---
myst:
  html_meta:
    keywords: LaTeX, programmation, syntaxe, registres
---

# Comment prendre la main sur un registre de liste d'unités lexicales ?

Manipuler un registre de liste d'unités lexicales utilisé par d'autres commandes 
peut parfois être nécessaire. Par exemple, lorsque vous voulez ajouter quelque chose 
à un tel registre du système (`\output` ou `\every*`), 
mais que vous savez que d'autres commandes utilisent également ce registre. 
C'est un cas fréquent avec `\everypar` 
car LaTeX change `\everypar` à chaque fois que l'on touche à quelque chose.

La technique suivante, due à David Kastrup, fait ce dont vous avez besoin, 
et permet à une autre extension d'obtenir un résultat identique :

```{noedit}
\let\monpkg@@everypar\everypar
\newtoks\monpkg@everypar
\monpkg@everypar\expandafter{\the\everypar}
\monpkg@@everypar{\monpkg@ajout\the\monpkg@everypar}
\def\monpkg@ajout{%
  ⟨choses à faire au début du registre⟩%
}
\let\everypar\monpkg@everypar
```

Comme vous pouvez le voir, ce code pour notre extension *monpkg* :

- crée un alias pour le registre système `\everypar` (figé dans n'importe quel environnement, 
  et continuant à utiliser l'original) ;
- crée un registre pour récupérer `\everypar` et l'initialise avec le contenu actuel de `\everypar` ;
- définit l'ancien `\everypar` pour qu'il exécute son propre code supplémentaire, 
  ainsi que le contenu de son propre registre de jetons ;
- définit la commande `\monpkg@ajout` pour le code supplémentaire ; et
- fait pointer le registre `\everypar` vers le nouveau registre.

Les noms de la forme `\monpkg@...` sont recommandés pour les noms internes des commandes des extensions LaTeX, 
c'est pourquoi cet exemple utilise des macros de cette forme.

:::{sources}
[Subverting a token register](faquk:FAQ-subverttoks)
:::