Using binary operators for dependencies
---------------------------------------

Not supported before 2.1:

  $ cat > dune-project <<EOF
  > (lang dune 2.0)
  > (name foo)
  > (generate_opam_files true)
  > (package
  >  (name foo)
  >  (depends (conf-libX11 (<> :os win32))))
  > EOF

  $ dune build @install
  File "dune-project", line 6, characters 23-37:
  6 |  (depends (conf-libX11 (<> :os win32))))
                             ^^^^^^^^^^^^^^
  Error: Passing two arguments to <> is only available since version 2.1 of the
  dune language. Please update your dune-project file to have (lang dune 2.1).
  [1]

Supported since 2.1:

  $ cat > dune-project <<EOF
  > (lang dune 2.1)
  > (name foo)
  > (generate_opam_files true)
  > (package
  >  (name foo)
  >  (depends (conf-libX11 (<> :os win32))))
  > EOF

  $ dune build @install
  $ grep conf-libX11 foo.opam
    "conf-libX11" {os != "win32"}


Using negation operator for dependencies
----------------------------------------

Not supported before 3.18:

  $ cat > dune-project <<EOF
  > (lang dune 3.17)
  > (generate_opam_files)
  > (package
  >   (name foo)
  >   (allow_empty)
  >   (depends
  >    (ocp-indent
  >     (not :with-test))))
  > EOF
  $ dune build
  File "dune-project", line 8, characters 4-20:
  8 |     (not :with-test))))
          ^^^^^^^^^^^^^^^^
  Error: Not operator is only available since version 3.18 of the dune
  language. Please update your dune-project file to have (lang dune 3.18).
  [1]

Supported since 3.18:

  $ cat > dune-project <<EOF
  > (lang dune 3.18)
  > (generate_opam_files)
  > (package
  >   (name foo)
  >   (allow_empty)
  >   (depends
  >    (ocp-indent
  >     (not
  >       (or
  >        (and
  >         (not :with-test)
  >         (>= 1.0))
  >        (not
  >         (and
  >          (not (= :os win32))
  >          (not (>= 1.5)))))))
  >    (not (>= 2.0))))
  > EOF
  $ dune build
  $ cat foo.opam
  # This file is generated by dune, edit dune-project instead
  opam-version: "2.0"
  depends: [
    "dune" {>= "3.18"}
    "ocp-indent" {!(!with-test & >= "1.0" | !(!os = "win32" & !>= "1.5"))}
    "not" {>= "2.0"}
    "odoc" {with-doc}
  ]
  build: [
    ["dune" "subst"] {dev}
    [
      "dune"
      "build"
      "-p"
      name
      "-j"
      jobs
      "@install"
      "@runtest" {with-test}
      "@doc" {with-doc}
    ]
  ]
  x-maintenance-intent: ["(latest)"]
