/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import sharpen.core.Configuration;

public class VODConfiguration
extends Configuration {
    VODConfiguration(String runtimeTypeName) {
        super(runtimeTypeName);
        this.setUpPrimitiveMappings();
        this.setUpAnnotationMappings();
        this.mapType("java.lang.System", runtimeTypeName);
        this.mapMethod("java.lang.Math.abs", "System.Math.Abs");
        this.mapMethod("java.lang.Math.min", "System.Math.Min");
        this.mapMethod("java.lang.Math.max", "System.Math.Max");
        this.mapMethod("java.lang.System.exit", "System.Environment.Exit");
        this.mapType("java.lang.Cast", "Sharpen.Cast");
        this.setUpIoMappings();
        this.mapMethod("System.IO.TextWriter.flush", "Flush");
        this.mapMethod("System.IO.TextWriter.print", "Write");
        this.mapMethod("System.IO.TextWriter.println", "WriteLine");
        this.setUpExceptionMappings();
        this.mapType("java.lang.Comparable", "System.IComparable");
        this.mapMethod("java.lang.Comparable.compareTo", "CompareTo");
        this.mapMethod("java.lang.Object.toString", "ToString");
        this.mapMethod("java.lang.Object.hashCode", "GetHashCode");
        this.mapMethod("java.lang.Object.equals", "Equals");
        this.mapMethod("java.lang.Float.isNaN", "float.IsNaN");
        this.mapMethod("java.lang.Double.isNaN", "double.IsNaN");
        this.setUpStringMappings();
        this.mapMethod("java.lang.Throwable.printStackTrace", this.runtimeMethod("printStackTrace"));
        this.mapMethod("java.lang.System.arraycopy", "System.Array.Copy");
        this.mapMethod("java.lang.Object.wait", this.runtimeMethod("wait"));
        this.mapMethod("java.lang.Object.notify", this.runtimeMethod("notify"));
        this.mapMethod("java.lang.Object.notifyAll", this.runtimeMethod("notifyAll"));
        this.mapMethod("java.lang.Object.getClass", this.runtimeMethod("getClassForObject"));
        this.mapMethod("length", "Length");
        this.mapType("java.util.Map.Entry", "java.util.MapEntry");
        this.mapType("Versant.Persistence.RT.VersantSocketChannel", "java.nio.channels.SocketChannel");
    }

    private void setUpPrimitiveMappings() {
        this.mapType("boolean", "bool");
        this.mapPrimitive("void");
        this.mapPrimitive("char");
        this.mapType("byte", "sbyte");
        this.mapType("java.lang.ubyte", "byte");
        this.mapPrimitive("short");
        this.mapPrimitive("int");
        this.mapPrimitive("long");
        this.mapPrimitive("float");
        this.mapPrimitive("double");
        this.mapType("java.lang.Object", "object");
        this.mapType("java.lang.String", "string");
    }

    private void setUpExceptionMappings() {
        this.mapType("java.lang.Throwable", "System.Exception");
        this.mapProperty("java.lang.Throwable.getMessage", "Message");
        this.mapProperty("java.lang.Throwable.getCause", "InnerException");
        this.mapType("java.lang.Error", "System.Exception");
        this.mapType("java.lang.OutOfMemoryError", "System.OutOfMemoryException");
        this.mapType("java.lang.Exception", "System.Exception");
        this.mapType("java.lang.RuntimeException", "System.Exception");
        this.mapType("java.lang.ClassCastException", "System.InvalidCastException");
        this.mapType("java.lang.NullPointerException", "System.ArgumentNullException");
        this.mapType("java.lang.IllegalArgumentException", "System.ArgumentException");
        this.mapType("java.lang.IllegalStateException", "System.InvalidOperationException");
        this.mapType("java.lang.IndexOutOfBoundsException", "System.IndexOutOfRangeException");
        this.mapType("java.lang.UnsupportedOperationException", "System.NotSupportedException");
        this.mapType("java.lang.ArrayIndexOutOfBoundsException", "System.IndexOutOfRangeException");
        this.mapType("java.lang.NoSuchMethodError", "System.MissingMethodException");
        this.mapType("java.io.IOException", "System.IO.IOException");
        this.mapType("java.net.SocketException", "System.Net.Sockets.SocketException");
        this.mapType("java.lang.SecurityException", "System.Security.SecurityException");
        this.mapType("java.lang.NumberFormatException", "System.SystemException");
        this.mapType("java.lang.NoSuchFieldException", "System.MissingFieldException");
        this.mapType("java.rmi.NoSuchObjectException", "System.InvalidOperationException");
        this.mapType("java.util.NoSuchElementException", "System.InvalidOperationException");
        this.mapType("java.lang.NoSuchMethodException", "System.MissingMethodException");
        this.mapType("java.lang.reflect.InvocationTargetException", "System.Reflection.TargetInvocationException");
        this.mapType("java.lang.IllegalAccessException", "System.MethodAccessException");
        this.mapType("java.io.FileNotFoundException", "System.IO.FileNotFoundException");
        this.mapType("java.io.StreamCorruptedException", "System.IO.IOException");
        this.mapType("java.io.UTFDataFormatException", "System.IO.IOException");
        this.mapType("java.io.InvalidObjectException", "System.Runtime.Serialization.InvalidDataContractException");
        this.mapType("java.util.ConcurrentModificationException", "System.InvalidOperationException");
        this.mapType("java.lang.InstantiationException", "System.MissingMethodException");
    }

    @Override
    public boolean isIgnoredExceptionType(String exceptionType) {
        return exceptionType.equals("java.lang.CloneNotSupportedException") || exceptionType.equals("java.lang.InterruptedException");
    }

    @Override
    public boolean mapProtectedToProtectedInternal() {
        return true;
    }

    @Override
    public boolean mapByteToSbyte() {
        return true;
    }
}

