/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FamilyScanner_H
#define FamilyScanner_H

#include "Language.h"
#include "Parameter.h"

class FamilyScanner : public ParameterScanner, public LanguageScanner 
{
public:
	const string& keyword() const;
	bool validate(Request&) const;
	const vector<string>& params() const;
	const vector<string>& values(const string&) ;//const;
	const vector<string>& beau(const string&) ;//const;

	static FamilyScanner& find(const IconClass&);

protected:
	FamilyScanner(const IconClass&);
	virtual ~FamilyScanner();

private:
	FamilyScanner(const FamilyScanner&);
	FamilyScanner& operator=(const FamilyScanner&);

	string                      keyword_;
	map<string,string>	    names_;
	const IconClass&            class_;
	vector<string>              params_;
	map<string,vector<string> > values_;
	map<string,vector<string> > beau_;

	// From LanguageScanner
	virtual void next(const Parameter&);

	// From ParameterScanner
	virtual void next(const Parameter&, const char*,const char*);
};

inline void destroy(FamilyScanner**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FamilyScanner);
//#endif

#endif
