C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5L (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 14, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5L                                       
C       PARAMETER (ISET=3) 
        DATA  DrI, FlI, AlI /   1.,   5.,  .1460 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C
C        DATA  NXI,  NTI, NfMxI /    90,    14,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .168633E+01, .225626E+01, .312523E+01,
     +  .450000E+01, .726804E+01, .125527E+02, .234016E+02, .475972E+02,
     +  .106914E+03, .268929E+03, .769591E+03, .255116E+04, .100000E+05/
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C
C Parton Distribution Table:                                                
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .248351E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .134945E+06, .101967E+06,
     +  .757145E+05, .561861E+05, .416622E+05, .308678E+05,
     +  .228511E+05, .169017E+05, .124900E+05, .922112E+04,
     +  .680115E+04, .501115E+04, .368836E+04, .271174E+04,
     +  .199143E+04, .146069E+04, .107007E+04, .782889E+03,
     +  .572010E+03, .417344E+03, .304057E+03, .221186E+03,
     +  .160653E+03, .116496E+03, .843388E+02, .609540E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .439839E+02, .315377E+02, .226849E+02, .162912E+02,
     +  .116822E+02, .836576E+01, .598368E+01, .428027E+01,
     +  .305762E+01, .218423E+01, .156110E+01, .111690E+01,
     +  .800401E+00, .574769E+00, .414042E+00, .299196E+00,
     +  .217011E+00, .158036E+00, .115578E+00, .848915E-01,
     +  .626969E-01, .464105E-01, .345541E-01, .257735E-01,
     +  .193072E-01, .145036E-01, .109203E-01, .823684E-02,
     +  .622016E-02, .469996E-02, .355109E-02, .268108E-02,
     +  .202127E-02, .152037E-02, .113995E-02, .851110E-03,
     +  .631881E-03, .466475E-03, .340652E-03, .245914E-03,
     +  .174888E-03, .121939E-03, .827573E-04, .540432E-04,
     +  .332611E-04, .184728E-04, .822215E-05, .130856E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .310696E+06, .234107E+06, .173251E+06,
     +  .128130E+06, .946820E+05, .699059E+05, .515675E+05,
     +  .380049E+05, .279826E+05, .205828E+05, .151242E+05,
     +  .111013E+05, .813930E+04, .596066E+04, .435989E+04,
     +  .318498E+04, .232363E+04, .169289E+04, .123162E+04,
     +  .894699E+03, .648954E+03, .469952E+03, .339770E+03,
     +  .245226E+03, .176686E+03, .127068E+03, .912342E+02,
     +  .650794E+02, .465676E+02, .332647E+02, .237238E+02,
     +  .168946E+02, .120152E+02, .854500E+01, .606795E+01,
     +  .430848E+01, .306037E+01, .217586E+01, .154939E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .110545E+01, .791150E+00, .567949E+00, .409216E+00,
     +  .296023E+00, .215049E+00, .156889E+00, .115094E+00,
     +  .846174E-01, .625737E-01, .463531E-01, .344851E-01,
     +  .257261E-01, .192350E-01, .144063E-01, .108019E-01,
     +  .810369E-02, .607896E-02, .455688E-02, .341125E-02,
     +  .254841E-02, .189850E-02, .140928E-02, .104132E-02,
     +  .766324E-03, .559216E-03, .404881E-03, .290391E-03,
     +  .205932E-03, .144056E-03, .991012E-04, .667725E-04,
     +  .438145E-04, .277559E-04, .167188E-04, .939014E-05,
     +  .461058E-05, .166059E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .533926E+06, .401143E+06, .295846E+06, .218034E+06,
     +  .160549E+06, .118114E+06, .868148E+05, .637477E+05,
     +  .467628E+05, .342676E+05, .250839E+05, .183408E+05,
     +  .133946E+05, .977040E+04, .711776E+04, .517840E+04,
     +  .376230E+04, .272950E+04, .197729E+04, .143013E+04,
     +  .103274E+04, .744513E+03, .535813E+03, .384915E+03,
     +  .276017E+03, .197537E+03, .141132E+03, .100159E+03,
     +  .713008E+02, .506657E+02, .359407E+02, .254551E+02,
     +  .180025E+02, .127304E+02, .898766E+01, .634389E+01,
     +  .447908E+01, .316509E+01, .223984E+01, .158806E+01,
     +  .112935E+01, .805553E+00, .576680E+00, .414467E+00,
     +  .299142E+00, .216817E+00, .158027E+00, .115419E+00,
     +  .847960E-01, .624032E-01, .461222E-01, .341820E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .253897E-01, .188908E-01, .140710E-01, .104863E-01,
     +  .781422E-02, .581897E-02, .432744E-02, .321192E-02,
     +  .237768E-02, .175434E-02, .128897E-02, .943863E-03,
     +  .686002E-03, .495397E-03, .355155E-03, .252539E-03,
     +  .177951E-03, .124153E-03, .857007E-04, .585016E-04,
     +  .394701E-04, .263197E-04, .174460E-04, .114615E-04,
     +  .752457E-05, .497350E-05, .333957E-05, .229551E-05,
     +  .162410E-05, .117516E-05, .856929E-06, .618317E-06,
     +  .429305E-06, .277317E-06, .159021E-06, .747695E-07,
     +  .233396E-07, .219712E-08, .000000E+00, .811487E+06,
     +  .607881E+06, .446744E+06, .328077E+06, .240714E+06,
     +  .176449E+06, .129216E+06, .945307E+05, .690839E+05,
     +  .504322E+05, .367746E+05, .267841E+05, .194839E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .141554E+05, .102705E+05, .744153E+04, .538409E+04,
     +  .388963E+04, .280566E+04, .202047E+04, .145262E+04,
     +  .104252E+04, .746870E+03, .534051E+03, .381160E+03,
     +  .271470E+03, .193010E+03, .136286E+03, .965289E+02,
     +  .682394E+02, .481527E+02, .339219E+02, .238595E+02,
     +  .167785E+02, .117786E+02, .826591E+01, .580193E+01,
     +  .407548E+01, .286673E+01, .202012E+01, .142777E+01,
     +  .101209E+01, .720011E+00, .514233E+00, .368817E+00,
     +  .265628E+00, .192387E+00, .139625E+00, .101934E+00,
     +  .745412E-01, .547465E-01, .403182E-01, .297589E-01,
     +  .220022E-01, .162852E-01, .120600E-01, .893033E-02,
     +  .660835E-02, .488382E-02, .360253E-02, .265072E-02,
     +  .194440E-02, .142068E-02, .103504E-02, .748935E-03 /
        DATA (UPDI(I),I=885,936) /
     +  .538982E-03, .385619E-03, .274200E-03, .193767E-03,
     +  .136115E-03, .951251E-04, .662299E-04, .460257E-04,
     +  .320147E-04, .224596E-04, .158790E-04, .113894E-04,
     +  .830728E-05, .615756E-05, .461773E-05, .347917E-05,
     +  .260225E-05, .190363E-05, .134363E-05, .895497E-06,
     +  .547879E-06, .294528E-06, .128290E-06, .370397E-07,
     +  .356944E-08, .000000E+00, .115005E+07, .858944E+06,
     +  .629021E+06, .460285E+06, .336496E+06, .245760E+06,
     +  .179309E+06, .130689E+06, .951489E+05, .691954E+05,
     +  .502622E+05, .364649E+05, .264216E+05, .191191E+05,
     +  .138160E+05, .996946E+04, .718323E+04, .516761E+04,
     +  .371164E+04, .266138E+04, .190504E+04, .136114E+04,
     +  .970748E+03, .690959E+03, .490857E+03, .347938E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .246190E+03, .172976E+03, .121907E+03, .857443E+02,
     +  .601935E+02, .421822E+02, .295110E+02, .206403E+02,
     +  .144094E+02, .100553E+02, .701765E+01, .490090E+01,
     +  .342713E+01, .240070E+01, .168660E+01, .118836E+01,
     +  .840282E+00, .596476E+00, .425196E+00, .304358E+00,
     +  .219097E+00, .158033E+00, .114672E+00, .833431E-01,
     +  .608386E-01, .445326E-01, .326701E-01, .240081E-01,
     +  .176624E-01, .130008E-01, .956893E-02, .703841E-02,
     +  .517068E-02, .379171E-02, .277386E-02, .202344E-02,
     +  .147059E-02, .106618E-02, .768146E-03, .550889E-03,
     +  .393238E-03, .279437E-03, .197783E-03, .139573E-03,
     +  .983682E-04, .693969E-04, .491457E-04, .350492E-04,
     +  .253463E-04, .185504E-04, .137888E-04, .103952E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .791407E-05, .604302E-05, .458881E-05, .342705E-05,
     +  .248232E-05, .172280E-05, .112232E-05, .667550E-06,
     +  .346860E-06, .144807E-06, .399023E-07, .389994E-08,
     +  .000000E+00, .155596E+07, .115866E+07, .845497E+06,
     +  .616477E+06, .449054E+06, .326770E+06, .237537E+06,
     +  .172483E+06, .125105E+06, .906351E+05, .655828E+05,
     +  .473952E+05, .342067E+05, .246543E+05, .177444E+05,
     +  .127521E+05, .915046E+04, .655544E+04, .468863E+04,
     +  .334757E+04, .238586E+04, .169721E+04, .120505E+04,
     +  .853857E+03, .603803E+03, .425997E+03, .300000E+03,
     +  .209758E+03, .147110E+03, .102958E+03, .719133E+02,
     +  .501370E+02, .348931E+02, .242755E+02, .168557E+02,
     +  .116980E+02, .811866E+01, .563783E+01, .391997E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .273009E+01, .190687E+01, .133568E+01, .938893E+00,
     +  .662535E+00, .469493E+00, .334070E+00, .239068E+00,
     +  .171411E+00, .123646E+00, .893341E-01, .648282E-01,
     +  .471743E-01, .344053E-01, .251354E-01, .183838E-01,
     +  .134531E-01, .984450E-02, .719944E-02, .525885E-02,
     +  .383473E-02, .278998E-02, .202449E-02, .146399E-02,
     +  .105653E-02, .758122E-03, .541941E-03, .386023E-03,
     +  .274128E-03, .194273E-03, .137612E-03, .976446E-04,
     +  .695918E-04, .499728E-04, .362563E-04, .267291E-04,
     +  .199557E-04, .151070E-04, .115562E-04, .888107E-05,
     +  .680614E-05, .515612E-05, .382218E-05, .273527E-05,
     +  .186809E-05, .119304E-05, .692944E-06, .349926E-06,
     +  .140978E-06, .373606E-07, .369593E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .203504E+07, .151095E+07, .109867E+07, .798222E+06,
     +  .579351E+06, .420054E+06, .304229E+06, .220094E+06,
     +  .159042E+06, .114786E+06, .827421E+05, .595656E+05,
     +  .428233E+05, .307433E+05, .220389E+05, .157748E+05,
     +  .112734E+05, .804310E+04, .572871E+04, .407293E+04,
     +  .289045E+04, .204727E+04, .144724E+04, .102091E+04,
     +  .718684E+03, .504720E+03, .353793E+03, .246190E+03,
     +  .171835E+03, .119679E+03, .831804E+02, .577019E+02,
     +  .399532E+02, .276522E+02, .190994E+02, .131843E+02,
     +  .910061E+01, .628504E+01, .434572E+01, .300962E+01,
     +  .209023E+01, .145579E+01, .101746E+01, .713857E+00,
     +  .502956E+00, .355818E+00, .253174E+00, .180478E+00,
     +  .129443E+00, .929855E-01, .670934E-01, .485450E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .352043E-01, .255738E-01, .185991E-01, .135343E-01,
     +  .984869E-02, .716269E-02, .520344E-02, .377401E-02,
     +  .273151E-02, .197220E-02, .141946E-02, .102003E-02,
     +  .729210E-03, .519753E-03, .369532E-03, .262295E-03,
     +  .186129E-03, .132299E-03, .944292E-04, .678719E-04,
     +  .492732E-04, .362036E-04, .270429E-04, .204407E-04,
     +  .156291E-04, .120327E-04, .926833E-05, .708902E-05,
     +  .533756E-05, .391890E-05, .276862E-05, .186123E-05,
     +  .116651E-05, .662697E-06, .325910E-06, .127077E-06,
     +  .325164E-07, .325291E-08, .000000E+00, .259249E+07,
     +  .191923E+07, .139067E+07, .100680E+07, .728131E+06,
     +  .526029E+06, .379600E+06, .273615E+06, .196986E+06,
     +  .141641E+06, .101715E+06, .729457E+05, .522410E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .373587E+05, .266762E+05, .190183E+05, .135369E+05,
     +  .961883E+04, .682295E+04, .483077E+04, .341389E+04,
     +  .240774E+04, .169473E+04, .119028E+04, .834209E+03,
     +  .583211E+03, .406958E+03, .281860E+03, .195813E+03,
     +  .135732E+03, .938827E+02, .648074E+02, .446498E+02,
     +  .307470E+02, .211280E+02, .145087E+02, .996198E+01,
     +  .684316E+01, .470607E+01, .324140E+01, .223883E+01,
     +  .155065E+01, .107774E+01, .751929E+00, .526824E+00,
     +  .370616E+00, .262238E+00, .185891E+00, .132586E+00,
     +  .947136E-01, .679624E-01, .489028E-01, .352689E-01,
     +  .254805E-01, .184303E-01, .133388E-01, .965421E-02,
     +  .698390E-02, .504698E-02, .364177E-02, .262274E-02,
     +  .188475E-02, .135054E-02, .966664E-03, .688729E-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .489636E-03, .347589E-03, .246672E-03, .175294E-03,
     +  .125011E-03, .897038E-04, .649446E-04, .475667E-04,
     +  .352855E-04, .265994E-04, .202608E-04, .155716E-04,
     +  .120119E-04, .923874E-05, .703260E-05, .525295E-05,
     +  .381599E-05, .266048E-05, .176076E-05, .108356E-05,
     +  .602585E-06, .288922E-06, .109220E-06, .270582E-07,
     +  .273585E-08, .000000E+00, .323277E+07, .238636E+07,
     +  .172316E+07, .124316E+07, .895905E+06, .644936E+06,
     +  .463740E+06, .333054E+06, .238904E+06, .171149E+06,
     +  .122449E+06, .874851E+05, .624161E+05, .444643E+05,
     +  .316272E+05, .224599E+05, .159235E+05, .112695E+05,
     +  .796162E+04, .561397E+04, .395101E+04, .277492E+04,
     +  .194493E+04, .136016E+04, .949135E+03, .660628E+03 /
        DATA (UPDI(I),I=1301,1352) /
     +  .458929E+03, .316401E+03, .218804E+03, .150964E+03,
     +  .103927E+03, .713983E+02, .489518E+02, .335438E+02,
     +  .229345E+02, .156694E+02, .107036E+02, .731437E+01,
     +  .500369E+01, .342809E+01, .235512E+01, .162241E+01,
     +  .112152E+01, .778228E+00, .542292E+00, .379422E+00,
     +  .267017E+00, .188248E+00, .133544E+00, .948818E-01,
     +  .677174E-01, .484656E-01, .347673E-01, .249847E-01,
     +  .179762E-01, .129420E-01, .931830E-02, .670632E-02,
     +  .482197E-02, .346235E-02, .248176E-02, .177550E-02,
     +  .126699E-02, .903558E-03, .641805E-03, .455257E-03,
     +  .322797E-03, .229096E-03, .163061E-03, .116663E-03,
     +  .841222E-04, .612865E-04, .452115E-04, .337820E-04,
     +  .256267E-04, .196085E-04, .151009E-04, .116392E-04 /
        DATA (UPDI(I),I=1353,1404) /
     +  .891886E-05, .674546E-05, .499315E-05, .358685E-05,
     +  .246739E-05, .160779E-05, .971833E-06, .529321E-06,
     +  .247613E-06, .908655E-07, .218428E-07, .223125E-08,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .473739E+05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1509,1560) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .305524E+05,
     +  .235130E+05, .178397E+05, .135324E+05, .102619E+05,
     +  .777928E+04, .589527E+04, .446593E+04, .338187E+04,
     +  .255994E+04, .193697E+04, .146495E+04, .110746E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .836795E+03, .631962E+03, .477014E+03, .359857E+03,
     +  .271314E+03, .204432E+03, .153938E+03, .115839E+03,
     +  .871084E+02, .654568E+02, .491500E+02, .368777E+02,
     +  .276475E+02, .207126E+02, .154417E+02, .115524E+02,
     +  .863674E+01, .645292E+01, .481879E+01, .359707E+01,
     +  .268693E+01, .200584E+01, .149819E+01, .112003E+01,
     +  .838423E+00, .628737E+00, .472479E+00, .356112E+00,
     +  .269188E+00, .204168E+00, .155411E+00, .118743E+00,
     +  .910698E-01, .701797E-01, .541886E-01, .420491E-01,
     +  .326795E-01, .254911E-01, .199307E-01, .156134E-01,
     +  .122492E-01, .961930E-02, .755755E-02, .593737E-02,
     +  .466175E-02, .365594E-02, .286212E-02, .223520E-02,
     +  .174023E-02, .134940E-02, .104247E-02, .799292E-03 /
        DATA (UPDI(I),I=1613,1664) /
     +  .608375E-03, .458946E-03, .342432E-03, .252040E-03,
     +  .182336E-03, .129018E-03, .885379E-04, .583503E-04,
     +  .360231E-04, .200365E-04, .875212E-05, .116498E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .754602E+05, .579070E+05,
     +  .437869E+05, .331001E+05, .250117E+05, .188918E+05,
     +  .142632E+05, .107637E+05, .811900E+04, .612103E+04,
     +  .461233E+04, .347358E+04, .261449E+04, .196669E+04,
     +  .147846E+04, .111071E+04, .833857E+03, .625560E+03,
     +  .468945E+03, .351263E+03, .262902E+03, .196600E+03,
     +  .146892E+03, .109651E+03, .817778E+02, .609294E+02 /
        DATA (UPDI(I),I=1665,1716) /
     +  .453572E+02, .335917E+02, .249637E+02, .185359E+02,
     +  .137525E+02, .101967E+02, .755626E+01, .560278E+01,
     +  .415122E+01, .307706E+01, .228274E+01, .169561E+01,
     +  .126169E+01, .940764E+00, .703567E+00, .527720E+00,
     +  .397174E+00, .300013E+00, .227488E+00, .173155E+00,
     +  .132442E+00, .101500E+00, .781812E-01, .603119E-01,
     +  .467000E-01, .362456E-01, .281858E-01, .219499E-01,
     +  .171098E-01, .133428E-01, .104043E-01, .810795E-02,
     +  .631119E-02, .490427E-02, .380231E-02, .293953E-02,
     +  .226425E-02, .173882E-02, .132652E-02, .100607E-02,
     +  .757850E-03, .566386E-03, .419444E-03, .307351E-03,
     +  .222448E-03, .158686E-03, .111277E-03, .763733E-04,
     +  .512791E-04, .332745E-04, .207273E-04, .122069E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .661374E-05, .310435E-05, .103955E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .138080E+06, .105639E+06, .795961E+05,
     +  .599516E+05, .451341E+05, .339621E+05, .255424E+05,
     +  .191998E+05, .144241E+05, .108300E+05, .812643E+04,
     +  .609390E+04, .456670E+04, .341984E+04, .255914E+04,
     +  .191360E+04, .142977E+04, .106737E+04, .796150E+03,
     +  .593307E+03, .441735E+03, .328563E+03, .244144E+03,
     +  .181225E+03, .134381E+03, .995305E+02, .736469E+02,
     +  .542027E+02, .400272E+02, .295297E+02, .217654E+02,
     +  .160299E+02, .117979E+02, .868734E+01, .639135E+01,
     +  .470378E+01, .346442E+01, .255468E+01, .188706E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .139677E+01, .103696E+01, .772105E+00, .576875E+00,
     +  .432598E+00, .325664E+00, .246109E+00, .186913E+00,
     +  .142233E+00, .108792E+00, .833415E-01, .640863E-01,
     +  .493975E-01, .381496E-01, .295058E-01, .228421E-01,
     +  .176911E-01, .137003E-01, .106033E-01, .819699E-02,
     +  .632612E-02, .487137E-02, .374076E-02, .286245E-02,
     +  .218430E-02, .165635E-02, .124935E-02, .936706E-03,
     +  .697579E-03, .515621E-03, .377996E-03, .274612E-03,
     +  .197608E-03, .140688E-03, .990165E-04, .691233E-04,
     +  .476194E-04, .324830E-04, .219712E-04, .147779E-04,
     +  .990469E-05, .665452E-05, .448629E-05, .302705E-05,
     +  .203786E-05, .134621E-05, .850531E-06, .491478E-06,
     +  .243367E-06, .847208E-07, .769627E-08, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .205645E+06, .169349E+06, .127135E+06, .954023E+05,
     +  .715519E+05, .536340E+05, .401798E+05, .300824E+05,
     +  .225084E+05, .168302E+05, .125758E+05, .939018E+04,
     +  .700629E+04, .522351E+04, .389122E+04, .289626E+04,
     +  .215382E+04, .160021E+04, .118777E+04, .880741E+03,
     +  .652409E+03, .482745E+03, .356813E+03, .263425E+03,
     +  .194255E+03, .143063E+03, .105250E+03, .770007E+02,
     +  .565223E+02, .414441E+02, .303568E+02, .222156E+02,
     +  .162450E+02, .118837E+02, .868474E+01, .634856E+01,
     +  .464400E+01, .340101E+01, .249488E+01, .183386E+01,
     +  .135202E+01, .999714E+00, .741768E+00, .552421E+00,
     +  .413023E+00, .309999E+00, .233852E+00, .176750E+00,
     +  .134296E+00, .102195E+00, .780660E-01, .597785E-01 /
        DATA (UPDI(I),I=1873,1924) /
     +  .458652E-01, .352421E-01, .271055E-01, .208566E-01,
     +  .160468E-01, .123387E-01, .947667E-02, .726636E-02,
     +  .555932E-02, .424179E-02, .322532E-02, .244607E-02,
     +  .184380E-02, .138292E-02, .103154E-02, .764816E-03,
     +  .563406E-03, .412216E-03, .299486E-03, .216106E-03,
     +  .154845E-03, .110225E-03, .783097E-04, .553453E-04,
     +  .390976E-04, .276747E-04, .196774E-04, .140577E-04,
     +  .101029E-04, .726267E-05, .517312E-05, .361546E-05,
     +  .243053E-05, .153032E-05, .864796E-06, .409370E-06,
     +  .133273E-06, .123829E-07, .000000E+00, .351606E+06,
     +  .267190E+06, .199732E+06, .149233E+06, .111434E+06,
     +  .831576E+05, .620158E+05, .462178E+05, .344200E+05,
     +  .256150E+05, .190479E+05, .141532E+05, .105076E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .779432E+04, .577649E+04, .427701E+04, .316370E+04,
     +  .233779E+04, .172569E+04, .127243E+04, .937171E+03,
     +  .689415E+03, .506550E+03, .371710E+03, .272418E+03,
     +  .199364E+03, .145732E+03, .105911E+03, .772278E+02,
     +  .562427E+02, .409125E+02, .297305E+02, .215849E+02,
     +  .156759E+02, .113719E+02, .825101E+01, .599023E+01,
     +  .435362E+01, .316930E+01, .231171E+01, .169122E+01,
     +  .124092E+01, .913674E+00, .675244E+00, .501018E+00,
     +  .373199E+00, .279426E+00, .209617E+00, .158097E+00,
     +  .119424E+00, .905649E-01, .688499E-01, .524473E-01,
     +  .400128E-01, .305565E-01, .233454E-01, .178343E-01,
     +  .136153E-01, .103817E-01, .790188E-02, .600003E-02,
     +  .454245E-02, .342560E-02, .257535E-02, .192279E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .142698E-02, .105172E-02, .769022E-03, .557249E-03,
     +  .399651E-03, .283275E-03, .198135E-03, .136482E-03,
     +  .922992E-04, .613874E-04, .397952E-04, .251301E-04,
     +  .153965E-04, .911477E-05, .518916E-05, .283999E-05,
     +  .150112E-05, .777804E-06, .415009E-06, .240654E-06,
     +  .153963E-06, .100556E-06, .596073E-07, .244100E-07,
     +  .209883E-08, .000000E+00, .522093E+06, .395295E+06,
     +  .294221E+06, .218873E+06, .162714E+06, .120881E+06,
     +  .897400E+05, .665720E+05, .493474E+05, .365503E+05,
     +  .270494E+05, .200009E+05, .147759E+05, .109056E+05,
     +  .804128E+04, .592322E+04, .435849E+04, .320357E+04,
     +  .235202E+04, .172475E+04, .126324E+04, .924019E+03,
     +  .675019E+03, .492431E+03, .358743E+03, .260942E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .189569E+03, .136895E+03, .991834E+02, .717639E+02,
     +  .518587E+02, .374325E+02, .269916E+02, .194673E+02,
     +  .140234E+02, .101027E+02, .728202E+01, .525422E+01,
     +  .379709E+01, .274938E+01, .199668E+01, .145430E+01,
     +  .106294E+01, .779811E+00, .574393E+00, .424746E+00,
     +  .315736E+00, .235148E+00, .176091E+00, .132067E+00,
     +  .994452E-01, .750683E-01, .567823E-01, .430161E-01,
     +  .326196E-01, .247468E-01, .187720E-01, .142304E-01,
     +  .107742E-01, .814285E-02, .613945E-02, .461544E-02,
     +  .345636E-02, .258071E-02, .191390E-02, .141130E-02,
     +  .103399E-02, .752084E-03, .542664E-03, .388113E-03,
     +  .274928E-03, .192768E-03, .133694E-03, .916135E-04,
     +  .622848E-04, .418054E-04, .278224E-04, .184086E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .121557E-04, .804428E-05, .536358E-05, .360701E-05,
     +  .243289E-05, .163366E-05, .106903E-05, .661101E-06,
     +  .368607E-06, .171281E-06, .537434E-07, .502453E-08,
     +  .000000E+00, .740175E+06, .558386E+06, .413836E+06,
     +  .306526E+06, .226880E+06, .167805E+06, .124017E+06,
     +  .915829E+05, .675754E+05, .498185E+05, .366951E+05,
     +  .270037E+05, .198528E+05, .145809E+05, .106979E+05,
     +  .784043E+04, .573979E+04, .419700E+04, .306521E+04,
     +  .223576E+04, .162866E+04, .118477E+04, .860677E+03,
     +  .624312E+03, .452202E+03, .326991E+03, .236143E+03,
     +  .169483E+03, .122041E+03, .877523E+02, .630109E+02,
     +  .451901E+02, .323726E+02, .231940E+02, .165958E+02,
     +  .118747E+02, .850051E+01, .609093E+01, .437108E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .314280E+01, .226636E+01, .163910E+01, .118957E+01,
     +  .866581E+00, .633838E+00, .465427E+00, .343583E+00,
     +  .254110E+00, .188986E+00, .140765E+00, .105273E+00,
     +  .789278E-01, .592976E-01, .446182E-01, .336062E-01,
     +  .253234E-01, .190798E-01, .143661E-01, .108036E-01,
     +  .811001E-02, .607360E-02, .453549E-02, .337399E-02,
     +  .250291E-02, .184449E-02, .135195E-02, .985015E-03,
     +  .712974E-03, .512445E-03, .365586E-03, .258838E-03,
     +  .181887E-03, .126901E-03, .879209E-04, .608237E-04,
     +  .418860E-04, .288752E-04, .199923E-04, .139406E-04,
     +  .980027E-05, .694069E-05, .492182E-05, .345319E-05,
     +  .236865E-05, .155356E-05, .946064E-06, .511420E-06,
     +  .226456E-06, .669277E-07, .638510E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .101270E+07, .761267E+06, .561821E+06, .414368E+06,
     +  .305382E+06, .224884E+06, .165470E+06, .121651E+06,
     +  .893569E+05, .655761E+05, .480789E+05, .352157E+05,
     +  .257678E+05, .188346E+05, .137518E+05, .100291E+05,
     +  .730558E+04, .531499E+04, .386189E+04, .280226E+04,
     +  .203061E+04, .146930E+04, .106161E+04, .765835E+03,
     +  .551622E+03, .396619E+03, .284783E+03, .203185E+03,
     +  .145445E+03, .103952E+03, .741885E+02, .528774E+02,
     +  .376415E+02, .267977E+02, .190507E+02, .135422E+02,
     +  .963030E+01, .685454E+01, .488612E+01, .348942E+01,
     +  .249931E+01, .179533E+01, .129412E+01, .936363E+00,
     +  .680257E+00, .496146E+00, .363816E+00, .267271E+00,
     +  .197459E+00, .146101E+00, .108545E+00, .808479E-01 /
        DATA (UPDI(I),I=2237,2288) /
     +  .603435E-01, .451094E-01, .337552E-01, .252704E-01,
     +  .189164E-01, .141507E-01, .105728E-01, .788549E-02,
     +  .586756E-02, .435382E-02, .321851E-02, .237300E-02,
     +  .173842E-02, .126711E-02, .918519E-03, .661939E-03,
     +  .474161E-03, .337601E-03, .239001E-03, .168351E-03,
     +  .118127E-03, .826464E-04, .580096E-04, .407491E-04,
     +  .288011E-04, .205256E-04, .147568E-04, .106823E-04,
     +  .775180E-05, .559092E-05, .395419E-05, .270868E-05,
     +  .175855E-05, .105135E-05, .553502E-06, .236215E-06,
     +  .668382E-07, .646598E-08, .000000E+00, .134635E+07,
     +  .100856E+07, .741249E+06, .544423E+06, .399539E+06,
     +  .292968E+06, .214638E+06, .157110E+06, .114895E+06,
     +  .839417E+05, .612668E+05, .446706E+05, .325353E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .236702E+05, .172008E+05, .124844E+05, .905006E+04,
     +  .655185E+04, .473695E+04, .341992E+04, .246555E+04,
     +  .177478E+04, .127561E+04, .915322E+03, .655740E+03,
     +  .468892E+03, .334811E+03, .237515E+03, .169048E+03,
     +  .120122E+03, .852246E+02, .603811E+02, .427230E+02,
     +  .302292E+02, .213567E+02, .150860E+02, .106600E+02,
     +  .753881E+01, .533921E+01, .378822E+01, .269565E+01,
     +  .192371E+01, .137760E+01, .990251E+00, .714721E+00,
     +  .517889E+00, .377312E+00, .275391E+00, .202156E+00,
     +  .148619E+00, .109713E+00, .812008E-01, .602244E-01,
     +  .447371E-01, .332664E-01, .247484E-01, .184098E-01,
     +  .136858E-01, .101618E-01, .753209E-02, .557023E-02,
     +  .410821E-02, .301887E-02, .221302E-02, .161228E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .116913E-02, .843592E-03, .605602E-03, .432583E-03,
     +  .307559E-03, .217821E-03, .153849E-03, .108560E-03,
     +  .766359E-04, .544617E-04, .388663E-04, .279773E-04,
     +  .203260E-04, .148813E-04, .109364E-04, .801608E-05,
     +  .580586E-05, .409788E-05, .278454E-05, .178302E-05,
     +  .104555E-05, .536654E-06, .221426E-06, .602784E-07,
     +  .590321E-08, .000000E+00, .174745E+07, .130458E+07,
     +  .954940E+06, .698512E+06, .510509E+06, .372778E+06,
     +  .271960E+06, .198221E+06, .144336E+06, .104993E+06,
     +  .762946E+05, .553803E+05, .401542E+05, .290802E+05,
     +  .210350E+05, .151962E+05, .109639E+05, .789956E+04,
     +  .568376E+04, .408342E+04, .292932E+04, .209804E+04,
     +  .150028E+04, .107099E+04, .763251E+03, .542866E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .385553E+03, .272001E+03, .192525E+03, .136038E+03,
     +  .959687E+02, .676020E+02, .475527E+02, .334479E+02,
     +  .234890E+02, .164916E+02, .115818E+02, .814011E+01,
     +  .572917E+01, .403942E+01, .285632E+01, .202551E+01,
     +  .144134E+01, .102953E+01, .738390E+00, .531673E+00,
     +  .384938E+00, .279197E+00, .203682E+00, .148812E+00,
     +  .109180E+00, .803106E-01, .592004E-01, .437087E-01,
     +  .323043E-01, .238872E-01, .176619E-01, .130508E-01,
     +  .963233E-02, .709724E-02, .521784E-02, .382614E-02,
     +  .279574E-02, .203837E-02, .147740E-02, .106627E-02,
     +  .766196E-03, .548206E-03, .390696E-03, .277535E-03,
     +  .196732E-03, .139376E-03, .988965E-04, .703902E-04,
     +  .505586E-04, .365399E-04, .266598E-04, .196198E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .145191E-04, .107482E-04, .790013E-05, .571144E-05,
     +  .400503E-05, .269178E-05, .169748E-05, .975980E-06,
     +  .488658E-06, .195261E-06, .512972E-07, .508138E-08,
     +  .000000E+00, .222182E+07, .165327E+07, .120539E+07,
     +  .878200E+06, .639252E+06, .464891E+06, .337768E+06,
     +  .245165E+06, .177769E+06, .128765E+06, .931679E+05,
     +  .673352E+05, .486085E+05, .350470E+05, .252375E+05,
     +  .181496E+05, .130348E+05, .934806E+04, .669440E+04,
     +  .478665E+04, .341729E+04, .243561E+04, .173309E+04,
     +  .123099E+04, .872837E+03, .617611E+03, .436359E+03,
     +  .306198E+03, .215573E+03, .151499E+03, .106289E+03,
     +  .744552E+02, .520777E+02, .364219E+02, .254294E+02,
     +  .177494E+02, .123914E+02, .865708E+01, .605636E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .424424E+01, .298291E+01, .210237E+01, .148689E+01,
     +  .105558E+01, .752460E+00, .538501E+00, .387528E+00,
     +  .279369E+00, .202584E+00, .147120E+00, .107295E+00,
     +  .784555E-01, .574906E-01, .421959E-01, .310029E-01,
     +  .227906E-01, .167527E-01, .123071E-01, .903105E-02,
     +  .661623E-02, .483686E-02, .352729E-02, .256359E-02,
     +  .185961E-02, .134140E-02, .963939E-03, .690113E-03,
     +  .492364E-03, .350285E-03, .248738E-03, .176553E-03,
     +  .125491E-03, .895289E-04, .642010E-04, .465330E-04,
     +  .339688E-04, .250280E-04, .185735E-04, .138249E-04,
     +  .102598E-04, .753039E-05, .541612E-05, .376421E-05,
     +  .249863E-05, .155065E-05, .874080E-06, .427065E-06,
     +  .165466E-06, .420507E-07, .421106E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .277468E+07, .205803E+07, .149473E+07, .108477E+07,
     +  .786515E+06, .569720E+06, .412274E+06, .298034E+06,
     +  .215222E+06, .155249E+06, .111862E+06, .805049E+05,
     +  .578677E+05, .415431E+05, .297849E+05, .213255E+05,
     +  .152474E+05, .108856E+05, .775992E+04, .552291E+04,
     +  .392451E+04, .278389E+04, .197143E+04, .139349E+04,
     +  .983204E+03, .692230E+03, .486616E+03, .339696E+03,
     +  .237920E+03, .166328E+03, .116072E+03, .808709E+02,
     +  .562563E+02, .391272E+02, .271653E+02, .188537E+02,
     +  .130870E+02, .909023E+01, .632237E+01, .440469E+01,
     +  .307746E+01, .215620E+01, .151594E+01, .106983E+01,
     +  .758116E+00, .539343E+00, .385859E+00, .276528E+00,
     +  .199357E+00, .143932E+00, .104362E+00, .758709E-01 /
        DATA (UPDI(I),I=2601,2652) /
     +  .552773E-01, .403392E-01, .294697E-01, .215405E-01,
     +  .157443E-01, .115014E-01, .839282E-02, .611488E-02,
     +  .444625E-02, .322544E-02, .233233E-02, .168378E-02,
     +  .120919E-02, .865516E-03, .617631E-03, .439603E-03,
     +  .312351E-03, .221820E-03, .157711E-03, .112482E-03,
     +  .806661E-04, .582337E-04, .425291E-04, .312876E-04,
     +  .232115E-04, .173119E-04, .129166E-04, .957883E-05,
     +  .700202E-05, .499999E-05, .343928E-05, .225279E-05,
     +  .137535E-05, .760062E-06, .362504E-06, .136323E-06,
     +  .335824E-07, .339847E-08, .000000E+00, .341046E+07,
     +  .252172E+07, .182462E+07, .131916E+07, .952806E+06,
     +  .687507E+06, .495569E+06, .356836E+06, .256659E+06,
     +  .184395E+06, .132322E+06, .948387E+05, .678880E+05 /
        DATA (UPDI(I),I=2653,2704) /
     +  .485322E+05, .346483E+05, .247012E+05, .175845E+05,
     +  .124990E+05, .887057E+04, .628506E+04, .444582E+04,
     +  .313920E+04, .221272E+04, .155668E+04, .109311E+04,
     +  .765878E+03, .535760E+03, .372125E+03, .259326E+03,
     +  .180372E+03, .125226E+03, .867936E+02, .600571E+02,
     +  .415477E+02, .286894E+02, .198023E+02, .136693E+02,
     +  .944164E+01, .652978E+01, .452335E+01, .314236E+01,
     +  .218906E+01, .153021E+01, .107371E+01, .756500E+00,
     +  .535106E+00, .380651E+00, .271234E+00, .194435E+00,
     +  .139582E+00, .100639E+00, .727536E-01, .527100E-01,
     +  .382517E-01, .277899E-01, .202006E-01, .146840E-01,
     +  .106685E-01, .774323E-02, .561174E-02, .405930E-02,
     +  .292999E-02, .210851E-02, .151537E-02, .108378E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .772991E-03, .550031E-03, .390723E-03, .277385E-03,
     +  .197081E-03, .140393E-03, .100476E-03, .724073E-04,
     +  .525786E-04, .386373E-04, .285896E-04, .213054E-04,
     +  .159290E-04, .118834E-04, .878688E-05, .638564E-05,
     +  .452116E-05, .307520E-05, .198668E-05, .119293E-05,
     +  .646356E-06, .301019E-06, .109972E-06, .263083E-07,
     +  .268948E-08, .000000E+00, .332208E+05, .114604E+05,
     +  .910386E+04, .723189E+04, .574487E+04, .456364E+04,
     +  .362532E+04, .287996E+04, .228788E+04, .181754E+04,
     +  .144393E+04, .114714E+04, .911387E+03, .724108E+03,
     +  .575339E+03, .457160E+03, .363280E+03, .288703E+03,
     +  .229460E+03, .182396E+03, .145007E+03, .115304E+03,
     +  .917068E+02, .729587E+02, .580631E+02, .462276E+02 /
        DATA (UPDI(I),I=2757,2808) /
     +  .368229E+02, .292549E+02, .233364E+02, .186313E+02,
     +  .148901E+02, .119146E+02, .954715E+01, .766785E+01,
     +  .616712E+01, .497152E+01, .401800E+01, .325651E+01,
     +  .264728E+01, .215859E+01, .176609E+01, .144932E+01,
     +  .119284E+01, .984320E+00, .814074E+00, .674476E+00,
     +  .559911E+00, .464586E+00, .385955E+00, .320097E+00,
     +  .265359E+00, .219602E+00, .181320E+00, .149282E+00,
     +  .122484E+00, .100098E+00, .814348E-01, .659176E-01,
     +  .530603E-01, .424500E-01, .337350E-01, .266146E-01,
     +  .208312E-01, .161838E-01, .124372E-01, .946113E-02,
     +  .711786E-02, .529055E-02, .388064E-02, .280543E-02,
     +  .199597E-02, .139521E-02, .956109E-03, .640566E-03,
     +  .420162E-03, .267319E-03, .164820E-03, .980186E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .558967E-04, .303427E-04, .155316E-04, .741423E-05,
     +  .322872E-05, .126172E-05, .425999E-06, .117816E-06,
     +  .244070E-07, .320252E-08, .182627E-09, .135687E-11,
     +  .000000E+00, .383172E+05, .276641E+05, .214617E+05,
     +  .166567E+05, .129322E+05, .100442E+05, .780410E+04,
     +  .606584E+04, .471653E+04, .366874E+04, .285480E+04,
     +  .222229E+04, .173058E+04, .134818E+04, .105069E+04,
     +  .819165E+03, .638913E+03, .498524E+03, .389145E+03,
     +  .303893E+03, .237422E+03, .185576E+03, .145121E+03,
     +  .113544E+03, .888873E+02, .696258E+02, .545756E+02,
     +  .426635E+02, .334984E+02, .263274E+02, .207141E+02,
     +  .163183E+02, .128739E+02, .101808E+02, .806221E+01,
     +  .639938E+01, .509282E+01, .406474E+01, .325436E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .261389E+01, .210709E+01, .170412E+01, .138269E+01,
     +  .112526E+01, .918205E+00, .750913E+00, .615643E+00,
     +  .504700E+00, .414495E+00, .339993E+00, .278910E+00,
     +  .228520E+00, .186894E+00, .152485E+00, .124041E+00,
     +  .100546E+00, .811688E-01, .652230E-01, .521390E-01,
     +  .414416E-01, .327318E-01, .256758E-01, .199874E-01,
     +  .154492E-01, .118152E-01, .894645E-02, .670042E-02,
     +  .495771E-02, .361907E-02, .260204E-02, .183889E-02,
     +  .127361E-02, .861837E-03, .566189E-03, .360085E-03,
     +  .217617E-03, .122638E-03, .615313E-04, .239598E-04,
     +  .248916E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .653928E+05, .508479E+05, .390485E+05, .299946E+05,
     +  .230446E+05, .177085E+05, .136108E+05, .104636E+05,
     +  .804588E+04, .618820E+04, .476055E+04, .366315E+04,
     +  .281943E+04, .217059E+04, .167152E+04, .128756E+04,
     +  .992081E+03, .764641E+03, .589533E+03, .454676E+03,
     +  .350796E+03, .270751E+03, .209058E+03, .161494E+03,
     +  .124815E+03, .965155E+02, .746820E+02, .576188E+02,
     +  .446570E+02, .346431E+02, .269034E+02, .209191E+02,
     +  .162892E+02, .127148E+02, .993848E+01, .778686E+01,
     +  .611750E+01, .482043E+01, .381082E+01, .302284E+01,
     +  .240705E+01, .192347E+01, .154248E+01, .124107E+01,
     +  .100158E+01, .810390E+00, .657627E+00, .533782E+00,
     +  .434239E+00, .352940E+00, .287007E+00, .233190E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .189188E+00, .153173E+00, .123685E+00, .995515E-01,
     +  .798231E-01, .637263E-01, .506261E-01, .399992E-01,
     +  .314117E-01, .245055E-01, .189748E-01, .145914E-01,
     +  .111033E-01, .836610E-02, .623525E-02, .459084E-02,
     +  .333415E-02, .238405E-02, .167439E-02, .115112E-02,
     +  .771758E-03, .500573E-03, .312496E-03, .183349E-03,
     +  .979964E-04, .438803E-04, .113695E-04, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .109889E+06,
     +  .849220E+05, .647501E+05, .493735E+05, .376490E+05,
     +  .287092E+05, .218927E+05, .166951E+05, .127319E+05,
     +  .970991E+04, .740553E+04, .564832E+04, .430834E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .328647E+04, .250717E+04, .191284E+04, .145955E+04,
     +  .111381E+04, .850091E+03, .648913E+03, .495442E+03,
     +  .378345E+03, .288999E+03, .220815E+03, .168778E+03,
     +  .129049E+03, .987265E+02, .752866E+02, .576770E+02,
     +  .442226E+02, .339401E+02, .260792E+02, .200666E+02,
     +  .154776E+02, .119540E+02, .925479E+01, .718472E+01,
     +  .559484E+01, .437158E+01, .342780E+01, .269870E+01,
     +  .213264E+01, .169171E+01, .134678E+01, .107576E+01,
     +  .861752E+00, .692615E+00, .556943E+00, .449038E+00,
     +  .361809E+00, .291775E+00, .235165E+00, .189318E+00,
     +  .152137E+00, .121965E+00, .974866E-01, .776435E-01,
     +  .615845E-01, .486179E-01, .381796E-01, .298072E-01,
     +  .231226E-01, .178058E-01, .136206E-01, .103120E-01 /
        DATA (UPDI(I),I=3069,3120) /
     +  .773246E-02, .573692E-02, .420635E-02, .304363E-02,
     +  .216969E-02, .152053E-02, .104463E-02, .701300E-03,
     +  .457078E-03, .288435E-03, .173047E-03, .969439E-04,
     +  .486959E-04, .195703E-04, .440313E-05, .103980E-05,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .172108E+06, .132342E+06,
     +  .100320E+06, .760409E+05, .576299E+05, .436706E+05,
     +  .330881E+05, .250666E+05, .189873E+05, .143804E+05,
     +  .108900E+05, .824576E+04, .624286E+04, .472594E+04,
     +  .357725E+04, .270751E+04, .204907E+04, .155065E+04,
     +  .117342E+04, .887927E+03, .671902E+03, .508442E+03,
     +  .384781E+03, .291223E+03, .220454E+03, .166909E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .126421E+03, .954183E+02, .723510E+02, .548977E+02,
     +  .416904E+02, .316945E+02, .241261E+02, .184087E+02,
     +  .140640E+02, .107703E+02, .827070E+01, .637106E+01,
     +  .492481E+01, .382068E+01, .297663E+01, .232813E+01,
     +  .182821E+01, .144116E+01, .114014E+01, .904825E+00,
     +  .720701E+00, .574443E+00, .459242E+00, .366995E+00,
     +  .293617E+00, .234840E+00, .187657E+00, .149722E+00,
     +  .119196E+00, .946319E-01, .748773E-01, .590135E-01,
     +  .463007E-01, .361417E-01, .280517E-01, .216376E-01,
     +  .165701E-01, .126075E-01, .949531E-02, .708442E-02,
     +  .523104E-02, .381826E-02, .275153E-02, .195451E-02,
     +  .136591E-02, .936945E-03, .629125E-03, .411306E-03,
     +  .261621E-03, .159617E-03, .925299E-04, .500205E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .243002E-04, .108417E-04, .665480E-05, .448629E-05,
     +  .302705E-05, .203786E-05, .134621E-05, .850531E-06,
     +  .491478E-06, .243367E-06, .847208E-07, .769627E-08,
     +  .000000E+00, .196974E+06, .195749E+06, .147625E+06,
     +  .111312E+06, .839097E+05, .632363E+05, .476437E+05,
     +  .358862E+05, .270229E+05, .203432E+05, .153105E+05,
     +  .115197E+05, .866515E+04, .651621E+04, .489895E+04,
     +  .368212E+04, .276687E+04, .207861E+04, .156123E+04,
     +  .117238E+04, .880239E+03, .660786E+03, .495998E+03,
     +  .372272E+03, .279412E+03, .209707E+03, .157433E+03,
     +  .117739E+03, .884578E+02, .664938E+02, .500192E+02,
     +  .376620E+02, .283905E+02, .214511E+02, .162268E+02,
     +  .123035E+02, .935437E+01, .713446E+01, .546057E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .419488E+01, .323659E+01, .250735E+01, .195052E+01,
     +  .152349E+01, .119449E+01, .939674E+00, .742128E+00,
     +  .586620E+00, .465233E+00, .368884E+00, .292904E+00,
     +  .232557E+00, .184513E+00, .146198E+00, .115610E+00,
     +  .911855E-01, .716915E-01, .561523E-01, .437894E-01,
     +  .339795E-01, .262215E-01, .201121E-01, .153169E-01,
     +  .115915E-01, .868433E-02, .644646E-02, .473679E-02,
     +  .344155E-02, .246950E-02, .174755E-02, .121753E-02,
     +  .833518E-03, .559474E-03, .366580E-03, .234673E-03,
     +  .145150E-03, .864390E-04, .492477E-04, .266993E-04,
     +  .147364E-04, .101032E-04, .726267E-05, .517312E-05,
     +  .361546E-05, .243053E-05, .153032E-05, .864796E-06,
     +  .409370E-06, .133273E-06, .123829E-07, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .384800E+06, .293244E+06, .219957E+06, .164938E+06,
     +  .123635E+06, .926386E+05, .693863E+05, .519496E+05,
     +  .388791E+05, .290852E+05, .217495E+05, .162571E+05,
     +  .121467E+05, .907170E+04, .677233E+04, .505363E+04,
     +  .376956E+04, .281059E+04, .209477E+04, .156065E+04,
     +  .116231E+04, .865334E+03, .644056E+03, .479224E+03,
     +  .356511E+03, .265154E+03, .197227E+03, .146094E+03,
     +  .108709E+03, .809198E+02, .602670E+02, .449208E+02,
     +  .335161E+02, .250624E+02, .187604E+02, .140749E+02,
     +  .105881E+02, .798994E+01, .605077E+01, .459943E+01,
     +  .351180E+01, .269255E+01, .207337E+01, .160332E+01,
     +  .124483E+01, .969928E+00, .758925E+00, .594439E+00,
     +  .467289E+00, .367325E+00, .289234E+00, .227780E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .179297E+00, .140973E+00, .110644E+00, .866303E-01,
     +  .676236E-01, .525957E-01, .407344E-01, .313956E-01,
     +  .240663E-01, .183376E-01, .138732E-01, .104298E-01,
     +  .776150E-02, .572177E-02, .417420E-02, .300978E-02,
     +  .214190E-02, .150178E-02, .103520E-02, .699684E-03,
     +  .462240E-03, .296593E-03, .184547E-03, .109524E-03,
     +  .612164E-04, .314090E-04, .141248E-04, .566520E-05,
     +  .284023E-05, .150112E-05, .777804E-06, .415009E-06,
     +  .240654E-06, .153963E-06, .100556E-06, .596073E-07,
     +  .244100E-07, .209883E-08, .000000E+00, .554849E+06,
     +  .421008E+06, .314184E+06, .234377E+06, .174759E+06,
     +  .130243E+06, .970184E+05, .722328E+05, .537518E+05,
     +  .399782E+05, .297184E+05, .220796E+05, .163954E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .121678E+05, .902537E+04, .669070E+04, .495724E+04,
     +  .367081E+04, .271676E+04, .200956E+04, .148570E+04,
     +  .109782E+04, .810848E+03, .598611E+03, .441769E+03,
     +  .325874E+03, .240372E+03, .176516E+03, .130207E+03,
     +  .960640E+02, .709014E+02, .523632E+02, .387051E+02,
     +  .286703E+02, .212562E+02, .157937E+02, .117660E+02,
     +  .879247E+01, .659376E+01, .496354E+01, .375328E+01,
     +  .285020E+01, .217404E+01, .166552E+01, .128130E+01,
     +  .989379E+00, .767367E+00, .595863E+00, .464484E+00,
     +  .362114E+00, .282845E+00, .221005E+00, .172631E+00,
     +  .134716E+00, .104957E+00, .815868E-01, .632372E-01,
     +  .488431E-01, .375702E-01, .287626E-01, .219023E-01,
     +  .165800E-01, .124627E-01, .931003E-02, .688476E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .504419E-02, .365776E-02, .262208E-02, .185569E-02,
     +  .129448E-02, .888359E-03, .598424E-03, .394681E-03,
     +  .253526E-03, .158680E-03, .955432E-04, .550780E-04,
     +  .301532E-04, .156696E-04, .837144E-05, .536378E-05,
     +  .360701E-05, .243289E-05, .163366E-05, .106903E-05,
     +  .661101E-06, .368607E-06, .171281E-06, .537434E-07,
     +  .502453E-08, .000000E+00, .772501E+06, .583764E+06,
     +  .433541E+06, .321831E+06, .238773E+06, .177049E+06,
     +  .131205E+06, .971738E+05, .719258E+05, .532048E+05,
     +  .393318E+05, .290574E+05, .214530E+05, .158282E+05,
     +  .116704E+05, .859886E+04, .633149E+04, .465874E+04,
     +  .342564E+04, .251718E+04, .184844E+04, .135646E+04,
     +  .994830E+03, .729155E+03, .534158E+03, .391062E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .286248E+03, .208539E+03, .152601E+03, .111671E+03,
     +  .817377E+02, .598575E+02, .438654E+02, .322108E+02,
     +  .236709E+02, .174313E+02, .128694E+02, .953033E+01,
     +  .708252E+01, .528327E+01, .395912E+01, .297963E+01,
     +  .225264E+01, .171063E+01, .130466E+01, .998855E+00,
     +  .768283E+00, .591674E+00, .457533E+00, .353883E+00,
     +  .274289E+00, .212703E+00, .164919E+00, .127764E+00,
     +  .988319E-01, .762881E-01, .587232E-01, .450492E-01,
     +  .344203E-01, .261775E-01, .198042E-01, .148956E-01,
     +  .111253E-01, .825903E-02, .606972E-02, .442003E-02,
     +  .318620E-02, .227104E-02, .159863E-02, .110972E-02,
     +  .758427E-03, .509400E-03, .335603E-03, .215986E-03,
     +  .136106E-03, .832001E-04, .494053E-04, .285819E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .164018E-04, .100248E-04, .694086E-05, .492182E-05,
     +  .345319E-05, .236865E-05, .155356E-05, .946064E-06,
     +  .511420E-06, .226456E-06, .669277E-07, .638510E-08,
     +  .000000E+00, .104461E+07, .786316E+06, .581273E+06,
     +  .429478E+06, .317124E+06, .234012E+06, .172569E+06,
     +  .127173E+06, .936541E+05, .689213E+05, .506839E+05,
     +  .372449E+05, .273490E+05, .200671E+05, .147128E+05,
     +  .107786E+05, .789028E+04, .577126E+04, .421803E+04,
     +  .308031E+04, .224774E+04, .163888E+04, .119408E+04,
     +  .869340E+03, .632503E+03, .459823E+03, .334186E+03,
     +  .241670E+03, .175537E+03, .127486E+03, .925956E+02,
     +  .672782E+02, .489108E+02, .356261E+02, .259661E+02,
     +  .189630E+02, .138832E+02, .101945E+02, .751207E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .555626E+01, .412853E+01, .308100E+01, .230983E+01,
     +  .173956E+01, .131588E+01, .999316E+00, .762559E+00,
     +  .582661E+00, .447115E+00, .343209E+00, .264046E+00,
     +  .203271E+00, .156479E+00, .120373E+00, .924704E-01,
     +  .708913E-01, .542025E-01, .413056E-01, .313536E-01,
     +  .236911E-01, .178088E-01, .133104E-01, .987917E-02,
     +  .728892E-02, .532424E-02, .385413E-02, .276227E-02,
     +  .195804E-02, .137125E-02, .947546E-03, .645195E-03,
     +  .432314E-03, .284714E-03, .183744E-03, .116680E-03,
     +  .724395E-04, .442266E-04, .267926E-04, .164799E-04,
     +  .108364E-04, .775193E-05, .559092E-05, .395419E-05,
     +  .270868E-05, .175855E-05, .105135E-05, .553502E-06,
     +  .236215E-06, .668382E-07, .646598E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .137784E+07, .103328E+07, .760451E+06, .559341E+06,
     +  .411134E+06, .301982E+06, .221648E+06, .162564E+06,
     +  .119139E+06, .872464E+05, .638404E+05, .466755E+05,
     +  .340976E+05, .248880E+05, .181504E+05, .132250E+05,
     +  .962783E+04, .700269E+04, .508882E+04, .369460E+04,
     +  .268002E+04, .194226E+04, .140641E+04, .101748E+04,
     +  .735543E+03, .531225E+03, .383506E+03, .275424E+03,
     +  .198668E+03, .143266E+03, .103308E+03, .745121E+02,
     +  .537660E+02, .388669E+02, .281107E+02, .203698E+02,
     +  .147961E+02, .107789E+02, .787959E+01, .578162E+01,
     +  .426178E+01, .315516E+01, .234673E+01, .175348E+01,
     +  .131611E+01, .991796E+00, .751101E+00, .569594E+00,
     +  .433877E+00, .330623E+00, .252546E+00, .193050E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .147582E+00, .112754E+00, .860343E-01, .655192E-01,
     +  .497666E-01, .376795E-01, .284180E-01, .213371E-01,
     +  .159390E-01, .118392E-01, .873343E-02, .640487E-02,
     +  .465074E-02, .334715E-02, .238557E-02, .168211E-02,
     +  .117233E-02, .806705E-03, .547532E-03, .366229E-03,
     +  .241291E-03, .156292E-03, .100092E-03, .631205E-04,
     +  .395395E-04, .248881E-04, .160873E-04, .110421E-04,
     +  .801618E-05, .580586E-05, .409788E-05, .278454E-05,
     +  .178302E-05, .104555E-05, .536654E-06, .221426E-06,
     +  .602784E-07, .590321E-08, .000000E+00, .177852E+07,
     +  .132899E+07, .973896E+06, .713241E+06, .521957E+06,
     +  .381680E+06, .278884E+06, .203609E+06, .148529E+06,
     +  .108258E+06, .788372E+05, .573612E+05, .416979E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .302836E+05, .219732E+05, .159280E+05, .115348E+05,
     +  .834500E+04, .603139E+04, .435476E+04, .314114E+04,
     +  .226341E+04, .162940E+04, .117180E+04, .841970E+03,
     +  .604322E+03, .433535E+03, .309329E+03, .221667E+03,
     +  .158787E+03, .113725E+03, .814599E+02, .583670E+02,
     +  .418930E+02, .300803E+02, .216374E+02, .156005E+02,
     +  .112801E+02, .818408E+01, .595975E+01, .435994E+01,
     +  .320349E+01, .236476E+01, .175375E+01, .130655E+01,
     +  .977347E+00, .734797E+00, .553209E+00, .418414E+00,
     +  .316600E+00, .240165E+00, .182335E+00, .138453E+00,
     +  .105077E+00, .796513E-01, .602653E-01, .454827E-01,
     +  .342179E-01, .256456E-01, .191361E-01, .142072E-01,
     +  .104890E-01, .769108E-02, .560737E-02, .404816E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .289717E-02, .205382E-02, .144095E-02, .999742E-03,
     +  .685360E-03, .463926E-03, .309964E-03, .204464E-03,
     +  .133034E-03, .859758E-04, .550624E-04, .353061E-04,
     +  .229341E-04, .153629E-04, .108208E-04, .790021E-05,
     +  .571144E-05, .400503E-05, .269178E-05, .169748E-05,
     +  .975980E-06, .488658E-06, .195261E-06, .512972E-07,
     +  .508138E-08, .000000E+00, .225249E+07, .167736E+07,
     +  .122411E+07, .892743E+06, .650557E+06, .473682E+06,
     +  .344606E+06, .250486E+06, .181911E+06, .131990E+06,
     +  .956799E+05, .692924E+05, .501338E+05, .362360E+05,
     +  .261646E+05, .188727E+05, .135988E+05, .978813E+04,
     +  .703780E+04, .505465E+04, .362646E+04, .259888E+04,
     +  .186053E+04, .133046E+04, .950467E+03, .678185E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .483623E+03, .342940E+03, .244233E+03, .173850E+03,
     +  .123714E+03, .880373E+02, .626609E+02, .446725E+02,
     +  .318566E+02, .227563E+02, .162923E+02, .116970E+02,
     +  .842609E+01, .609203E+01, .442473E+01, .322774E+01,
     +  .236558E+01, .174182E+01, .128845E+01, .957004E+00,
     +  .714492E+00, .534182E+00, .401265E+00, .301561E+00,
     +  .227226E+00, .171371E+00, .129276E+00, .974786E-01,
     +  .734188E-01, .551983E-01, .413977E-01, .309517E-01,
     +  .230553E-01, .170989E-01, .126186E-01, .926098E-02,
     +  .675087E-02, .489376E-02, .351319E-02, .250074E-02,
     +  .176372E-02, .123159E-02, .850953E-03, .581426E-03,
     +  .392734E-03, .262280E-03, .173344E-03, .113374E-03,
     +  .739681E-04, .480840E-04, .314795E-04, .209768E-04 /
        DATA (UPDI(I),I=3901,3952) /
     +  .144151E-04, .103096E-04, .753045E-05, .541612E-05,
     +  .376421E-05, .249863E-05, .155065E-05, .874080E-06,
     +  .427065E-06, .165466E-06, .420507E-07, .421106E-08,
     +  .000000E+00, .280496E+07, .208181E+07, .151320E+07,
     +  .109912E+07, .797679E+06, .578402E+06, .419028E+06,
     +  .303290E+06, .219313E+06, .158435E+06, .114344E+06,
     +  .824386E+05, .593748E+05, .427179E+05, .307010E+05,
     +  .220399E+05, .158047E+05, .113203E+05, .809911E+04,
     +  .578758E+04, .413104E+04, .294505E+04, .209719E+04,
     +  .149160E+04, .105974E+04, .751915E+03, .533156E+03,
     +  .375847E+03, .266093E+03, .188276E+03, .133164E+03,
     +  .941743E+02, .666062E+02, .471819E+02, .334274E+02,
     +  .237212E+02, .168700E+02, .120302E+02, .860738E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .618062E+01, .445834E+01, .322994E+01, .235095E+01,
     +  .171919E+01, .126304E+01, .931756E+00, .690972E+00,
     +  .513129E+00, .382904E+00, .285867E+00, .214001E+00,
     +  .160358E+00, .120199E+00, .900622E-01, .674094E-01,
     +  .503668E-01, .375427E-01, .278991E-01, .206566E-01,
     +  .152288E-01, .111725E-01, .815219E-02, .590866E-02,
     +  .425943E-02, .304123E-02, .215355E-02, .151147E-02,
     +  .105080E-02, .723301E-03, .492794E-03, .332339E-03,
     +  .221988E-03, .147096E-03, .967618E-04, .637397E-04,
     +  .420219E-04, .280150E-04, .190514E-04, .133292E-04,
     +  .961303E-05, .700206E-05, .499999E-05, .343928E-05,
     +  .225279E-05, .137535E-05, .760062E-06, .362504E-06,
     +  .136323E-06, .335824E-07, .339847E-08, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .344035E+07, .254520E+07, .184286E+07, .133334E+07,
     +  .963830E+06, .696082E+06, .502240E+06, .362028E+06,
     +  .260701E+06, .187543E+06, .134774E+06, .967492E+05,
     +  .693770E+05, .496929E+05, .355534E+05, .254070E+05,
     +  .181350E+05, .129284E+05, .920556E+04, .654641E+04,
     +  .464971E+04, .329826E+04, .233678E+04, .165343E+04,
     +  .116854E+04, .824669E+03, .581570E+03, .407679E+03,
     +  .287008E+03, .201914E+03, .141980E+03, .998158E+02,
     +  .701719E+02, .494051E+02, .347857E+02, .245301E+02,
     +  .173345E+02, .122821E+02, .873067E+01, .622823E+01,
     +  .446325E+01, .321223E+01, .232266E+01, .168732E+01,
     +  .123149E+01, .902525E+00, .664953E+00, .490597E+00,
     +  .363745E+00, .269826E+00, .200716E+00, .149461E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .111334E+00, .829061E-01, .616742E-01, .458026E-01,
     +  .339357E-01, .250686E-01, .184516E-01, .135240E-01,
     +  .986474E-02, .715720E-02, .515860E-02, .369864E-02,
     +  .262699E-02, .185097E-02, .129312E-02, .895310E-03,
     +  .614189E-03, .417451E-03, .281234E-03, .187998E-03,
     +  .124968E-03, .827118E-04, .550041E-04, .367362E-04,
     +  .248745E-04, .171861E-04, .121718E-04, .881035E-05,
     +  .638567E-05, .452116E-05, .307520E-05, .198668E-05,
     +  .119293E-05, .646356E-06, .301019E-06, .109972E-06,
     +  .263083E-07, .268948E-08, .000000E+00, .265094E+05,
     +  .286822E+05, .227876E+05, .181048E+05, .143847E+05,
     +  .114293E+05, .908137E+04, .721603E+04, .573408E+04,
     +  .455669E+04, .362125E+04, .287803E+04, .228751E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .181830E+04, .144548E+04, .114923E+04, .913816E+03,
     +  .726736E+03, .578059E+03, .459894E+03, .365974E+03,
     +  .291319E+03, .231971E+03, .184787E+03, .147270E+03,
     +  .117435E+03, .937057E+02, .745906E+02, .596251E+02,
     +  .477129E+02, .382283E+02, .306738E+02, .246540E+02,
     +  .198674E+02, .160385E+02, .129824E+02, .105407E+02,
     +  .858713E+01, .702138E+01, .576330E+01, .475133E+01,
     +  .393352E+01, .327063E+01, .273118E+01, .229028E+01,
     +  .192817E+01, .163013E+01, .138076E+01, .117297E+01,
     +  .995940E+00, .844868E+00, .713827E+00, .598966E+00,
     +  .497735E+00, .408719E+00, .331256E+00, .264968E+00,
     +  .209351E+00, .163592E+00, .126594E+00, .971086E-01,
     +  .738808E-01, .557551E-01, .417822E-01, .309792E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .227474E-01, .165250E-01, .118629E-01, .840410E-02,
     +  .586668E-02, .402857E-02, .271600E-02, .179330E-02,
     +  .115607E-02, .728719E-03, .444584E-03, .262261E-03,
     +  .148820E-03, .807222E-04, .415228E-04, .200517E-04,
     +  .898396E-05, .364768E-05, .131928E-05, .408398E-06,
     +  .102349E-06, .189265E-07, .217328E-08, .105541E-09,
     +  .641736E-12, .000000E+00, .316290E+05, .448028E+05,
     +  .350796E+05, .274775E+05, .215307E+05, .168772E+05,
     +  .132343E+05, .103814E+05, .814651E+04, .639505E+04,
     +  .502197E+04, .394514E+04, .310034E+04, .243735E+04,
     +  .191685E+04, .150808E+04, .118695E+04, .934574E+03,
     +  .736169E+03, .580137E+03, .457389E+03, .360788E+03,
     +  .284741E+03, .224852E+03, .177671E+03, .140486E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .111172E+03, .877611E+02, .695865E+02, .552383E+02,
     +  .439054E+02, .349497E+02, .278682E+02, .222801E+02,
     +  .178434E+02, .143285E+02, .115407E+02, .932641E+01,
     +  .756456E+01, .615908E+01, .503663E+01, .413598E+01,
     +  .341108E+01, .282529E+01, .234979E+01, .196184E+01,
     +  .164462E+01, .138086E+01, .116252E+01, .977805E+00,
     +  .821445E+00, .687153E+00, .570853E+00, .469782E+00,
     +  .382241E+00, .307204E+00, .243885E+00, .191410E+00,
     +  .148689E+00, .114451E+00, .873673E-01, .661742E-01,
     +  .497261E-01, .371129E-01, .274090E-01, .200491E-01,
     +  .145104E-01, .103778E-01, .732398E-02, .509166E-02,
     +  .347991E-02, .233188E-02, .152747E-02, .972706E-03,
     +  .601354E-03, .354986E-03, .197433E-03, .100132E-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .426154E-04, .107888E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .135525E-19, .101644E-19, .000000E+00, .370577E-21,
     +  .000000E+00, .866870E+05, .679156E+05, .526102E+05,
     +  .407709E+05, .316078E+05, .245135E+05, .190189E+05,
     +  .147617E+05, .114620E+05, .890355E+04, .691904E+04,
     +  .537913E+04, .418375E+04, .325545E+04, .253427E+04,
     +  .197377E+04, .153797E+04, .119899E+04, .935200E+03,
     +  .729838E+03, .569896E+03, .445267E+03, .348117E+03,
     +  .272346E+03, .213227E+03, .167070E+03, .131024E+03,
     +  .102504E+03, .805654E+02, .634003E+02, .499618E+02,
     +  .394343E+02, .311809E+02, .247227E+02, .196373E+02,
     +  .156412E+02, .124970E+02, .100192E+02, .806288E+01 /
        DATA (UPDI(I),I=4317,4368) /
     +  .651401E+01, .528620E+01, .430813E+01, .352651E+01,
     +  .289922E+01, .239346E+01, .198346E+01, .165033E+01,
     +  .137503E+01, .114857E+01, .958251E+00, .798352E+00,
     +  .662220E+00, .545530E+00, .445289E+00, .359526E+00,
     +  .286902E+00, .226307E+00, .176590E+00, .136461E+00,
     +  .104537E+00, .794450E-01, .599221E-01, .448441E-01,
     +  .333367E-01, .245237E-01, .178689E-01, .128824E-01,
     +  .917741E-02, .645083E-02, .446564E-02, .303782E-02,
     +  .202461E-02, .131751E-02, .831494E-03, .507447E-03,
     +  .293445E-03, .157419E-03, .742092E-04, .258364E-04,
     +  .348396E-06, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .131096E+06, .101920E+06, .782567E+05, .601061E+05,
     +  .461777E+05, .354869E+05, .272791E+05, .209760E+05,
     +  .161345E+05, .124145E+05, .955550E+04, .735756E+04,
     +  .566732E+04, .436709E+04, .336657E+04, .259639E+04,
     +  .200333E+04, .154647E+04, .119441E+04, .923001E+03,
     +  .713680E+03, .552167E+03, .427496E+03, .331209E+03,
     +  .256814E+03, .199293E+03, .154810E+03, .119955E+03,
     +  .934008E+02, .728214E+02, .568611E+02, .444740E+02,
     +  .348516E+02, .273901E+02, .215670E+02, .170313E+02,
     +  .134932E+02, .107284E+02, .856344E+01, .686321E+01,
     +  .552599E+01, .446891E+01, .363041E+01, .296232E+01,
     +  .242742E+01, .199669E+01, .164902E+01, .136352E+01,
     +  .113020E+01, .935450E+00, .773069E+00, .636015E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .519692E+00, .420856E+00, .337261E+00, .267271E+00,
     +  .209488E+00, .162525E+00, .124929E+00, .952341E-01,
     +  .720409E-01, .540988E-01, .403118E-01, .298420E-01,
     +  .218626E-01, .158661E-01, .113941E-01, .808713E-02,
     +  .566491E-02, .390956E-02, .265282E-02, .176517E-02,
     +  .114840E-02, .726179E-03, .445746E-03, .261133E-03,
     +  .144047E-03, .724519E-04, .307304E-04, .872718E-05,
     +  .104065E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .193230E+06,
     +  .149272E+06, .113772E+06, .867306E+05, .661246E+05,
     +  .504213E+05, .384531E+05, .293306E+05, .223764E+05,
     +  .170744E+05, .130316E+05, .994835E+04, .759658E+04 /
        DATA (UPDI(I),I=4473,4524) /
     +  .580239E+04, .443334E+04, .338843E+04, .259075E+04,
     +  .198164E+04, .151641E+04, .116095E+04, .889280E+03,
     +  .681570E+03, .522713E+03, .401157E+03, .308111E+03,
     +  .236838E+03, .182241E+03, .139864E+03, .107885E+03,
     +  .833330E+02, .644691E+02, .499644E+02, .388004E+02,
     +  .302222E+02, .235878E+02, .184659E+02, .145054E+02,
     +  .114370E+02, .905448E+01, .719864E+01, .575067E+01,
     +  .461488E+01, .372072E+01, .301346E+01, .245118E+01,
     +  .200146E+01, .164086E+01, .134665E+01, .110780E+01,
     +  .909823E+00, .745994E+00, .608890E+00, .493632E+00,
     +  .396715E+00, .315624E+00, .248448E+00, .193534E+00,
     +  .149298E+00, .114162E+00, .865998E-01, .652043E-01,
     +  .487458E-01, .361628E-01, .266554E-01, .194448E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .140524E-01, .100504E-01, .710534E-02, .495867E-02,
     +  .341054E-02, .230747E-02, .153216E-02, .995946E-03,
     +  .630483E-03, .388768E-03, .230214E-03, .129927E-03,
     +  .686586E-04, .328998E-04, .139588E-04, .665574E-05,
     +  .448629E-05, .302705E-05, .203786E-05, .134621E-05,
     +  .850531E-06, .491478E-06, .243367E-06, .847208E-07,
     +  .769627E-08, .000000E+00, .190358E+06, .212612E+06,
     +  .161024E+06, .121960E+06, .923709E+05, .699605E+05,
     +  .529877E+05, .401336E+05, .303989E+05, .230268E+05,
     +  .174438E+05, .132157E+05, .100137E+05, .758855E+04,
     +  .575176E+04, .436043E+04, .330647E+04, .250795E+04,
     +  .190290E+04, .144434E+04, .109676E+04, .833217E+03,
     +  .633363E+03, .481740E+03, .366684E+03, .279315E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .212983E+03, .161957E+03, .123797E+03, .947603E+02,
     +  .726507E+02, .558023E+02, .429499E+02, .331617E+02,
     +  .256579E+02, .199152E+02, .155127E+02, .121306E+02,
     +  .952613E+01, .751381E+01, .595609E+01, .474357E+01,
     +  .379608E+01, .305202E+01, .246462E+01, .199794E+01,
     +  .162621E+01, .132488E+01, .108187E+01, .881824E+00,
     +  .717529E+00, .581174E+00, .467597E+00, .373035E+00,
     +  .294718E+00, .230483E+00, .178461E+00, .136906E+00,
     +  .104144E+00, .786148E-01, .589155E-01, .438453E-01,
     +  .323820E-01, .237639E-01, .172600E-01, .124200E-01,
     +  .884560E-02, .622811E-02, .432963E-02, .296726E-02,
     +  .200133E-02, .132578E-02, .860806E-03, .545332E-03,
     +  .337582E-03, .201812E-03, .116169E-03, .638890E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .333195E-04, .169923E-04, .101041E-04, .726267E-05,
     +  .517312E-05, .361546E-05, .243053E-05, .153032E-05,
     +  .864796E-06, .409370E-06, .133273E-06, .123829E-07,
     +  .000000E+00, .405740E+06, .310029E+06, .233295E+06,
     +  .175537E+06, .132057E+06, .993322E+05, .747061E+05,
     +  .561778E+05, .422399E+05, .317567E+05, .238733E+05,
     +  .179456E+05, .134892E+05, .101393E+05, .762135E+04,
     +  .572892E+04, .430676E+04, .323800E+04, .243489E+04,
     +  .183135E+04, .137782E+04, .103695E+04, .780751E+03,
     +  .588139E+03, .443325E+03, .334378E+03, .252453E+03,
     +  .190037E+03, .143812E+03, .108982E+03, .827196E+02,
     +  .629035E+02, .479353E+02, .366477E+02, .280788E+02,
     +  .215846E+02, .166537E+02, .129015E+02, .100389E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .784732E+01, .616591E+01, .486844E+01, .386310E+01,
     +  .308007E+01, .246680E+01, .198331E+01, .160110E+01,
     +  .129358E+01, .104747E+01, .846493E+00, .682854E+00,
     +  .548326E+00, .437425E+00, .346100E+00, .271308E+00,
     +  .210631E+00, .161987E+00, .123487E+00, .933825E-01,
     +  .700954E-01, .522463E-01, .386757E-01, .284123E-01,
     +  .207400E-01, .149821E-01, .107210E-01, .759160E-02,
     +  .531275E-02, .366922E-02, .249655E-02, .167002E-02,
     +  .109552E-02, .702748E-03, .438140E-03, .265357E-03,
     +  .153613E-03, .841056E-04, .425329E-04, .190337E-04,
     +  .724637E-05, .284102E-05, .150112E-05, .777804E-06,
     +  .415009E-06, .240654E-06, .153963E-06, .100556E-06,
     +  .596073E-07, .244100E-07, .209883E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .575693E+06, .437716E+06, .327461E+06, .244928E+06,
     +  .183144E+06, .136906E+06, .102314E+06, .764420E+05,
     +  .570975E+05, .426378E+05, .318326E+05, .237605E+05,
     +  .177320E+05, .132306E+05, .987059E+04, .736297E+04,
     +  .549202E+04, .409628E+04, .305532E+04, .227900E+04,
     +  .170018E+04, .126860E+04, .946856E+03, .706958E+03,
     +  .528109E+03, .394701E+03, .295262E+03, .220172E+03,
     +  .165062E+03, .123911E+03, .931658E+02, .701797E+02,
     +  .529768E+02, .401236E+02, .304561E+02, .231964E+02,
     +  .177346E+02, .136158E+02, .105014E+02, .813782E+01,
     +  .633993E+01, .496411E+01, .390673E+01, .308966E+01,
     +  .245465E+01, .195775E+01, .156784E+01, .125641E+01,
     +  .100905E+01, .808643E+00, .646840E+00, .515041E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .407465E+00, .319804E+00, .248775E+00, .191745E+00,
     +  .146469E+00, .110952E+00, .834025E-01, .622462E-01,
     +  .461388E-01, .339692E-01, .248199E-01, .180208E-01,
     +  .129480E-01, .921595E-02, .649134E-02, .451910E-02,
     +  .310528E-02, .210268E-02, .140037E-02, .915277E-03,
     +  .585692E-03, .364999E-03, .221752E-03, .129615E-03,
     +  .725628E-04, .385249E-04, .192646E-04, .945712E-05,
     +  .536445E-05, .360701E-05, .243289E-05, .163366E-05,
     +  .106903E-05, .661101E-06, .368607E-06, .171281E-06,
     +  .537434E-07, .502453E-08, .000000E+00, .793249E+06,
     +  .600396E+06, .446757E+06, .332334E+06, .247119E+06,
     +  .183682E+06, .136477E+06, .101364E+06, .752565E+05,
     +  .558524E+05, .414366E+05, .307308E+05, .227836E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .168862E+05, .125118E+05, .926809E+04, .686383E+04,
     +  .508225E+04, .376261E+04, .278534E+04, .206189E+04,
     +  .152638E+04, .113013E+04, .836918E+03, .620010E+03,
     +  .459476E+03, .340787E+03, .251895E+03, .187198E+03,
     +  .139293E+03, .103804E+03, .774995E+02, .579820E+02,
     +  .435256E+02, .327463E+02, .247219E+02, .187367E+02,
     +  .142618E+02, .109067E+02, .838152E+01, .647639E+01,
     +  .503012E+01, .392725E+01, .308150E+01, .242908E+01,
     +  .192225E+01, .152741E+01, .121429E+01, .967437E+00,
     +  .768975E+00, .610073E+00, .481790E+00, .378085E+00,
     +  .294425E+00, .227323E+00, .173977E+00, .132017E+00,
     +  .993804E-01, .742609E-01, .551073E-01, .406205E-01,
     +  .297432E-01, .216140E-01, .156086E-01, .111543E-01 /
        DATA (UPDI(I),I=4889,4940) /
     +  .789669E-02, .553259E-02, .383159E-02, .261965E-02,
     +  .176547E-02, .117084E-02, .762694E-03, .487097E-03,
     +  .303653E-03, .185262E-03, .109489E-03, .627364E-04,
     +  .348659E-04, .190243E-04, .107692E-04, .694141E-05,
     +  .492182E-05, .345319E-05, .236865E-05, .155356E-05,
     +  .946064E-06, .511420E-06, .226456E-06, .669277E-07,
     +  .638510E-08, .000000E+00, .106526E+07, .802871E+06,
     +  .594428E+06, .439932E+06, .325433E+06, .240615E+06,
     +  .177817E+06, .131344E+06, .969697E+05, .715570E+05,
     +  .527792E+05, .389108E+05, .286736E+05, .211203E+05,
     +  .155504E+05, .114448E+05, .842016E+04, .619279E+04,
     +  .455340E+04, .334717E+04, .246012E+04, .180793E+04,
     +  .132867E+04, .976501E+03, .717849E+03, .527810E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .388361E+03, .284714E+03, .209863E+03, .154871E+03,
     +  .114455E+03, .847370E+02, .628647E+02, .467957E+02,
     +  .349114E+02, .261367E+02, .196450E+02, .148307E+02,
     +  .112500E+02, .857628E+01, .657474E+01, .506685E+01,
     +  .392555E+01, .305673E+01, .239130E+01, .187797E+01,
     +  .148088E+01, .116817E+01, .923434E+00, .728163E+00,
     +  .573080E+00, .448968E+00, .349562E+00, .270141E+00,
     +  .207055E+00, .157373E+00, .118641E+00, .887618E-01,
     +  .659362E-01, .486518E-01, .356634E-01, .259710E-01,
     +  .187701E-01, .134819E-01, .958262E-02, .674775E-02,
     +  .470273E-02, .324017E-02, .220444E-02, .147892E-02,
     +  .976968E-03, .634544E-03, .404712E-03, .252598E-03,
     +  .154939E-03, .926929E-04, .543729E-04, .314981E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .183865E-04, .113468E-04, .775238E-05, .559092E-05,
     +  .395419E-05, .270868E-05, .175855E-05, .105135E-05,
     +  .553502E-06, .236215E-06, .668382E-07, .646598E-08,
     +  .000000E+00, .139840E+07, .104976E+07, .773546E+06,
     +  .569748E+06, .419404E+06, .308555E+06, .226873E+06,
     +  .166716E+06, .122440E+06, .898702E+05, .659262E+05,
     +  .483338E+05, .354162E+05, .259365E+05, .189841E+05,
     +  .138881E+05, .101552E+05, .742221E+04, .542257E+04,
     +  .396014E+04, .289132E+04, .211041E+04, .154025E+04,
     +  .112402E+04, .820366E+03, .598767E+03, .437301E+03,
     +  .318142E+03, .232711E+03, .170404E+03, .124950E+03,
     +  .917791E+02, .675497E+02, .498848E+02, .369204E+02,
     +  .274218E+02, .204486E+02, .153166E+02, .115287E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .872147E+01, .663548E+01, .507538E+01, .390299E+01,
     +  .301674E+01, .234265E+01, .182616E+01, .142933E+01,
     +  .111898E+01, .877804E+00, .686805E+00, .536318E+00,
     +  .416902E+00, .322113E+00, .247081E+00, .188035E+00,
     +  .141953E+00, .106333E+00, .790701E-01, .583946E-01,
     +  .428441E-01, .312329E-01, .226208E-01, .162602E-01,
     +  .116165E-01, .821257E-02, .575242E-02, .398827E-02,
     +  .273415E-02, .185138E-02, .123676E-02, .814097E-03,
     +  .527487E-03, .336222E-03, .210301E-03, .129829E-03,
     +  .787008E-04, .472483E-04, .284032E-04, .174691E-04,
     +  .113921E-04, .801653E-05, .580586E-05, .409788E-05,
     +  .278454E-05, .178302E-05, .104555E-05, .536654E-06,
     +  .221426E-06, .602784E-07, .590321E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .179899E+07, .134539E+07, .986932E+06, .723600E+06,
     +  .530190E+06, .388223E+06, .284084E+06, .207742E+06,
     +  .151815E+06, .110870E+06, .809136E+05, .590120E+05,
     +  .430104E+05, .313272E+05, .228031E+05, .165880E+05,
     +  .120597E+05, .876249E+04, .636349E+04, .461895E+04,
     +  .335133E+04, .243065E+04, .176248E+04, .127770E+04,
     +  .926251E+03, .671403E+03, .486935E+03, .351706E+03,
     +  .255414E+03, .185667E+03, .135140E+03, .985265E+02,
     +  .719730E+02, .527527E+02, .387489E+02, .285632E+02,
     +  .211401E+02, .157165E+02, .117422E+02, .881770E+01,
     +  .665993E+01, .505733E+01, .386122E+01, .296312E+01,
     +  .228455E+01, .176804E+01, .137382E+01, .106756E+01,
     +  .831230E+00, .645428E+00, .500171E+00, .385855E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .295901E+00, .225332E+00, .170293E+00, .127710E+00,
     +  .950634E-01, .702665E-01, .515940E-01, .376427E-01,
     +  .272906E-01, .196586E-01, .140548E-01, .998760E-02,
     +  .702360E-02, .489400E-02, .337590E-02, .230311E-02,
     +  .155249E-02, .103298E-02, .677834E-03, .438391E-03,
     +  .279469E-03, .175344E-03, .109057E-03, .670298E-04,
     +  .411526E-04, .255536E-04, .163615E-04, .110608E-04,
     +  .790048E-05, .571145E-05, .400503E-05, .269178E-05,
     +  .169748E-05, .975980E-06, .488658E-06, .195261E-06,
     +  .512972E-07, .508138E-08, .000000E+00, .227286E+07,
     +  .169369E+07, .123708E+07, .903055E+06, .658752E+06,
     +  .480195E+06, .349783E+06, .254601E+06, .185182E+06,
     +  .134590E+06, .977469E+05, .709356E+05, .514403E+05 /
        DATA (UPDI(I),I=5201,5252) /
     +  .372748E+05, .269906E+05, .195295E+05, .141212E+05,
     +  .102036E+05, .736822E+04, .531747E+04, .383551E+04,
     +  .276517E+04, .199281E+04, .143569E+04, .103419E+04,
     +  .744786E+03, .536611E+03, .384962E+03, .277672E+03,
     +  .200460E+03, .144893E+03, .104895E+03, .760818E+02,
     +  .553678E+02, .403790E+02, .295518E+02, .217154E+02,
     +  .160292E+02, .118910E+02, .886661E+01, .665006E+01,
     +  .501470E+01, .380212E+01, .289754E+01, .221844E+01,
     +  .170481E+01, .131532E+01, .101471E+01, .784318E+00,
     +  .604481E+00, .464954E+00, .356030E+00, .271040E+00,
     +  .204941E+00, .153832E+00, .114618E+00, .847916E-01,
     +  .623039E-01, .454867E-01, .330027E-01, .237966E-01,
     +  .170497E-01, .121245E-01, .857061E-02, .599569E-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .415642E-02, .285297E-02, .193728E-02, .130033E-02,
     +  .862068E-03, .564178E-03, .364436E-03, .232533E-03,
     +  .146476E-03, .918594E-04, .572626E-04, .359056E-04,
     +  .229244E-04, .151350E-04, .104741E-04, .753065E-05,
     +  .541612E-05, .376421E-05, .249863E-05, .155065E-05,
     +  .874080E-06, .427065E-06, .165466E-06, .420507E-07,
     +  .421106E-08, .000000E+00, .282523E+07, .209807E+07,
     +  .152612E+07, .110939E+07, .805836E+06, .584885E+06,
     +  .424182E+06, .307386E+06, .222569E+06, .161024E+06,
     +  .116401E+06, .840743E+05, .606752E+05, .437518E+05,
     +  .315231E+05, .226936E+05, .163245E+05, .117337E+05,
     +  .842782E+04, .604899E+04, .433893E+04, .311038E+04,
     +  .222866E+04, .159615E+04, .114288E+04, .818019E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .585716E+03, .417500E+03, .299210E+03, .214605E+03,
     +  .154095E+03, .110814E+03, .798349E+02, .577068E+02,
     +  .417985E+02, .303822E+02, .221734E+02, .162559E+02,
     +  .119774E+02, .887062E+01, .660829E+01, .494972E+01,
     +  .372766E+01, .282166E+01, .214571E+01, .163762E+01,
     +  .125474E+01, .961119E+00, .737591E+00, .564336E+00,
     +  .430915E+00, .327576E+00, .247603E+00, .185926E+00,
     +  .138632E+00, .102637E+00, .754673E-01, .551295E-01,
     +  .400220E-01, .288785E-01, .207106E-01, .147597E-01,
     +  .104406E-01, .734204E-02, .510990E-02, .352470E-02,
     +  .240780E-02, .162770E-02, .108820E-02, .719092E-03,
     +  .469585E-03, .303149E-03, .193746E-03, .122628E-03,
     +  .775895E-04, .490511E-04, .313600E-04, .204962E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .138471E-04, .972587E-05, .700222E-05, .499999E-05,
     +  .343928E-05, .225279E-05, .137535E-05, .760062E-06,
     +  .362504E-06, .136323E-06, .335824E-07, .339847E-08,
     +  .000000E+00, .346053E+07, .256138E+07, .185572E+07,
     +  .134356E+07, .971950E+06, .702536E+06, .507370E+06,
     +  .366105E+06, .263942E+06, .190119E+06, .136822E+06,
     +  .983773E+05, .706714E+05, .507220E+05, .363715E+05,
     +  .260575E+05, .186522E+05, .133397E+05, .953253E+04,
     +  .680638E+04, .485640E+04, .346258E+04, .246742E+04,
     +  .175727E+04, .125107E+04, .890256E+03, .633685E+03,
     +  .448947E+03, .319791E+03, .227950E+03, .162654E+03,
     +  .116230E+03, .832012E+02, .597537E+02, .430008E+02,
     +  .310528E+02, .225152E+02, .163990E+02, .120042E+02 /
        DATA (UPDI(I),I=5409,5460) /
     +  .883270E+01, .653735E+01, .486479E+01, .363984E+01,
     +  .273715E+01, .206770E+01, .156750E+01, .119289E+01,
     +  .907401E+00, .691494E+00, .525297E+00, .398247E+00,
     +  .300596E+00, .225628E+00, .168279E+00, .124657E+00,
     +  .917149E-01, .670339E-01, .486874E-01, .351486E-01,
     +  .252241E-01, .179933E-01, .127557E-01, .897607E-02,
     +  .627991E-02, .434873E-02, .298510E-02, .202981E-02,
     +  .136638E-02, .910142E-03, .599711E-03, .390971E-03,
     +  .252401E-03, .161690E-03, .102898E-03, .657110E-04,
     +  .421114E-04, .273980E-04, .182555E-04, .125435E-04,
     +  .888774E-05, .638578E-05, .452116E-05, .307520E-05,
     +  .198668E-05, .119293E-05, .646356E-06, .301019E-06,
     +  .109972E-06, .263083E-07, .268948E-08, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .264976E+05, .286100E+05, .227237E+05, .180482E+05,
     +  .143346E+05, .113849E+05, .904206E+04, .718124E+04,
     +  .570328E+04, .452943E+04, .359713E+04, .285668E+04,
     +  .226862E+04, .180160E+04, .143071E+04, .113617E+04,
     +  .902265E+03, .716526E+03, .569037E+03, .451924E+03,
     +  .358934E+03, .285102E+03, .226482E+03, .179942E+03,
     +  .142994E+03, .113662E+03, .903762E+02, .716579E+02,
     +  .570365E+02, .454274E+02, .362092E+02, .288884E+02,
     +  .230733E+02, .184650E+02, .147917E+02, .118708E+02,
     +  .954575E+01, .769254E+01, .621270E+01, .502775E+01,
     +  .407758E+01, .331180E+01, .269250E+01, .218955E+01,
     +  .177937E+01, .144361E+01, .116893E+01, .941767E+00,
     +  .756470E+00, .604264E+00, .481691E+00, .383991E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .307473E+00, .248543E+00, .203595E+00, .169146E+00,
     +  .142134E+00, .120179E+00, .101662E+00, .856180E-01,
     +  .715367E-01, .591688E-01, .483827E-01, .391226E-01,
     +  .311957E-01, .245499E-01, .190580E-01, .145852E-01,
     +  .109957E-01, .815798E-02, .594949E-02, .425880E-02,
     +  .298640E-02, .204620E-02, .137172E-02, .891773E-03,
     +  .561695E-03, .341186E-03, .198712E-03, .110164E-03,
     +  .575925E-04, .280806E-04, .124931E-04, .498821E-05,
     +  .172122E-05, .486629E-06, .103087E-06, .138365E-07,
     +  .807431E-09, .614140E-11, .000000E+00, .316156E+05,
     +  .447260E+05, .350116E+05, .274173E+05, .214774E+05,
     +  .168300E+05, .131925E+05, .103444E+05, .811379E+04,
     +  .636609E+04, .499635E+04, .392248E+04, .308030E+04 /
        DATA (UPDI(I),I=5565,5616) /
     +  .241962E+04, .190118E+04, .149423E+04, .117471E+04,
     +  .923761E+03, .726619E+03, .571704E+03, .449943E+03,
     +  .354217E+03, .278943E+03, .219737E+03, .173160E+03,
     +  .136508E+03, .107664E+03, .846729E+02, .668627E+02,
     +  .528350E+02, .417837E+02, .330750E+02, .262096E+02,
     +  .208098E+02, .165373E+02, .131650E+02, .105004E+02,
     +  .839219E+01, .672133E+01, .539357E+01, .433717E+01,
     +  .349260E+01, .281529E+01, .227004E+01, .182950E+01,
     +  .147234E+01, .118320E+01, .946602E+00, .755765E+00,
     +  .600721E+00, .477127E+00, .379428E+00, .303302E+00,
     +  .244718E+00, .199850E+00, .165203E+00, .137834E+00,
     +  .115522E+00, .967706E-01, .806770E-01, .667360E-01,
     +  .546691E-01, .442919E-01, .355023E-01, .280715E-01 /
        DATA (UPDI(I),I=5617,5668) /
     +  .219130E-01, .168776E-01, .128167E-01, .958759E-02,
     +  .705676E-02, .510328E-02, .361918E-02, .251163E-02,
     +  .169900E-02, .112056E-02, .712369E-03, .434281E-03,
     +  .250715E-03, .134000E-03, .633749E-04, .231397E-04,
     +  .242700E-05, .000000E+00, .173472E-17, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .865957E+05, .678346E+05,
     +  .525385E+05, .407074E+05, .315517E+05, .244638E+05,
     +  .189749E+05, .147227E+05, .114276E+05, .887306E+04,
     +  .689208E+04, .535529E+04, .416267E+04, .323682E+04,
     +  .251780E+04, .195922E+04, .152512E+04, .118763E+04,
     +  .925177E+03, .720991E+03, .562089E+03, .438381E+03,
     +  .342044E+03, .266992E+03, .208507E+03, .162910E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .127358E+03, .992791E+02, .777229E+02, .608940E+02,
     +  .477508E+02, .374821E+02, .294551E+02, .231939E+02,
     +  .182806E+02, .144337E+02, .114187E+02, .905213E+01,
     +  .719139E+01, .572443E+01, .456656E+01, .364828E+01,
     +  .291786E+01, .233475E+01, .186768E+01, .149232E+01,
     +  .119124E+01, .947133E+00, .752101E+00, .595091E+00,
     +  .470970E+00, .373513E+00, .297895E+00, .239756E+00,
     +  .195126E+00, .160513E+00, .133071E+00, .110694E+00,
     +  .919702E-01, .760326E-01, .623727E-01, .506850E-01,
     +  .407459E-01, .324180E-01, .254488E-01, .197274E-01,
     +  .150908E-01, .113827E-01, .845740E-02, .618211E-02,
     +  .443871E-02, .312372E-02, .214965E-02, .143989E-02,
     +  .938427E-03, .587382E-03, .350345E-03, .195570E-03 /
        DATA (UPDI(I),I=5721,5772) /
     +  .985315E-04, .410643E-04, .940322E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .131000E+06, .101835E+06, .781811E+05,
     +  .600392E+05, .461185E+05, .354345E+05, .272327E+05,
     +  .209350E+05, .160982E+05, .123824E+05, .952715E+04,
     +  .733249E+04, .564517E+04, .434752E+04, .334927E+04,
     +  .258111E+04, .198984E+04, .153456E+04, .118391E+04,
     +  .913732E+03, .705506E+03, .544961E+03, .421144E+03,
     +  .325612E+03, .251884E+03, .194949E+03, .150985E+03,
     +  .116592E+03, .904393E+02, .702122E+02, .545610E+02,
     +  .424449E+02, .330595E+02, .258041E+02, .201610E+02,
     +  .157814E+02, .123784E+02, .973017E+01, .766559E+01 /
        DATA (UPDI(I),I=5773,5824) /
     +  .605160E+01, .478834E+01, .379484E+01, .301125E+01,
     +  .239101E+01, .189850E+01, .150615E+01, .119427E+01,
     +  .943675E+00, .745273E+00, .586929E+00, .462732E+00,
     +  .365830E+00, .290949E+00, .233452E+00, .189254E+00,
     +  .154886E+00, .127591E+00, .105361E+00, .868521E-01,
     +  .712253E-01, .579650E-01, .467402E-01, .372940E-01,
     +  .294593E-01, .229660E-01, .176838E-01, .134403E-01,
     +  .100744E-01, .744016E-02, .540694E-02, .386058E-02,
     +  .270286E-02, .185148E-02, .123541E-02, .803160E-03,
     +  .502606E-03, .300956E-03, .170057E-03, .883707E-04,
     +  .400978E-04, .134447E-04, .120534E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .193129E+06, .149182E+06, .113693E+06, .866603E+05,
     +  .660624E+05, .503662E+05, .384044E+05, .292875E+05,
     +  .223383E+05, .170408E+05, .130018E+05, .992204E+04,
     +  .757333E+04, .578185E+04, .441520E+04, .337241E+04,
     +  .257662E+04, .196917E+04, .150541E+04, .115125E+04,
     +  .880732E+03, .674038E+03, .516078E+03, .395313E+03,
     +  .302967E+03, .232309E+03, .178256E+03, .136364E+03,
     +  .104804E+03, .806210E+02, .620806E+02, .478592E+02,
     +  .369428E+02, .285801E+02, .221337E+02, .171750E+02,
     +  .133558E+02, .104095E+02, .813218E+01, .636703E+01,
     +  .499711E+01, .392879E+01, .309328E+01, .243754E+01,
     +  .192128E+01, .151355E+01, .119226E+01, .936349E+00,
     +  .735485E+00, .576487E+00, .452694E+00, .356680E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .282774E+00, .226113E+00, .182534E+00, .148601E+00,
     +  .121643E+00, .997374E-01, .815979E-01, .664034E-01,
     +  .536306E-01, .429256E-01, .340041E-01, .266749E-01,
     +  .206555E-01, .158011E-01, .119334E-01, .888997E-02,
     +  .652630E-02, .471550E-02, .334831E-02, .233215E-02,
     +  .159017E-02, .105694E-02, .685391E-03, .428755E-03,
     +  .257658E-03, .147219E-03, .786085E-04, .381240E-04,
     +  .157301E-04, .538837E-05, .302731E-05, .203786E-05,
     +  .134621E-05, .850531E-06, .491478E-06, .243367E-06,
     +  .847208E-07, .769627E-08, .000000E+00, .190338E+06,
     +  .212517E+06, .160941E+06, .121886E+06, .923055E+05,
     +  .699026E+05, .529365E+05, .400883E+05, .303589E+05,
     +  .229914E+05, .174126E+05, .131881E+05, .998930E+04 /
        DATA (UPDI(I),I=5929,5980) /
     +  .756702E+04, .573275E+04, .434366E+04, .329168E+04,
     +  .249490E+04, .189139E+04, .143420E+04, .108783E+04,
     +  .825353E+03, .626440E+03, .475647E+03, .361324E+03,
     +  .274600E+03, .208837E+03, .158318E+03, .120597E+03,
     +  .919458E+02, .701742E+02, .536219E+02, .410280E+02,
     +  .314648E+02, .241572E+02, .185849E+02, .143300E+02,
     +  .110755E+02, .858132E+01, .666421E+01, .518872E+01,
     +  .404759E+01, .316250E+01, .247360E+01, .193575E+01,
     +  .151449E+01, .118535E+01, .925357E+00, .722969E+00,
     +  .564004E+00, .441094E+00, .346296E+00, .273602E+00,
     +  .217967E+00, .175183E+00, .141857E+00, .115400E+00,
     +  .939686E-01, .763217E-01, .616532E-01, .494316E-01,
     +  .392836E-01, .309034E-01, .240803E-01, .185246E-01 /
        DATA (UPDI(I),I=5981,6032) /
     +  .140810E-01, .105686E-01, .782588E-02, .571152E-02,
     +  .410342E-02, .289789E-02, .200822E-02, .136311E-02,
     +  .902606E-03, .583885E-03, .365156E-03, .220217E-03,
     +  .127155E-03, .695641E-04, .356037E-04, .167653E-04,
     +  .791319E-05, .517337E-05, .361546E-05, .243053E-05,
     +  .153032E-05, .864796E-06, .409370E-06, .133273E-06,
     +  .123829E-07, .000000E+00, .405627E+06, .309929E+06,
     +  .233206E+06, .175459E+06, .131988E+06, .992710E+05,
     +  .746520E+05, .561299E+05, .421976E+05, .317193E+05,
     +  .238403E+05, .179165E+05, .134635E+05, .101165E+05,
     +  .760130E+04, .571124E+04, .429117E+04, .322426E+04,
     +  .242279E+04, .182069E+04, .136843E+04, .102869E+04,
     +  .773485E+03, .581750E+03, .437709E+03, .329442E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .248117E+03, .186235E+03, .140473E+03, .106048E+03,
     +  .801411E+02, .606361E+02, .459396E+02, .348883E+02,
     +  .265255E+02, .202103E+02, .154345E+02, .118166E+02,
     +  .907027E+01, .697924E+01, .538501E+01, .416354E+01,
     +  .322497E+01, .250126E+01, .194153E+01, .150723E+01,
     +  .117109E+01, .908020E+00, .705104E+00, .547078E+00,
     +  .425818E+00, .332863E+00, .261882E+00, .207680E+00,
     +  .166030E+00, .133607E+00, .107916E+00, .871931E-01,
     +  .702446E-01, .562783E-01, .447547E-01, .352825E-01,
     +  .275377E-01, .212930E-01, .162556E-01, .122629E-01,
     +  .913423E-02, .671163E-02, .485945E-02, .346221E-02,
     +  .242324E-02, .166281E-02, .111614E-02, .729294E-03,
     +  .464122E-03, .284090E-03, .166306E-03, .918750E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .468028E-04, .210674E-04, .757245E-05, .195552E-05,
     +  .778021E-06, .415009E-06, .240654E-06, .153963E-06,
     +  .100556E-06, .596073E-07, .244100E-07, .209883E-08,
     +  .000000E+00, .575573E+06, .437610E+06, .327367E+06,
     +  .244845E+06, .183070E+06, .136841E+06, .102257E+06,
     +  .763914E+05, .570528E+05, .425983E+05, .317978E+05,
     +  .237298E+05, .177048E+05, .132067E+05, .984946E+04,
     +  .734434E+04, .547560E+04, .408182E+04, .304259E+04,
     +  .226780E+04, .169033E+04, .125993E+04, .939239E+03,
     +  .700266E+03, .522233E+03, .389540E+03, .290733E+03,
     +  .216206E+03, .161582E+03, .120857E+03, .904856E+02,
     +  .678262E+02, .509085E+02, .383033E+02, .288520E+02,
     +  .217802E+02, .164812E+02, .125035E+02, .951148E+01 /
        DATA (UPDI(I),I=6137,6188) /
     +  .725394E+01, .554822E+01, .425302E+01, .326670E+01,
     +  .251298E+01, .193527E+01, .149104E+01, .115029E+01,
     +  .885967E+00, .683842E+00, .527699E+00, .408740E+00,
     +  .318081E+00, .249143E+00, .196633E+00, .156342E+00,
     +  .125021E+00, .100270E+00, .804000E-01, .642602E-01,
     +  .510723E-01, .402925E-01, .315172E-01, .244107E-01,
     +  .187345E-01, .141975E-01, .106332E-01, .786435E-02,
     +  .573842E-02, .412650E-02, .292041E-02, .203085E-02,
     +  .138505E-02, .924530E-03, .601225E-03, .381378E-03,
     +  .233275E-03, .137101E-03, .767261E-04, .403469E-04,
     +  .195978E-04, .866525E-05, .391770E-05, .243307E-05,
     +  .163366E-05, .106903E-05, .661101E-06, .368607E-06,
     +  .171281E-06, .537434E-07, .502453E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .793122E+06, .600283E+06, .446658E+06, .332246E+06,
     +  .247042E+06, .183614E+06, .136416E+06, .101310E+06,
     +  .752092E+05, .558107E+05, .413998E+05, .306983E+05,
     +  .227549E+05, .168609E+05, .124895E+05, .924847E+04,
     +  .684655E+04, .506704E+04, .374924E+04, .277358E+04,
     +  .205155E+04, .151730E+04, .112216E+04, .829917E+03,
     +  .613867E+03, .454087E+03, .336063E+03, .247763E+03,
     +  .183577E+03, .136120E+03, .101023E+03, .750611E+02,
     +  .558427E+02, .416462E+02, .310936E+02, .232661E+02,
     +  .174517E+02, .131248E+02, .989817E+01, .748459E+01,
     +  .567661E+01, .431552E+01, .328790E+01, .250936E+01,
     +  .191775E+01, .146672E+01, .112374E+01, .859914E+00,
     +  .659821E+00, .506426E+00, .390352E+00, .302381E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .235761E+00, .185156E+00, .146401E+00, .116337E+00,
     +  .926581E-01, .737456E-01, .584893E-01, .461255E-01,
     +  .361099E-01, .280316E-01, .215491E-01, .164181E-01,
     +  .123527E-01, .918643E-02, .674726E-02, .488983E-02,
     +  .349287E-02, .245596E-02, .169726E-02, .115083E-02,
     +  .764234E-03, .494921E-03, .313194E-03, .191670E-03,
     +  .113292E-03, .643625E-04, .349751E-04, .181845E-04,
     +  .924083E-05, .513394E-05, .345334E-05, .236865E-05,
     +  .155356E-05, .946064E-06, .511420E-06, .226456E-06,
     +  .669277E-07, .638510E-08, .000000E+00, .106513E+07,
     +  .802752E+06, .594323E+06, .439840E+06, .325351E+06,
     +  .240543E+06, .177753E+06, .131287E+06, .969198E+05,
     +  .715130E+05, .527404E+05, .388765E+05, .286434E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .210937E+05, .155270E+05, .114242E+05, .840201E+04,
     +  .617682E+04, .453936E+04, .333483E+04, .244928E+04,
     +  .179842E+04, .132032E+04, .969183E+03, .711436E+03,
     +  .522189E+03, .383440E+03, .280415E+03, .206101E+03,
     +  .151579E+03, .111574E+03, .822152E+02, .606563E+02,
     +  .448594E+02, .332125E+02, .246438E+02, .183310E+02,
     +  .136717E+02, .102257E+02, .766907E+01, .576962E+01,
     +  .435137E+01, .328936E+01, .249136E+01, .188996E+01,
     +  .143523E+01, .109226E+01, .830559E+00, .633625E+00,
     +  .483740E+00, .371051E+00, .286098E+00, .222022E+00,
     +  .173491E+00, .136410E+00, .107720E+00, .852087E-01,
     +  .673253E-01, .529984E-01, .414806E-01, .322306E-01,
     +  .248357E-01, .189536E-01, .143380E-01, .107121E-01 /
        DATA (UPDI(I),I=6345,6396) /
     +  .791143E-02, .577148E-02, .415493E-02, .294872E-02,
     +  .206039E-02, .141544E-02, .954523E-03, .630914E-03,
     +  .407155E-03, .257267E-03, .157714E-03, .938884E-04,
     +  .542146E-04, .304160E-04, .167532E-04, .935353E-05,
     +  .573573E-05, .395431E-05, .270868E-05, .175855E-05,
     +  .105135E-05, .553502E-06, .236215E-06, .668382E-07,
     +  .646598E-08, .000000E+00, .139825E+07, .104964E+07,
     +  .773435E+06, .569650E+06, .419317E+06, .308478E+06,
     +  .226805E+06, .166657E+06, .122387E+06, .898237E+05,
     +  .658853E+05, .482977E+05, .353844E+05, .259084E+05,
     +  .189595E+05, .138664E+05, .101362E+05, .740545E+04,
     +  .540784E+04, .394721E+04, .287997E+04, .210046E+04,
     +  .153153E+04, .111639E+04, .813678E+03, .592913E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .432182E+03, .313675E+03, .228808E+03, .166993E+03,
     +  .121971E+03, .891759E+02, .652744E+02, .478941E+02,
     +  .351779E+02, .258946E+02, .191084E+02, .141385E+02,
     +  .104915E+02, .780678E+01, .582773E+01, .436156E+01,
     +  .327227E+01, .246021E+01, .185304E+01, .139754E+01,
     +  .105668E+01, .798589E+00, .605805E+00, .460085E+00,
     +  .351195E+00, .269523E+00, .208167E+00, .161836E+00,
     +  .126530E+00, .992976E-01, .780179E-01, .612067E-01,
     +  .478310E-01, .371618E-01, .286645E-01, .219291E-01,
     +  .166166E-01, .124830E-01, .926223E-02, .679459E-02,
     +  .492402E-02, .352196E-02, .248385E-02, .172514E-02,
     +  .117847E-02, .790714E-03, .520477E-03, .334949E-03,
     +  .211519E-03, .130041E-03, .780669E-04, .458534E-04 /
        DATA (UPDI(I),I=6449,6500) /
     +  .265135E-04, .153232E-04, .913107E-05, .590472E-05,
     +  .409797E-05, .278454E-05, .178302E-05, .104555E-05,
     +  .536654E-06, .221426E-06, .602784E-07, .590321E-08,
     +  .000000E+00, .179883E+07, .134526E+07, .986814E+06,
     +  .723496E+06, .530098E+06, .388142E+06, .284013E+06,
     +  .207679E+06, .151759E+06, .110821E+06, .808705E+05,
     +  .589740E+05, .429770E+05, .312977E+05, .227772E+05,
     +  .165652E+05, .120397E+05, .874491E+04, .634805E+04,
     +  .460541E+04, .333946E+04, .242025E+04, .175337E+04,
     +  .126974E+04, .919285E+03, .665314E+03, .481616E+03,
     +  .347073E+03, .251371E+03, .182140E+03, .132064E+03,
     +  .958441E+02, .696333E+02, .507103E+02, .369656E+02,
     +  .270048E+02, .197766E+02, .145222E+02, .106949E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .789834E+01, .585219E+01, .434762E+01, .323818E+01,
     +  .241731E+01, .180819E+01, .135467E+01, .101783E+01,
     +  .764650E+00, .576868E+00, .435856E+00, .331097E+00,
     +  .252906E+00, .194395E+00, .150353E+00, .116890E+00,
     +  .911665E-01, .711546E-01, .554347E-01, .430123E-01,
     +  .331790E-01, .254105E-01, .193033E-01, .145256E-01,
     +  .108382E-01, .798793E-02, .582127E-02, .419152E-02,
     +  .297925E-02, .208840E-02, .144216E-02, .979951E-03,
     +  .654484E-03, .429262E-03, .275679E-03, .174146E-03,
     +  .107487E-03, .651363E-04, .389246E-04, .231416E-04,
     +  .139122E-04, .867604E-05, .577895E-05, .400510E-05,
     +  .269178E-05, .169748E-05, .975980E-06, .488658E-06,
     +  .195261E-06, .512972E-07, .508138E-08, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .227271E+07, .169355E+07, .123696E+07, .902945E+06,
     +  .658656E+06, .480110E+06, .349708E+06, .254534E+06,
     +  .185124E+06, .134538E+06, .977014E+05, .708956E+05,
     +  .514051E+05, .372439E+05, .269634E+05, .195056E+05,
     +  .141002E+05, .101851E+05, .735207E+04, .530331E+04,
     +  .382311E+04, .275432E+04, .198332E+04, .142740E+04,
     +  .102694E+04, .738461E+03, .531094E+03, .380163E+03,
     +  .273490E+03, .196819E+03, .141723E+03, .102136E+03,
     +  .736807E+02, .532769E+02, .385581E+02, .279652E+02,
     +  .203319E+02, .148219E+02, .108367E+02, .794536E+01,
     +  .584490E+01, .431141E+01, .318877E+01, .236413E+01,
     +  .175664E+01, .130759E+01, .976479E+00, .729334E+00,
     +  .547269E+00, .411400E+00, .311022E+00, .236455E+00 /
        DATA (UPDI(I),I=6605,6656) /
     +  .180871E+00, .139170E+00, .107587E+00, .833967E-01,
     +  .646652E-01, .500358E-01, .385533E-01, .295316E-01,
     +  .224601E-01, .169450E-01, .126646E-01, .938699E-02,
     +  .687308E-02, .497669E-02, .356095E-02, .251569E-02,
     +  .175320E-02, .120408E-02, .814136E-03, .541477E-03,
     +  .354074E-03, .227089E-03, .143623E-03, .890815E-04,
     +  .545301E-04, .331443E-04, .202036E-04, .125378E-04,
     +  .807016E-05, .546220E-05, .376426E-05, .249863E-05,
     +  .155065E-05, .874080E-06, .427065E-06, .165466E-06,
     +  .420507E-07, .421106E-08, .000000E+00, .282507E+07,
     +  .209792E+07, .152599E+07, .110927E+07, .805734E+06,
     +  .584795E+06, .424102E+06, .307316E+06, .222508E+06,
     +  .160969E+06, .116353E+06, .840322E+05, .606382E+05 /
        DATA (UPDI(I),I=6657,6708) /
     +  .437193E+05, .314945E+05, .226686E+05, .163025E+05,
     +  .117144E+05, .841093E+04, .603420E+04, .432598E+04,
     +  .309906E+04, .221877E+04, .158752E+04, .113535E+04,
     +  .811456E+03, .580001E+03, .412535E+03, .294892E+03,
     +  .210851E+03, .150834E+03, .107982E+03, .773755E+02,
     +  .555705E+02, .399433E+02, .287706E+02, .207730E+02,
     +  .150385E+02, .109188E+02, .795018E+01, .580817E+01,
     +  .425505E+01, .312586E+01, .230215E+01, .169958E+01,
     +  .125724E+01, .933328E+00, .693176E+00, .517403E+00,
     +  .387011E+00, .291193E+00, .220337E+00, .167723E+00,
     +  .128384E+00, .986899E-01, .760359E-01, .585780E-01,
     +  .450226E-01, .344543E-01, .262114E-01, .197995E-01,
     +  .148374E-01, .110160E-01, .811208E-02, .590160E-02 /
        DATA (UPDI(I),I=6709,6760) /
     +  .424652E-02, .302001E-02, .212101E-02, .146990E-02,
     +  .100430E-02, .675955E-03, .447912E-03, .292179E-03,
     +  .187276E-03, .118680E-03, .740274E-04, .457921E-04,
     +  .282888E-04, .176260E-04, .112163E-04, .737740E-05,
     +  .503145E-05, .343932E-05, .225279E-05, .137535E-05,
     +  .760062E-06, .362504E-06, .136323E-06, .335824E-07,
     +  .339847E-08, .000000E+00, .346036E+07, .256122E+07,
     +  .185558E+07, .134343E+07, .971842E+06, .702441E+06,
     +  .507286E+06, .366031E+06, .263877E+06, .190062E+06,
     +  .136772E+06, .983331E+05, .706325E+05, .506878E+05,
     +  .363416E+05, .260313E+05, .186292E+05, .133195E+05,
     +  .951488E+04, .679094E+04, .484291E+04, .345080E+04,
     +  .245713E+04, .174830E+04, .124326E+04, .883456E+03 /
        DATA (UPDI(I),I=6761,6812) /
     +  .627772E+03, .443819E+03, .315339E+03, .224088E+03,
     +  .159305E+03, .113327E+03, .806870E+02, .575756E+02,
     +  .411148E+02, .294198E+02, .211013E+02, .151747E+02,
     +  .109444E+02, .791571E+01, .574464E+01, .418076E+01,
     +  .305127E+01, .223284E+01, .163812E+01, .120447E+01,
     +  .889018E+00, .656642E+00, .487613E+00, .362938E+00,
     +  .271790E+00, .204687E+00, .155050E+00, .118066E+00,
     +  .902488E-01, .691137E-01, .529068E-01, .403965E-01,
     +  .307075E-01, .232045E-01, .174116E-01, .129623E-01,
     +  .956133E-02, .699622E-02, .505798E-02, .361730E-02,
     +  .255732E-02, .178589E-02, .123106E-02, .837025E-03,
     +  .561010E-03, .370545E-03, .241263E-03, .154649E-03,
     +  .982685E-04, .616788E-04, .385579E-04, .241831E-04 /
        DATA (UPDI(I),I=6813,6864) /
     +  .153540E-04, .996216E-05, .664662E-05, .454265E-05,
     +  .307523E-05, .198668E-05, .119293E-05, .646356E-06,
     +  .301019E-06, .109972E-06, .263083E-07, .268948E-08,
     +  .000000E+00, .158142E+07, .122471E+07, .936100E+06,
     +  .715571E+06, .547053E+06, .418269E+06, .319842E+06,
     +  .244609E+06, .187098E+06, .143131E+06, .109514E+06,
     +  .838070E+05, .641469E+05, .491090E+05, .376050E+05,
     +  .288029E+05, .220671E+05, .169116E+05, .129648E+05,
     +  .994270E+04, .762815E+04, .585505E+04, .449636E+04,
     +  .345493E+04, .265643E+04, .204396E+04, .157401E+04,
     +  .120880E+04, .932880E+03, .720833E+03, .557774E+03,
     +  .432301E+03, .335675E+03, .261395E+03, .203926E+03,
     +  .159550E+03, .125234E+03, .986491E+02, .780110E+02 /
        DATA (UPDI(I),I=6865,6916) /
     +  .619427E+02, .494140E+02, .395959E+02, .318764E+02,
     +  .257809E+02, .209458E+02, .170923E+02, .140159E+02,
     +  .115234E+02, .951822E+01, .787724E+01, .654134E+01,
     +  .544441E+01, .453990E+01, .379107E+01, .316892E+01,
     +  .265036E+01, .221697E+01, .185394E+01, .154928E+01,
     +  .129325E+01, .107788E+01, .896607E+00, .744005E+00,
     +  .616119E+00, .507897E+00, .417036E+00, .340880E+00,
     +  .277194E+00, .224087E+00, .179953E+00, .143430E+00,
     +  .113351E+00, .887092E-01, .686388E-01, .525642E-01,
     +  .396159E-01, .293755E-01, .213743E-01, .152118E-01,
     +  .105459E-01, .708501E-02, .458486E-02, .282289E-02,
     +  .163917E-02, .879093E-03, .422881E-03, .173732E-03,
     +  .556006E-04, .112760E-04, .748728E-06, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .302250E+07, .233341E+07, .177686E+07, .135285E+07,
     +  .102986E+07, .783855E+06, .596513E+06, .453865E+06,
     +  .345266E+06, .262600E+06, .199687E+06, .151815E+06,
     +  .115395E+06, .876924E+05, .666256E+05, .506080E+05,
     +  .384327E+05, .291797E+05, .221497E+05, .168097E+05,
     +  .127548E+05, .967617E+04, .733973E+04, .556679E+04,
     +  .422202E+04, .320189E+04, .242872E+04, .183544E+04,
     +  .139322E+04, .105811E+04, .804187E+03, .611806E+03,
     +  .466023E+03, .355827E+03, .272049E+03, .208520E+03,
     +  .160302E+03, .123656E+03, .957585E+02, .744639E+02,
     +  .581889E+02, .456878E+02, .360536E+02, .285958E+02,
     +  .227960E+02, .182609E+02, .147094E+02, .118839E+02,
     +  .965226E+01, .785799E+01, .642237E+01, .526327E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .432308E+01, .355714E+01, .293068E+01, .241654E+01,
     +  .199330E+01, .164401E+01, .135517E+01, .111595E+01,
     +  .917608E+00, .753095E+00, .616496E+00, .503643E+00,
     +  .409502E+00, .331597E+00, .267247E+00, .214221E+00,
     +  .170661E+00, .135011E+00, .105963E+00, .824194E-01,
     +  .634617E-01, .482715E-01, .363200E-01, .268692E-01,
     +  .195385E-01, .139266E-01, .969664E-02, .656728E-02,
     +  .430151E-02, .270853E-02, .161803E-02, .908638E-03,
     +  .469247E-03, .216144E-03, .843912E-04, .253830E-04,
     +  .481793E-05, .318389E-06, .000000E+00, .480375E+07,
     +  .369377E+07, .279959E+07, .212120E+07, .160669E+07,
     +  .121658E+07, .920870E+06, .696787E+06, .527036E+06,
     +  .398484E+06, .301168E+06, .227521E+06, .171810E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .129682E+06, .978393E+05, .737797E+05, .556101E+05,
     +  .418939E+05, .315454E+05, .237409E+05, .178587E+05,
     +  .134271E+05, .100906E+05, .757972E+04, .569150E+04,
     +  .427161E+04, .320552E+04, .239531E+04, .179739E+04,
     +  .134891E+04, .101268E+04, .760731E+03, .571953E+03,
     +  .430917E+03, .324978E+03, .245634E+03, .186172E+03,
     +  .141565E+03, .108053E+03, .828137E+02, .637839E+02,
     +  .493651E+02, .384040E+02, .300346E+02, .236142E+02,
     +  .186608E+02, .148336E+02, .118284E+02, .948583E+01,
     +  .762643E+01, .615745E+01, .498610E+01, .404756E+01,
     +  .329216E+01, .268165E+01, .218646E+01, .178355E+01,
     +  .145486E+01, .118616E+01, .966148E+00, .785800E+00,
     +  .637917E+00, .516483E+00, .417299E+00, .335507E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .268603E+00, .213989E+00, .169520E+00, .133433E+00,
     +  .104263E+00, .807960E-01, .620253E-01, .471181E-01,
     +  .353358E-01, .262003E-01, .190856E-01, .136546E-01,
     +  .956685E-02, .654041E-02, .434384E-02, .278544E-02,
     +  .171415E-02, .998379E-03, .545134E-03, .272740E-03,
     +  .121145E-03, .453311E-04, .129588E-04, .233037E-05,
     +  .150474E-06, .000000E+00, .717986E+07, .549720E+07,
     +  .414552E+07, .312484E+07, .235443E+07, .177315E+07,
     +  .133474E+07, .100423E+07, .755178E+06, .567587E+06,
     +  .426361E+06, .320089E+06, .240165E+06, .180086E+06,
     +  .134952E+06, .101063E+06, .756338E+05, .565637E+05,
     +  .422730E+05, .315698E+05, .235603E+05, .175699E+05,
     +  .130938E+05, .975104E+04, .725715E+04, .539689E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .401203E+04, .296865E+04, .220551E+04, .163831E+04,
     +  .121704E+04, .904403E+03, .672453E+03, .500914E+03,
     +  .373395E+03, .278900E+03, .208850E+03, .156879E+03,
     +  .118273E+03, .895274E+02, .681025E+02, .520564E+02,
     +  .400000E+02, .309015E+02, .240030E+02, .187419E+02,
     +  .147240E+02, .116048E+02, .920115E+01, .731462E+01,
     +  .584078E+01, .467847E+01, .375730E+01, .302385E+01,
     +  .243742E+01, .196680E+01, .158791E+01, .128206E+01,
     +  .103464E+01, .834168E+00, .671557E+00, .539613E+00,
     +  .432387E+00, .345733E+00, .275035E+00, .217833E+00,
     +  .171650E+00, .134467E+00, .104637E+00, .808054E-01,
     +  .618630E-01, .468994E-01, .351690E-01, .260185E-01,
     +  .190216E-01, .136513E-01, .961433E-02, .662466E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .444907E-02, .289888E-02, .182061E-02, .109536E-02,
     +  .622153E-03, .330330E-03, .160097E-03, .685440E-04,
     +  .245590E-04, .666291E-05, .113088E-05, .695051E-07,
     +  .000000E+00, .102251E+08, .779556E+07, .584947E+07,
     +  .438686E+07, .328818E+07, .246327E+07, .184424E+07,
     +  .137994E+07, .103189E+07, .771116E+06, .575861E+06,
     +  .429746E+06, .320476E+06, .238810E+06, .177819E+06,
     +  .132299E+06, .983521E+05, .730537E+05, .542170E+05,
     +  .402014E+05, .297833E+05, .220449E+05, .163031E+05,
     +  .120459E+05, .889301E+04, .655871E+04, .483454E+04,
     +  .354581E+04, .261089E+04, .192175E+04, .141426E+04,
     +  .104090E+04, .766354E+03, .565152E+03, .416967E+03,
     +  .308197E+03, .228343E+03, .169677E+03, .126533E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .947306E+02, .712690E+02, .538774E+02, .409447E+02,
     +  .312858E+02, .240381E+02, .185676E+02, .144327E+02,
     +  .112554E+02, .883198E+01, .694917E+01, .549303E+01,
     +  .435611E+01, .346397E+01, .276062E+01, .220375E+01,
     +  .176119E+01, .140835E+01, .112628E+01, .900306E+00,
     +  .718972E+00, .573314E+00, .456272E+00, .362075E+00,
     +  .286701E+00, .225818E+00, .177055E+00, .138091E+00,
     +  .107048E+00, .824089E-01, .629404E-01, .476400E-01,
     +  .356943E-01, .264422E-01, .193140E-01, .139343E-01,
     +  .986113E-02, .684312E-02, .464185E-02, .306572E-02,
     +  .196192E-02, .120835E-02, .711731E-03, .394838E-03,
     +  .204208E-03, .960696E-04, .397439E-04, .136777E-04,
     +  .353678E-05, .568242E-06, .319989E-07, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .140118E+08, .106387E+08, .794425E+07, .592856E+07,
     +  .442154E+07, .329545E+07, .245451E+07, .182688E+07,
     +  .135876E+07, .100984E+07, .749938E+06, .556479E+06,
     +  .412586E+06, .305637E+06, .226212E+06, .167273E+06,
     +  .123575E+06, .912036E+05, .672467E+05, .495315E+05,
     +  .364466E+05, .267897E+05, .196718E+05, .144295E+05,
     +  .105737E+05, .773888E+04, .566021E+04, .411793E+04,
     +  .300751E+04, .219527E+04, .160180E+04, .116866E+04,
     +  .852752E+03, .623162E+03, .455501E+03, .333499E+03,
     +  .244717E+03, .180075E+03, .132966E+03, .985591E+02,
     +  .734102E+02, .549413E+02, .413361E+02, .312702E+02,
     +  .237883E+02, .181936E+02, .140047E+02, .108158E+02,
     +  .840636E+01, .655169E+01, .513055E+01, .403111E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .317625E+01, .250840E+01, .198440E+01, .157173E+01,
     +  .124567E+01, .987351E+00, .782255E+00, .619159E+00,
     +  .489333E+00, .385955E+00, .303508E+00, .238143E+00,
     +  .185836E+00, .144338E+00, .111497E+00, .855886E-01,
     +  .652304E-01, .493089E-01, .369277E-01, .273662E-01,
     +  .200436E-01, .144671E-01, .103095E-01, .720155E-02,
     +  .492936E-02, .329541E-02, .214296E-02, .134874E-02,
     +  .815842E-03, .471215E-03, .255796E-03, .129146E-03,
     +  .591245E-04, .237072E-04, .786669E-05, .194837E-05,
     +  .297183E-06, .145608E-07, .000000E+00, .192796E+08,
     +  .145712E+08, .108218E+08, .803151E+07, .595641E+07,
     +  .441417E+07, .326874E+07, .241862E+07, .178813E+07,
     +  .132087E+07, .974861E+06, .718831E+06, .529549E+06 /
        DATA (UPDI(I),I=7385,7436) /
     +  .389726E+06, .286537E+06, .210449E+06, .154403E+06,
     +  .113157E+06, .828371E+05, .605702E+05, .442380E+05,
     +  .322701E+05, .235127E+05, .171104E+05, .124370E+05,
     +  .902726E+04, .654691E+04, .472141E+04, .341792E+04,
     +  .247240E+04, .178743E+04, .129186E+04, .933607E+03,
     +  .675591E+03, .488903E+03, .354324E+03, .257322E+03,
     +  .187374E+03, .136896E+03, .100392E+03, .739764E+02,
     +  .547710E+02, .407657E+02, .305086E+02, .229616E+02,
     +  .173752E+02, .132348E+02, .101144E+02, .778044E+01,
     +  .600185E+01, .465257E+01, .361906E+01, .282337E+01,
     +  .220785E+01, .172964E+01, .135669E+01, .106488E+01,
     +  .835950E+00, .655953E+00, .514212E+00, .402485E+00,
     +  .314389E+00, .244821E+00, .190215E+00, .146957E+00 /
        DATA (UPDI(I),I=7437,7488) /
     +  .112989E+00, .863853E-01, .656186E-01, .494762E-01,
     +  .369904E-01, .273907E-01, .200633E-01, .145187E-01,
     +  .103484E-01, .727932E-02, .501577E-02, .338426E-02,
     +  .222842E-02, .142596E-02, .882170E-03, .523834E-03,
     +  .296569E-03, .157492E-03, .776159E-04, .345873E-04,
     +  .134513E-04, .431007E-05, .102493E-05, .148302E-06,
     +  .570970E-08, .000000E+00, .257471E+08, .193729E+08,
     +  .143123E+08, .105653E+08, .779305E+07, .574351E+07,
     +  .422940E+07, .311170E+07, .228730E+07, .167972E+07,
     +  .123235E+07, .903211E+06, .661296E+06, .483652E+06,
     +  .353339E+06, .257839E+06, .187931E+06, .136808E+06,
     +  .994703E+05, .722285E+05, .523807E+05, .379351E+05,
     +  .274378E+05, .198175E+05, .142948E+05, .102946E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .740682E+04, .529764E+04, .380335E+04, .272799E+04,
     +  .195522E+04, .140072E+04, .100320E+04, .719337E+03,
     +  .515719E+03, .370226E+03, .266291E+03, .192022E+03,
     +  .138915E+03, .100864E+03, .735851E+02, .539375E+02,
     +  .397446E+02, .294480E+02, .219435E+02, .164408E+02,
     +  .124009E+02, .938480E+01, .715003E+01, .546289E+01,
     +  .419490E+01, .323263E+01, .249860E+01, .193598E+01,
     +  .150285E+01, .116815E+01, .908641E+00, .706899E+00,
     +  .549722E+00, .427075E+00, .331281E+00, .256438E+00,
     +  .197879E+00, .152340E+00, .116604E+00, .888087E-01,
     +  .672502E-01, .505868E-01, .377636E-01, .279466E-01,
     +  .204780E-01, .148386E-01, .106186E-01, .748106E-02,
     +  .519955E-02, .353774E-02, .235556E-02, .152951E-02 /
        DATA (UPDI(I),I=7541,7592) /
     +  .964314E-03, .587196E-03, .342793E-03, .190537E-03,
     +  .991614E-04, .477961E-04, .207773E-04, .785665E-05,
     +  .243749E-05, .557997E-06, .764913E-07, .194378E-08,
     +  .000000E+00, .335012E+08, .251001E+08, .184495E+08,
     +  .135494E+08, .994214E+07, .728868E+07, .533847E+07,
     +  .390632E+07, .285555E+07, .208529E+07, .152120E+07,
     +  .110848E+07, .806825E+06, .586570E+06, .425932E+06,
     +  .308898E+06, .223736E+06, .161836E+06, .116905E+06,
     +  .843288E+05, .607454E+05, .436921E+05, .313816E+05,
     +  .225050E+05, .161158E+05, .115201E+05, .822618E+04,
     +  .583788E+04, .415842E+04, .295886E+04, .210344E+04,
     +  .149441E+04, .106125E+04, .754427E+03, .536141E+03,
     +  .381464E+03, .271900E+03, .194277E+03, .139252E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .100170E+03, .723968E+02, .525701E+02, .383746E+02,
     +  .281676E+02, .207946E+02, .154360E+02, .115368E+02,
     +  .865127E+01, .653215E+01, .494631E+01, .376483E+01,
     +  .287597E+01, .220378E+01, .169297E+01, .130309E+01,
     +  .100436E+01, .774714E+00, .597694E+00, .460943E+00,
     +  .355137E+00, .273195E+00, .209718E+00, .160474E+00,
     +  .122508E+00, .929725E-01, .702016E-01, .526968E-01,
     +  .392886E-01, .290650E-01, .213113E-01, .154687E-01,
     +  .111003E-01, .786427E-02, .548330E-02, .377054E-02,
     +  .253689E-02, .166951E-02, .107081E-02, .666429E-03,
     +  .400269E-03, .230269E-03, .125998E-03, .644622E-04,
     +  .304991E-04, .129894E-04, .480090E-05, .145162E-05,
     +  .322522E-06, .422437E-07, .517815E-09, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .426144E+08, .317979E+08, .232587E+08, .169969E+08,
     +  .124093E+08, .905124E+07, .659530E+07, .480079E+07,
     +  .349084E+07, .253552E+07, .183955E+07, .133304E+07,
     +  .964825E+06, .697435E+06, .503500E+06, .363001E+06,
     +  .261349E+06, .187892E+06, .134887E+06, .966867E+05,
     +  .692009E+05, .494490E+05, .352806E+05, .251296E+05,
     +  .178712E+05, .126848E+05, .899298E+04, .633480E+04,
     +  .447882E+04, .316267E+04, .223096E+04, .157254E+04,
     +  .110778E+04, .781096E+03, .550492E+03, .388380E+03,
     +  .274471E+03, .194424E+03, .138146E+03, .985035E+02,
     +  .705671E+02, .507903E+02, .367493E+02, .267380E+02,
     +  .195671E+02, .143989E+02, .106697E+02, .793278E+01,
     +  .593950E+01, .446006E+01, .336688E+01, .255112E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .193918E+01, .147788E+01, .112860E+01, .863092E+00,
     +  .660597E+00, .505734E+00, .387039E+00, .295922E+00,
     +  .225908E+00, .172095E+00, .130677E+00, .989975E-01,
     +  .745476E-01, .558492E-01, .415918E-01, .307608E-01,
     +  .225712E-01, .164128E-01, .118125E-01, .840329E-02,
     +  .590059E-02, .407640E-02, .277677E-02, .184995E-02,
     +  .120504E-02, .764687E-03, .470600E-03, .279330E-03,
     +  .158696E-03, .856869E-04, .432137E-04, .201324E-04,
     +  .843131E-05, .305914E-05, .906220E-06, .196700E-06,
     +  .248428E-07, .225472E-10, .000000E+00, .531384E+08,
     +  .394956E+08, .287537E+08, .209125E+08, .151945E+08,
     +  .110286E+08, .799636E+07, .579142E+07, .418974E+07,
     +  .302745E+07, .218495E+07, .157492E+07, .113374E+07 /
        DATA (UPDI(I),I=7749,7800) /
     +  .815052E+06, .585139E+06, .419475E+06, .300275E+06,
     +  .214617E+06, .153159E+06, .109121E+06, .776214E+05,
     +  .551195E+05, .390763E+05, .276530E+05, .195359E+05,
     +  .137729E+05, .969763E+04, .678286E+04, .476156E+04,
     +  .333802E+04, .233730E+04, .163515E+04, .114309E+04,
     +  .799761E+03, .559205E+03, .391376E+03, .274352E+03,
     +  .192752E+03, .135830E+03, .960501E+02, .682383E+02,
     +  .487060E+02, .349489E+02, .252181E+02, .183035E+02,
     +  .133594E+02, .981999E+01, .724273E+01, .538035E+01,
     +  .400876E+01, .300304E+01, .225825E+01, .170377E+01,
     +  .128891E+01, .977117E+00, .741864E+00, .563755E+00,
     +  .428537E+00, .325650E+00, .247240E+00, .187425E+00,
     +  .141783E+00, .106908E+00, .804253E-01, .601353E-01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .447323E-01, .330746E-01, .242847E-01, .176887E-01,
     +  .127667E-01, .911880E-02, .643685E-02, .448401E-02,
     +  .307253E-02, .207555E-02, .137083E-02, .884947E-03,
     +  .556335E-03, .339047E-03, .199192E-03, .111951E-03,
     +  .597597E-04, .297706E-04, .136886E-04, .565178E-05,
     +  .201907E-05, .588016E-06, .125227E-06, .153743E-07,
     +  .000000E+00, .000000E+00, .651033E+08, .482069E+08,
     +  .349367E+08, .252929E+08, .182918E+08, .132142E+08,
     +  .953535E+07, .687266E+07, .494758E+07, .355729E+07,
     +  .255440E+07, .183181E+07, .131183E+07, .938110E+06,
     +  .669883E+06, .477618E+06, .340010E+06, .241654E+06,
     +  .171471E+06, .121460E+06, .858894E+05, .606249E+05,
     +  .427171E+05, .300416E+05, .210891E+05, .147718E+05 /
        DATA (UPDI(I),I=7853,7904) /
     +  .103328E+05, .717822E+04, .500487E+04, .348431E+04,
     +  .242257E+04, .168267E+04, .116773E+04, .810970E+03,
     +  .562785E+03, .390885E+03, .271900E+03, .189546E+03,
     +  .132528E+03, .929786E+02, .655370E+02, .464103E+02,
     +  .330409E+02, .236558E+02, .170370E+02, .123398E+02,
     +  .900233E+01, .658998E+01, .485959E+01, .359445E+01,
     +  .267348E+01, .199630E+01, .149571E+01, .112379E+01,
     +  .846197E+00, .638186E+00, .481774E+00, .363828E+00,
     +  .274687E+00, .207206E+00, .156070E+00, .117310E+00,
     +  .878895E-01, .656976E-01, .488079E-01, .360721E-01,
     +  .264981E-01, .193285E-01, .139853E-01, .100260E-01,
     +  .711229E-02, .498552E-02, .344827E-02, .234555E-02,
     +  .157266E-02, .103065E-02, .660021E-03, .411484E-03 /
        DATA (UPDI(I),I=7905,7956) /
     +  .248597E-03, .144726E-03, .805621E-04, .425689E-04,
     +  .209764E-04, .953292E-05, .388637E-05, .136927E-05,
     +  .392757E-06, .822620E-07, .987865E-08, .000000E+00,
     +  .000000E+00, .785162E+08, .579285E+08, .417986E+08,
     +  .301266E+08, .216898E+08, .155977E+08, .112035E+08,
     +  .803730E+07, .575863E+07, .412058E+07, .294451E+07,
     +  .210115E+07, .149719E+07, .106523E+07, .756735E+06,
     +  .536719E+06, .380053E+06, .268656E+06, .189585E+06,
     +  .133542E+06, .938975E+05, .658952E+05, .461583E+05,
     +  .322677E+05, .225142E+05, .156720E+05, .108936E+05,
     +  .751859E+04, .520802E+04, .360170E+04, .248729E+04,
     +  .171578E+04, .118241E+04, .815367E+03, .561778E+03,
     +  .387353E+03, .267468E+03, .185079E+03, .128443E+03 /
        DATA (UPDI(I),I=7957,8008) /
     +  .894407E+02, .625736E+02, .439822E+02, .310806E+02,
     +  .220889E+02, .157929E+02, .113565E+02, .822646E+01,
     +  .597981E+01, .437945E+01, .321735E+01, .237711E+01,
     +  .176341E+01, .131272E+01, .980059E+00, .733368E+00,
     +  .549688E+00, .412442E+00, .309596E+00, .232348E+00,
     +  .174230E+00, .130460E+00, .974854E-01, .726089E-01,
     +  .539588E-01, .398512E-01, .292787E-01, .213800E-01,
     +  .155017E-01, .111484E-01, .794318E-02, .559958E-02,
     +  .390016E-02, .268002E-02, .181079E-02, .120583E-02,
     +  .784654E-03, .498799E-03, .308599E-03, .184952E-03,
     +  .106771E-03, .589088E-04, .308346E-04, .150401E-04,
     +  .676051E-05, .272327E-05, .946909E-06, .267704E-06,
     +  .552042E-07, .651284E-08, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .933615E+08, .686411E+08, .493188E+08, .353944E+08,
     +  .253718E+08, .181653E+08, .129896E+08, .927666E+07,
     +  .661624E+07, .471231E+07, .335153E+07, .238020E+07,
     +  .168784E+07, .119499E+07, .844692E+06, .596077E+06,
     +  .419921E+06, .295292E+06, .207279E+06, .145220E+06,
     +  .101551E+06, .708698E+05, .493624E+05, .343091E+05,
     +  .237984E+05, .164670E+05, .113769E+05, .780309E+04,
     +  .537123E+04, .369091E+04, .253239E+04, .173540E+04,
     +  .118794E+04, .813647E+03, .556747E+03, .381222E+03,
     +  .261393E+03, .179601E+03, .123760E+03, .855695E+02,
     +  .594422E+02, .414870E+02, .291123E+02, .205466E+02,
     +  .145897E+02, .104204E+02, .749835E+01, .541478E+01,
     +  .394025E+01, .287638E+01, .211203E+01, .155725E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .115233E+01, .855257E+00, .636279E+00, .474197E+00,
     +  .353796E+00, .264095E+00, .197107E+00, .146996E+00,
     +  .109468E+00, .813561E-01, .602673E-01, .445457E-01,
     +  .327203E-01, .239082E-01, .173622E-01, .125186E-01,
     +  .895241E-02, .634209E-02, .444489E-02, .307753E-02,
     +  .210188E-02, .141127E-02, .933770E-03, .603566E-03,
     +  .381024E-03, .234028E-03, .139194E-03, .797119E-04,
     +  .436050E-04, .226166E-04, .109228E-04, .485724E-05,
     +  .193360E-05, .663599E-06, .184933E-06, .375625E-07,
     +  .436651E-08, .000000E+00, .000000E+00, .109601E+09,
     +  .803094E+08, .574658E+08, .410699E+08, .293164E+08,
     +  .209002E+08, .148808E+08, .105808E+08, .751302E+07,
     +  .532703E+07, .377152E+07, .266612E+07, .188175E+07 /
        DATA (UPDI(I),I=8113,8164) /
     +  .132596E+07, .932766E+06, .655015E+06, .459154E+06,
     +  .321255E+06, .224351E+06, .156365E+06, .108767E+06,
     +  .754986E+05, .522997E+05, .361488E+05, .249330E+05,
     +  .171527E+05, .117816E+05, .803202E+04, .549549E+04,
     +  .375316E+04, .255908E+04, .174262E+04, .118523E+04,
     +  .806535E+03, .548255E+03, .372918E+03, .253990E+03,
     +  .173343E+03, .118644E+03, .814794E+02, .562214E+02,
     +  .389773E+02, .271703E+02, .190507E+02, .134403E+02,
     +  .953840E+01, .682105E+01, .489539E+01, .354097E+01,
     +  .256963E+01, .187590E+01, .137531E+01, .101204E+01,
     +  .747026E+00, .552768E+00, .409774E+00, .304130E+00,
     +  .225845E+00, .167694E+00, .124422E+00, .921876E-01,
     +  .681666E-01, .502411E-01, .369476E-01, .270008E-01 /
        DATA (UPDI(I),I=8165,8216) /
     +  .196277E-01, .141799E-01, .101704E-01, .723446E-02,
     +  .509730E-02, .355273E-02, .244589E-02, .166077E-02,
     +  .110839E-02, .728849E-03, .468072E-03, .293500E-03,
     +  .178998E-03, .105672E-03, .600374E-04, .325658E-04,
     +  .167381E-04, .800397E-05, .352099E-05, .138503E-05,
     +  .469088E-06, .128847E-06, .257808E-07, .295886E-08,
     +  .000000E+00, .000000E+00, .264976E+05, .290822E+05,
     +  .231470E+05, .184277E+05, .146748E+05, .116899E+05,
     +  .931547E+04, .742634E+04, .592301E+04, .472641E+04,
     +  .377372E+04, .301499E+04, .241055E+04, .192884E+04,
     +  .154478E+04, .123844E+04, .993962E+03, .798744E+03,
     +  .642758E+03, .518031E+03, .418218E+03, .338272E+03,
     +  .274175E+03, .222729E+03, .181387E+03, .148121E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .121314E+03, .994028E+02, .819695E+02, .678471E+02,
     +  .563842E+02, .470603E+02, .394596E+02, .332662E+02,
     +  .281801E+02, .240058E+02, .205707E+02, .177360E+02,
     +  .153896E+02, .134400E+02, .118166E+02, .104567E+02,
     +  .931273E+01, .834497E+01, .752126E+01, .681545E+01,
     +  .620840E+01, .567721E+01, .521464E+01, .480398E+01,
     +  .444060E+01, .411566E+01, .382299E+01, .355704E+01,
     +  .331272E+01, .308545E+01, .287143E+01, .266780E+01,
     +  .247270E+01, .228510E+01, .210456E+01, .193097E+01,
     +  .176445E+01, .160587E+01, .145376E+01, .130931E+01,
     +  .117267E+01, .104397E+01, .923330E+00, .810803E+00,
     +  .706426E+00, .610195E+00, .522012E+00, .441723E+00,
     +  .369891E+00, .305271E+00, .248163E+00, .198273E+00 /
        DATA (UPDI(I),I=8269,8320) /
     +  .155265E+00, .118759E+00, .883321E-01, .635556E-01,
     +  .437848E-01, .286548E-01, .175013E-01, .972861E-02,
     +  .471920E-02, .184613E-02, .487858E-03, .494171E-04,
     +  .000000E+00, .316156E+05, .452353E+05, .354682E+05,
     +  .278265E+05, .218443E+05, .171588E+05, .134873E+05,
     +  .106087E+05, .835063E+04, .657839E+04, .518664E+04,
     +  .409304E+04, .323318E+04, .255666E+04, .202401E+04,
     +  .160432E+04, .127339E+04, .101221E+04, .805898E+03,
     +  .642769E+03, .513646E+03, .411325E+03, .330141E+03,
     +  .265642E+03, .214325E+03, .173433E+03, .140791E+03,
     +  .114357E+03, .935143E+02, .767766E+02, .633050E+02,
     +  .524364E+02, .436461E+02, .365373E+02, .307415E+02,
     +  .260174E+02, .221551E+02, .189872E+02, .163798E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .142246E+02, .124385E+02, .109487E+02, .970014E+01,
     +  .864750E+01, .775416E+01, .699089E+01, .633599E+01,
     +  .576438E+01, .526770E+01, .482769E+01, .443904E+01,
     +  .409199E+01, .377975E+01, .349630E+01, .323634E+01,
     +  .299528E+01, .276939E+01, .255594E+01, .235315E+01,
     +  .215996E+01, .197586E+01, .180064E+01, .163418E+01,
     +  .147721E+01, .132810E+01, .118785E+01, .105644E+01,
     +  .933843E+00, .819989E+00, .714791E+00, .618127E+00,
     +  .529845E+00, .449751E+00, .377506E+00, .313507E+00,
     +  .256511E+00, .206658E+00, .163568E+00, .126829E+00,
     +  .960037E-01, .706119E-01, .502026E-01, .341438E-01,
     +  .220326E-01, .132457E-01, .723142E-02, .343468E-02,
     +  .130957E-02, .336559E-03, .343834E-04, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .872013E+05, .683780E+05, .530256E+05, .411440E+05,
     +  .319430E+05, .248145E+05, .192892E+05, .150045E+05,
     +  .116801E+05, .909936E+04, .709489E+04, .553704E+04,
     +  .432555E+04, .338278E+04, .264860E+04, .207642E+04,
     +  .163014E+04, .128174E+04, .100950E+04, .796545E+03,
     +  .629787E+03, .499042E+03, .396399E+03, .315702E+03,
     +  .252160E+03, .202043E+03, .162441E+03, .130690E+03,
     +  .105900E+03, .861823E+02, .704592E+02, .578883E+02,
     +  .478099E+02, .397276E+02, .331909E+02, .279035E+02,
     +  .236116E+02, .201149E+02, .172547E+02, .149041E+02,
     +  .129659E+02, .113569E+02, .100140E+02, .888594E+01,
     +  .793174E+01, .711894E+01, .642342E+01, .581792E+01,
     +  .529304E+01, .482907E+01, .442008E+01, .405548E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .372796E+01, .343114E+01, .315952E+01, .290847E+01,
     +  .267431E+01, .245437E+01, .224685E+01, .205066E+01,
     +  .186518E+01, .169007E+01, .152502E+01, .137061E+01,
     +  .122508E+01, .108928E+01, .963021E+00, .846141E+00,
     +  .738439E+00, .639699E+00, .549675E+00, .468105E+00,
     +  .394708E+00, .329024E+00, .271317E+00, .220358E+00,
     +  .176172E+00, .138322E+00, .106351E+00, .797857E-01,
     +  .581227E-01, .409074E-01, .275138E-01, .175376E-01,
     +  .103995E-01, .558929E-02, .260654E-02, .972018E-03,
     +  .243949E-03, .251087E-04, .000000E+00, .131646E+06,
     +  .102414E+06, .787002E+05, .605044E+05, .465355E+05,
     +  .358081E+05, .275676E+05, .212351E+05, .163671E+05,
     +  .126234E+05, .974302E+04, .752591E+04, .581846E+04 /
        DATA (UPDI(I),I=8477,8528) /
     +  .450277E+04, .348836E+04, .270571E+04, .210144E+04,
     +  .163453E+04, .127344E+04, .993925E+03, .777324E+03,
     +  .609281E+03, .478745E+03, .377199E+03, .298084E+03,
     +  .236339E+03, .188060E+03, .149758E+03, .120163E+03,
     +  .968609E+02, .784645E+02, .638989E+02, .523313E+02,
     +  .431391E+02, .357696E+02, .298579E+02, .250968E+02,
     +  .212463E+02, .181179E+02, .155629E+02, .134680E+02,
     +  .117377E+02, .103001E+02, .909732E+01, .808358E+01,
     +  .722290E+01, .648858E+01, .585110E+01, .529991E+01,
     +  .481387E+01, .438636E+01, .400604E+01, .366505E+01,
     +  .335668E+01, .307526E+01, .281608E+01, .257549E+01,
     +  .235081E+01, .214023E+01, .194256E+01, .175706E+01,
     +  .158324E+01, .142063E+01, .126962E+01, .112836E+01 /
        DATA (UPDI(I),I=8529,8580) /
     +  .997507E+00, .876753E+00, .765790E+00, .664299E+00,
     +  .571944E+00, .488372E+00, .413225E+00, .346141E+00,
     +  .286566E+00, .234646E+00, .189174E+00, .150082E+00,
     +  .116890E+00, .891088E-01, .662485E-01, .477927E-01,
     +  .332826E-01, .221273E-01, .139251E-01, .813907E-02,
     +  .430224E-02, .196719E-02, .716045E-03, .175020E-03,
     +  .181674E-04, .000000E+00, .193816E+06, .149799E+06,
     +  .114246E+06, .871555E+05, .665061E+05, .507638E+05,
     +  .387606E+05, .296067E+05, .226243E+05, .172969E+05,
     +  .132313E+05, .101276E+05, .775746E+04, .594677E+04,
     +  .456289E+04, .350467E+04, .269505E+04, .207521E+04,
     +  .160034E+04, .123623E+04, .956800E+03, .742125E+03,
     +  .577015E+03, .449851E+03, .351775E+03, .276002E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .217361E+03, .171312E+03, .136094E+03, .108643E+03,
     +  .871863E+02, .703631E+02, .571297E+02, .467109E+02,
     +  .384320E+02, .318473E+02, .265867E+02, .223643E+02,
     +  .189576E+02, .161930E+02, .139396E+02, .120879E+02,
     +  .105566E+02, .928093E+01, .820970E+01, .730329E+01,
     +  .653235E+01, .586499E+01, .528953E+01, .478337E+01,
     +  .433923E+01, .394499E+01, .359233E+01, .327419E+01,
     +  .298473E+01, .271918E+01, .247387E+01, .224607E+01,
     +  .203392E+01, .183613E+01, .165181E+01, .148034E+01,
     +  .132103E+01, .117414E+01, .103770E+01, .912198E+00,
     +  .797203E+00, .692280E+00, .596995E+00, .510909E+00,
     +  .433573E+00, .364546E+00, .303392E+00, .249489E+00,
     +  .202878E+00, .162383E+00, .127856E+00, .987918E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .746838E-01, .550318E-01, .393220E-01, .271030E-01,
     +  .178151E-01, .110713E-01, .637993E-02, .331779E-02,
     +  .148809E-02, .529103E-03, .126143E-03, .132017E-04,
     +  .000000E+00, .190338E+06, .213173E+06, .161529E+06,
     +  .122412E+06, .927773E+05, .703252E+05, .533151E+05,
     +  .404275E+05, .306627E+05, .232635E+05, .176562E+05,
     +  .134063E+05, .101847E+05, .774198E+04, .588939E+04,
     +  .448387E+04, .341718E+04, .260722E+04, .199190E+04,
     +  .152412E+04, .116827E+04, .897315E+03, .690801E+03,
     +  .533209E+03, .412799E+03, .320642E+03, .250007E+03,
     +  .195075E+03, .153471E+03, .121353E+03, .964878E+02,
     +  .771765E+02, .621266E+02, .503845E+02, .411356E+02,
     +  .338409E+02, .280595E+02, .234536E+02, .197633E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .167877E+02, .143761E+02, .124050E+02, .107825E+02,
     +  .943641E+01, .831038E+01, .736081E+01, .655570E+01,
     +  .586079E+01, .526322E+01, .473898E+01, .428012E+01,
     +  .387380E+01, .351123E+01, .318505E+01, .288925E+01,
     +  .261898E+01, .237051E+01, .214107E+01, .192869E+01,
     +  .173198E+01, .154988E+01, .138162E+01, .122634E+01,
     +  .108413E+01, .952923E+00, .833056E+00, .723970E+00,
     +  .625116E+00, .535960E+00, .455970E+00, .384613E+00,
     +  .321377E+00, .265767E+00, .217106E+00, .175348E+00,
     +  .139351E+00, .108908E+00, .834957E-01, .626016E-01,
     +  .457258E-01, .323655E-01, .220829E-01, .143539E-01,
     +  .881074E-02, .500701E-02, .256247E-02, .112784E-02,
     +  .392022E-03, .912979E-04, .963081E-05, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .406413E+06, .310633E+06, .233837E+06, .176024E+06,
     +  .132494E+06, .997244E+05, .750580E+05, .564936E+05,
     +  .425232E+05, .320109E+05, .241013E+05, .181502E+05,
     +  .136727E+05, .103038E+05, .776884E+04, .586114E+04,
     +  .442527E+04, .334420E+04, .253005E+04, .191660E+04,
     +  .145417E+04, .110532E+04, .841969E+03, .642944E+03,
     +  .492379E+03, .378293E+03, .291749E+03, .225141E+03,
     +  .175223E+03, .137089E+03, .107874E+03, .854203E+02,
     +  .680999E+02, .547217E+02, .442866E+02, .361335E+02,
     +  .297294E+02, .246701E+02, .206484E+02, .174288E+02,
     +  .148366E+02, .127304E+02, .110059E+02, .958199E+01,
     +  .839599E+01, .739973E+01, .655811E+01, .583411E+01,
     +  .521354E+01, .467079E+01, .419715E+01, .377901E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .340704E+01, .307359E+01, .277242E+01, .249859E+01,
     +  .224827E+01, .201861E+01, .180752E+01, .161340E+01,
     +  .143506E+01, .127151E+01, .112171E+01, .985563E+00,
     +  .860899E+00, .747877E+00, .645806E+00, .554022E+00,
     +  .471883E+00, .398765E+00, .334055E+00, .277174E+00,
     +  .227565E+00, .184513E+00, .147884E+00, .116587E+00,
     +  .903595E-01, .686726E-01, .510164E-01, .369023E-01,
     +  .258491E-01, .174411E-01, .111992E-01, .678302E-02,
     +  .379763E-02, .191099E-02, .824873E-03, .280331E-03,
     +  .638905E-04, .679095E-05, .000000E+00, .576416E+06,
     +  .438366E+06, .328044E+06, .245451E+06, .183613E+06,
     +  .137328E+06, .102692E+06, .767811E+05, .574016E+05,
     +  .429106E+05, .320773E+05, .239799E+05, .179286E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .134068E+05, .100285E+05, .750444E+04, .561874E+04,
     +  .420977E+04, .315693E+04, .236997E+04, .178159E+04,
     +  .134144E+04, .101201E+04, .765227E+03, .580207E+03,
     +  .441286E+03, .336894E+03, .257313E+03, .198247E+03,
     +  .153559E+03, .119654E+03, .938475E+02, .741309E+02,
     +  .590449E+02, .473855E+02, .383564E+02, .313242E+02,
     +  .258130E+02, .214646E+02, .180072E+02, .152411E+02,
     +  .130062E+02, .111856E+02, .968931E+01, .844817E+01,
     +  .740950E+01, .653517E+01, .578551E+01, .514501E+01,
     +  .458659E+01, .410077E+01, .367322E+01, .329415E+01,
     +  .295559E+01, .265111E+01, .237564E+01, .212526E+01,
     +  .189699E+01, .168857E+01, .149827E+01, .132470E+01,
     +  .116667E+01, .102298E+01, .893343E+00, .775512E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .669475E+00, .574426E+00, .489598E+00, .414261E+00,
     +  .347714E+00, .289278E+00, .238322E+00, .194242E+00,
     +  .156303E+00, .124300E+00, .971953E-01, .746879E-01,
     +  .562540E-01, .413951E-01, .296411E-01, .205379E-01,
     +  .136958E-01, .868130E-02, .518339E-02, .285568E-02,
     +  .141069E-02, .595887E-03, .197415E-03, .438805E-04,
     +  .470581E-05, .000000E+00, .794027E+06, .601094E+06,
     +  .447384E+06, .332896E+06, .247624E+06, .184135E+06,
     +  .136883E+06, .101728E+06, .755827E+05, .561449E+05,
     +  .416988E+05, .309658E+05, .229941E+05, .170748E+05,
     +  .126807E+05, .941931E+04, .699919E+04, .520339E+04,
     +  .387099E+04, .288228E+04, .214857E+04, .160386E+04,
     +  .119937E+04, .898774E+03, .675251E+03, .508811E+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .384818E+03, .291118E+03, .222189E+03, .170503E+03,
     +  .131640E+03, .102323E+03, .801242E+02, .632877E+02,
     +  .503867E+02, .404790E+02, .328236E+02, .268691E+02,
     +  .222037E+02, .185184E+02, .155872E+02, .132315E+02,
     +  .113218E+02, .975910E+01, .846802E+01, .739147E+01,
     +  .648838E+01, .571655E+01, .505923E+01, .448793E+01,
     +  .399249E+01, .355790E+01, .317394E+01, .283234E+01,
     +  .252649E+01, .225118E+01, .200237E+01, .177693E+01,
     +  .157247E+01, .138705E+01, .121910E+01, .106729E+01,
     +  .930214E+00, .807424E+00, .696620E+00, .597627E+00,
     +  .509540E+00, .431504E+00, .362714E+00, .302409E+00,
     +  .249861E+00, .204399E+00, .165386E+00, .132081E+00,
     +  .104224E+00, .808352E-01, .615887E-01, .459737E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .335109E-01, .237543E-01, .162811E-01, .107306E-01,
     +  .671446E-02, .395218E-02, .214261E-02, .103909E-02,
     +  .429555E-03, .138767E-03, .301035E-04, .325716E-05,
     +  .000000E+00, .106610E+07, .803621E+06, .595101E+06,
     +  .440536E+06, .325974E+06, .241101E+06, .178252E+06,
     +  .131734E+06, .973195E+05, .718704E+05, .530600E+05,
     +  .391623E+05, .288988E+05, .213220E+05, .157308E+05,
     +  .116063E+05, .856460E+04, .632195E+04, .466886E+04,
     +  .345035E+04, .255229E+04, .189024E+04, .140214E+04,
     +  .104206E+04, .776329E+03, .579969E+03, .434847E+03,
     +  .326061E+03, .246689E+03, .187662E+03, .143645E+03,
     +  .110718E+03, .859899E+02, .673885E+02, .532489E+02,
     +  .424739E+02, .342102E+02, .278275E+02, .228594E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .189587E+02, .158733E+02, .134061E+02, .114151E+02,
     +  .979245E+01, .845697E+01, .734725E+01, .641945E+01,
     +  .562901E+01, .495798E+01, .437662E+01, .387408E+01,
     +  .343475E+01, .304802E+01, .270535E+01, .239994E+01,
     +  .212644E+01, .188067E+01, .165935E+01, .145991E+01,
     +  .128027E+01, .111866E+01, .973573E+00, .843477E+00,
     +  .727749E+00, .624050E+00, .532061E+00, .450792E+00,
     +  .379315E+00, .316769E+00, .262344E+00, .215279E+00,
     +  .174875E+00, .140477E+00, .111347E+00, .871850E-01,
     +  .670729E-01, .506706E-01, .374871E-01, .270677E-01,
     +  .189946E-01, .128785E-01, .838936E-02, .518225E-02,
     +  .300720E-02, .160439E-02, .763927E-03, .309139E-03,
     +  .974372E-04, .206544E-04, .225427E-05, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .139929E+07, .105057E+07, .774269E+06, .570396E+06,
     +  .419985E+06, .309076E+06, .227339E+06, .167135E+06,
     +  .122815E+06, .902057E+05, .662267E+05, .486028E+05,
     +  .356569E+05, .261518E+05, .191767E+05, .140603E+05,
     +  .103092E+05, .755975E+04, .554541E+04, .406982E+04,
     +  .298919E+04, .219773E+04, .161810E+04, .119341E+04,
     +  .882175E+03, .653819E+03, .486293E+03, .361648E+03,
     +  .271395E+03, .204787E+03, .155499E+03, .118914E+03,
     +  .916489E+02, .712948E+02, .559379E+02, .443197E+02,
     +  .354708E+02, .286806E+02, .234277E+02, .193265E+02,
     +  .160992E+02, .135306E+02, .114666E+02, .979092E+01,
     +  .841675E+01, .727867E+01, .633023E+01, .552472E+01,
     +  .484307E+01, .425438E+01, .374720E+01, .330536E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .291788E+01, .257599E+01, .227270E+01, .200250E+01,
     +  .176107E+01, .154498E+01, .135149E+01, .117834E+01,
     +  .102361E+01, .885641E+00, .762756E+00, .654188E+00,
     +  .557572E+00, .472464E+00, .397800E+00, .332601E+00,
     +  .275959E+00, .227031E+00, .185036E+00, .149260E+00,
     +  .119040E+00, .936507E-01, .727649E-01, .555279E-01,
     +  .415950E-01, .304998E-01, .218157E-01, .151560E-01,
     +  .101653E-01, .654519E-02, .399147E-02, .228357E-02,
     +  .119904E-02, .560612E-03, .222131E-03, .683499E-04,
     +  .141742E-04, .156016E-05, .000000E+00, .179995E+07,
     +  .134626E+07, .987707E+06, .724295E+06, .530813E+06,
     +  .388781E+06, .284584E+06, .208190E+06, .152216E+06,
     +  .111228E+06, .812348E+05, .592993E+05, .432674E+05 /
        DATA (UPDI(I),I=9205,9256) /
     +  .315570E+05, .230085E+05, .167715E+05, .122236E+05,
     +  .890878E+04, .649402E+04, .473537E+04, .345512E+04,
     +  .252313E+04, .184484E+04, .135102E+04, .991473E+03,
     +  .729412E+03, .538478E+03, .397402E+03, .295974E+03,
     +  .221650E+03, .167047E+03, .126807E+03, .970332E+02,
     +  .749629E+02, .584265E+02, .459997E+02, .365958E+02,
     +  .294235E+02, .239064E+02, .196214E+02, .162657E+02,
     +  .136064E+02, .114780E+02, .975637E+01, .834929E+01,
     +  .718764E+01, .622263E+01, .540554E+01, .471627E+01,
     +  .412293E+01, .361346E+01, .317122E+01, .278491E+01,
     +  .244550E+01, .214585E+01, .188029E+01, .164434E+01,
     +  .143442E+01, .124764E+01, .108156E+01, .934122E+00,
     +  .803515E+00, .687958E+00, .586548E+00, .496912E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .418492E+00, .350172E+00, .290930E+00, .239829E+00,
     +  .196007E+00, .158671E+00, .127103E+00, .100643E+00,
     +  .785892E-01, .605947E-01, .458691E-01, .340708E-01,
     +  .247616E-01, .175455E-01, .120677E-01, .800722E-02,
     +  .509600E-02, .306814E-02, .173068E-02, .894417E-03,
     +  .410688E-03, .159374E-03, .479025E-04, .972907E-05,
     +  .107976E-05, .000000E+00, .227390E+07, .169462E+07,
     +  .123792E+07, .903800E+06, .659420E+06, .480793E+06,
     +  .350318E+06, .255080E+06, .185611E+06, .134974E+06,
     +  .980899E+05, .712423E+05, .517144E+05, .375197E+05,
     +  .272093E+05, .197248E+05, .142954E+05, .103590E+05,
     +  .750675E+04, .544089E+04, .394542E+04, .286299E+04,
     +  .207982E+04, .151304E+04, .110290E+04, .805808E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .590744E+03, .432872E+03, .320119E+03, .238045E+03,
     +  .178152E+03, .134309E+03, .102086E+03, .783580E+02,
     +  .606938E+02, .475024E+02, .375793E+02, .300537E+02,
     +  .242953E+02, .198445E+02, .163743E+02, .136355E+02,
     +  .114514E+02, .969089E+01, .825664E+01, .707619E+01,
     +  .609856E+01, .527328E+01, .457932E+01, .398388E+01,
     +  .347436E+01, .303372E+01, .265034E+01, .231499E+01,
     +  .202035E+01, .176060E+01, .153111E+01, .132816E+01,
     +  .114869E+01, .990111E+00, .850239E+00, .727138E+00,
     +  .618928E+00, .524592E+00, .441764E+00, .369788E+00,
     +  .307510E+00, .253879E+00, .207944E+00, .168832E+00,
     +  .135753E+00, .107992E+00, .849015E-01, .658054E-01,
     +  .503507E-01, .378092E-01, .278485E-01, .200609E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .140819E-01, .958912E-02, .629453E-02, .395979E-02,
     +  .235380E-02, .130916E-02, .665969E-03, .300350E-03,
     +  .114184E-03, .335439E-04, .667934E-05, .747276E-06,
     +  .000000E+00, .282634E+07, .209906E+07, .152701E+07,
     +  .111019E+07, .806551E+06, .585525E+06, .424754E+06,
     +  .307898E+06, .223027E+06, .161433E+06, .116767E+06,
     +  .844013E+05, .609672E+05, .440126E+05, .317558E+05,
     +  .229012E+05, .165095E+05, .118985E+05, .857464E+04,
     +  .617966E+04, .445515E+04, .321369E+04, .232044E+04,
     +  .167763E+04, .121515E+04, .882103E+03, .642472E+03,
     +  .467640E+03, .343552E+03, .253789E+03, .188696E+03,
     +  .141347E+03, .106763E+03, .814534E+02, .627250E+02,
     +  .488202E+02, .384184E+02, .305709E+02, .245954E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .199974E+02, .164273E+02, .136201E+02, .113892E+02,
     +  .959672E+01, .814095E+01, .694631E+01, .595992E+01,
     +  .512973E+01, .443386E+01, .383875E+01, .333131E+01,
     +  .289412E+01, .251531E+01, .218544E+01, .189702E+01,
     +  .164410E+01, .142190E+01, .122655E+01, .105485E+01,
     +  .904089E+00, .771947E+00, .656392E+00, .555466E+00,
     +  .468050E+00, .391802E+00, .325984E+00, .269418E+00,
     +  .221039E+00, .179889E+00, .145100E+00, .115888E+00,
     +  .915545E-01, .714671E-01, .549834E-01, .417501E-01,
     +  .311005E-01, .227156E-01, .162193E-01, .112793E-01,
     +  .760437E-02, .493843E-02, .307093E-02, .180234E-02,
     +  .988473E-03, .494994E-03, .219298E-03, .816975E-04,
     +  .234709E-04, .458651E-05, .517169E-06, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .346172E+07, .256244E+07, .185667E+07, .134441E+07,
     +  .972715E+06, .703220E+06, .507982E+06, .366652E+06,
     +  .264431E+06, .190556E+06, .137212E+06, .987257E+05,
     +  .709823E+05, .509993E+05, .366188E+05, .262779E+05,
     +  .188484E+05, .135144E+05, .968794E+04, .694454E+04,
     +  .497914E+04, .357155E+04, .256408E+04, .184296E+04,
     +  .132697E+04, .957445E+03, .693089E+03, .501331E+03,
     +  .366027E+03, .268725E+03, .198582E+03, .147860E+03,
     +  .111029E+03, .842302E+02, .645108E+02, .499495E+02,
     +  .391126E+02, .309765E+02, .248090E+02, .200830E+02,
     +  .164273E+02, .135628E+02, .112938E+02, .947619E+01,
     +  .800437E+01, .680003E+01, .580856E+01, .497660E+01,
     +  .428147E+01, .368899E+01, .318561E+01, .275359E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .238082E+01, .205769E+01, .177656E+01, .153133E+01,
     +  .131710E+01, .112985E+01, .966265E+00, .823509E+00,
     +  .699163E+00, .591109E+00, .497330E+00, .416626E+00,
     +  .346688E+00, .286714E+00, .235513E+00, .192019E+00,
     +  .155277E+00, .124432E+00, .987173E-01, .774535E-01,
     +  .600317E-01, .458455E-01, .345473E-01, .255300E-01,
     +  .184914E-01, .130873E-01, .901656E-02, .601867E-02,
     +  .386704E-02, .237709E-02, .137752E-02, .744996E-03,
     +  .367281E-03, .159867E-03, .583782E-04, .164108E-04,
     +  .315004E-05, .357916E-06, .000000E+00, .265094E+05,
     +  .289827E+05, .230570E+05, .183463E+05, .146012E+05,
     +  .116234E+05, .925533E+04, .737198E+04, .587388E+04,
     +  .468202E+04, .373360E+04, .297874E+04, .237780E+04 /
        DATA (UPDI(I),I=9569,9620) /
     +  .189924E+04, .151804E+04, .121428E+04, .972129E+03,
     +  .779013E+03, .624925E+03, .501910E+03, .403642E+03,
     +  .325090E+03, .262249E+03, .211934E+03, .171611E+03,
     +  .139262E+03, .113280E+03, .921193E+02, .753494E+02,
     +  .618214E+02, .508904E+02, .420416E+02, .348643E+02,
     +  .290463E+02, .242941E+02, .204152E+02, .172408E+02,
     +  .146356E+02, .124912E+02, .107196E+02, .925286E+01,
     +  .803178E+01, .701129E+01, .615428E+01, .543067E+01,
     +  .481598E+01, .429203E+01, .383742E+01, .344422E+01,
     +  .309646E+01, .278858E+01, .251198E+01, .226114E+01,
     +  .203217E+01, .182261E+01, .163101E+01, .145642E+01,
     +  .129793E+01, .115447E+01, .102479E+01, .907552E+00,
     +  .801478E+00, .705408E+00, .618731E+00, .539719E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .468237E+00, .403708E+00, .345642E+00, .293613E+00,
     +  .247239E+00, .206166E+00, .170055E+00, .138557E+00,
     +  .111323E+00, .882467E-01, .686501E-01, .523692E-01,
     +  .390599E-01, .283817E-01, .200002E-01, .135891E-01,
     +  .884173E-02, .543569E-02, .312507E-02, .164166E-02,
     +  .762591E-03, .296498E-03, .870393E-04, .153063E-04,
     +  .769188E-06, .000000E+00, .316290E+05, .451268E+05,
     +  .353700E+05, .277378E+05, .217640E+05, .170863E+05,
     +  .134217E+05, .105494E+05, .829708E+04, .652999E+04,
     +  .514291E+04, .405352E+04, .319747E+04, .252439E+04,
     +  .199485E+04, .157798E+04, .124958E+04, .990693E+03,
     +  .786449E+03, .625186E+03, .497746E+03, .396943E+03,
     +  .317128E+03, .253863E+03, .203657E+03, .163764E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .132021E+03, .106406E+03, .862879E+02, .701997E+02,
     +  .573098E+02, .469614E+02, .386353E+02, .319389E+02,
     +  .265108E+02, .221128E+02, .185394E+02, .156271E+02,
     +  .132457E+02, .112908E+02, .968208E+01, .835046E+01,
     +  .724351E+01, .631849E+01, .554099E+01, .488333E+01,
     +  .432489E+01, .384217E+01, .342623E+01, .305989E+01,
     +  .273717E+01, .244901E+01, .218962E+01, .195487E+01,
     +  .174198E+01, .154910E+01, .137482E+01, .121783E+01,
     +  .107670E+01, .949941E+00, .836069E+00, .733711E+00,
     +  .641600E+00, .559074E+00, .484396E+00, .417354E+00,
     +  .357317E+00, .303737E+00, .256134E+00, .214072E+00,
     +  .177147E+00, .144974E+00, .117180E+00, .933667E-01,
     +  .733830E-01, .565803E-01, .427626E-01, .315858E-01 /
        DATA (UPDI(I),I=9725,9776) /
     +  .227165E-01, .158349E-01, .106384E-01, .684330E-02,
     +  .415456E-02, .235576E-02, .121861E-02, .556319E-03,
     +  .212053E-03, .608279E-04, .104709E-04, .536070E-06,
     +  .000000E+00, .870721E+05, .682611E+05, .529199E+05,
     +  .410484E+05, .318566E+05, .247364E+05, .192186E+05,
     +  .149407E+05, .116224E+05, .904726E+04, .704780E+04,
     +  .549450E+04, .428711E+04, .334804E+04, .261721E+04,
     +  .204806E+04, .160451E+04, .125857E+04, .988557E+03,
     +  .777614E+03, .612668E+03, .483558E+03, .382389E+03,
     +  .303020E+03, .240674E+03, .191633E+03, .153000E+03,
     +  .122132E+03, .981239E+02, .791069E+02, .640120E+02,
     +  .520035E+02, .424276E+02, .347923E+02, .286549E+02,
     +  .237224E+02, .197458E+02, .165290E+02, .139172E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .117876E+02, .100461E+02, .861303E+01, .742827E+01,
     +  .644322E+01, .561909E+01, .492496E+01, .433790E+01,
     +  .383235E+01, .339842E+01, .301780E+01, .268410E+01,
     +  .238776E+01, .212271E+01, .188455E+01, .167017E+01,
     +  .147736E+01, .130435E+01, .114947E+01, .101104E+01,
     +  .887378E+00, .776886E+00, .678115E+00, .589723E+00,
     +  .510998E+00, .440202E+00, .377058E+00, .320892E+00,
     +  .271115E+00, .227205E+00, .188690E+00, .155128E+00,
     +  .126107E+00, .101238E+00, .800944E-01, .624954E-01,
     +  .478214E-01, .358582E-01, .262680E-01, .187283E-01,
     +  .129359E-01, .861296E-02, .548387E-02, .329229E-02,
     +  .184422E-02, .941194E-03, .423197E-03, .158545E-03,
     +  .445763E-04, .753311E-05, .392029E-06, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .131507E+06, .102288E+06, .785865E+05, .604016E+05,
     +  .464425E+05, .357241E+05, .274916E+05, .211665E+05,
     +  .163051E+05, .125673E+05, .969240E+04, .748017E+04,
     +  .577713E+04, .446542E+04, .345461E+04, .267521E+04,
     +  .207389E+04, .160963E+04, .125094E+04, .973577E+03,
     +  .758927E+03, .592641E+03, .463691E+03, .363574E+03,
     +  .285746E+03, .225158E+03, .177923E+03, .140572E+03,
     +  .111818E+03, .892720E+02, .715533E+02, .575950E+02,
     +  .465705E+02, .378621E+02, .309254E+02, .253993E+02,
     +  .209815E+02, .174365E+02, .145803E+02, .122679E+02,
     +  .103898E+02, .885408E+01, .759176E+01, .654784E+01,
     +  .567875E+01, .495007E+01, .433640E+01, .381010E+01,
     +  .336021E+01, .296732E+01, .262451E+01, .232176E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .205267E+01, .181250E+01, .159783E+01, .140608E+01,
     +  .123512E+01, .108299E+01, .947760E+00, .827599E+00,
     +  .720797E+00, .625841E+00, .541322E+00, .466483E+00,
     +  .399590E+00, .340304E+00, .287914E+00, .241795E+00,
     +  .201395E+00, .166208E+00, .135768E+00, .109643E+00,
     +  .874291E-01, .686853E-01, .532086E-01, .404101E-01,
     +  .300645E-01, .218442E-01, .154408E-01, .105691E-01,
     +  .696295E-02, .438573E-02, .260246E-02, .143922E-02,
     +  .724025E-03, .320272E-03, .117742E-03, .323756E-04,
     +  .535810E-05, .284112E-06, .000000E+00, .193666E+06,
     +  .149664E+06, .114123E+06, .870450E+05, .664062E+05,
     +  .506736E+05, .386791E+05, .295330E+05, .225577E+05,
     +  .172368E+05, .131769E+05, .100785E+05, .771308E+04 /
        DATA (UPDI(I),I=9933,9984) /
     +  .590667E+04, .452666E+04, .347194E+04, .266547E+04,
     +  .204848E+04, .157619E+04, .121440E+04, .937062E+03,
     +  .724276E+03, .560870E+03, .435242E+03, .338550E+03,
     +  .264020E+03, .206501E+03, .161475E+03, .127164E+03,
     +  .100526E+03, .797995E+02, .636312E+02, .509840E+02,
     +  .410879E+02, .332774E+02, .271106E+02, .222229E+02,
     +  .183329E+02, .152232E+02, .127241E+02, .107083E+02,
     +  .907049E+01, .773226E+01, .663160E+01, .571989E+01,
     +  .495903E+01, .432107E+01, .377624E+01, .331250E+01,
     +  .290932E+01, .255927E+01, .225181E+01, .198017E+01,
     +  .173930E+01, .152542E+01, .133561E+01, .116740E+01,
     +  .101857E+01, .886973E+00, .770642E+00, .667777E+00,
     +  .576804E+00, .496264E+00, .425353E+00, .362345E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .306846E+00, .258114E+00, .215497E+00, .178415E+00,
     +  .146340E+00, .118788E+00, .953110E-01, .754994E-01,
     +  .589061E-01, .453116E-01, .341596E-01, .252196E-01,
     +  .181772E-01, .127408E-01, .864373E-02, .564045E-02,
     +  .351658E-02, .206328E-02, .112711E-02, .559391E-03,
     +  .243768E-03, .881572E-04, .238323E-04, .391085E-05,
     +  .214353E-06, .000000E+00, .190358E+06, .213028E+06,
     +  .161397E+06, .122294E+06, .926701E+05, .702284E+05,
     +  .532276E+05, .403484E+05, .305913E+05, .231989E+05,
     +  .175979E+05, .133537E+05, .101371E+05, .769898E+04,
     +  .585055E+04, .444879E+04, .338547E+04, .257857E+04,
     +  .196602E+04, .150074E+04, .114713E+04, .878202E+03,
     +  .673519E+03, .517575E+03, .398651E+03, .307829E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .238400E+03, .184567E+03, .143937E+03, .112694E+03,
     +  .886146E+02, .700085E+02, .555901E+02, .444119E+02,
     +  .356688E+02, .288262E+02, .234487E+02, .192036E+02,
     +  .158361E+02, .131497E+02, .109975E+02, .926002E+01,
     +  .784871E+01, .669426E+01, .574282E+01, .495249E+01,
     +  .429278E+01, .373176E+01, .325632E+01, .284483E+01,
     +  .248932E+01, .217874E+01, .190595E+01, .166555E+01,
     +  .145342E+01, .126632E+01, .110147E+01, .956390E+00,
     +  .828779E+00, .716536E+00, .617787E+00, .530908E+00,
     +  .454397E+00, .387408E+00, .328231E+00, .276419E+00,
     +  .231207E+00, .191921E+00, .157961E+00, .128783E+00,
     +  .103890E+00, .828302E-01, .651873E-01, .505174E-01,
     +  .385900E-01, .288819E-01, .211627E-01, .151331E-01 /
        DATA (UPDI(I),I=10089,10140) /
     +  .105194E-01, .707446E-02, .457332E-02, .282278E-02,
     +  .163825E-02, .884409E-03, .433287E-03, .186154E-03,
     +  .662987E-04, .176517E-04, .287700E-05, .163262E-06,
     +  .000000E+00, .406238E+06, .310476E+06, .233695E+06,
     +  .175895E+06, .132378E+06, .996193E+05, .749631E+05,
     +  .564078E+05, .424458E+05, .319409E+05, .240381E+05,
     +  .180931E+05, .136211E+05, .102572E+05, .772677E+04,
     +  .582314E+04, .439094E+04, .331320E+04, .250204E+04,
     +  .189130E+04, .143131E+04, .108466E+04, .823294E+03,
     +  .626058E+03, .477107E+03, .364469E+03, .279234E+03,
     +  .213822E+03, .164962E+03, .127779E+03, .994186E+02,
     +  .777320E+02, .610995E+02, .483361E+02, .384531E+02,
     +  .307939E+02, .248319E+02, .201683E+02, .165010E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .135994E+02, .112929E+02, .944422E+01, .795265E+01,
     +  .674011E+01, .574657E+01, .492568E+01, .424398E+01,
     +  .366714E+01, .318078E+01, .276207E+01, .240237E+01,
     +  .209007E+01, .181758E+01, .157910E+01, .137013E+01,
     +  .118705E+01, .102679E+01, .886606E+00, .764020E+00,
     +  .656816E+00, .563049E+00, .481045E+00, .409265E+00,
     +  .346820E+00, .292022E+00, .244374E+00, .203089E+00,
     +  .167475E+00, .136917E+00, .110862E+00, .888070E-01,
     +  .702958E-01, .549154E-01, .422317E-01, .320075E-01,
     +  .237592E-01, .172604E-01, .122324E-01, .842310E-02,
     +  .560834E-02, .358675E-02, .218833E-02, .125396E-02,
     +  .667499E-03, .321868E-03, .135768E-03, .473043E-04,
     +  .122513E-04, .193114E-05, .108740E-06, .000000E+00 /
        DATA (UPDI(I),I=10193,10244) /
     +  .576227E+06, .438195E+06, .327890E+06, .245311E+06,
     +  .183487E+06, .137214E+06, .102589E+06, .766881E+05,
     +  .573177E+05, .428347E+05, .320088E+05, .239180E+05,
     +  .178727E+05, .133564E+05, .998296E+04, .746332E+04,
     +  .558161E+04, .417624E+04, .312666E+04, .234263E+04,
     +  .175690E+04, .131913E+04, .991859E+03, .747019E+03,
     +  .563750E+03, .426401E+03, .323430E+03, .245146E+03,
     +  .187228E+03, .143574E+03, .110598E+03, .856251E+02,
     +  .666567E+02, .522398E+02, .411818E+02, .326914E+02,
     +  .261417E+02, .210627E+02, .171020E+02, .139929E+02,
     +  .115397E+02, .958708E+01, .802177E+01, .675691E+01,
     +  .572629E+01, .487922E+01, .417933E+01, .359001E+01,
     +  .309563E+01, .267224E+01, .231056E+01, .199842E+01 /
        DATA (UPDI(I),I=10245,10296) /
     +  .172781E+01, .149254E+01, .128776E+01, .110951E+01,
     +  .954436E+00, .819589E+00, .702347E+00, .600399E+00,
     +  .511742E+00, .434665E+00, .367605E+00, .309635E+00,
     +  .259097E+00, .215452E+00, .177899E+00, .145738E+00,
     +  .118345E+00, .951654E-01, .756948E-01, .594829E-01,
     +  .461227E-01, .351957E-01, .264633E-01, .194807E-01,
     +  .140298E-01, .985283E-02, .672003E-02, .442940E-02,
     +  .280227E-02, .169001E-02, .956304E-03, .502158E-03,
     +  .238557E-03, .990007E-04, .338973E-04, .862994E-05,
     +  .134937E-05, .789885E-07, .000000E+00, .793822E+06,
     +  .600909E+06, .447216E+06, .332745E+06, .247487E+06,
     +  .184011E+06, .136771E+06, .101627E+06, .754918E+05,
     +  .560628E+05, .416246E+05, .308988E+05, .229337E+05 /
        DATA (UPDI(I),I=10297,10348) /
     +  .170202E+05, .126314E+05, .937486E+04, .695907E+04,
     +  .516718E+04, .383831E+04, .285278E+04, .212194E+04,
     +  .157982E+04, .117767E+04, .879174E+03, .657549E+03,
     +  .492814E+03, .370362E+03, .278069E+03, .210386E+03,
     +  .159821E+03, .121965E+03, .935543E+02, .721676E+02,
     +  .560580E+02, .438108E+02, .344889E+02, .273587E+02,
     +  .218749E+02, .176320E+02, .143262E+02, .117362E+02,
     +  .968818E+01, .805652E+01, .674562E+01, .568324E+01,
     +  .481449E+01, .410024E+01, .350173E+01, .300215E+01,
     +  .257653E+01, .221494E+01, .190472E+01, .163743E+01,
     +  .140653E+01, .120684E+01, .103409E+01, .884711E+00,
     +  .755560E+00, .643904E+00, .547358E+00, .463879E+00,
     +  .391729E+00, .329333E+00, .275734E+00, .229309E+00 /
        DATA (UPDI(I),I=10349,10400) /
     +  .189485E+00, .155457E+00, .126520E+00, .102054E+00,
     +  .815039E-01, .643737E-01, .502224E-01, .386542E-01,
     +  .292699E-01, .218339E-01, .159401E-01, .113811E-01,
     +  .792074E-02, .535111E-02, .349179E-02, .218543E-02,
     +  .130291E-02, .728101E-03, .377198E-03, .176576E-03,
     +  .721189E-04, .242814E-04, .608469E-05, .946005E-06,
     +  .576181E-07, .000000E+00, .106587E+07, .803420E+06,
     +  .594920E+06, .440372E+06, .325826E+06, .240967E+06,
     +  .178132E+06, .131625E+06, .972210E+05, .717815E+05,
     +  .529798E+05, .390899E+05, .288334E+05, .212630E+05,
     +  .156777E+05, .115583E+05, .852129E+04, .628288E+04,
     +  .463362E+04, .341856E+04, .252361E+04, .186437E+04,
     +  .137880E+04, .102100E+04, .757325E+03, .562811E+03 /
        DATA (UPDI(I),I=10401,10452) /
     +  .419359E+03, .312097E+03, .234076E+03, .176262E+03,
     +  .133338E+03, .101392E+03, .775444E+02, .597310E+02,
     +  .463004E+02, .361610E+02, .284671E+02, .225953E+02,
     +  .180857E+02, .145969E+02, .118816E+02, .974796E+01,
     +  .805801E+01, .670770E+01, .561906E+01, .473319E+01,
     +  .400838E+01, .340390E+01, .290182E+01, .247625E+01,
     +  .211667E+01, .180994E+01, .154726E+01, .132173E+01,
     +  .112788E+01, .961199E+00, .817899E+00, .694706E+00,
     +  .588792E+00, .497722E+00, .419426E+00, .352149E+00,
     +  .294315E+00, .244944E+00, .202457E+00, .166253E+00,
     +  .135529E+00, .109586E+00, .878073E-01, .696492E-01,
     +  .546271E-01, .423134E-01, .323273E-01, .242919E-01,
     +  .179783E-01, .130175E-01, .921481E-02, .635560E-02 /
        DATA (UPDI(I),I=10453,10504) /
     +  .425328E-02, .274777E-02, .170144E-02, .100282E-02,
     +  .553502E-03, .282936E-03, .130540E-03, .524878E-04,
     +  .173849E-04, .429068E-05, .663361E-06, .419484E-07,
     +  .000000E+00, .139905E+07, .105035E+07, .774072E+06,
     +  .570219E+06, .419825E+06, .308931E+06, .227209E+06,
     +  .167017E+06, .122708E+06, .901096E+05, .661400E+05,
     +  .485245E+05, .355863E+05, .260881E+05, .191193E+05,
     +  .140086E+05, .102625E+05, .751766E+04, .550746E+04,
     +  .403561E+04, .295835E+04, .216993E+04, .159304E+04,
     +  .117082E+04, .861810E+03, .635453E+03, .469735E+03,
     +  .346738E+03, .257946E+03, .192652E+03, .144546E+03,
     +  .109022E+03, .827096E+02, .632081E+02, .486181E+02,
     +  .376874E+02, .294549E+02, .232173E+02, .184602E+02 /
        DATA (UPDI(I),I=10505,10556) /
     +  .148042E+02, .119765E+02, .976766E+01, .802786E+01,
     +  .664497E+01, .553560E+01, .463712E+01, .390544E+01,
     +  .329806E+01, .279602E+01, .237262E+01, .201679E+01,
     +  .171497E+01, .145800E+01, .123869E+01, .105131E+01,
     +  .891136E+00, .754209E+00, .637148E+00, .537058E+00,
     +  .451473E+00, .378307E+00, .315805E+00, .262394E+00,
     +  .217081E+00, .178335E+00, .145536E+00, .117890E+00,
     +  .947074E-01, .753848E-01, .593914E-01, .462587E-01,
     +  .355764E-01, .269812E-01, .201204E-01, .147747E-01,
     +  .106104E-01, .744691E-02, .509046E-02, .337470E-02,
     +  .215856E-02, .132244E-02, .770634E-03, .420147E-03,
     +  .211943E-03, .963948E-04, .381670E-04, .124416E-04,
     +  .302586E-05, .465168E-06, .304754E-07, .000000E+00 /
        DATA (UPDI(I),I=10557,10608) /
     +  .179969E+07, .134602E+07, .987494E+06, .724103E+06,
     +  .530639E+06, .388625E+06, .284443E+06, .208062E+06,
     +  .152101E+06, .111125E+06, .811412E+05, .592149E+05,
     +  .431913E+05, .314883E+05, .229466E+05, .167157E+05,
     +  .121733E+05, .886348E+04, .645321E+04, .469861E+04,
     +  .342200E+04, .249331E+04, .181798E+04, .132683E+04,
     +  .969692E+03, .709792E+03, .520812E+03, .381518E+03,
     +  .281669E+03, .208764E+03, .155437E+03, .116343E+03,
     +  .875974E+02, .664474E+02, .507385E+02, .390534E+02,
     +  .303141E+02, .237374E+02, .187544E+02, .149485E+02,
     +  .120223E+02, .974913E+01, .796808E+01, .655944E+01,
     +  .543478E+01, .452807E+01, .379307E+01, .318570E+01,
     +  .268606E+01, .226678E+01, .191626E+01, .162057E+01 /
        DATA (UPDI(I),I=10609,10660) /
     +  .137027E+01, .115789E+01, .977475E+00, .824136E+00,
     +  .693779E+00, .582946E+00, .488697E+00, .408549E+00,
     +  .340418E+00, .282552E+00, .233397E+00, .191950E+00,
     +  .156734E+00, .127119E+00, .102324E+00, .816736E-01,
     +  .645833E-01, .505392E-01, .390925E-01, .298520E-01,
     +  .224749E-01, .166331E-01, .121189E-01, .863241E-02,
     +  .600727E-02, .406993E-02, .267298E-02, .169285E-02,
     +  .102620E-02, .591293E-03, .318463E-03, .158557E-03,
     +  .711020E-04, .277305E-04, .890008E-05, .213400E-05,
     +  .326188E-06, .220969E-07, .000000E+00, .227362E+07,
     +  .169436E+07, .123769E+07, .903592E+06, .659232E+06,
     +  .480624E+06, .350165E+06, .254942E+06, .185487E+06,
     +  .134862E+06, .979889E+05, .711513E+05, .516323E+05 /
        DATA (UPDI(I),I=10661,10712) /
     +  .374458E+05, .271427E+05, .196647E+05, .142414E+05,
     +  .103103E+05, .746293E+04, .540145E+04, .390993E+04,
     +  .283105E+04, .205108E+04, .148719E+04, .107965E+04,
     +  .784891E+03, .571936E+03, .415987E+03, .304937E+03,
     +  .224394E+03, .165876E+03, .123269E+03, .921534E+02,
     +  .694159E+02, .526423E+02, .402487E+02, .310401E+02,
     +  .241543E+02, .189689E+02, .150315E+02, .120210E+02,
     +  .969467E+01, .788097E+01, .645329E+01, .531862E+01,
     +  .440787E+01, .367287E+01, .306822E+01, .257314E+01,
     +  .215973E+01, .181589E+01, .152741E+01, .128457E+01,
     +  .107969E+01, .906632E+00, .760361E+00, .636693E+00,
     +  .532114E+00, .443664E+00, .368861E+00, .305629E+00,
     +  .252233E+00, .207142E+00, .169355E+00, .137452E+00 /
        DATA (UPDI(I),I=10713,10764) /
     +  .110795E+00, .886250E-01, .702872E-01, .552161E-01,
     +  .429198E-01, .329709E-01, .250000E-01, .186853E-01,
     +  .137243E-01, .992220E-02, .701044E-02, .483738E-02,
     +  .324838E-02, .211361E-02, .132545E-02, .795076E-03,
     +  .453012E-03, .241053E-03, .118470E-03, .523900E-04,
     +  .201319E-04, .636409E-05, .150505E-05, .228730E-06,
     +  .159930E-07, .000000E+00, .282604E+07, .209879E+07,
     +  .152676E+07, .110996E+07, .806348E+06, .585342E+06,
     +  .424589E+06, .307749E+06, .222893E+06, .161312E+06,
     +  .116658E+06, .843032E+05, .608789E+05, .439330E+05,
     +  .316841E+05, .228367E+05, .164515E+05, .118463E+05,
     +  .852765E+04, .613740E+04, .441716E+04, .317954E+04,
     +  .228974E+04, .165005E+04, .119038E+04, .859847E+03 /
        DATA (UPDI(I),I=10765,10816) /
     +  .622491E+03, .449731E+03, .327476E+03, .239361E+03,
     +  .175748E+03, .129727E+03, .963344E+02, .720888E+02,
     +  .543164E+02, .412673E+02, .316312E+02, .244685E+02,
     +  .191056E+02, .150558E+02, .119755E+02, .960688E+01,
     +  .776896E+01, .632873E+01, .518909E+01, .427825E+01,
     +  .354636E+01, .294691E+01, .245836E+01, .205237E+01,
     +  .171642E+01, .143606E+01, .120133E+01, .100440E+01,
     +  .838972E+00, .699915E+00, .582979E+00, .484623E+00,
     +  .401883E+00, .332291E+00, .273793E+00, .224678E+00,
     +  .183445E+00, .149102E+00, .120287E+00, .963663E-01,
     +  .766030E-01, .603660E-01, .471137E-01, .363777E-01,
     +  .277544E-01, .208969E-01, .155058E-01, .113035E-01,
     +  .810906E-02, .568320E-02, .388860E-02, .258831E-02 /
        DATA (UPDI(I),I=10817,10868) /
     +  .166856E-02, .103614E-02, .615063E-03, .346566E-03,
     +  .182213E-03, .884100E-04, .385631E-04, .146045E-04,
     +  .454895E-05, .106147E-05, .160391E-06, .115561E-07,
     +  .000000E+00, .346139E+07, .256214E+07, .185640E+07,
     +  .134417E+07, .972496E+06, .703022E+06, .507804E+06,
     +  .366492E+06, .264286E+06, .190426E+06, .137095E+06,
     +  .986201E+05, .708872E+05, .509137E+05, .365418E+05,
     +  .262086E+05, .187862E+05, .134584E+05, .963763E+04,
     +  .689933E+04, .493854E+04, .353509E+04, .253135E+04,
     +  .181359E+04, .130063E+04, .933811E+03, .671904E+03,
     +  .482374E+03, .349043E+03, .253512E+03, .184958E+03,
     +  .135662E+03, .100108E+03, .744491E+02, .557532E+02,
     +  .421070E+02, .320881E+02, .246825E+02, .191676E+02 /
        DATA (UPDI(I),I=10869,10920) /
     +  .150245E+02, .118886E+02, .948858E+01, .763457E+01,
     +  .618798E+01, .504812E+01, .414088E+01, .341497E+01,
     +  .282298E+01, .234271E+01, .194550E+01, .161847E+01,
     +  .134697E+01, .112089E+01, .932239E+00, .774626E+00,
     +  .642851E+00, .532629E+00, .440412E+00, .363252E+00,
     +  .298706E+00, .244752E+00, .199711E+00, .162120E+00,
     +  .131000E+00, .105052E+00, .836477E-01, .660799E-01,
     +  .517433E-01, .401223E-01, .307740E-01, .233193E-01,
     +  .174349E-01, .128438E-01, .929308E-02, .661562E-02,
     +  .459932E-02, .312066E-02, .205898E-02, .131512E-02,
     +  .808724E-03, .475099E-03, .264758E-03, .137555E-03,
     +  .659004E-04, .283576E-04, .105871E-04, .325030E-05,
     +  .748606E-06, .112470E-06, .833735E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
