/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfConvention.h
    \brief Definition of the Template class NetcdfConvention.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#ifndef NetcdfConvention_H
#define NetcdfConvention_H

#include "magics.h"
#include "MagTranslator.h"
#include "Factory.h"


namespace magics {

class XmlNode; 

class NetcdfConvention  {

public:
	NetcdfConvention();
	virtual ~NetcdfConvention();
    virtual void set(const map<string, string>&) {}
    virtual void set(const XmlNode&) {}
    virtual bool accept(const string&) { return false; }
    virtual NetcdfConvention* clone() { return new NetcdfConvention(); }
    void toxml(ostream&, int)  const {}


protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	NetcdfConvention(const NetcdfConvention&);
    //! Overloaded << operator to copy - No copy allowed
	NetcdfConvention& operator=(const NetcdfConvention&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const NetcdfConvention& p)
		{ p.print(s); return s; }

};

template<>
class MagTranslator<string, NetcdfConvention> { 
public:
	NetcdfConvention* operator()(const string& val ) {
		 return SimpleObjectMaker<NetcdfConvention>::create(val);
	}     
    NetcdfConvention* magics(const string& param)
    {
        NetcdfConvention* object;
		ParameterManager::update(param, object);
		return object;
    }
};
} // namespace magics
#endif
