      SUBROUTINE DCBFIX(MATVEC,PCONDL,A,IA,C,IC,IPC,
     2   AA,BB,NSTEPS,B,X,R,DX,WORK,N)
C***BEGIN PROLOGUE  DCBFIX
C***REFER TO  DPPCG,DCGCHB
C***ROUTINES CALLED  DAXPY,DCOPY,DSCAL
C***REVISION DATE  870501   (YYMMDD)
C***END PROLOGUE  DCBFIX
C
C     THIS SUBROUTINE PERFORMS NSTEPS STEPS OF THE CHEBYSHEV ITERATION
C     (BASED ON THE INTERVAL [AA,BB]) ON THE LINEAR SYSTEM AX=B.  THE
C     INITIAL GUESS X0 IS ASSUMED TO BE THE ZERO VECTOR.  R AND DX ARE
C     WORK ARRAYS OF LENGTH .GE. N.  IF PRECONDITIONING IS REQUESTED
C     (IPC .NE. 0), AN ADDITIONAL WORK ARRAY, WORK, MUST BE PASSED.
C     IN THIS CASE THE PROBLEM SOLVED IS C*AX = B.
C
C     *** DECLARATIONS ***
      IMPLICIT  DOUBLE PRECISION(A-H,O-Z)
      EXTERNAL  MATVEC,PCONDL
      DIMENSION B(N),X(N),R(N),DX(N),WORK(N)
C
C***FIRST EXECUTABLE STATEMENT  DCBFIX
 1    CONTINUE
C
C     *** CHECK FOR NSTEPS .LE. 0 ***
      IF (NSTEPS .LE. 0) THEN
C        *** RETURN X=B ***
         CALL DCOPY(N,B,1,X,1)
         RETURN
      END IF
C         
C     *** INITIALIZE ITERATION PARAMETERS ***
      D  = 0.50D0*(BB+AA)
      C2 = 0.250D0*(BB-AA)*(BB-AA)
      P1 = 2.0D0/D
      P2 = 0.0D0
C
C     *** EXECUTE STEP ONE OF THE ITERATION ***
      RECIPD = 1.0D0/D
      DO 10 I = 1, N
         DX(I) = RECIPD*B(I)
         X(I) = DX(I)
 10   CONTINUE
C
C     *** MAIN LOOP OF THE CHEBYSHEV ITERATION ***
      DO 40 ISTEP = 2, NSTEPS
C
C        *** COMPUTE MATRIX TIMES X ***
         IF (IPC .EQ. 0) THEN
            CALL MATVEC(0,A,IA,WDUMMY,X,R,N)
         ELSE
            CALL MATVEC(0,A,IA,WDUMMY,X,WORK,N)
            CALL PCONDL(0,C,IC,WDUMMY,WORK,R,N)
         END IF
C
C        *** COMPUTE NEW DX AND X ***
         P2 = C2*P1 / (4.0D0*D - C2*P1)
         P1 = (1.0D0 + P2) / D
         DO 30 I = 1, N
            DX(I) = P2*DX(I) + P1*(B(I)-R(I))
            X(I) = X(I) + DX(I)
 30      CONTINUE
C
 40   CONTINUE
C
      RETURN
      END
