/* SPDX-License-Identifier: (BSD-3-Clause OR GPL-2.0)
 * Copyright(c) 2021 Intel Corporation
 */

#ifndef _ICP_QAT_HW_GEN4_COMP_DEFS_H
#define _ICP_QAT_HW_GEN4_COMP_DEFS_H

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_BITPOS	31
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SCB_CONTROL_ENABLE = 0x0,
	ICP_QAT_HW_COMP_20_SCB_CONTROL_DISABLE = 0x1,
} icp_qat_hw_comp_20_scb_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SCB_CONTROL_DISABLE

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_BITPOS	30
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_ALL = 0x0,
	ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_FC_ONLY = 0x1,
} icp_qat_hw_comp_20_rmb_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_RMB_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_RMB_CONTROL_RESET_ALL

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_BITPOS	28
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_MASK		0x3

typedef enum {
	ICP_QAT_HW_COMP_20_SOM_CONTROL_NORMAL_MODE = 0x0,
	ICP_QAT_HW_COMP_20_SOM_CONTROL_REPLAY_MODE = 0x1,
	ICP_QAT_HW_COMP_20_SOM_CONTROL_INPUT_CRC = 0x2,
	ICP_QAT_HW_COMP_20_SOM_CONTROL_RESERVED_MODE = 0x3,
} icp_qat_hw_comp_20_som_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SOM_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SOM_CONTROL_NORMAL_MODE

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_BITPOS	27
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_NO_SKIP = 0x0,
	ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_SKIP_HASH_READS = 0x1,
} icp_qat_hw_comp_20_skip_hash_rd_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_RD_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SKIP_HASH_RD_CONTROL_NO_SKIP

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_BITPOS	26
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_UNLOAD = 0x0,
	ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_NO_UNLOAD = 0x1,
} icp_qat_hw_comp_20_scb_unload_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_UNLOAD_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SCB_UNLOAD_CONTROL_UNLOAD

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_BITPOS 21
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_MASK   0x1

typedef enum {
	ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_ENABLE = 0x0,
	ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_DISABLE = 0x1,
} icp_qat_hw_comp_20_disable_token_fusion_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_DISABLE_TOKEN_FUSION_CONTROL_DEFAULT_VAL \
		ICP_QAT_HW_COMP_20_DISABLE_TOKEN_FUSION_CONTROL_ENABLE

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LBMS_BITPOS	19
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LBMS_MASK		0x3

typedef enum {
	ICP_QAT_HW_COMP_20_LBMS_LBMS_64KB = 0x0,
	ICP_QAT_HW_COMP_20_LBMS_LBMS_256KB = 0x1,
	ICP_QAT_HW_COMP_20_LBMS_LBMS_1MB = 0x2,
	ICP_QAT_HW_COMP_20_LBMS_LBMS_4MB = 0x3,
} icp_qat_hw_comp_20_lbms_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LBMS_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_LBMS_LBMS_64KB

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_MODE_RESET_MASK_BITPOS	18
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_MODE_RESET_MASK_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SCB_MODE_RESET_MASK_RESET_COUNTERS = 0x0,
	ICP_QAT_HW_COMP_20_SCB_MODE_RESET_MASK_RESET_COUNTERS_AND_HISTORY = 0x1,
} icp_qat_hw_comp_20_scb_mode_reset_mask_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SCB_MODE_RESET_MASK_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SCB_MODE_RESET_MASK_RESET_COUNTERS

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_BITPOS	9
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_MASK	0x1ff
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LAZY_PARAM_DEFAULT_VAL 258

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_BITPOS	0
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_MASK	0x1ff
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_NICE_PARAM_DEFAULT_VAL 259

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_BITPOS	14
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_MASK		0x7

typedef enum {
	ICP_QAT_HW_COMP_20_HBS_CONTROL_HBS_IS_32KB = 0x0,
} icp_qat_hw_comp_20_hbs_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HBS_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_HBS_CONTROL_HBS_IS_32KB

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_ABD_BITPOS	13
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_ABD_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_ABD_ABD_ENABLED = 0x0,
	ICP_QAT_HW_COMP_20_ABD_ABD_DISABLED = 0x1,
} icp_qat_hw_comp_20_abd_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_ABD_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_ABD_ABD_ENABLED

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LLLBD_CTRL_BITPOS	12
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LLLBD_CTRL_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_LLLBD_CTRL_LLLBD_ENABLED = 0x0,
	ICP_QAT_HW_COMP_20_LLLBD_CTRL_LLLBD_DISABLED = 0x1,
} icp_qat_hw_comp_20_lllbd_ctrl_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_LLLBD_CTRL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_LLLBD_CTRL_LLLBD_ENABLED

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_BITPOS	8
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_MASK		0xf

typedef enum {
	ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_1 = 0x1,
	ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_6 = 0x3,
	ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_9 = 0x4,
} icp_qat_hw_comp_20_search_depth_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SEARCH_DEPTH_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SEARCH_DEPTH_LEVEL_1

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_BITPOS	5
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_MASK	0x7

typedef enum {
	ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_ILZ77 = 0x0,
	ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_DEFLATE = 0x1,
	ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_LZ4 = 0x2,
	ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_LZ4S = 0x3,
} icp_qat_hw_comp_20_hw_comp_format_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_HW_COMP_FORMAT_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_HW_COMP_FORMAT_DEFLATE

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_BITPOS	4
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_MIN_MATCH_CONTROL_MATCH_3B = 0x0,
	ICP_QAT_HW_COMP_20_MIN_MATCH_CONTROL_MATCH_4B = 0x1,
} icp_qat_hw_comp_20_min_match_control_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_MIN_MATCH_CONTROL_MATCH_3B

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_BITPOS	3
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_MASK		0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_ALLOW = 0x0,
	ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_DONT_ALLOW = 0x1,
} icp_qat_hw_comp_20_skip_hash_collision_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_COLLISION_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SKIP_HASH_COLLISION_ALLOW

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_BITPOS	2
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_ALLOW = 0x0,
	ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_DONT_ALLOW = 0x1,
} icp_qat_hw_comp_20_skip_hash_update_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_SKIP_HASH_UPDATE_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_SKIP_HASH_UPDATE_ALLOW

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_BITPOS	1
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_TOKEN = 0x0,
	ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_LITERAL = 0x1,
} icp_qat_hw_comp_20_byte_skip_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_BYTE_SKIP_DEFAULT_VAL	\
		ICP_QAT_HW_COMP_20_BYTE_SKIP_3BYTE_TOKEN

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_BITPOS	0
#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_MASK	0x1

typedef enum {
	ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_DISABLED = 0x0,
	ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_ENABLED = 0x1,
} icp_qat_hw_comp_20_extended_delay_match_mode_t;

#define ICP_QAT_HW_COMP_20_CONFIG_CSR_EXTENDED_DELAY_MATCH_MODE_DEFAULT_VAL \
		ICP_QAT_HW_COMP_20_EXTENDED_DELAY_MATCH_MODE_EDMM_DISABLED

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_BITPOS 31
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_MASK   0x1

typedef enum {
	ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_ENABLE = 0x0,
	ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_DISABLE = 0x1,
} icp_qat_hw_decomp_20_speculative_decoder_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_SPECULATIVE_DECODER_CONTROL_DEFAULT_VAL\
		ICP_QAT_HW_DECOMP_20_SPECULATIVE_DECODER_CONTROL_ENABLE

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MINI_CAM_CONTROL_BITPOS	30
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MINI_CAM_CONTROL_MASK	0x1

typedef enum {
	ICP_QAT_HW_DECOMP_20_MINI_CAM_CONTROL_ENABLE = 0x0,
	ICP_QAT_HW_DECOMP_20_MINI_CAM_CONTROL_DISABLE = 0x1,
} icp_qat_hw_decomp_20_mini_cam_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MINI_CAM_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_DECOMP_20_MINI_CAM_CONTROL_ENABLE

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_BITPOS	14
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_MASK	0x7

typedef enum {
	ICP_QAT_HW_DECOMP_20_HBS_CONTROL_HBS_IS_32KB = 0x0,
} icp_qat_hw_decomp_20_hbs_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HBS_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_DECOMP_20_HBS_CONTROL_HBS_IS_32KB

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LBMS_BITPOS	8
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LBMS_MASK	0x3

typedef enum {
	ICP_QAT_HW_DECOMP_20_LBMS_LBMS_64KB = 0x0,
	ICP_QAT_HW_DECOMP_20_LBMS_LBMS_256KB = 0x1,
	ICP_QAT_HW_DECOMP_20_LBMS_LBMS_1MB = 0x2,
	ICP_QAT_HW_DECOMP_20_LBMS_LBMS_4MB = 0x3,
} icp_qat_hw_decomp_20_lbms_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LBMS_DEFAULT_VAL	\
		ICP_QAT_HW_DECOMP_20_LBMS_LBMS_64KB

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_BITPOS	5
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_MASK	0x7

typedef enum {
	ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_DEFLATE = 0x1,
	ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_LZ4 = 0x2,
	ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_LZ4S = 0x3,
} icp_qat_hw_decomp_20_hw_comp_format_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_HW_DECOMP_FORMAT_DEFAULT_VAL	\
		ICP_QAT_HW_DECOMP_20_HW_DECOMP_FORMAT_DEFLATE

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_BITPOS	4
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_MASK		0x1

typedef enum {
	ICP_QAT_HW_DECOMP_20_MIN_MATCH_CONTROL_MATCH_3B = 0x0,
	ICP_QAT_HW_DECOMP_20_MIN_MATCH_CONTROL_MATCH_4B = 0x1,
} icp_qat_hw_decomp_20_min_match_control_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_MIN_MATCH_CONTROL_DEFAULT_VAL	\
		ICP_QAT_HW_DECOMP_20_MIN_MATCH_CONTROL_MATCH_3B

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LZ4_BLOCK_CHECKSUM_PRESENT_BITPOS 3
#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LZ4_BLOCK_CHECKSUM_PRESENT_MASK   0x1

typedef enum {
	ICP_QAT_HW_DECOMP_20_LZ4_BLOCK_CHKSUM_ABSENT  =  0x0,
	ICP_QAT_HW_DECOMP_20_LZ4_BLOCK_CHKSUM_PRESENT  =  0x1,
} icp_qat_hw_decomp_20_lz4_block_checksum_present_t;

#define ICP_QAT_HW_DECOMP_20_CONFIG_CSR_LZ4_BLOCK_CHECKSUM_PRESENT_DEFAULT_VAL \
	ICP_QAT_HW_DECOMP_20_LZ4_BLOCK_CHKSUM_ABSENT

#endif /* _ICP_QAT_HW_GEN4_COMP_DEFS_H */
