// ----------------------------------------------------------------------------
// Copyright (C) 2002-2006 Marcin Kalicinski
// Copyright (C) 2009 Sebastian Redl
//
// Distributed under the Boost Software License, Version 1.0. 
// (See accompanying file LICENSE_1_0.txt or copy at 
// http://www.boost.org/LICENSE_1_0.txt)
//
// For more information, see www.boost.org
// ----------------------------------------------------------------------------

#ifndef XML_PARSER_TEST_DATA_HPP_INCLUDED
#define XML_PARSER_TEST_DATA_HPP_INCLUDED

///////////////////////////////////////////////////////////////////////////////
// Test data

// Correct
const char *ok_data_1 = 
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<start/>";

// Correct
const char *ok_data_2 = 
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<root>\n"
    "<a>&lt;&gt;&amp;</a>\n"
    "<b>1&lt;2&gt;3&amp;4</b>\n"
    "<c> &lt; &gt; &amp; </c>\n"
    "<d>&#32;</d>\n"
    "</root>\n";

// Correct
const char *ok_data_3 =
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<!DOCTYPE spec PUBLIC \"-//W3C//DTD Specification::19990205//EN\" \"dtds/xmlspec.dtd\" [\n"
    "<!ENTITY doc-type \"WD\">\n"
    "<!ENTITY iso6.doc.date '29-May-1999'>\n"
    "]>\n"
    "<!--ArborText, Inc., 1988-1998, v.4002-->\n"
    "<?Pub UDT _bookmark _target?>\n"
    "<?Pub Inc?>\n"
    "<?xml-stylesheet\n"
    "href=\"file:///C|/Program%20Files/SoftQuad/XMetaL%201/display/xmlspec.css\"\n"
    "type=\"text/css\"?>\n"
    "<spec>\n"
    "\n"
    "<!-- Last edited: 27 May 1999 by bent -->\n"
    "<header><?Pub Dtl?>\n"
    "\t<title><![CDATA[XML Linking Language (XLink)]]></title>\n"
    "\t<version>Version 1.0</version>\n"
    "\t<w3c-designation>WD-xlink-19990527</w3c-designation>\n"
    "\t<w3c-doctype>World Wide Web Consortium Working Draft</w3c-doctype>\n"
    "\t<pubdate><day>29</day><month>May</month><year>1999</year></pubdate>\n"
    "\t<notice>\n"
    "\t<p>This draft is for public discussion.</p>\n"
    "\t</notice>\n"
    "\t<publoc><loc href=\"http://www.w3.org/XML/Group/1999/05/WD-xlink-current\">http://www.w3.org/XML/Group/1999/05/WD-xlink-current</loc></publoc>\n"
    "\t<prevlocs>\n"
    "\t<!--Check: was it actually August?-->\n"
    "\t<loc href=\"http://www.w3.org/XML/Group/1999/05/WD-xlink-19990527\">http://www.w3.org/XML/Group/1999/05/WD-xlink-19990527</loc>\n"
    "\t<loc href=\"http://www.w3.org/XML/Group/1999/05/WD-xlink-19990505\">http://www.w3.org/XML/Group/1999/05/WD-xlink-19990505</loc>\n"
    "\t<loc href=\"http://www.w3.org/TR/1998/WD-xlink-19980303\">http://www.w3.org/TR/1998/WD-xlink-19980303</loc>\n"
    "\t<loc href=\"http://www.w3.org/TR/WD-xml-link-970630\">http://www.w3.org/TR/WD-xml-link-970630</loc></prevlocs>\n"
    "\n"
    "   <authlist>\n"
    "       <!--Updated author hrefs  dorchard-->\n"
    "       <!-- Update Steve's email - bent --> \n"
    "       <author>\n"
    "           <name>Steve DeRose</name>\n"
    "           <affiliation>Inso Corp. and Brown University</affiliation>\n"
    "           <email href=\"mailto:Steven_DeRose@Brown.edu\">Steven_DeRose@Brown.edu</email>\n"
    "       </author>\n"
    "       <author>\n"
    "           <name>David Orchard</name>\n"
    "           <affiliation>IBM Corp.</affiliation>\n"
    "           <email href=\"mailto:dorchard@ca.ibm.com\">dorchard@ca.ibm.com</email>\n"
    "       </author>\n"
    "       <author>\n"
    "           <name>Ben Trafford</name>\n"
    "           <affiliation>Invited Expert</affiliation>\n"
    "           <email href=\"mailto:bent@exemplary.net\">bent@exemplary.net</email>\n"
    "       </author>\n"
    "       <!-- I suggest we move Eve and Tim down to the Acknowledgements section. We\n"
    "       also ought to add Gabe Beged-Dov there, as well. bent\n"
    "       how shall we cite Tim? sjd What about with an Acknowledgments section?\n"
    "       -elm <AUTHOR> <NAME>Tim Bray</NAME> <AFFILIATION>Textuality</AFFILIATION>\n"
    "       <EMAIL>tbray@textuality.com</EMAIL> </AUTHOR>-->\n"
    "   </authlist>\n"
    "\n"
    "   <status>\n"
    "       <p>This is a W3C Working Draft for review by W3C members and other interested parties. It is a draft document and may be updated, replaced, or obsoleted by other documents at any time. It is inappropriate to use W3C Working Drafts as reference material or to cite them as other than \"work in progress\". A list of current W3C working drafts can be found at <loc href=\"http://www.w3.org/TR\">http://www.w3.org/TR</loc>.</p>\n"
    "       <p><emph>Note:</emph> Since working drafts are subject to frequent change, you are advised to reference the above URI, rather than the URIs for working drafts themselves. Some of the work remaining is described in <specref ref=\"unfinished\"/>. </p>\n"
    "       <p>This work is part of the W3C XML Activity (for current status, see <loc href=\"http://www.w3.org/MarkUp/SGML/Activity\">http://www.w3.org/XML/Activity         </loc>). For information about the XPointer language which is expected to be used with XLink, see <loc href=\"http://www.w3.org/MarkUp/SGML/Activity\">http://www.w3.org/TR/WD-xptr</loc>.\n"
    "       </p>\n"
    "       <p>See <loc href=\"http://www.w3.org/TR/NOTE-xlink-principles\">http://www.w3.org/TR/NOTE-xlink-principles </loc> for additional background on the design principles informing XLink.</p>\n"
    "       <p>Also see <loc href=\"http://www.w3.org/TR/NOTE-xlink-req/\">http://www.w3.org/TR/NOTE-xlink-req/</loc> for the XLink requirements that this document attempts to satisfy.</p>\n"
    "   </status>\n"
    "\n"
    "   <abstract>\n"
    "       <!-- edited the abstract for further clarity - bent -->\n"
    "       <p>This specification defines constructs that may be inserted into XML DTDs, schemas and document instances to describe links between objects. It uses XML syntax to create structures that can describe the simple unidirectional hyperlinks of today's HTML as well as more sophisticated links.</p>\n"
    "   </abstract>\n"
    "\n"
    "   <pubstmt>\n"
    "       <p>Burlington, Seekonk, et al.: World-Wide Web Consortium, XML Working Group, 1998.</p>\n"
    "   </pubstmt>\n"
    "\n"
    "   <sourcedesc>\n"
    "       <p>Created in electronic form.</p>\n"
    "   </sourcedesc>\n"
    "\n"
    "   <langusage>\n"
    "       <language id=\"en\">English</language>\n"
    "       <language id=\"ebnf\">Extended Backus-Naur Form (formal grammar)</language>\n"
    "   </langusage>\n"
    "\n"
    "   <revisiondesc>\n"
    "       <slist>\n"
    "           <sitem>1997-01-15 : Skeleton draft by TB</sitem>\n"
    "           <sitem>1997-01-24 : Fleshed out by sjd</sitem>\n"
    "           <sitem>1997-04-08 : Substantive draft</sitem>\n"
    "           <sitem>1997-06-30 : Public draft</sitem>\n"
    "           <sitem>1997-08-01 : Public draft</sitem>\n"
    "           <sitem>1997-08-05 : Prose/organization work by sjd</sitem>\n"
    "           <sitem>1997-10-14: Conformance and design principles; a bit of cleanup by elm</sitem>\n"
    "           <sitem>1997-11-07: Update for editorial issues per issues doc, by sjd.</sitem>\n"
    "           <sitem>1997-12-01: Update for editorial issues per issues doc in preparation for F2F meeting, by sjd.</sitem>\n"
    "           <sitem>1998-01-13: Editorial cleanup, addition of new design principles, by elm.</sitem>\n"
    "           <sitem>1998-02-27: Splitting out of XLink and XPointer, by elm.</sitem>\n"
    "           <sitem>1998-03-03: Moved most of the XPointer locator stuff here. elm</sitem>\n"
    "           <sitem>1999-04-24: Editorial rewrites to represent new ideas on XLink, especially the inclusion of arcs. bent</sitem>\n"
    "           <sitem>1999-05-05: Prose/organization work by dorchard. Moved much of the semantics section around, from: locators, link semantics, remote resource semantics, local resource semantics; to: resource semantics, locators, behavior semantics, link semantics, arc semantics</sitem>\n"
    "           <sitem>1999-05-12: Prose/organization work. Re-organized some of the sections, removed XML constructs from the document, added descriptive prose, edited document text for clarity. Rewrote the link recognition section. bent</sitem>\n"
    "           <sitem>1999-05-17: Further prose work. Added non-normative examples. Clarified arcs. bent</sitem>\n"
    "           <sitem>1999-05-23: Edited for grammar and clarity. bent</sitem>\n"
    "           <sitem>1999-05-27: Final once-over before sending to group. Fixed sjd's email address. bent</sitem>\n"
    "       </slist>\n"
    "   </revisiondesc>\n"
    "</header>\n"
    "\n"
    "<body>\n"
    "   <div1><?Pub Dtl?>\n"
    "       <head>Introduction</head>\n"
    "       <p>This specification defines constructs that may be inserted into XML DTDs, schemas, and document instances to describe links between objects. A <termref def=\"dt-link\">link</termref>, as the term is used here, is an explicit relationship between two or more data objects or portions of data objects. This specification is concerned with the syntax used to assert link existence and describe link characteristics. Implicit (unasserted) relationships, for example that of one word to the next or that of a word in a text to its entry in an on-line dictionary are obviously important, but outside its scope.</p>\n"
    "       <p>Links are asserted by <xtermref href=\"WD-xml-lang.html#dt-element\">elements </xtermref> contained in <xtermref href=\"WD-xml-lang.html#dt-xml-doc\">XML document instances</xtermref>. The simplest case is very like an HTML <code>A</code> link, and has these characteristics:\n"
    "           <ulist>\n"
    "               <item><p>The link is expressed at one of its ends (similar to the <code>A</code> element in some document)</p></item>\n"
    "               <item><p>Users can only initiate travel from that end to the other</p></item>\n"
    "               <item><p>The link's effect on windows, frames, go-back lists, stylesheets in use, and so on is mainly determined by browsers, not by the link itself. For example, traveral of <code>A</code> links normally replaces the current view, perhaps with a user option to open a new window.</p></item>\n"
    "               <item><p>The link goes to only one destination (although a server may have great freedom in finding or dynamically creating that destination).</p></item>\n"
    "           </ulist>\n"
    "       </p>\n"
    "       <p>While this set of characteristics is already very powerful and obviously has proven itself highly useful and effective, each of these assumptions also limits the range of hypertext functionality. The linking model defined here provides ways to create links that go beyond each of these specific characteristics, thus providing features previously available mostly in dedicated hypermedia systems.\n"
    "       </p>\n"
    "\n"
    "<div2>\n"
    "   <head>Origin and Goals</head>\n"
    "   <p>Following is a summary of the design principles governing XLink:\n"
    "       <olist>\n"
    "           <item><p>XLink must be straightforwardly usable over the Internet. </p></item>\n"
    "           <item><p>XLink must be usable by a wide variety of link usage domains and classes of linking application software.</p></item>\n"
    "           <item><p>XLink must support HTML 4.0 linking constructs.</p></item>\n"
    "           <item><p>The XLink expression language must be XML.</p></item>\n"
    "           <item><p>The XLink design must be formal, concise, and illustrative.</p></item>\n"
    "           <item><p>XLinks must be human-readable and human-writable.</p></item>\n"
    "           <item><p>XLinks may reside within or outside the documents in which the\n"
    "           participating resources reside. </p></item>\n"
    "           <item><p>XLink must represent the abstract structure and significance of links.</p></item>\n"
    "           <item><p>XLink must be feasible to implement.</p></item>\n"
    "           <item><p>XLink must be informed by knowledge of established hypermedia systems and standards.</p></item>\n"
    "       </olist>\n"
    "   </p>\n"
    "</div2>\n"
    "<!--Changed the list of requirements to reflect current XLink requirements\n"
    "document. bent-->\n"
    "\n"
    "<div2>\n"
    "   <head>Relationship to Existing Standards</head>\n"
    "   <p>Three standards have been especially influential:\n"
    "       <ulist>\n"
    "           <item><p><emph>HTML:</emph> Defines several SGML element types that represent links.</p></item>\n"
    "           <item><p><emph>HyTime:</emph> Defines inline and out-of-line link structures and some semantic features, including traversal control and presentation of objects. <!--Changed from \"placement of objects into a display or other space\" -elm-->\n"
    "           </p></item>\n"
    "           <item><p><emph>Text Encoding Initiative Guidelines (TEI P3):</emph> Provides structures for creating links, aggregate objects, and link collections out of them.</p></item>\n"
    "       </ulist>\n"
    "   </p>\n"
    "   <p>Many other linking systems have also informed this design, especially Dexter, FRESS, MicroCosm, and InterMedia.</p>\n"
    "</div2>\n"
    "\n"
    "<div2>\n"
    "   <head>Terminology</head>\n"
    "   <p>The following basic terms apply in this document. <!--<IMG\n"
    "   SRC=\"local://./linkdiag.gif\">(figure to be inserted)-->\n"
    "       <glist>\n"
    "           <gitem>\n"
    "           <label><termdef id=\"dt-arc\" term=\"Arc\">arc</termdef></label>\n"
    "           <def><p>A symbolic representation of traversal behavior in links, especially the direction, context and timing of traversal.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-eltree\" term=\"Element Tree\">element tree</termdef></label>\n"
    "               <def><p>A representation of the relevant structure specified by the tags and attributes in an XML document, based on \"groves\" as defined in the ISO DSSSL standard. </p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-inline\" term=\"In-Line Link\">inline link</termdef></label>\n"
    "               <def><p>Abstractly, a <termref def=\"dt-link\">link</termref> which serves as one of its own <termref def=\"dt-resource\">resources</termref>. Concretely, a link where the content of the <termref def=\"dt-linkel\">linking   element</termref> serves as a <termref def=\"dt-particip-resource\">participating resource</termref>.\n"
    "               HTML <code>A</code>, HyTime <code>clink</code>, and TEI <code>XREF</code>\n"
    "               are all inline links.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-link\" term=\"Link\">link</termdef></label>\n"
    "               <def><p>An explicit relationship between two or more data objects or portions of data objects.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-linkel\" term=\"Linking Element\">linking element </termdef></label>\n"
    "               <def><p>An <xtermref href=\"WD-xml-lang.html#dt-element\">element</xtermref> that asserts the existence and describes the characteristics of a <termref def=\"dt-link\"> link</termref>.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-local-resource\" term=\"Local Resource\">local resource</termdef></label>\n"
    "               <def><p>The content of an <termref def=\"dt-inline\">inline</termref>linking element. Note that the content of the linking element could be explicitly pointed to by means of a regular <termref def=\"dt-locator\">locator</termref> in the same linking element, in which case the resource is considered <termref def=\"dt-remote-resource\"> remote</termref>, not local.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-locator\" term=\"Locator\">locator</termdef> </label>\n"
    "               <def><p>Data, provided as part of a link, which identifies a\n"
    "               <termref def=\"dt-resource\">resource</termref>.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-multidir\" term=\"Multi-Directional Link\">multidirectional link</termdef></label>\n"
    "               <def><p>A <termref def=\"dt-link\">link</termref> whose <termref def=\"dt-traversal\"> traversal</termref> can be initiated from more than one of its <termref  def=\"dt-particip-resource\"> participating resources</termref>. Note that being able to \"go back\" after following a one-directional link does not make the link multidirectional.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-outofline\" term=\"Out-of-line Link\">out-of-line link</termdef></label>\n"
    "               <def><p>A <termref def=\"dt-link\">link</termref> whose content does not serve as one of the link's <termref def=\"dt-particip-resource\">participating resources </termref>. Such links                        presuppose a notion like <termref def=\"dt-xlg\">extended link groups</termref>, which instruct application software where to look for links. Out-of-line links are generally required for supporting multidirectional <termref def=\"dt-traversal\">traversal</termref> and for allowing read-only resources to have outgoing links.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-parsedq\" term=\"Parsed\">parsed</termdef></label> <def><p>In the context of link behavior, a parsed link is any link           whose content is transcluded into the document where the link originated. The   use of the term \"parsed\" directly refers to the concept in XML of a\n"
    "               parsed entity.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-particip-resource\" term=\"Participating Resource\"> participating resource</termdef></label>\n"
    "               <def><p>A <termref def=\"dt-resource\">resource</termref> that belongs to a link. All resources are potential contributors to a link; participating resources are the actual contributors to a particular link.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-remote-resource\" term=\"Remote Resource\">remote resource</termdef></label>\n"
    "               <def><p>Any participating resource of a link that is pointed to with a locator. </p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-resource\" term=\"Resource\">resource</termdef></label>\n"
    "               <def><p>In the abstract sense, an addressable unit of information or service that is participating in a <termref def=\"dt-link\">link</termref>. Examples include files, images, documents, programs, and query results. Concretely, anything reachable by the use of a <termref def=\"dt-locator\">locator</termref> in some <termref def=\"dt-linkel\">linking    element</termref>. Note that this term and its definition are taken from the basic specifications governing the World Wide Web. <!--Joel notes: need link here. bent asks: A link?-->\n"
    "                </p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-subresource\" term=\"sub-Resource\">sub-resource</termdef></label>\n"
    "               <def><p>A portion of a resource, pointed to as the precise  destination of a link. As one example, a link might specify that an entire  document be retrieved and displayed, but that some specific part(s) of it is the specific linked data, to be treated in an application-appropriate manner such as indication by highlighting, scrolling, etc.</p></def>\n"
    "           </gitem>\n"
    "           <gitem>\n"
    "               <label><termdef id=\"dt-traversal\" term=\"Traversal\">traversal</termdef></label>\n"
    "               <def><p>The action of using a <termref def=\"dt-link\">link</termref>; that is, of accessing a <termref def=\"dt-resource\">resource</termref>. Traversal may be initiated by a user action (for example, clicking on the displayed content of a <termref def=\"dt-linkel\">linking element</termref>) or occur under program control.</p></def>\n"
    "           </gitem>\n"
    "       </glist>\n"
    "   </p>\n"
    "</div2>\n"
    "\n"
    "<div2>\n"
    "   <head>Notation</head>\n"
    "   <p>The formal grammar for <termref def=\"dt-locator\">locators</termref> is given using a simple Extended Backus-Naur Form (EBNF) location, as described in <xspecref href=\"http://www.w3.org/TR/REC-xml#sec-notation\">the XML specification</xspecref>.</p>\n"
    "   <!-- fixed link to XML spec - bent -->\n"
    "</div2>\n"
    "</div1>\n"
    "\n"
    "<div1 id=\"addressing\"><?Pub Dtl?>\n"
    "   <head>Locator Syntax</head>\n"
    "   <p>The locator for a <termref def=\"dt-resource\">resource</termref> is typically provided by means of a Uniform Resource Identifier, or URI. XPointers can be used in conjunction with the URI structure, as fragment identifiers, to specify a more precise sub-resource. </p>\n"
    "   <!-- Removed the discussion of queries from the previous paragraph, due to contention within the WG. bent -->\n"
    "   <p>A locator generally contains a URI, as described in IETF RFCs <bibref ref=\"rfc1738\"/> and <bibref ref=\"rfc1808\"/>. As these RFCs state, the URI may include a trailing <emph>query</emph> (marked by a leading \"<code>?</code>\"), and be followed by a \"<code>#</code>\" and a <emph>fragment identifier</emph>, with the query interpreted by the host providing the indicated resource, and the interpretation of the fragment identifier dependent on the data type of the indicated resource.</p>\n"
    "   <!--Is there some restriction on URNs having queries and/or fragment identifiers?  Since these RFCs don't mention URIs explicitly, should the wording here lead from URLs to URIs more explicitly? -elm-->\n"
    "   <p>In order to locate XML documents and portions of documents, a locator value may contain either a <xtermref href=\"http://www.w3.org/Addressing/rfc1738.txt\"> URI</xtermref> or a fragment identifier, or both. Any fragment identifier for pointing into XML must be an <xtermref href=\"http://www.w3.org/TR/WD-xptr#dt-xpointer\"> XPointer</xtermref>.</p>\n"
    "   <p>Special syntax may be used to request the use of particular processing models in accessing the locator's resource. This is designed to reflect the realities of network operation, where it may or may not be desirable to exercise fine control over the distribution of work between local and remote processors. \n"
    "       <scrap id=\"locator\" lang=\"ebnf\">\n"
    "           <head>Locator</head>\n"
    "           <prod id=\"nt-locator\">\n"
    "               <lhs>Locator</lhs>\n"
    "               <rhs><nt def=\"nt-uri\">URI</nt></rhs>\n"
    "               <rhs>| <nt def=\"nt-connector\">Connector</nt> (<xnt href=\"http://www.w3.org/TR/WD-xptr\">XPointer</xnt> | <xnt href=\"WD-xml-lang.html#NT-Name\">Name</xnt>)</rhs>\n"
    "               <rhs>| <nt def=\"nt-uri\">URI</nt> <nt def=\"nt-connector\">Connector</nt> (<xnt href=\"http://www.w3.org/TR/WD-xptr\">XPointer</xnt> | <xnt href=\"WD-xml-lang.html#NT-Name\">Name</xnt>)</rhs>\n"
    "           </prod>\n"
    "           <prod id=\"nt-connector\">\n"
    "               <lhs>Connector</lhs><rhs>'#' | '|'</rhs>\n"
    "           </prod>\n"
    "           <prod id=\"nt-uri\">\n"
    "               <lhs>URI</lhs><rhs><xnt href=\"WD-xml-lang.html#NT-URLchar\">URIchar*</xnt></rhs>\n"
    "           </prod>\n"
    "       </scrap>\n"
    "   </p>\n"
    "   <p><termdef id=\"dt-designated\" term=\"Designated Resource\">In this discussion, the term <term>designated resource</term> refers to the resource which an entire locator serves to locate.</termdef> The following rules apply:\n"
    "       <ulist>\n"
    "           <item>\n"
    "               <p><termdef id=\"dt-containing-resource\" term=\"Containing Resource\">       The URI, if provided, locates a resource called the <term>containing resource</term>.</termdef></p>\n"
    "           </item>\n"
    "           <item>\n"
    "               <p>If the URI is not provided, the containing resource is considered to be the document in which the linking element is contained. \n"
    "               </p></item>\n"
    "           <item>\n"
    "               <p><termdef id=\"dt-sub-resource\" term=\"Sub-Resource\">If an XPointer               is provided, the designated resource is a <term>sub-resource</term>\n"
    "               of the containing resource; otherwise the designated resource is the\n"
    "               containing resource.</termdef></p>\n"
    "           </item>\n"
    "           <!--Is this now incorrect, given the nature of the switch from here() to origin()? -elm \n"
    "           Oy, yes, i think so. it will require some fun wording, though, so i haven't fixed it yet here -sjd-->\n"
    "           <item>\n"
    "               <p>If the <nt def=\"nt-connector\">Connector</nt> is followed directly by a <xnt href=\"http://www.w3.org/TR/REC-xml#NT-Name\">Name</xnt>, the <xnt href=\"http://www.w3.org/TR/REC-xml#NT-Name\">Name</xnt> is shorthand for the XPointer\"<code>id(Name)</code>\"; that is, the sub-resource is the element in the containing resource that has an XML <xtermref href=\"http://www.w3.org/TR/REC-xml#sec-attrtypes\">ID attribute</xtermref> whose value <xtermref href=\"http://www.w3.org/TR/REC-xml#dt-match\">matches</xtermref> the                <xnt href=\"http://www.w3.org/TR/REC-xml#NT-Name\">Name</xnt>. This shorthand is to encourage use of the robust <code>id</code> addressing mode.</p>\n"
    "           </item>\n"
    "           <!-- fixed links to the XML recommendation - bent -->\n"
    "           <item>\n"
    "               <p>If the connector is \"<code>#</code>\", this signals an intent that the containing resource is to be fetched as a whole from the host that provides it, and that the XPointer processing to extract the sub-resource\n"
    "               is to be performed on the client, that is to say on the same system where the linking element is recognized and processed.</p>\n"
    "           </item>\n"
    "           <item>\n"
    "               <p>If the connector is \"<code>|</code>\", no intent is signaled as to what processing model is to be used to go about accessing the designated resource.</p>\n"
    "           </item>\n"
    "       </ulist>\n"
    "   </p>\n"
    "   <p>Note that the definition of a URI includes an optional query component. </p>\n"
    "   <p>In the case where the URI contains a query (to be interpreted by the server), information providers and authors of server software are urged to use queries as follows: \n"
    "       <scrap id=\"querysyntax\" lang=\"ebnf\">\n"
    "           <head>Query</head>\n"
    "           <prod id=\"nt-query\">\n"
    "               <lhs>Query</lhs><rhs>'XML-XPTR=' (<xnt href=\"http://www.w3.org/TR/WD-xptr\"> XPointer</xnt> | <xnt href=\"http://www.w3.org/TR/REC-xml#NT-Name\">Name</xnt>)</rhs>\n"
    "           </prod>\n"
    "       </scrap>\n"
    "   </p>\n"
    "   <!-- fixed link to XML recommendation - bent -->\n"
    "</div1>\n"
    "\n"
    "<div1><?Pub Dtl?>\n"
    "   <head>Link Recognition</head>\n"
    "   <p>The existence of a <termref def=\"dt-link\">link</termref> is asserted by a <termref def=\"dt-linkel\">linking element</termref>. Linking elements must be recognized reliably by application software in order to provide appropriate display and behavior. There are several ways link recognition could be accomplished: for example, reserving element type names, reserving attributes names, leaving the matter of recognition entirely up to stylesheets and application software, or using the XLink <xtermref href=\"http://www.w3.org/TR/REC-xml-names/\">namespace</xtermref> to specify element names and attribute names that would be recognized by namespace and XLink-aware processors. Using element and attribute names within the XLink namespace provides a balance between giving users control of their own markup language design and keeping the identification of linking elements simple and unambiguous.</p>\n"
    "   <p>The two approaches to identifying linking elements are relatively simple to implement. For example, here's how the HTML <code>A</code> element would be declared using attributes within the XLink namespace, and then how an element within the XLink namespace might do the same:\n"
    "       <eg>&lt;A xlink:type=\"simple\" xlink:href=\"http://www.w3.org/TR/wd-xlink/\"\n"
    "xlink:title=\"The Xlink Working Draft\"&gt;The XLink Working Draft.&lt;/A&gt;</eg>\n"
    "       <eg>&lt;xlink:simple href=\"http://www.w3.org/TR/wd-xlink/\"\n"
    "title=\"The XLink Working Draft\"&gt;The XLink Working Draft&lt;/xlink:simple&gt;</eg>\n"
    "   Any arbitrary element can be made into an XLink by using the <code>xlink:type</code> attribute. And, of course, the explicit XLink elements may be used, as well. This document will go on to describe the linking attributes that are associated with linking elements. It may be assumed by the reader that these attributes would require the <code>xlink</code> namespace prefix if they existed within an arbitrary element, or that they may be used directly if they exist within an explicit Xlink element.</p>\n"
    "       <!-- heavily modified this section to accomodate namespace-aware link recognition - bent -->\n"
    "</div1>\n"
    "\n"
    "<!-- Rewrote this entire section. - bent -->\n"
    "<div1>\n"
    "   <head>Linking Attributes</head>\n"
    "   <p>XLink has several attributes associated with the variety of links it may represent. These attributes define four main concepts: locators, arcs, behaviors, and semantics. <emph>Locators</emph> define where the actual resource is located. <emph>Arcs</emph> define the traversal of links. Where does the link come from? Where does it go to? All this information can be stored in the arc attributes. <emph>Behaviors</emph> define how the link is activated, and what the application should do with the resource being linked to. <emph>Semantics</emph> define useful information that the application may use, and enables the link for such specalized targets as constricted devices and accessibility software.</p>\n"
    "   \n"
    "   <div2 id=\"link-locators\">\n"
    "       <head>Locator Attributes</head>\n"
    "       <p>The only locator attribute at this time is <code>href</code>. This attribute must contain either a string in the form of a URI that defines the remote resource being linked to, a string containing a fragment identifier that links to a local resource, or a string containing a URI with a fragment identifier concacenated onto it.</p>\n"
    "   </div2>\n"
    "\n"
    "   <div2 id=\"link-arcs\">\n"
    "       <head>Arc Attributes</head>\n"
    "       <p>Arcs contain two attributes, <code>from</code> and <code>to</code>. The <code>from</code> attribute may contain a string containing the content of a <code>role</code> attribute from the resource being linked from. The purpose of the <code>from</code> attribute is to define where this link is being actuated from.</p>\n"
    "       <p>The <code>to</code> attribute may contain a string containing the content of a <code>role</code> attribute from the resource being linked to. The purpose of the <code>to</code> attribute is to define where this link traverses to.</p>\n"
    "       <p>The application may use this information in a number of ways, especially in a complex hypertext system, but it is mainly useful in providing context for application behavior.</p>\n"
    "       <!-- I'm at a loss as to how to describe arcs more clearly than this. I don't want to devolve into discussions of directed graphs and n-ary links. -bent -->\n"
    "   </div2>\n"
    "\n"
    "   <div2 id=\"link-behaviors\">\n"
    "       <head>Behavior Attributes</head>\n"
    "       <p>There are two attributes associated with behavior: <code>show</code> and <code>actuate</code>. The <code>show</code> attribute defines how the remote resource is to be revealed to the user. It has three options: <code>new</code>, <code>parsed</code>, and <code>replace</code>. The <code>new</code> option indicates that the remote resource should be shown in a new window (or other device context) without replacing the previous content. The <code>parsed</code> option, relating directly to the XML concept of a parsed entity, indicates that the content should be integrated into the document from which the link was actuated. The <code>replace</code> option is the one most commonly seen on the World Wide Web, where the document being linked from is entirely replaced by the object being linked to.</p>\n"
    "       <p>The <code>actuate</code> attribute defines how the link is initiated. It has two options: <code>user</code> and <code>auto</code>. The <code>user</code> option indicates that the link must be initiated by some sort of human-initiated selection, such as clicking on an HTML anchor. The <code>auto</code> option indicates that the link is automatically initiated when the application deems that the user has reached the link. It then follows the behavior set out in the <code>show</code> option.</p>\n"
    "       <!-- Something should be put here in terms of an example. Idea: \"A\" link versus automatically updating encyclopedia. -bent -->\n"
    "   </div2>\n"
    "\n"
    "   <div2 id=\"link-semantics\">\n"
    "       <head>Semantic Attributes</head>\n"
    "       <p>There are two attributes associated with semantics, <code>role</code> and <code>title</code>. The <code>role</code> attribute is a generic string used to describe the function of the link's content. For example, a poem might have a link with a <code>role=\"stanza\"</code>. The <code>role</code> is also used as an identifier for the <code>from</code> and <code>to</code> attributes of arcs.</p>\n"
    "       <p>The <code>title</code> attribute is designed to provide human-readable text describing the link. It is very useful for those who have text-based applications, whether that be due to a constricted device that cannot display the link's content, or if it's being read by an application to a visually-impaired user, or if it's being used to create a table of links. The <code>title</code> attribute contains a simple, descriptive string.</p>\n"
    "   </div2>\n"
    "</div1>\n"
    "\n"
    "<div1 id=\"linking-elements\">\n"
    "   <head>Linking Elements</head>\n"
    "   <p>There are several kinds of linking elements in XLink: <code>simple</code> links, <code>locators</code>, <code>arcs</code>, and <code>extended</code> links. These elements may be instantiated via element declarations from the XLink namespace, or they may be instantiated via attribute declarations from the XLink namespace. Both kinds of instantiation are described in the definition of each linking element.</p>\n"
    "   <p>The <code>simple</code> link is used to declare a link that approximates the functionality of the HTML <code>A</code> element. It has, however, a few added features to increase its value, including the potential declaration of semantics and behavior. The <code>locator</code> elements are used to define the resource being linked to. Some links may contain multiple locators, representing a choice of potential links to be traversed. The <code>arcs</code> are used to define the traversal semantics of the link. Finally, an <code>extended</code> linking element differs from a simple link in that it can connect any number of resources, not just one local resource (optionally) and one remote resource, and in that extended links are more often out-of-line than simple links.</p>\n"
    "\n"
    "<div2 id=\"simple-links\">\n"
    "   <head>Simple Links</head>\n"
    "   <p id=\"dt-simplelink\"><termdef id=\"dt-simpleline\" term=\"Simple Link\"><term>Simple links</term> can be used for purposes that approximate the functionality of a basic HTML <code>A</code> link, but they can also support a limited amount of additional functionality. Simple links have only one locator and thus, for convenience, combine the functions of a linking element and a locator into a single element.</termdef> As a result of this combination, the simple linking element offers both a locator attribute and all the behavior and semantic attributes.</p>\n"
    "   <p>The following are two examples of linking elements, each showing all the possible attributes that can be associated with a simple link. Here is the explicit XLink simple linking element.\n"
    "   <eg>&lt;!ELEMENT xlink:simple ANY&gt;\n"
    "&lt;!ATTLIST xlink:slink\n"
    "    href           CDATA                   #REQUIRED\n"
    "    role           CDATA                   #IMPLIED\n"
    "    title          CDATA                   #IMPLIED\n"
    "    show           (new|parsed|replace)    \"replace\"\n"
    "    actuate        (user|auto)                 \"user\"\n"
    "&gt;</eg>\n"
    "   And here is how to make an arbitrary element into a simple link.\n"
    "   <eg>&lt;!ELEMENT xlink:simple ANY&gt;\n"
    "&lt;!ATTLIST foo\n"
    "   xlink:type     (simple|extended|locator|arc) #FIXED \"simple\"      \n"
    "    xlink:href     CDATA                   #REQUIRED\n"
    "    xlink:role     CDATA                   #IMPLIED\n"
    "    xlink:title    CDATA                   #IMPLIED\n"
    "    xlink:show     (new|parsed|replace)    \"replace\"\n"
    "    xlink:actuate  (user|auto)                 \"user\"\n"
    "&gt;</eg>\n"
    "   Here is how the first example might look in a document:\n"
    "<eg>&lt;xlink:simple href=\"http://www.w3.org/TR/wd-xlink\" role=\"working draft\" \n"
    "   title=\"The XLink Working Draft\" show=\"replace\" actuate=\"user\"&gt;\n"
    "The XLink Working Draft.&lt;/xlink:simple&gt;</eg>\n"
    "<eg>&lt;foo xlink:href=\"http://www.w3.org/TR/wd-xlink\" xlink:role=\"working draft\"\n"
    "   xlink:title=\"The XLink Working Draft\" xlink:show=\"new\" xlink:actuate=\"user\"&gt;\n"
    "The XLink Working Draft.&lt;/foo&gt;</eg>\n"
    "   Alternately, a simple link could be as terse as this:\n"
    "<eg>&lt;foo xlink:href=\"#stanza1\"&gt;The First Stanza.&lt;/foo&gt;</eg>\n"
    "   </p>\n"
    "   <p>\n"
    "   There are no constraints on the contents of a simple linking element. In\n"
    "   the sample declaration above, it is given a content model of <code>ANY</code>\n"
    "   to illustrate that any content model or declared content is acceptable. In\n"
    "   a valid document, every element that is significant to XLink must still conform\n"
    "   to the constraints expressed in its governing DTD.</p>\n"
    "   <p>Note that it is meaningful to have an out-of-line simple link, although\n"
    "   such links are uncommon. They are called \"one-ended\" and are typically used\n"
    "   to associate discrete semantic properties with locations. The properties might\n"
    "   be expressed by attributes on the link, the link's element type name, or in\n"
    "   some other way, and are not considered full-fledged resources of the link.\n"
    "   Most out-of-line links are extended links, as these have a far wider range\n"
    "   of uses.</p>\n"
    "</div2>\n"
    "\n"
    "<div2 id=\"extended-link\">\n"
    "<head>Extended Links</head>\n"
    "   <p><termdef id=\"dt-extendedlink\" term=\"Extended Link\">An <term>extended link</term> differs from a simple link in that it can connect any number of resources, not just one local resource (optionally) and one remote resource, and in that extended links are more often out-of-line than simple links.</termdef></p>\n"
    "   <p>These additional capabilities of extended links are required for:  \n"
    "       <ulist>\n"
    "           <item>\n"
    "               <p>Enabling outgoing links in documents that cannot be modified to add an inline link</p>\n"
    "           </item>\n"
    "           <item>\n"
    "               <p>Creating links to and from resources in formats with no native support for embedded links (such as most multimedia formats)</p>\n"
    "           </item>\n"
    "           <item>\n"
    "               <p>Applying and filtering sets of relevant links on demand</p>\n"
    "           </item>\n"
    "           <item><p>Enabling other advanced hypermedia capabilities</p></item>\n"
    "       </ulist>\n"
    "   </p>\n"
    "   <p>Application software might be expected to provide traversal among all of a link's participating resources (subject to semantic constraints outside the scope of this specification) and to signal the fact that a given resource or sub-resource participates in one or more links when it is displayed (even though there is no markup at exactly that point to signal it).</p>\n"
    "   <p>A linking element for an extended link contains a series of <xtermref href=\"http://www.w3.org/TR/REC-xml/#dt-parentchild\">child elements</xtermref> that serve as locators and arcs. Because an extended link can have more than one remote resource, it separates out linking itself from the mechanisms used to locate each resource (whereas a simple link combines the two).</p>\n"
    "   <p>The <code>xlink:type</code> attribute value for an extended link must be <code> extended</code>, if the link is being instantiated on an arbitrary element. Note that extended links introduce variants of the <code>show</code> and <code>actuate</code> behavior attributes. These attributes, the <code>showdefault</code> and <code>actuatedefault</code> define the same behavior as their counterparts. However, in this case, they are considered to define the default behavior for all the linking elements that they contain.</p>\n"
    "   <p>However, when a linking element within an extended link has a <code>show</code> or <code>actuate</code> attribute of its own, that attribute overrides the defaults set on the extended linking element.</p>\n"
    "   <p>The extended linking element itself retains those attributes relevant to the link as a whole, and to its local resource if any. Following are two sample declaration for an extended link. The first is an example of the explicit XLink extended link:\n"
    "   \n"
    "<eg>&lt;!ELEMENT xlink:extended ((xlink:arc | xlink:locator)*)>\n"
    "&lt;!ATTLIST xlink:extended\n"
    "   role           CDATA                    #IMPLIED\n"
    "   title          CDATA                    #IMPLIED\n"
    "   showdefault    (new|parsed|replace)     #IMPLIED \n"
    "    actuatedefault (user|auto)                 #IMPLIED &gt;</eg>\n"
    "\n"
    "   The second is an example of an arbitrary element being used an extended link:\n"
    "\n"
    "<eg>&lt;!ELEMENT foo ((xlink:arc | xlink:locator)*)>\n"
    "&lt;!ATTLIST foo\n"
    "   xlink:type      (simple|extended|locator|arc)   #FIXED \"extended\"\n"
    "   xlink:role           CDATA                      #IMPLIED\n"
    "   xlink:title          CDATA                      #IMPLIED\n"
    "   xlink:showdefault    (new|parsed|replace)       #IMPLIED \n"
    "    xlink:actuatedefault (user|auto)               #IMPLIED &gt;</eg>\n"
    "\n"
    "   The following two examples demonstrate how each of the above might appear within a document instance. Note that the content of these examples would be other elements. For brevity's sake, they've been left blank. The first example shows how the link might appear, using an explicit XLink extended link:\n"
    "\n"
    "<eg>&lt;xlink:extended role=\"address book\" title=\"Ben's Address Book\" showdefault=\"replace\" actuatedefault=\"user\"&gt; ... &lt;/xlink:extended&gt;</eg>\n"
    "\n"
    "   And the second shows how the link might appear, using an arbitrary element:\n"
    "\n"
    "<eg>&lt;foo xlink:type=\"extended\" xlink:role=\"address book\" xlink:title=\"Ben's Address Book\" xlink:showdefault=\"replace\" xlink:actuatedefault=\"user\"&gt; ... &lt;/foo&gt;</eg>\n"
    "   </p>\n"
    "\n"
    "</div2>\n"
    "\n"
    "<div2 id=\"xlink-arcs\">\n"
    "   <head>Arc Elements</head>\n"
    "   <p><termdef id=\"dt-arc\" term=\"Arc\">An <term>arc</term> is contained within an extended link for the purpose of defining traversal behavior.</termdef> More than one arc may be associated with a link. Otherwise, arc elements function exactly as the arc attributes might lead on to expect.</p>\n"
    "   <!-- More here? -bent -->\n"
    "</div2>\n"
    "\n"
    "</div1>\n"
    "<div1>\n"
    "<head>Conformance</head>\n"
    "<p>An element conforms to XLink if:  <olist>\n"
    "<item><p>The element has an <code>xml:link</code> attribute whose value is\n"
    "one of the attribute values prescribed by this specification, and</p></item>\n"
    "<item><p>the element and all of its attributes and content adhere to the\n"
    "syntactic\n"
    "requirements imposed by the chosen <code>xml:link</code> attribute value,\n"
    "as prescribed in this specification.</p></item>\n"
    "</olist></p>\n"
    "<p>Note that conformance is assessed at the level of individual elements,\n"
    "rather than whole XML documents, because XLink and non-XLink linking mechanisms\n"
    "may be used side by side in any one document.</p>\n"
    "<p>An application conforms to XLink if it interprets XLink-conforming elements\n"
    "according to all required semantics prescribed by this specification and,\n"
    "for any optional semantics it chooses to support, supports them in the way\n"
    "prescribed. <!--If/when we split out the XLinkfunctionality\n"
    "(e.g. inline links and out-of-line links), the\n"
    "conformance language will have to address the different\n"
    "levels of support. -elm--> </p>\n"
    "</div1>\n"
    "</body><back>\n"
    "<div1 id=\"unfinished\">\n"
    "<head>Unfinished Work</head>\n"
    "<div2>\n"
    "<head>Structured Titles</head>\n"
    "<p>The simple title mechanism described in this draft is insufficient to cope\n"
    "with internationalization or the use of multimedia in link titles. A future\n"
    "version will provide a mechanism for the use of structured link titles.</p>\n"
    "</div2>\n"
    "</div1>\n"
    "<div1>\n"
    "<head>References</head>\n"
    "<blist>\n"
    "<bibl id=\"xptr\" key=\"XPTR\">Eve Maler and Steve DeRose, editors. <titleref>\n"
    "XML Pointer Language (XPointer) V1.0</titleref>. ArborText, Inso, and Brown\n"
    "University. Burlington, Seekonk, et al.: World Wide Web Consortium, 1998.\n"
    "(See <loc href=\"http://www.w3.org/TR/WD-xptr\">http://www.w3.org/TR/WD-xptr\n"
    " </loc>.)</bibl>\n"
    "<bibl id=\"iso10744\" key=\"ISO/IEC 10744\">ISO (International Organization for\n"
    "Standardization). <titleref>ISO/IEC 10744-1992 (E). Information technology\n"
    "- Hypermedia/Time-based Structuring Language (HyTime).</titleref> [Geneva]:\n"
    "International Organization for Standardization, 1992. <titleref>Extended\n"
    "Facilities\n"
    "Annex.</titleref> [Geneva]: International Organization for Standardization,\n"
    "1996. (See  <loc\n"
    "href=\"http://www.ornl.gov/sgml/wg8/hytime/html/is10744r.html\">http://www.ornl.go\n"
    "v/sgml/wg8/hytime/html/is10744r.html </loc> <!--p m-r says this link is\n"
    "broken. elm --> ).</bibl>\n"
    "<bibl id=\"rfc1738\" key=\"IETF RFC 1738\">IETF (Internet Engineering Task\n"
    "Force). <titleref>\n"
    "RFC 1738: Uniform Resource Locators</titleref>. 1991. (See  <loc\n"
    "href=\"http://www.w3.org/Addressing/rfc1738.txt\">\n"
    "http://www.w3.org/Addressing/rfc1738.txt</loc>).</bibl>\n"
    "<bibl id=\"rfc1808\" key=\"IETF RFC 1808\">IETF (Internet Engineering Task\n"
    "Force). <titleref>\n"
    "RFC 1808: Relative Uniform Resource Locators</titleref>. 1995. (See  <loc\n"
    "href=\"http://www.w3.org/Addressing/rfc1808.txt\">http://www.w3.org/Addressing/rfc\n"
    "1808.txt </loc>).</bibl>\n"
    "<bibl id=\"tei\" key=\"TEI\">C. M. Sperberg-McQueen and Lou Burnard, editors.\n"
    "<titleref>\n"
    "Guidelines for Electronic Text Encoding and Interchange</titleref>. Association\n"
    "for Computers and the Humanities (ACH), Association for Computational\n"
    "Linguistics\n"
    "(ACL), and Association for Literary and Linguistic Computing (ALLC). Chicago,\n"
    "Oxford: Text Encoding Initiative, 1994. <!-- add cite to DOM work --> </bibl>\n"
    "<bibl id=\"chum\" key=\"CHUM\">]Steven J. DeRose and David G. Durand. 1995. \"The\n"
    "TEI Hypertext Guidelines.\" In <titleref>Computing and the Humanities\n"
    "</titleref>29(3).\n"
    "Reprinted in <titleref>Text Encoding Initiative: Background and\n"
    "Context</titleref>,\n"
    "ed. Nancy Ide and Jean ronis <!-- fix this name -->, ISBN 0-7923-3704-2. </bibl>\n"
    "</blist></div1>\n"
    "</back></spec>\n"
    "<?Pub *0000052575?>\n";

// Correct
const char *ok_data_4 =
    "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n"
    "<!DOCTYPE rss [\n"
    "<!--\n"
    "\n"
    "  Rich Site Summary (RSS) 0.91 official DTD, proposed.\n"
    "  \n"
    "  RSS is an XML vocabulary for describing\n"
    "  metadata about websites, and enabling the display of\n"
    "  \"channels\" on the \"My Netscape\" website.\n"
    "  \n"
    "  RSS Info can be found at http://my.netscape.com/publish/\n"
    "  XML Info can be found at http://www.w3.org/XML/ \n"
    "  \n"
    "  copyright Netscape Communications, 1999\n"
    "\n"
    "  Dan Libby - danda@netscape.com\n"
    "  \n"
    "  Based on RSS DTD originally created by\n"
    "  Lars Marius Garshol - larsga@ifi.uio.no.\n"
    "  \n"
    "-->\n"
    "<!ELEMENT rss (channel)>\n"
    "<!ATTLIST rss version CDATA #REQUIRED>\n"
    "<!-- must be \"0.91\"> --><!ELEMENT channel (title | description | link \n"
    "| language | item+ | rating? | image? | textinput? | copyright? | \n"
    "pubDate? | lastBuildDate? | docs? | managingEditor? | webMaster? | \n"
    "skipHours? | skipDays?)*>\n"
    "<!ELEMENT title (#PCDATA)>\n"
    "<!ELEMENT description (#PCDATA)>\n"
    "<!ELEMENT link (#PCDATA)>\n"
    "<!ELEMENT image (title | url | link | width? | height? | description?)*>\n"
    "<!ELEMENT url (#PCDATA)>\n"
    "<!ELEMENT item (title | link | description)*>\n"
    "<!ELEMENT textinput (title | description | name | link)*>\n"
    "<!ELEMENT name (#PCDATA)>\n"
    "<!ELEMENT rating (#PCDATA)>\n"
    "<!ELEMENT language (#PCDATA)>\n"
    "<!ELEMENT width (#PCDATA)>\n"
    "<!ELEMENT height (#PCDATA)>\n"
    "<!ELEMENT copyright (#PCDATA)>\n"
    "<!ELEMENT pubDate (#PCDATA)>\n"
    "<!ELEMENT lastBuildDate (#PCDATA)>\n"
    "<!ELEMENT docs (#PCDATA)>\n"
    "<!ELEMENT managingEditor (#PCDATA)>\n"
    "<!ELEMENT webMaster (#PCDATA)>\n"
    "<!ELEMENT hour (#PCDATA)>\n"
    "<!ELEMENT day (#PCDATA)>\n"
    "<!ELEMENT skipHours (hour)+>\n"
    "<!ELEMENT skipDays (day)+>\n"
    "<!--\n"
    "     Copied from HTML 3.2 DTD, with modifications (removed CDATA)\n"
    "     http://www.w3.org/TR/REC-html32.html#dtd\n"
    "     =============== BEGIN ===================\n"
    "-->\n"
    "<!-- \n"
    "     Character Entities for ISO Latin-1\n"
    "     \n"
    "     (C) International Organization for Standardization 1986\n"
    "     Permission to copy in any form is granted for use with\n"
    "     conforming SGML systems and applications as defined in\n"
    "     ISO 8879, provided this notice is included in all copies.\n"
    "     This has been extended for use with HTML to cover the full\n"
    "     set of codes in the range 160-255 decimal.\n"
    "-->\n"
    "<!-- Character entity set. Typical invocation:\n"
    "     <!ENTITY % ISOlat1 PUBLIC\n"
    "       \"ISO 8879-1986//ENTITIES Added Latin 1//EN//HTML\">\n"
    "     %ISOlat1;\n"
    "-->\n"
    "<!ENTITY nbsp \"&#160;\"> <!-- no-break space -->\n"
    "<!ENTITY iexcl \"&#161;\">\n"
    "<!-- inverted exclamation mark --><!ENTITY cent \"&#162;\">\n"
    "<!-- cent sign --><!ENTITY pound \"&#163;\">\n"
    "<!-- pound sterling sign --><!ENTITY curren \"&#164;\">\n"
    "<!-- general currency sign --><!ENTITY yen \"&#165;\">\n"
    "<!-- yen sign --><!ENTITY brvbar \"&#166;\">\n"
    "<!-- broken (vertical) bar --><!ENTITY sect \"&#167;\">\n"
    "<!-- section sign --><!ENTITY uml \"&#168;\">\n"
    "<!-- umlaut (dieresis) --><!ENTITY copy \"&#169;\">\n"
    "<!-- copyright sign --><!ENTITY ordf \"&#170;\">\n"
    "<!-- ordinal indicator, feminine --><!ENTITY laquo \"&#171;\">\n"
    "<!-- angle quotation mark, left --><!ENTITY not \"&#172;\">\n"
    "<!-- not sign --><!ENTITY shy \"&#173;\">\n"
    "<!-- soft hyphen --><!ENTITY reg \"&#174;\">\n"
    "<!-- registered sign --><!ENTITY macr \"&#175;\">\n"
    "<!-- macron --><!ENTITY deg \"&#176;\">\n"
    "<!-- degree sign --><!ENTITY plusmn \"&#177;\">\n"
    "<!-- plus-or-minus sign --><!ENTITY sup2 \"&#178;\">\n"
    "<!-- superscript two --><!ENTITY sup3 \"&#179;\">\n"
    "<!-- superscript three --><!ENTITY acute \"&#180;\">\n"
    "<!-- acute accent --><!ENTITY micro \"&#181;\">\n"
    "<!-- micro sign --><!ENTITY para \"&#182;\">\n"
    "<!-- pilcrow (paragraph sign) --><!ENTITY middot \"&#183;\">\n"
    "<!-- middle dot --><!ENTITY cedil \"&#184;\">\n"
    "<!-- cedilla --><!ENTITY sup1 \"&#185;\">\n"
    "<!-- superscript one --><!ENTITY ordm \"&#186;\">\n"
    "<!-- ordinal indicator, masculine --><!ENTITY raquo \"&#187;\">\n"
    "<!-- angle quotation mark, right --><!ENTITY frac14 \"&#188;\">\n"
    "<!-- fraction one-quarter --><!ENTITY frac12 \"&#189;\">\n"
    "<!-- fraction one-half --><!ENTITY frac34 \"&#190;\">\n"
    "<!-- fraction three-quarters --><!ENTITY iquest \"&#191;\">\n"
    "<!-- inverted question mark --><!ENTITY Agrave \"&#192;\">\n"
    "<!-- capital A, grave accent --><!ENTITY Aacute \"&#193;\">\n"
    "<!-- capital A, acute accent --><!ENTITY Acirc \"&#194;\">\n"
    "<!-- capital A, circumflex accent --><!ENTITY Atilde \"&#195;\">\n"
    "<!-- capital A, tilde --><!ENTITY Auml \"&#196;\">\n"
    "<!-- capital A, dieresis or umlaut mark --><!ENTITY Aring \"&#197;\">\n"
    "<!-- capital A, ring --><!ENTITY AElig \"&#198;\">\n"
    "<!-- capital AE diphthong (ligature) --><!ENTITY Ccedil \"&#199;\">\n"
    "<!-- capital C, cedilla --><!ENTITY Egrave \"&#200;\">\n"
    "<!-- capital E, grave accent --><!ENTITY Eacute \"&#201;\">\n"
    "<!-- capital E, acute accent --><!ENTITY Ecirc \"&#202;\">\n"
    "<!-- capital E, circumflex accent --><!ENTITY Euml \"&#203;\">\n"
    "<!-- capital E, dieresis or umlaut mark --><!ENTITY Igrave \"&#204;\">\n"
    "<!-- capital I, grave accent --><!ENTITY Iacute \"&#205;\">\n"
    "<!-- capital I, acute accent --><!ENTITY Icirc \"&#206;\">\n"
    "<!-- capital I, circumflex accent --><!ENTITY Iuml \"&#207;\">\n"
    "<!-- capital I, dieresis or umlaut mark --><!ENTITY ETH \"&#208;\">\n"
    "<!-- capital Eth, Icelandic --><!ENTITY Ntilde \"&#209;\">\n"
    "<!-- capital N, tilde --><!ENTITY Ograve \"&#210;\">\n"
    "<!-- capital O, grave accent --><!ENTITY Oacute \"&#211;\">\n"
    "<!-- capital O, acute accent --><!ENTITY Ocirc \"&#212;\">\n"
    "<!-- capital O, circumflex accent --><!ENTITY Otilde \"&#213;\">\n"
    "<!-- capital O, tilde --><!ENTITY Ouml \"&#214;\">\n"
    "<!-- capital O, dieresis or umlaut mark --><!ENTITY times \"&#215;\">\n"
    "<!-- multiply sign --><!ENTITY Oslash \"&#216;\">\n"
    "<!-- capital O, slash --><!ENTITY Ugrave \"&#217;\">\n"
    "<!-- capital U, grave accent --><!ENTITY Uacute \"&#218;\">\n"
    "<!-- capital U, acute accent --><!ENTITY Ucirc \"&#219;\">\n"
    "<!-- capital U, circumflex accent --><!ENTITY Uuml \"&#220;\">\n"
    "<!-- capital U, dieresis or umlaut mark --><!ENTITY Yacute \"&#221;\">\n"
    "<!-- capital Y, acute accent --><!ENTITY THORN \"&#222;\">\n"
    "<!-- capital THORN, Icelandic --><!ENTITY szlig \"&#223;\">\n"
    "<!-- small sharp s, German (sz ligature) --><!ENTITY agrave \"&#224;\">\n"
    "<!-- small a, grave accent --><!ENTITY aacute \"&#225;\">\n"
    "<!-- small a, acute accent --><!ENTITY acirc \"&#226;\">\n"
    "<!-- small a, circumflex accent --><!ENTITY atilde \"&#227;\">\n"
    "<!-- small a, tilde --><!ENTITY auml \"&#228;\">\n"
    "<!-- small a, dieresis or umlaut mark --><!ENTITY aring \"&#229;\">\n"
    "<!-- small a, ring --><!ENTITY aelig \"&#230;\">\n"
    "<!-- small ae diphthong (ligature) --><!ENTITY ccedil \"&#231;\">\n"
    "<!-- small c, cedilla --><!ENTITY egrave \"&#232;\">\n"
    "<!-- small e, grave accent --><!ENTITY eacute \"&#233;\">\n"
    "<!-- small e, acute accent --><!ENTITY ecirc \"&#234;\">\n"
    "<!-- small e, circumflex accent --><!ENTITY euml \"&#235;\">\n"
    "<!-- small e, dieresis or umlaut mark --><!ENTITY igrave \"&#236;\">\n"
    "<!-- small i, grave accent --><!ENTITY iacute \"&#237;\">\n"
    "<!-- small i, acute accent --><!ENTITY icirc \"&#238;\">\n"
    "<!-- small i, circumflex accent --><!ENTITY iuml \"&#239;\">\n"
    "<!-- small i, dieresis or umlaut mark --><!ENTITY eth \"&#240;\">\n"
    "<!-- small eth, Icelandic --><!ENTITY ntilde \"&#241;\">\n"
    "<!-- small n, tilde --><!ENTITY ograve \"&#242;\">\n"
    "<!-- small o, grave accent --><!ENTITY oacute \"&#243;\">\n"
    "<!-- small o, acute accent --><!ENTITY ocirc \"&#244;\">\n"
    "<!-- small o, circumflex accent --><!ENTITY otilde \"&#245;\">\n"
    "<!-- small o, tilde --><!ENTITY ouml \"&#246;\">\n"
    "<!-- small o, dieresis or umlaut mark --><!ENTITY divide \"&#247;\">\n"
    "<!-- divide sign --><!ENTITY oslash \"&#248;\">\n"
    "<!-- small o, slash --><!ENTITY ugrave \"&#249;\">\n"
    "<!-- small u, grave accent --><!ENTITY uacute \"&#250;\">\n"
    "<!-- small u, acute accent --><!ENTITY ucirc \"&#251;\">\n"
    "<!-- small u, circumflex accent --><!ENTITY uuml \"&#252;\">\n"
    "<!-- small u, dieresis or umlaut mark --><!ENTITY yacute \"&#253;\">\n"
    "<!-- small y, acute accent --><!ENTITY thorn \"&#254;\">\n"
    "<!-- small thorn, Icelandic --><!ENTITY yuml \"&#255;\">\n"
    "<!-- small y, dieresis or umlaut mark --><!--\n"
    "     Copied from HTML 3.2 DTD, with modifications (removed CDATA)\n"
    "     http://www.w3.org/TR/REC-html32.html#dtd\n"
    "     ================= END ===================\n"
    "-->\n"
    "]>\n"
    "<rss>\n"
    "<channel>\n"
    "<image/>\n"
    "<title>PP</title>\n"
    "</channel>\n"
    "</rss>\n";

// Correct, with UTF-8 data
const char ok_data_5[] =
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" /*39 chars*/
    "<doc>\xC3\xA4</doc>";

// Erroneous
const char *error_data_1 = 
    "a";      // bogus character

// Erroneous
const char *error_data_2 = 
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"    
    "<start>";      // XML tag not closed

const char *bug_data_pr2855 =
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<start> notrim</start>";

// byte order mark
const char *bug_data_pr1678 =
    "\xEF\xBB\xBF<?xml version=\"1.0\" encoding=\"utf-8\"?><root/>";

// russian
const char *bug_data_pr5203 =
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<name>\xD0\xAE\xD0\xBD\xD0\xB8\xD1\x82</name>";

// Quoting attributes
const char *bug_data_pr4840 =
    "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
    "<start a=\"hello &quot;world&quot;\"/>";

#endif
