// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABAL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SABAL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sabal2_4S[] = {
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00008001, 0x00000021,
  0x00000002, 0x00007fff, 0x00008000, 0x00000022,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00000030,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x0000009d,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x0000009e,
  0x00007fed, 0x00007f82, 0x00007f83, 0x0000009f,
  0x00007f80, 0x00007f81, 0x00007f82, 0x00003353,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x00005575,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x0000801d,
  0x00004cca, 0x00002aaa, 0x00000004, 0x0000801e,
  0x00002aa8, 0x00000002, 0x00000003, 0x0000801f,
  0x00000000, 0x00000001, 0x00000002, 0x00008020,
  0x00000001, 0x00000002, 0x00010001, 0x0000801f,
  0x00000002, 0x0000ffff, 0x00010000, 0x00005576,
  0x0000fffd, 0x0000fffe, 0x0000d557, 0x00003354,
  0x0000fffc, 0x0000d555, 0x0000b335, 0x000000a0,
  0x0000d553, 0x0000b333, 0x00008081, 0x0000009f,
  0x0000b331, 0x0000807f, 0x00008080, 0x0000009e,
  0x0000807d, 0x0000807e, 0x0000807f, 0x0000009d,
  0x0000807c, 0x0000807d, 0x0000807e, 0x00000030,
  0x0000807b, 0x0000807c, 0x00008011, 0x00000023,
  0x0000807a, 0x0000800f, 0x00008004, 0x00000022,
  0x0000800d, 0x00008002, 0x00008003, 0x00000021,
  0x00008001, 0x00008002, 0x00000003, 0x00000021,
  0x00008000, 0x00008001, 0x00000002, 0x00000020,
  0x00007fff, 0x00008000, 0x00000003, 0x00000021,
  0x00007ffe, 0x00007fff, 0x00000004, 0x0000002f,
  0x00007ffd, 0x00007ffe, 0x00000012, 0x0000009c,
  0x00007ffc, 0x00007ff0, 0x0000007f, 0x0000009d,
  0x00007fee, 0x00007f83, 0x00000080, 0x0000009e,
  0x00007f81, 0x00007f82, 0x00000081, 0x00003352,
  0x00007f80, 0x00007f81, 0x00003335, 0x00005574,
  0x00007f7f, 0x00004ccd, 0x00005557, 0x0000801c,
  0x00004ccb, 0x00002aab, 0x00007fff, 0x0000801d,
  0x00002aa9, 0x00000003, 0x00008000, 0x0000801e,
  0x00000001, 0x00000002, 0x00008001, 0x00008021,
  0x00000000, 0x00000001, 0x00008002, 0x00008020,
  0x00000001, 0x00010000, 0x00008001, 0x00005577,
  0x0000fffe, 0x0000ffff, 0x00005558, 0x00003355,
  0x0000fffd, 0x0000d556, 0x00003336, 0x000000a1,
  0x0000d554, 0x0000b334, 0x00000082, 0x000000a0,
  0x0000b332, 0x00008080, 0x00000081, 0x0000009f,
  0x0000807e, 0x0000807f, 0x00000080, 0x0000009e,
  0x0000807d, 0x0000807e, 0x0000007f, 0x00000031,
  0x0000807c, 0x0000807d, 0x00000012, 0x00000024,
  0x0000807b, 0x00008010, 0x00000005, 0x00000023,
  0x0000800e, 0x00008003, 0x00000004, 0x00000022,
  0x00008002, 0x00000003, 0x00000004, 0x00000022,
  0x00008001, 0x00000002, 0x00000003, 0x00000021,
  0x00008000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0x00000002, 0x00000003, 0x0000002e,
  0x00007ffe, 0x00000003, 0x00000011, 0x0000009b,
  0x00007ffd, 0x00000011, 0x0000007e, 0x0000009c,
  0x00007fef, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00007f82, 0x0000007f, 0x00000080, 0x00003351,
  0x00007f81, 0x00000080, 0x00003334, 0x00005573,
  0x00007f80, 0x00003334, 0x00005556, 0x0000801b,
  0x00004ccc, 0x00005556, 0x00007ffe, 0x0000801c,
  0x00002aaa, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00000002, 0x00007fff, 0x00008000, 0x00008022,
  0x00000001, 0x00008000, 0x00008003, 0x00008021,
  0x00000000, 0x00008001, 0x00008002, 0x00005578,
  0x0000ffff, 0x00008000, 0x00005559, 0x00003356,
  0x0000fffe, 0x00005557, 0x00003337, 0x000000a2,
  0x0000d555, 0x00003335, 0x00000083, 0x000000a1,
  0x0000b333, 0x00000081, 0x00000082, 0x000000a0,
  0x0000807f, 0x00000080, 0x00000081, 0x0000009f,
  0x0000807e, 0x0000007f, 0x00000080, 0x00000032,
  0x0000807d, 0x0000007e, 0x00000013, 0x00000025,
  0x0000807c, 0x00000011, 0x00000006, 0x00000024,
  0x0000800f, 0x00000004, 0x00000005, 0x00000023,
  0x00000003, 0x00000004, 0x00000005, 0x00000030,
  0x00000002, 0x00000003, 0x00000004, 0x0000002f,
  0x00000001, 0x00000002, 0x00000003, 0x0000002e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000010, 0x0000008d,
  0x00000002, 0x00000010, 0x0000007d, 0x0000008e,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000008f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003343,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005565,
  0x0000007f, 0x00003333, 0x00005555, 0x0000800d,
  0x00003333, 0x00005555, 0x00007ffd, 0x0000800e,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x0000800f,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00008030,
  0x00007ffe, 0x00007fff, 0x00008004, 0x0000802f,
  0x00007fff, 0x00008002, 0x00008003, 0x00005586,
  0x00008000, 0x00008001, 0x0000555a, 0x00003364,
  0x00007fff, 0x00005558, 0x00003338, 0x000000b0,
  0x00005556, 0x00003336, 0x00000084, 0x000000af,
  0x00003334, 0x00000082, 0x00000083, 0x000000ae,
  0x00000080, 0x00000081, 0x00000082, 0x000000ad,
  0x0000007f, 0x00000080, 0x00000081, 0x00000040,
  0x0000007e, 0x0000007f, 0x00000014, 0x00000033,
  0x0000007d, 0x00000012, 0x00000007, 0x00000032,
  0x00000010, 0x00000005, 0x00000006, 0x00000031,
  0x00000004, 0x00000005, 0x00000013, 0x0000009d,
  0x00000003, 0x00000004, 0x00000012, 0x0000009c,
  0x00000002, 0x00000003, 0x00000011, 0x0000009b,
  0x00000001, 0x00000002, 0x00000010, 0x0000008d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x0000000f, 0x0000006f, 0x00000021,
  0x0000000f, 0x0000007c, 0x00000070, 0x00000022,
  0x0000007c, 0x0000007d, 0x00000071, 0x000032d6,
  0x0000007d, 0x0000007e, 0x00003325, 0x000054f8,
  0x0000007e, 0x00003332, 0x00005547, 0x00007fa0,
  0x00003332, 0x00005554, 0x00007fef, 0x00007fa1,
  0x00005554, 0x00007ffc, 0x00007ff0, 0x00007fa2,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x0000809d,
  0x00007ffd, 0x00007ffe, 0x00008012, 0x0000809c,
  0x00007ffe, 0x00008003, 0x00008011, 0x000055f3,
  0x00008001, 0x00008002, 0x00005568, 0x000033d1,
  0x00008000, 0x00005559, 0x00003346, 0x0000011d,
  0x00005557, 0x00003337, 0x00000092, 0x0000011c,
  0x00003335, 0x00000083, 0x00000091, 0x0000011b,
  0x00000081, 0x00000082, 0x00000090, 0x0000011a,
  0x00000080, 0x00000081, 0x0000008f, 0x000000ad,
  0x0000007f, 0x00000080, 0x00000022, 0x000000a0,
  0x0000007e, 0x00000013, 0x00000015, 0x0000009f,
  0x00000011, 0x00000006, 0x00000014, 0x0000009e,
  0x00000005, 0x00000013, 0x00000080, 0x0000009e,
  0x00000004, 0x00000012, 0x0000007f, 0x0000009d,
  0x00000003, 0x00000011, 0x0000007e, 0x0000009c,
  0x00000002, 0x00000010, 0x0000007d, 0x0000008e,
  0x00000001, 0x0000000f, 0x0000006f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000000e, 0x0000006e, 0x00000003, 0x00000021,
  0x0000007b, 0x0000006f, 0x00000004, 0x000032d5,
  0x0000007c, 0x00000070, 0x000032b8, 0x000054f7,
  0x0000007d, 0x00003324, 0x000054da, 0x00007f9f,
  0x00003331, 0x00005546, 0x00007f82, 0x00007fa0,
  0x00005553, 0x00007fee, 0x00007f83, 0x00007fa1,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x0000809e,
  0x00007ffc, 0x00007ff0, 0x0000807f, 0x0000809d,
  0x00007ffd, 0x00008011, 0x0000807e, 0x000055f4,
  0x00008002, 0x00008010, 0x000055d5, 0x000033d2,
  0x00008001, 0x00005567, 0x000033b3, 0x0000011e,
  0x00005558, 0x00003345, 0x000000ff, 0x0000011d,
  0x00003336, 0x00000091, 0x000000fe, 0x0000011c,
  0x00000082, 0x00000090, 0x000000fd, 0x0000011b,
  0x00000081, 0x0000008f, 0x000000fc, 0x000000ae,
  0x00000080, 0x0000008e, 0x0000008f, 0x000000a1,
  0x0000007f, 0x00000021, 0x00000082, 0x000000a0,
  0x00000012, 0x00000014, 0x00000081, 0x0000009f,
  0x00000013, 0x00000080, 0x00000081, 0x0000009f,
  0x00000012, 0x0000007f, 0x00000080, 0x0000009e,
  0x00000011, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00000010, 0x0000007d, 0x0000007e, 0x0000008f,
  0x0000000f, 0x0000007c, 0x00000070, 0x00000022,
  0x0000000e, 0x0000006e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000006d, 0x00000002, 0x00000003, 0x000032d4,
  0x0000006e, 0x00000003, 0x000032b7, 0x000054f6,
  0x0000006f, 0x000032b7, 0x000054d9, 0x00007f9e,
  0x00003323, 0x000054d9, 0x00007f81, 0x00007f9f,
  0x00005545, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x00007fed, 0x00007f82, 0x00007f83, 0x0000809f,
  0x00007fee, 0x00007f83, 0x00008080, 0x0000809e,
  0x00007fef, 0x0000807e, 0x0000807f, 0x000055f5,
  0x00008010, 0x0000807d, 0x000055d6, 0x000033d3,
  0x0000800f, 0x000055d4, 0x000033b4, 0x0000011f,
  0x00005566, 0x000033b2, 0x00000100, 0x0000011e,
  0x00003344, 0x000000fe, 0x000000ff, 0x0000011d,
  0x00000090, 0x000000fd, 0x000000fe, 0x0000011c,
  0x0000008f, 0x000000fc, 0x000000fd, 0x000000af,
  0x0000008e, 0x000000fb, 0x00000090, 0x000000a2,
  0x0000008d, 0x0000008e, 0x00000083, 0x000000a1,
  0x00000020, 0x00000081, 0x00000082, 0x000000a0,
  0x00000080, 0x00000081, 0x00000082, 0x00003353,
  0x0000007f, 0x00000080, 0x00000081, 0x00003352,
  0x0000007e, 0x0000007f, 0x00000080, 0x00003351,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00003343,
  0x0000007c, 0x0000007d, 0x00000071, 0x000032d6,
  0x0000007b, 0x0000006f, 0x00000004, 0x000032d5,
  0x0000006d, 0x00000002, 0x00000003, 0x000032d4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x000032b6, 0x00002242,
  0x00000002, 0x000032b6, 0x000054d8, 0x00004cea,
  0x000032b6, 0x000054d8, 0x00007f80, 0x00004ceb,
  0x000054d8, 0x00007f80, 0x00007f81, 0x00004cec,
  0x00007f80, 0x00007f81, 0x00007f82, 0x0000b353,
  0x00007f81, 0x00007f82, 0x00008081, 0x0000b352,
  0x00007f82, 0x0000807f, 0x00008080, 0x000088a9,
  0x0000807d, 0x0000807e, 0x000055d7, 0x00006687,
  0x0000807c, 0x000055d5, 0x000033b5, 0x000033d3,
  0x000055d3, 0x000033b3, 0x00000101, 0x000033d2,
  0x000033b1, 0x000000ff, 0x00000100, 0x000033d1,
  0x000000fd, 0x000000fe, 0x000000ff, 0x000033d0,
  0x000000fc, 0x000000fd, 0x000000fe, 0x00003363,
  0x000000fb, 0x000000fc, 0x00000091, 0x00003356,
  0x000000fa, 0x0000008f, 0x00000084, 0x00003355,
  0x0000008d, 0x00000082, 0x00000083, 0x00003354,
  0x00000081, 0x00000082, 0x00003336, 0x00005575,
  0x00000080, 0x00000081, 0x00003335, 0x00005574,
  0x0000007f, 0x00000080, 0x00003334, 0x00005573,
  0x0000007e, 0x0000007f, 0x00003333, 0x00005565,
  0x0000007d, 0x0000007e, 0x00003325, 0x000054f8,
  0x0000007c, 0x00000070, 0x000032b8, 0x000054f7,
  0x0000006e, 0x00000003, 0x000032b7, 0x000054f6,
  0x00000001, 0x00000002, 0x000032b6, 0x00002242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x0000d575,
  0x00007f80, 0x00007f81, 0x0000b335, 0x0000d574,
  0x00007f81, 0x00008080, 0x0000b334, 0x0000aacb,
  0x0000807e, 0x0000807f, 0x0000888b, 0x000088a9,
  0x0000807d, 0x000055d6, 0x00006669, 0x000055f5,
  0x000055d4, 0x000033b4, 0x000033b5, 0x000055f4,
  0x000033b2, 0x00000100, 0x000033b4, 0x000055f3,
  0x000000fe, 0x000000ff, 0x000033b3, 0x000055f2,
  0x000000fd, 0x000000fe, 0x000033b2, 0x00005585,
  0x000000fc, 0x000000fd, 0x00003345, 0x00005578,
  0x000000fb, 0x00000090, 0x00003338, 0x00005577,
  0x0000008e, 0x00000083, 0x00003337, 0x00005576,
  0x00000082, 0x00003336, 0x00005558, 0x0000801d,
  0x00000081, 0x00003335, 0x00005557, 0x0000801c,
  0x00000080, 0x00003334, 0x00005556, 0x0000801b,
  0x0000007f, 0x00003333, 0x00005555, 0x0000800d,
  0x0000007e, 0x00003332, 0x00005547, 0x00007fa0,
  0x0000007d, 0x00003324, 0x000054da, 0x00007f9f,
  0x0000006f, 0x000032b7, 0x000054d9, 0x00007f9e,
  0x00000002, 0x000032b6, 0x000054d8, 0x00004cea,
  0x00000001, 0x000032b5, 0x00002224, 0x00002ac8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x0001001d,
  0x00007f7f, 0x00004ccd, 0x0000d557, 0x0001001c,
  0x00007f80, 0x0000b334, 0x0000d556, 0x0000d573,
  0x0000807f, 0x0000b333, 0x0000aaad, 0x0000b351,
  0x0000807e, 0x0000888a, 0x0000888b, 0x0000809d,
  0x000055d5, 0x00006668, 0x000055d7, 0x0000809c,
  0x000033b3, 0x000033b4, 0x000055d6, 0x0000809b,
  0x000000ff, 0x000033b3, 0x000055d5, 0x0000809a,
  0x000000fe, 0x000033b2, 0x000055d4, 0x0000802d,
  0x000000fd, 0x000033b1, 0x00005567, 0x00008020,
  0x000000fc, 0x00003344, 0x0000555a, 0x0000801f,
  0x0000008f, 0x00003337, 0x00005559, 0x0000801e,
  0x00003336, 0x00005558, 0x00008000, 0x0000801e,
  0x00003335, 0x00005557, 0x00007fff, 0x0000801d,
  0x00003334, 0x00005556, 0x00007ffe, 0x0000801c,
  0x00003333, 0x00005555, 0x00007ffd, 0x0000800e,
  0x00003332, 0x00005554, 0x00007fef, 0x00007fa1,
  0x00003331, 0x00005546, 0x00007f82, 0x00007fa0,
  0x00003323, 0x000054d9, 0x00007f81, 0x00007f9f,
  0x000032b6, 0x000054d8, 0x00007f80, 0x00004ceb,
  0x000032b5, 0x000054d7, 0x00004ccc, 0x00002ac9,
  0x000032b4, 0x00002223, 0x00002aaa, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00004cca, 0x00002aaa, 0x00000004, 0x0001001e,
  0x00004ccb, 0x00002aab, 0x0000ffff, 0x0001001d,
  0x00004ccc, 0x0000d556, 0x0000fffe, 0x0000d574,
  0x0000b333, 0x0000d555, 0x0000d555, 0x0000b352,
  0x0000b332, 0x0000aaac, 0x0000b333, 0x0000809e,
  0x00008889, 0x0000888a, 0x0000807f, 0x0000809d,
  0x00006667, 0x000055d6, 0x0000807e, 0x0000809c,
  0x000033b3, 0x000055d5, 0x0000807d, 0x0000809b,
  0x000033b2, 0x000055d4, 0x0000807c, 0x0000802e,
  0x000033b1, 0x000055d3, 0x0000800f, 0x00008021,
  0x000033b0, 0x00005566, 0x00008002, 0x00008020,
  0x00003343, 0x00005559, 0x00008001, 0x0000801f,
  0x00005558, 0x00008000, 0x00008001, 0x0000801f,
  0x00005557, 0x00007fff, 0x00008000, 0x0000801e,
  0x00005556, 0x00007ffe, 0x00007fff, 0x0000801d,
  0x00005555, 0x00007ffd, 0x00007ffe, 0x0000800f,
  0x00005554, 0x00007ffc, 0x00007ff0, 0x00007fa2,
  0x00005553, 0x00007fee, 0x00007f83, 0x00007fa1,
  0x00005545, 0x00007f81, 0x00007f82, 0x00007fa0,
  0x000054d8, 0x00007f80, 0x00007f81, 0x00004cec,
  0x000054d7, 0x00007f7f, 0x00004ccd, 0x00002aca,
  0x000054d6, 0x00004ccb, 0x00002aab, 0x00000022,
  0x00002222, 0x00002aa9, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002aa8, 0x00000002, 0x00000003, 0x0001001f,
  0x00002aa9, 0x00000003, 0x00010000, 0x0001001e,
  0x00002aaa, 0x0000fffe, 0x0000ffff, 0x0000d575,
  0x0000d555, 0x0000fffd, 0x0000d556, 0x0000b353,
  0x0000d554, 0x0000d554, 0x0000b334, 0x0000809f,
  0x0000aaab, 0x0000b332, 0x00008080, 0x0000809e,
  0x00008889, 0x0000807e, 0x0000807f, 0x0000809d,
  0x000055d5, 0x0000807d, 0x0000807e, 0x0000809c,
  0x000055d4, 0x0000807c, 0x0000807d, 0x0000802f,
  0x000055d3, 0x0000807b, 0x00008010, 0x00008022,
  0x000055d2, 0x0000800e, 0x00008003, 0x00008021,
  0x00005565, 0x00008001, 0x00008002, 0x00008020,
  0x00008000, 0x00008001, 0x00008002, 0x00008020,
  0x00007fff, 0x00008000, 0x00008001, 0x00008021,
  0x00007ffe, 0x00007fff, 0x00008000, 0x00008022,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x00008030,
  0x00007ffc, 0x00007ffd, 0x00007ff1, 0x0000809d,
  0x00007ffb, 0x00007fef, 0x00007f84, 0x0000809e,
  0x00007fed, 0x00007f82, 0x00007f83, 0x0000809f,
  0x00007f80, 0x00007f81, 0x00007f82, 0x0000b353,
  0x00007f7f, 0x00007f80, 0x00004cce, 0x0000d575,
  0x00007f7e, 0x00004ccc, 0x00002aac, 0x0001001d,
  0x00004cca, 0x00002aaa, 0x00000004, 0x0001001e,
  0x00002aa8, 0x00000002, 0x00000003, 0x0001001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00010001, 0x00000021,
  0x00000002, 0x0000ffff, 0x00010000, 0x00002aca,
  0x0000fffd, 0x0000fffe, 0x0000d557, 0x00004cec,
  0x0000fffc, 0x0000d555, 0x0000b335, 0x00007fa0,
  0x0000d553, 0x0000b333, 0x00008081, 0x00007fa1,
  0x0000b331, 0x0000807f, 0x00008080, 0x00007fa2,
  0x0000807d, 0x0000807e, 0x0000807f, 0x00007fa3,
  0x0000807c, 0x0000807d, 0x0000807e, 0x00008010,
  0x0000807b, 0x0000807c, 0x00008011, 0x0000801d,
  0x0000807a, 0x0000800f, 0x00008004, 0x0000801e,
  0x0000800d, 0x00008002, 0x00008003, 0x0000801f,
  0x00008001, 0x00008002, 0x00008001, 0x0000801f,
  0x00008000, 0x00008001, 0x00008002, 0x00008020,
  0x00007fff, 0x00008000, 0x00008003, 0x00008021,
  0x00007ffe, 0x00007fff, 0x00008004, 0x0000802f,
  0x00007ffd, 0x00007ffe, 0x00008012, 0x0000809c,
  0x00007ffc, 0x00007ff0, 0x0000807f, 0x0000809d,
  0x00007fee, 0x00007f83, 0x00008080, 0x0000809e,
  0x00007f81, 0x00007f82, 0x00008081, 0x0000b352,
  0x00007f80, 0x00007f81, 0x0000b335, 0x0000d574,
  0x00007f7f, 0x00004ccd, 0x0000d557, 0x0001001c,
  0x00004ccb, 0x00002aab, 0x0000ffff, 0x0001001d,
  0x00002aa9, 0x00000003, 0x00010000, 0x0001001e,
  0x00000001, 0x00000002, 0x00010001, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00010000, 0x00000003, 0x00002ac9,
  0x0000fffe, 0x0000ffff, 0x00002aac, 0x00004ceb,
  0x0000fffd, 0x0000d556, 0x00004cce, 0x00007f9f,
  0x0000d554, 0x0000b334, 0x00007f82, 0x00007fa0,
  0x0000b332, 0x00008080, 0x00007f83, 0x00007fa1,
  0x0000807e, 0x0000807f, 0x00007f84, 0x00007fa2,
  0x0000807d, 0x0000807e, 0x00007f85, 0x0000800f,
  0x0000807c, 0x0000807d, 0x00007ff2, 0x0000801c,
  0x0000807b, 0x00008010, 0x00007fff, 0x0000801d,
  0x0000800e, 0x00008003, 0x00008000, 0x0000801e,
  0x00008002, 0x00007fff, 0x00008000, 0x00005576,
  0x00008001, 0x00008000, 0x00008001, 0x00005577,
  0x00008000, 0x00008001, 0x00008002, 0x00005578,
  0x00007fff, 0x00008002, 0x00008003, 0x00005586,
  0x00007ffe, 0x00008003, 0x00008011, 0x000055f3,
  0x00007ffd, 0x00008011, 0x0000807e, 0x000055f4,
  0x00007fef, 0x0000807e, 0x0000807f, 0x000055f5,
  0x00007f82, 0x0000807f, 0x00008080, 0x000088a9,
  0x00007f81, 0x00008080, 0x0000b334, 0x0000aacb,
  0x00007f80, 0x0000b334, 0x0000d556, 0x0000d573,
  0x00004ccc, 0x0000d556, 0x0000fffe, 0x0000d574,
  0x00002aaa, 0x0000fffe, 0x0000ffff, 0x0000d575,
  0x00000002, 0x0000ffff, 0x00010000, 0x00002aca,
  0x00000001, 0x00010000, 0x00000003, 0x00002ac9,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000ffff, 0x00000002, 0x00002aab, 0x00002242,
  0x0000fffe, 0x00002aab, 0x00004ccd, 0x000054f6,
  0x0000d555, 0x00004ccd, 0x00007f81, 0x000054f7,
  0x0000b333, 0x00007f81, 0x00007f82, 0x000054f8,
  0x0000807f, 0x00007f82, 0x00007f83, 0x000054f9,
  0x0000807e, 0x00007f83, 0x00007f84, 0x00005566,
  0x0000807d, 0x00007f84, 0x00007ff1, 0x00005573,
  0x0000807c, 0x00007ff1, 0x00007ffe, 0x00005574,
  0x0000800f, 0x00007ffe, 0x00007fff, 0x00005575,
  0x00007ffd, 0x00007ffe, 0x00005557, 0x00003354,
  0x00007ffe, 0x00007fff, 0x00005558, 0x00003355,
  0x00007fff, 0x00008000, 0x00005559, 0x00003356,
  0x00008000, 0x00008001, 0x0000555a, 0x00003364,
  0x00008001, 0x00008002, 0x00005568, 0x000033d1,
  0x00008002, 0x00008010, 0x000055d5, 0x000033d2,
  0x00008010, 0x0000807d, 0x000055d6, 0x000033d3,
  0x0000807d, 0x0000807e, 0x000055d7, 0x00006687,
  0x0000807e, 0x0000807f, 0x0000888b, 0x000088a9,
  0x0000807f, 0x0000b333, 0x0000aaad, 0x0000b351,
  0x0000b333, 0x0000d555, 0x0000d555, 0x0000b352,
  0x0000d555, 0x0000fffd, 0x0000d556, 0x0000b353,
  0x0000fffd, 0x0000fffe, 0x0000d557, 0x00004cec,
  0x0000fffe, 0x0000ffff, 0x00002aac, 0x00004ceb,
  0x0000ffff, 0x00000002, 0x00002aab, 0x00002242,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00002aaa, 0x00002224, 0x000032d4,
  0x00002aaa, 0x00004ccc, 0x000054d8, 0x000032d5,
  0x00004ccc, 0x00007f80, 0x000054d9, 0x000032d6,
  0x00007f80, 0x00007f81, 0x000054da, 0x000032d7,
  0x00007f81, 0x00007f82, 0x000054db, 0x00003344,
  0x00007f82, 0x00007f83, 0x00005548, 0x00003351,
  0x00007f83, 0x00007ff0, 0x00005555, 0x00003352,
  0x00007ff0, 0x00007ffd, 0x00005556, 0x00003353,
  0x00007ffc, 0x00005555, 0x00003335, 0x000000a0,
  0x00007ffd, 0x00005556, 0x00003336, 0x000000a1,
  0x00007ffe, 0x00005557, 0x00003337, 0x000000a2,
  0x00007fff, 0x00005558, 0x00003338, 0x000000b0,
  0x00008000, 0x00005559, 0x00003346, 0x0000011d,
  0x00008001, 0x00005567, 0x000033b3, 0x0000011e,
  0x0000800f, 0x000055d4, 0x000033b4, 0x0000011f,
  0x0000807c, 0x000055d5, 0x000033b5, 0x000033d3,
  0x0000807d, 0x000055d6, 0x00006669, 0x000055f5,
  0x0000807e, 0x0000888a, 0x0000888b, 0x0000809d,
  0x0000b332, 0x0000aaac, 0x0000b333, 0x0000809e,
  0x0000d554, 0x0000d554, 0x0000b334, 0x0000809f,
  0x0000fffc, 0x0000d555, 0x0000b335, 0x00007fa0,
  0x0000fffd, 0x0000d556, 0x00004cce, 0x00007f9f,
  0x0000fffe, 0x00002aab, 0x00004ccd, 0x000054f6,
  0x00000001, 0x00002aaa, 0x00002224, 0x000032d4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002aa9, 0x00002223, 0x000032b6, 0x00000021,
  0x00004ccb, 0x000054d7, 0x000032b7, 0x00000022,
  0x00007f7f, 0x000054d8, 0x000032b8, 0x00000023,
  0x00007f80, 0x000054d9, 0x000032b9, 0x00000090,
  0x00007f81, 0x000054da, 0x00003326, 0x0000009d,
  0x00007f82, 0x00005547, 0x00003333, 0x0000009e,
  0x00007fef, 0x00005554, 0x00003334, 0x0000009f,
  0x00005553, 0x00003333, 0x00000081, 0x0000009f,
  0x00005554, 0x00003334, 0x00000082, 0x000000a0,
  0x00005555, 0x00003335, 0x00000083, 0x000000a1,
  0x00005556, 0x00003336, 0x00000084, 0x000000af,
  0x00005557, 0x00003337, 0x00000092, 0x0000011c,
  0x00005558, 0x00003345, 0x000000ff, 0x0000011d,
  0x00005566, 0x000033b2, 0x00000100, 0x0000011e,
  0x000055d3, 0x000033b3, 0x00000101, 0x000033d2,
  0x000055d4, 0x000033b4, 0x000033b5, 0x000055f4,
  0x000055d5, 0x00006668, 0x000055d7, 0x0000809c,
  0x00008889, 0x0000888a, 0x0000807f, 0x0000809d,
  0x0000aaab, 0x0000b332, 0x00008080, 0x0000809e,
  0x0000d553, 0x0000b333, 0x00008081, 0x00007fa1,
  0x0000d554, 0x0000b334, 0x00007f82, 0x00007fa0,
  0x0000d555, 0x00004ccd, 0x00007f81, 0x000054f7,
  0x00002aaa, 0x00004ccc, 0x000054d8, 0x000032d5,
  0x00002aa9, 0x00002223, 0x000032b6, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00002222, 0x000032b5, 0x00000003, 0x00000021,
  0x000054d6, 0x000032b6, 0x00000004, 0x00000022,
  0x000054d7, 0x000032b7, 0x00000005, 0x0000008f,
  0x000054d8, 0x000032b8, 0x00000072, 0x0000009c,
  0x000054d9, 0x00003325, 0x0000007f, 0x0000009d,
  0x00005546, 0x00003332, 0x00000080, 0x0000009e,
  0x00003331, 0x0000007f, 0x00000080, 0x0000009e,
  0x00003332, 0x00000080, 0x00000081, 0x0000009f,
  0x00003333, 0x00000081, 0x00000082, 0x000000a0,
  0x00003334, 0x00000082, 0x00000083, 0x000000ae,
  0x00003335, 0x00000083, 0x00000091, 0x0000011b,
  0x00003336, 0x00000091, 0x000000fe, 0x0000011c,
  0x00003344, 0x000000fe, 0x000000ff, 0x0000011d,
  0x000033b1, 0x000000ff, 0x00000100, 0x000033d1,
  0x000033b2, 0x00000100, 0x000033b4, 0x000055f3,
  0x000033b3, 0x000033b4, 0x000055d6, 0x0000809b,
  0x00006667, 0x000055d6, 0x0000807e, 0x0000809c,
  0x00008889, 0x0000807e, 0x0000807f, 0x0000809d,
  0x0000b331, 0x0000807f, 0x00008080, 0x00007fa2,
  0x0000b332, 0x00008080, 0x00007f83, 0x00007fa1,
  0x0000b333, 0x00007f81, 0x00007f82, 0x000054f8,
  0x00004ccc, 0x00007f80, 0x000054d9, 0x000032d6,
  0x00004ccb, 0x000054d7, 0x000032b7, 0x00000022,
  0x00002222, 0x000032b5, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000032b4, 0x00000002, 0x00000003, 0x00000021,
  0x000032b5, 0x00000003, 0x00000004, 0x0000008e,
  0x000032b6, 0x00000004, 0x00000071, 0x0000009b,
  0x000032b7, 0x00000071, 0x0000007e, 0x0000009c,
  0x00003324, 0x0000007e, 0x0000007f, 0x0000009d,
  0x0000007d, 0x0000007e, 0x0000007f, 0x0000009d,
  0x0000007e, 0x0000007f, 0x00000080, 0x0000009e,
  0x0000007f, 0x00000080, 0x00000081, 0x0000009f,
  0x00000080, 0x00000081, 0x00000082, 0x000000ad,
  0x00000081, 0x00000082, 0x00000090, 0x0000011a,
  0x00000082, 0x00000090, 0x000000fd, 0x0000011b,
  0x00000090, 0x000000fd, 0x000000fe, 0x0000011c,
  0x000000fd, 0x000000fe, 0x000000ff, 0x000033d0,
  0x000000fe, 0x000000ff, 0x000033b3, 0x000055f2,
  0x000000ff, 0x000033b3, 0x000055d5, 0x0000809a,
  0x000033b3, 0x000055d5, 0x0000807d, 0x0000809b,
  0x000055d5, 0x0000807d, 0x0000807e, 0x0000809c,
  0x0000807d, 0x0000807e, 0x0000807f, 0x00007fa3,
  0x0000807e, 0x0000807f, 0x00007f84, 0x00007fa2,
  0x0000807f, 0x00007f82, 0x00007f83, 0x000054f9,
  0x00007f80, 0x00007f81, 0x000054da, 0x000032d7,
  0x00007f7f, 0x000054d8, 0x000032b8, 0x00000023,
  0x000054d6, 0x000032b6, 0x00000004, 0x00000022,
  0x000032b4, 0x00000002, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000003, 0x0000008d,
  0x00000002, 0x00000003, 0x00000070, 0x0000009a,
  0x00000003, 0x00000070, 0x0000007d, 0x0000009b,
  0x00000070, 0x0000007d, 0x0000007e, 0x0000009c,
  0x0000007c, 0x0000007d, 0x0000007e, 0x00000030,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00000031,
  0x0000007e, 0x0000007f, 0x00000080, 0x00000032,
  0x0000007f, 0x00000080, 0x00000081, 0x00000040,
  0x00000080, 0x00000081, 0x0000008f, 0x000000ad,
  0x00000081, 0x0000008f, 0x000000fc, 0x000000ae,
  0x0000008f, 0x000000fc, 0x000000fd, 0x000000af,
  0x000000fc, 0x000000fd, 0x000000fe, 0x00003363,
  0x000000fd, 0x000000fe, 0x000033b2, 0x00005585,
  0x000000fe, 0x000033b2, 0x000055d4, 0x0000802d,
  0x000033b2, 0x000055d4, 0x0000807c, 0x0000802e,
  0x000055d4, 0x0000807c, 0x0000807d, 0x0000802f,
  0x0000807c, 0x0000807d, 0x0000807e, 0x00008010,
  0x0000807d, 0x0000807e, 0x00007f85, 0x0000800f,
  0x0000807e, 0x00007f83, 0x00007f84, 0x00005566,
  0x00007f81, 0x00007f82, 0x000054db, 0x00003344,
  0x00007f80, 0x000054d9, 0x000032b9, 0x00000090,
  0x000054d7, 0x000032b7, 0x00000005, 0x0000008f,
  0x000032b5, 0x00000003, 0x00000004, 0x0000008e,
  0x00000001, 0x00000002, 0x00000003, 0x0000008d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x0000006f, 0x0000002d,
  0x00000002, 0x0000006f, 0x0000007c, 0x0000002e,
  0x0000006f, 0x0000007c, 0x0000007d, 0x0000002f,
  0x0000007b, 0x0000007c, 0x00000011, 0x00000023,
  0x0000007c, 0x0000007d, 0x00000012, 0x00000024,
  0x0000007d, 0x0000007e, 0x00000013, 0x00000025,
  0x0000007e, 0x0000007f, 0x00000014, 0x00000033,
  0x0000007f, 0x00000080, 0x00000022, 0x000000a0,
  0x00000080, 0x0000008e, 0x0000008f, 0x000000a1,
  0x0000008e, 0x000000fb, 0x00000090, 0x000000a2,
  0x000000fb, 0x000000fc, 0x00000091, 0x00003356,
  0x000000fc, 0x000000fd, 0x00003345, 0x00005578,
  0x000000fd, 0x000033b1, 0x00005567, 0x00008020,
  0x000033b1, 0x000055d3, 0x0000800f, 0x00008021,
  0x000055d3, 0x0000807b, 0x00008010, 0x00008022,
  0x0000807b, 0x0000807c, 0x00008011, 0x0000801d,
  0x0000807c, 0x0000807d, 0x00007ff2, 0x0000801c,
  0x0000807d, 0x00007f84, 0x00007ff1, 0x00005573,
  0x00007f82, 0x00007f83, 0x00005548, 0x00003351,
  0x00007f81, 0x000054da, 0x00003326, 0x0000009d,
  0x000054d8, 0x000032b8, 0x00000072, 0x0000009c,
  0x000032b6, 0x00000004, 0x00000071, 0x0000009b,
  0x00000002, 0x00000003, 0x00000070, 0x0000009a,
  0x00000001, 0x00000002, 0x0000006f, 0x0000002d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x0000006e, 0x0000000f, 0x00000021,
  0x0000006e, 0x0000007b, 0x00000010, 0x00000022,
  0x0000007a, 0x0000000f, 0x00000004, 0x00000022,
  0x0000007b, 0x00000010, 0x00000005, 0x00000023,
  0x0000007c, 0x00000011, 0x00000006, 0x00000024,
  0x0000007d, 0x00000012, 0x00000007, 0x00000032,
  0x0000007e, 0x00000013, 0x00000015, 0x0000009f,
  0x0000007f, 0x00000021, 0x00000082, 0x000000a0,
  0x0000008d, 0x0000008e, 0x00000083, 0x000000a1,
  0x000000fa, 0x0000008f, 0x00000084, 0x00003355,
  0x000000fb, 0x00000090, 0x00003338, 0x00005577,
  0x000000fc, 0x00003344, 0x0000555a, 0x0000801f,
  0x000033b0, 0x00005566, 0x00008002, 0x00008020,
  0x000055d2, 0x0000800e, 0x00008003, 0x00008021,
  0x0000807a, 0x0000800f, 0x00008004, 0x0000801e,
  0x0000807b, 0x00008010, 0x00007fff, 0x0000801d,
  0x0000807c, 0x00007ff1, 0x00007ffe, 0x00005574,
  0x00007f83, 0x00007ff0, 0x00005555, 0x00003352,
  0x00007f82, 0x00005547, 0x00003333, 0x0000009e,
  0x000054d9, 0x00003325, 0x0000007f, 0x0000009d,
  0x000032b7, 0x00000071, 0x0000007e, 0x0000009c,
  0x00000003, 0x00000070, 0x0000007d, 0x0000009b,
  0x00000002, 0x0000006f, 0x0000007c, 0x0000002e,
  0x00000001, 0x0000006e, 0x0000000f, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000006d, 0x0000000e, 0x00000003, 0x00000021,
  0x0000000d, 0x00000002, 0x00000003, 0x00000021,
  0x0000000e, 0x00000003, 0x00000004, 0x00000022,
  0x0000000f, 0x00000004, 0x00000005, 0x00000023,
  0x00000010, 0x00000005, 0x00000006, 0x00000031,
  0x00000011, 0x00000006, 0x00000014, 0x0000009e,
  0x00000012, 0x00000014, 0x00000081, 0x0000009f,
  0x00000020, 0x00000081, 0x00000082, 0x000000a0,
  0x0000008d, 0x00000082, 0x00000083, 0x00003354,
  0x0000008e, 0x00000083, 0x00003337, 0x00005576,
  0x0000008f, 0x00003337, 0x00005559, 0x0000801e,
  0x00003343, 0x00005559, 0x00008001, 0x0000801f,
  0x00005565, 0x00008001, 0x00008002, 0x00008020,
  0x0000800d, 0x00008002, 0x00008003, 0x0000801f,
  0x0000800e, 0x00008003, 0x00008000, 0x0000801e,
  0x0000800f, 0x00007ffe, 0x00007fff, 0x00005575,
  0x00007ff0, 0x00007ffd, 0x00005556, 0x00003353,
  0x00007fef, 0x00005554, 0x00003334, 0x0000009f,
  0x00005546, 0x00003332, 0x00000080, 0x0000009e,
  0x00003324, 0x0000007e, 0x0000007f, 0x0000009d,
  0x00000070, 0x0000007d, 0x0000007e, 0x0000009c,
  0x0000006f, 0x0000007c, 0x0000007d, 0x0000002f,
  0x0000006e, 0x0000007b, 0x00000010, 0x00000022,
  0x0000006d, 0x0000000e, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
};
const unsigned kExpectedCount_NEON_sabal2_4S = 576;

#endif  // VIXL_SIM_SABAL2_4S_TRACE_AARCH64_H_
