# 4.0.1 Release Notes

This primarily a bug fix release, but also includes some new features. This is the release that allowed me to incorporate StringTemplate v4 into ANTLR v3.

## New feature list

* 	`<% ... %>` templates that ignore indentation and newlines.
* 	Improved StringTemplate Inspector GUI
* 	`...` pass-through operator sets argument x of an included template to be the value of x in the enclosing template.
* 	Added STGroup.iterateAcrossValues static boolean for v3 compatibility v3 iterates across values not keys like v4. But to convert ANTLR templates, it's too hard to find without static typing in templates.
* 	improve some error messages
* 	Added <aggr.{prop1, prop2}> notation for injecting attributes  in ST.add(). E.g., 
 ``` 	
st.add("users.{name,id}", "Ter", "parrt");
```
 
## April 10, 2011

* 	Added STNoSuchAttributeException to distinguish from no such property.
* 	Pass through didn't handle case properly of empty or nonexistent attributes. We only pass through nonempty values. Further, it makes no sense to set values for parameter x if x has no definition above. That is the same as having no value. This is required to get default attributes to work with passthru in all cases. Added unit tests.
* 	Oops. That is not quite correct. If no value exists or the attribute itself does not exist, we must set the parameter to null ifthere is no default parameter. otherwise the interpreter will complain about a missing argument value.
* 	Was missing alreadyLoaded = true; in STGroupString.
* 	Bug fix for `<@super.r()>` exprs; it tried to doubly-define region. Code generator didn't generate mangled name either
* 	Improved error msg when referencing implicit attributes like 'i'.

## April 9, 2011

* 	Sam pointed out that regions didn't work with `<% %>`
* 	Cleaned up STViz, the StringTemplate Inspector GUI.
* 	STViz expands template attribute view when you click in output
* 	STViz template and attribute tree views now grouped.
* 	default arguments were not evaluated in context of invoked template; couldn't see other args.
* 	Added `...` pass through arg back in. Only allowed with named arg lists or as sole arg. Not allowed in `<(name)()>` indirect includes. Inserts new passthru bytecode to set any unset args.
* 	AST pane not updated upon new ST selection
* 	Scroll output pane when ST selected
* 	Added STGroup.iterateAcrossValues static boolean for v3 compatibility v3 iterates across values not keys like v4. But to convert ANTLR templates, it's too hard to find without static typing in templates.
* 	Cleaned up ST.locals[] creation; centralized in Interpreter.
* 	MapModelAdaptor made copy of STs unnecessarily and w/o copying locals[]

## April 8, 2011

* 	Added scope tree showing all inherited attributes (dynamic scoping) in lower left "attributes" pane.
* 	Undid some bugs I introduced concerning selecting templates. Tried to move the cursor in output window which triggered multiple / wrong update events.

## April 6, 2011

* 	Ignore indentation in <% .. %> templates but keep white space between elements
* 	Added better error msg for internal errors during template evaluation.
  
 ```
context [outputFile parser genericParser rule ruleBlockSingleAlt alt element
ruleRefAndListLabel ruleRef] 1:1 internal error caused by: java.lang.NullPointerException
at org.stringtemplate.v4.ST.rawSetAttribute(ST.java:294)
at org.stringtemplate.v4.Interpreter.storeArgs(Interpreter.java:576)
at org.stringtemplate.v4.Interpreter.super_new(Interpreter.java:495)
...
```

## April 4, 2011

* 	in TestSubtemplates.java there was an extra (bad) import
* 	fixed a couple of unit tests that failed.
* 	removed .class files from depot
* 	added `t() ::= <% ... %>` template that ignores all newlines inside template. This allows arbitrary formatting within a template that does not result in new lines in the output. This is useful when you have a really complicated template with IFs and such that needs to generate output all on the same line. Currently, this can be quite challenging. There's no way to read a huge template on one line.

## April 3, 2011

* 	ST.getAttribute() only looks in that template now. Can't look up since it doesn't know what interp is executing. It's just to get an attr out of a template now. Moved dynamically scope getAttribute() to Interpreter.
* 	STRuntimeMessage takes an Interpreter interp arg now.
* 	ST dropped some weight. No need for enclosingInstance ptr now. That is properly done in interpreter as a stack of scopes. Now, there is no side-effect whatsoever in ST instances for execution. THREAD SAFE eval now.
* 	Interpreter interp added to ModelAdaptor. BREAKING CHANGE IF YOU'VE BUILT a model adaptor (rare)
* 	Internal clean up so stack of template evaluation scopes has debug info. Required changes across lots of files. Started referring to scopes so entire path to root is available and with debugging info if debug on for that interpreter. Extracted InstanceScope from inner class.

## March 30 - April 2, 2011

* 	ST.inspect() now returns an STViz, which has all the goodies and gives you access to the GUI stuff.
* 	added `aggr.{prop1, prop2}` for ST.add(). Too useful. (Was in v3). Use ST.addAggr("aggr.{p1,p2}", a1, a2);
* 	refactored to fold DebugST into ST; adds one object ptr to every ST instance but worth reduction in complexity. "new ST(...)" calls didn't work (not DebugST objects) in inspector. ST.inspect() for any ST now.
* 	Fixed bug in STViz. Didn't highlight entire output when you click topmost template.
* 	STGroup.debug no longer there nor static. It's an instance var of Interpreter. ST.inspect() tells interp to debug. STGroup.trackCreationEvents says to record where in code an ST was created and where code added attributes.
* 	Gutted tree model for STViz, refactored debugging/event tracking code.
* 	creation events had wrong location (launch of interp location); only tracks now for externally/injected created templates.

## March 29, 2011

* 	Fixed bug where escaped quotes in template defs were not unescaped for use by compiler.
