/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.tok.Token;

class ReplacementTextBuffer {
    private static final int INIT_SIZE = 64;
    private char[] buf = new char[64];
    private int len;
    private boolean mustReparse = false;
    private Entity.Reference[] refs = new Entity.Reference[2];
    int nRefs;

    ReplacementTextBuffer() {
    }

    public void clear() {
        this.len = 0;
        this.mustReparse = false;
        this.nRefs = 0;
    }

    public void setMustReparse() {
        this.mustReparse = true;
    }

    public boolean getMustReparse() {
        return this.mustReparse;
    }

    public void appendReplacementText(Entity entity) {
        this.appendEntityReference(new Entity.Reference(entity, this.len, this.len + entity.text.length));
        this.append(entity.text, 0, entity.text.length);
    }

    private void appendEntityReference(Entity.Reference reference) {
        if (this.nRefs == this.refs.length) {
            Entity.Reference[] referenceArray = this.refs;
            this.refs = new Entity.Reference[referenceArray.length << 1];
            System.arraycopy(referenceArray, 0, this.refs, 0, referenceArray.length);
        }
        this.refs[this.nRefs++] = reference;
    }

    public Entity.Reference[] getReferences() {
        if (this.nRefs == 0) {
            return null;
        }
        Entity.Reference[] referenceArray = new Entity.Reference[this.nRefs];
        System.arraycopy(this.refs, 0, referenceArray, 0, this.nRefs);
        return referenceArray;
    }

    public void append(char c) {
        this.need(1);
        this.buf[this.len++] = c;
    }

    public void appendRefCharPair(Token token) {
        this.need(2);
        token.getRefCharPair(this.buf, this.len);
        this.len += 2;
    }

    public void append(char[] cArray, int n, int n2) {
        this.need(n2 - n);
        for (int i = n; i < n2; ++i) {
            this.buf[this.len++] = cArray[i];
        }
    }

    private void need(int n) {
        if (this.len + n <= this.buf.length) {
            return;
        }
        char[] cArray = this.buf;
        this.buf = n > cArray.length ? new char[n * 2] : new char[cArray.length << 1];
        System.arraycopy(cArray, 0, this.buf, 0, cArray.length);
    }

    public char[] getChars() {
        char[] cArray = new char[this.len];
        System.arraycopy(this.buf, 0, cArray, 0, this.len);
        return cArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public int length() {
        return this.len;
    }

    public char charAt(int n) {
        if (n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[n];
    }

    public void chop() {
        --this.len;
    }
}

