
/**
 * \file V_error.c
 *
 * \brief Display error functions.
 *
 * (C) 1999-2009 by the GRASS Development Team 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * \author GRASS GIS Development Team
 *
 * \date 1999-2009
 */

#include <stdio.h>
#include <stdarg.h>
#include <grass/gis.h>
#include <grass/vask.h>

/**
 * \fn int V_error (char *message)
 *
 * \brief Dispay error routine.
 *
 * Deals with error messages generated by other Visual ask routines.
 *
 * \param[in] message
 * \return always returns 0
 */

void V_error(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    fprintf(stderr, "V_ask error: ");
    vfprintf(stderr, fmt, ap);
    va_end(ap);

    G_sleep(4);
}
