/*
 * Copyright (c) 2009-2012, Albertas Vyšniauskas
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *     * Neither the name of the software author nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CHANGENOTIFICATION_H_
#define CHANGENOTIFICATION_H_

#include "ColorSource.h"

#include <map>
#include <string>
#include <list>

#include <boost/shared_ptr.hpp>

class ChangeNotification;

class NotificationLink{
protected:
	std::string source_name;
	uint32_t source_slot_id;
	std::string destination_name;
	uint32_t destination_slot_id;

	bool enabled;

public:
	NotificationLink(const char *source_name, uint32_t source_slot_id, const char *destination_name, uint32_t destination_slot_id);
	friend class ChangeNotification;
};

class ChangeNotification{
protected:
	std::map<std::string, ColorSource*> sources;
	std::multimap<std::string, boost::shared_ptr<NotificationLink> > links;
public:
	ChangeNotification();
	~ChangeNotification();

	bool registerSource(const char *location, ColorSource *source);
	bool unregisterSource(const char *location, ColorSource *source);

	bool addLink(boost::shared_ptr<NotificationLink> notification_link);
	bool removeLink(boost::shared_ptr<NotificationLink> notification_link);
};

#endif /* CHANGENOTIFICATION_H_ */

