### 查询条件方法

查询和统计主要使用`Get`, `Find`, `Count`, `Rows`, `Iterate`这几个方法。在进行查询时可以使用多个方法来形成查询条件，条件函数如下：

* Id(interface{})
传入一个PK字段的值，作为查询条件，如
```Go
engine.Id(1).Get(&user)
// SELECT * FROM user Where id = 1
```

如果是复合主键，则可以
```Go
engine.Id(core.PK{1, "name"}).Get(&user)
// SELECT * FROM user Where id =1 AND name= 'name'
```
传入的两个参数按照struct中pk标记字段出现的顺序赋值。

* Where(string, …interface{})
和SQL中Where语句中的条件基本相同，作为条件

* And(string, …interface{})
和Where函数中的条件基本相同，作为条件

* Or(string, …interface{})
和Where函数中的条件基本相同，作为条件

* Sql(string, …interface{})
执行指定的Sql语句，并把结果映射到结构体

* Asc(…string)
指定字段名正序排序

* Desc(…string)
指定字段名逆序排序

* OrderBy(string)
按照指定的顺序进行排序

* In(string, …interface{})
某字段在一些值中，这里需要注意必须是[]interface{}才可以展开，由于Go语言的限制，[]int64等不可以直接展开，而是通过传递一个slice。示例代码如下：
```Go
engine.In("cloumn", 1, 2, 3).Find()
engine.In("column", []int{1, 2, 3}).Find()
```

* Cols(…string)
只查询或更新某些指定的字段，默认是查询所有映射的字段或者根据Update的第一个参数来判断更新的字段。例如：
```Go
engine.Cols("age", "name").Find(&users)
// SELECT age, name FROM user
engine.Cols("age", "name").Update(&user)
// UPDATE user SET age=? AND name=?
```

* AllCols()
查询或更新所有字段，一般与Update配合使用，因为默认Update只更新非0，非""，非bool的字段。
```Go
engine.AllCols().Id(1).Update(&user)
// UPDATE user SET name = ?, age =?, gender =? WHERE id = 1
```

* MustCols(…string)
某些字段必须更新，一般与Update配合使用。

* Omit(...string)
和cols相反，此函数指定排除某些指定的字段。注意：此方法和Cols方法不可同时使用
```Go
engine.Omit("age", "gender").Update(&user)
// UPDATE user SET name = ? AND department = ?

engine.Omit("age, gender").Insert(&user)
// INSERT INTO user (name) values (?) // 这样的话age和gender会给默认值

engine.Omit("age", "gender").Find(&users)
// SELECT name FROM user //只select除age和gender字段的其它字段
```

* Distinct(…string)
按照参数中指定的字段归类结果
```Go
engine.Distinct("age", "department").Find(&users)
// SELECT DISTINCT age, department FROM user
```
注意：当开启了缓存时，此方法的调用将在当前查询中禁用缓存。因为缓存系统当前依赖Id，而此时无法获得Id

* Table(nameOrStructPtr interface{})
传入表名称或者结构体指针，如果传入的是结构体指针，则按照IMapper的规则提取出表名

* Limit(int, …int)
限制获取的数目，第一个参数为条数，第二个参数表示开始位置，如果不传则为0

* Top(int)
相当于Limit(int, 0)

* Join(string,string,string)
第一个参数为连接类型，当前支持INNER, LEFT OUTER, CROSS中的一个值，第二个参数为表名，第三个参数为连接条件
```Go
type UserGroup struct {
    User `xorm:"extends"`
    Group `xorm:"extends"`
}
usergroup := make([]UserGroup, 0)
engine.Table(&User{}).Join("INNER", "group", "group.id = user.group_id").Find(&usergroup)
```

* GroupBy(string)
Groupby的参数字符串

* Having(string)
Having的参数字符串
