### 名称映射规则

名称映射规则主要负责结构体名称到表名和结构体field到表字段的名称映射。由xorm.IMapper接口的实现者来管理，xorm内置了两种IMapper实现：`SnakeMapper` 和 `SameMapper`。SnakeMapper支持struct为驼峰式命名，表结构为下划线命名之间的转换；SameMapper支持结构体名称和对应的表名称以及结构体field名称与对应的表字段名称相同的命名。

当前SnakeMapper为默认值，如果需要改变时，在engine创建完成后使用

```Go
engine.SetMapper(SameMapper{})
```

同时需要注意的是：

* 如果你使用了别的命名规则映射方案，也可以自己实现一个IMapper。
* 表名称和字段名称的映射规则默认是相同的，当然也可以设置为不同，如：

```Go
engine.SetTableMapper(SameMapper{})
engine.SetColumnMapper(SnakeMapper{})
```


When a struct auto mapping to a database's table, the below table describes how they change to each other:

<table>
    <tr>
    <td>go type's kind
    </td>
    <td>value method</td>
    <td>xorm type
    </td>
    </tr>
    <tr>
 <td>implemented Conversion</td>
 <td>Conversion.ToDB / Conversion.FromDB</td>
 <td>Text</td>
 </tr>
 <tr>
 <td>int, int8, int16, int32, uint, uint8, uint16, uint32</td>
 <td></td>
 <td> Int </td>
 </tr>
 <tr>
 <td>int64, uint64</td><td></td><td>BigInt</td>
 </tr>
 <tr><td>float32</td><td></td><td>Float</td>
 </tr>
 <tr><td>float64</td><td></td><td>Double</td>
 </tr>
 <tr><td>complex64, complex128</td>
 <td>json.Marshal / json.UnMarshal</td>
 <td>Varchar(64)</td>
 </tr>
 <tr>
 <td>[]uint8</td><td></td><td>Blob</td>
 </tr>
 <tr>
 <td>array, slice, map except []uint8</td>
 <td>json.Marshal / json.UnMarshal</td>
 <td>Text</td>
 </tr>
 <tr>
 <td>bool</td><td>1 or 0</td><td>Bool</td>
 </tr>
 <tr>
 <td>string</td><td></td><td>Varchar(255)</td>
 </tr>
 <tr>
 <td>time.Time</td><td></td><td>DateTime</td>
 </tr>
  <tr>
 <td>cascade struct</td><td>primary key field value</td><td>BigInt</td>
 </tr>
 <tr>
 <tr>
 <td>struct</td><td>json.Marshal / json.UnMarshal</td><td>Text</td>
 </tr>
 <tr>
 <td>
 Others
 </td>
 <td></td>
 <td>
 Text
 </td>
 </tr>
 </table>