### 6.1.Optimistic Lock

To enable object optimistic lock, add 'version' tag value:
```Go
type User struct {
    Id int64
    Name string
    Version int `xorm:"version"`
}
```
The version starts with 1 when inserted to DB. For updating make sure originated version value is used for optimistic lock check.

```Go
var user User
engine.Id(1).Get(&user)
// SELECT * FROM user WHERE id = ?
engine.Id(1).Update(&user)
// UPDATE user SET ..., version = version + 1 WHERE id = ? AND version = ?
```
