### 5.1. Chainable APIs for Queries, Execusions and Aggregations

Queries and Aggregations is basically formed by using `Get`, `Find`, `Count` methods, with conjunction of following chainable APIs to form conditions, grouping and ordering:
查询和统计主要使用`Get`, `Find`, `Count`三个方法。在进行查询时可以使用多个方法来形成查询条件，条件函数如下：

* Id([]interface{})
Primary Key lookup

* Where(string, …interface{})
As SQL conditional WHERE clause

* And(string, …interface{})
Conditional AND 

* Or(string, …interface{})
Conditional OR

* Sql(string, …interface{})
Custom SQL query

* Asc(…string)
Ascending ordering on 1 or more fields

* Desc(…string)
Descending ordering on 1 or more fields

* OrderBy(string)
As SQL ORDER BY

* In(string, …interface{})
As SQL Conditional IN

* Cols(…string)
Explicity specify query or update columns. e.g.,:
```Go
engine.Cols("age", "name").Find(&users)
// SELECT age, name FROM user
engine.Cols("age", "name").Update(&user)
// UPDATE user SET age=? AND name=?
```

* Omit(...string)
Inverse function to Cols, to exclude specify query or update columns. Warning: Don't use with Cols()
```Go
engine.Omit("age").Update(&user)
// UPDATE user SET name = ? AND department = ?
```

* Distinct(…string)
As SQL DISTINCT
```Go
engine.Distinct("age", "department").Find(&users)
// SELECT DISTINCT age, department FROM user
```
Caution: this method will not lookup from caching store


* Table(nameOrStructPtr interface{})
Specify table name, or if struct pointer is passed into the name is extract from struct type name by IMapper conversion policy

* Limit(int, …int)
As SQL LIMIT with optional second param for OFFSET

* Top(int)
As SQL LIMIT

* Join(type, tableName, criteria string)
As SQL JOIN, support
type: either of these values [INNER, LEFT OUTER, CROSS] are supported now
tableName: joining table name
criteria: join criteria

* GroupBy(string)
As SQL GROUP BY

* Having(string)
As SQL HAVING
