### 2.4.Column definition

Struct tag defines something for column as basic sql concepts, such as :

```
type User struct {
    Id   int64
    Name string  `xorm:"varchar(25) not null unique 'usr_name'"`
}
```

Data types are different in different DBMS. So xorm makes own data types definition to keep compatible. Details is in document [Column Types](https://github.com/go-xorm/xorm/blob/master/docs/COLUMNTYPE.md).

The following table is field mapping rules, the keyword is not case sensitive except column name：

<table>
    <tr>
        <td>name or 'name'</td><td>Column Name, optional</td>
    </tr>
    <tr>
        <td>pk</td><td>If column is Primary Key</td>
    </tr>
    <tr>
        <td>support over 30 kinds of column types, details in [Column Types](https://github.com/go-xorm/xorm/blob/master/docs/COLUMNTYPE.md)</td><td>column type</td>
    </tr>
    <tr>
        <td>autoincr</td><td>If autoincrement column</td>
    </tr>
    <tr>
        <td>[not ]null | notnull</td><td>if column could be blank</td>
    </tr>
    <tr>
        <td>unique/unique(uniquename)</td><td>column is Unique index; if add (uniquename), the column is used for combined unique index with the field that defining same uniquename.</td>
    </tr>
    <tr>
        <td>index/index(indexname)</td><td>column is index. if add (indexname), the column is used for combined index with the field that defining same indexname.</td>
    </tr>
    <tr>
        <td>extends</td><td>use for anonymous field, map the struct in anonymous field to database</td>
    </tr>
    <tr>
        <td>-</td><td>This field will not be mapping</td>
    </tr>
     <tr>
        <td>-></td><td>only write into database</td>
    </tr>
     <tr>
        <td>&lt;-</td><td>only read from database</td>
    </tr>
     <tr>
        <td>created</td><td>This field will be filled in current time on insert</td>
    </tr>
     <tr>
        <td>updated</td><td>This field will be filled in current time on insert or update</td>
    </tr>
    <tr>
        <td>version</td><td>This field will be filled 1 on insert and autoincrement on update</td>
    </tr>
    <tr>
        <td>default 0 | default 'name'</td><td>column default value</td>
    </tr>
</table>

Some default mapping rules：

- 1. If field is name of `Id` and type of `int64`, xorm makes it as auto increment primary key. If another field, use struct tag `xorm:"pk"`.

- 2. String is corresponding to varchar(255).

- 3. Support custom type as `type MyString string`，slice, map as field type. They are saving as Text column type and json-encode string. Support Blob column type with field type []byte or []uint8.

- 4. You can implement Conversion interface to define your custom mapping rule between field and database data.

```
type Conversion interface {
    FromDB([]byte) error
    ToDB() ([]byte, error)
}
```

- 5. If one struct has a Conversion field, so we need set an implementation to the field before get data from database. We can implement `BeforeSet(name string, cell xorm.Cell)` on struct to do this. For example: [testConversion](https://github.com/go-xorm/tests/blob/master/base.go#L1826)


<table>
    <tr>
    <td>xorm
    </td>
    <td>mysql
    </td>
    <td>sqlite3
    </td>
    <td>postgres
    </td>
    <td>remark</td>
    </tr>
    
    <tr>
    <td>BIT
    </td>
    <td>BIT
    </td>
    <td>INTEGER
    </td>
    <td>BIT
    </td>
    <td></td>
    </tr>
    
    <tr>
    <td>TINYINT
    </td>
    <td>TINYINT
    </td>
    <td>INTEGER
    </td>
    <td>SMALLINT
    </td>
    <td></td>
    </tr>


<tr>
    <td>SMALLINT
    </td>
    <td>SMALLINT
    </td>
    <td>INTEGER
    </td>
    <td>SMALLINT
    </td>
    <td></td>
    </tr>


<tr>
    <td>MEDIUMINT
    </td>
    <td>MEDIUMINT
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>


<tr>
    <td>INT
    </td>
    <td>INT
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>

<tr>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>


<tr>
    <td>BIGINT
    </td>
    <td>BIGINT
    </td>
    <td>INTEGER
    </td>
    <td>BIGINT
    </td>
    <td></td>
    </tr>
 <tr><td cols="5"></td></tr>

<tr>
    <td>CHAR
    </td>
    <td>CHAR
    </td>
    <td>TEXT
    </td>
    <td>CHAR
    </td>
    <td></td>
    </tr>


<tr>
    <td>VARCHAR
    </td>
    <td>VARCHAR
    </td>
    <td>TEXT
    </td>
    <td>VARCHAR
    </td>
    <td></td>
    </tr>


<tr>
    <td>TINYTEXT
    </td>
    <td>TINYTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>

<tr>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>
    
<tr>
    <td>MEDIUMTEXT
    </td>
    <td>MEDIUMTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>


<tr>
    <td>LONGTEXT
    </td>
    <td>LONGTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>
<tr><td cols="5"></td></tr>

<tr>
    <td>BINARY
    </td>
    <td>BINARY
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>VARBINARY
    </td>
    <td>VARBINARY
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>
<tr><td cols="5"></td></tr>

<tr>
    <td>DATE
    </td>
    <td>DATE
    </td>
    <td>NUMERIC
    </td>
    <td>DATE
    </td>
    <td></td>
    </tr>


<tr>
    <td>DATETIME
    </td>
    <td>DATETIME
    </td>
    <td>NUMERIC
    </td>
    <td>TIMESTAMP
    </td>
    <td></td>
    </tr>


<tr>
    <td>TIME
    </td>
    <td>TIME
    </td>
    <td>NUMERIC
    </td>
    <td>TIME
    </td>
    <td></td>
    </tr>


<tr>
    <td>TIMESTAMP
    </td>
    <td>TIMESTAMP
    </td>
    <td>NUMERIC
    </td>
    <td>TIMESTAMP
    </td>
    <td></td>
    </tr>
    
    
<tr>
    <td>TIMESTAMPZ
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TIMESTAMP with zone
    </td>
    <td>timestamp with zone info</td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>FLOAT
    </td>
    <td>FLOAT
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>DOUBLE
    </td>
    <td>DOUBLE
    </td>
    <td>REAL
    </td>
    <td>DOUBLE PRECISION
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>DECIMAL
    </td>
    <td>DECIMAL
    </td>
    <td>NUMERIC
    </td>
    <td>DECIMAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>TINYBLOB
    </td>
    <td>TINYBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>MEDIUMBLOB
    </td>
    <td>MEDIUMBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>LONGBLOB
    </td>
    <td>LONGBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>

<tr>
    <td>BYTEA
    </td>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>

<tr>
    <td>BOOL
    </td>
    <td>TINYINT
    </td>
    <td>INTEGER
    </td>
    <td>BOOLEAN
    </td>
    <td></td>
    </tr>


<tr>
    <td>SERIAL
    </td>
    <td>INT
    </td>
    <td>INTEGER
    </td>
    <td>SERIAL
    </td>
    <td>auto increment</td>
    </tr>

<tr>
    <td>BIGSERIAL
    </td>
    <td>BIGINT
    </td>
    <td>INTEGER
    </td>
    <td>BIGSERIAL
    </td>
    <td>auto increment</td>
    </tr>


</table>