/*
*
*  $Id: surfacepipeline.h 3388 2011-02-23 10:20:17Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#include <list>
#include <yasper/yasper.h>
#include "ipipeline.h"

class vtkImageReslice;
class vtkImageGaussianSmooth;
class vtkImageMarchingCubes;
class vtkContourFilter;
class vtkDecimatePro;
class vtkImageResample;
class vtkImageReslice;
class vtkSmoothPolyDataFilter;
class vtkPolyDataNormals;
class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class wxWindow;
class vtkDepthSortPolyData;

namespace MedicalViewer {
	namespace Reconstruction {

		namespace Pipelines {
			class SurfaceCommandObserver;
		}
	}
}

#define NSURF 2

namespace MedicalViewer {
	namespace Reconstruction {
		namespace Pipelines {

			class SurfacePipeline : public IPipeline {

			public:

				typedef std::list<vtkSmartPointer<SurfaceCommandObserver> > TProgressList;

				typedef vtkImageMarchingCubes TReconstructionFilter;

				bool                                     Enabled[NSURF];

				vtkSmartPointer<vtkImageResample>        Resample;

				vtkSmartPointer<vtkImageGaussianSmooth>  PreSmooth;
				vtkSmartPointer<vtkImageGaussianSmooth>  PostSmooth;

				vtkSmartPointer<TReconstructionFilter>   Surf[NSURF];
				vtkSmartPointer<vtkDecimatePro>          Decimate[NSURF];
				vtkSmartPointer<vtkDepthSortPolyData>    DepthSort[NSURF];

				vtkSmartPointer<vtkPolyDataNormals>      Normals[NSURF];

				vtkSmartPointer<vtkPolyDataMapper>       Mapper[NSURF];
				vtkSmartPointer<vtkLODActor>             Actor[NSURF];

				TProgressList Progresses;

				bool         ApplyPreSmooth;
				bool         ApplyPostSmooth;
				unsigned int resolutionQuality;

			public:

				SurfacePipeline(wxWindow* win3d);

				~SurfacePipeline();

				void SetupInteractor();

				void SetDataSet(unsigned int volNum, unsigned int quality);

				void EnableSurface(int surf, bool enable);

				void SetSurfValue(int surf, double val);

				void SetSurfColor(int surf, double r, double g, double b);

				void SetSurfTransparency(int surf, double opacity);

				void EnableSmooth(bool enablePreSmooth, bool enablePostSmooth);

				void Enable(int surf, bool enabled);

				void SetProgressNotifier(IReconstructionNotifier* notifier);

				virtual void Update();

			protected:
				void SetResolutionQuality(unsigned int resolution);
			};
		}
	}
}
