/*
 *  
 *  $Id: gvistacompleja.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/wx.h>
#include "gvistacompleja.h"
#include "gvistasimple.h"
#include "imprimevistasimple.h"
#include "../vistas/vista2d.h"
#include <visualizator/resources/aprimresourcemanager.h>
#include <resources/ginkgoresourcemanager.h>

#include <wx/msgdlg.h>
#include <wx/menu.h>

#include "../eventos/visualizatorevents.h"
#include <api/icontroladorherramientas.h>
#include <api/icontroladorlog.h>
#include <api/icontroladorvistas.h>
#include <eventos/eventosginkgo.h>
#include <api/iwidgetsmanager.h>
#include "../estudios/visualizatorstudy.h"

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkVISUManagement/vtkLookupTableManager.h>
#include <vtk/widgets/widgetsactor.h>
#include <vtkCamera.h>
#include <vtkPointData.h>
#include <vtkImageBlend.h>
#include <vtkImageMathematics.h>
#include <api/westilo.h>


#include <export/iherramientapuntero.h>
#include <export/iherramientaregla.h>
#include <export/iherramientaangulo.h>
#include <export/iherramientanota.h>
#include <export/itoolwindowlevel.h>
#include <export/iherramientalupa.h>
#include <export/iherramientamarcado.h>
#include <export/iherramientarejillametrica.h>
#include <export/iherramientaanotacionesesquina.h>
#include <api/imodelointegracion.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorpermisos.h>
#include <api/icontroladorcomandos.h>
#include <export/iherramientareset.h>
#include <export/iherramientalayoutventana.h>
#include "../exportacion/iherramientamapacolor.h"
#include "../exportacion/iherramientaoverlays.h"
#include "../exportacion/ireconstructiontool.h"
#include <export/iherramientadesencajar.h>

#include <commands/comandodestruirvista.h>

#include <cairo/cairo.h>
#include <widgets/openglhelper.h>
//#include <widgets/wprogreso.h>
#include <widgets/wanotacionesquina.h>

#include <hackimageactor.h>


#include "reconstruction/endoscopy.h"
#include "reconstruction/mpr3d.h"
#include "reconstruction/surface.h"
#include "reconstruction/volume.h"

#define ID_BOTON_PLAY_STOP 0
#define ID_BOTON_VER 1
#define ID_BOTON_LAYOUT 2
#define ID_BOTON_SINCRONIZAR 3
#define ID_BOTON_DESENCAJAR 4

#define ID_ROTATE_LEFT 4151
#define ID_ROTATE_RIGHT 4152
#define ID_FLIP_V 4153
#define ID_FLIP_H 4154
//esta clase sirve para las barras de herramientas de abajo
class BarraHerramientasBotones:public wxAuiToolBar{
public:
	BarraHerramientasBotones(wxWindow* pParent, const wxColor& color = wxColor(0x40, 0x40, 0x40)): wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize, wxAUI_TB_DEFAULT_STYLE)
	{
		SetToolBitmapSize(wxSize(16,16));
		AUI_NAMESPACE wxAuiDefaultToolBarArt* pToolArt= new AUI_NAMESPACE wxAuiDefaultToolBarArt();
#if defined(USE_PATCHED_LIBS) && !defined(__WXOSX__)
		pToolArt->SetBaseColor(color);
#endif
		SetArtProvider(pToolArt);
	}

	~BarraHerramientasBotones()
	{
	}
};

//esta clase sirve para no tener que definir identificadores en las opciones de periodo en el cine
class ItemFrameRate: protected wxEvtHandler, public wxMenuItem {
public:
	ItemFrameRate(wxMenu *parentMenu,const wxString& text,GVistaCompleja* pVista,int periodo):wxMenuItem(parentMenu,wxID_ANY,text,wxEmptyString,wxITEM_CHECK)
	{
		m_pVista = pVista;
		m_periodo = periodo;
		int id = wxMenuItem::GetId();
		#ifdef __WXMSW__
		parentMenu->GetParent()->Connect(id,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( ItemFrameRate::OnMenuClick),NULL,this);
		#else
		parentMenu->Connect(id,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( ItemFrameRate::OnMenuClick),NULL,this);
		#endif
	}
	~ItemFrameRate(){
		m_pVista =NULL;
		int id = wxMenuItem::GetId();
		#ifdef __WXMSW__
		GetMenu()->GetParent()->Disconnect(id,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( ItemFrameRate::OnMenuClick ),NULL,this);
		#else
		GetMenu()->Disconnect(id,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( ItemFrameRate::OnMenuClick ),NULL,this);
		#endif
	}

	void OnMenuClick(wxCommandEvent &event) {
		m_pVista->SetPeriodo(m_periodo);
		event.Skip(false);
	}


	GVistaCompleja* m_pVista;
	int m_periodo;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class TimerPlay:public wxTimer
{
public:
	TimerPlay(GVistaCompleja *pVista){
		m_pVista=pVista;
	}

	~TimerPlay() {}

	virtual void Notify(){
		m_pVista->OnTimer();
	}

	GVistaCompleja *m_pVista;
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


GVistaCompleja::GVistaCompleja(GNKVisualizator::Vista2D* pIVista) : VistaComplejaBase(pIVista->GetVisualizatorStudy()->VentanaPadre ) {
	IVista = pIVista;
	IVista->GetVisualizatorStudy()->Ventana = this;
	m_hasBeenRendered = false;
	m_ReproducirBucle = false;
	m_PeriodoMs = 500;
	m_posicion = m_pSliderSlice->GetValue();

	// Setup del manejador de widgets */
	GNC::GCS::IContratoWidgets::m_pManager = IVista->GetEstudio()->Entorno->NewWidgetsManager(IVista);
	GNC::GCS::IContratoWidgets::Setup(GNC::GCS::IContratoWidgets::m_pManager);

	m_playTimer = new TimerPlay(this);

	//se añaden los botones de ver/cine
	m_pBarraIzquierda = new BarraHerramientasBotones(m_pPanelManipulacion);
	m_pBarraIzquierda->AddTool(ID_BOTON_VER,_("Display Options"),APrimResourcesManager::Herramientas::GetIcoMenuImagen(),_("Display Options"));
	m_pBarraIzquierda->Connect(ID_BOTON_VER,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( GVistaCompleja::OnMenuVerClick),NULL,this);

	m_pBarraIzquierda->AddTool(ID_BOTON_LAYOUT,_("Layout Setup"),APrimResourcesManager::Herramientas::GetIcoLayout(),_("Layout Setup"));
	m_pBarraIzquierda->Connect(ID_BOTON_LAYOUT,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( GVistaCompleja::OnMenuLayout),NULL,this);

	GNC::GCS::IControladorHerramientas* cH = IVista->GetEstudio()->Entorno->GetControladorHerramientas();
	try {
		GNC::GCS::IHerramientaDesencajar*  hDesencajar = NULL;
		hDesencajar = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaDesencajar>(GNC::GCS::IHerramientaDesencajar::ID);
		if (hDesencajar != NULL) {
			m_pBarraIzquierda->AddTool(ID_BOTON_DESENCAJAR,_("Disencage view"),hDesencajar->GetIcono(),_("Disencage view"));
			m_pBarraIzquierda->Connect(ID_BOTON_DESENCAJAR,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( GVistaCompleja::OnDesencajar),NULL,this);
		}
	}catch(...){}

	m_pBarraIzquierda->Realize();
	m_pSizerIzquierda->Add(m_pBarraIzquierda,0, wxALIGN_CENTER_VERTICAL|wxEXPAND,0);

	m_pBarraCine = new BarraHerramientasBotones(m_pPanelManipulacion);
	m_pBarraCine->AddTool(ID_BOTON_PLAY_STOP,_("Play"),GinkgoResourcesManager::BarraCine::GetIcoPlay(),_("Play"));
	m_pBarraCine->Connect(ID_BOTON_PLAY_STOP,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( GVistaCompleja::OnPlayStopClick),NULL,this);
	m_pBarraCine->SetToolDropDown(ID_BOTON_PLAY_STOP, true);
	m_pBarraCine->Connect(ID_BOTON_PLAY_STOP,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler( GVistaCompleja::OnMenuCineClick),NULL,this);

	m_pBarraCine->Realize();
	m_pSizerIzquierda->Add(m_pBarraCine,0, wxALIGN_CENTER_VERTICAL|wxEXPAND,0);

	//se añaden los de sincronizar/dessincronizar
	m_pBarraDerecha = new BarraHerramientasBotones(m_pPanelManipulacion);
	m_pBarraDerecha->AddTool(ID_BOTON_SINCRONIZAR,_("Synchronize/Des synchronize"),APrimResourcesManager::BarraSincronizar::GetIcoDessincronizar(),_("Synchronize/Des synchronize"),wxITEM_CHECK);
	m_pBarraDerecha->Connect(ID_BOTON_SINCRONIZAR,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( GVistaCompleja::OnSincronizarClick),NULL,this);
	m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,false);

	m_pBarraDerecha->Realize();
	m_pSizerDerecho->Add(m_pBarraDerecha,0, wxALIGN_CENTER_VERTICAL|wxEXPAND,0);




	//Connect(wxEVT_CHILD_FOCUS, wxChildFocusEventHandler(GVistaCompleja::OnFocus),NULL,this);
	Connect(wxEVT_KEY_DOWN,wxKeyEventHandler(GVistaCompleja::OnKeyDown),NULL,this);
	Connect(wxEVT_CHAR,wxKeyEventHandler(GVistaCompleja::OnKeyDown),NULL,this);
	Connect(wxEVT_MOUSEWHEEL,wxMouseEventHandler(GVistaCompleja::OnMouseWheel),NULL,this);

	GNC::GCS::Eventos::EventoModificacionImagen ev2(IVista);
	GNC::GCS::Eventos::EventoModificacionWidget ev3(IVista);
	GNC::GCS::Eventos::EventoRender ev4(IVista);
	GNKVisualizator::Eventos::EventoMostrarOverlay evt5(IVista);

	pIVista->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev2);
	pIVista->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev3);
	pIVista->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev4);
	pIVista->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, evt5);

	GNC::GCS::IContratoWidgets::m_pManager->CrearWidgetAnotador(this);
	AddVistaSimple();

	//FUNDAMENTAL PARA QUE FUNCIONE LA HERRAMIENTA DE MAPAS DE COLOR
	IVista->VisualizatorStudy->Viewer = m_VistasSimples[0]->ViewImage2D;

	//GNC::GCS::IContratoWidgets::m_pManager->InsertarWidget(new GNC::GCS::Widgets::WProgreso(m_VistasSimples.front()->ViewInteractor2D, GNC::GCS::IContratoWidgets::m_pManager, -1, "progreso", 666));
	GNC::GCS::IContratoWidgets::m_pManager->EnableAnimation();

	Layout();
}

GVistaCompleja::~GVistaCompleja()
{
	IVista->ComienzaDestruccion();
	//FUNDAMENTAL PARA QUE los viewers se destruyan correctamente y sin leaks ya que Viewer es smart pointer
	for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->UnRefIVista();
	}

	IVista->VisualizatorStudy->Viewer = NULL;

	if (IVista != NULL) {
		IVista->VisualizatorStudy->Entorno->GetControladorComandos()->AbortarComandosDeOwner(IVista);
	}

	//Disconnect(wxEVT_CHILD_FOCUS, wxChildFocusEventHandler(GVistaCompleja::OnFocus),NULL,this);
	this->Disconnect(wxEVT_KEY_DOWN,wxKeyEventHandler(GVistaCompleja::OnKeyDown),NULL,this);
	this->Disconnect(wxEVT_MOUSEWHEEL,wxMouseEventHandler(GVistaCompleja::OnMouseWheel),NULL,this);

	if(m_ListaSincronizacion.size() >0){
		//si esta reproduciendose se para
		Stop();
		//
		DesSincronizar();
	}

	if(m_playTimer!= NULL) {
		delete m_playTimer;
		m_playTimer = NULL;
	}

	GNC::GCS::IContratoWidgets::m_pManager->EliminarTodosLosWidgets(false);

	m_VistasSimples.clear();

	IVista->GetEstudio()->Entorno->FreeWidgetsManager(GNC::GCS::IContratoWidgets::m_pManager);
	GNC::GCS::IContratoWidgets::m_pManager = NULL;
	
	GNKVisualizator::IReconstructionTool* hReconstruction = IVista->VisualizatorStudy->Entorno->GetControladorHerramientas()->ObtenerHerramientaConcreta<GNKVisualizator::IReconstructionTool>(GNKVisualizator::IReconstructionTool::ID);
	if (hReconstruction != NULL) {
		((GNC::GCS::IContratable<GNKVisualizator::IReconstructionContract>*)hReconstruction)->DesSubscribirsLosDeLaVista(IVista);
	}

	IVista->Lock(GLOC());
	delete IVista;
}

void GVistaCompleja::AddVistaSimple()
{
	GVistaSimple* pVistaSimple = new GVistaSimple(IVista,this);
	m_VistasSimples.push_back(pVistaSimple);
	m_pSizerSeries->Add(pVistaSimple,1,wxEXPAND);


	GNC::GCS::IWidgetsRenderer* pR = pVistaSimple->ViewInteractor2D;
	pR->SetManager(GNC::GCS::IContratoWidgets::m_pManager);
	pR->SetIOverlay(pVistaSimple);
	//GNC::GCS::IContratoWidgets::m_pManager->SetRendererActivo(pR);
	std::ostringstream os;
	os << "Renderer " << pVistaSimple << std::endl;
	pR->sid = os.str();
	////

	WidgetRepresentation* pWidgetsRepresentation = WidgetRepresentation::New();
	pWidgetsRepresentation->SetRenderer(pVistaSimple->ViewInteractor2D->FindPokedRenderer(0,0));
	pVistaSimple->ViewInteractor2D->FindPokedRenderer(0,0)->AddViewProp(pWidgetsRepresentation);
	pR->SetRepresentation(pWidgetsRepresentation);
	pWidgetsRepresentation->SetWidgetsManager(GNC::GCS::IContratoWidgets::m_pManager);
	pWidgetsRepresentation->SetWidgetsRenderer(pR);
	pWidgetsRepresentation->Delete();

	pVistaSimple->ViewImage2D->SetWindowLevelFrom(m_VistasSimples[0]->ViewImage2D);
	pVistaSimple->ViewImage2D->SetLookupTable(m_VistasSimples[0]->ViewImage2D->GetLookupTable(), m_VistasSimples[0]->ViewImage2D->GetIdLookupTable());
	pVistaSimple->ViewImage2D->SetZoom(m_VistasSimples[0]->ViewImage2D->GetZoom());
	pVistaSimple->ViewImage2D->CopyCameraStatus(m_VistasSimples[0]->ViewImage2D);

	for (unsigned int i = 0; i < m_VistasSimples.size(); i++) {
		GNC::GCS::IWidgetsRenderer* pR = m_VistasSimples[i]->ViewInteractor2D;
		pR->SetVID(i, false);
		std::ostringstream os;
		os << "Renderer " << i << std::endl;
		pR->sid = os.str();
	}
}

void GVistaCompleja::IniciarPipeline()
{
	m_pPanelManipulacion->Enable(true);

	m_pListaOverlays = IVista->VisualizatorStudy->GetOverlaysImagenActiva();
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNKVisualizator::Eventos::EventoRefrescarListaOverlays(IVista,m_pListaOverlays));

	//contratos que son 1:1 con gvistacompleja
	GNKVisualizator::IContratoMapaColor::Setup(IVista->GetEstudio());
	GNKVisualizator::IReconstructionContract::Setup(IVista->GetEstudio());
	GNKVisualizator::IContratoOverlays::Setup(m_pListaOverlays,IVista->GetEstudio()->Entorno);
	//esto es correcto porque en la creacion se mete siempre una vista simple


	GNC::GCS::IContractWindowLevel::Setup(*IVista->GetEstudio()->GetTagsImagenDeImagenActiva());


	///////////recorrer las vistas simples y pasarles las imagenes
	int i = 0;
	if(m_VistasSimples.size() > 0) {
		for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
			GVistaSimple* pvs = *it;
			pvs->EstudioReferido->SetIndiceActivo(i);
			pvs->SetOverlays(m_pListaOverlays, m_EstadoOverlays);

			//despues se establece el WL
			if (HasDefaultWindowLevel()) {
				GNC::GCS::IContractWindowLevel::WindowLevel wl = GetAndSetDefaultWindowLevel();
				pvs->ViewImage2D->SetDefaultWindowLevel(wl.m_window, wl.m_level);
			}
			else {
				pvs->ViewImage2D->SetAutoDefaultWindowLevel();
			}
			i++;
		}
		GNC::GCS::IContratoWidgets::m_pManager->SetRendererActivo( (* (m_VistasSimples.begin()) )->ViewInteractor2D );

		GNC::GCS::IContratoLayoutVentana::Setup(0, IVista->GetEstudio()->GetNumeroCortes() - 1);

		ActualizarMaxMinSlider();
	}

	//contrato window level, hay que preguntarle al viewer de la primera vista porque el estudioatencionprimaria no tiene viewer
	GNC::GCS::IControladorHerramientas* cH = IVista->GetEstudio()->Entorno->GetControladorHerramientas();
	GNC::GCS::IToolWindowLevel* hWindowLevel = NULL;
	try {
		if(m_VistasSimples[0]->ViewImage2D->GetNumberOfComponents() == 1){
			// Subscribimos la vista al contrato de hWindowLevel
			hWindowLevel = cH->ObtenerHerramientaConcreta<GNC::GCS::IToolWindowLevel>(GNC::GCS::IToolWindowLevel::ID);
			if (hWindowLevel != NULL) {
				((GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>*)hWindowLevel)->Subscribir(IVista, this);
				((GNC::GCS::IContratable<GNC::GCS::IContractWindowLevel>*)hWindowLevel)->Subscribir(IVista, this);
			}
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex << std::endl;
	}

	GNKVisualizator::IReconstructionTool* hReconstruction = cH->ObtenerHerramientaConcreta<GNKVisualizator::IReconstructionTool>(GNKVisualizator::IReconstructionTool::ID);
	if (hReconstruction != NULL) {
		((GNC::GCS::IContratable<GNKVisualizator::IReconstructionContract>*)hReconstruction)->Subscribir(IVista, this);
	}
}



void GVistaCompleja::DetenerPipeline()
{
	m_pManager->OcultarTodosLosWidgets(true, 666);
	m_pManager->DisableAnimation();
	m_pPanelManipulacion->Enable(true);
	m_pManager->Render();
}

void GVistaCompleja::OnCargaFinalizada()
{
	m_pManager->OcultarTodosLosWidgets(true, 666);
	m_pManager->DisableAnimation();
	m_pManager->Render();
}


void GVistaCompleja::OnPaint(wxPaintEvent& event)
{
	//std::cout << "GVistaCompleja::OnPaint()" << std::endl;
	VistaComplejaBase::OnPaint(event);
	if(IVista->GetEstudio()->Entorno->GetControladorVistas()->GetVistaActiva() == IVista)
	{
		wxPaintDC dc(this);
		wxColour colorLineaSeleccion(219, 219, 0, 255);
		dc.SetBrush(wxBrush(colorLineaSeleccion,wxTRANSPARENT));
		dc.SetPen(wxPen(colorLineaSeleccion, 3, wxSOLID));
		dc.DrawRectangle(wxRect(wxPoint(1, 1), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
	}
	//la comprobacion de la textura, se hace la primera vez que se pinta
	if(!m_hasBeenRendered ) {
		if(IVista->EstaCargada()) {
			for(GVistaCompleja::TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
				GVistaSimple* vs = *it;
				try {
					vs->ViewInteractor2D->Render();
					long idTextura = vs->ViewImage2D->GetImageTexture();
					if (idTextura != 0) {
						if ( !glIsTexture(idTextura) ) {
							IVista->GetEstudio()->Entorno->GetControladorLog()->Log("GVistaCompleja: Textura no cargada en memoria de video",GNC::GCS::IControladorLog::ErrorLog);
							IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,_Std("Error: You have exhausted the system's video memory and has not been able to load the image. Close some studies to free memory."),GNC::GCS::Eventos::EventoMensajes::PopUpMessage,false));
							GADAPI::ComandoDestruirVistaParams* pParams = new GADAPI::ComandoDestruirVistaParams(IVista);
							IVista->GetEstudio()->Entorno->GetControladorComandos()->ProcessAsync(_Std("Destroy View"),new GADAPI::ComandoDestruirVista(pParams),NULL);
						}
					} else {
						//se comprobara mas tarde porque la textura todavia no tiene id
						return;
					}
				}catch(const std::bad_alloc&)
				{
					IVista->GetEstudio()->Entorno->GetControladorLog()->Log("GVistaCompleja: bad_alloc, error al reservar memoria física",GNC::GCS::IControladorLog::ErrorLog);
					IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,_Std("Error: System out of memory. Close some studies to free memory."),GNC::GCS::Eventos::EventoMensajes::PopUpMessage,false));
					GADAPI::ComandoDestruirVistaParams* pParams = new GADAPI::ComandoDestruirVistaParams(IVista);
					IVista->GetEstudio()->Entorno->GetControladorComandos()->ProcessAsync(_Std("Destroy View"),new GADAPI::ComandoDestruirVista(pParams),NULL);
				}
				catch(...)
				{
					IVista->GetEstudio()->Entorno->GetControladorLog()->Log("GVistaCompleja: excepción general al comprobar errores de memoria",GNC::GCS::IControladorLog::ErrorLog);
					IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,_Std("Error: Internal error."),GNC::GCS::Eventos::EventoMensajes::PopUpMessage,false));
					GADAPI::ComandoDestruirVistaParams* pParams = new GADAPI::ComandoDestruirVistaParams(IVista);
					IVista->GetEstudio()->Entorno->GetControladorComandos()->ProcessAsync(_Std("Destroy View"),new GADAPI::ComandoDestruirVista(pParams),NULL);
				}
			}
			m_hasBeenRendered = true;
		}
	}
}

void GVistaCompleja::OnMenuVerClick(wxCommandEvent& )
{
	IVista->OnFocus();
	wxMenu* pMenuVer = new wxMenu();
	GNC::GCS::IControladorHerramientas* cH = IVista->GetEstudio()->Entorno->GetControladorHerramientas();
	try {
		//////HERRAMIENTA ANOTACIONES ESQUINA, UN MENU////
		GNC::GCS::IHerramientaAnotacionesEsquina*  hAnotacionesEsquina = NULL;
		// Subscribimos la vista al contrato de Anotaciones ventana
		// Subscribimos la vista al contrato de rejilla
		hAnotacionesEsquina = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			hAnotacionesEsquina->AppendInMenu(this,pMenuVer);
		}

		GNC::GCS::IHerramientaRejillaMetrica*  hRejilla = NULL;
		// Subscribimos la vista al contrato de rejilla
		hRejilla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRejillaMetrica>(GNC::GCS::IHerramientaRejillaMetrica::ID);
		if (hRejilla != NULL) {
			hRejilla->AppendInMenu(this,pMenuVer);
		}

		pMenuVer->AppendSeparator();
		
		/////MAPA DE COLOR/////
		GNKVisualizator::IHerramientaMapaColor*  hMapa = NULL;
		// Subscribimos la vista al contrato de rejilla
		hMapa = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaMapaColor>(GNKVisualizator::IHerramientaMapaColor::ID);
		if (hMapa != NULL) {
			hMapa->AppendInMenu(this,pMenuVer);
		}
		/////OVERLAYS//////
		GNKVisualizator::IHerramientaOverlays*  hOverlays = NULL;
		// Subscribimos la vista al contrato de rejilla
		hOverlays = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaOverlays>(GNKVisualizator::IHerramientaOverlays::ID);
		if (hOverlays != NULL) {
			hOverlays->AppendInMenu(this,pMenuVer);
		}

		if (m_pEntorno->GetControladorPermisos()->Get("atencionprimaria", "reconstruction")) {
			GNKVisualizator::IReconstructionTool* hReconstruction = NULL;
			// Reconstruction Tool subscription
			hReconstruction = cH->ObtenerHerramientaConcreta<GNKVisualizator::IReconstructionTool>(GNKVisualizator::IReconstructionTool::ID);
			if (hReconstruction != NULL) {
				pMenuVer->AppendSeparator();
				hReconstruction->AppendInMenu(this, pMenuVer);
			}
		}

		pMenuVer->AppendSeparator();

		//////RESETEAR////
		GNC::GCS::IHerramientaReset*  hReset = NULL;
		// Subscribimos la vista al contrato de reset
		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			hReset->AppendInMenu(this,pMenuVer);
		}

		//rotate left y right y flip
		pMenuVer->AppendSeparator();
		wxMenuItem* pRotateLeft = new wxMenuItem(pMenuVer, ID_ROTATE_LEFT, _("Rotate 90") + wxString::FromUTF8("º")+ _(" Counter-ClockWise"));
		wxMenuItem* pRotateRight = new wxMenuItem(pMenuVer, ID_ROTATE_RIGHT, _("Rotate 90") + wxString::FromUTF8("º")+ _(" ClockWise"));
		wxMenuItem* pFlipVertical = new wxMenuItem(pMenuVer, ID_FLIP_V, _("Flip Vertical"));
		wxMenuItem* pFlipHorizontal = new wxMenuItem(pMenuVer, ID_FLIP_H, _("Flip Horizontal"));
		
		#ifdef __WXMSW__
			pRotateLeft->SetBitmaps(APrimResourcesManager::Herramientas::GetIcoRotateLeft());
			pRotateRight->SetBitmaps(APrimResourcesManager::Herramientas::GetIcoRotateRight());
			pFlipVertical->SetBitmaps(APrimResourcesManager::Herramientas::GetIcoFlipVertical());
			pFlipHorizontal->SetBitmaps(APrimResourcesManager::Herramientas::GetIcoFlipHorizontal());
		#else
			pRotateLeft->SetBitmap(APrimResourcesManager::Herramientas::GetIcoRotateLeft());
			pRotateRight->SetBitmap(APrimResourcesManager::Herramientas::GetIcoRotateRight());
			pFlipVertical->SetBitmap(APrimResourcesManager::Herramientas::GetIcoFlipVertical());
			pFlipHorizontal->SetBitmap(APrimResourcesManager::Herramientas::GetIcoFlipHorizontal());
		#endif
		pMenuVer->Append(pRotateLeft);
		pMenuVer->Append(pRotateRight);
		pMenuVer->AppendSeparator();
		pMenuVer->Append(pFlipVertical);
		pMenuVer->Append(pFlipHorizontal);

		pMenuVer->Connect(ID_ROTATE_LEFT, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnRotateLeft),NULL,this);
		pMenuVer->Connect(ID_ROTATE_RIGHT, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnRotateRight),NULL,this);
		pMenuVer->Connect(ID_FLIP_V, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnFlipVertical),NULL,this);
		pMenuVer->Connect(ID_FLIP_H, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnFlipHorizontal),NULL,this);
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex << std::endl;
	}
	m_pBarraIzquierda->PopupMenu(pMenuVer);
	delete pMenuVer;
}


void GVistaCompleja::OnMenuCineClick(wxAuiToolBarEvent& evt)
{
	if (evt.IsDropDownClicked())
	{
		wxAuiToolBar* tb = static_cast<wxAuiToolBar*>(evt.GetEventObject());
		tb->SetToolSticky(evt.GetId(), true);

		IVista->OnFocus();
		//se crea el menu
		wxMenu menuVer;
		wxMenu* pMenuFrameRate = new wxMenu();
		menuVer.AppendSubMenu(pMenuFrameRate,_("Speed"));
		//importante si se añade un titulo añadir un periodo!!
		wxString titulos[8] = {wxT("20 fps"), wxT("8 fps"),wxT("4 fps"),wxT("2 fps"),wxT("1 fps"),wxT("0.5 fps"),wxT("0.2 fps"),wxT("0.1 fps")};
		int periodos[8] = {50,125,250,500,1000,2000,5000,10000};
		for(int i=0; i < 8; i++)
		{
			wxMenuItem* pItem = new ItemFrameRate(pMenuFrameRate,titulos[i],this,periodos[i]);
			pMenuFrameRate->Append(pItem);
			if(periodos[i] == m_PeriodoMs) {
				pItem->Check(true);
			}
		}

		wxMenuItem* pItem = new wxMenuItem(&menuVer,wxID_ANY,_("Loop"),_("Repeat on end"),wxITEM_CHECK);
		#ifdef __WXMSW__
		pItem->SetBitmaps(GinkgoResourcesManager::BarraCine::GetIcoBucle(),GinkgoResourcesManager::BarraCine::GetIcoNoBucle());
		//#else
		//pItem->SetBitmap(GinkgoResourcesManager::BarraCine::GetIcoBucle());
		#endif
		//este apend suelta por consola: 'InsertMenuItem()' failed with error 0x00000057, es un buf arreglado pero no afecta negativamente,
		// es xq solo tiene un bitmap mas info:
		//http://trac.wxwidgets.org/ticket/9878
		menuVer.Append(pItem);
		//
		menuVer.Check(pItem->GetId(),m_ReproducirBucle);
		menuVer.Connect(pItem->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnBucleClick ),NULL,this);

		if(!m_playTimer->IsRunning()){
			pItem = new wxMenuItem(&menuVer,wxID_ANY,_("Play"),_("Start playback"));
			#ifdef __WXMSW__
			pItem->SetBitmaps(GinkgoResourcesManager::BarraCine::GetIcoPlay());
			#else
			pItem->SetBitmap(GinkgoResourcesManager::BarraCine::GetIcoPlay());
			#endif
			menuVer.Append(pItem);
			menuVer.Connect(pItem->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnPlayStopClick ),NULL,this);
		} else {
			pItem = new wxMenuItem(&menuVer,wxID_ANY,_("Stop"),_("End playback"));
			#ifdef __WXMSW__
			pItem->SetBitmaps(GinkgoResourcesManager::BarraCine::GetIcoPause());
			#else
			pItem->SetBitmap(GinkgoResourcesManager::BarraCine::GetIcoPause());
			#endif
			menuVer.Append(pItem);
			menuVer.Connect(pItem->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( GVistaCompleja::OnPlayStopClick ),NULL,this);
		}

		wxRect rect = tb->GetToolRect(evt.GetId());
		wxPoint pt = tb->ClientToScreen(rect.GetBottomLeft());
		pt = ScreenToClient(pt);


		PopupMenu(&menuVer, pt);

		// make sure the button is "un-stuck"
		tb->SetToolSticky(evt.GetId(), false);
	}
}

void GVistaCompleja::OnMenuLayout(wxCommandEvent &event)
{
	IVista->OnFocus();
	GNC::GCS::IControladorHerramientas* cH = IVista->GetEstudio()->Entorno->GetControladorHerramientas();
	try {
		//////HERRAMIENTA layout ventana////
		GNC::GCS::IHerramientaLayoutVentana*  hLayout = NULL;
		hLayout = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLayoutVentana>(GNC::GCS::IHerramientaLayoutVentana::ID);
		if (hLayout != NULL) {
			wxMenu* pMenuLayout = hLayout->GetMenu(this);
			m_pBarraIzquierda->PopupMenu(pMenuLayout);
			delete pMenuLayout;
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex << std::endl;
	}
}

void GVistaCompleja::OnDesencajar(wxCommandEvent &event)
{
	IVista->OnFocus();
	GNC::GCS::IControladorHerramientas* cH = IVista->GetEstudio()->Entorno->GetControladorHerramientas();
	try {
		GNC::GCS::IHerramientaDesencajar*  hDesencajar = NULL;
		hDesencajar = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaDesencajar>(GNC::GCS::IHerramientaDesencajar::ID);
		if (hDesencajar != NULL) {
			if(hDesencajar->IsDesencajada()) {
				m_pBarraIzquierda->SetToolShortHelp(ID_BOTON_DESENCAJAR,_("Disengage Vista"));
			} else {
				m_pBarraIzquierda->SetToolShortHelp(ID_BOTON_DESENCAJAR,_("Fit View"));
			}
			hDesencajar->Desencajar(IVista);
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex << std::endl;
	}
}
void GVistaCompleja::OnRotateLeft(wxCommandEvent &event)
{
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->Rotar(false);
	}
}

void GVistaCompleja::OnRotateRight(wxCommandEvent &event)
{
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->Rotar(true);
	}	
}

void GVistaCompleja::OnFlipVertical(wxCommandEvent &event)
{
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->Flip(true);
	}
}

void GVistaCompleja::OnFlipHorizontal(wxCommandEvent &event)
{
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->Flip(false);
	}
}

void GVistaCompleja::ActualizarMaxMinSlider()
{
	//depende de m_MinSlice y m_MaxSlice;
	//tb depende del numero de vistasimples
	int minSlider = m_MinSlice;
	int maxSlider = ((m_MaxSlice - m_MinSlice) +1)  - (m_pSizerSeries->GetRows() * m_pSizerSeries->GetCols());
	if (minSlider < maxSlider) {
		m_pSliderSlice->SetRange(minSlider, maxSlider);
		m_pSliderSlice->Enable(true);
		if( !m_pBarraCine->IsShown() ) {
			m_pBarraCine->SetToolBitmap(ID_BOTON_PLAY_STOP, GinkgoResourcesManager::BarraCine::GetIcoPlay());
			m_pBarraCine->SetToolShortHelp(ID_BOTON_PLAY_STOP, _("Play"));
			m_pBarraCine->Enable(true);
			m_pBarraCine->Show(true);
		}
		m_pSliderSlice->Show(true);
		m_pBarraDerecha->Show(true);
		m_pBarraDerecha->Refresh();
	} else {
		m_pSliderSlice->SetRange(0, 1);
		if(m_ListaSincronizacion.size()>0)
		{
			Sincronizar(false);
		}
		if(m_playTimer->IsRunning()) {
			Stop();
		}
		m_pBarraCine->Hide();
		m_pSliderSlice->Show(false);
		m_pBarraDerecha->Show(false);
	}
}

void GVistaCompleja::SetPeriodo(int milisegundos)
{
	if(milisegundos>0) {
		m_PeriodoMs = milisegundos;
		if(m_playTimer->IsRunning()){
			m_playTimer->Stop();
			m_playTimer->Start(m_PeriodoMs);
		}
	}
}

void GVistaCompleja::OnFocus(wxChildFocusEvent &)
{
	IVista->OnFocus();
}

void GVistaCompleja::OnSize(wxSizeEvent &)
{
	Layout();
}

void GVistaCompleja::OnZSliderScroll (wxScrollEvent& event) {
	int pos = event.GetPosition() - m_posicion;

	if(pos!=0){
		GoToSlice(event.GetPosition(), false);
	}
	event.Skip(false);
}

void GVistaCompleja::OnKeyDown( wxKeyEvent& event )
{
	switch(event.GetKeyCode()){
		case WXK_RIGHT:
			{
				GoToSlice(1);
			}
			break;
		case WXK_LEFT:
			{
				GoToSlice(-1);
			}
			break;
		case WXK_ESCAPE:
			{
				GNC::GCS::ISolicitadorCambioHerramienta* solicitador = dynamic_cast<GNC::GCS::ISolicitadorCambioHerramienta*>(IVista->GetEstudio()->Entorno->GetControladorHerramientas());
				if(solicitador!=NULL){
					solicitador->SolicitarActivacion(IVista->GetEstudio()->Entorno->GetControladorHerramientas()->ObtenerHerramienta(GNC::GCS::IHerramientaPuntero::ID), event.ShiftDown() ? GNC::GCS::TriggerButton().EnableRight() : GNC::GCS::TriggerButton().EnableLeft());
				}
			}
			break;
		default:
			event.ResumePropagation(1);
			event.Skip(true);
	}
}

void GVistaCompleja::OnMouseWheel(wxMouseEvent& event)
{
	if (event.ControlDown())
	{
		if (event.ShiftDown()) {
			for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
				if(event.GetWheelRotation() > 0)
				{
					(*it)->GoToTSlice(-1);
				}
				else
				{
					(*it)->GoToTSlice(1);
				}
			}
		} else {
			if(event.GetWheelRotation() > 0)
			{
				GoToSlice(-1);
			}
			else
			{
				GoToSlice(1);
			}
		}
	} 
}

void GVistaCompleja::OnPlayStopClick(wxCommandEvent &){
	if(!m_playTimer->IsRunning()) {
		Play();
	} else {
		Stop();
	}
}

void GVistaCompleja::Play()
{
	if(!m_ReproducirBucle && m_pSliderSlice->GetValue() == m_pSliderSlice->GetMax()){
		GoToSlice(0,false);
	}
	m_playTimer->Start(m_PeriodoMs);
	m_pBarraCine->SetToolBitmap(ID_BOTON_PLAY_STOP, GinkgoResourcesManager::BarraCine::GetIcoStop());
	m_pBarraCine->SetToolShortHelp(ID_BOTON_PLAY_STOP, _("Stop"));
	m_pBarraCine->Refresh();

	AtencionPrimaria::Eventos::EventoSincronizacion* evt = new AtencionPrimaria::Eventos::EventoSincronizacion(IVista,AtencionPrimaria::Eventos::EventoSincronizacion::Play);
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(evt);
}

void GVistaCompleja::Stop()
{
	//stop
	m_playTimer->Stop();
	m_pBarraCine->SetToolBitmap(ID_BOTON_PLAY_STOP, GinkgoResourcesManager::BarraCine::GetIcoPlay());
	m_pBarraCine->SetToolShortHelp(ID_BOTON_PLAY_STOP, _("Play"));
	m_pBarraCine->Refresh();

	AtencionPrimaria::Eventos::EventoSincronizacion* evt = new AtencionPrimaria::Eventos::EventoSincronizacion(IVista,AtencionPrimaria::Eventos::EventoSincronizacion::Stop);
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(evt);
}

void GVistaCompleja::OnBucleClick(wxCommandEvent &){
	m_ReproducirBucle = !m_ReproducirBucle;
}

void GVistaCompleja::OnTimer()
{
	if((m_pSliderSlice->GetValue() +1 ) >m_pSliderSlice->GetMax() && m_ReproducirBucle){
		GoToSlice(0,false);
	} else {
		GoToSlice(1);

		if(m_pSliderSlice->GetValue()  == m_pSliderSlice->GetMax() && !m_ReproducirBucle){
			Stop();
		}
	}
}

//contrato widgets
vtkGinkgoImageViewer* GVistaCompleja::GetViewerActivo()
{
	// TODO Excepciones
	vtkGinkgoImageViewer* viewer = m_VistasSimples[0]->ViewImage2D;
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); viewer == NULL && it != m_VistasSimples.end(); it++)
	{
		if (m_pManager->GetRendererActivo() == (*it)->ViewInteractor2D)
		{
			viewer = (*it)->ViewImage2D;
		}
	}
	return viewer;
}

void GVistaCompleja::GetAllViewers(std::list<vtkGinkgoImageViewer*>& viewerList)
{
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		viewerList.push_back((*it)->ViewImage2D);
	}
}

//region "Realizacion de la interfaz IAnnotator"
std::string GVistaCompleja::GetTopLeftAnnotation(GNC::GCS::Contexto3D* c)
{
	GNC::GCS::IWidgetsRenderer* r = ( c == NULL? NULL : c->GetRenderer());
	if (r == NULL) {
		return m_VistasSimples[0]->GetTopLeftAnnotation(c);
	} else {
		for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
			if ( (*it)->ViewInteractor2D == r) {
				return (*it)->GetTopLeftAnnotation(c);
			}
		}
	}
	return "";
}

std::string GVistaCompleja::GetTopRightAnnotation(GNC::GCS::Contexto3D* c)
{
	GNC::GCS::IWidgetsRenderer* r = ( c == NULL? NULL : c->GetRenderer());
	if (r == NULL) {
		return m_VistasSimples[0]->GetTopRightAnnotation(c);
	} else {
		for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
			if ( (*it)->ViewInteractor2D == r) {
				return (*it)->GetTopRightAnnotation(c);
			}
		}
	}
	return "";
}

std::string GVistaCompleja::GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c)
{
	GNC::GCS::IWidgetsRenderer* r = ( c == NULL? NULL : c->GetRenderer());
	if (r == NULL) {
		return m_VistasSimples[0]->GetBottomLeftAnnotation(c);
	} else {
		for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
			if ( (*it)->ViewInteractor2D == r) {
				return (*it)->GetBottomLeftAnnotation(c);
			}
		}
	}
	return "";
}

std::string GVistaCompleja::GetBottomRightAnnotation(GNC::GCS::Contexto3D* c)
{
	GNC::GCS::IWidgetsRenderer* r = ( c == NULL? NULL : c->GetRenderer());
	if (r == NULL) {
		return m_VistasSimples[0]->GetBottomRightAnnotation(c);
	} else {
		for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
			if ( (*it)->ViewInteractor2D == r) {
				return (*it)->GetBottomRightAnnotation(c);
			}
		}
	}
	return "";
}

std::string GVistaCompleja::GetAnotacionPosicion(GNC::GCS::Vector* pPosicion)
{
	GNC::GCS::IWidgetsRenderer* r = GNC::GCS::IContratoWidgets::m_pManager->GetRendererActivo();
	for (TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		if ( (*it)->ViewInteractor2D == r) {
			return (*it)->GetAnotacionPosicion(pPosicion);
		}
	}
	return "";
}
//endregion

// Asigna los valores de los apuntadores a la la imagen y el slice actual
void GVistaCompleja::AsignarConexionesDeFiltrado(vtkImageData** pImagen, int* slice, vtkImageData** pChroma)
{
	/*
	*pImagen = m_pImagenOriginal;
	if(m_VistasSimples.size() > 0) {
		*slice = m_VistasSimples[0]->ViewImage2D->GetZSlice();
	}
	*/
}

void GVistaCompleja::ActualizarImagen()
{
	//m_pImagenOriginal->Modified();
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(IVista,GNC::GCS::Eventos::EventoModificacionImagen::ImagenModificada, -1));
}

//----------DIALOGO SINCRONIZACION...-------------
class DialogoSincronizacion: public DialogoSincronizacionBase {
public:
	typedef std::vector<GNKVisualizator::Vista2D*>	TipoListaVistas;
	DialogoSincronizacion(wxWindow* parent, TipoListaVistas listaVistas):DialogoSincronizacionBase(parent){
		m_lista = listaVistas;
		for(TipoListaVistas::iterator it = listaVistas.begin(); it!=listaVistas.end(); it++){
			m_pCheckListVistas->AppendString(wxString::FromUTF8((*it)->GetTitulo().c_str()));
		}
		Layout();
	}

	~DialogoSincronizacion(){

	}

	void OnAceptarClick(wxCommandEvent &event){
		EndModal(wxID_OK);
	}

	TipoListaVistas GetVistasSeleccionadas(){
		TipoListaVistas resultado;
		wxArrayInt selecciones;
		for(unsigned int i=0; i<m_pCheckListVistas->GetCount();i++){
			//se busca la vista
			for(TipoListaVistas::iterator itVistas = m_lista.begin(); itVistas!= m_lista.end(); ++itVistas){
				if(m_pCheckListVistas->IsChecked(i)){
					resultado.push_back(m_lista[i]);
					break;
				}
			}
		}
		return resultado;
	}

protected:
	TipoListaVistas m_lista;
};

//---------- end DIALOGO SINCRONIZACION...-------------

void GVistaCompleja::OnSincronizarClick(wxCommandEvent &event)
{
	bool enabled = m_pBarraDerecha->GetToolToggled(ID_BOTON_SINCRONIZAR);
	Sincronizar(enabled);
}

void GVistaCompleja::Sincronizar(bool sincronizar)
{
	//si esta toogled...
	if(!sincronizar) {
		//dessincronizar
		//si esta reproduciendose se para
		Stop();
		//
		DesSincronizar();
	} else {
		//sincronizar
		typedef GNC::GCS::IControladorVistas::TipoListaVistas TipoListaIVistas;

		TipoListaVista2D lista;
		{
			TipoListaIVistas listaTmp = IVista->GetEstudio()->Entorno->GetControladorVistas()->GetVistas();

			//pillamos las vistas simples
			for(TipoListaIVistas::iterator it = listaTmp.begin(); it!= listaTmp.end(); it++){
				GNKVisualizator::Vista2D* v = dynamic_cast<GNKVisualizator::Vista2D*> ((*it));
				if(v!=NULL && v!=IVista && v->GVista->EsSincronizable()){
					lista.push_back(v);
				}
			}
		}

		DialogoSincronizacion* dialogoSincronizacion = new DialogoSincronizacion(this, lista);
		int answer = dialogoSincronizacion->ShowModal();
		if (answer == wxID_OK) {
			//se pillan las vistas seleccionadas
			lista = dialogoSincronizacion->GetVistasSeleccionadas();
			if(lista.size()>0){
				//nos metemos en la lista
				lista.push_back(IVista);
				//y ahora sincronizamos a tol mundo
				for(DialogoSincronizacion::TipoListaVistas::iterator it = lista.begin(); it!= lista.end(); it++){
					(*it)->GVista->Sincronizar(lista);
				}
				m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,true);
				m_pBarraDerecha->Refresh();
			} else {
				m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,false);
				m_pBarraDerecha->Refresh();
			}
		}
	}
}

void GVistaCompleja::Sincronizar(const TipoListaVista2D& lista)
{
	//si esta reproduciendose se para
	Stop();
	//se suscribe a los eventos de los brothers
	for(TipoListaVista2D::const_iterator it = lista.begin(); it!= lista.end(); it++){
		if((*it) != IVista){
			AtencionPrimaria::Eventos::EventoSincronizacion evento((*it));
			IVista->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this,evento);
			m_ListaSincronizacion.push_back((*it));
		}
	}
	m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,true);
	m_pBarraDerecha->Refresh();
}

bool GVistaCompleja::EsSincronizable(){
	return (m_ListaSincronizacion.size() == 0) && m_pSliderSlice->IsShown();
}

void GVistaCompleja::DesSincronizar(){
	for(TipoListaVista2D::iterator it = m_ListaSincronizacion.begin(); it!= m_ListaSincronizacion.end(); it++){
		AtencionPrimaria::Eventos::EventoSincronizacion eventoOtro((*it));
		IVista->GetEstudio()->Entorno->GetControladorEventos()->DesRegistrar(this,eventoOtro);
	}
	m_ListaSincronizacion.clear();

	m_pBarraCine->Enable(true);
	m_pBarraCine->Refresh();

	//dessincronizamos
	AtencionPrimaria::Eventos::EventoSincronizacion* evento = new AtencionPrimaria::Eventos::EventoSincronizacion(IVista,AtencionPrimaria::Eventos::EventoSincronizacion::Dessincronizar);
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(evento);

	m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,false);
	m_pBarraDerecha->Refresh();
}

void GVistaCompleja::GoToSlice(int pos, bool relativa, bool propagar, bool render){
	if (m_MaxSlice == m_MinSlice) {
		return;
	}
	int posicion;

	if(relativa){
		posicion = m_pSliderSlice->GetValue() + pos;
	}else{
		posicion = pos;
	}

	posicion = std::max(m_pSliderSlice->GetMin(), std::min(m_pSliderSlice->GetMax(), posicion));

	//si la posicion + las que se muestran en el layout actual es mayor al número de slices de la serie, no se avanza

	if(posicion + ( (int) m_VistasSimples.size() ) > IVista->GetEstudio()->GetNumeroCortes()) {
		return;
	}

	m_pSliderSlice->SetValue(posicion);
	m_posicion = posicion;

	//se reestablece el window/level antes del evento de modificación porque ese evento lo escucha la herramienta
	GNC::GCS::IContractWindowLevel::Setup(*IVista->GetEstudio()->GetTagsImagen(m_posicion));

	//se le indica al manager el vid
	IVista->GetEstudio()->IndiceFicheroActivo = posicion;
	for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->GoToSlice(posicion,false,false);

		//despues se establece el WL
		if (HasCurrentWindowLevel()) {
			GNC::GCS::IContractWindowLevel::WindowLevel wl = GetCurrentWindowLevel();
			(*it)->ViewImage2D->SetDefaultWindowLevel(wl.m_window, wl.m_level);
		} else if (HasDefaultWindowLevel()) {
			GNC::GCS::IContractWindowLevel::WindowLevel wl = GetAndSetDefaultWindowLevel();
			(*it)->ViewImage2D->SetDefaultWindowLevel(wl.m_window, wl.m_level);			
		} else {
			(*it)->ViewImage2D->SetAutoDefaultWindowLevel();
		}

		if(IVista->VisualizatorStudy->TieneOverlaysImagen(posicion)) {
			GNKVisualizator::TListaOverlays* pLista = IVista->VisualizatorStudy->GetOverlaysImagen(posicion);
			(*it)->SetOverlays(pLista,m_EstadoOverlays);
		} else {
			(*it)->SetOverlays(NULL, m_EstadoOverlays);
		}
		posicion++;
	}
		
	
	GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(IVista,GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado, -1, render);
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(pEvt);

	if(propagar){
		IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new AtencionPrimaria::Eventos::EventoSincronizacion(IVista, AtencionPrimaria::Eventos::EventoSincronizacion::Scroll,pos,relativa));
	}
}

int GVistaCompleja::GetCurrentSlice()
{
	return m_posicion;
}

void GVistaCompleja::PreProcesarEvento(GNC::GCS::Eventos::IEvento* evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista)
{
	if (evt == NULL) {
		std::cerr << "Error: Evento nulo" << std::endl;
		return;
	}
	switch (evt->GetCodigoEvento()) {
		case ginkgoEVT_GNKVisualizator_EventoSincronizacion:
			{
				AtencionPrimaria::Eventos::EventoSincronizacion* pEvt = dynamic_cast<AtencionPrimaria::Eventos::EventoSincronizacion*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de sincronización: Evento = " << evt << std::endl;
					return;
				}
				if (pEvt->GetTipoEvento() != AtencionPrimaria::Eventos::EventoSincronizacion::Scroll) {
					return;
				}
				int posicion = pEvt->GetPosicion();
				if(pEvt->EsRelativa()){
					posicion += m_pSliderSlice->GetValue();
				}
				posicion = std::max(m_pSliderSlice->GetMin(), std::min(m_pSliderSlice->GetMax(), posicion));
			}
			break;
		case ginkgoEVT_Core_ModificacionImagen:
			{
				GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de modificación de imagen: Evento = " << evt << std::endl;
					return;
				}
				switch (pEvt->GetTipo()) {
					case GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada:
						{
							lista.push_back(new GNC::GCS::Eventos::EventoModificacionImagen(IVista,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada, -1));
							lista.push_back(new GNC::GCS::Eventos::EventoModificacionFichero(IVista,GNC::GCS::Eventos::EventoModificacionFichero::FicheroModificado));
						}
						break;
					default:
						break;
				}
				if (pEvt->GetApilarRender()) {
					lista.push_back(new GNC::GCS::Eventos::EventoRender(IVista,pEvt->GetSliceAfectado()));
				}
			}
			break;
		case ginkgoEVT_Core_ModificacionWidget:
			{
				GNC::GCS::Eventos::EventoModificacionWidget* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionWidget*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de modificación de widget: Evento = " << evt << std::endl;
					return;
				}
				// TODO: Este flujo es muy mejorable
				lista.push_back(new GNC::GCS::Eventos::EventoModificacionFichero(IVista,GNC::GCS::Eventos::EventoModificacionFichero::FicheroModificado,IVista));
			}
			break;
		case ginkgoEVT_GNKVisualizator_EventoMostrarOverlay:
			{
				lista.push_back(new GNC::GCS::Eventos::EventoRender(IVista));
			}
			break;
		default:
			break;
	}
}

void GVistaCompleja::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	switch (evt->GetCodigoEvento()) {
		case ginkgoEVT_GNKVisualizator_EventoSincronizacion:
			{
				AtencionPrimaria::Eventos::EventoSincronizacion* pEvt = dynamic_cast<AtencionPrimaria::Eventos::EventoSincronizacion*>(evt);
				if(pEvt!=NULL){
					if(pEvt->GetTipoEvento() == AtencionPrimaria::Eventos::EventoSincronizacion::Scroll){
						GoToSlice(pEvt->GetPosicion(),pEvt->EsRelativa(),false);
					} else if (pEvt->GetTipoEvento() == AtencionPrimaria::Eventos::EventoSincronizacion::Play) {
						m_pBarraCine->Enable(false);
						m_pBarraCine->Refresh();
					} else if (pEvt->GetTipoEvento() == AtencionPrimaria::Eventos::EventoSincronizacion::Stop) {
						m_pBarraCine->Enable(true);
						m_pBarraCine->Refresh();
					} else if (pEvt->GetTipoEvento() == AtencionPrimaria::Eventos::EventoSincronizacion::Dessincronizar) {
						for(TipoListaVista2D::iterator it = m_ListaSincronizacion.begin(); it!= m_ListaSincronizacion.end(); it++){
							if((*it) == pEvt->GetVista()){
								IVista->GetEstudio()->Entorno->GetControladorEventos()->DesRegistrar(this,*pEvt);
								m_ListaSincronizacion.erase(it);
								if(m_ListaSincronizacion.size() == 0){
									m_pBarraDerecha->ToggleTool(ID_BOTON_SINCRONIZAR,false);
									m_pBarraDerecha->Refresh();
								}
								return;
							}
						}
					}
				}
			}
			break;

			case ginkgoEVT_Core_ModificacionImagen:
			{
				GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de modificación de imagen: Evento = " << evt << std::endl;
					return;
				}
				switch (pEvt->GetTipo()) {
					case GNC::GCS::Eventos::EventoModificacionImagen::ImagenModificada:
					case GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada:
					case GNC::GCS::Eventos::EventoModificacionImagen::MapaModificado:
					case GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado:
							{
								for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
									(*it)->ViewImage2D->Modified();
								}
								IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(IVista,GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas));
							}
							break;
					case GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada:
						{
							
								int i = 0;
								for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++, i++) {
									m_VistasSimples[i]->GetEstudio()->RecalibrarImagenActiva(pEvt->GetNewSpacing(), pEvt->GetNewOrigin());

									//esto es necesario para establecer bien las coordenadas cuando se cambia el origen
									(*it)->GoToSlice(m_posicion + i,false,false);
									pEvt->SetSlice(-1);
									(*it)->RefrescarOverlays(m_EstadoOverlays);
								}
								//se vuelve hacer setup del contrato mapa de color
							//	GNKVisualizator::IContratoMapaColor::Setup(m_pImagenOriginal);
								
							
						}
					break;
					case GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada:
						//para que pille bien el window/level
						for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
							if (pEvt->AutoCalculeWindowLevel()) {
								(*it)->ViewImage2D->SetAutoDefaultWindowLevel();
								(*it)->ViewImage2D->ResetToDefaultWindowLevel();
								SetUserDefinedWindowLevel((*it)->ViewImage2D->GetWindow(), (*it)->ViewImage2D->GetLevel());
							} else {
								if(pEvt->ResetWindowLevel()) {
									if (HasDefaultWindowLevel()) {
										GNC::GCS::IContractWindowLevel::WindowLevel wl = GetAndSetDefaultWindowLevel();
										(*it)->ViewImage2D->SetDefaultWindowLevel(wl.m_window, wl.m_level);			
									} else {
										(*it)->ViewImage2D->SetAutoDefaultWindowLevel();
									}

									(*it)->ViewImage2D->ResetToDefaultWindowLevel();
								} else {
									(*it)->ViewImage2D->SetWindow(pEvt->GetWindow());
									(*it)->ViewImage2D->SetLevel(pEvt->GetLevel());
									//(*it)->ViewImage2D->UpdateImage();
									for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
																							  //(*it)->ViewInteractor2D->Refresh(false);
																							  //(*it)->ViewInteractor2D->Render();
									}
								}
							}
							if(pEvt->ResetCurrentPoint())
							{
								/*
								double* bounds  = (*it)->ViewImage2D->GetInput()->GetBounds();
								const double* currentPoint = (*it)->ViewImage2D->GetCurrentPoint();
								double  pos[3] =
								{
									(bounds[0]+bounds[1])/2.0,
									(bounds[2]+bounds[3])/2.0,
									currentPoint[2]
								};

								(*it)->ViewImage2D->SetCurrentPoint(pos);
								*/
							}
							if(pEvt->ResetZoom())
							{
								(*it)->ViewImage2D->ResetZoom();
							}
							//(*it)->ViewImage2D->Modified();
						}
						IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(IVista,GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas));
					break;
					case GNC::GCS::Eventos::EventoModificacionImagen::ImagenDescargada:
					break;
					case GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas:

					break;
				}
			}//fin modificacion
			break;

		case ginkgoEVT_Core_Render:
			{
				for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
					(*it)->ViewInteractor2D->Refresh(false);
				}
			}
			break;
		case ginkgoEVT_Core_ModificacionFichero:
			{
				GNC::GCS::Eventos::EventoModificacionFichero* pEvt = new GNC::GCS::Eventos::EventoModificacionFichero();
				pEvt->SetVista(IVista);
				IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(pEvt);
			}
			break;
		case ginkgoEVT_GNKVisualizator_EventoMostrarOverlay:
			{
				for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
					(*it)->RefrescarOverlays(m_EstadoOverlays);
					(*it)->ViewImage2D->Modified();
				}
			}
			break;
	}
}

void GVistaCompleja::SetMapaColor(vtkLookupTable* pTabla, int idLookupTable)
{
	Freeze();
	for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); it != m_VistasSimples.end(); it++) {
		(*it)->ViewImage2D->SetLookupTable(pTabla, idLookupTable);
	}
	IVista->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(IVista));
	Thaw();
}


void GVistaCompleja::SetLayoutVentana(int filas, int columnas)
{
	if(filas <1 || columnas < 1)
	{
		//layout invalido
		return;
	}
	bool incrementado = false;

	const int maxSlices = m_MaxSlice - m_MinSlice +1;
	if(filas*columnas > maxSlices) {
		//layout invalido aunque podría ser valido...
		filas = (int)std::ceil((double)maxSlices/columnas);
	}
	Freeze();

	int filasActuales = m_pSizerSeries->GetRows();
	int columnasActuales = m_pSizerSeries->GetCols();
	int tamAnterior = m_VistasSimples.size();
	int nuevoTam = filas*columnas;

	m_pSizerSeries->SetCols(columnas);
	m_pSizerSeries->SetRows(filas);


	//FUNDAMENTAL PARA QUE los viewers se destruyan correctamente y sin leaks ya que Viewer es smart pointer
	IVista->VisualizatorStudy->Viewer = NULL;
	if(tamAnterior > nuevoTam) {
		//hay que borrar
		for(int i = 0; i< tamAnterior-nuevoTam; i++) {
			TListaGVistasSimples::iterator pVista = m_VistasSimples.begin();
			m_pManager->LiberarRecursos((*pVista)->ViewInteractor2D);
			m_pSizerSeries->Detach((*pVista));
			(*pVista)->Destroy();

			m_VistasSimples.erase(pVista);
		}
	} else {
		int interpolationMode = VTK_NEAREST_INTERPOLATION;
		for (unsigned int i = 0; i < m_VistasSimples.size(); ++i) {
			if (i == 0) {				
				interpolationMode = m_VistasSimples[i]->ViewImage2D->GetInterpolationMode();
			}
			m_VistasSimples[i]->ViewImage2D->ResetZoom();
		}

		//hay que crear
		for(unsigned int i = 0; i< (unsigned int) (nuevoTam - tamAnterior) && m_VistasSimples.size() < (unsigned int) maxSlices; i++) {
			incrementado = true;
			AddVistaSimple();
		}
		for (unsigned int i = 1; i < m_VistasSimples.size(); ++i) {
			m_VistasSimples[i]->ViewImage2D->SetInterpolationMode(interpolationMode);
		}
		//por si la posicion actual es invalida
		m_posicion = 0;
	}
	//FUNDAMENTAL PARA QUE FUNCIONE LA HERRAMIENTA DE MAPAS DE COLOR
	IVista->VisualizatorStudy->Viewer = m_VistasSimples[0]->ViewImage2D;
	ActualizarMaxMinSlider();
	Layout();
	//nos quedamos en la posicion
	GoToSlice(m_posicion,false,false,false);
	Thaw();
	if ( (filas > 1 || columnas > 1) && incrementado) { // condición para evitar doble render. Ya se comprueba por otro lado en la creación (con 1 vista).
		bool noerror = true;
		for(TListaGVistasSimples::iterator it = m_VistasSimples.begin(); noerror && it != m_VistasSimples.end(); it++) {
			GVistaSimple* vs = *it;
			vs->ViewInteractor2D->Render();
			long idTextura = vs->ViewImage2D->GetImageTexture();
			if (idTextura == 0 || !glIsTexture(idTextura)) {
				noerror = false;
			}
		}
		if (!noerror) {
			SetLayoutVentana(filasActuales, columnasActuales);
			wxMessageBox(_("It has exhausted the system's video memory and has not been able to assign the grid configuration. Close some studies to free memory."), _("Error configuring the grid"), wxOK, NULL);
			return;
		}
	}
	m_pEntorno->GetControladorHerramientas()->RefrescarHerramientas();
}

int GVistaCompleja::GetFilas()
{
	return m_pSizerSeries->GetRows();
}

int GVistaCompleja::GetColumnas()
{
	return m_pSizerSeries->GetCols();
}

vtkScalarsToColors* GVistaCompleja::GetLookupTable()
{
	if(m_VistasSimples.size()>0) {
		return m_VistasSimples[0]->ViewImage2D->GetLookupTable();
	} else {
		return NULL;
	}
}

void GVistaCompleja::GetImage(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, int index, bool conWidgets, const GNC::GCS::Vector& size)
{
	if (!IVista->VisualizatorStudy->Viewer->IsInstalledAndInitialized())
		return ;

	GNKVisualizator::ImprimeVistaSimple imprimeVistaSimple(GNC::GCS::IContratoWidgets::m_pManager, IVista->VisualizatorStudy, index);

	if(IVista->VisualizatorStudy->Viewer->GetNumberOfComponents() == 3) {
		imprimeVistaSimple.PrintImageRGB(img,conWidgets, size);
	} else {
		vtkScalarsToColors* pTabla = GetLookupTable();
		if(pTabla != NULL) {
			imprimeVistaSimple.PrintImage(img, conWidgets, pTabla, size);
		}
	}
}

void GVistaCompleja::SetReconstructionMode(GNKVisualizator::Reconstruction::ReconstructionMode mode)
{

	switch (mode) {
		case GNKVisualizator::Reconstruction::RM_SurfaceRendering:
			{
				typedef MedicalViewer::Reconstruction::GUI::wxSurfaceRendering TReconstructionWin;
				TReconstructionWin* win = new TReconstructionWin(this, GNKVisualizator::IReconstructionContract::Estudio);
				win->Show(true);				
			}
			break;
		case GNKVisualizator::Reconstruction::RM_VolumeRendering:
			{
				typedef MedicalViewer::Reconstruction::GUI::wxVolumeRendering TReconstructionWin;
				TReconstructionWin* win = new TReconstructionWin(this, GNKVisualizator::IReconstructionContract::Estudio, GetViewerActivo()->GetWindow(), GetViewerActivo()->GetLevel());
				win->Show(true);
			}
			break;
		case GNKVisualizator::Reconstruction::RM_OrthogonalMPR:
		case GNKVisualizator::Reconstruction::RM_MIP3D:
		case GNKVisualizator::Reconstruction::RM_3D_Endoscopy:
		case GNKVisualizator::Reconstruction::RM_MaxMode:
			wxMessageBox(_("Reconstruction mode not implemented:\n"), _("Error"), wxICON_ERROR);
			break;
		default:
			wxMessageBox(_("Reconstruction mode not supported:\n"), _("Error"), wxICON_ERROR);
			break;
			
	}	
}
