/*
 *  
 *  $Id: wecg.h 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwidgets.h>
#include <api/observers/iwidgetsobserver.h>
#include <api/icontroladoreventos.h>
#include <visualizator/estudios/ecgstudy.h>
#include <vector>
#include <list>
#include <set>

namespace GNC {
	namespace GCS {
		class IContextoEstudio;
		class TexturaCairo;
	}
}

namespace GNKVisualizator {

	namespace Widgets {

		class WECG;
		class Data;

		class WECGBuilder : public GNC::GCS::Widgets::IWidgetBuilder, public GNC::GCS::Widgets::IObservadorWidget {
		public:

			WECGBuilder(GNC::GCS::IWidgetsManager* pManager, const GNC::GCS::TriggerButton& buttonMask, long gid);

			~WECGBuilder();

			virtual void OnWidgetDestruido(GNC::GCS::Widgets::IWidget*);

			virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

			virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

			virtual void Render(GNC::GCS::Contexto3D* c);

			void AutoCallibrateImage();

		protected:
			GNC::GCS::Vector          m_PosicionCursor;
			WECG*                     m_pRejillaActiva;				

		};

		//----------------------------------------------------------------------------

		typedef struct TexturasCanalECG
		{
			GNC::GCS::TexturaCairo* tl;
			GNC::GCS::TexturaCairo* tu;

			TexturasCanalECG();
			~TexturasCanalECG();

			void Destruir();

		} TexturasCanalECG;

		class RecursosECG {
		public:
			typedef std::vector<TexturasCanalECG*> TListaTexturas;
				
			TListaTexturas Texturas;

			RecursosECG()
			{						
			}

			~RecursosECG()
			{
				if (Texturas.size() > 0) {
					//Fail
					std::cout << std::endl;
				}
			}

			void Alloc(unsigned int csize)
			{
				if (csize == Texturas.size()) {
					return;
				}
				Dealloc();
				Texturas = TListaTexturas(csize);
				for (unsigned int i = 0; i < csize; i++) {
					Texturas[i] = new TexturasCanalECG();
				}
			}

			void Dealloc()
			{
				for (unsigned int i = 0; i < Texturas.size(); i++)
				{
					Texturas[i]->Destruir();
					delete Texturas[i];
				}
				Texturas.clear();
			}
		};

		class WECG : public GNC::GCS::Widgets::IWidget {

		protected:
			
		typedef std::map<void*, RecursosECG*> TMapaRecursos;

		public:

		//region "Constructor y destructor"

		public:

			WECG(GNC::GCS::IWidgetsManager* pManager, long vid, const char* nombre = "WECG");

			~WECG();

		//endregion

		//region "Interfaz generica"

			virtual bool SoportaAutoBorrado() const {
				return false;
			}

			virtual void AutoCallibrate();

			virtual void Reload(const GNKVisualizator::ECGStudy::TListChannelInfo& listInfoChannels);

			virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

			virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

			virtual bool HitTest(float x, float y, float umbralCuadrado);

			virtual bool HitTest(GNC::GCS::Vector* vertices, int numVertices);

			virtual void Render(GNC::GCS::Contexto3D* c);

			virtual void Seleccionar(bool seleccionado);

			virtual void Iluminar(bool iluminado);

			virtual void Ocultar(bool oculto);

			virtual void LiberarRecursos(GNC::GCS::IWidgetsRenderer* pKey);

		//endregion

		//region "Estado interno"

		private:


		//region "Propiedades geometricas"
		private:
			Data* CData;
			TMapaRecursos m_mapaRecursos;

		public:

		//endregion

		//endregion

		};
	}
}

