/*
 *  
 *  $Id: iherramientaoverlays.h 3698 2011-04-14 12:38:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iherramienta.h>
#include "icontratosaprimaria.h"
#include "iherramientasaprimaria.h"
#include <export/iherramientascore.h>

namespace GNKVisualizator {
	class IHerramientaOverlays: public GNC::GCS::IHerramienta, public GNC::GCS::IContratable<GNKVisualizator::IContratoOverlays> {
	public:
		typedef GNKVisualizator::IContratoOverlays     TContratoWidgets;
		typedef GNC::GCS::IContratable<TContratoWidgets> TContratableWidgets;

		static const IHerramienta::UID ID = HGNKVisualizator_Overlays;
		IHerramientaOverlays() : IHerramienta(HGNKVisualizator_Overlays,TMenuImagen, "Overlays",SubFamiliaImagenHerramientasRadio) {}
		virtual ~IHerramientaOverlays() {}

		virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

		virtual void ConectarContratos(bool) = 0;

		virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
			return GNC::GCS::IContratable<TContratoWidgets>::ValidaContrato(pVista);
		}

	};
}
