/*
 *  
 *  $Id: iconoimagenctrl.cpp 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include "iconoimagenctrl.h"

#include <wx/gdicmn.h>
#include <wx/panel.h>
#include <wx/font.h>
#include <wx/colour.h>
#include <wx/settings.h>
#include <wx/string.h>

#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/dcscreen.h>
#include <wx/brush.h>
#include <wx/dc.h>
#include <wx/image.h>

#include <sstream>

#define DIMENSION_NORMAL 32
#define DIMENSION_AJUSTADO 24
#define DIMENSION_IMAGEN 16

IconoImagenCtrl::IconoImagenCtrl(wxWindow* pPadre, const wxImage& icono, const wxString toolTip,bool hasMenu,bool ajustado) : wxPanel(pPadre)
{
	Inicializar(icono,toolTip,hasMenu,ajustado);
};

IconoImagenCtrl::IconoImagenCtrl(wxWindow* pPadre, const wxBitmap& icono, const wxString toolTip, bool hasMenu,bool ajustado) : wxPanel(pPadre)
{
	Inicializar(icono.ConvertToImage(),toolTip,hasMenu,ajustado);
}

void IconoImagenCtrl::Inicializar(const wxImage& icono, const wxString toolTip, bool hasMenu,bool ajustado)
{
	m_texto = wxEmptyString;
	m_enabled = true;
	m_check = false;
	m_hasMenu = hasMenu;
	m_dimension=DIMENSION_NORMAL;
	if(ajustado)
		m_dimension = DIMENSION_AJUSTADO;

	m_ColorFondo = GetParent()->GetBackgroundColour();
	m_ColorLineaSeleccion = wxColour(255, 255, 255, 255);
	m_ColorLineaNormal = wxColour(128, 128, 128, 255);
	m_ColorFondoSeleccionado = wxColour(128, 128, 128, 255);
	this->SetToolTip(toolTip);
	
	this->SetSize(m_dimension,m_dimension);
	this->SetMinSize(wxSize(m_dimension,m_dimension));

	SetIcono(icono);	

	m_MouseDown = false;
	m_MouseDownMenu = false;
	m_activado = true;

	// Connect Events
	this->Connect( wxEVT_LEFT_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_LEFT_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_MOTION, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_MIDDLE_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_RIGHT_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_LEAVE_WINDOW, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_ENTER_WINDOW, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Connect( wxEVT_PAINT, wxPaintEventHandler( IconoImagenCtrl::OnPaint ) );
}

IconoImagenCtrl::~IconoImagenCtrl(){
	// Connect Events
	this->Disconnect( wxEVT_LEFT_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEFT_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_DOWN, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_UP, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_MOTION, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEFT_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_MIDDLE_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_RIGHT_DCLICK, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_LEAVE_WINDOW, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_ENTER_WINDOW, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_MOUSEWHEEL, wxMouseEventHandler( IconoImagenCtrl::OnMouseEvents ) );
	this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( IconoImagenCtrl::OnPaint ) );
}

void IconoImagenCtrl::SetIcono(const wxImage &icono)
{
	
	if (icono.Ok())
	{
		double scaleX = ((double) DIMENSION_IMAGEN)/((double) icono.GetWidth());
		double scaleY = ((double) DIMENSION_IMAGEN)/((double) icono.GetHeight());

		if (scaleX != 1.0 || scaleY != 1.0)
		{
			double scale = wxMin(scaleX, scaleY);
			int newWidth = (int) (scale * icono.GetWidth());
			int newHeight = (int) (scale * icono.GetHeight());
			wxImage iconoReescalado = icono.Scale(newWidth, newHeight,wxIMAGE_QUALITY_HIGH);
			m_bitmap = wxBitmap(iconoReescalado);
			iconoReescalado = icono.ConvertToGreyscale();
			m_disabled_bitmap = wxBitmap(iconoReescalado);

		} else {
			m_bitmap = wxBitmap(icono);
			wxImage iconoGris = icono.ConvertToGreyscale();
			m_disabled_bitmap = wxBitmap(iconoGris);
		}
		Update();
	}
}

void IconoImagenCtrl::SetCheck(bool check)
{
	if(check!=m_check) {
		m_check = check;
		Update();
	}
}

bool IconoImagenCtrl::IsChecked()
{
	return m_check;
}

void IconoImagenCtrl::SetNumero(int numero)
{
	if(numero<100 && numero>=0){
		std::ostringstream ostr;
		ostr << numero;
		m_texto = wxString::FromUTF8(ostr.str().c_str());
	} else {
		m_texto =wxEmptyString;
	}
}

//esto sirve para que se comporte como el disabled pero sigue pillando eventos
void IconoImagenCtrl::SetIcoActivado(bool activar)
{
	if(m_activado!=activar) {
		m_activado = activar;
		wxRect rect = GetRect();
		this->GetParent()->Refresh(false,&rect);
	}
}

bool IconoImagenCtrl::EstaActivado()
{
	return m_activado;
}

bool IconoImagenCtrl::Enable(bool enable)
{
	bool vuelta = wxPanel::Enable(enable);
	wxRect rect = GetRect();
	this->GetParent()->Refresh(false,&rect);
	return vuelta;
}

// Dibuja manualmente el fondo seleccionado
void IconoImagenCtrl::OnPaint(wxPaintEvent& evt)
{
	wxPaintDC dc(this);
	const int coordImagen = (m_dimension - DIMENSION_IMAGEN) / 2;
	if (m_MouseDown && m_isEnabled && m_enabled) {
		dc.SetBrush(wxBrush(m_ColorFondo,wxTRANSPARENT));
		dc.SetPen(wxPen(m_ColorFondoSeleccionado, 1, wxSOLID));
		dc.DrawBitmap(m_bitmap,coordImagen,coordImagen);
	} else if (!m_isEnabled || !m_activado) {
		dc.DrawBitmap(m_disabled_bitmap,coordImagen,coordImagen);
	} else {
		dc.DrawBitmap(m_bitmap,coordImagen,coordImagen);
	}

	if(m_texto!=wxEmptyString) 
	{
		wxColour colorTexto;
		colorTexto.Set(255,255,255);
		wxColour colorFondo;
		colorFondo.Set(209,215,255);
		wxColour colorLinea;
		colorLinea.Set(209,209,209);
		
		dc.SetPen(wxPen(colorLinea, 1, wxSOLID));	

		// Circulo interior
		dc.SetBrush(wxBrush(colorFondo,wxSOLID));
		dc.DrawCircle(dc.GetSize().x-12, 8, 7);		

		if(m_texto.size()==1) {
			dc.SetFont(wxFont(8,wxFONTFAMILY_DEFAULT,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_LIGHT));
			dc.SetPen(wxPen(colorTexto, 1, wxSOLID));
			dc.DrawText(m_texto,dc.GetSize().x - 15,1);
		} else {
			dc.SetFont(wxFont(7,wxFONTFAMILY_DEFAULT,wxFONTSTYLE_NORMAL,wxFONTWEIGHT_LIGHT));			
			dc.SetPen(wxPen(colorTexto, 1, wxSOLID));
			dc.DrawText(m_texto,dc.GetSize().x - 17,2);
		}
	}
	
	//no se permite menu para las ajustadas
	if(!m_hasMenu || m_dimension == DIMENSION_AJUSTADO) {
		if (m_check || m_MouseDown || m_MouseDownMenu) {
			dc.SetBrush(wxBrush(m_ColorFondo,wxTRANSPARENT));
			dc.SetPen(wxPen(m_ColorLineaSeleccion, 1, wxSOLID));
		} else {
			dc.SetBrush(wxBrush(m_ColorFondo,wxTRANSPARENT));
			dc.SetPen(wxPen(m_ColorLineaNormal, 1, wxSOLID));
		}
		dc.DrawRoundedRectangle(wxRect(wxPoint(2, 2), wxPoint(dc.GetSize().x - 3, dc.GetSize().y - 3)), 5);
	} else {		
		dc.SetBrush(wxBrush(m_ColorFondo,wxTRANSPARENT));

		if(m_check) {
			dc.SetPen(wxPen(m_ColorLineaSeleccion, 1, wxSOLID));
			dc.DrawRoundedRectangle(wxRect(wxPoint(2, 2), wxPoint(dc.GetSize().x - 3, dc.GetSize().y - 3)), 5);

		} else if (m_MouseDown) {
			dc.SetPen(wxPen(m_ColorLineaSeleccion, 1, wxSOLID));
			dc.DrawRoundedRectangle(wxRect(wxPoint(2, 2), wxPoint(dc.GetSize().x - 3, dc.GetSize().y - 3)), 5);
			dc.SetPen(wxPen(m_ColorLineaNormal, 1, wxSOLID));			

		} else if (m_MouseDownMenu) {
			dc.SetPen(wxPen(m_ColorLineaNormal, 1, wxSOLID));
			dc.DrawRoundedRectangle(wxRect(wxPoint(2, 2), wxPoint(dc.GetSize().x - 3, dc.GetSize().y - 3)), 5);
			dc.SetPen(wxPen(m_ColorLineaSeleccion, 1, wxSOLID));			

		} else {
			dc.SetPen(wxPen(m_ColorLineaNormal, 1, wxSOLID));			
			dc.DrawRoundedRectangle(wxRect(wxPoint(2, 2), wxPoint(dc.GetSize().x - 3, dc.GetSize().y - 3)), 5);
		}




		dc.DrawLine(wxPoint(20, 20),wxPoint(20, dc.GetSize().y - 1));
		dc.DrawLine(wxPoint(20, 20),wxPoint(dc.GetSize().x - 1, 20));

		dc.SetBrush(wxBrush(wxColour(0, 0, 0), wxSOLID));
		wxPoint lista[3];
		lista[0] = wxPoint(22, 23);
		lista[1] = wxPoint(26, 30);
		lista[2] = wxPoint(29, 23);

		dc.DrawPolygon(3, lista);

		
	}

	evt.Skip(false);
};

// Manejador de eventos de ratón
void IconoImagenCtrl::OnMouseEvents(wxMouseEvent& evt) {
	if (evt.LeftDown()) {
		if(m_hasMenu) {
			if(evt.GetPosition().x >20 && evt.GetPosition().y >20) {
				m_MouseDownMenu = true;
			} else {
				m_MouseDown = true;
			}
		} else {
			m_MouseDown = true;
		}
		Refresh();
	}
	else if (evt.LeftUp()) {
		wxCommandEvent e;
		if(m_MouseDown || m_MouseDownMenu) {
			if(m_hasMenu) {
				//menu o normal....
				if(m_MouseDown) {
					m_MouseDown = false;
					e.SetEventType(wxEVT_COMMAND_BUTTON_CLICKED);   
				} else if(m_MouseDownMenu){
					m_MouseDownMenu = false;
					e.SetEventType(wxEVT_CONTEXT_MENU);   
				}						  		
			} else {
				e.SetEventType(wxEVT_COMMAND_BUTTON_CLICKED);   
				m_MouseDown = false;
			}
			Refresh();
			this->ProcessEvent(e);		
		}
	}
	else  if (evt.Leaving() && (m_MouseDown || m_MouseDownMenu)) {
		m_MouseDown = false;
		m_MouseDownMenu = false;
		Refresh();
	}
};
