/*
 *  
 *  $Id: selectfilesdicomdir.cpp 4406 2011-11-16 09:53:14Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/dirdlg.h>
#include <wx/msgout.h>
#include <wx/datetime.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/regex.h>
#include <wx/radiobox.h>
#include <wx/filename.h>
#include <main/controllers/configurationcontroller.h>

#include <string>
//#define _GINKGO_TRACE
#include <api/globals.h>

#include "selectfilesdicomdir.h"
#include <api/icontextoestudio.h>

#include <main/entorno.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <iostream>

#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorcomandos.h>
#include <api/icontextoestudio.h>
#include <main/controllers/dcmtk/dicomservers.h>
#include <main/gui/dicombrowsercomponent.h>
#include <commands/exporttodicomdircommand.h>

namespace GNC {
	namespace GUI {

		SelectFilesDicomDir::SelectFilesDicomDir(wxWindow* pParent, const TListUIDs& uids,IWizard* pWizard):SelectFilesDicomDirBase(pParent),IPasoWizard(pWizard)
		{
			//first create IModeloDICOM of files stored in the repository
			{
				GNC::GCS::IControladorHistorial::ListaModelosSeries seriesList;
				GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerie(seriesList, uids);
				IModeloDicom model;
				for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
				{
					std::string sex(&(*it).m_sexo,1);
					model.InsertarPaciente((*it).m_idPaciente, (*it).m_nombrePaciente, (*it).m_fechaNacimiento, sex);
					model.InsertarEstudio((*it).m_idPaciente, (*it).m_uidEstudio, "", (*it).m_descripcionEstudio, (*it).m_modalidad, (*it).m_fechaEstudio, (*it).m_horaEstudio, "");
					std::ostringstream numSlices;
					numSlices << (*it).m_numeroSlices;
						model.InsertarSerie((*it).m_uidEstudio, (*it).m_uidSerie, (*it).m_modalidad, (*it).m_fechaSerie, (*it).m_horaSerie, (*it).m_descripcionSerie, numSlices.str(), "");
				}
				m_pFileSelection->SetModel(model);
			}

			//get diagnostic models
			{
				GNC::GCS::IControladorHistorial::ListaModelosSeries seriesList;
				GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerieDiagnostico(seriesList, uids);
				IModeloDicom model;
				for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
				{
					std::string sex(&(*it).m_sexo,1);
					model.InsertarPaciente((*it).m_idPaciente, (*it).m_nombrePaciente, (*it).m_fechaNacimiento, sex);
					model.InsertarEstudio((*it).m_idPaciente, (*it).m_uidEstudio, "", (*it).m_descripcionEstudio, (*it).m_modalidad, (*it).m_fechaEstudio, (*it).m_horaEstudio, "");
				}
				m_pFileSelection->SetDiagnosticModel(model);
			}

			//if uids.size > 0 all to right
			if (uids.size() > 0) {
				wxCommandEvent e;
				m_pFileSelection->OnDicomDirIzqAddAll(e);
			}
		}

		SelectFilesDicomDir::~SelectFilesDicomDir()
		{
		}

		//region "Metodos heredados de Ipasowizard"

		std::string SelectFilesDicomDir::GetTitle(){
			return _Std("Export to DICOM Dir");
		}

		std::string SelectFilesDicomDir::GetSubTitle(){
			return "";
		}

		bool SelectFilesDicomDir::Siguiente(){
			return true;
		}

		bool SelectFilesDicomDir::Anterior(){
			return false;
		}

		bool SelectFilesDicomDir::Cancelar(){
			return true;
		}

		bool SelectFilesDicomDir::Validar()
		{
			//list of files
			std::list<std::string> seriesList = m_pFileSelection->GetSelectedUIDs(false); //series instances uids
			std::list<std::string> diagnosticList = m_pFileSelection->GetSelectedUIDs(true); //study instances uids

			//check if diagnostics are modified...
			if (diagnosticList.size() > 0) {
				std::list<std::string> modifiedDiagnosticsList;
				GNC::GCS::ControladorVistas::TipoListaVistas viewList = GNC::GCS::ControladorVistas::Instance()->GetVistas();
				for (GNC::GCS::ControladorVistas::TipoListaVistas::const_iterator it = viewList.begin(); it != viewList.end(); ++it) {
					if ((*it)->EstaModificada()) {
						modifiedDiagnosticsList.push_back((*it)->GetEstudio()->GetUIDEstudioDiagnostico());
					}
				}
				bool modified = false;
				for (std::list<std::string>::iterator itUpload = diagnosticList.begin(); itUpload != diagnosticList.end() && !modified; ++itUpload) {
					for (std::list<std::string>::iterator itModified = modifiedDiagnosticsList.begin(); itModified != modifiedDiagnosticsList.end(); ++itModified) {
						if ((*itUpload) == (*itModified)) {
							modified = true;
							break;
						}
					}
				}
				if (modified) {
					int answer = wxMessageBox(_("There are selected diagnostics with pending modifications\nDo you want to save it before uploading?"),_("Save"), wxYES_NO , this);
					if (answer == wxYES) {
						for (GNC::GCS::ControladorVistas::TipoListaVistas::const_iterator it = viewList.begin(); it != viewList.end(); ++it) {
							if ((*it)->EstaModificada()) {
								std::string uidDiagnosis = (*it)->GetEstudio()->GetUIDEstudioDiagnostico();
								for (std::list<std::string>::iterator itUpload = diagnosticList.begin(); itUpload != diagnosticList.end(); ++itUpload) {
									if ((*itUpload) == uidDiagnosis) {
										(*it)->Guardar();
										break;
									}
								}
							}
						}									
					}
				}
			}

			if(seriesList.size() == 0 && diagnosticList.size() == 0) {
				wxMessageBox(_("Select Series you want to export"), _("Info"),
					wxOK | wxICON_INFORMATION, this);
				return false;
			}

			std::string pathDef;
			GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Exportacion", "PathDefecto", pathDef);
			wxString wxPathDefecto = wxString::FromUTF8(pathDef.c_str());
			wxDirDialog seleccionarDirectorio(this,_("Select the directory where the files will be stored"),wxPathDefecto,wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON);
			int response = seleccionarDirectorio.ShowModal();
			if (response == wxID_OK)
			{
				wxString wxPath = seleccionarDirectorio.GetPath();

				if( !wxDirExists(wxPath) ){
					wxMessageDialog dialog(NULL,_("The selected directory does not exist\nWould you like to create?"),_("Info"),wxYES_NO|wxICON_INFORMATION);
					if ( dialog.ShowModal() == wxID_NO)
					{
						return false;;
					}
					if(!wxFileName::Mkdir(wxPath)){
						wxMessageBox(_("There was an error creating directory"), _("Info"),
							wxOK | wxICON_INFORMATION, this);
						return false;
					}
				} else {
					if (wxDirExists(wxPath + wxFileName::GetPathSeparator() + wxT("DICOM"))) {
						wxMessageBox(_("There are other DICOM directory in selected path"), _("Info"),
							wxOK | wxICON_INFORMATION, this);
						return false;
					}
				}
				//anonimization
				GIL::DICOM::TipoJerarquia base;
				if (m_pCheckPatientName->IsChecked()) {
					base.tags["0010|0010"] = _Std("Unknown");
				}
				if (m_pCheckPatientId->IsChecked()) {
					base.tags["0010|0020"] = _Std("Unknown");
				}
				if (m_pCheckInstitutions->IsChecked()) {
					base.tags["0008|0080"] = _Std("Unknown");
				}
				if (m_pCheckReferringPhysician->IsChecked()) {
					base.tags["0008|0090"] = _Std("Unknown");
				}
				if (m_pCheckComments->IsChecked()) {
					base.tags["0008|1030"] = _Std("Unknown"); //study
					base.tags["0008|103e"] = _Std("Unknown"); //series
					base.tags["0020|4000"] = _Std("Unknown"); //image
				}

				std::string pathDicomDir(TOPATH(wxPath));
				GADAPI::ExportToDicomDirCommandParams* pParams = new GADAPI::ExportToDicomDirCommandParams(seriesList, diagnosticList, pathDicomDir, base, !m_pCheckPrivateTags->IsChecked());
				GADAPI::ExportToDicomDirCommand* pCmd = new GADAPI::ExportToDicomDirCommand(pParams);
				GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Exporting images ..."), pCmd, NULL);

				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Exportacion", "PathDefecto",std::string(wxPath.ToUTF8()));
				return true;
			} else {
				return false;
			}

			return true;
		}
		//endregion
	}
}
