/*
 *  
 *  $Id: dialogoadquisicion.h 4639 2012-01-31 14:42:25Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <list>
#include <yasper/yasper.h>
#include <api/icontroladormodulo.h>
#include <api/imodelointegracion.h>
#include <api/icontroladoreventos.h>

#include <main/controllers/pacscontroller.h>
#include <commands/comandopacs.h>

#include "dialogoadquisicionbase.h"

class IModeloDicom;
class wxAnimationCtrl;

namespace Descargas {
	class DescargasGridTable;
}

namespace GNC {

	namespace GUI {
		class DownloadElementContainerPanel;

		class DialogoAdquisicion: public DialogoAdquisicionBase, public GADAPI::PACS::IComandoPACSNotificador, public GNC::GCS::IObservador
		{
			public:
				static DialogoAdquisicion* Instance();
				static void FreeInstance();

				DialogoAdquisicion(wxWindow* pParent);
				~DialogoAdquisicion();
				
				virtual bool Show(bool show = true);
				virtual bool Show(const std::string& idPatient, const std::string& idPACS);

			//---------------------------------------------------------------------------
			//region Eventos de interfaz
				virtual void OnPACSChanged(wxCommandEvent & event);
				virtual void OnKeyDownFormulario( wxKeyEvent& event );
				virtual void OnFechaDesdeDateChanged( wxDateEvent& event );
				virtual void OnFechaHastaDateChanged( wxDateEvent& event );
				virtual void OnBusquedaClick( wxCommandEvent& event );
				virtual void Search();
				virtual void OnCancelClick( wxCommandEvent& event);
				std::string GetModalities();
				virtual void OnLimpiarClick( wxCommandEvent& event );
				virtual void OnCloseClick( wxCommandEvent& event );
				virtual void OnDescargarClick( wxCommandEvent& event);

				virtual void OnTreeSelChanged(wxTreeEvent& event);
				virtual void OnTreeItemActivated(wxTreeEvent& event);
				virtual void OnTreeItemMenu(wxTreeEvent& event);
				virtual void OnTreeItemExpanded(wxTreeEvent& event);
				virtual void OnTreeBeginDrag(wxTreeEvent& event);
				virtual void OnClickColumnHeader(wxListEvent& event);
			
			//---------------------------------------------------------------------------
			//region Helpers
			std::string GetServerSeleccionado();
			void AddDescarga(bool lanzarBusqueda);
			void ShowProperties();
			bool IsAllowedToDownload(const std::string& modality);
			void ShowAnimation(bool show);
			
			void LimpiarBusquedas(bool lock = true);
			//endregion

			//---------------------------------------------------------------------------
			//region realizacion de la interfaz IComandoPACSNotificador
				virtual void PACSCargarListado(IModeloDicom *);
			//endregion

				//para enterarse si ha parado un comando...
			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);
				//

			private:
				static DialogoAdquisicion* m_pInstance;

				wxString m_SelectedPACS;
				
				wxAnimationCtrl* m_pAnimation;

				GIL::DICOM::ContextoResultado* m_pResultado;
				wxImageList*                   m_pImageList;
				GADAPI::ComandoPACS*           m_pComandoPACS;
				wxTreeItemId                   m_lastExpanded;
				GnkPtr<IModeloDicom>           m_pModeloDicom;

				DownloadElementContainerPanel* m_pDownloadPanel;

				bool        m_SizeRestriction;
				bool        m_SizeOK;
				bool			m_reverseOrder;

				bool         m_AutoAddSeries;     // Indica que se auto-anyadiran a las descargas todas las series del proximo despliegue
				wxTreeItemId m_AutoAddSeriesItem; // Elemento desplegado sobre el que se auto-anyadira

				typedef enum TDialogMode
				{
					TD_SERIES,
					TD_STUDIES
				}TDialogMode;
				TDialogMode m_Mode;

				Descargas::DescargasGridTable* m_pDescargasGridTable;
				GNC::GCS::ILockable m_TreeListResultadosLocker; // Necesario para evitar problemas con el treelistcontrol.

				typedef std::vector<wxCheckBox*>  TModalitiesVector;
				TModalitiesVector m_modalitiesList;

		};
	}
}
