/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
//#define _GINKGO_TRACE
#include <wx/string.h>
#include <api/globals.h>
#include <main/controllers/configurationcontroller.h>
#include "icontroladormodulo.h"
#include <wx/bitmap.h>
#include <export/tagsprivadoscomunes.h>

GNC::GCS::IControladorModulo::IControladorModulo(GNC::GCS::IEntorno* pEntorno, const std::string& uid, int priority)
{
	m_pEntorno       = pEntorno;
	m_UID            = uid;
	m_priority = priority;
	GTRACE("IControladorModulo::IControladorModulo( " << m_UID << " )");
}

/* Destructor */
GNC::GCS::IControladorModulo::~IControladorModulo()
{
	GTRACE(">>IControladorModulo::~IControladorModulo( " << m_UID << " )");
	GTRACE("<<IControladorModulo::~IControladorModulo( " << m_UID << " )");
}

void GNC::GCS::IControladorModulo::RegistrarConfiguracion()
{
	bool written = false;

	std::string key;
	std::string val;

	GNC::GCS::ConfigurationController * pConfig = GNC::GCS::ConfigurationController::Instance();

	for (TipoListaIdsHL7::iterator it = m_ListaInformes.begin(); it != m_ListaInformes.end(); it++)
	{
		const IdHL7& i = *it;

		key = i.etiqueta;
		if ( !pConfig->readStringGeneral("/GinkgoCore/HCE/Plantillas",key, val)) {
			pConfig->writeStringGeneral("/GinkgoCore/HCE/Plantillas",key,(const std::string)i);
			written = true;
		}
	}

	if (written) {
		pConfig->Flush();
	}

}


void GNC::GCS::IControladorModulo::GetTagsPrivadosReplace(GNC::GCS::IControladorModulo::TMapaTagsPrivados& mapaTags)
{
	if (mapaTags.find(UID_TAGS_PRIVADOS_COMUNES) == mapaTags.end()) {
		mapaTags[UID_TAGS_PRIVADOS_COMUNES] = TListaIdsTagsPrivados();
	}

	mapaTags[UID_TAGS_PRIVADOS_COMUNES].push_back(GNC::GCS::IControladorModulo::TPrivateTagReemplazable(TAG_WIDGETS, GNC::GCS::IControladorModulo::TPrivateTagReemplazable::XML));
}

GNC::GCS::IContextoEstudio::TModoFuncionamiento GNC::GCS::IControladorModulo::GetDiagnosticMode()
{
	return GNC::GCS::IContextoEstudio::TMF_UNDiagnostico;
}


bool GNC::GCS::IControladorModulo::SupportsImportationUID(const std::string &)
{
	return false;
}
