/*
 *  
 *  $Id: icontexto.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <api/api.h>
#include <api/math/geometria.h>

// Forward Declarations

struct _cairo;
struct _cairo_surface;

class vtkGinkgoImageViewer;
namespace GNC {
	namespace GCS {
		class IWidgetsRenderer;
	}
}

class wxWindow;

// Forward Declarations

namespace GNC {
	namespace GCS {

		typedef enum TipoProyeccion {
			TP_Ortogonal,
			TP_Perspectiva
		} TipoProyeccion;

		class EXTAPI Contexto3D{
		public:

			/* Dimension en las coordenadas x del viewport */
			unsigned int ancho;
			/* Dimension en las coordenadas y del viewport */
			unsigned int alto;

			// Propiedades para Offscreen Rendering

			double           spacing[3];
			double           origin[3];
			unsigned char*   pixelData;
			_cairo*          cr;
			_cairo_surface*  cs;
			bool             offscreenCreado;
			long             OVID; // VID offscreen
			GNC::GCS::Vector factorReescalado; // Factor de reescalado de la imagen. Para corregir coordenadas mundo al redimensionar.

			/* Puntero a wxWindow del renderer para permitir enparentar wxWidgets (Ventanas, dialogos, etc...) */
			wxWindow*              pWindow;
			IWidgetsRenderer*      pRenderer;
			vtkGinkgoImageViewer*  pOffscrenViewer;


		protected:
			/* Relacion coordenada mundo => coordenada pantalla*/
			GNC::GCS::Vector       m_RelacionMundoPantallaOffscreen;

			GNC::GCS::Vector       m_RelacionImagenPantalla;

		public:

			/* Rotacion y posicion de la camara */
			double rotacion;
			bool   flipHorizontal;
			bool   flipVertical;

			/* Tipo de Proyeccion (Para calcular la norma) */
			TipoProyeccion tipoProyeccion;

			inline Contexto3D(TipoProyeccion proyeccion = TP_Ortogonal)
			{
				tipoProyeccion = proyeccion;
				pWindow = NULL;
				pRenderer = NULL;
				pixelData = NULL;
				cr = NULL;
				cs = NULL;
				pOffscrenViewer = NULL;
				offscreenCreado = false;
				OVID = 0;
				Reset();
			}

			inline ~Contexto3D()
			{
				Reset();
			}

			inline void Reset() {
				ancho           = 0;
				flipHorizontal  = false;
				flipVertical    = false;
				alto            = 0;
				rotacion        = 0;
				spacing[0] = spacing[1] = spacing[2] = 1.0f;
				origin[0] = origin[1] = origin[2] = 0.0f;
				m_RelacionMundoPantallaOffscreen.Asignar(1.0f, 1.0f);
				m_RelacionImagenPantalla.Asignar(1.0f, 1.0f);

				OVID            = 0;
				if ( offscreenCreado) {
					DestruirOffscreen();
				}
			}

			inline GNC::GCS::Vector& RefRelacionImagenPantalla() {
				return m_RelacionImagenPantalla;
			}

			inline const GNC::GCS::Vector& RelacionImagenPantalla() const {
				return m_RelacionImagenPantalla;
			}
			
			inline GNC::GCS::Vector& RefRelacionMundoPantallaOffscreen() {
				return m_RelacionMundoPantallaOffscreen;
			}
			
			inline const GNC::GCS::Vector& RelacionMundoPantallaOffscreen() const {
				return m_RelacionMundoPantallaOffscreen;
			}

			inline bool IsOk() const {
				return ancho > 0 && alto > 0 && pWindow != NULL && pRenderer != NULL;
			}

			inline IWidgetsRenderer* GetRenderer() const {
				return pRenderer;
			}

			void CrearOffscreen();

			void DestruirOffscreen();

			GNC::GCS::Vector Reproyectar(const GNC::GCS::Vector& v);

		};
	}
}
