/* Copyright (C) 2009 Versant Inc. http://www.db4o.com */
using System;
using System.Collections.Generic;
using System.IO;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Query;

namespace Db4objects.Db4odoc.Debugging
{
	public class DebugExample
	{
		private const string Db4oFileName = "reference.db4o";

		public static void Main(string[] args) 
		{
			SetCars();
            SetCarsWithFileOutput();
		}
		// end Main

		private static void SetCars()
		{
            // Set the debug message levet to the maximum
            IEmbeddedConfiguration configuration = Db4oEmbedded.NewConfiguration();
            configuration.Common.MessageLevel = 3;
            // Do some db4o operations
			File.Delete(Db4oFileName);
            IObjectContainer db = Db4oEmbedded.OpenFile(configuration, Db4oFileName);
			try 
			{
				Car car1 = new Car("BMW");
				db.Store(car1);
				Car car2 = new Car("Ferrari");
                db.Store(car2);
				db.Deactivate(car1,2);
				
				IList<Car> results = db.Query<Car>();
				ListResult(results);
			} 
			finally 
			{
				db.Close();
			}
		}
		// end SetCars

        private static void SetCarsWithFileOutput()
        {
            // Create StreamWriter for a file
            FileInfo f = new FileInfo("Debug.txt");
            StreamWriter debugWriter = f.CreateText();

            IEmbeddedConfiguration configuration = Db4oEmbedded.NewConfiguration();
            // Redirect debug output to the specified writer
            configuration.Common.OutStream = debugWriter;

            // Set the debug message levet to the maximum
            configuration.Common.MessageLevel = 3;
            // Do some db4o operations
            File.Delete(Db4oFileName);
            IObjectContainer db = Db4oEmbedded.OpenFile(configuration, Db4oFileName);
            try
            {
                Car car1 = new Car("BMW");
                db.Store(car1);
                Car car2 = new Car("Ferrari");
                db.Store(car2);
                db.Deactivate(car1, 2);
                
                IList<Car> results = db.Query<Car>();
                ListResult(results);
            }
            finally
            {
                db.Close();
                debugWriter.Close();
            }
            
        }
        // end SetCarsWithFileOutput

		private static void ListResult<T>(IList<T> result)
		{
			Console.WriteLine(result.Count);
			foreach (T item in result)
			{
				Console.WriteLine(item);
			}
		}
		// end ListResult
	}
}
