template <typename Type>
concept bool Comparable()
{
    return requires(Type lhs, Type rhs)
        {
            {lhs == rhs} -> bool;
            {lhs != rhs} -> bool;
        };
}

template <typename Type1, typename Type2>
concept bool Comparable()
{
    return false;
}

template <typename T1, Comparable<T1> T2>
void gun(T1 t1, T1 t2)
{}


template <typename T1, typename T2>
requires Comparable<T1, T2>()
void fun(T1 t1, T2 t2)
{}

int main()
{
    gun(3, 4);
}
