package Task::MojoliciousPlugins::PerlAcademy;

# ABSTRACT: All these modules are installed for the Mojolicious training

use strict;
use warnings;

our $VERSION = '0.02';

q~A great start to play with Perl~;

__END__

=pod

=encoding utf-8

=head1 NAME

Task::MojoliciousPlugins::PerlAcademy - All these modules are installed for the Mojolicious training

=head1 VERSION

version 0.02

=head1 MODULES REQUIRED

=over 4

=item * MojoX-AIO

Asynchronous File I/O for Mojolicious

=item * MojoX-Auth-Simple

Perl extension for simple login authentication for Mojolicious web applications

=item * MojoX-CPAN-Uploader

Mojo way to upload files to CPAN

=item * MojoX-CustomTemplateFileParser

Parses a custom Mojo template file format

=item * MojoX-DirectoryListing

show Apache-style directory listings in your Mojolicious app

=item * MojoX-Dispatcher-Qooxdoo-Jsonrpc

dispatch Qooxdoo applications with Mojo

=item * MojoX-Encode-Gzip

Gzip a Mojo::Message::Response

=item * MojoX-GlobalEvents

A module to handle events

=item * MojoX-IOLoop-Server-StartTLS

=item * MojoX-JSON-RPC

Perl implementation of JSON-RPC 2.0 protocol for Mojolicious

=item * MojoX-JSON-RPC-Service-AutoRegister

Base class for RPC Services

=item * MojoX-JSON-XS

A JSON::XS backend replacement for Mojo::JSON

=item * MojoX-JSONRPC2-HTTP

Client for JSON RPC 2.0 over HTTP

=item * MojoX-Log-Declare

Integrate Log::Declare with Mojolicious

=item * MojoX-Log-Dispatch

Log::Dispatch For Mojo

=item * MojoX-Log-Fast

Log::Fast for Mojolicious

=item * MojoX-Log-Log4perl

Log::Log4perl logging for Mojo/Mojolicious

=item * MojoX-Logite

A simple Mojo::Log implementation which logs to an SQLite database

=item * MojoX-Moose-Controller

A Moose based Mojolicious controller

=item * MojoX-Mysql

Mojolicious ♥ Mysql

=item * MojoX-Ping

asynchronous ping with Mojolicious (DEPRECATED).

=item * MojoX-Plugin-AnyCache

Cache plugin with blocking and non-blocking support

=item * MojoX-Plugin-PHP

use PHP as a templating system in Mojolicious

=item * MojoX-Plugin-PODRenderer

=item * MojoX-Redis

asynchronous Redis client for Mojolicious. (Obsoleted by

=item * MojoX-Renderer-Alloy

Base class for Template::Alloy renderer

=item * MojoX-Renderer-CTPP2

CTPP2 renderer for Mojo

=item * MojoX-Renderer-HTC

HTML::Template::Compiled renderer for Mojo

=item * MojoX-Renderer-HTP

HTML::Template::Pro renderer for Mojo

=item * MojoX-Renderer-IncludeLater

A post processor to defer partial template rendering

=item * MojoX-Renderer-JSON-XS

Fast JSON::XS handler for Mojolicious::Renderer

=item * MojoX-Renderer-WriteExcel

emit Excel spreadsheets from Mojo

=item * MojoX-Renderer-XSLT

The great new MojoX::Renderer::XSLT!

=item * MojoX-Renderer-Xslate

Text::Xslate renderer for Mojo

=item * MojoX-Routes-AsGraph

Create a graph from a MojoX::Routes object

=item * MojoX-Run

IO::Handle wrapper with some emulated socket-like behaviour for Mojo::IOLoop compatibility.

=item * MojoX-Session

Session management for Mojo

=item * MojoX-Session-Simple

Plack::Middleware::Session::Simple adapter for Mojolicious

=item * MojoX-Session-Store-File

File store for MojoX::Session

=item * MojoX-Session-Store-Libmemcached

Memcached Store for MojoX::Session

=item * MojoX-Session-Store-Memcached

Memcached Store for MojoX::Session

=item * MojoX-Session-Store-MongoDB

MongoDB Store for MojoX::Session

=item * MojoX-Session-Store-Redis

RedisDB Store for MojoX::Session

=item * MojoX-Transaction-WebSocket76

WebSocket version hixie-76 transaction container

=item * MojoX-UserAgent

An asynchronous user-agent for the Mojo Web Framework.

=item * MojoX-UserAgent-Throttler

add throttling support to Mojo::UserAgent

=item * MojoX-ValidateHeadLinks

Ensure CSS and JS links in web pages point to real files

=item * MojoX-Validator

Data validator

=item * Mojolicious

Real-time web framework

=item * Mojolicious-Command-deploy

Deployment command

=item * Mojolicious-Command-deploy-heroku

Deploy to Heroku

=item * Mojolicious-Command-generate-bootstrap

Include Twitters Bootstrap

=item * Mojolicious-Command-generate-bootstrap_app

Generate a simple application with DBIx::Class authentication and Twitter Bootstrap CSS.

=item * Mojolicious-Command-generate-dbicdump

dbicdump your Mojo app schema

=item * Mojolicious-Command-generate-qx_mojo_app

Mojo generator for a qooxdoo mojolicious app

=item * Mojolicious-Command-generate-upstart

upstart job generator command

=item * Mojolicious-Command-listdeps

Command to list dependencies in a Mojolicious project

=item * Mojolicious-Command-nopaste

A clone of App::Nopaste using Mojolicious

=item * Mojolicious-Command-secret

Create application secrets() consisting of random bytes

=item * Mojolicious-Plugin-AccessControl

Access control

=item * Mojolicious-Plugin-AccessLog

AccessLog Plugin

=item * Mojolicious-Plugin-AdditionalValidationChecks

Mojolicious Plugin

=item * Mojolicious-Plugin-AdvancedMod

Generic Mojolicious app, controllers, models, helpers, views

=item * Mojolicious-Plugin-Airbrake

=item * Mojolicious-Plugin-Alias

Mojolicious plugin to serve static files from aliased paths

=item * Mojolicious-Plugin-Angular-MaterialDesign

Mojolicious + https://material.angularjs.org/

=item * Mojolicious-Plugin-AnyData

Use and handle any data like a database source in test mode

=item * Mojolicious-Plugin-AppCacheManifest

Offline web application manifest support for Mojolicious

=item * Mojolicious-Plugin-Args

Gives you a simple %args hash of parameters on the request, even if they're posted in JSON.

=item * Mojolicious-Plugin-AssetPack

Compress and convert css, less, sass, javascript and coffeescript files

=item * Mojolicious-Plugin-AttributeMaker

Make attributes for Mojolicious? - easily!

=item * Mojolicious-Plugin-Authentication

A plugin to make authentication a bit easier

=item * Mojolicious-Plugin-Authorization

A plugin to make authorization a bit easier

=item * Mojolicious-Plugin-AutoIndex

Mojolicious plugin for autoindex function at static resource

=item * Mojolicious-Plugin-AutoParams

Send captured placeholder values as parameters for routes.

=item * Mojolicious-Plugin-AutoRoute

Mojolicious Plugin to create routes automatically

=item * Mojolicious-Plugin-BasicAuth

Basic HTTP Auth Helper

=item * Mojolicious-Plugin-BasicAuthPlus

Basic HTTP Auth Helper Plus

=item * Mojolicious-Plugin-Bcrypt

bcrypt your passwords!

=item * Mojolicious-Plugin-BindSessionToIP

Binds your Mojolicious session to IP-address for better security of your application

=item * Mojolicious-Plugin-BlogSpam

Check your Comments using BlogSpam

=item * Mojolicious-Plugin-Bootstrap3

Mojolicious + http://getbootstrap.com/

=item * Mojolicious-Plugin-BootstrapAlerts

Bootstrap alerts for your web app

=item * Mojolicious-Plugin-BootstrapHelpers

Type less bootstrap

=item * Mojolicious-Plugin-BootstrapPagination

Page Navigator plugin for Mojolicious

=item * Mojolicious-Plugin-BrowserDetect

HTTP::BrowserDetect integration for Mojolicious

=item * Mojolicious-Plugin-Browserify

An Mojolicious plugin for assetpack+browserify

=item * Mojolicious-Plugin-Bundle

Collection of mojolicious plugins

=item * Mojolicious-Plugin-CBOR

render a CBOR response with Mojolicious

=item * Mojolicious-Plugin-CGI

Run CGI script from Mojolicious

=item * Mojolicious-Plugin-CHI

Use CHI Caches in Mojolicious

=item * Mojolicious-Plugin-CORS

A cheap and easy way to enable CORS requests (cross origin resource sharing) for public APIs; configurability is on the TODO

=item * Mojolicious-Plugin-CSRFDefender

Defend CSRF automatically in Mojolicious Application

=item * Mojolicious-Plugin-CSRFProtect

Fully protects you from CSRF attacks

=item * Mojolicious-Plugin-CSSCompressor

Mojolicious plugin to compress stylesheets

=item * Mojolicious-Plugin-CSSLoader

move css loading to the end of the document

=item * Mojolicious-Plugin-Cache

Mojolicious plugin for caching

=item * Mojolicious-Plugin-CacheMoney

Bling bling

=item * Mojolicious-Plugin-CachePurge

Mojolicious Plugin to purge content from front end HTTP cache

=item * Mojolicious-Plugin-Captcha

create and validate captcha for Mojolicious framework

=item * Mojolicious-Plugin-Captcha-reCAPTCHA

use Captcha::reCAPTCHA in Mojolicious apps

=item * Mojolicious-Plugin-CaptchaRenderer

captcha renderer for Mojolicious framework

=item * Mojolicious-Plugin-ChromeLogger

Pushes Mojolicious logs, stash, session, config to Google Chrome console

=item * Mojolicious-Plugin-ConfigHashMerge

Perlish Configuration, with merging of deeply-nested defaults.

=item * Mojolicious-Plugin-ConfigRoutes

is a Perl-ish configuration of routes plugin.

=item * Mojolicious-Plugin-ConfigSimple

Config::Simple::Extended

=item * Mojolicious-Plugin-ConsoleLogger

Console logging in your browser

=item * Mojolicious-Plugin-CountryDropDown

Provide a localizable dropdown where users can select a country

=item * Mojolicious-Plugin-Crypto

Provide interface to various cipher algorithms

=item * Mojolicious-Plugin-DBICAdmin

Web interface for DBIx::Class Schema/ResultSource/ResultSet

=item * Mojolicious-Plugin-DBIxTransactionManager

DBIx::TransactionManager for Mojolicious's plugin

=item * Mojolicious-Plugin-DBViewer

Mojolicious plugin to display database information on browser

=item * Mojolicious-Plugin-DOCRenderer

Browses online documentation of your Mojolicious application

=item * Mojolicious-Plugin-DSC

use DBIx::Simple::Class in your application.

=item * Mojolicious-Plugin-Data-Validate-WithYAML

validate form input with Data::Validate::WithYAML

=item * Mojolicious-Plugin-Database

"proper" handling of DBI based connections in Mojolicious

=item * Mojolicious-Plugin-DateTime

Mojolicious plugin to DateTime module integration

=item * Mojolicious-Plugin-DeCSRF

Defend from CSRF attacks

=item * Mojolicious-Plugin-DigestAuth

HTTP Digest Authentication for Mojolicious

=item * Mojolicious-Plugin-Directory

Serve static files from document root with directory index

=item * Mojolicious-Plugin-DirectoryQueue

Mojolicious 应用使用的内部队列服务, 基本本地文件系统的队列系统 , 为方便做任务应用使用.

=item * Mojolicious-Plugin-Disqus

Interface with Disqus comments from your Mojolicious app

=item * Mojolicious-Plugin-Disqus-Tiny

Mojolicious plugin for integrating Disqus forum

=item * Mojolicious-Plugin-DomIdHelper

Mojolicious plugin to generate DOM IDs and CSS class names from your ORM objects

=item * Mojolicious-Plugin-Dotcloud

A quick and dirty wrapper around DotCloud::Environment

=item * Mojolicious-Plugin-DumpyLog

Automatically runs Data::Dumper against the last element in the list passed to any ->log->method() if it's a ref.

=item * Mojolicious-Plugin-EventSource

A plugin to make it eazy to use EventSource with Mojolicious

=item * Mojolicious-Plugin-FeedReader

Mojolicious plugin to find and parse RSS & Atom feeds

=item * Mojolicious-Plugin-FillInFormLite

Mojolicious plugin to fill in form.

=item * Mojolicious-Plugin-FontAwesome4

Mojolicious + http://fortawesome.github.io/Font-Awesome/

=item * Mojolicious-Plugin-Form

abstract forms for Mojolicious and DBIx::Class

=item * Mojolicious-Plugin-FormFields

Lightweight form builder with validation and filtering

=item * Mojolicious-Plugin-FormFieldsFromJSON

create form fields based on a definition in a JSON file

=item * Mojolicious-Plugin-FormFieldsFromJSON-Date

Mojolicious Plugin

=item * Mojolicious-Plugin-FormValidator

Mojolicious Plugin

=item * Mojolicious-Plugin-Geo

Mojolicious Plugin

=item * Mojolicious-Plugin-GoogleAnalytics

GoogleAnalytics plugin

=item * Mojolicious-Plugin-Gravatar

Globally Recognized Avatars for Mojolicious

=item * Mojolicious-Plugin-GroupedParams

grouped params from query.

=item * Mojolicious-Plugin-HTMLLint

HTML::Lint support for Mojolicious

=item * Mojolicious-Plugin-HTMLTemplateProRenderer

A Mojoliciuos plugin to render templates using HTML::Template::Pro module

=item * Mojolicious-Plugin-HTMLTemplateRenderer

Mojolicious Plugin to render templates with HTML::Template

=item * Mojolicious-Plugin-HTTPStatusRenderer

HTTP status renderer plugin

=item * Mojolicious-Plugin-HamlRenderer

Haml renderer for Mojolicious

=item * Mojolicious-Plugin-HostMeta

Serve and Retrieve Host-Meta Documents

=item * Mojolicious-Plugin-HttpBasicAuth

Http-Basic-Authentication implementation for Mojolicious

=item * Mojolicious-Plugin-Human

Helpers to print values as human readable form.

=item * Mojolicious-Plugin-Humane

Mojolicious integration for humane.js

=item * Mojolicious-Plugin-I18N

Internationalization Plugin for Mojolicious

=item * Mojolicious-Plugin-I18NUtils

provide some helper functions for I18N

=item * Mojolicious-Plugin-INIConfig

Mojolicious Plugin to create routes automatically

=item * Mojolicious-Plugin-Ident

Mojolicious plugin to interact with a remote ident service

=item * Mojolicious-Plugin-InstallablePaths

Easy installation configuration for Mojolicious apps

=item * Mojolicious-Plugin-JQuery

Mojolicious + http://jquery.com/

=item * Mojolicious-Plugin-JSLoader

move js loading to the end of the document

=item * Mojolicious-Plugin-JSONP

Render JSONP with transparent fallback to JSON

=item * Mojolicious-Plugin-JSONRPC2

JSON RPC 2.0 over HTTP

=item * Mojolicious-Plugin-JSUrlFor

Mojolicious "url_for" helper for javascript

=item * Mojolicious-Plugin-JavaScript-Console

use the JavaScript console from Mojolicious applications

=item * Mojolicious-Plugin-KossyValidator

根据 Kossy 中的 Validator 移植过来的模块

=item * Mojolicious-Plugin-Leafletjs

A Mojolicious Plugin

=item * Mojolicious-Plugin-LeakTracker

Helps you track down memory leaks in your code

=item * Mojolicious-Plugin-Libravatar

Access the Libravatar API in Mojolicious.

=item * Mojolicious-Plugin-LinkEmbedder

Convert a URL to embedded content

=item * Mojolicious-Plugin-LinkedContent

manage linked css and js

=item * Mojolicious-Plugin-Log-Access

Plugin for production-tier access logging

=item * Mojolicious-Plugin-Log-Timestamp

Plugin for customised log timestamps

=item * Mojolicious-Plugin-Logf

Plugin for logging datastructures using sprintf

=item * Mojolicious-Plugin-Mail

Mojolicious Plugin for send mail

=item * Mojolicious-Plugin-MailException

Mojolicious plugin to send crash information by email

=item * Mojolicious-Plugin-MarkaplRenderer

Markapl template plugin for Mojolicious

=item * Mojolicious-Plugin-Mason1Renderer

Mason 1 (aka HTML::Mason 1.x) Renderer Plugin.

=item * Mojolicious-Plugin-Mason2Renderer

Mason 2 (aka Mason 2.x) Renderer Plugin.

=item * Mojolicious-Plugin-Memorize

Memorize part of your Mojolicious template

=item * Mojolicious-Plugin-Message-Locale

Mojolicious Plugin

=item * Mojolicious-Plugin-MethodOverride

Simulate HTTP Verbs

=item * Mojolicious-Plugin-Mobi

Mojolicious Plugin

=item * Mojolicious-Plugin-Module

Mojolicious plugin for modular development.

=item * Mojolicious-Plugin-Mongodb

Use MongoDB in Mojolicious

=item * Mojolicious-Plugin-MoreUtilHelpers

Methods to format, count, sanitize, etc...

=item * Mojolicious-Plugin-MostTagHelpers

More tag helpers for your templated and slides

=item * Mojolicious-Plugin-MountPSGI

Mount PSGI apps

=item * Mojolicious-Plugin-MozPersona

Minimalistic integration of Mozillas "Persona" authentication system in Mojolicious apps

=item * Mojolicious-Plugin-MultiConfig

Load multiple configs and merge

=item * Mojolicious-Plugin-MySQLViewerLite

Mojolicious plugin to display MySQL database information on browser

=item * Mojolicious-Plugin-NYTProf

Auto handling of Devel::NYTProf in your Mojolicious app

=item * Mojolicious-Plugin-NamespaceForm

Support foo.0.bar params

=item * Mojolicious-Plugin-Narada

Narada configuration plugin

=item * Mojolicious-Plugin-NetsPayment

Make payments using Nets

=item * Mojolicious-Plugin-Nexmo

Asynchronous (and synchronous) SMS and TTS (Text To Speech) sending with Nexmo provider.

=item * Mojolicious-Plugin-Notifications

Event Notifications for your Users

=item * Mojolicious-Plugin-Nour-Config

Robustly imports config from a ./config sub-directory loaded with nested YAML files

=item * Mojolicious-Plugin-Nour-Database

Adds an easy to use database handle to your mojo app.

=item * Mojolicious-Plugin-Number-Commify

Plugin for readable numbers

=item * Mojolicious-Plugin-OAuth2

Authenticate against OAuth2 providers

=item * Mojolicious-Plugin-OnFork

Do Something Whenever a Worker Starts

=item * Mojolicious-Plugin-PDFRenderer

Uses wkhtmltopdf via PDF::WebKit to render your app exactly as it looks in Chrome/WebKit but vector scalable and in PDF

=item * Mojolicious-Plugin-PPI

Mojolicious Plugin for Rendering Perl Code Using PPI

=item * Mojolicious-Plugin-ParamExpand

Use objects and data structures in your forms

=item * Mojolicious-Plugin-ParamLogger

Log request parameters

=item * Mojolicious-Plugin-ParamsAuth

URL Parameters Auth Helper

=item * Mojolicious-Plugin-PayPal

Make payments using PayPal

=item * Mojolicious-Plugin-PetalTinyRenderer

Petal::Tiny renderer plugin

=item * Mojolicious-Plugin-PgAsync

Mojolicious Plugin for asynchronous operation with PostgreSQL

=item * Mojolicious-Plugin-Piwik

Use Piwik in Mojolicious

=item * Mojolicious-Plugin-PlackMiddleware

Plack::Middleware inside Mojolicious

=item * Mojolicious-Plugin-PlainRoutes

Plaintext route definitions for Mojolicious

=item * Mojolicious-Plugin-ProRenderer

HTML::Tempate::Pro render plugin for Mojolicious

=item * Mojolicious-Plugin-Prove

run test scripts via browser

=item * Mojolicious-Plugin-Proxy

Proxy requests

=item * Mojolicious-Plugin-PubSubHubbub

Publish and Subscribe with PubSubHubbub

=item * Mojolicious-Plugin-Qaptcha

jQuery QapTcha Plugin for Mojolicious

=item * Mojolicious-Plugin-Qooxdoo

Qooxdoo JSON-RPC support for the Mojolicious Perl framework

=item * Mojolicious-Plugin-REST

Mojolicious Plugin for RESTful operations

=item * Mojolicious-Plugin-RESTRoutes

routing helper for RESTful operations

=item * Mojolicious-Plugin-Recaptcha

ReCaptcha plugin for Mojolicious framework

=item * Mojolicious-Plugin-RedirectHost

Redirects requests from mirrors to the main host (useful for SEO)

=item * Mojolicious-Plugin-Redis

Use Redis in Mojolicious

=item * Mojolicious-Plugin-RelativeUrlFor

relative links in Mojolicious, really.

=item * Mojolicious-Plugin-RemoteAddr

an easy way of getting remote ip address

=item * Mojolicious-Plugin-RenderFile

"render_file" helper for Mojolicious

=item * Mojolicious-Plugin-RenderSteps

ASync controllers without the boilerplate

=item * Mojolicious-Plugin-RequestBase

Support setting base in frontend proxy

=item * Mojolicious-Plugin-Responsinator

Simulate screen sizes

=item * Mojolicious-Plugin-Resque

Mojolicious helper for sending jobs to a Resque queue.

=item * Mojolicious-Plugin-ReverseProxy

ReverseProxy plugin for the Mojolicious Perl framework

=item * Mojolicious-Plugin-SMS

Easy SMS sending from Mojolicious apps

=item * Mojolicious-Plugin-SQLMaker

The great new Mojolicious::Plugin::SQLMaker!

=item * Mojolicious-Plugin-SQLiteViewerLite

Mojolicious plugin to display SQLite database information on browser

=item * Mojolicious-Plugin-SassRenderer

Sass Renderer Plugin for Mojolicious

=item * Mojolicious-Plugin-SaveRequest

Mojolicious Plugin

=item * Mojolicious-Plugin-SecureCORS

Complete control over CORS

=item * Mojolicious-Plugin-SemanticUI

Semantic UI for your application

=item * Mojolicious-Plugin-Sentry

A perl sentry client for Mojolicious

=item * Mojolicious-Plugin-ServerSession

Perl extension to enable an additional server side session in mojolicious

=item * Mojolicious-Plugin-ServerStatus

show server status like Apache's mod_status

=item * Mojolicious-Plugin-SessionCompress

Session serialization and compression plugin for Mojolicious

=item * Mojolicious-Plugin-SessionStore

session data store plugin for Mojolicious

=item * Mojolicious-Plugin-ShareHelpers

A Mojolicious Plugin for generate share urls, buttons and meta for Twitter, Facebook, Google Buzz, VKontakte, MyMailRU and Google Plus

=item * Mojolicious-Plugin-Shotwell

View photos from Shotwell database

=item * Mojolicious-Plugin-SimpleSession

Exceedingly Simple Mojolicious Sessions

=item * Mojolicious-Plugin-SimpleSlides

Create a presentation using Mojolicious

=item * Mojolicious-Plugin-Sprite

let you easy introduce and maintain CSS sprites in your web-site.

=item * Mojolicious-Plugin-SslAuth

SSL client certificate auth helper

=item * Mojolicious-Plugin-StaticCompressor

Automatic JS/CSS minifier & compressor for Mojolicious

=item * Mojolicious-Plugin-Subdispatch

create requests to your Mojolicious actions

=item * Mojolicious-Plugin-Sugar

Some sweet stuff for Mojolicious

=item * Mojolicious-Plugin-Surveil

Surveil user actions

=item * Mojolicious-Plugin-TagHelpers-MailToChiffre

Obfuscate Email Addresses in Templates

=item * Mojolicious-Plugin-TagHelpers-NoCaching

Force images, styles, js reloading by the browser if they were modified on filesystem

=item * Mojolicious-Plugin-TagHelpers-Pagination

Pagination Helper for Mojolicious

=item * Mojolicious-Plugin-TagHelpersI18N

TagHelpers with I18N support

=item * Mojolicious-Plugin-Thumbnail

Use Imager in Mojolicious

=item * Mojolicious-Plugin-TimeAgo

DateTime TimeAgo Mojolicious Plugin

=item * Mojolicious-Plugin-ToolkitRenderer

Template Toolkit Renderer Mojolicious Plugin

=item * Mojolicious-Plugin-Toto

A simple tab and object based site structure

=item * Mojolicious-Plugin-TtRenderer

Template Renderer Plugin for Mojolicious

=item * Mojolicious-Plugin-TweetButton

TweetButton plugin for Mojolicious

=item * Mojolicious-Plugin-UTF8

Ensures proper UTF8 rendering by forcing all response Content-Type headers to have the "...; charset=utf-8" suffix

=item * Mojolicious-Plugin-UnicodeNormalize

normalize incoming Unicode parameters

=item * Mojolicious-Plugin-UrlWith

Preserve parts of the url

=item * Mojolicious-Plugin-UserMessages

Mojolicious Plugin to manage user message queue(s)

=item * Mojolicious-Plugin-Util-Callback

Reverse Helpers for Mojolicious

=item * Mojolicious-Plugin-Util-Endpoint

Use template URIs in Mojolicious

=item * Mojolicious-Plugin-Util-RandomString

Generate Secure Random Strings for Mojolicious

=item * Mojolicious-Plugin-VHost

Mojolicious Plugin that adds VirtualHosts

=item * Mojolicious-Plugin-ValidateMoose

Can validate using Moose objects

=item * Mojolicious-Plugin-ValidateTiny

Lightweight validator for Mojolicious

=item * Mojolicious-Plugin-ViewBuilder

a Mojolicious plugin that allows to chain templates generated by other plugins

=item * Mojolicious-Plugin-Vparam

Mojolicious plugin validator for GET/POST data.

=item * Mojolicious-Plugin-WWWSession

Use WWWW::Session with Mojolicious

=item * Mojolicious-Plugin-Web-Auth

Authentication plugin for Mojolicious

=item * Mojolicious-Plugin-WebFinger

Serve and Retrieve WebFinger Documents

=item * Mojolicious-Plugin-Webtail

display tail to your browser

=item * Mojolicious-Plugin-Wolowitz

Mojo I18n with Locale::Wolowitz

=item * Mojolicious-Plugin-WriteExcel

write Excel spreadsheets from Mojolicious

=item * Mojolicious-Plugin-XML-Loy

XML Generation with Mojolicious

=item * Mojolicious-Plugin-XRD

XRD Document Handling with Mojolicious

=item * Mojolicious-Plugin-YamlConfig

YAML Configuration Plugin for Mojolicious

=item * Mojolicious-Plugin-YubiVerify

Verify YubiKey one time passwords.

=item * Mojolicious-Plugin-ZombieApocalypse

Detect Zombie apocalypse

=back

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2014 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
