#!/usr/bin/perl

package eBay::API::XML::DataType::UserType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UserType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::UserType

=head1 DESCRIPTION

Type to contain the data for one eBay user. Depending on the context, the user
might be the seller or the buyer in a transaction, or the bidder or winning bidder
in a listing. An object of this type is returned by a number of calls, including
the GetUser call.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::UserType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::BiddingSummaryType;
use eBay::API::XML::DataType::BuyerType;
use eBay::API::XML::DataType::CharityAffiliationsType;
use eBay::API::XML::DataType::SellerType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::EBaySubscriptionTypeCodeType;
use eBay::API::XML::DataType::Enum::FeedbackRatingStarCodeType;
use eBay::API::XML::DataType::Enum::PayPalAccountLevelCodeType;
use eBay::API::XML::DataType::Enum::PayPalAccountStatusCodeType;
use eBay::API::XML::DataType::Enum::PayPalAccountTypeCodeType;
use eBay::API::XML::DataType::Enum::SellerPaymentMethodCodeType;
use eBay::API::XML::DataType::Enum::SiteCodeType;
use eBay::API::XML::DataType::Enum::UserStatusCodeType;
use eBay::API::XML::DataType::Enum::VATStatusCodeType;


my @gaProperties = ( [ 'AboutMePage', 'xs:boolean', '', '', '' ]
	, [ 'BiddingSummary', 'ns:BiddingSummaryType', ''
	     ,'eBay::API::XML::DataType::BiddingSummaryType', '1' ]
	, [ 'BuyerInfo', 'ns:BuyerType', ''
	     ,'eBay::API::XML::DataType::BuyerType', '1' ]
	, [ 'CharityAffiliations', 'ns:CharityAffiliationsType', ''
	     ,'eBay::API::XML::DataType::CharityAffiliationsType', '1' ]
	, [ 'EIASToken', 'xs:string', '', '', '' ]
	, [ 'Email', 'xs:string', '', '', '' ]
	, [ 'FeedbackPrivate', 'xs:boolean', '', '', '' ]
	, [ 'FeedbackRatingStar', 'ns:FeedbackRatingStarCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::FeedbackRatingStarCodeType', '' ]
	, [ 'FeedbackScore', 'xs:int', '', '', '' ]
	, [ 'IDVerified', 'xs:boolean', '', '', '' ]
	, [ 'MotorsDealer', 'xs:boolean', '', '', '' ]
	, [ 'NewUser', 'xs:boolean', '', '', '' ]
	, [ 'PayPalAccountLevel', 'ns:PayPalAccountLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PayPalAccountLevelCodeType', '' ]
	, [ 'PayPalAccountStatus', 'ns:PayPalAccountStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PayPalAccountStatusCodeType', '' ]
	, [ 'PayPalAccountType', 'ns:PayPalAccountTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PayPalAccountTypeCodeType', '' ]
	, [ 'PositiveFeedbackPercent', 'xs:float', '', '', '' ]
	, [ 'RESTToken', 'xs:string', '', '', '' ]
	, [ 'RegistrationAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'RegistrationDate', 'xs:dateTime', '', '', '' ]
	, [ 'SellerInfo', 'ns:SellerType', ''
	     ,'eBay::API::XML::DataType::SellerType', '1' ]
	, [ 'SellerPaymentMethod', 'ns:SellerPaymentMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SellerPaymentMethodCodeType', '' ]
	, [ 'Site', 'ns:SiteCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SiteCodeType', '' ]
	, [ 'SiteVerified', 'xs:boolean', '', '', '' ]
	, [ 'SkypeID', 'xs:string', '1', '', '' ]
	, [ 'Status', 'ns:UserStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::UserStatusCodeType', '' ]
	, [ 'TUVLevel', 'xs:int', '', '', '' ]
	, [ 'UniqueNegativeFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniqueNeutralFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniquePositiveFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UserAnonymized', 'xs:boolean', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
	, [ 'UserIDChanged', 'xs:boolean', '', '', '' ]
	, [ 'UserIDLastChanged', 'xs:dateTime', '', '', '' ]
	, [ 'UserSubscription', 'ns:EBaySubscriptionTypeCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::EBaySubscriptionTypeCodeType', '' ]
	, [ 'VATID', 'xs:string', '', '', '' ]
	, [ 'VATStatus', 'ns:VATStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::VATStatusCodeType', '' ]
	, [ 'eBayGoodStanding', 'xs:boolean', '', '', '' ]
	, [ 'eBayWikiReadOnly', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAboutMePage()

If true, indicates that the user has set up an About Me page.

#    Argument: 'xs:boolean'

=cut

sub setAboutMePage {
  my $self = shift;
  $self->{'AboutMePage'} = shift
}

=head2 isAboutMePage()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

#    Returns: 'xs:boolean'

=cut

sub isAboutMePage {
  my $self = shift;
  return $self->{'AboutMePage'};
}


=head2 setBiddingSummary()

Contains information about the user as a bidder on a certain
item. Returned for GetAllBidders if IncludeBiddingSummary =
true is included in the request.

#    Argument: 'ns:BiddingSummaryType'

=cut

sub setBiddingSummary {
  my $self = shift;
  $self->{'BiddingSummary'} = shift
}

=head2 getBiddingSummary()

  Calls: GetAllBidders
  Returned: Conditionally

#    Returns: 'ns:BiddingSummaryType'

=cut

sub getBiddingSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BiddingSummary'
		,'eBay::API::XML::DataType::BiddingSummaryType');
}


=head2 setBuyerInfo()

Contains information about the user as a buyer, such as
the shipping address. See BuyerType for its child elements.
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'ns:BuyerType'

=cut

sub setBuyerInfo {
  my $self = shift;
  $self->{'BuyerInfo'} = shift
}

=head2 getBuyerInfo()

  Calls: GetAllBidders
         GetHighBidders
  Returned: Always

  Calls: GetBidderList
  Returned: Conditionally
  Context: Bidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList

#    Returns: 'ns:BuyerType'

=cut

sub getBuyerInfo {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerInfo'
		,'eBay::API::XML::DataType::BuyerType');
}


=head2 setCharityAffiliations()

Contains information about the seller's charity affliations.
Returned if the user is affiliated with one or more
charities. Seller must be registered with the eBay Giving
Works provider to be affiliated with a charity non-profit
organization.

SeeLink: URL: http://givingworks.ebay.com/
Title: eBay Giving Works Program

#    Argument: 'ns:CharityAffiliationsType'

=cut

sub setCharityAffiliations {
  my $self = shift;
  $self->{'CharityAffiliations'} = shift
}

=head2 getCharityAffiliations()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:CharityAffiliationsType'

=cut

sub getCharityAffiliations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CharityAffiliations'
		,'eBay::API::XML::DataType::CharityAffiliationsType');
}


=head2 setEIASToken()

Unique identifier for the user that does not change when the eBay user name
is changed. Use when an application needs to associate a new eBay user name
with the corresponding eBay user.
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:string'

=cut

sub setEIASToken {
  my $self = shift;
  $self->{'EIASToken'} = shift
}

=head2 getEIASToken()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetHighBidders
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getEIASToken {
  my $self = shift;
  return $self->{'EIASToken'};
}


=head2 setEmail()

Email address for the user. You cannot retrieve an email address for any user
with whom you do not have a transactional relationship, regardless of site.
Email is only returned for applicable calls when you are retrieving your own
user data OR when you and the other user are in a transactional relationship
and the call is being executed within a certain amount of time after the
transaction is created. Based on Trust and Safety policies, the time is
unspecified and can vary by site.
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that
bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:string'

=cut

sub setEmail {
  my $self = shift;
  $self->{'Email'} = shift
}

=head2 getEmail()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Conditionally

  Calls: GetBestOffers
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
  Context: HighBidder

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getEmail {
  my $self = shift;
  return $self->{'Email'};
}


=head2 setFeedbackPrivate()

Indicates whether the user has chosen to make their feedback score and
feedback details private (hidden from other users). Note that the percentage
of positive feedback can still be returned, even if other feedback details are
private. To be eligible to list on Express, a seller's feedback needs to be
public. See "eBay Express" in the eBay Web Services guide. In GetSearchResults
and GetCategoryListings, feedback information is only returned if
IncludeFeedback = true in the request.
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:boolean'

=cut

sub setFeedbackPrivate {
  my $self = shift;
  $self->{'FeedbackPrivate'} = shift
}

=head2 isFeedbackPrivate()

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:boolean'

=cut

sub isFeedbackPrivate {
  my $self = shift;
  return $self->{'FeedbackPrivate'};
}


=head2 setFeedbackRatingStar()

Visual indicator of user's feedback score. See FeedbackRatingStarCodeType for
specific values.

#    Argument: 'ns:FeedbackRatingStarCodeType'

=cut

sub setFeedbackRatingStar {
  my $self = shift;
  $self->{'FeedbackRatingStar'} = shift
}

=head2 getFeedbackRatingStar()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetMyeBayBuying
         GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           WatchList

#    Returns: 'ns:FeedbackRatingStarCodeType'

=cut

sub getFeedbackRatingStar {
  my $self = shift;
  return $self->{'FeedbackRatingStar'};
}


=head2 setFeedbackScore()

The aggregate feedback score for a user. A user's feedback score is the net
positive feedback minus the net negative feedback left for the user. Feedback
scores are a quantitative expression of the desirability of dealing with a
user as a buyer or a seller in transactions. Each transaction can result in
one feedback entry for a given user (the buyer can leave feedback for the
seller, and the seller can leave feedback for the buyer.). That one feedback
can be positive, negative, or neutral. The aggregated feedback counts for a
particular user represent that user's overall feedback score (referred to as a
"feedback rating" on the eBay site). If the user has chosen to make their
feedback private and that user is not the user identified in the request's
authentication token, FeedbackScore is not returned and FeedbackPrivate is
returned with a value of true.<br>
<br>
To be eligible to list on Express, a seller's feedback score needs to be 100 or higher.
See "eBay Express" in the eBay Web Services guide.
In GetSearchResultsExpress, only returned when ItemDetails is set to Fine.<br>
<br>
In GetSearchResults and GetCategoryListings, feedback information is only
returned if IncludeFeedback = true in the request.
<br>
In GetMyeBayBuying and GetMyeBaySelling, feedback information (FeedbackScore
and FeedbackRatingStar) is returned in BidList.ItemArray.Item.Seller.
For GetMyeBayBuying, the feedback score of each seller
with an item having received a bid from the buyer is returned. For GetMyeBaySelling, the
feedback score of the seller is returned.
<br>
<br>
GetMyeBayBuying and GetMyeBaySelling
also return feedback information (FeedbackScore and FeedbackRatingStar) in
BidList.ItemArray.Item.SellingStatus.HighBidder.
GetMyeBayBuying returns feedback information on the high bidder of each item the buyer
is bidding on. GetMyeBaySelling returns feedback information on the high bidder of each
item the seller is selling.
<br>
<br>
Since a bidder's user info is anonymous, the real feedback score will
be returned only to that bidder, and to the seller of an item that the
user is bidding on. For all other users, the value -99 is returned.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:int'

=cut

sub setFeedbackScore {
  my $self = shift;
  $self->{'FeedbackScore'} = shift
}

=head2 getFeedbackScore()

  Calls: GetAllBidders
         GetCategoryListings
         GetHighBidders
         GetProducts
  Returned: Conditionally

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetBidderList
  Returned: Always

  Calls: GetBestOffers
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnCategories, ItemReturnAttributes, ReturnAll
           GranularityLevel: Coarse


  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetMyeBayBuying
         GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           WatchList

#    Returns: 'xs:int'

=cut

sub getFeedbackScore {
  my $self = shift;
  return $self->{'FeedbackScore'};
}


=head2 setIDVerified()

Indicates whether the user has been verified. For more information
about the ID Verify program, see:
http://pages.ebay.com/help/policies/identity-idverify.html

#    Argument: 'xs:boolean'

=cut

sub setIDVerified {
  my $self = shift;
  $self->{'IDVerified'} = shift
}

=head2 isIDVerified()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:boolean'

=cut

sub isIDVerified {
  my $self = shift;
  return $self->{'IDVerified'};
}


=head2 setMotorsDealer()

Indicates if item is listed for sale by owner (FSBO) or listed by a
dealer.
Applies to eBay Motors Pro applications only.

TheseSites: AU, DE, FR, IT, UK

  Calls: AddItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setMotorsDealer {
  my $self = shift;
  $self->{'MotorsDealer'} = shift
}

=head2 isMotorsDealer()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: Seller

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

#    Returns: 'xs:boolean'

=cut

sub isMotorsDealer {
  my $self = shift;
  return $self->{'MotorsDealer'};
}


=head2 setNewUser()

If true, identifies a new user who has been a registered eBay user for 30 days
or less. Always false after the user has been registered for more than 30
days. Does not indicate an ID change (see UserIdChanged).

#    Argument: 'xs:boolean'

=cut

sub setNewUser {
  my $self = shift;
  $self->{'NewUser'} = shift
}

=head2 isNewUser()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:boolean'

=cut

sub isNewUser {
  my $self = shift;
  return $self->{'NewUser'};
}


=head2 setPayPalAccountLevel()

The user's PayPal account level. Only returned for the user identified in
eBayAuthToken. That is, you cannot see someone else's PayPal account level.
Use this information to check whether a seller is eligible to list digital 
downloadable items. See the eBay Web site online
help for current PayPal requirements for listing digital items.

#    Argument: 'ns:PayPalAccountLevelCodeType'

=cut

sub setPayPalAccountLevel {
  my $self = shift;
  $self->{'PayPalAccountLevel'} = shift
}

=head2 getPayPalAccountLevel()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PayPalAccountLevelCodeType'

=cut

sub getPayPalAccountLevel {
  my $self = shift;
  return $self->{'PayPalAccountLevel'};
}


=head2 setPayPalAccountStatus()

The user's PayPal account status. Only returned for the user identified in
eBayAuthToken. That is, you cannot see someone else's PayPal account status.
Use this information to check whether a seller is eligible to list digital 
downloadable items. See the eBay Web site online
help for current PayPal requirements for listing digital items.

#    Argument: 'ns:PayPalAccountStatusCodeType'

=cut

sub setPayPalAccountStatus {
  my $self = shift;
  $self->{'PayPalAccountStatus'} = shift
}

=head2 getPayPalAccountStatus()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PayPalAccountStatusCodeType'

=cut

sub getPayPalAccountStatus {
  my $self = shift;
  return $self->{'PayPalAccountStatus'};
}


=head2 setPayPalAccountType()

The user's PayPal account type. Only returned for the user identified in
eBayAuthToken. That is, you cannot see someone else's PayPal account type. Use
this information to check whether a seller is likely to be eligible to 
list digital downloadable items. See the eBay Web site online
help for current PayPal requirements for listing digital items. Please note
that this information cannot necessarily be used to determine whether a seller
is eligible to list items on eBay Express, because a seller can have more than
one PayPal account (and any of these accounts can be used for a given
listing).

#    Argument: 'ns:PayPalAccountTypeCodeType'

=cut

sub setPayPalAccountType {
  my $self = shift;
  $self->{'PayPalAccountType'} = shift
}

=head2 getPayPalAccountType()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PayPalAccountTypeCodeType'

=cut

sub getPayPalAccountType {
  my $self = shift;
  return $self->{'PayPalAccountType'};
}


=head2 setPositiveFeedbackPercent()

Percent of total feedback that is positive. For example, if the member has 50
feedbacks, where 49 are positive and 1 is neutral or negative, the positive
feedback percent could be 98.0. The value uses a max precision of 4 and a
scale of 1. If the user has feedback, this value can be returned regardless of
whether the member has chosen to make their feedback private. Not returned if
the user has no feedback. To be eligible to list on Express, a seller's
feedback percent needs to be 98 or higher. See "eBay Express" in the eBay Web
Services guide. In GetSearchResults and GetCategoryListings, feedback
information is only returned if IncludeFeedback = true in the request.

#    Argument: 'xs:float'

=cut

sub setPositiveFeedbackPercent {
  my $self = shift;
  $self->{'PositiveFeedbackPercent'} = shift
}

=head2 getPositiveFeedbackPercent()

  Calls: GetAllBidders
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetCategoryListings
         GetItem
         GetProducts
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnCategories, ItemReturnAttributes, ReturnAll
           GranularityLevel: Coarse


  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:float'

=cut

sub getPositiveFeedbackPercent {
  my $self = shift;
  return $self->{'PositiveFeedbackPercent'};
}


=head2 setRESTToken()

This token is for the Trading API.
For REST calls, it is recommended that you use
the Shopping API instead of the Trading API.
See <a href="http://developer.ebay.com/products/shopping/" target="_blank">Shopping API</a> for more information.
The RESTToken field contains the REST token (if available) for the user
who is making the request. Not returned
when UserID is for a different user than the one identified in eBayAuthToken.
Use the REST token to authenticate REST API calls in the Trading API.

#    Argument: 'xs:string'

=cut

sub setRESTToken {
  my $self = shift;
  $self->{'RESTToken'} = shift
}

=head2 getRESTToken()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getRESTToken {
  my $self = shift;
  return $self->{'RESTToken'};
}


=head2 setRegistrationAddress()

Registration address for a user.<br>
<br>
<b>GetUser:</b> eBay returns complete
RegistrationAddress details (including Phone), as applicable to the
registration site, when you retrieve your own user data. <br>
<br>
<b>GetItem:</b> RegistrationAddress for another user
(except for Phone) is only returned
if you have a transactional relationship with that user AND that user is
registered on DE/AT/CH, regardless of your registration site and
the site to which you send the request. For example, the seller
can see the buyer's registration address if the buyer is
registered on DE/AT/CH, or the buyer can see the seller's
registration address if the seller is registered on DE/AT/CH.
(The buyer and seller won't see their own registration addresses
in GetItem.) <br>
<br>
To be eligible to list on Express US, a seller's
registration address must be in the US or Canada. To list on Express Germany,
a seller's registration address must be in Germany. See "eBay Express" in the
eBay Web Services guide.
<p></p>
<span class="tablenote"><b>Note:</b>
At the end of April 2008, UK and Germany eBay Express will be shutdown. No
users will be eligible to list on these sites. All users previously registered
on UK and Germany Express will have their registered status revoked. Any
Express only items listed on these sites will be ended and credited the full
insertion fee to their sellers. Please refer to the respective Express sites
for more information.
</span>

#    Argument: 'ns:AddressType'

=cut

sub setRegistrationAddress {
  my $self = shift;
  $self->{'RegistrationAddress'} = shift
}

=head2 getRegistrationAddress()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: Seller
           HighBidder

#    Returns: 'ns:AddressType'

=cut

sub getRegistrationAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RegistrationAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setRegistrationDate()

Indicates the date the specified user originally registered with eBay.
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:dateTime'

=cut

sub setRegistrationDate {
  my $self = shift;
  $self->{'RegistrationDate'} = shift
}

=head2 getRegistrationDate()

  Calls: GetBestOffers
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller
           HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:dateTime'

=cut

sub getRegistrationDate {
  my $self = shift;
  return $self->{'RegistrationDate'};
}


=head2 setSellerInfo()

Contains information about the user as a seller, such as whether the seller is
authorized to list Live Auction items or opts to have items cross-promoted. <br><br>This field is replaced by the SellerBusinessType field if the user is a business seller with a site ID of 77 (Germany), 3 (UK), 205 (Ireland) or 100 (Motors).
<br><br>See SellerType or SellerBusinessCodeType for the child elements.

#    Argument: 'ns:SellerType'

=cut

sub setSellerInfo {
  my $self = shift;
  $self->{'SellerInfo'} = shift
}

=head2 getSellerInfo()

  Calls: GetBidderList
  Returned: Always
  Context: Seller

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Coarse, Medium, Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

#    Returns: 'ns:SellerType'

=cut

sub getSellerInfo {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerInfo'
		,'eBay::API::XML::DataType::SellerType');
}


=head2 setSellerPaymentMethod()

Indicates the method the seller selected to pay eBay with for the account.
The payment methods vary from one eBay site to the next.
Payment methods are enumerated in the SellerPaymentMethodCodeType code
list.

#    Argument: 'ns:SellerPaymentMethodCodeType'

=cut

sub setSellerPaymentMethod {
  my $self = shift;
  $self->{'SellerPaymentMethod'} = shift
}

=head2 getSellerPaymentMethod()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SellerPaymentMethodCodeType'

=cut

sub getSellerPaymentMethod {
  my $self = shift;
  return $self->{'SellerPaymentMethod'};
}


=head2 setSite()

eBay site the user is registered with.
To be eligible to list on Express US, a seller must be registered
on the eBay US or Canada site. To be eligible to list on Express Germany,
a seller must registered on the eBay Germany site. See "eBay Express"
in the eBay Web Services guide.
<p></p>
<span class="tablenote"><b>Note:</b>
At the end of April 2008, UK and Germany eBay Express will be shutdown. No
users will be eligible to list on these sites. All users previously registered
on UK and Germany Express will have their registered status revoked. Any
Express only items listed on these sites will be ended and credited the full
insertion fee to their sellers. Please refer to the respective Express sites
for more information.
</span>
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'ns:SiteCodeType'

=cut

sub setSite {
  my $self = shift;
  $self->{'Site'} = shift
}

=head2 getSite()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'ns:SiteCodeType'

=cut

sub getSite {
  my $self = shift;
  return $self->{'Site'};
}


=head2 setSiteVerified()

No longer used.

Ignore: 
#    Argument: 'xs:boolean'

=cut

sub setSiteVerified {
  my $self = shift;
  $self->{'SiteVerified'} = shift
}

=head2 isSiteVerified()

#    Returns: 'xs:boolean'

=cut

sub isSiteVerified {
  my $self = shift;
  return $self->{'SiteVerified'};
}


=head2 setSkypeID()

Indicates the Skype name of the user. Available if
the seller has a Skype account and has linked it (on the eBay site)
with his or her eBay account.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setSkypeID {
  my $self = shift;
  $self->{'SkypeID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSkypeID()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getSkypeID {
  my $self = shift;
  return $self->_getDataTypeArray('SkypeID');
}


=head2 setStatus()

Indicates the user's registration/user status.
To be eligible to list on Express, a seller's status must be Confirmed.
See "eBay Express" in the eBay Web Services guide.

#    Argument: 'ns:UserStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport

  Calls: GetUser
  Returned: Conditionally
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetItem
  Returned: Conditionally
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ItemReturnDescription,
							ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  AllValuesExcept: UnconfirmedPassport,
								CreditCardVerifyPassport
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'ns:UserStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setTUVLevel()

TUV level is a number allocated to a user based on various characteristics
such as buyer, seller, new buyer, new seller, high risk, or bid limit.
Applies to eBay Motors Pro applications only.

TheseSites: AU, DE, FR, IT, UK

#    Argument: 'xs:int'

=cut

sub setTUVLevel {
  my $self = shift;
  $self->{'TUVLevel'} = shift
}

=head2 getTUVLevel()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getTUVLevel {
  my $self = shift;
  return $self->{'TUVLevel'};
}


=head2 setUniqueNegativeFeedbackCount()

Total count of negative Feedback entries received by the user, including weekly repeats.

#    Argument: 'xs:int'

=cut

sub setUniqueNegativeFeedbackCount {
  my $self = shift;
  $self->{'UniqueNegativeFeedbackCount'} = shift
}

=head2 getUniqueNegativeFeedbackCount()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniqueNegativeFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNegativeFeedbackCount'};
}


=head2 setUniqueNeutralFeedbackCount()

Total count of neutral Feedback entries received by the user, including weekly repeats.

#    Argument: 'xs:int'

=cut

sub setUniqueNeutralFeedbackCount {
  my $self = shift;
  $self->{'UniqueNeutralFeedbackCount'} = shift
}

=head2 getUniqueNeutralFeedbackCount()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniqueNeutralFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNeutralFeedbackCount'};
}


=head2 setUniquePositiveFeedbackCount()

Total count of positive Feedback entries received by the user, including weekly repeats.
Contains the aggregate feedback score for a user. A member's feedback score is
the net positive feedback minus the net negative feedback left for the member.
Feedback scores are a quantitative expression of the desirability of dealing
with that person as a Buyer or a Seller in auction transactions. Each auction
transaction can result in one feedback entry for a given user (the buyer can
leave feedback for the seller, and the seller can leave feedback for the
buyer.). That one feedback can be positive, negative, or neutral. The
aggregated feedback counts for a particular user represent that user's overall
feedback score (referred to as a "feedback rating" on the eBay site). This
rating is commonly expressed as the eBay Feedback score for the user.

#    Argument: 'xs:int'

=cut

sub setUniquePositiveFeedbackCount {
  my $self = shift;
  $self->{'UniquePositiveFeedbackCount'} = shift
}

=head2 getUniquePositiveFeedbackCount()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:int'

=cut

sub getUniquePositiveFeedbackCount {
  my $self = shift;
  return $self->{'UniquePositiveFeedbackCount'};
}


=head2 setUserAnonymized()

Indicates whether or not the User container has been made
anonymous. If true, some elements in the User container have
either been removed, or had their values changed to remove
identifying characteristics. If false, all expected elements
are returned, and no values are changed.
<br><br>
Since a bidder's user info is anonymous, this tag is returned as false
only to the bidder, and to the seller of an item that the user is bidding
on. For all other users, this tag is returned as true.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:boolean'

=cut

sub setUserAnonymized {
  my $self = shift;
  $self->{'UserAnonymized'} = shift
}

=head2 isUserAnonymized()

  Calls: GetAllBidders
         GetHighBidders
         GetSellerEvents
  Returned: Always

  Calls: GetSellerList
  Returned: Always
  Details: GranularityLevel: Fine

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: HighBidder

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isUserAnonymized {
  my $self = shift;
  return $self->{'UserAnonymized'};
}


=head2 setUserID()

Unique eBay user ID for the user.<br>
<br>
In GetSearchResultsExpress, only returned when ItemDetails is set to Fine.
<br><br>
Since a bidder's user info is anonymous, this tag will contain the real ID
value only for that bidder, and the seller of an item that the user is bidding
on. For all other users, the real ID value will be replaced with the anonymous
value, according to these rules:
<br><br>
When bidding on items listed on the US site: UserID is replaced with the value
"a****b" where a and b are random characters from the UserID. For example, if
the UserID = IBidALot, it might be displayed as, "I****A".
<br>
Note that in this format, the anonymous bidder ID stays the same for every
auction.
<br><br>
(GetMyeBayBuying only) when bidding on items listed on the US site: UserID is
replaced with the value "a****b" where a and b are random characters from the
UserID.
<br><br>
When bidding on items listed on the the UK and AU sites: UserID is replaced
with the value "Bidder X" where X is a number indicating the order of that
user's first bid. For example, if the user was the third bidder, UserID =
Bidder 3.
<br>
Note that in this format, the anonymous bidder ID stays the same for a given
auction, but is different for different auctions. For example, a bidder who is
the third and then the seventh bidder in an auction will be listed for both
bids as "Bidder 3". However, if that same bidder is the first bidder on a
different auction, the bidder will be listed for that auction as "Bidder 1",
not "Bidder 3".
<br><br>
(GetMyeBayBuying only) when bidding on items listed on the UK and AU sites:
UserID is replaced with the string "High Bidder".
<br><br>
(GetSearchResults only)When IncludeFeedback is set to true in GetSearchResults request, the call response returns the seller's User ID. Please note seller's UserID is not anonymized.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

  Calls: PlaceOffer
  Returned: Always

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Conditionally

  Calls: GetBestOffers
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetItemsAwaitingFeedback
  Returned: Conditionally
  Context: Buyer

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           SoldList
           BidList

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}


=head2 setUserIDChanged()

If true, identifies a user whose ID has changed within the last 30 days. Does not
indicate a new user (see NewUser).
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:boolean'

=cut

sub setUserIDChanged {
  my $self = shift;
  $self->{'UserIDChanged'} = shift
}

=head2 isUserIDChanged()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:boolean'

=cut

sub isUserIDChanged {
  my $self = shift;
  return $self->{'UserIDChanged'};
}


=head2 setUserIDLastChanged()

Date and time the user's data was last changed (in GMT).
<br><br>
Since a bidder's user info is anonymous, this tag will be returned only to that bidder, and to the seller of an item that the user is bidding on.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo
Title: Working with Anonymous User Information

#    Argument: 'xs:dateTime'

=cut

sub setUserIDLastChanged {
  my $self = shift;
  $self->{'UserIDLastChanged'} = shift
}

=head2 getUserIDLastChanged()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:dateTime'

=cut

sub getUserIDLastChanged {
  my $self = shift;
  return $self->{'UserIDLastChanged'};
}


=head2 setUserSubscription()

Specifies the subscription level for a user.

#    Argument: reference to an array  
                      of 'ns:EBaySubscriptionTypeCodeType'

=cut

sub setUserSubscription {
  my $self = shift;
  $self->{'UserSubscription'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getUserSubscription()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: reference to an array  
                      of 'ns:EBaySubscriptionTypeCodeType'

=cut

sub getUserSubscription {
  my $self = shift;
  return $self->_getDataTypeArray('UserSubscription');
}


=head2 setVATID()

The value added tax identifier (VATID) is applicable to the VAT-enabled
sites.
Applies to eBay Motors Pro applications only.

TheseSites: AU, DE, FR, IT, UK

#    Argument: 'xs:string'

=cut

sub setVATID {
  my $self = shift;
  $self->{'VATID'} = shift
}

=head2 getVATID()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:string'

=cut

sub getVATID {
  my $self = shift;
  return $self->{'VATID'};
}


=head2 setVATStatus()

Indicates whether or not the user is subject to VAT.
Users who have registered with eBay as VAT-exempt are not
subject to VAT. See documentation on Value-Added Tax (VAT).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=VATStatus
Title: VAT-exempt Sellers

#    Argument: 'ns:VATStatusCodeType'

=cut

sub setVATStatus {
  my $self = shift;
  $self->{'VATStatus'} = shift
}

=head2 getVATStatus()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'ns:VATStatusCodeType'

=cut

sub getVATStatus {
  my $self = shift;
  return $self->{'VATStatus'};
}


=head2 setEBayGoodStanding()

If true, indicates that the user is in good standing with eBay.

#    Argument: 'xs:boolean'

=cut

sub setEBayGoodStanding {
  my $self = shift;
  $self->{'eBayGoodStanding'} = shift
}

=head2 isEBayGoodStanding()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: Seller

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: HighBidder

  Calls: GetSellerList
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll
  Context: Seller

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: Buyer

#    Returns: 'xs:boolean'

=cut

sub isEBayGoodStanding {
  my $self = shift;
  return $self->{'eBayGoodStanding'};
}


=head2 setEBayWikiReadOnly()

Indicates whether a user has read-only access to the eBay Wiki (true)
or whether the user is able contribute or edit articles on the eBay Wiki
(false). By default, all registered eBay users have access to contribute and
edit articles on the eBay Wiki. All content contributed to the eBay Wiki is
subject to the Community Content Policy.

Default: false

#    Argument: 'xs:boolean'

=cut

sub setEBayWikiReadOnly {
  my $self = shift;
  $self->{'eBayWikiReadOnly'} = shift
}

=head2 isEBayWikiReadOnly()

  Calls: GetUser
  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isEBayWikiReadOnly {
  my $self = shift;
  return $self->{'eBayWikiReadOnly'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
