# This Makefile.PL for POE-Loop-Mojo_IOLoop was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.33.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.010001;
use ExtUtils::MakeMaker;

use POE::Test::Loops 1.360;

my %WriteMakefileArgs = (
  "ABSTRACT" => "a bridge that allows POE to be driven by Mojo::IOLoop",
  "AUTHOR" => "Dan Book <dbook\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "POE::Test::Loops" => "1.360"
  },
  "DISTNAME" => "POE-Loop-Mojo_IOLoop",
  "EXE_FILES" => [],
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.010001",
  "NAME" => "POE::Loop::Mojo_IOLoop",
  "PREREQ_PM" => {
    "Mojolicious" => "5.70",
    "POE" => "1.366",
    "Scalar::Util" => 0,
    "Time::HiRes" => 0
  },
  "TEST_REQUIRES" => {
    "POE::Test::Loops" => "1.360",
    "Test::More" => "0.47"
  },
  "VERSION" => "0.001",
  "test" => {
    "TESTS" => "t/*.t t/*/*/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    (clean => { FILES => 't/30_loops/*/* t/30_loops/* t/30_loops' }),
);

my %FallbackPrereqs = (
  "ExtUtils::MakeMaker" => 0,
  "Mojolicious" => "5.70",
  "POE" => "1.366",
  "POE::Test::Loops" => "1.360",
  "Scalar::Util" => 0,
  "Test::More" => "0.47",
  "Time::HiRes" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# Switch to default behavior if STDIN isn't a tty.
unless (-t STDIN) {
  warn(
    "\n",
    "=============================================\n\n",
    "STDIN is not a terminal.  Assuming --default.\n\n",
    "=============================================\n\n",
  );
  push @ARGV, "--default";
}
# Remind the user she can use --default.
unless (grep /^--default$/, @ARGV) {
  warn(
    "\n",
    "=============================================\n\n",
    "Prompts may be bypassed by running:\n",
    "   $^X $0 --default\n\n",
    "=============================================\n\n",
  );
}
# Should we skip the network tests?
my $prompt = (
  "Some of POE's tests require a functional network.\n" .
  "You can skip these tests if you'd like.\n\n" .
  "Would you like to skip the network tests?"
);
my $ret = "n";
if (grep /^--default$/, @ARGV) {
  print $prompt, " [$ret] $ret\n\n";
}
else {
  $ret = prompt($prompt, "n");
}
my $marker = 'run_network_tests';
unlink $marker;
unless ($ret =~ /^Y$/i) {
  open(TOUCH,"+>$marker") and close TOUCH;
}
print "\n";
POE::Test::Loops::generate('t/30_loops', ['Mojo::IOLoop','Mojo::IOLoop::Tester::EV'], 0);
