package Net::Amazon::EMR::InstanceStateChangeReason;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

subtype 'Net::Amazon::EMR::Type::InstanceStateChangeReason::Code' => as 'Str' => where { m/^(?:INTERNAL_ERROR | VALIDATION_ERROR | INSTANCE_FAILURE | BOOTSTRAP_FAILURE | CLUSTER_TERMINATED)$/x };

has 'Code' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::InstanceStateChangeReason::Code',
);

has 'Message' => ( is => 'ro', 
                   isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceStateChangeReason

=head1 DESCRIPTION

Implements the InstanceStateChangeReason data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceStateChangeReason.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
