use strict;
use warnings;
use utf8;

use Test::More tests => 1;

use String::Copyright;

#is( ( 0 + copyright( "foo" ) ), 0, 'non-copyright string numeric is zero' );

my $string = copyright(<<'END');
© 1999,2000,2003 Foo Barbaz <foo@bar.baz> and Acme Corp.
© 2000, 2002 Foo Barbaz and Acme Corp.
Copyright 2003, Foo and friends
Copyright 2004, friends of Foo
Copyright (c) 2001,2004 Foo Barbaz (really) <foo@bar.baz>
END

#my $parser = copyright(
#	alias => { 'foo@bar.baz' => ['fb@acme.corp'] },
#	mangle => ['s/Foo \Kand friends/foo@bar.baz and friends of Foo/'],
#);

my $expected = [
	'1999-2000, 2003 Foo Barbaz <foo@bar.baz> and Acme Corp.',
	'2000, 2002 Foo Barbaz and Acme Corp.',
	'2003, Foo and friends',
	'2004, friends of Foo',
	'2001, 2004 Foo Barbaz (really) <foo@bar.baz>',
];

is_deeply $string->blocks, $expected, 'resolve parts';

