use strictures 2;

use Test::Roo;
use App::Licensecheck;

has encoding => ( is => 'ro' );
has license  => ( is => 'ro', required => 1 );
has corpus   => ( is => 'ro' );

sub _build_description { return shift->license }

test "Parse corpus" => sub {
	my $self = shift;

	my $app = App::Licensecheck->new;
	$app->lines(0);
	$app->deb_fmt(1);
	$app->encoding( $self->encoding ) if $self->encoding;

	foreach (
		ref( $self->corpus ) eq 'ARRAY' ? @{ $self->corpus } : $self->corpus )
	{
		my ( $license, $copyright ) = $app->parse("t/grant/$_");
		is( $license, $self->license, "Corpus file $_" );
	}
};

# GPL
run_me(
	{   license => 'CC-BY-SA',
		corpus  => 'GPL_and_more/init.lua'
	}
);

# AGPL
run_me( { license => 'AGPL-3+', corpus => 'AGPL/fastx.c' } );
run_me( { license => 'AGPL-3+', corpus => 'AGPL/fet.cpp' } );
run_me( { license => 'AGPL-3+', corpus => 'AGPL/setup.py' } );

# Apache
run_me(
	{ license => 'Apache-2.0 or GPL-2', corpus => 'Apache_and_more/PIE.htc' }
);
run_me(
	{   license => 'Apache-2.0 or Expat',
		corpus  => 'Apache_and_more/rust.lang'
	}
);
run_me(
	{   license => 'Apache-2.0 or GPL-2',
		corpus  => 'Apache_and_more/select2.js'
	}
);
run_me(
	{   license => 'Apache-2.0 or BSD-3-clause',
		corpus  => 'Apache_and_more/test_run.py'
	}
);

# CC-BY-SA
run_me(
	{   license => 'CC-BY-SA-3.0',
		corpus  => 'CC-BY-SA_and_more/WMLA'
	}
);
run_me(
	{   license => 'CC-BY-SA-2.0 or GPL-3',
		corpus  => 'CC-BY-SA_and_more/cewl.rb'
	}
);
run_me(
	{   license => 'CC-BY-SA-3.0 or LGPL-2',
		corpus  => 'CC-BY-SA_and_more/utilities.scad'
	}
);

# EPL
run_me(
	{   license => 'AGPL-3+ and/or LGPL-2.1 and/or Apache-2.0+',
		corpus  => 'EPL_and_more/Base64Coder.java'
	}
);

done_testing;
