
package Paws::GameLift::UpdateRuntimeConfiguration;
  use Moose;
  has FleetId => (is => 'ro', isa => 'Str', required => 1);
  has RuntimeConfiguration => (is => 'ro', isa => 'Paws::GameLift::RuntimeConfiguration', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateRuntimeConfiguration');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::GameLift::UpdateRuntimeConfigurationOutput');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::UpdateRuntimeConfiguration - Arguments for method UpdateRuntimeConfiguration on Paws::GameLift

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateRuntimeConfiguration on the 
Amazon GameLift service. Use the attributes of this class
as arguments to method UpdateRuntimeConfiguration.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateRuntimeConfiguration.

As an example:

  $service_obj->UpdateRuntimeConfiguration(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FleetId => Str

Unique identifier for a fleet to update run-time configuration for.



=head2 B<REQUIRED> RuntimeConfiguration => L<Paws::GameLift::RuntimeConfiguration>

Instructions for launching server processes on each instance in the
fleet. The run-time configuration for a fleet has a collection of
server process configurations, one for each type of server process to
run on an instance. A server process configuration specifies the
location of the server executable, launch parameters, and the number of
concurrent processes with that configuration to maintain on each
instance.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateRuntimeConfiguration in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

