use Mojo::Base -strict;

use Test::More;
use Mojolicious::Lite;
use Test::Mojo;

plugin 'SecurityHeader' => [
    'Referrer-Policy',
    'Strict-Transport-Security' => -1,
];

get '/' => sub {
  my $c = shift;
  $c->render(text => 'Hello Mojo!');
};

my $t = Test::Mojo->new;
$t->get_ok('/')->status_is(200)
  ->header_is( 'Strict-Transport-Security', 'max-age=31536000' )
  ->header_is( 'Referrer-Policy', '' );

done_testing();
