/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONSerializer;
import org.couchbase.mock.views.Configuration;
import org.couchbase.mock.views.View;

public class Reducer {
    private final String body;
    private final ScriptEngine engine;

    public Reducer(ScriptEngine engine, String body) {
        this.engine = engine;
        this.body = body;
    }

    public ArrayList execute(ArrayList rows, Configuration config) throws ScriptException {
        if (this.body.startsWith("_count")) {
            return this.executeCount(rows, config);
        }
        if (this.body.startsWith("_sum")) {
            return this.executeSum(rows, config);
        }
        if (this.body.startsWith("_stats")) {
            return this.executeStats(rows, config);
        }
        return this.executeJS(rows, config);
    }

    private HashMap<Object, ReduceEntry> toReduceParams(ArrayList rows, Configuration config) {
        HashMap<Object, ReduceEntry> res = new HashMap<Object, ReduceEntry>();
        for (HashMap row : rows) {
            JSON json;
            String key = null;
            if (config.isGroup()) {
                key = (String)row.get("key");
            }
            if (config.getGroupLevel() > 0 && (json = JSONSerializer.toJSON(row.get("key"))) instanceof JSONArray) {
                ArrayList<Object> acc = new ArrayList<Object>();
                for (int i = 0; i < config.getGroupLevel() && i < json.size(); ++i) {
                    acc.add(((JSONArray)json).get(i));
                }
                key = JSONArray.fromObject(acc).toString();
            }
            if (!res.containsKey(key)) {
                res.put(key, new ReduceEntry());
            }
            res.get(key).add(row.get("key"), row.get("id"), row.get("value"));
        }
        return res;
    }

    private ArrayList executeJS(ArrayList rows, Configuration config) throws ScriptException {
        ArrayList res = new ArrayList();
        for (Map.Entry<Object, ReduceEntry> entry : this.toReduceParams(rows, config).entrySet()) {
            JSON group = JSONSerializer.toJSON(entry.getKey());
            JSON[] params = new JSON[]{JSONSerializer.toJSON(entry.getValue().keys), JSONSerializer.toJSON(entry.getValue().values)};
            Object value = View.fromNativeObject(this.engine.eval("(" + this.body + ")(" + params[0].toString() + ", " + params[1].toString() + ", false)"));
            HashMap<String, Object> reduced = new HashMap<String, Object>();
            reduced.put("key", group);
            reduced.put("value", value);
            res.add(reduced);
        }
        return res;
    }

    private ArrayList executeCount(ArrayList rows, Configuration config) {
        ArrayList res = new ArrayList();
        for (Map.Entry<Object, ReduceEntry> entry : this.toReduceParams(rows, config).entrySet()) {
            JSON group = JSONSerializer.toJSON(entry.getKey());
            HashMap<String, Serializable> reduced = new HashMap<String, Serializable>();
            reduced.put("key", group);
            reduced.put("value", Integer.valueOf(entry.getValue().values.size()));
            res.add(reduced);
        }
        return res;
    }

    private ArrayList executeSum(ArrayList rows, Configuration config) {
        ArrayList res = new ArrayList();
        for (Map.Entry<Object, ReduceEntry> entry : this.toReduceParams(rows, config).entrySet()) {
            JSON group = JSONSerializer.toJSON(entry.getKey());
            HashMap<String, Serializable> reduced = new HashMap<String, Serializable>();
            reduced.put("key", group);
            double sum = 0.0;
            for (Object val : entry.getValue().values) {
                sum += ((Number)val).doubleValue();
            }
            reduced.put("value", Double.valueOf(sum));
            res.add(reduced);
        }
        return res;
    }

    private ArrayList executeStats(ArrayList rows, Configuration config) {
        ArrayList res = new ArrayList();
        for (Map.Entry<Object, ReduceEntry> entry : this.toReduceParams(rows, config).entrySet()) {
            JSON group = JSONSerializer.toJSON(entry.getKey());
            HashMap<String, Serializable> reduced = new HashMap<String, Serializable>();
            reduced.put("key", group);
            ArrayList values = entry.getValue().values;
            double sum = 0.0;
            int count = values.size();
            double min = 0.0;
            double max = 0.0;
            double sumsqr = 0.0;
            if (count > 0) {
                min = max = ((Number)values.get(0)).doubleValue();
            }
            for (Object val : entry.getValue().values) {
                double d = ((Number)val).doubleValue();
                sum += d;
                sumsqr += Math.pow(d, 2.0);
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
            HashMap<String, Number> stats = new HashMap<String, Number>();
            stats.put("sum", sum);
            stats.put("max", max);
            stats.put("min", min);
            stats.put("count", count);
            stats.put("sumsqr", sumsqr);
            reduced.put("value", stats);
            res.add(reduced);
        }
        return res;
    }

    private class ReduceEntry {
        public ArrayList keys = new ArrayList();
        public ArrayList values = new ArrayList();

        private ReduceEntry() {
        }

        public void add(Object key, Object id, Object value) {
            JSONArray json = new JSONArray();
            json.add(key);
            json.add(id);
            this.keys.add(json);
            this.values.add(value);
        }
    }
}

