package Perl::ToPerl6::Exception::Configuration::NonExistentTransformer;

use 5.006001;
use strict;
use warnings;

use Readonly;

our $VERSION = '0.031';

#-----------------------------------------------------------------------------

use Exception::Class (
    'Perl::ToPerl6::Exception::Configuration::NonExistentTransformer' => {
        isa         => 'Perl::ToPerl6::Exception::Configuration',
        description => 'The configuration referred to a non-existant transformer.',
        fields      => [ qw{ transformer } ],
    },
);

#-----------------------------------------------------------------------------

Readonly::Array our @EXPORT_OK => qw< throw_extra_parameter >;

#-----------------------------------------------------------------------------

sub full_message {
    my ( $self ) = @_;

    my $transformer = $self->transformer();

    return qq<There is no $transformer transformer installed.>;
}


1;

__END__

#-----------------------------------------------------------------------------

=pod

=for stopwords

=head1 NAME

Perl::ToPerl6::Exception::Configuration::NonExistentTransformer - The configuration referred to a non-existent transformer.

=head1 DESCRIPTION

A representation of the configuration attempting to specify a
L<Perl::ToPerl6::Transformer|Perl::ToPerl6::Transformer> that is not known, whether from a
F<.perlmogrifyrc>, another profile file, or command line.


=head1 INTERFACE SUPPORT

This is considered to be a public class.  Any changes to its interface
will go through a deprecation cycle.


=head1 CLASS METHODS

=over

=item C<< throw( transformer => $transformer ) >>

See L<Exception::Class/"throw">.


=item C<< new( transformer => $transformer ) >>

See L<Exception::Class/"new">.


=back


=head1 METHODS

=over

=item C<full_message()>

Provide a standard message.  See L<Exception::Class/"full_message">.


=back


=head1 AUTHOR

Elliot Shank <perl@galumph.com>

=head1 COPYRIGHT

Copyright (c) 2007-2011 Elliot Shank.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.  The full text of this license
can be found in the LICENSE file included with this module.

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 78
#   indent-tabs-mode: nil
#   c-indentation-style: bsd
# End:
# ex: set ts=8 sts=4 sw=4 tw=78 ft=perl expandtab shiftround :
