package Auth::Kokolores::Response;

use Moose;

# ABSTRACT: saslauthd protocol response object
our $VERSION = '1.00'; # VERSION

use overload
  q{""}    => sub { $_[0]->as_string },
  fallback => 1;

has 'message' => ( is => 'ro', isa => 'Str', required => 1 );

sub as_string {
  my $self = shift;
  my $size = length($self->message) + 1;
  return pack("nA$size", $size, $self->message."\0");
}

sub new_OK {
  return shift->new( message => 'OK' );
}
sub new_NO {
  return shift->new( message => 'NO' );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Auth::Kokolores::Response - saslauthd protocol response object

=head1 VERSION

version 1.00

=head1 AUTHOR

Markus Benning <ich@markusbenning.de>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Markus Benning <ich@markusbenning.de>.

This is free software, licensed under:

  The GNU General Public License, Version 2, June 1991

=cut
