# Marpa::R3 is Copyright (C) 2017, Jeffrey Kegler.
#
# This module is free software; you can redistribute it and/or modify it
# under the same terms as Perl 5.10.1. For more details, see the full text
# of the licenses in the directory LICENSES.
#
# This program is distributed in the hope that it will be
# useful, but it is provided "as is" and without any express
# or implied warranties. For details, see the full text of
# of the licenses in the directory LICENSES.

package Marpa::R3::MetaG;

use 5.010001;
use strict;
use warnings;

use vars qw($VERSION $STRING_VERSION);
$VERSION        = '4.001_050';
$STRING_VERSION = $VERSION;
## no critic(BuiltinFunctions::ProhibitStringyEval)
$VERSION = eval $VERSION;
## use critic

package Marpa::R3::Internal::MetaG;

use English qw( -no_match_vars );

sub hashed_grammar {
    my $hashed_metag;

## no critic(RegularExpressions::RequireDotMatchAnything)
## no critic(RegularExpressions::RequireExtendedFormatting)
## no critic(RegularExpressions::RequireLineBoundaryMatching)
## no critic(RegularExpressions::ProhibitEscapedMetacharacters)
## no critic(RegularExpressions::ProhibitComplexRegexes)

## The following auto-generated code is obtained from this command:
##     cat meta/metag.pl
##
## The code after this line was automatically generated by sl_to_hash.pl
$hashed_metag = {
                  'character_classes' => {
                                           '[[\']]' => [
                                                         '[\']',
                                                         ''
                                                       ],
                                           '[[+-]]' => [
                                                         '[+-]',
                                                         ''
                                                       ],
                                           '[[,]]' => [
                                                        '[,]',
                                                        ''
                                                      ],
                                           '[[01]]' => [
                                                         '[01]',
                                                         ''
                                                       ],
                                           '[[1]]' => [
                                                        '[1]',
                                                        ''
                                                      ],
                                           '[[[:alnum:]]]' => [
                                                                '[[:alnum:]]',
                                                                ''
                                                              ],
                                           '[[\\#]]' => [
                                                          '[\\#]',
                                                          ''
                                                        ],
                                           '[[\\(]]' => [
                                                          '[\\(]',
                                                          ''
                                                        ],
                                           '[[\\)]]' => [
                                                          '[\\)]',
                                                          ''
                                                        ],
                                           '[[\\*]]' => [
                                                          '[\\*]',
                                                          ''
                                                        ],
                                           '[[\\+]]' => [
                                                          '[\\+]',
                                                          ''
                                                        ],
                                           '[[\\,]]' => [
                                                          '[\\,]',
                                                          ''
                                                        ],
                                           '[[\\-]]' => [
                                                          '[\\-]',
                                                          ''
                                                        ],
                                           '[[\\:]]' => [
                                                          '[\\:]',
                                                          ''
                                                        ],
                                           '[[\\;]]' => [
                                                          '[\\;]',
                                                          ''
                                                        ],
                                           '[[\\<]]' => [
                                                          '[\\<]',
                                                          ''
                                                        ],
                                           '[[\\=]]' => [
                                                          '[\\=]',
                                                          ''
                                                        ],
                                           '[[\\>]]' => [
                                                          '[\\>]',
                                                          ''
                                                        ],
                                           '[[\\[]]' => [
                                                          '[\\[]',
                                                          ''
                                                        ],
                                           '[[\\\\]]' => [
                                                           '[\\\\]',
                                                           ''
                                                         ],
                                           '[[\\]]]' => [
                                                          '[\\]]',
                                                          ''
                                                        ],
                                           '[[\\^]]' => [
                                                          '[\\^]',
                                                          ''
                                                        ],
                                           '[[\\d]]' => [
                                                          '[\\d]',
                                                          ''
                                                        ],
                                           '[[\\s\\w]]' => [
                                                             '[\\s\\w]',
                                                             ''
                                                           ],
                                           '[[\\s]]' => [
                                                          '[\\s]',
                                                          ''
                                                        ],
                                           '[[\\w]]' => [
                                                          '[\\w]',
                                                          ''
                                                        ],
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                 '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 ''
                                                                                               ],
                                           '[[\\{]]' => [
                                                          '[\\{]',
                                                          ''
                                                        ],
                                           '[[\\|]]' => [
                                                          '[\\|]',
                                                          ''
                                                        ],
                                           '[[\\}]]' => [
                                                          '[\\}]',
                                                          ''
                                                        ],
                                           '[[\\~]]' => [
                                                          '[\\~]',
                                                          ''
                                                        ],
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                 '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                 ''
                                                                                                               ],
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                      '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                      ''
                                                                                                                    ],
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                  '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                  ''
                                                                                                ],
                                           '[[a-zA-Z]]' => [
                                                             '[a-zA-Z]',
                                                             ''
                                                           ],
                                           '[[a]]' => [
                                                        '[a]',
                                                        ''
                                                      ],
                                           '[[b]]' => [
                                                        '[b]',
                                                        ''
                                                      ],
                                           '[[c]]' => [
                                                        '[c]',
                                                        ''
                                                      ],
                                           '[[d]]' => [
                                                        '[d]',
                                                        ''
                                                      ],
                                           '[[e]]' => [
                                                        '[e]',
                                                        ''
                                                      ],
                                           '[[f]]' => [
                                                        '[f]',
                                                        ''
                                                      ],
                                           '[[g]]' => [
                                                        '[g]',
                                                        ''
                                                      ],
                                           '[[h]]' => [
                                                        '[h]',
                                                        ''
                                                      ],
                                           '[[i]]' => [
                                                        '[i]',
                                                        ''
                                                      ],
                                           '[[k]]' => [
                                                        '[k]',
                                                        ''
                                                      ],
                                           '[[l]]' => [
                                                        '[l]',
                                                        ''
                                                      ],
                                           '[[m]]' => [
                                                        '[m]',
                                                        ''
                                                      ],
                                           '[[n]]' => [
                                                        '[n]',
                                                        ''
                                                      ],
                                           '[[o]]' => [
                                                        '[o]',
                                                        ''
                                                      ],
                                           '[[p]]' => [
                                                        '[p]',
                                                        ''
                                                      ],
                                           '[[r]]' => [
                                                        '[r]',
                                                        ''
                                                      ],
                                           '[[s]]' => [
                                                        '[s]',
                                                        ''
                                                      ],
                                           '[[t]]' => [
                                                        '[t]',
                                                        ''
                                                      ],
                                           '[[u]]' => [
                                                        '[u]',
                                                        ''
                                                      ],
                                           '[[v]]' => [
                                                        '[v]',
                                                        ''
                                                      ],
                                           '[[w]]' => [
                                                        '[w]',
                                                        ''
                                                      ],
                                           '[[x]]' => [
                                                        '[x]',
                                                        ''
                                                      ],
                                           '[[y]]' => [
                                                        '[y]',
                                                        ''
                                                      ]
                                         },
                  'discard_default_adverbs' => undef,
                  'first_lhs' => 'statements',
                  'lexeme_declarations' => {
                                             'Perl name' => {},
                                             '[:discard:]' => {},
                                             '[Lex-0]' => {},
                                             '[Lex-10]' => {},
                                             '[Lex-11]' => {},
                                             '[Lex-12]' => {},
                                             '[Lex-13]' => {},
                                             '[Lex-14]' => {},
                                             '[Lex-15]' => {},
                                             '[Lex-16]' => {},
                                             '[Lex-17]' => {},
                                             '[Lex-18]' => {},
                                             '[Lex-19]' => {},
                                             '[Lex-1]' => {},
                                             '[Lex-20]' => {},
                                             '[Lex-21]' => {},
                                             '[Lex-22]' => {},
                                             '[Lex-23]' => {},
                                             '[Lex-24]' => {},
                                             '[Lex-25]' => {},
                                             '[Lex-26]' => {},
                                             '[Lex-27]' => {},
                                             '[Lex-28]' => {},
                                             '[Lex-29]' => {},
                                             '[Lex-2]' => {},
                                             '[Lex-30]' => {},
                                             '[Lex-31]' => {},
                                             '[Lex-32]' => {},
                                             '[Lex-33]' => {},
                                             '[Lex-34]' => {},
                                             '[Lex-35]' => {},
                                             '[Lex-36]' => {},
                                             '[Lex-37]' => {},
                                             '[Lex-38]' => {},
                                             '[Lex-39]' => {},
                                             '[Lex-3]' => {},
                                             '[Lex-40]' => {},
                                             '[Lex-41]' => {},
                                             '[Lex-42]' => {},
                                             '[Lex-43]' => {},
                                             '[Lex-44]' => {},
                                             '[Lex-45]' => {},
                                             '[Lex-46]' => {},
                                             '[Lex-47]' => {},
                                             '[Lex-4]' => {},
                                             '[Lex-5]' => {},
                                             '[Lex-6]' => {},
                                             '[Lex-7]' => {},
                                             '[Lex-8]' => {},
                                             '[Lex-9]' => {},
                                             'array descriptor' => {},
                                             'bare name' => {},
                                             'before or after' => {},
                                             'boolean' => {},
                                             'bracketed name' => {},
                                             'character class' => {},
                                             'op declare bnf' => {},
                                             'op declare match' => {},
                                             'op equal priority' => {},
                                             'op loosen' => {},
                                             'reserved action name' => {},
                                             'reserved blessing name' => {},
                                             'reserved event name' => {},
                                             'signed integer' => {},
                                             'single quoted name' => {},
                                             'single quoted string' => {},
                                             'standard name' => {}
                                           },
                  'lexeme_default_adverbs' => {
                                                'action' => '[start,length,value]',
                                                'bless' => '::name'
                                              },
                  'meta' => 1,
                  'rules' => {
                               'g1' => [
                                         {
                                           'action' => '::first',
                                           'lhs' => '[:start:]',
                                           'rhs' => [
                                                      'statements'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,[:start:],statements'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action',
                                           'rhs' => [
                                                      '[Lex-24]',
                                                      '[Lex-25]',
                                                      'action name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,action,[Lex-24],[Lex-25],action name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'Perl name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,action name,Perl name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'array descriptor'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,action name,array descriptor'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'reserved action name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,action name,reserved action name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'action'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,action'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'blessing'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,blessing'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'eager specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,eager specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'event specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,event specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'group association'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,group association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'left association'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,left association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'naming'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,naming'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'null adverb'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,null adverb'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'null ranking specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,null ranking specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'pause specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,pause specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'priority specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,priority specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'proper specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,proper specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'rank specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,rank specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'right association'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,right association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'separator specification'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb item,separator specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb list',
                                           'rhs' => [
                                                      'adverb list items'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb list,adverb list items'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb list items',
                                           'min' => 0,
                                           'rhs' => [
                                                      'adverb item'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,adverb list items,adverb item'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative',
                                           'rhs' => [
                                                      'rhs',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,alternative,rhs,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,alternative name,single quoted name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,alternative name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternatives',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternative'
                                                    ],
                                           'separator' => 'op equal priority',
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,alternatives,alternative'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing',
                                           'rhs' => [
                                                      '[Lex-42]',
                                                      '[Lex-25]',
                                                      'blessing name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,blessing,[Lex-42],[Lex-25],blessing name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing name',
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,blessing name,reserved blessing name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,blessing name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'completion event declaration',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'event initialization',
                                                      '[Lex-10]',
                                                      '[Lex-15]',
                                                      'symbol name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,completion event declaration,[Lex-14],event initialization,[Lex-10],[Lex-15],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'default rule',
                                           'rhs' => [
                                                      '[Lex-7]',
                                                      'op declare bnf',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,default rule,[Lex-7],op declare bnf,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'discard default statement',
                                           'rhs' => [
                                                      '[Lex-11]',
                                                      '[Lex-9]',
                                                      '[Lex-10]',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,discard default statement,[Lex-11],[Lex-9],[Lex-10],adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'discard rule',
                                           'rhs' => [
                                                      '[Lex-12]',
                                                      'op declare match',
                                                      'single symbol',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,discard rule,[Lex-12],op declare match,single symbol,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'eager specification',
                                           'rhs' => [
                                                      '[Lex-32]',
                                                      '[Lex-25]',
                                                      'boolean'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,eager specification,[Lex-32],[Lex-25],boolean'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'empty rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,empty rule,lhs,op declare,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initialization',
                                           'rhs' => [
                                                      'event name',
                                                      'event initializer'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event initialization,event name,event initializer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initializer',
                                           'rhs' => [],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event initializer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initializer',
                                           'rhs' => [
                                                      '[Lex-10]',
                                                      'on or off'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event initializer,[Lex-10],on or off'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'reserved event name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event name,reserved event name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event name,single quoted name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event specification',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      '[Lex-25]',
                                                      'event initialization'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,event specification,[Lex-14],[Lex-25],event initialization'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'group association',
                                           'rhs' => [
                                                      '[Lex-26]',
                                                      '[Lex-25]',
                                                      '[Lex-29]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,group association,[Lex-26],[Lex-25],[Lex-29]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible statement',
                                           'rhs' => [
                                                      '[Lex-18]',
                                                      '[Lex-6]',
                                                      'inaccessible treatment',
                                                      '[Lex-19]',
                                                      '[Lex-9]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,inaccessible statement,[Lex-18],[Lex-6],inaccessible treatment,[Lex-19],[Lex-9]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-20]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,inaccessible treatment,[Lex-20]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-21]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,inaccessible treatment,[Lex-21]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-22]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,inaccessible treatment,[Lex-22]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'left association',
                                           'rhs' => [
                                                      '[Lex-26]',
                                                      '[Lex-25]',
                                                      '[Lex-27]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,left association,[Lex-26],[Lex-25],[Lex-27]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lexeme default statement',
                                           'rhs' => [
                                                      '[Lex-8]',
                                                      '[Lex-9]',
                                                      '[Lex-10]',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,lexeme default statement,[Lex-8],[Lex-9],[Lex-10],adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lexeme rule',
                                           'rhs' => [
                                                      '[Lex-13]',
                                                      'op declare match',
                                                      'symbol',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,lexeme rule,[Lex-13],op declare match,symbol,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lhs',
                                           'rhs' => [
                                                      'symbol name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,lhs,symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'naming',
                                           'rhs' => [
                                                      '[Lex-43]',
                                                      '[Lex-25]',
                                                      'alternative name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,naming,[Lex-43],[Lex-25],alternative name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null adverb',
                                           'rhs' => [
                                                      '[Lex-23]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null adverb,[Lex-23]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-36]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null ranking constant,[Lex-36]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-37]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null ranking constant,[Lex-37]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-34]',
                                                      '[Lex-25]',
                                                      'null ranking constant'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null ranking specification,[Lex-34],[Lex-25],null ranking constant'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-35]',
                                                      '[Lex-33]',
                                                      '[Lex-25]',
                                                      'null ranking constant'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null ranking specification,[Lex-35],[Lex-33],[Lex-25],null ranking constant'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null statement',
                                           'rhs' => [
                                                      '[Lex-0]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,null statement,[Lex-0]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'nulled event declaration',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'event initialization',
                                                      '[Lex-10]',
                                                      '[Lex-16]',
                                                      'symbol name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,nulled event declaration,[Lex-14],event initialization,[Lex-10],[Lex-16],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-40]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,on or off,[Lex-40]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-41]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,on or off,[Lex-41]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'op declare',
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,op declare,op declare bnf'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'op declare',
                                           'rhs' => [
                                                      'op declare match'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,op declare,op declare match'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'parenthesized rhs primary list',
                                           'rhs' => [
                                                      '[Lex-44]',
                                                      'rhs primary list',
                                                      '[Lex-45]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,parenthesized rhs primary list,[Lex-44],rhs primary list,[Lex-45]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'pause specification',
                                           'rhs' => [
                                                      '[Lex-39]',
                                                      '[Lex-25]',
                                                      'before or after'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,pause specification,[Lex-39],[Lex-25],before or after'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'prediction event declaration',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'event initialization',
                                                      '[Lex-10]',
                                                      '[Lex-17]',
                                                      'symbol name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,prediction event declaration,[Lex-14],event initialization,[Lex-10],[Lex-17],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priorities',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternatives'
                                                    ],
                                           'separator' => 'op loosen',
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,priorities,alternatives'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priority rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'priorities'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,priority rule,lhs,op declare,priorities'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priority specification',
                                           'rhs' => [
                                                      '[Lex-38]',
                                                      '[Lex-25]',
                                                      'signed integer'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,priority specification,[Lex-38],[Lex-25],signed integer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'proper specification',
                                           'rhs' => [
                                                      '[Lex-31]',
                                                      '[Lex-25]',
                                                      'boolean'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,proper specification,[Lex-31],[Lex-25],boolean'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantified rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'single symbol',
                                                      'quantifier',
                                                      'adverb list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,quantified rule,lhs,op declare,single symbol,quantifier,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-46]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,quantifier,[Lex-46]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-47]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,quantifier,[Lex-47]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rank specification',
                                           'rhs' => [
                                                      '[Lex-33]',
                                                      '[Lex-25]',
                                                      'signed integer'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rank specification,[Lex-33],[Lex-25],signed integer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rhs,rhs primary'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'parenthesized rhs primary list'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rhs primary,parenthesized rhs primary list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'single quoted string'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rhs primary,single quoted string'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'single symbol'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rhs primary,single symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary list',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,rhs primary list,rhs primary'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'right association',
                                           'rhs' => [
                                                      '[Lex-26]',
                                                      '[Lex-25]',
                                                      '[Lex-28]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,right association,[Lex-26],[Lex-25],[Lex-28]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'separator specification',
                                           'rhs' => [
                                                      '[Lex-30]',
                                                      '[Lex-25]',
                                                      'single symbol'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,separator specification,[Lex-30],[Lex-25],single symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'single symbol',
                                           'rhs' => [
                                                      'character class'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,single symbol,character class'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'single symbol',
                                           'rhs' => [
                                                      'symbol'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,single symbol,symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-3]',
                                                      'op declare bnf',
                                                      'symbol'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,start rule,[Lex-3],op declare bnf,symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-4]',
                                                      '[Lex-5]',
                                                      '[Lex-6]',
                                                      'symbol'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,start rule,[Lex-4],[Lex-5],[Lex-6],symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'completion event declaration'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,completion event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'default rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,default rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'discard default statement'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,discard default statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'discard rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,discard rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'empty rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,empty rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'inaccessible statement'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,inaccessible statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'lexeme default statement'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,lexeme default statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'lexeme rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,lexeme rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'null statement'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,null statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'nulled event declaration'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,nulled event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'prediction event declaration'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,prediction event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'priority rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,priority rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'quantified rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,quantified rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'start rule'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,start rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'statement group'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement,statement group'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement group',
                                           'rhs' => [
                                                      '[Lex-1]',
                                                      'statements',
                                                      '[Lex-2]'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statement group,[Lex-1],statements,[Lex-2]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'statement'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,statements,statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol',
                                           'rhs' => [
                                                      'symbol name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,symbol,symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol name',
                                           'rhs' => [
                                                      'bare name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,symbol name,bare name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol name',
                                           'rhs' => [
                                                      'bracketed name'
                                                    ],
                                           'subgrammar' => 'g1',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'g1,symbol name,bracketed name'
                                         }
                                       ],
                               'l0' => [
                                         {
                                           'lhs' => 'Perl identifier',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,Perl identifier,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'Perl name',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'Perl identifier'
                                                    ],
                                           'separator' => 'double colon',
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,Perl name,Perl identifier'
                                         },
                                         {
                                           'lhs' => '[:discard:]',
                                           'rhs' => [
                                                      'hash comment'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:discard:],hash comment'
                                         },
                                         {
                                           'lhs' => '[:discard:]',
                                           'rhs' => [
                                                      'whitespace'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:discard:],whitespace'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'Perl name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],Perl name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[:discard:]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[:discard:]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-0]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-0]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-10]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-10]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-11]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-11]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-12]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-12]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-13]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-13]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-14]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-14]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-15]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-15]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-16]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-16]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-17]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-17]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-18]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-18]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-19]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-19]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-1]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-1]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-20]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-20]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-21]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-21]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-22]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-22]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-23]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-23]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-24]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-24]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-25]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-25]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-26]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-26]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-27]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-27]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-28]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-28]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-29]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-29]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-2]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-2]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-30]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-30]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-31]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-31]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-32]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-32]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-33]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-33]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-34]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-34]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-35]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-35]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-36]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-36]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-37]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-37]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-38]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-38]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-39]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-39]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-3]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-3]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-40]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-40]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-41]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-41]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-42]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-42]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-43]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-43]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-44]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-44]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-45]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-45]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-46]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-46]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-47]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-47]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-4]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-4]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-5]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-5]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-6]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-6]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-7]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-7]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-8]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-8]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      '[Lex-9]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],[Lex-9]'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'array descriptor'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],array descriptor'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'bare name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],bare name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'before or after'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],before or after'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'boolean'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],boolean'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'bracketed name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],bracketed name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'character class'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],character class'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],op declare bnf'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'op declare match'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],op declare match'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'op equal priority'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],op equal priority'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'op loosen'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],op loosen'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'reserved action name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],reserved action name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],reserved blessing name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'reserved event name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],reserved event name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'signed integer'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],signed integer'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],single quoted name'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'single quoted string'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],single quoted string'
                                         },
                                         {
                                           'lhs' => '[:lex_start:]',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[:lex_start:],standard name'
                                         },
                                         {
                                           'lhs' => '[Lex-0]',
                                           'rhs' => [
                                                      '[[\\;]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-0],[[\\;]]'
                                         },
                                         {
                                           'lhs' => '[Lex-10]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-10],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-11]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-11],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-12]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-12],[[\\:]],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-13]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-13],[[\\:]],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-14]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-14],[[e]],[[v]],[[e]],[[n]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-15]',
                                           'rhs' => [
                                                      '[[c]]',
                                                      '[[o]]',
                                                      '[[m]]',
                                                      '[[p]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8,
                                                          9
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-15],[[c]],[[o]],[[m]],[[p]],[[l]],[[e]],[[t]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-16]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-16],[[n]],[[u]],[[l]],[[l]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-17]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[e]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8,
                                                          9
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-17],[[p]],[[r]],[[e]],[[d]],[[i]],[[c]],[[t]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-18]',
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[c]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[i]]',
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8,
                                                          9,
                                                          10,
                                                          11,
                                                          12
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-18],[[i]],[[n]],[[a]],[[c]],[[c]],[[e]],[[s]],[[s]],[[i]],[[b]],[[l]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-19]',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[y]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-19],[[b]],[[y]]'
                                         },
                                         {
                                           'lhs' => '[Lex-1]',
                                           'rhs' => [
                                                      '[[\\{]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-1],[[\\{]]'
                                         },
                                         {
                                           'lhs' => '[Lex-20]',
                                           'rhs' => [
                                                      '[[w]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[n]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-20],[[w]],[[a]],[[r]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-21]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[k]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-21],[[o]],[[k]]'
                                         },
                                         {
                                           'lhs' => '[Lex-22]',
                                           'rhs' => [
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[l]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-22],[[f]],[[a]],[[t]],[[a]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-23]',
                                           'rhs' => [
                                                      '[[\\,]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-23],[[\\,]]'
                                         },
                                         {
                                           'lhs' => '[Lex-24]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-24],[[a]],[[c]],[[t]],[[i]],[[o]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-25]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-25],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-26]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-26],[[a]],[[s]],[[s]],[[o]],[[c]]'
                                         },
                                         {
                                           'lhs' => '[Lex-27]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-27],[[l]],[[e]],[[f]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-28]',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-28],[[r]],[[i]],[[g]],[[h]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-29]',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[u]]',
                                                      '[[p]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-29],[[g]],[[r]],[[o]],[[u]],[[p]]'
                                         },
                                         {
                                           'lhs' => '[Lex-2]',
                                           'rhs' => [
                                                      '[[\\}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-2],[[\\}]]'
                                         },
                                         {
                                           'lhs' => '[Lex-30]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[e]]',
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[o]]',
                                                      '[[r]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8,
                                                          9
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-30],[[s]],[[e]],[[p]],[[a]],[[r]],[[a]],[[t]],[[o]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-31]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[p]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-31],[[p]],[[r]],[[o]],[[p]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-32]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[a]]',
                                                      '[[g]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-32],[[e]],[[a]],[[g]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-33]',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-33],[[r]],[[a]],[[n]],[[k]]'
                                         },
                                         {
                                           'lhs' => '[Lex-34]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[\\-]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]',
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[g]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8,
                                                          9,
                                                          10,
                                                          11,
                                                          12
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-34],[[n]],[[u]],[[l]],[[l]],[[\\-]],[[r]],[[a]],[[n]],[[k]],[[i]],[[n]],[[g]]'
                                         },
                                         {
                                           'lhs' => '[Lex-35]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-35],[[n]],[[u]],[[l]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-36]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[o]]',
                                                      '[[w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-36],[[l]],[[o]],[[w]]'
                                         },
                                         {
                                           'lhs' => '[Lex-37]',
                                           'rhs' => [
                                                      '[[h]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-37],[[h]],[[i]],[[g]],[[h]]'
                                         },
                                         {
                                           'lhs' => '[Lex-38]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[t]]',
                                                      '[[y]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-38],[[p]],[[r]],[[i]],[[o]],[[r]],[[i]],[[t]],[[y]]'
                                         },
                                         {
                                           'lhs' => '[Lex-39]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[s]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-39],[[p]],[[a]],[[u]],[[s]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-3]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-3],[[\\:]],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-40]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-40],[[o]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-41]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[f]]',
                                                      '[[f]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-41],[[o]],[[f]],[[f]]'
                                         },
                                         {
                                           'lhs' => '[Lex-42]',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-42],[[b]],[[l]],[[e]],[[s]],[[s]]'
                                         },
                                         {
                                           'lhs' => '[Lex-43]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-43],[[n]],[[a]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-44]',
                                           'rhs' => [
                                                      '[[\\(]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-44],[[\\(]]'
                                         },
                                         {
                                           'lhs' => '[Lex-45]',
                                           'rhs' => [
                                                      '[[\\)]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-45],[[\\)]]'
                                         },
                                         {
                                           'lhs' => '[Lex-46]',
                                           'rhs' => [
                                                      '[[\\*]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-46],[[\\*]]'
                                         },
                                         {
                                           'lhs' => '[Lex-47]',
                                           'rhs' => [
                                                      '[[\\+]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-47],[[\\+]]'
                                         },
                                         {
                                           'lhs' => '[Lex-4]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-4],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-5]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-5],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-6]',
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-6],[[i]],[[s]]'
                                         },
                                         {
                                           'lhs' => '[Lex-7]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-7],[[\\:]],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-8]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-8],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-9]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,[Lex-9],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor',
                                           'rhs' => [
                                                      'array descriptor left bracket',
                                                      'result item descriptor list',
                                                      'array descriptor right bracket'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,array descriptor,array descriptor left bracket,result item descriptor list,array descriptor right bracket'
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'rhs' => [
                                                      '[[\\[]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,array descriptor left bracket,[[\\[]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'whitespace'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,array descriptor left bracket,[[\\[]],whitespace'
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'rhs' => [
                                                      '[[\\]]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,array descriptor right bracket,[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'rhs' => [
                                                      'whitespace',
                                                      '[[\\]]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,array descriptor right bracket,whitespace,[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'bare name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,bare name,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[f]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,before or after,[[a]],[[f]],[[t]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,before or after,[[b]],[[e]],[[f]],[[o]],[[r]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'boolean',
                                           'rhs' => [
                                                      '[[01]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,boolean,[[01]]'
                                         },
                                         {
                                           'lhs' => 'bracketed name',
                                           'rhs' => [
                                                      '[[\\<]]',
                                                      'bracketed name string',
                                                      '[[\\>]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,bracketed name,[[\\<]],bracketed name string,[[\\>]]'
                                         },
                                         {
                                           'lhs' => 'bracketed name string',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s\\w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,bracketed name string,[[\\s\\w]]'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'escaped cc character'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,cc element,escaped cc character'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'negated posix char class'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,cc element,negated posix char class'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'posix char class'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,cc element,posix char class'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'safe cc character'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,cc element,safe cc character'
                                         },
                                         {
                                           'lhs' => 'cc elements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'cc element'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,cc elements,cc element'
                                         },
                                         {
                                           'lhs' => 'character class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'cc elements',
                                                      '[[\\]]]',
                                                      'character class modifiers'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,character class,[[\\[]],cc elements,[[\\]]],character class modifiers'
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,character class modifier,[[\\:]],[[i]]'
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]',
                                                      '[[c]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,character class modifier,[[\\:]],[[i]],[[c]]'
                                         },
                                         {
                                           'lhs' => 'character class modifiers',
                                           'min' => 0,
                                           'rhs' => [
                                                      'character class modifier'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,character class modifiers,character class modifier'
                                         },
                                         {
                                           'lhs' => 'double colon',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,double colon,[[\\:]],[[\\:]]'
                                         },
                                         {
                                           'lhs' => 'escaped cc character',
                                           'rhs' => [
                                                      '[[\\\\]]',
                                                      'horizontal character'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,escaped cc character,[[\\\\]],horizontal character'
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'rhs' => [
                                                      'terminated hash comment'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,hash comment,terminated hash comment'
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'rhs' => [
                                                      'unterminated final hash comment'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,hash comment,unterminated final hash comment'
                                         },
                                         {
                                           'lhs' => 'hash comment body',
                                           'min' => 0,
                                           'rhs' => [
                                                      'hash comment char'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,hash comment body,hash comment char'
                                         },
                                         {
                                           'lhs' => 'hash comment char',
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,hash comment char,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'horizontal character',
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,horizontal character,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'integer',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\d]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,integer,[[\\d]]'
                                         },
                                         {
                                           'lhs' => 'negated posix char class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      '[[\\^]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,negated posix char class,[[\\[]],[[\\:]],[[\\^]],posix char class name,[[\\:]],[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'one or more word characters',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,one or more word characters,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'op declare bnf',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      '[[\\=]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,op declare bnf,[[\\:]],[[\\:]],[[\\=]]'
                                         },
                                         {
                                           'lhs' => 'op declare match',
                                           'rhs' => [
                                                      '[[\\~]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,op declare match,[[\\~]]'
                                         },
                                         {
                                           'lhs' => 'op equal priority',
                                           'rhs' => [
                                                      '[[\\|]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,op equal priority,[[\\|]]'
                                         },
                                         {
                                           'lhs' => 'op loosen',
                                           'rhs' => [
                                                      '[[\\|]]',
                                                      '[[\\|]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,op loosen,[[\\|]],[[\\|]]'
                                         },
                                         {
                                           'lhs' => 'posix char class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,posix char class,[[\\[]],[[\\:]],posix char class name,[[\\:]],[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'posix char class name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[[:alnum:]]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,posix char class name,[[[:alnum:]]]'
                                         },
                                         {
                                           'lhs' => 'reserved action name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,reserved action name,[[\\:]],[[\\:]],one or more word characters'
                                         },
                                         {
                                           'lhs' => 'reserved blessing name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,reserved blessing name,[[\\:]],[[\\:]],one or more word characters'
                                         },
                                         {
                                           'lhs' => 'reserved event name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,reserved event name,[[\\:]],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[h]]',
                                                      '[[s]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[l]],[[h]],[[s]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[n]],[[a]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[r]],[[u]],[[l]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]',
                                                      '[[s]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]],[[s]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[g]],[[1]],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4,
                                                          5,
                                                          6,
                                                          7,
                                                          8
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor,[[g]],[[1]],[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor list',
                                           'min' => 0,
                                           'rhs' => [
                                                      'result item descriptor'
                                                    ],
                                           'separator' => 'result item descriptor separator',
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor list,result item descriptor'
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'rhs' => [
                                                      '[[,]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor separator,[[,]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'rhs' => [
                                                      '[[,]]',
                                                      'whitespace'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,result item descriptor separator,[[,]],whitespace'
                                         },
                                         {
                                           'lhs' => 'safe cc character',
                                           'rhs' => [
                                                      '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,safe cc character,[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'sign',
                                           'rhs' => [
                                                      '[[+-]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,sign,[[+-]]'
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'rhs' => [
                                                      'integer'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,signed integer,integer'
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'rhs' => [
                                                      'sign',
                                                      'integer'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,signed integer,sign,integer'
                                         },
                                         {
                                           'lhs' => 'single quoted name',
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,single quoted name,[[\']],string without single quote or vertical space,[[\']]'
                                         },
                                         {
                                           'lhs' => 'single quoted string',
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]',
                                                      'character class modifiers'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3,
                                                          4
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,single quoted string,[[\']],string without single quote or vertical space,[[\']],character class modifiers'
                                         },
                                         {
                                           'lhs' => 'standard name',
                                           'rhs' => [
                                                      '[[a-zA-Z]]',
                                                      'zero or more word characters'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,standard name,[[a-zA-Z]],zero or more word characters'
                                         },
                                         {
                                           'lhs' => 'string without single quote or vertical space',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,string without single quote or vertical space,[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'terminated hash comment',
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body',
                                                      'vertical space char'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2,
                                                          3
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,terminated hash comment,[[\\#]],hash comment body,vertical space char'
                                         },
                                         {
                                           'lhs' => 'unterminated final hash comment',
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1,
                                                          2
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,unterminated final hash comment,[[\\#]],hash comment body'
                                         },
                                         {
                                           'lhs' => 'vertical space char',
                                           'rhs' => [
                                                      '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,vertical space char,[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'whitespace',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,whitespace,[[\\s]]'
                                         },
                                         {
                                           'lhs' => 'zero or more word characters',
                                           'min' => 0,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'subgrammar' => 'l0',
                                           'xpr_dot' => [
                                                          0,
                                                          1
                                                        ],
                                           'xpr_top' => 1,
                                           'xprid' => 'l0,zero or more word characters,[[\\w]]'
                                         }
                                       ]
                             },
                  'start_lhs' => 'statements',
                  'symbols' => {
                                 'g1' => {
                                           'Perl name' => {
                                                            'wsyid' => 474,
                                                            'xsy' => 'Perl name'
                                                          },
                                           '[:start:]' => {
                                                            'wsyid' => 657,
                                                            'xsy' => '[:start:]'
                                                          },
                                           '[Lex-0]' => {
                                                          'wsyid' => 18,
                                                          'xsy' => '[Lex-0]'
                                                        },
                                           '[Lex-10]' => {
                                                           'wsyid' => 84,
                                                           'xsy' => '[Lex-10]'
                                                         },
                                           '[Lex-11]' => {
                                                           'wsyid' => 93,
                                                           'xsy' => '[Lex-11]'
                                                         },
                                           '[Lex-12]' => {
                                                           'wsyid' => 116,
                                                           'xsy' => '[Lex-12]'
                                                         },
                                           '[Lex-13]' => {
                                                           'wsyid' => 126,
                                                           'xsy' => '[Lex-13]'
                                                         },
                                           '[Lex-14]' => {
                                                           'wsyid' => 133,
                                                           'xsy' => '[Lex-14]'
                                                         },
                                           '[Lex-15]' => {
                                                           'wsyid' => 145,
                                                           'xsy' => '[Lex-15]'
                                                         },
                                           '[Lex-16]' => {
                                                           'wsyid' => 161,
                                                           'xsy' => '[Lex-16]'
                                                         },
                                           '[Lex-17]' => {
                                                           'wsyid' => 178,
                                                           'xsy' => '[Lex-17]'
                                                         },
                                           '[Lex-18]' => {
                                                           'wsyid' => 192,
                                                           'xsy' => '[Lex-18]'
                                                         },
                                           '[Lex-19]' => {
                                                           'wsyid' => 198,
                                                           'xsy' => '[Lex-19]'
                                                         },
                                           '[Lex-1]' => {
                                                          'wsyid' => 21,
                                                          'xsy' => '[Lex-1]'
                                                        },
                                           '[Lex-20]' => {
                                                           'wsyid' => 212,
                                                           'xsy' => '[Lex-20]'
                                                         },
                                           '[Lex-21]' => {
                                                           'wsyid' => 216,
                                                           'xsy' => '[Lex-21]'
                                                         },
                                           '[Lex-22]' => {
                                                           'wsyid' => 223,
                                                           'xsy' => '[Lex-22]'
                                                         },
                                           '[Lex-23]' => {
                                                           'wsyid' => 248,
                                                           'xsy' => '[Lex-23]'
                                                         },
                                           '[Lex-24]' => {
                                                           'wsyid' => 256,
                                                           'xsy' => '[Lex-24]'
                                                         },
                                           '[Lex-25]' => {
                                                           'wsyid' => 260,
                                                           'xsy' => '[Lex-25]'
                                                         },
                                           '[Lex-26]' => {
                                                           'wsyid' => 268,
                                                           'xsy' => '[Lex-26]'
                                                         },
                                           '[Lex-27]' => {
                                                           'wsyid' => 276,
                                                           'xsy' => '[Lex-27]'
                                                         },
                                           '[Lex-28]' => {
                                                           'wsyid' => 290,
                                                           'xsy' => '[Lex-28]'
                                                         },
                                           '[Lex-29]' => {
                                                           'wsyid' => 304,
                                                           'xsy' => '[Lex-29]'
                                                         },
                                           '[Lex-2]' => {
                                                          'wsyid' => 24,
                                                          'xsy' => '[Lex-2]'
                                                        },
                                           '[Lex-30]' => {
                                                           'wsyid' => 315,
                                                           'xsy' => '[Lex-30]'
                                                         },
                                           '[Lex-31]' => {
                                                           'wsyid' => 325,
                                                           'xsy' => '[Lex-31]'
                                                         },
                                           '[Lex-32]' => {
                                                           'wsyid' => 335,
                                                           'xsy' => '[Lex-32]'
                                                         },
                                           '[Lex-33]' => {
                                                           'wsyid' => 343,
                                                           'xsy' => '[Lex-33]'
                                                         },
                                           '[Lex-34]' => {
                                                           'wsyid' => 360,
                                                           'xsy' => '[Lex-34]'
                                                         },
                                           '[Lex-35]' => {
                                                           'wsyid' => 369,
                                                           'xsy' => '[Lex-35]'
                                                         },
                                           '[Lex-36]' => {
                                                           'wsyid' => 380,
                                                           'xsy' => '[Lex-36]'
                                                         },
                                           '[Lex-37]' => {
                                                           'wsyid' => 386,
                                                           'xsy' => '[Lex-37]'
                                                         },
                                           '[Lex-38]' => {
                                                           'wsyid' => 396,
                                                           'xsy' => '[Lex-38]'
                                                         },
                                           '[Lex-39]' => {
                                                           'wsyid' => 405,
                                                           'xsy' => '[Lex-39]'
                                                         },
                                           '[Lex-3]' => {
                                                          'wsyid' => 32,
                                                          'xsy' => '[Lex-3]'
                                                        },
                                           '[Lex-40]' => {
                                                           'wsyid' => 423,
                                                           'xsy' => '[Lex-40]'
                                                         },
                                           '[Lex-41]' => {
                                                           'wsyid' => 428,
                                                           'xsy' => '[Lex-41]'
                                                         },
                                           '[Lex-42]' => {
                                                           'wsyid' => 435,
                                                           'xsy' => '[Lex-42]'
                                                         },
                                           '[Lex-43]' => {
                                                           'wsyid' => 444,
                                                           'xsy' => '[Lex-43]'
                                                         },
                                           '[Lex-44]' => {
                                                           'wsyid' => 465,
                                                           'xsy' => '[Lex-44]'
                                                         },
                                           '[Lex-45]' => {
                                                           'wsyid' => 468,
                                                           'xsy' => '[Lex-45]'
                                                         },
                                           '[Lex-46]' => {
                                                           'wsyid' => 503,
                                                           'xsy' => '[Lex-46]'
                                                         },
                                           '[Lex-47]' => {
                                                           'wsyid' => 506,
                                                           'xsy' => '[Lex-47]'
                                                         },
                                           '[Lex-4]' => {
                                                          'wsyid' => 41,
                                                          'xsy' => '[Lex-4]'
                                                        },
                                           '[Lex-5]' => {
                                                          'wsyid' => 49,
                                                          'xsy' => '[Lex-5]'
                                                        },
                                           '[Lex-6]' => {
                                                          'wsyid' => 53,
                                                          'xsy' => '[Lex-6]'
                                                        },
                                           '[Lex-7]' => {
                                                          'wsyid' => 63,
                                                          'xsy' => '[Lex-7]'
                                                        },
                                           '[Lex-8]' => {
                                                          'wsyid' => 72,
                                                          'xsy' => '[Lex-8]'
                                                        },
                                           '[Lex-9]' => {
                                                          'wsyid' => 81,
                                                          'xsy' => '[Lex-9]'
                                                        },
                                           'action' => {
                                                         'wsyid' => 232,
                                                         'xsy' => 'action'
                                                       },
                                           'action name' => {
                                                              'wsyid' => 262,
                                                              'xsy' => 'action name'
                                                            },
                                           'adverb item' => {
                                                              'wsyid' => 231,
                                                              'xsy' => 'adverb item'
                                                            },
                                           'adverb list' => {
                                                              'wsyid' => 65,
                                                              'xsy' => 'adverb list'
                                                            },
                                           'adverb list items' => {
                                                                    'wsyid' => 230,
                                                                    'xsy' => 'adverb list items'
                                                                  },
                                           'alternative' => {
                                                              'wsyid' => 227,
                                                              'xsy' => 'alternative'
                                                            },
                                           'alternative name' => {
                                                                   'wsyid' => 448,
                                                                   'xsy' => 'alternative name'
                                                                 },
                                           'alternatives' => {
                                                               'wsyid' => 225,
                                                               'xsy' => 'alternatives'
                                                             },
                                           'array descriptor' => {
                                                                   'wsyid' => 476,
                                                                   'xsy' => 'array descriptor'
                                                                 },
                                           'bare name' => {
                                                            'wsyid' => 472,
                                                            'xsy' => 'bare name'
                                                          },
                                           'before or after' => {
                                                                  'wsyid' => 409,
                                                                  'xsy' => 'before or after'
                                                                },
                                           'blessing' => {
                                                           'wsyid' => 244,
                                                           'xsy' => 'blessing'
                                                         },
                                           'blessing name' => {
                                                                'wsyid' => 439,
                                                                'xsy' => 'blessing name'
                                                              },
                                           'boolean' => {
                                                          'wsyid' => 329,
                                                          'xsy' => 'boolean'
                                                        },
                                           'bracketed name' => {
                                                                 'wsyid' => 473,
                                                                 'xsy' => 'bracketed name'
                                                               },
                                           'character class' => {
                                                                  'wsyid' => 471,
                                                                  'xsy' => 'character class'
                                                                },
                                           'completion event declaration' => {
                                                                               'wsyid' => 13,
                                                                               'xsy' => 'completion event declaration'
                                                                             },
                                           'default rule' => {
                                                               'wsyid' => 9,
                                                               'xsy' => 'default rule'
                                                             },
                                           'discard default statement' => {
                                                                            'wsyid' => 11,
                                                                            'xsy' => 'discard default statement'
                                                                          },
                                           'discard rule' => {
                                                               'wsyid' => 8,
                                                               'xsy' => 'discard rule'
                                                             },
                                           'eager specification' => {
                                                                      'wsyid' => 240,
                                                                      'xsy' => 'eager specification'
                                                                    },
                                           'empty rule' => {
                                                             'wsyid' => 3,
                                                             'xsy' => 'empty rule'
                                                           },
                                           'event initialization' => {
                                                                       'wsyid' => 147,
                                                                       'xsy' => 'event initialization'
                                                                     },
                                           'event initializer' => {
                                                                    'wsyid' => 418,
                                                                    'xsy' => 'event initializer'
                                                                  },
                                           'event name' => {
                                                             'wsyid' => 417,
                                                             'xsy' => 'event name'
                                                           },
                                           'event specification' => {
                                                                      'wsyid' => 241,
                                                                      'xsy' => 'event specification'
                                                                    },
                                           'group association' => {
                                                                    'wsyid' => 235,
                                                                    'xsy' => 'group association'
                                                                  },
                                           'inaccessible statement' => {
                                                                         'wsyid' => 16,
                                                                         'xsy' => 'inaccessible statement'
                                                                       },
                                           'inaccessible treatment' => {
                                                                         'wsyid' => 207,
                                                                         'xsy' => 'inaccessible treatment'
                                                                       },
                                           'left association' => {
                                                                   'wsyid' => 233,
                                                                   'xsy' => 'left association'
                                                                 },
                                           'lexeme default statement' => {
                                                                           'wsyid' => 10,
                                                                           'xsy' => 'lexeme default statement'
                                                                         },
                                           'lexeme rule' => {
                                                              'wsyid' => 12,
                                                              'xsy' => 'lexeme rule'
                                                            },
                                           'lhs' => {
                                                      'wsyid' => 103,
                                                      'xsy' => 'lhs'
                                                    },
                                           'naming' => {
                                                         'wsyid' => 245,
                                                         'xsy' => 'naming'
                                                       },
                                           'null adverb' => {
                                                              'wsyid' => 246,
                                                              'xsy' => 'null adverb'
                                                            },
                                           'null ranking constant' => {
                                                                        'wsyid' => 364,
                                                                        'xsy' => 'null ranking constant'
                                                                      },
                                           'null ranking specification' => {
                                                                             'wsyid' => 239,
                                                                             'xsy' => 'null ranking specification'
                                                                           },
                                           'null statement' => {
                                                                 'wsyid' => 4,
                                                                 'xsy' => 'null statement'
                                                               },
                                           'nulled event declaration' => {
                                                                           'wsyid' => 14,
                                                                           'xsy' => 'nulled event declaration'
                                                                         },
                                           'on or off' => {
                                                            'wsyid' => 420,
                                                            'xsy' => 'on or off'
                                                          },
                                           'op declare' => {
                                                             'wsyid' => 104,
                                                             'xsy' => 'op declare'
                                                           },
                                           'op declare bnf' => {
                                                                 'wsyid' => 34,
                                                                 'xsy' => 'op declare bnf'
                                                               },
                                           'op declare match' => {
                                                                   'wsyid' => 118,
                                                                   'xsy' => 'op declare match'
                                                                 },
                                           'op equal priority' => {
                                                                    'wsyid' => 228,
                                                                    'xsy' => 'op equal priority'
                                                                  },
                                           'op loosen' => {
                                                            'wsyid' => 226,
                                                            'xsy' => 'op loosen'
                                                          },
                                           'parenthesized rhs primary list' => {
                                                                                 'wsyid' => 463,
                                                                                 'xsy' => 'parenthesized rhs primary list'
                                                                               },
                                           'pause specification' => {
                                                                      'wsyid' => 243,
                                                                      'xsy' => 'pause specification'
                                                                    },
                                           'prediction event declaration' => {
                                                                               'wsyid' => 15,
                                                                               'xsy' => 'prediction event declaration'
                                                                             },
                                           'priorities' => {
                                                             'wsyid' => 105,
                                                             'xsy' => 'priorities'
                                                           },
                                           'priority rule' => {
                                                                'wsyid' => 6,
                                                                'xsy' => 'priority rule'
                                                              },
                                           'priority specification' => {
                                                                         'wsyid' => 242,
                                                                         'xsy' => 'priority specification'
                                                                       },
                                           'proper specification' => {
                                                                       'wsyid' => 237,
                                                                       'xsy' => 'proper specification'
                                                                     },
                                           'quantified rule' => {
                                                                  'wsyid' => 7,
                                                                  'xsy' => 'quantified rule'
                                                                },
                                           'quantifier' => {
                                                             'wsyid' => 107,
                                                             'xsy' => 'quantifier'
                                                           },
                                           'rank specification' => {
                                                                     'wsyid' => 238,
                                                                     'xsy' => 'rank specification'
                                                                   },
                                           'reserved action name' => {
                                                                       'wsyid' => 475,
                                                                       'xsy' => 'reserved action name'
                                                                     },
                                           'reserved blessing name' => {
                                                                         'wsyid' => 460,
                                                                         'xsy' => 'reserved blessing name'
                                                                       },
                                           'reserved event name' => {
                                                                      'wsyid' => 451,
                                                                      'xsy' => 'reserved event name'
                                                                    },
                                           'rhs' => {
                                                      'wsyid' => 229,
                                                      'xsy' => 'rhs'
                                                    },
                                           'rhs primary' => {
                                                              'wsyid' => 461,
                                                              'xsy' => 'rhs primary'
                                                            },
                                           'rhs primary list' => {
                                                                   'wsyid' => 470,
                                                                   'xsy' => 'rhs primary list'
                                                                 },
                                           'right association' => {
                                                                    'wsyid' => 234,
                                                                    'xsy' => 'right association'
                                                                  },
                                           'separator specification' => {
                                                                          'wsyid' => 236,
                                                                          'xsy' => 'separator specification'
                                                                        },
                                           'signed integer' => {
                                                                 'wsyid' => 347,
                                                                 'xsy' => 'signed integer'
                                                               },
                                           'single quoted name' => {
                                                                     'wsyid' => 450,
                                                                     'xsy' => 'single quoted name'
                                                                   },
                                           'single quoted string' => {
                                                                       'wsyid' => 462,
                                                                       'xsy' => 'single quoted string'
                                                                     },
                                           'single symbol' => {
                                                                'wsyid' => 106,
                                                                'xsy' => 'single symbol'
                                                              },
                                           'standard name' => {
                                                                'wsyid' => 449,
                                                                'xsy' => 'standard name'
                                                              },
                                           'start rule' => {
                                                             'wsyid' => 2,
                                                             'xsy' => 'start rule'
                                                           },
                                           'statement' => {
                                                            'wsyid' => 1,
                                                            'xsy' => 'statement'
                                                          },
                                           'statement group' => {
                                                                  'wsyid' => 5,
                                                                  'xsy' => 'statement group'
                                                                },
                                           'statements' => {
                                                             'wsyid' => 0,
                                                             'xsy' => 'statements'
                                                           },
                                           'symbol' => {
                                                         'wsyid' => 35,
                                                         'xsy' => 'symbol'
                                                       },
                                           'symbol name' => {
                                                              'wsyid' => 148,
                                                              'xsy' => 'symbol name'
                                                            }
                                         },
                                 'l0' => {
                                           'Perl identifier' => {
                                                                  'wsyid' => 538,
                                                                  'xsy' => 'Perl identifier'
                                                                },
                                           'Perl name' => {
                                                            'wsyid' => 542,
                                                            'xsy' => 'Perl name'
                                                          },
                                           '[:discard:]' => {
                                                              'wsyid' => 480,
                                                              'xsy' => '[:discard:]'
                                                            },
                                           '[:lex_start:]' => {
                                                                'wsyid' => 724,
                                                                'xsy' => '[:lex_start:]'
                                                              },
                                           '[Lex-0]' => {
                                                          'wsyid' => 19,
                                                          'xsy' => '[Lex-0]'
                                                        },
                                           '[Lex-10]' => {
                                                           'wsyid' => 85,
                                                           'xsy' => '[Lex-10]'
                                                         },
                                           '[Lex-11]' => {
                                                           'wsyid' => 94,
                                                           'xsy' => '[Lex-11]'
                                                         },
                                           '[Lex-12]' => {
                                                           'wsyid' => 117,
                                                           'xsy' => '[Lex-12]'
                                                         },
                                           '[Lex-13]' => {
                                                           'wsyid' => 127,
                                                           'xsy' => '[Lex-13]'
                                                         },
                                           '[Lex-14]' => {
                                                           'wsyid' => 134,
                                                           'xsy' => '[Lex-14]'
                                                         },
                                           '[Lex-15]' => {
                                                           'wsyid' => 146,
                                                           'xsy' => '[Lex-15]'
                                                         },
                                           '[Lex-16]' => {
                                                           'wsyid' => 162,
                                                           'xsy' => '[Lex-16]'
                                                         },
                                           '[Lex-17]' => {
                                                           'wsyid' => 179,
                                                           'xsy' => '[Lex-17]'
                                                         },
                                           '[Lex-18]' => {
                                                           'wsyid' => 193,
                                                           'xsy' => '[Lex-18]'
                                                         },
                                           '[Lex-19]' => {
                                                           'wsyid' => 199,
                                                           'xsy' => '[Lex-19]'
                                                         },
                                           '[Lex-1]' => {
                                                          'wsyid' => 22,
                                                          'xsy' => '[Lex-1]'
                                                        },
                                           '[Lex-20]' => {
                                                           'wsyid' => 213,
                                                           'xsy' => '[Lex-20]'
                                                         },
                                           '[Lex-21]' => {
                                                           'wsyid' => 217,
                                                           'xsy' => '[Lex-21]'
                                                         },
                                           '[Lex-22]' => {
                                                           'wsyid' => 224,
                                                           'xsy' => '[Lex-22]'
                                                         },
                                           '[Lex-23]' => {
                                                           'wsyid' => 249,
                                                           'xsy' => '[Lex-23]'
                                                         },
                                           '[Lex-24]' => {
                                                           'wsyid' => 257,
                                                           'xsy' => '[Lex-24]'
                                                         },
                                           '[Lex-25]' => {
                                                           'wsyid' => 261,
                                                           'xsy' => '[Lex-25]'
                                                         },
                                           '[Lex-26]' => {
                                                           'wsyid' => 269,
                                                           'xsy' => '[Lex-26]'
                                                         },
                                           '[Lex-27]' => {
                                                           'wsyid' => 277,
                                                           'xsy' => '[Lex-27]'
                                                         },
                                           '[Lex-28]' => {
                                                           'wsyid' => 291,
                                                           'xsy' => '[Lex-28]'
                                                         },
                                           '[Lex-29]' => {
                                                           'wsyid' => 305,
                                                           'xsy' => '[Lex-29]'
                                                         },
                                           '[Lex-2]' => {
                                                          'wsyid' => 25,
                                                          'xsy' => '[Lex-2]'
                                                        },
                                           '[Lex-30]' => {
                                                           'wsyid' => 316,
                                                           'xsy' => '[Lex-30]'
                                                         },
                                           '[Lex-31]' => {
                                                           'wsyid' => 326,
                                                           'xsy' => '[Lex-31]'
                                                         },
                                           '[Lex-32]' => {
                                                           'wsyid' => 336,
                                                           'xsy' => '[Lex-32]'
                                                         },
                                           '[Lex-33]' => {
                                                           'wsyid' => 344,
                                                           'xsy' => '[Lex-33]'
                                                         },
                                           '[Lex-34]' => {
                                                           'wsyid' => 361,
                                                           'xsy' => '[Lex-34]'
                                                         },
                                           '[Lex-35]' => {
                                                           'wsyid' => 370,
                                                           'xsy' => '[Lex-35]'
                                                         },
                                           '[Lex-36]' => {
                                                           'wsyid' => 381,
                                                           'xsy' => '[Lex-36]'
                                                         },
                                           '[Lex-37]' => {
                                                           'wsyid' => 387,
                                                           'xsy' => '[Lex-37]'
                                                         },
                                           '[Lex-38]' => {
                                                           'wsyid' => 397,
                                                           'xsy' => '[Lex-38]'
                                                         },
                                           '[Lex-39]' => {
                                                           'wsyid' => 406,
                                                           'xsy' => '[Lex-39]'
                                                         },
                                           '[Lex-3]' => {
                                                          'wsyid' => 33,
                                                          'xsy' => '[Lex-3]'
                                                        },
                                           '[Lex-40]' => {
                                                           'wsyid' => 424,
                                                           'xsy' => '[Lex-40]'
                                                         },
                                           '[Lex-41]' => {
                                                           'wsyid' => 429,
                                                           'xsy' => '[Lex-41]'
                                                         },
                                           '[Lex-42]' => {
                                                           'wsyid' => 436,
                                                           'xsy' => '[Lex-42]'
                                                         },
                                           '[Lex-43]' => {
                                                           'wsyid' => 445,
                                                           'xsy' => '[Lex-43]'
                                                         },
                                           '[Lex-44]' => {
                                                           'wsyid' => 466,
                                                           'xsy' => '[Lex-44]'
                                                         },
                                           '[Lex-45]' => {
                                                           'wsyid' => 469,
                                                           'xsy' => '[Lex-45]'
                                                         },
                                           '[Lex-46]' => {
                                                           'wsyid' => 504,
                                                           'xsy' => '[Lex-46]'
                                                         },
                                           '[Lex-47]' => {
                                                           'wsyid' => 507,
                                                           'xsy' => '[Lex-47]'
                                                         },
                                           '[Lex-4]' => {
                                                          'wsyid' => 42,
                                                          'xsy' => '[Lex-4]'
                                                        },
                                           '[Lex-5]' => {
                                                          'wsyid' => 50,
                                                          'xsy' => '[Lex-5]'
                                                        },
                                           '[Lex-6]' => {
                                                          'wsyid' => 54,
                                                          'xsy' => '[Lex-6]'
                                                        },
                                           '[Lex-7]' => {
                                                          'wsyid' => 64,
                                                          'xsy' => '[Lex-7]'
                                                        },
                                           '[Lex-8]' => {
                                                          'wsyid' => 73,
                                                          'xsy' => '[Lex-8]'
                                                        },
                                           '[Lex-9]' => {
                                                          'wsyid' => 82,
                                                          'xsy' => '[Lex-9]'
                                                        },
                                           '[[\']]' => {
                                                         'wsyid' => 624,
                                                         'xsy' => '[[\']]'
                                                       },
                                           '[[+-]]' => {
                                                         'wsyid' => 523,
                                                         'xsy' => '[[+-]]'
                                                       },
                                           '[[,]]' => {
                                                        'wsyid' => 563,
                                                        'xsy' => '[[,]]'
                                                      },
                                           '[[01]]' => {
                                                         'wsyid' => 525,
                                                         'xsy' => '[[01]]'
                                                       },
                                           '[[1]]' => {
                                                        'wsyid' => 583,
                                                        'xsy' => '[[1]]'
                                                      },
                                           '[[[:alnum:]]]' => {
                                                                'wsyid' => 655,
                                                                'xsy' => '[[[:alnum:]]]'
                                                              },
                                           '[[\\#]]' => {
                                                          'wsyid' => 487,
                                                          'xsy' => '[[\\#]]'
                                                        },
                                           '[[\\(]]' => {
                                                          'wsyid' => 464,
                                                          'xsy' => '[[\\(]]'
                                                        },
                                           '[[\\)]]' => {
                                                          'wsyid' => 467,
                                                          'xsy' => '[[\\)]]'
                                                        },
                                           '[[\\*]]' => {
                                                          'wsyid' => 502,
                                                          'xsy' => '[[\\*]]'
                                                        },
                                           '[[\\+]]' => {
                                                          'wsyid' => 505,
                                                          'xsy' => '[[\\+]]'
                                                        },
                                           '[[\\,]]' => {
                                                          'wsyid' => 247,
                                                          'xsy' => '[[\\,]]'
                                                        },
                                           '[[\\-]]' => {
                                                          'wsyid' => 352,
                                                          'xsy' => '[[\\-]]'
                                                        },
                                           '[[\\:]]' => {
                                                          'wsyid' => 653,
                                                          'xsy' => '[[\\:]]'
                                                        },
                                           '[[\\;]]' => {
                                                          'wsyid' => 17,
                                                          'xsy' => '[[\\;]]'
                                                        },
                                           '[[\\<]]' => {
                                                          'wsyid' => 547,
                                                          'xsy' => '[[\\<]]'
                                                        },
                                           '[[\\=]]' => {
                                                          'wsyid' => 493,
                                                          'xsy' => '[[\\=]]'
                                                        },
                                           '[[\\>]]' => {
                                                          'wsyid' => 548,
                                                          'xsy' => '[[\\>]]'
                                                        },
                                           '[[\\[]]' => {
                                                          'wsyid' => 650,
                                                          'xsy' => '[[\\[]]'
                                                        },
                                           '[[\\\\]]' => {
                                                           'wsyid' => 635,
                                                           'xsy' => '[[\\\\]]'
                                                         },
                                           '[[\\]]]' => {
                                                          'wsyid' => 654,
                                                          'xsy' => '[[\\]]]'
                                                        },
                                           '[[\\^]]' => {
                                                          'wsyid' => 652,
                                                          'xsy' => '[[\\^]]'
                                                        },
                                           '[[\\d]]' => {
                                                          'wsyid' => 524,
                                                          'xsy' => '[[\\d]]'
                                                        },
                                           '[[\\s\\w]]' => {
                                                             'wsyid' => 551,
                                                             'xsy' => '[[\\s\\w]]'
                                                           },
                                           '[[\\s]]' => {
                                                          'wsyid' => 479,
                                                          'xsy' => '[[\\s]]'
                                                        },
                                           '[[\\w]]' => {
                                                          'wsyid' => 543,
                                                          'xsy' => '[[\\w]]'
                                                        },
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                 'wsyid' => 489,
                                                                                                 'xsy' => '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                               },
                                           '[[\\{]]' => {
                                                          'wsyid' => 20,
                                                          'xsy' => '[[\\{]]'
                                                        },
                                           '[[\\|]]' => {
                                                          'wsyid' => 500,
                                                          'xsy' => '[[\\|]]'
                                                        },
                                           '[[\\}]]' => {
                                                          'wsyid' => 23,
                                                          'xsy' => '[[\\}]]'
                                                        },
                                           '[[\\~]]' => {
                                                          'wsyid' => 495,
                                                          'xsy' => '[[\\~]]'
                                                        },
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                 'wsyid' => 626,
                                                                                                                 'xsy' => '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                               },
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                      'wsyid' => 633,
                                                                                                                      'xsy' => '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                    },
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                  'wsyid' => 656,
                                                                                                  'xsy' => '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                },
                                           '[[a-zA-Z]]' => {
                                                             'wsyid' => 545,
                                                             'xsy' => '[[a-zA-Z]]'
                                                           },
                                           '[[a]]' => {
                                                        'wsyid' => 613,
                                                        'xsy' => '[[a]]'
                                                      },
                                           '[[b]]' => {
                                                        'wsyid' => 600,
                                                        'xsy' => '[[b]]'
                                                      },
                                           '[[c]]' => {
                                                        'wsyid' => 642,
                                                        'xsy' => '[[c]]'
                                                      },
                                           '[[d]]' => {
                                                        'wsyid' => 200,
                                                        'xsy' => '[[d]]'
                                                      },
                                           '[[e]]' => {
                                                        'wsyid' => 616,
                                                        'xsy' => '[[e]]'
                                                      },
                                           '[[f]]' => {
                                                        'wsyid' => 516,
                                                        'xsy' => '[[f]]'
                                                      },
                                           '[[g]]' => {
                                                        'wsyid' => 587,
                                                        'xsy' => '[[g]]'
                                                      },
                                           '[[h]]' => {
                                                        'wsyid' => 595,
                                                        'xsy' => '[[h]]'
                                                      },
                                           '[[i]]' => {
                                                        'wsyid' => 644,
                                                        'xsy' => '[[i]]'
                                                      },
                                           '[[k]]' => {
                                                        'wsyid' => 374,
                                                        'xsy' => '[[k]]'
                                                      },
                                           '[[l]]' => {
                                                        'wsyid' => 614,
                                                        'xsy' => '[[l]]'
                                                      },
                                           '[[m]]' => {
                                                        'wsyid' => 599,
                                                        'xsy' => '[[m]]'
                                                      },
                                           '[[n]]' => {
                                                        'wsyid' => 590,
                                                        'xsy' => '[[n]]'
                                                      },
                                           '[[o]]' => {
                                                        'wsyid' => 601,
                                                        'xsy' => '[[o]]'
                                                      },
                                           '[[p]]' => {
                                                        'wsyid' => 400,
                                                        'xsy' => '[[p]]'
                                                      },
                                           '[[r]]' => {
                                                        'wsyid' => 603,
                                                        'xsy' => '[[r]]'
                                                      },
                                           '[[s]]' => {
                                                        'wsyid' => 617,
                                                        'xsy' => '[[s]]'
                                                      },
                                           '[[t]]' => {
                                                        'wsyid' => 588,
                                                        'xsy' => '[[t]]'
                                                      },
                                           '[[u]]' => {
                                                        'wsyid' => 615,
                                                        'xsy' => '[[u]]'
                                                      },
                                           '[[v]]' => {
                                                        'wsyid' => 612,
                                                        'xsy' => '[[v]]'
                                                      },
                                           '[[w]]' => {
                                                        'wsyid' => 379,
                                                        'xsy' => '[[w]]'
                                                      },
                                           '[[x]]' => {
                                                        'wsyid' => 122,
                                                        'xsy' => '[[x]]'
                                                      },
                                           '[[y]]' => {
                                                        'wsyid' => 598,
                                                        'xsy' => '[[y]]'
                                                      },
                                           'array descriptor' => {
                                                                   'wsyid' => 552,
                                                                   'xsy' => 'array descriptor'
                                                                 },
                                           'array descriptor left bracket' => {
                                                                                'wsyid' => 553,
                                                                                'xsy' => 'array descriptor left bracket'
                                                                              },
                                           'array descriptor right bracket' => {
                                                                                 'wsyid' => 555,
                                                                                 'xsy' => 'array descriptor right bracket'
                                                                               },
                                           'bare name' => {
                                                            'wsyid' => 544,
                                                            'xsy' => 'bare name'
                                                          },
                                           'before or after' => {
                                                                  'wsyid' => 514,
                                                                  'xsy' => 'before or after'
                                                                },
                                           'boolean' => {
                                                          'wsyid' => 526,
                                                          'xsy' => 'boolean'
                                                        },
                                           'bracketed name' => {
                                                                 'wsyid' => 549,
                                                                 'xsy' => 'bracketed name'
                                                               },
                                           'bracketed name string' => {
                                                                        'wsyid' => 550,
                                                                        'xsy' => 'bracketed name string'
                                                                      },
                                           'cc element' => {
                                                             'wsyid' => 631,
                                                             'xsy' => 'cc element'
                                                           },
                                           'cc elements' => {
                                                              'wsyid' => 630,
                                                              'xsy' => 'cc elements'
                                                            },
                                           'character class' => {
                                                                  'wsyid' => 629,
                                                                  'xsy' => 'character class'
                                                                },
                                           'character class modifier' => {
                                                                           'wsyid' => 639,
                                                                           'xsy' => 'character class modifier'
                                                                         },
                                           'character class modifiers' => {
                                                                            'wsyid' => 622,
                                                                            'xsy' => 'character class modifiers'
                                                                          },
                                           'double colon' => {
                                                               'wsyid' => 541,
                                                               'xsy' => 'double colon'
                                                             },
                                           'escaped cc character' => {
                                                                       'wsyid' => 634,
                                                                       'xsy' => 'escaped cc character'
                                                                     },
                                           'hash comment' => {
                                                               'wsyid' => 481,
                                                               'xsy' => 'hash comment'
                                                             },
                                           'hash comment body' => {
                                                                    'wsyid' => 485,
                                                                    'xsy' => 'hash comment body'
                                                                  },
                                           'hash comment char' => {
                                                                    'wsyid' => 488,
                                                                    'xsy' => 'hash comment char'
                                                                  },
                                           'horizontal character' => {
                                                                       'wsyid' => 636,
                                                                       'xsy' => 'horizontal character'
                                                                     },
                                           'integer' => {
                                                          'wsyid' => 521,
                                                          'xsy' => 'integer'
                                                        },
                                           'negated posix char class' => {
                                                                           'wsyid' => 638,
                                                                           'xsy' => 'negated posix char class'
                                                                         },
                                           'one or more word characters' => {
                                                                              'wsyid' => 530,
                                                                              'xsy' => 'one or more word characters'
                                                                            },
                                           'op declare bnf' => {
                                                                 'wsyid' => 494,
                                                                 'xsy' => 'op declare bnf'
                                                               },
                                           'op declare match' => {
                                                                   'wsyid' => 496,
                                                                   'xsy' => 'op declare match'
                                                                 },
                                           'op equal priority' => {
                                                                    'wsyid' => 501,
                                                                    'xsy' => 'op equal priority'
                                                                  },
                                           'op loosen' => {
                                                            'wsyid' => 499,
                                                            'xsy' => 'op loosen'
                                                          },
                                           'posix char class' => {
                                                                   'wsyid' => 637,
                                                                   'xsy' => 'posix char class'
                                                                 },
                                           'posix char class name' => {
                                                                        'wsyid' => 649,
                                                                        'xsy' => 'posix char class name'
                                                                      },
                                           'reserved action name' => {
                                                                       'wsyid' => 529,
                                                                       'xsy' => 'reserved action name'
                                                                     },
                                           'reserved blessing name' => {
                                                                         'wsyid' => 533,
                                                                         'xsy' => 'reserved blessing name'
                                                                       },
                                           'reserved event name' => {
                                                                      'wsyid' => 459,
                                                                      'xsy' => 'reserved event name'
                                                                    },
                                           'result item descriptor' => {
                                                                         'wsyid' => 560,
                                                                         'xsy' => 'result item descriptor'
                                                                       },
                                           'result item descriptor list' => {
                                                                              'wsyid' => 554,
                                                                              'xsy' => 'result item descriptor list'
                                                                            },
                                           'result item descriptor separator' => {
                                                                                   'wsyid' => 561,
                                                                                   'xsy' => 'result item descriptor separator'
                                                                                 },
                                           'safe cc character' => {
                                                                    'wsyid' => 632,
                                                                    'xsy' => 'safe cc character'
                                                                  },
                                           'sign' => {
                                                       'wsyid' => 522,
                                                       'xsy' => 'sign'
                                                     },
                                           'signed integer' => {
                                                                 'wsyid' => 520,
                                                                 'xsy' => 'signed integer'
                                                               },
                                           'single quoted name' => {
                                                                     'wsyid' => 625,
                                                                     'xsy' => 'single quoted name'
                                                                   },
                                           'single quoted string' => {
                                                                       'wsyid' => 620,
                                                                       'xsy' => 'single quoted string'
                                                                     },
                                           'standard name' => {
                                                                'wsyid' => 546,
                                                                'xsy' => 'standard name'
                                                              },
                                           'string without single quote or vertical space' => {
                                                                                                'wsyid' => 621,
                                                                                                'xsy' => 'string without single quote or vertical space'
                                                                                              },
                                           'terminated hash comment' => {
                                                                          'wsyid' => 482,
                                                                          'xsy' => 'terminated hash comment'
                                                                        },
                                           'unterminated final hash comment' => {
                                                                                  'wsyid' => 483,
                                                                                  'xsy' => 'unterminated final hash comment'
                                                                                },
                                           'vertical space char' => {
                                                                      'wsyid' => 486,
                                                                      'xsy' => 'vertical space char'
                                                                    },
                                           'whitespace' => {
                                                             'wsyid' => 478,
                                                             'xsy' => 'whitespace'
                                                           },
                                           'zero or more word characters' => {
                                                                               'wsyid' => 536,
                                                                               'xsy' => 'zero or more word characters'
                                                                             }
                                         }
                               },
                  'xpr' => {
                             'g1' => {
                                       'g1,[:start:],statements' => {
                                                                      'action' => '::first',
                                                                      'length' => 0,
                                                                      'lhs' => '[:start:]',
                                                                      'rhs' => [
                                                                                 'statements'
                                                                               ],
                                                                      'start' => 0,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 0
                                                                    },
                                       'g1,action name,Perl name' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'action_name',
                                                                       'length' => 29,
                                                                       'lhs' => 'action name',
                                                                       'mask' => [
                                                                                   1
                                                                                 ],
                                                                       'name' => 'action name',
                                                                       'rhs' => [
                                                                                  'Perl name'
                                                                                ],
                                                                       'start' => 4634,
                                                                       'subgrammar' => 'g1',
                                                                       'subkey' => 1,
                                                                       'xrlid' => 'action name@4634+29'
                                                                     },
                                       'g1,action name,array descriptor' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'action_name',
                                                                              'length' => 36,
                                                                              'lhs' => 'action name',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'action name',
                                                                              'rhs' => [
                                                                                         'array descriptor'
                                                                                       ],
                                                                              'start' => 4705,
                                                                              'subgrammar' => 'g1',
                                                                              'subkey' => 1,
                                                                              'xrlid' => 'action name@4705+36'
                                                                            },
                                       'g1,action name,reserved action name' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'action_name',
                                                                                  'length' => 40,
                                                                                  'lhs' => 'action name',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'action name',
                                                                                  'rhs' => [
                                                                                             'reserved action name'
                                                                                           ],
                                                                                  'start' => 4664,
                                                                                  'subgrammar' => 'g1',
                                                                                  'subkey' => 1,
                                                                                  'xrlid' => 'action name@4664+40'
                                                                                },
                                       'g1,action,[Lex-24],[Lex-25],action name' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'action',
                                                                                      'length' => 40,
                                                                                      'lhs' => 'action',
                                                                                      'mask' => [
                                                                                                  0,
                                                                                                  0,
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'action',
                                                                                      'rhs' => [
                                                                                                 '[Lex-24]',
                                                                                                 '[Lex-25]',
                                                                                                 'action name'
                                                                                               ],
                                                                                      'start' => 2900,
                                                                                      'subgrammar' => 'g1',
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'action@2900+40'
                                                                                    },
                                       'g1,adverb item,action' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'adverb_item',
                                                                    'length' => 369,
                                                                    'lhs' => 'adverb item',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'adverb item',
                                                                    'rhs' => [
                                                                               'action'
                                                                             ],
                                                                    'start' => 2507,
                                                                    'subgrammar' => 'g1',
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'adverb item@2507+369'
                                                                  },
                                       'g1,adverb item,blessing' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'adverb_item',
                                                                      'length' => 8,
                                                                      'lhs' => 'adverb item',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'adverb item',
                                                                      'rhs' => [
                                                                                 'blessing'
                                                                               ],
                                                                      'start' => 2843,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 13,
                                                                      'xrlid' => 'adverb item@2507+369'
                                                                    },
                                       'g1,adverb item,eager specification' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'adverb_item',
                                                                                 'length' => 21,
                                                                                 'lhs' => 'adverb item',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'adverb item',
                                                                                 'rhs' => [
                                                                                            'eager specification'
                                                                                          ],
                                                                                 'start' => 2728,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 9,
                                                                                 'xrlid' => 'adverb item@2507+369'
                                                                               },
                                       'g1,adverb item,event specification' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'adverb_item',
                                                                                 'length' => 21,
                                                                                 'lhs' => 'adverb item',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'adverb item',
                                                                                 'rhs' => [
                                                                                            'event specification'
                                                                                          ],
                                                                                 'start' => 2756,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 10,
                                                                                 'xrlid' => 'adverb item@2507+369'
                                                                               },
                                       'g1,adverb item,group association' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_item',
                                                                               'length' => 19,
                                                                               'lhs' => 'adverb item',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb item',
                                                                               'rhs' => [
                                                                                          'group association'
                                                                                        ],
                                                                               'start' => 2587,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 4,
                                                                               'xrlid' => 'adverb item@2507+369'
                                                                             },
                                       'g1,adverb item,left association' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'adverb_item',
                                                                              'length' => 18,
                                                                              'lhs' => 'adverb item',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'adverb item',
                                                                              'rhs' => [
                                                                                         'left association'
                                                                                       ],
                                                                              'start' => 2544,
                                                                              'subgrammar' => 'g1',
                                                                              'subkey' => 2,
                                                                              'xrlid' => 'adverb item@2507+369'
                                                                            },
                                       'g1,adverb item,naming' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'adverb_item',
                                                                    'length' => 6,
                                                                    'lhs' => 'adverb item',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'adverb item',
                                                                    'rhs' => [
                                                                               'naming'
                                                                             ],
                                                                    'start' => 2854,
                                                                    'subgrammar' => 'g1',
                                                                    'subkey' => 14,
                                                                    'xrlid' => 'adverb item@2507+369'
                                                                  },
                                       'g1,adverb item,null adverb' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'adverb_item',
                                                                         'length' => 13,
                                                                         'lhs' => 'adverb item',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'adverb item',
                                                                         'rhs' => [
                                                                                    'null adverb'
                                                                                  ],
                                                                         'start' => 2863,
                                                                         'subgrammar' => 'g1',
                                                                         'subkey' => 15,
                                                                         'xrlid' => 'adverb item@2507+369'
                                                                       },
                                       'g1,adverb item,null ranking specification' => {
                                                                                        'action' => '[start,length,values]',
                                                                                        'bless' => 'adverb_item',
                                                                                        'length' => 28,
                                                                                        'lhs' => 'adverb item',
                                                                                        'mask' => [
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'adverb item',
                                                                                        'rhs' => [
                                                                                                   'null ranking specification'
                                                                                                 ],
                                                                                        'start' => 2693,
                                                                                        'subgrammar' => 'g1',
                                                                                        'subkey' => 8,
                                                                                        'xrlid' => 'adverb item@2507+369'
                                                                                      },
                                       'g1,adverb item,pause specification' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'adverb_item',
                                                                                 'length' => 21,
                                                                                 'lhs' => 'adverb item',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'adverb item',
                                                                                 'rhs' => [
                                                                                            'pause specification'
                                                                                          ],
                                                                                 'start' => 2815,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 12,
                                                                                 'xrlid' => 'adverb item@2507+369'
                                                                               },
                                       'g1,adverb item,priority specification' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'adverb_item',
                                                                                    'length' => 24,
                                                                                    'lhs' => 'adverb item',
                                                                                    'mask' => [
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'adverb item',
                                                                                    'rhs' => [
                                                                                               'priority specification'
                                                                                             ],
                                                                                    'start' => 2784,
                                                                                    'subgrammar' => 'g1',
                                                                                    'subkey' => 11,
                                                                                    'xrlid' => 'adverb item@2507+369'
                                                                                  },
                                       'g1,adverb item,proper specification' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'adverb_item',
                                                                                  'length' => 22,
                                                                                  'lhs' => 'adverb item',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'adverb item',
                                                                                  'rhs' => [
                                                                                             'proper specification'
                                                                                           ],
                                                                                  'start' => 2641,
                                                                                  'subgrammar' => 'g1',
                                                                                  'subkey' => 6,
                                                                                  'xrlid' => 'adverb item@2507+369'
                                                                                },
                                       'g1,adverb item,rank specification' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'adverb_item',
                                                                                'length' => 20,
                                                                                'lhs' => 'adverb item',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'adverb item',
                                                                                'rhs' => [
                                                                                           'rank specification'
                                                                                         ],
                                                                                'start' => 2670,
                                                                                'subgrammar' => 'g1',
                                                                                'subkey' => 7,
                                                                                'xrlid' => 'adverb item@2507+369'
                                                                              },
                                       'g1,adverb item,right association' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_item',
                                                                               'length' => 19,
                                                                               'lhs' => 'adverb item',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb item',
                                                                               'rhs' => [
                                                                                          'right association'
                                                                                        ],
                                                                               'start' => 2565,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 3,
                                                                               'xrlid' => 'adverb item@2507+369'
                                                                             },
                                       'g1,adverb item,separator specification' => {
                                                                                     'action' => '[start,length,values]',
                                                                                     'bless' => 'adverb_item',
                                                                                     'length' => 25,
                                                                                     'lhs' => 'adverb item',
                                                                                     'mask' => [
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'adverb item',
                                                                                     'rhs' => [
                                                                                                'separator specification'
                                                                                              ],
                                                                                     'start' => 2613,
                                                                                     'subgrammar' => 'g1',
                                                                                     'subkey' => 5,
                                                                                     'xrlid' => 'adverb item@2507+369'
                                                                                   },
                                       'g1,adverb list items,adverb item' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_list_items',
                                                                               'length' => 38,
                                                                               'lhs' => 'adverb list items',
                                                                               'min' => 0,
                                                                               'name' => 'adverb list items',
                                                                               'rhs' => [
                                                                                          'adverb item'
                                                                                        ],
                                                                               'start' => 2468,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 0,
                                                                               'xrlid' => 'adverb list items@2468+38'
                                                                             },
                                       'g1,adverb list,adverb list items' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_list',
                                                                               'length' => 37,
                                                                               'lhs' => 'adverb list',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb list',
                                                                               'rhs' => [
                                                                                          'adverb list items'
                                                                                        ],
                                                                               'start' => 2430,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 1,
                                                                               'xrlid' => 'adverb list@2430+37'
                                                                             },
                                       'g1,alternative name,single quoted name' => {
                                                                                     'action' => '[start,length,values]',
                                                                                     'bless' => 'alternative_name',
                                                                                     'length' => 20,
                                                                                     'lhs' => 'alternative name',
                                                                                     'mask' => [
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'alternative name',
                                                                                     'rhs' => [
                                                                                                'single quoted name'
                                                                                              ],
                                                                                     'start' => 3987,
                                                                                     'subgrammar' => 'g1',
                                                                                     'subkey' => 2,
                                                                                     'xrlid' => 'alternative name@3946+61'
                                                                                   },
                                       'g1,alternative name,standard name' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'alternative_name',
                                                                                'length' => 61,
                                                                                'lhs' => 'alternative name',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'alternative name',
                                                                                'rhs' => [
                                                                                           'standard name'
                                                                                         ],
                                                                                'start' => 3946,
                                                                                'subgrammar' => 'g1',
                                                                                'subkey' => 1,
                                                                                'xrlid' => 'alternative name@3946+61'
                                                                              },
                                       'g1,alternative,rhs,adverb list' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'alternative',
                                                                             'length' => 33,
                                                                             'lhs' => 'alternative',
                                                                             'mask' => [
                                                                                         1,
                                                                                         1
                                                                                       ],
                                                                             'name' => 'alternative',
                                                                             'rhs' => [
                                                                                        'rhs',
                                                                                        'adverb list'
                                                                                      ],
                                                                             'start' => 2395,
                                                                             'subgrammar' => 'g1',
                                                                             'subkey' => 1,
                                                                             'xrlid' => 'alternative@2395+33'
                                                                           },
                                       'g1,alternatives,alternative' => {
                                                                          'action' => '[start,length,values]',
                                                                          'bless' => 'alternatives',
                                                                          'length' => 78,
                                                                          'lhs' => 'alternatives',
                                                                          'min' => 1,
                                                                          'name' => 'alternatives',
                                                                          'proper' => '1',
                                                                          'rhs' => [
                                                                                     'alternative'
                                                                                   ],
                                                                          'separator' => 'op equal priority',
                                                                          'start' => 2316,
                                                                          'subgrammar' => 'g1',
                                                                          'subkey' => 0,
                                                                          'xrlid' => 'alternatives@2316+78'
                                                                        },
                                       'g1,blessing name,reserved blessing name' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'blessing_name',
                                                                                      'length' => 44,
                                                                                      'lhs' => 'blessing name',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'blessing name',
                                                                                      'rhs' => [
                                                                                                 'reserved blessing name'
                                                                                               ],
                                                                                      'start' => 4168,
                                                                                      'subgrammar' => 'g1',
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'blessing name@4168+44'
                                                                                    },
                                       'g1,blessing name,standard name' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'blessing_name',
                                                                             'length' => 35,
                                                                             'lhs' => 'blessing name',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'blessing name',
                                                                             'rhs' => [
                                                                                        'standard name'
                                                                                      ],
                                                                             'start' => 4132,
                                                                             'subgrammar' => 'g1',
                                                                             'subkey' => 1,
                                                                             'xrlid' => 'blessing name@4132+35'
                                                                           },
                                       'g1,blessing,[Lex-42],[Lex-25],blessing name' => {
                                                                                          'action' => '[start,length,values]',
                                                                                          'bless' => 'blessing',
                                                                                          'length' => 45,
                                                                                          'lhs' => 'blessing',
                                                                                          'mask' => [
                                                                                                      0,
                                                                                                      0,
                                                                                                      1
                                                                                                    ],
                                                                                          'name' => 'blessing',
                                                                                          'rhs' => [
                                                                                                     '[Lex-42]',
                                                                                                     '[Lex-25]',
                                                                                                     'blessing name'
                                                                                                   ],
                                                                                          'start' => 3853,
                                                                                          'subgrammar' => 'g1',
                                                                                          'subkey' => 1,
                                                                                          'xrlid' => 'blessing@3853+45'
                                                                                        },
                                       'g1,completion event declaration,[Lex-14],event initialization,[Lex-10],[Lex-15],symbol name' => {
                                                                                                                                          'action' => '[start,length,values]',
                                                                                                                                          'bless' => 'completion_event_declaration',
                                                                                                                                          'length' => 99,
                                                                                                                                          'lhs' => 'completion event declaration',
                                                                                                                                          'mask' => [
                                                                                                                                                      0,
                                                                                                                                                      1,
                                                                                                                                                      0,
                                                                                                                                                      0,
                                                                                                                                                      1
                                                                                                                                                    ],
                                                                                                                                          'name' => 'completion event declaration',
                                                                                                                                          'rhs' => [
                                                                                                                                                     '[Lex-14]',
                                                                                                                                                     'event initialization',
                                                                                                                                                     '[Lex-10]',
                                                                                                                                                     '[Lex-15]',
                                                                                                                                                     'symbol name'
                                                                                                                                                   ],
                                                                                                                                          'start' => 1750,
                                                                                                                                          'subgrammar' => 'g1',
                                                                                                                                          'subkey' => 1,
                                                                                                                                          'xrlid' => 'completion event declaration@1750+99'
                                                                                                                                        },
                                       'g1,default rule,[Lex-7],op declare bnf,adverb list' => {
                                                                                                 'action' => '[start,length,values]',
                                                                                                 'bless' => 'default_rule',
                                                                                                 'length' => 60,
                                                                                                 'lhs' => 'default rule',
                                                                                                 'mask' => [
                                                                                                             1,
                                                                                                             1,
                                                                                                             1
                                                                                                           ],
                                                                                                 'name' => 'default rule',
                                                                                                 'rhs' => [
                                                                                                            '[Lex-7]',
                                                                                                            'op declare bnf',
                                                                                                            'adverb list'
                                                                                                          ],
                                                                                                 'start' => 1220,
                                                                                                 'subgrammar' => 'g1',
                                                                                                 'subkey' => 1,
                                                                                                 'xrlid' => 'default rule@1220+60'
                                                                                               },
                                       'g1,discard default statement,[Lex-11],[Lex-9],[Lex-10],adverb list' => {
                                                                                                                 'action' => '[start,length,values]',
                                                                                                                 'bless' => 'discard_default_statement',
                                                                                                                 'length' => 71,
                                                                                                                 'lhs' => 'discard default statement',
                                                                                                                 'mask' => [
                                                                                                                             0,
                                                                                                                             0,
                                                                                                                             0,
                                                                                                                             1
                                                                                                                           ],
                                                                                                                 'name' => 'discard default statement',
                                                                                                                 'rhs' => [
                                                                                                                            '[Lex-11]',
                                                                                                                            '[Lex-9]',
                                                                                                                            '[Lex-10]',
                                                                                                                            'adverb list'
                                                                                                                          ],
                                                                                                                 'start' => 1351,
                                                                                                                 'subgrammar' => 'g1',
                                                                                                                 'subkey' => 1,
                                                                                                                 'xrlid' => 'discard default statement@1351+71'
                                                                                                               },
                                       'g1,discard rule,[Lex-12],op declare match,single symbol,adverb list' => {
                                                                                                                  'action' => '[start,length,values]',
                                                                                                                  'bless' => 'discard_rule',
                                                                                                                  'length' => 80,
                                                                                                                  'lhs' => 'discard rule',
                                                                                                                  'mask' => [
                                                                                                                              0,
                                                                                                                              0,
                                                                                                                              1,
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'discard rule',
                                                                                                                  'rhs' => [
                                                                                                                             '[Lex-12]',
                                                                                                                             'op declare match',
                                                                                                                             'single symbol',
                                                                                                                             'adverb list'
                                                                                                                           ],
                                                                                                                  'start' => 1599,
                                                                                                                  'subgrammar' => 'g1',
                                                                                                                  'subkey' => 1,
                                                                                                                  'xrlid' => 'discard rule@1599+80'
                                                                                                                },
                                       'g1,eager specification,[Lex-32],[Lex-25],boolean' => {
                                                                                               'action' => '[start,length,values]',
                                                                                               'bless' => 'eager_specification',
                                                                                               'length' => 48,
                                                                                               'lhs' => 'eager specification',
                                                                                               'mask' => [
                                                                                                           0,
                                                                                                           0,
                                                                                                           1
                                                                                                         ],
                                                                                               'name' => 'eager specification',
                                                                                               'rhs' => [
                                                                                                          '[Lex-32]',
                                                                                                          '[Lex-25]',
                                                                                                          'boolean'
                                                                                                        ],
                                                                                               'start' => 3196,
                                                                                               'subgrammar' => 'g1',
                                                                                               'subkey' => 1,
                                                                                               'xrlid' => 'eager specification@3196+48'
                                                                                             },
                                       'g1,empty rule,lhs,op declare,adverb list' => {
                                                                                       'action' => '[start,length,values]',
                                                                                       'bless' => 'empty_rule',
                                                                                       'length' => 47,
                                                                                       'lhs' => 'empty rule',
                                                                                       'mask' => [
                                                                                                   1,
                                                                                                   1,
                                                                                                   1
                                                                                                 ],
                                                                                       'name' => 'empty rule',
                                                                                       'rhs' => [
                                                                                                  'lhs',
                                                                                                  'op declare',
                                                                                                  'adverb list'
                                                                                                ],
                                                                                       'start' => 1471,
                                                                                       'subgrammar' => 'g1',
                                                                                       'subkey' => 1,
                                                                                       'xrlid' => 'empty rule@1471+47'
                                                                                     },
                                       'g1,event initialization,event name,event initializer' => {
                                                                                                   'action' => '[start,length,values]',
                                                                                                   'bless' => 'event_initialization',
                                                                                                   'length' => 59,
                                                                                                   'lhs' => 'event initialization',
                                                                                                   'mask' => [
                                                                                                               1,
                                                                                                               1
                                                                                                             ],
                                                                                                   'name' => 'event initialization',
                                                                                                   'rhs' => [
                                                                                                              'event name',
                                                                                                              'event initializer'
                                                                                                            ],
                                                                                                   'start' => 3689,
                                                                                                   'subgrammar' => 'g1',
                                                                                                   'subkey' => 1,
                                                                                                   'xrlid' => 'event initialization@3689+59'
                                                                                                 },
                                       'g1,event initializer' => {
                                                                   'action' => '[start,length,values]',
                                                                   'bless' => 'event_initializer',
                                                                   'length' => 23,
                                                                   'lhs' => 'event initializer',
                                                                   'name' => 'event initializer',
                                                                   'rhs' => [],
                                                                   'start' => 3820,
                                                                   'subgrammar' => 'g1',
                                                                   'subkey' => 0,
                                                                   'xrlid' => 'event initializer@3820+23'
                                                                 },
                                       'g1,event initializer,[Lex-10],on or off' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'event_initializer',
                                                                                      'length' => 41,
                                                                                      'lhs' => 'event initializer',
                                                                                      'mask' => [
                                                                                                  0,
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'event initializer',
                                                                                      'rhs' => [
                                                                                                 '[Lex-10]',
                                                                                                 'on or off'
                                                                                               ],
                                                                                      'start' => 3749,
                                                                                      'subgrammar' => 'g1',
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'event initializer@3749+41'
                                                                                    },
                                       'g1,event name,reserved event name' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'event_name',
                                                                                'length' => 21,
                                                                                'lhs' => 'event name',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'event name',
                                                                                'rhs' => [
                                                                                           'reserved event name'
                                                                                         ],
                                                                                'start' => 4075,
                                                                                'subgrammar' => 'g1',
                                                                                'subkey' => 3,
                                                                                'xrlid' => 'event name@4009+87'
                                                                              },
                                       'g1,event name,single quoted name' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'event_name',
                                                                               'length' => 20,
                                                                               'lhs' => 'event name',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'event name',
                                                                               'rhs' => [
                                                                                          'single quoted name'
                                                                                        ],
                                                                               'start' => 4048,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 2,
                                                                               'xrlid' => 'event name@4009+87'
                                                                             },
                                       'g1,event name,standard name' => {
                                                                          'action' => '[start,length,values]',
                                                                          'bless' => 'event_name',
                                                                          'length' => 87,
                                                                          'lhs' => 'event name',
                                                                          'mask' => [
                                                                                      1
                                                                                    ],
                                                                          'name' => 'event name',
                                                                          'rhs' => [
                                                                                     'standard name'
                                                                                   ],
                                                                          'start' => 4009,
                                                                          'subgrammar' => 'g1',
                                                                          'subkey' => 1,
                                                                          'xrlid' => 'event name@4009+87'
                                                                        },
                                       'g1,event specification,[Lex-14],[Lex-25],event initialization' => {
                                                                                                            'action' => '[start,length,values]',
                                                                                                            'bless' => 'event_specification',
                                                                                                            'length' => 63,
                                                                                                            'lhs' => 'event specification',
                                                                                                            'mask' => [
                                                                                                                        0,
                                                                                                                        0,
                                                                                                                        1
                                                                                                                      ],
                                                                                                            'name' => 'event specification',
                                                                                                            'rhs' => [
                                                                                                                       '[Lex-14]',
                                                                                                                       '[Lex-25]',
                                                                                                                       'event initialization'
                                                                                                                     ],
                                                                                                            'start' => 3625,
                                                                                                            'subgrammar' => 'g1',
                                                                                                            'subkey' => 1,
                                                                                                            'xrlid' => 'event specification@3625+63'
                                                                                                          },
                                       'g1,group association,[Lex-26],[Lex-25],[Lex-29]' => {
                                                                                              'action' => '[start,length,values]',
                                                                                              'bless' => 'group_association',
                                                                                              'length' => 46,
                                                                                              'lhs' => 'group association',
                                                                                              'mask' => [
                                                                                                          0,
                                                                                                          0,
                                                                                                          0
                                                                                                        ],
                                                                                              'name' => 'group association',
                                                                                              'rhs' => [
                                                                                                         '[Lex-26]',
                                                                                                         '[Lex-25]',
                                                                                                         '[Lex-29]'
                                                                                                       ],
                                                                                              'start' => 3033,
                                                                                              'subgrammar' => 'g1',
                                                                                              'subkey' => 1,
                                                                                              'xrlid' => 'group association@3033+46'
                                                                                            },
                                       'g1,inaccessible statement,[Lex-18],[Lex-6],inaccessible treatment,[Lex-19],[Lex-9]' => {
                                                                                                                                 'action' => '[start,length,values]',
                                                                                                                                 'bless' => 'inaccessible_statement',
                                                                                                                                 'length' => 92,
                                                                                                                                 'lhs' => 'inaccessible statement',
                                                                                                                                 'mask' => [
                                                                                                                                             0,
                                                                                                                                             0,
                                                                                                                                             1,
                                                                                                                                             0,
                                                                                                                                             0
                                                                                                                                           ],
                                                                                                                                 'name' => 'inaccessible statement',
                                                                                                                                 'rhs' => [
                                                                                                                                            '[Lex-18]',
                                                                                                                                            '[Lex-6]',
                                                                                                                                            'inaccessible treatment',
                                                                                                                                            '[Lex-19]',
                                                                                                                                            '[Lex-9]'
                                                                                                                                          ],
                                                                                                                                 'start' => 2044,
                                                                                                                                 'subgrammar' => 'g1',
                                                                                                                                 'subkey' => 1,
                                                                                                                                 'xrlid' => 'inaccessible statement@2044+92'
                                                                                                                               },
                                       'g1,inaccessible treatment,[Lex-20]' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'inaccessible_treatment',
                                                                                 'length' => 52,
                                                                                 'lhs' => 'inaccessible treatment',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'inaccessible treatment',
                                                                                 'rhs' => [
                                                                                            '[Lex-20]'
                                                                                          ],
                                                                                 'start' => 2137,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 1,
                                                                                 'xrlid' => 'inaccessible treatment@2137+52'
                                                                               },
                                       'g1,inaccessible treatment,[Lex-21]' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'inaccessible_treatment',
                                                                                 'length' => 4,
                                                                                 'lhs' => 'inaccessible treatment',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'inaccessible treatment',
                                                                                 'rhs' => [
                                                                                            '[Lex-21]'
                                                                                          ],
                                                                                 'start' => 2175,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 2,
                                                                                 'xrlid' => 'inaccessible treatment@2137+52'
                                                                               },
                                       'g1,inaccessible treatment,[Lex-22]' => {
                                                                                 'action' => '[start,length,values]',
                                                                                 'bless' => 'inaccessible_treatment',
                                                                                 'length' => 7,
                                                                                 'lhs' => 'inaccessible treatment',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'inaccessible treatment',
                                                                                 'rhs' => [
                                                                                            '[Lex-22]'
                                                                                          ],
                                                                                 'start' => 2182,
                                                                                 'subgrammar' => 'g1',
                                                                                 'subkey' => 3,
                                                                                 'xrlid' => 'inaccessible treatment@2137+52'
                                                                               },
                                       'g1,left association,[Lex-26],[Lex-25],[Lex-27]' => {
                                                                                             'action' => '[start,length,values]',
                                                                                             'bless' => 'left_association',
                                                                                             'length' => 44,
                                                                                             'lhs' => 'left association',
                                                                                             'mask' => [
                                                                                                         0,
                                                                                                         0,
                                                                                                         0
                                                                                                       ],
                                                                                             'name' => 'left association',
                                                                                             'rhs' => [
                                                                                                        '[Lex-26]',
                                                                                                        '[Lex-25]',
                                                                                                        '[Lex-27]'
                                                                                                      ],
                                                                                             'start' => 2941,
                                                                                             'subgrammar' => 'g1',
                                                                                             'subkey' => 1,
                                                                                             'xrlid' => 'left association@2941+44'
                                                                                           },
                                       'g1,lexeme default statement,[Lex-8],[Lex-9],[Lex-10],adverb list' => {
                                                                                                               'action' => '[start,length,values]',
                                                                                                               'bless' => 'lexeme_default_statement',
                                                                                                               'length' => 69,
                                                                                                               'lhs' => 'lexeme default statement',
                                                                                                               'mask' => [
                                                                                                                           0,
                                                                                                                           0,
                                                                                                                           0,
                                                                                                                           1
                                                                                                                         ],
                                                                                                               'name' => 'lexeme default statement',
                                                                                                               'rhs' => [
                                                                                                                          '[Lex-8]',
                                                                                                                          '[Lex-9]',
                                                                                                                          '[Lex-10]',
                                                                                                                          'adverb list'
                                                                                                                        ],
                                                                                                               'start' => 1281,
                                                                                                               'subgrammar' => 'g1',
                                                                                                               'subkey' => 1,
                                                                                                               'xrlid' => 'lexeme default statement@1281+69'
                                                                                                             },
                                       'g1,lexeme rule,[Lex-13],op declare match,symbol,adverb list' => {
                                                                                                          'action' => '[start,length,values]',
                                                                                                          'bless' => 'lexeme_rule',
                                                                                                          'length' => 69,
                                                                                                          'lhs' => 'lexeme rule',
                                                                                                          'mask' => [
                                                                                                                      0,
                                                                                                                      0,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'name' => 'lexeme rule',
                                                                                                          'rhs' => [
                                                                                                                     '[Lex-13]',
                                                                                                                     'op declare match',
                                                                                                                     'symbol',
                                                                                                                     'adverb list'
                                                                                                                   ],
                                                                                                          'start' => 1680,
                                                                                                          'subgrammar' => 'g1',
                                                                                                          'subkey' => 1,
                                                                                                          'xrlid' => 'lexeme rule@1680+69'
                                                                                                        },
                                       'g1,lhs,symbol name' => {
                                                                 'action' => '[start,length,values]',
                                                                 'bless' => 'lhs',
                                                                 'length' => 21,
                                                                 'lhs' => 'lhs',
                                                                 'mask' => [
                                                                             1
                                                                           ],
                                                                 'name' => 'lhs',
                                                                 'rhs' => [
                                                                            'symbol name'
                                                                          ],
                                                                 'start' => 4214,
                                                                 'subgrammar' => 'g1',
                                                                 'subkey' => 1,
                                                                 'xrlid' => 'lhs@4214+21'
                                                               },
                                       'g1,naming,[Lex-43],[Lex-25],alternative name' => {
                                                                                           'action' => '[start,length,values]',
                                                                                           'bless' => 'naming',
                                                                                           'length' => 45,
                                                                                           'lhs' => 'naming',
                                                                                           'mask' => [
                                                                                                       0,
                                                                                                       0,
                                                                                                       1
                                                                                                     ],
                                                                                           'name' => 'naming',
                                                                                           'rhs' => [
                                                                                                      '[Lex-43]',
                                                                                                      '[Lex-25]',
                                                                                                      'alternative name'
                                                                                                    ],
                                                                                           'start' => 3899,
                                                                                           'subgrammar' => 'g1',
                                                                                           'subkey' => 1,
                                                                                           'xrlid' => 'naming@3899+45'
                                                                                         },
                                       'g1,null adverb,[Lex-23]' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'null_adverb',
                                                                      'length' => 21,
                                                                      'lhs' => 'null adverb',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'null adverb',
                                                                      'rhs' => [
                                                                                 '[Lex-23]'
                                                                               ],
                                                                      'start' => 2878,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 1,
                                                                      'xrlid' => 'null adverb@2878+21'
                                                                    },
                                       'g1,null ranking constant,[Lex-36]' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'null_ranking_constant',
                                                                                'length' => 42,
                                                                                'lhs' => 'null ranking constant',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'null ranking constant',
                                                                                'rhs' => [
                                                                                           '[Lex-36]'
                                                                                         ],
                                                                                'start' => 3458,
                                                                                'subgrammar' => 'g1',
                                                                                'subkey' => 1,
                                                                                'xrlid' => 'null ranking constant@3458+42'
                                                                              },
                                       'g1,null ranking constant,[Lex-37]' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'null_ranking_constant',
                                                                                'length' => 6,
                                                                                'lhs' => 'null ranking constant',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'null ranking constant',
                                                                                'rhs' => [
                                                                                           '[Lex-37]'
                                                                                         ],
                                                                                'start' => 3494,
                                                                                'subgrammar' => 'g1',
                                                                                'subkey' => 2,
                                                                                'xrlid' => 'null ranking constant@3458+42'
                                                                              },
                                       'g1,null ranking specification,[Lex-34],[Lex-25],null ranking constant' => {
                                                                                                                    'action' => '[start,length,values]',
                                                                                                                    'bless' => 'null_ranking_specification',
                                                                                                                    'length' => 78,
                                                                                                                    'lhs' => 'null ranking specification',
                                                                                                                    'mask' => [
                                                                                                                                0,
                                                                                                                                0,
                                                                                                                                1
                                                                                                                              ],
                                                                                                                    'name' => 'null ranking specification',
                                                                                                                    'rhs' => [
                                                                                                                               '[Lex-34]',
                                                                                                                               '[Lex-25]',
                                                                                                                               'null ranking constant'
                                                                                                                             ],
                                                                                                                    'start' => 3301,
                                                                                                                    'subgrammar' => 'g1',
                                                                                                                    'subkey' => 1,
                                                                                                                    'xrlid' => 'null ranking specification@3301+78'
                                                                                                                  },
                                       'g1,null ranking specification,[Lex-35],[Lex-33],[Lex-25],null ranking constant' => {
                                                                                                                             'action' => '[start,length,values]',
                                                                                                                             'bless' => 'null_ranking_specification',
                                                                                                                             'length' => 77,
                                                                                                                             'lhs' => 'null ranking specification',
                                                                                                                             'mask' => [
                                                                                                                                         0,
                                                                                                                                         0,
                                                                                                                                         0,
                                                                                                                                         1
                                                                                                                                       ],
                                                                                                                             'name' => 'null ranking specification',
                                                                                                                             'rhs' => [
                                                                                                                                        '[Lex-35]',
                                                                                                                                        '[Lex-33]',
                                                                                                                                        '[Lex-25]',
                                                                                                                                        'null ranking constant'
                                                                                                                                      ],
                                                                                                                             'start' => 3380,
                                                                                                                             'subgrammar' => 'g1',
                                                                                                                             'subkey' => 1,
                                                                                                                             'xrlid' => 'null ranking specification@3380+77'
                                                                                                                           },
                                       'g1,null statement,[Lex-0]' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'null_statement',
                                                                        'length' => 24,
                                                                        'lhs' => 'null statement',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'null statement',
                                                                        'rhs' => [
                                                                                   '[Lex-0]'
                                                                                 ],
                                                                        'start' => 1052,
                                                                        'subgrammar' => 'g1',
                                                                        'subkey' => 1,
                                                                        'xrlid' => 'null statement@1052+24'
                                                                      },
                                       'g1,nulled event declaration,[Lex-14],event initialization,[Lex-10],[Lex-16],symbol name' => {
                                                                                                                                      'action' => '[start,length,values]',
                                                                                                                                      'bless' => 'nulled_event_declaration',
                                                                                                                                      'length' => 92,
                                                                                                                                      'lhs' => 'nulled event declaration',
                                                                                                                                      'mask' => [
                                                                                                                                                  0,
                                                                                                                                                  1,
                                                                                                                                                  0,
                                                                                                                                                  0,
                                                                                                                                                  1
                                                                                                                                                ],
                                                                                                                                      'name' => 'nulled event declaration',
                                                                                                                                      'rhs' => [
                                                                                                                                                 '[Lex-14]',
                                                                                                                                                 'event initialization',
                                                                                                                                                 '[Lex-10]',
                                                                                                                                                 '[Lex-16]',
                                                                                                                                                 'symbol name'
                                                                                                                                               ],
                                                                                                                                      'start' => 1850,
                                                                                                                                      'subgrammar' => 'g1',
                                                                                                                                      'subkey' => 1,
                                                                                                                                      'xrlid' => 'nulled event declaration@1850+92'
                                                                                                                                    },
                                       'g1,on or off,[Lex-40]' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'on_or_off',
                                                                    'length' => 28,
                                                                    'lhs' => 'on or off',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'on or off',
                                                                    'rhs' => [
                                                                               '[Lex-40]'
                                                                             ],
                                                                    'start' => 3791,
                                                                    'subgrammar' => 'g1',
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'on or off@3791+28'
                                                                  },
                                       'g1,on or off,[Lex-41]' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'on_or_off',
                                                                    'length' => 5,
                                                                    'lhs' => 'on or off',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'on or off',
                                                                    'rhs' => [
                                                                               '[Lex-41]'
                                                                             ],
                                                                    'start' => 3814,
                                                                    'subgrammar' => 'g1',
                                                                    'subkey' => 2,
                                                                    'xrlid' => 'on or off@3791+28'
                                                                  },
                                       'g1,op declare,op declare bnf' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'op_declare',
                                                                           'length' => 54,
                                                                           'lhs' => 'op declare',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'op declare',
                                                                           'rhs' => [
                                                                                      'op declare bnf'
                                                                                    ],
                                                                           'start' => 2191,
                                                                           'subgrammar' => 'g1',
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'op declare@2191+54'
                                                                         },
                                       'g1,op declare,op declare match' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'op_declare',
                                                                             'length' => 18,
                                                                             'lhs' => 'op declare',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'op declare',
                                                                             'rhs' => [
                                                                                        'op declare match'
                                                                                      ],
                                                                             'start' => 2227,
                                                                             'subgrammar' => 'g1',
                                                                             'subkey' => 2,
                                                                             'xrlid' => 'op declare@2191+54'
                                                                           },
                                       'g1,parenthesized rhs primary list,[Lex-44],rhs primary list,[Lex-45]' => {
                                                                                                                   'action' => '[start,length,values]',
                                                                                                                   'bless' => 'parenthesized_rhs_primary_list',
                                                                                                                   'length' => 67,
                                                                                                                   'lhs' => 'parenthesized rhs primary list',
                                                                                                                   'mask' => [
                                                                                                                               0,
                                                                                                                               1,
                                                                                                                               0
                                                                                                                             ],
                                                                                                                   'name' => 'parenthesized rhs primary list',
                                                                                                                   'rhs' => [
                                                                                                                              '[Lex-44]',
                                                                                                                              'rhs primary list',
                                                                                                                              '[Lex-45]'
                                                                                                                            ],
                                                                                                                   'start' => 4385,
                                                                                                                   'subgrammar' => 'g1',
                                                                                                                   'subkey' => 1,
                                                                                                                   'xrlid' => 'parenthesized rhs primary list@4385+67'
                                                                                                                 },
                                       'g1,pause specification,[Lex-39],[Lex-25],before or after' => {
                                                                                                       'action' => '[start,length,values]',
                                                                                                       'bless' => 'pause_specification',
                                                                                                       'length' => 58,
                                                                                                       'lhs' => 'pause specification',
                                                                                                       'mask' => [
                                                                                                                   0,
                                                                                                                   0,
                                                                                                                   1
                                                                                                                 ],
                                                                                                       'name' => 'pause specification',
                                                                                                       'rhs' => [
                                                                                                                  '[Lex-39]',
                                                                                                                  '[Lex-25]',
                                                                                                                  'before or after'
                                                                                                                ],
                                                                                                       'start' => 3565,
                                                                                                       'subgrammar' => 'g1',
                                                                                                       'subkey' => 1,
                                                                                                       'xrlid' => 'pause specification@3565+58'
                                                                                                     },
                                       'g1,prediction event declaration,[Lex-14],event initialization,[Lex-10],[Lex-17],symbol name' => {
                                                                                                                                          'action' => '[start,length,values]',
                                                                                                                                          'bless' => 'prediction_event_declaration',
                                                                                                                                          'length' => 99,
                                                                                                                                          'lhs' => 'prediction event declaration',
                                                                                                                                          'mask' => [
                                                                                                                                                      0,
                                                                                                                                                      1,
                                                                                                                                                      0,
                                                                                                                                                      0,
                                                                                                                                                      1
                                                                                                                                                    ],
                                                                                                                                          'name' => 'prediction event declaration',
                                                                                                                                          'rhs' => [
                                                                                                                                                     '[Lex-14]',
                                                                                                                                                     'event initialization',
                                                                                                                                                     '[Lex-10]',
                                                                                                                                                     '[Lex-17]',
                                                                                                                                                     'symbol name'
                                                                                                                                                   ],
                                                                                                                                          'start' => 1943,
                                                                                                                                          'subgrammar' => 'g1',
                                                                                                                                          'subkey' => 1,
                                                                                                                                          'xrlid' => 'prediction event declaration@1943+99'
                                                                                                                                        },
                                       'g1,priorities,alternatives' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'priorities',
                                                                         'length' => 69,
                                                                         'lhs' => 'priorities',
                                                                         'min' => 1,
                                                                         'name' => 'priorities',
                                                                         'proper' => '1',
                                                                         'rhs' => [
                                                                                    'alternatives'
                                                                                  ],
                                                                         'separator' => 'op loosen',
                                                                         'start' => 2246,
                                                                         'subgrammar' => 'g1',
                                                                         'subkey' => 0,
                                                                         'xrlid' => 'priorities@2246+69'
                                                                       },
                                       'g1,priority rule,lhs,op declare,priorities' => {
                                                                                         'action' => '[start,length,values]',
                                                                                         'bless' => 'priority_rule',
                                                                                         'length' => 47,
                                                                                         'lhs' => 'priority rule',
                                                                                         'mask' => [
                                                                                                     1,
                                                                                                     1,
                                                                                                     1
                                                                                                   ],
                                                                                         'name' => 'priority rule',
                                                                                         'rhs' => [
                                                                                                    'lhs',
                                                                                                    'op declare',
                                                                                                    'priorities'
                                                                                                  ],
                                                                                         'start' => 1423,
                                                                                         'subgrammar' => 'g1',
                                                                                         'subkey' => 1,
                                                                                         'xrlid' => 'priority rule@1423+47'
                                                                                       },
                                       'g1,priority specification,[Lex-38],[Lex-25],signed integer' => {
                                                                                                         'action' => '[start,length,values]',
                                                                                                         'bless' => 'priority_specification',
                                                                                                         'length' => 63,
                                                                                                         'lhs' => 'priority specification',
                                                                                                         'mask' => [
                                                                                                                     0,
                                                                                                                     0,
                                                                                                                     1
                                                                                                                   ],
                                                                                                         'name' => 'priority specification',
                                                                                                         'rhs' => [
                                                                                                                    '[Lex-38]',
                                                                                                                    '[Lex-25]',
                                                                                                                    'signed integer'
                                                                                                                  ],
                                                                                                         'start' => 3501,
                                                                                                         'subgrammar' => 'g1',
                                                                                                         'subkey' => 1,
                                                                                                         'xrlid' => 'priority specification@3501+63'
                                                                                                       },
                                       'g1,proper specification,[Lex-31],[Lex-25],boolean' => {
                                                                                                'action' => '[start,length,values]',
                                                                                                'bless' => 'proper_specification',
                                                                                                'length' => 50,
                                                                                                'lhs' => 'proper specification',
                                                                                                'mask' => [
                                                                                                            0,
                                                                                                            0,
                                                                                                            1
                                                                                                          ],
                                                                                                'name' => 'proper specification',
                                                                                                'rhs' => [
                                                                                                           '[Lex-31]',
                                                                                                           '[Lex-25]',
                                                                                                           'boolean'
                                                                                                         ],
                                                                                                'start' => 3145,
                                                                                                'subgrammar' => 'g1',
                                                                                                'subkey' => 1,
                                                                                                'xrlid' => 'proper specification@3145+50'
                                                                                              },
                                       'g1,quantified rule,lhs,op declare,single symbol,quantifier,adverb list' => {
                                                                                                                     'action' => '[start,length,values]',
                                                                                                                     'bless' => 'quantified_rule',
                                                                                                                     'length' => 79,
                                                                                                                     'lhs' => 'quantified rule',
                                                                                                                     'mask' => [
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1
                                                                                                                               ],
                                                                                                                     'name' => 'quantified rule',
                                                                                                                     'rhs' => [
                                                                                                                                'lhs',
                                                                                                                                'op declare',
                                                                                                                                'single symbol',
                                                                                                                                'quantifier',
                                                                                                                                'adverb list'
                                                                                                                              ],
                                                                                                                     'start' => 1519,
                                                                                                                     'subgrammar' => 'g1',
                                                                                                                     'subkey' => 1,
                                                                                                                     'xrlid' => 'quantified rule@1519+79'
                                                                                                                   },
                                       'g1,quantifier,[Lex-46]' => {
                                                                     'action' => '[start,length,values]',
                                                                     'bless' => 'quantifier',
                                                                     'length' => 24,
                                                                     'lhs' => 'quantifier',
                                                                     'mask' => [
                                                                                 1
                                                                               ],
                                                                     'name' => 'quantifier',
                                                                     'rhs' => [
                                                                                '[Lex-46]'
                                                                              ],
                                                                     'start' => 5308,
                                                                     'subgrammar' => 'g1',
                                                                     'subkey' => 1,
                                                                     'xrlid' => 'quantifier@5308+24'
                                                                   },
                                       'g1,quantifier,[Lex-47]' => {
                                                                     'action' => '[start,length,values]',
                                                                     'bless' => 'quantifier',
                                                                     'length' => 3,
                                                                     'lhs' => 'quantifier',
                                                                     'mask' => [
                                                                                 1
                                                                               ],
                                                                     'name' => 'quantifier',
                                                                     'rhs' => [
                                                                                '[Lex-47]'
                                                                              ],
                                                                     'start' => 5329,
                                                                     'subgrammar' => 'g1',
                                                                     'subkey' => 2,
                                                                     'xrlid' => 'quantifier@5308+24'
                                                                   },
                                       'g1,rank specification,[Lex-33],[Lex-25],signed integer' => {
                                                                                                     'action' => '[start,length,values]',
                                                                                                     'bless' => 'rank_specification',
                                                                                                     'length' => 55,
                                                                                                     'lhs' => 'rank specification',
                                                                                                     'mask' => [
                                                                                                                 0,
                                                                                                                 0,
                                                                                                                 1
                                                                                                               ],
                                                                                                     'name' => 'rank specification',
                                                                                                     'rhs' => [
                                                                                                                '[Lex-33]',
                                                                                                                '[Lex-25]',
                                                                                                                'signed integer'
                                                                                                              ],
                                                                                                     'start' => 3245,
                                                                                                     'subgrammar' => 'g1',
                                                                                                     'subkey' => 1,
                                                                                                     'xrlid' => 'rank specification@3245+55'
                                                                                                   },
                                       'g1,rhs primary list,rhs primary' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'rhs_primary_list',
                                                                              'length' => 37,
                                                                              'lhs' => 'rhs primary list',
                                                                              'min' => 1,
                                                                              'name' => 'rhs primary list',
                                                                              'rhs' => [
                                                                                         'rhs primary'
                                                                                       ],
                                                                              'start' => 4453,
                                                                              'subgrammar' => 'g1',
                                                                              'subkey' => 0,
                                                                              'xrlid' => 'rhs primary list@4453+37'
                                                                            },
                                       'g1,rhs primary,parenthesized rhs primary list' => {
                                                                                            'action' => '[start,length,values]',
                                                                                            'bless' => 'rhs_primary',
                                                                                            'length' => 50,
                                                                                            'lhs' => 'rhs primary',
                                                                                            'mask' => [
                                                                                                        1
                                                                                                      ],
                                                                                            'name' => 'rhs primary',
                                                                                            'rhs' => [
                                                                                                       'parenthesized rhs primary list'
                                                                                                     ],
                                                                                            'start' => 4334,
                                                                                            'subgrammar' => 'g1',
                                                                                            'subkey' => 1,
                                                                                            'xrlid' => 'rhs primary@4334+50'
                                                                                          },
                                       'g1,rhs primary,single quoted string' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'rhs_primary',
                                                                                  'length' => 40,
                                                                                  'lhs' => 'rhs primary',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'rhs primary',
                                                                                  'rhs' => [
                                                                                             'single quoted string'
                                                                                           ],
                                                                                  'start' => 4293,
                                                                                  'subgrammar' => 'g1',
                                                                                  'subkey' => 1,
                                                                                  'xrlid' => 'rhs primary@4293+40'
                                                                                },
                                       'g1,rhs primary,single symbol' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'rhs_primary',
                                                                           'length' => 33,
                                                                           'lhs' => 'rhs primary',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'rhs primary',
                                                                           'rhs' => [
                                                                                      'single symbol'
                                                                                    ],
                                                                           'start' => 4259,
                                                                           'subgrammar' => 'g1',
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'rhs primary@4259+33'
                                                                         },
                                       'g1,rhs,rhs primary' => {
                                                                 'action' => '[start,length,values]',
                                                                 'bless' => 'rhs',
                                                                 'length' => 22,
                                                                 'lhs' => 'rhs',
                                                                 'min' => 1,
                                                                 'name' => 'rhs',
                                                                 'rhs' => [
                                                                            'rhs primary'
                                                                          ],
                                                                 'start' => 4236,
                                                                 'subgrammar' => 'g1',
                                                                 'subkey' => 0,
                                                                 'xrlid' => 'rhs@4236+22'
                                                               },
                                       'g1,right association,[Lex-26],[Lex-25],[Lex-28]' => {
                                                                                              'action' => '[start,length,values]',
                                                                                              'bless' => 'right_association',
                                                                                              'length' => 46,
                                                                                              'lhs' => 'right association',
                                                                                              'mask' => [
                                                                                                          0,
                                                                                                          0,
                                                                                                          0
                                                                                                        ],
                                                                                              'name' => 'right association',
                                                                                              'rhs' => [
                                                                                                         '[Lex-26]',
                                                                                                         '[Lex-25]',
                                                                                                         '[Lex-28]'
                                                                                                       ],
                                                                                              'start' => 2986,
                                                                                              'subgrammar' => 'g1',
                                                                                              'subkey' => 1,
                                                                                              'xrlid' => 'right association@2986+46'
                                                                                            },
                                       'g1,separator specification,[Lex-30],[Lex-25],single symbol' => {
                                                                                                         'action' => '[start,length,values]',
                                                                                                         'bless' => 'separator_specification',
                                                                                                         'length' => 64,
                                                                                                         'lhs' => 'separator specification',
                                                                                                         'mask' => [
                                                                                                                     0,
                                                                                                                     0,
                                                                                                                     1
                                                                                                                   ],
                                                                                                         'name' => 'separator specification',
                                                                                                         'rhs' => [
                                                                                                                    '[Lex-30]',
                                                                                                                    '[Lex-25]',
                                                                                                                    'single symbol'
                                                                                                                  ],
                                                                                                         'start' => 3080,
                                                                                                         'subgrammar' => 'g1',
                                                                                                         'subkey' => 1,
                                                                                                         'xrlid' => 'separator specification@3080+64'
                                                                                                       },
                                       'g1,single symbol,character class' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'single_symbol',
                                                                               'length' => 17,
                                                                               'lhs' => 'single symbol',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'single symbol',
                                                                               'rhs' => [
                                                                                          'character class'
                                                                                        ],
                                                                               'start' => 4526,
                                                                               'subgrammar' => 'g1',
                                                                               'subkey' => 2,
                                                                               'xrlid' => 'single symbol@4491+52'
                                                                             },
                                       'g1,single symbol,symbol' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'single_symbol',
                                                                      'length' => 52,
                                                                      'lhs' => 'single symbol',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'single symbol',
                                                                      'rhs' => [
                                                                                 'symbol'
                                                                               ],
                                                                      'start' => 4491,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 1,
                                                                      'xrlid' => 'single symbol@4491+52'
                                                                    },
                                       'g1,start rule,[Lex-3],op declare bnf,symbol' => {
                                                                                          'action' => '[start,length,values]',
                                                                                          'bless' => 'start_rule',
                                                                                          'length' => 51,
                                                                                          'lhs' => 'start rule',
                                                                                          'mask' => [
                                                                                                      0,
                                                                                                      0,
                                                                                                      1
                                                                                                    ],
                                                                                          'name' => 'start rule',
                                                                                          'rhs' => [
                                                                                                     '[Lex-3]',
                                                                                                     'op declare bnf',
                                                                                                     'symbol'
                                                                                                   ],
                                                                                          'start' => 1120,
                                                                                          'subgrammar' => 'g1',
                                                                                          'subkey' => 1,
                                                                                          'xrlid' => 'start rule@1120+51'
                                                                                        },
                                       'g1,start rule,[Lex-4],[Lex-5],[Lex-6],symbol' => {
                                                                                           'action' => '[start,length,values]',
                                                                                           'bless' => 'start_rule',
                                                                                           'length' => 47,
                                                                                           'lhs' => 'start rule',
                                                                                           'mask' => [
                                                                                                       0,
                                                                                                       0,
                                                                                                       0,
                                                                                                       1
                                                                                                     ],
                                                                                           'name' => 'start rule',
                                                                                           'rhs' => [
                                                                                                      '[Lex-4]',
                                                                                                      '[Lex-5]',
                                                                                                      '[Lex-6]',
                                                                                                      'symbol'
                                                                                                    ],
                                                                                           'start' => 1172,
                                                                                           'subgrammar' => 'g1',
                                                                                           'subkey' => 1,
                                                                                           'xrlid' => 'start rule@1172+47'
                                                                                         },
                                       'g1,statement group,[Lex-1],statements,[Lex-2]' => {
                                                                                            'action' => '[start,length,values]',
                                                                                            'bless' => 'statement_group',
                                                                                            'length' => 42,
                                                                                            'lhs' => 'statement group',
                                                                                            'mask' => [
                                                                                                        0,
                                                                                                        1,
                                                                                                        1
                                                                                                      ],
                                                                                            'name' => 'statement group',
                                                                                            'rhs' => [
                                                                                                       '[Lex-1]',
                                                                                                       'statements',
                                                                                                       '[Lex-2]'
                                                                                                     ],
                                                                                            'start' => 1077,
                                                                                            'subgrammar' => 'g1',
                                                                                            'subkey' => 1,
                                                                                            'xrlid' => 'statement group@1077+42'
                                                                                          },
                                       'g1,statement,completion event declaration' => {
                                                                                        'action' => '[start,length,values]',
                                                                                        'bless' => 'statement',
                                                                                        'length' => 30,
                                                                                        'lhs' => 'statement',
                                                                                        'mask' => [
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'statement',
                                                                                        'rhs' => [
                                                                                                   'completion event declaration'
                                                                                                 ],
                                                                                        'start' => 925,
                                                                                        'subgrammar' => 'g1',
                                                                                        'subkey' => 12,
                                                                                        'xrlid' => 'statement@681+369'
                                                                                      },
                                       'g1,statement,default rule' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'statement',
                                                                        'length' => 14,
                                                                        'lhs' => 'statement',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'statement',
                                                                        'rhs' => [
                                                                                   'default rule'
                                                                                 ],
                                                                        'start' => 825,
                                                                        'subgrammar' => 'g1',
                                                                        'subkey' => 8,
                                                                        'xrlid' => 'statement@681+369'
                                                                      },
                                       'g1,statement,discard default statement' => {
                                                                                     'action' => '[start,length,values]',
                                                                                     'bless' => 'statement',
                                                                                     'length' => 27,
                                                                                     'lhs' => 'statement',
                                                                                     'mask' => [
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'statement',
                                                                                     'rhs' => [
                                                                                                'discard default statement'
                                                                                              ],
                                                                                     'start' => 875,
                                                                                     'subgrammar' => 'g1',
                                                                                     'subkey' => 10,
                                                                                     'xrlid' => 'statement@681+369'
                                                                                   },
                                       'g1,statement,discard rule' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'statement',
                                                                        'length' => 14,
                                                                        'lhs' => 'statement',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'statement',
                                                                        'rhs' => [
                                                                                   'discard rule'
                                                                                 ],
                                                                        'start' => 808,
                                                                        'subgrammar' => 'g1',
                                                                        'subkey' => 7,
                                                                        'xrlid' => 'statement@681+369'
                                                                      },
                                       'g1,statement,empty rule' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'statement',
                                                                      'length' => 12,
                                                                      'lhs' => 'statement',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'statement',
                                                                      'rhs' => [
                                                                                 'empty rule'
                                                                               ],
                                                                      'start' => 710,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 2,
                                                                      'xrlid' => 'statement@681+369'
                                                                    },
                                       'g1,statement,inaccessible statement' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'statement',
                                                                                  'length' => 24,
                                                                                  'lhs' => 'statement',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'statement',
                                                                                  'rhs' => [
                                                                                             'inaccessible statement'
                                                                                           ],
                                                                                  'start' => 1026,
                                                                                  'subgrammar' => 'g1',
                                                                                  'subkey' => 15,
                                                                                  'xrlid' => 'statement@681+369'
                                                                                },
                                       'g1,statement,lexeme default statement' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'statement',
                                                                                    'length' => 26,
                                                                                    'lhs' => 'statement',
                                                                                    'mask' => [
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'statement',
                                                                                    'rhs' => [
                                                                                               'lexeme default statement'
                                                                                             ],
                                                                                    'start' => 844,
                                                                                    'subgrammar' => 'g1',
                                                                                    'subkey' => 9,
                                                                                    'xrlid' => 'statement@681+369'
                                                                                  },
                                       'g1,statement,lexeme rule' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'statement',
                                                                       'length' => 13,
                                                                       'lhs' => 'statement',
                                                                       'mask' => [
                                                                                   1
                                                                                 ],
                                                                       'name' => 'statement',
                                                                       'rhs' => [
                                                                                  'lexeme rule'
                                                                                ],
                                                                       'start' => 907,
                                                                       'subgrammar' => 'g1',
                                                                       'subkey' => 11,
                                                                       'xrlid' => 'statement@681+369'
                                                                     },
                                       'g1,statement,null statement' => {
                                                                          'action' => '[start,length,values]',
                                                                          'bless' => 'statement',
                                                                          'length' => 16,
                                                                          'lhs' => 'statement',
                                                                          'mask' => [
                                                                                      1
                                                                                    ],
                                                                          'name' => 'statement',
                                                                          'rhs' => [
                                                                                     'null statement'
                                                                                   ],
                                                                          'start' => 727,
                                                                          'subgrammar' => 'g1',
                                                                          'subkey' => 3,
                                                                          'xrlid' => 'statement@681+369'
                                                                        },
                                       'g1,statement,nulled event declaration' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'statement',
                                                                                    'length' => 26,
                                                                                    'lhs' => 'statement',
                                                                                    'mask' => [
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'statement',
                                                                                    'rhs' => [
                                                                                               'nulled event declaration'
                                                                                             ],
                                                                                    'start' => 960,
                                                                                    'subgrammar' => 'g1',
                                                                                    'subkey' => 13,
                                                                                    'xrlid' => 'statement@681+369'
                                                                                  },
                                       'g1,statement,prediction event declaration' => {
                                                                                        'action' => '[start,length,values]',
                                                                                        'bless' => 'statement',
                                                                                        'length' => 30,
                                                                                        'lhs' => 'statement',
                                                                                        'mask' => [
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'statement',
                                                                                        'rhs' => [
                                                                                                   'prediction event declaration'
                                                                                                 ],
                                                                                        'start' => 991,
                                                                                        'subgrammar' => 'g1',
                                                                                        'subkey' => 14,
                                                                                        'xrlid' => 'statement@681+369'
                                                                                      },
                                       'g1,statement,priority rule' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'statement',
                                                                         'length' => 15,
                                                                         'lhs' => 'statement',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'statement',
                                                                         'rhs' => [
                                                                                    'priority rule'
                                                                                  ],
                                                                         'start' => 768,
                                                                         'subgrammar' => 'g1',
                                                                         'subkey' => 5,
                                                                         'xrlid' => 'statement@681+369'
                                                                       },
                                       'g1,statement,quantified rule' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'statement',
                                                                           'length' => 17,
                                                                           'lhs' => 'statement',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'statement',
                                                                           'rhs' => [
                                                                                      'quantified rule'
                                                                                    ],
                                                                           'start' => 786,
                                                                           'subgrammar' => 'g1',
                                                                           'subkey' => 6,
                                                                           'xrlid' => 'statement@681+369'
                                                                         },
                                       'g1,statement,start rule' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'statement',
                                                                      'length' => 369,
                                                                      'lhs' => 'statement',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'statement',
                                                                      'rhs' => [
                                                                                 'start rule'
                                                                               ],
                                                                      'start' => 681,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 1,
                                                                      'xrlid' => 'statement@681+369'
                                                                    },
                                       'g1,statement,statement group' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'statement',
                                                                           'length' => 17,
                                                                           'lhs' => 'statement',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'statement',
                                                                           'rhs' => [
                                                                                      'statement group'
                                                                                    ],
                                                                           'start' => 746,
                                                                           'subgrammar' => 'g1',
                                                                           'subkey' => 4,
                                                                           'xrlid' => 'statement@681+369'
                                                                         },
                                       'g1,statements,statement' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'statements',
                                                                      'length' => 25,
                                                                      'lhs' => 'statements',
                                                                      'min' => 1,
                                                                      'name' => 'statements',
                                                                      'rhs' => [
                                                                                 'statement'
                                                                               ],
                                                                      'start' => 655,
                                                                      'subgrammar' => 'g1',
                                                                      'subkey' => 0,
                                                                      'xrlid' => 'statements@655+25'
                                                                    },
                                       'g1,symbol name,bare name' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'symbol_name',
                                                                       'length' => 29,
                                                                       'lhs' => 'symbol name',
                                                                       'mask' => [
                                                                                   1
                                                                                 ],
                                                                       'name' => 'symbol name',
                                                                       'rhs' => [
                                                                                  'bare name'
                                                                                ],
                                                                       'start' => 4569,
                                                                       'subgrammar' => 'g1',
                                                                       'subkey' => 1,
                                                                       'xrlid' => 'symbol name@4569+29'
                                                                     },
                                       'g1,symbol name,bracketed name' => {
                                                                            'action' => '[start,length,values]',
                                                                            'bless' => 'symbol_name',
                                                                            'length' => 34,
                                                                            'lhs' => 'symbol name',
                                                                            'mask' => [
                                                                                        1
                                                                                      ],
                                                                            'name' => 'symbol name',
                                                                            'rhs' => [
                                                                                       'bracketed name'
                                                                                     ],
                                                                            'start' => 4599,
                                                                            'subgrammar' => 'g1',
                                                                            'subkey' => 1,
                                                                            'xrlid' => 'symbol name@4599+34'
                                                                          },
                                       'g1,symbol,symbol name' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'symbol',
                                                                    'length' => 24,
                                                                    'lhs' => 'symbol',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'symbol',
                                                                    'rhs' => [
                                                                               'symbol name'
                                                                             ],
                                                                    'start' => 4544,
                                                                    'subgrammar' => 'g1',
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'symbol@4544+24'
                                                                  }
                                     },
                             'l0' => {
                                       'l0,Perl identifier,[[\\w]]' => {
                                                                         'length' => 25,
                                                                         'lhs' => 'Perl identifier',
                                                                         'min' => 1,
                                                                         'name' => 'Perl identifier',
                                                                         'rhs' => [
                                                                                    '[[\\w]]'
                                                                                  ],
                                                                         'start' => 5817,
                                                                         'subgrammar' => 'l0',
                                                                         'subkey' => 0,
                                                                         'xrlid' => 'Perl identifier@5817+25'
                                                                       },
                                       'l0,Perl name,Perl identifier' => {
                                                                           'length' => 72,
                                                                           'lhs' => 'Perl name',
                                                                           'min' => 1,
                                                                           'name' => 'Perl name',
                                                                           'proper' => '1',
                                                                           'rhs' => [
                                                                                      'Perl identifier'
                                                                                    ],
                                                                           'separator' => 'double colon',
                                                                           'start' => 5865,
                                                                           'subgrammar' => 'l0',
                                                                           'subkey' => 0,
                                                                           'xrlid' => 'Perl name@5865+72'
                                                                         },
                                       'l0,[:discard:],hash comment' => {
                                                                          'length' => 25,
                                                                          'lhs' => '[:discard:]',
                                                                          'rhs' => [
                                                                                     'hash comment'
                                                                                   ],
                                                                          'start' => 4802,
                                                                          'subgrammar' => 'l0',
                                                                          'subkey' => 0,
                                                                          'symbol_as_event' => 'hash comment'
                                                                        },
                                       'l0,[:discard:],whitespace' => {
                                                                        'length' => 21,
                                                                        'lhs' => '[:discard:]',
                                                                        'rhs' => [
                                                                                   'whitespace'
                                                                                 ],
                                                                        'start' => 4743,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0,
                                                                        'symbol_as_event' => 'whitespace'
                                                                      },
                                       'l0,[:lex_start:],Perl name' => {
                                                                         'length' => 0,
                                                                         'lhs' => '[:lex_start:]',
                                                                         'rhs' => [
                                                                                    'Perl name'
                                                                                  ],
                                                                         'start' => 0,
                                                                         'subgrammar' => 'l0',
                                                                         'subkey' => 0
                                                                       },
                                       'l0,[:lex_start:],[:discard:]' => {
                                                                           'length' => 0,
                                                                           'lhs' => '[:lex_start:]',
                                                                           'rhs' => [
                                                                                      '[:discard:]'
                                                                                    ],
                                                                           'start' => 0,
                                                                           'subgrammar' => 'l0',
                                                                           'subkey' => 0
                                                                         },
                                       'l0,[:lex_start:],[Lex-0]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-0]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-10]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-10]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-11]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-11]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-12]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-12]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-13]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-13]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-14]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-14]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-15]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-15]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-16]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-16]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-17]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-17]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-18]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-18]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-19]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-19]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-1]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-1]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-20]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-20]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-21]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-21]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-22]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-22]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-23]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-23]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-24]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-24]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-25]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-25]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-26]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-26]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-27]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-27]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-28]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-28]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-29]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-29]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-2]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-2]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-30]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-30]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-31]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-31]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-32]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-32]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-33]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-33]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-34]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-34]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-35]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-35]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-36]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-36]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-37]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-37]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-38]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-38]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-39]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-39]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-3]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-3]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-40]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-40]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-41]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-41]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-42]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-42]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-43]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-43]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-44]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-44]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-45]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-45]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-46]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-46]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-47]' => {
                                                                        'length' => 0,
                                                                        'lhs' => '[:lex_start:]',
                                                                        'rhs' => [
                                                                                   '[Lex-47]'
                                                                                 ],
                                                                        'start' => 0,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0
                                                                      },
                                       'l0,[:lex_start:],[Lex-4]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-4]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-5]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-5]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-6]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-6]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-7]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-7]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-8]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-8]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],[Lex-9]' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  '[Lex-9]'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],array descriptor' => {
                                                                                'length' => 0,
                                                                                'lhs' => '[:lex_start:]',
                                                                                'rhs' => [
                                                                                           'array descriptor'
                                                                                         ],
                                                                                'start' => 0,
                                                                                'subgrammar' => 'l0',
                                                                                'subkey' => 0
                                                                              },
                                       'l0,[:lex_start:],bare name' => {
                                                                         'length' => 0,
                                                                         'lhs' => '[:lex_start:]',
                                                                         'rhs' => [
                                                                                    'bare name'
                                                                                  ],
                                                                         'start' => 0,
                                                                         'subgrammar' => 'l0',
                                                                         'subkey' => 0
                                                                       },
                                       'l0,[:lex_start:],before or after' => {
                                                                               'length' => 0,
                                                                               'lhs' => '[:lex_start:]',
                                                                               'rhs' => [
                                                                                          'before or after'
                                                                                        ],
                                                                               'start' => 0,
                                                                               'subgrammar' => 'l0',
                                                                               'subkey' => 0
                                                                             },
                                       'l0,[:lex_start:],boolean' => {
                                                                       'length' => 0,
                                                                       'lhs' => '[:lex_start:]',
                                                                       'rhs' => [
                                                                                  'boolean'
                                                                                ],
                                                                       'start' => 0,
                                                                       'subgrammar' => 'l0',
                                                                       'subkey' => 0
                                                                     },
                                       'l0,[:lex_start:],bracketed name' => {
                                                                              'length' => 0,
                                                                              'lhs' => '[:lex_start:]',
                                                                              'rhs' => [
                                                                                         'bracketed name'
                                                                                       ],
                                                                              'start' => 0,
                                                                              'subgrammar' => 'l0',
                                                                              'subkey' => 0
                                                                            },
                                       'l0,[:lex_start:],character class' => {
                                                                               'length' => 0,
                                                                               'lhs' => '[:lex_start:]',
                                                                               'rhs' => [
                                                                                          'character class'
                                                                                        ],
                                                                               'start' => 0,
                                                                               'subgrammar' => 'l0',
                                                                               'subkey' => 0
                                                                             },
                                       'l0,[:lex_start:],op declare bnf' => {
                                                                              'length' => 0,
                                                                              'lhs' => '[:lex_start:]',
                                                                              'rhs' => [
                                                                                         'op declare bnf'
                                                                                       ],
                                                                              'start' => 0,
                                                                              'subgrammar' => 'l0',
                                                                              'subkey' => 0
                                                                            },
                                       'l0,[:lex_start:],op declare match' => {
                                                                                'length' => 0,
                                                                                'lhs' => '[:lex_start:]',
                                                                                'rhs' => [
                                                                                           'op declare match'
                                                                                         ],
                                                                                'start' => 0,
                                                                                'subgrammar' => 'l0',
                                                                                'subkey' => 0
                                                                              },
                                       'l0,[:lex_start:],op equal priority' => {
                                                                                 'length' => 0,
                                                                                 'lhs' => '[:lex_start:]',
                                                                                 'rhs' => [
                                                                                            'op equal priority'
                                                                                          ],
                                                                                 'start' => 0,
                                                                                 'subgrammar' => 'l0',
                                                                                 'subkey' => 0
                                                                               },
                                       'l0,[:lex_start:],op loosen' => {
                                                                         'length' => 0,
                                                                         'lhs' => '[:lex_start:]',
                                                                         'rhs' => [
                                                                                    'op loosen'
                                                                                  ],
                                                                         'start' => 0,
                                                                         'subgrammar' => 'l0',
                                                                         'subkey' => 0
                                                                       },
                                       'l0,[:lex_start:],reserved action name' => {
                                                                                    'length' => 0,
                                                                                    'lhs' => '[:lex_start:]',
                                                                                    'rhs' => [
                                                                                               'reserved action name'
                                                                                             ],
                                                                                    'start' => 0,
                                                                                    'subgrammar' => 'l0',
                                                                                    'subkey' => 0
                                                                                  },
                                       'l0,[:lex_start:],reserved blessing name' => {
                                                                                      'length' => 0,
                                                                                      'lhs' => '[:lex_start:]',
                                                                                      'rhs' => [
                                                                                                 'reserved blessing name'
                                                                                               ],
                                                                                      'start' => 0,
                                                                                      'subgrammar' => 'l0',
                                                                                      'subkey' => 0
                                                                                    },
                                       'l0,[:lex_start:],reserved event name' => {
                                                                                   'length' => 0,
                                                                                   'lhs' => '[:lex_start:]',
                                                                                   'rhs' => [
                                                                                              'reserved event name'
                                                                                            ],
                                                                                   'start' => 0,
                                                                                   'subgrammar' => 'l0',
                                                                                   'subkey' => 0
                                                                                 },
                                       'l0,[:lex_start:],signed integer' => {
                                                                              'length' => 0,
                                                                              'lhs' => '[:lex_start:]',
                                                                              'rhs' => [
                                                                                         'signed integer'
                                                                                       ],
                                                                              'start' => 0,
                                                                              'subgrammar' => 'l0',
                                                                              'subkey' => 0
                                                                            },
                                       'l0,[:lex_start:],single quoted name' => {
                                                                                  'length' => 0,
                                                                                  'lhs' => '[:lex_start:]',
                                                                                  'rhs' => [
                                                                                             'single quoted name'
                                                                                           ],
                                                                                  'start' => 0,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[:lex_start:],single quoted string' => {
                                                                                    'length' => 0,
                                                                                    'lhs' => '[:lex_start:]',
                                                                                    'rhs' => [
                                                                                               'single quoted string'
                                                                                             ],
                                                                                    'start' => 0,
                                                                                    'subgrammar' => 'l0',
                                                                                    'subkey' => 0
                                                                                  },
                                       'l0,[:lex_start:],standard name' => {
                                                                             'length' => 0,
                                                                             'lhs' => '[:lex_start:]',
                                                                             'rhs' => [
                                                                                        'standard name'
                                                                                      ],
                                                                             'start' => 0,
                                                                             'subgrammar' => 'l0',
                                                                             'subkey' => 0
                                                                           },
                                       'l0,[Lex-0],[[\\;]]' => {
                                                                 'length' => 3,
                                                                 'lhs' => '[Lex-0]',
                                                                 'mask' => [
                                                                             1
                                                                           ],
                                                                 'rhs' => [
                                                                            '[[\\;]]'
                                                                          ],
                                                                 'start' => 1073,
                                                                 'subgrammar' => 'l0',
                                                                 'subkey' => 0
                                                               },
                                       'l0,[Lex-10],[[\\=]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-10]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\=]]'
                                                                           ],
                                                                  'start' => 1332,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-11],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]' => {
                                                                                                    'length' => 9,
                                                                                                    'lhs' => '[Lex-11]',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'rhs' => [
                                                                                                               '[[d]]',
                                                                                                               '[[i]]',
                                                                                                               '[[s]]',
                                                                                                               '[[c]]',
                                                                                                               '[[a]]',
                                                                                                               '[[r]]',
                                                                                                               '[[d]]'
                                                                                                             ],
                                                                                                    'start' => 1384,
                                                                                                    'subgrammar' => 'l0',
                                                                                                    'subkey' => 0
                                                                                                  },
                                       'l0,[Lex-12],[[\\:]],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]' => {
                                                                                                            'length' => 10,
                                                                                                            'lhs' => '[Lex-12]',
                                                                                                            'mask' => [
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1
                                                                                                                      ],
                                                                                                            'rhs' => [
                                                                                                                       '[[\\:]]',
                                                                                                                       '[[d]]',
                                                                                                                       '[[i]]',
                                                                                                                       '[[s]]',
                                                                                                                       '[[c]]',
                                                                                                                       '[[a]]',
                                                                                                                       '[[r]]',
                                                                                                                       '[[d]]'
                                                                                                                     ],
                                                                                                            'start' => 1619,
                                                                                                            'subgrammar' => 'l0',
                                                                                                            'subkey' => 0
                                                                                                          },
                                       'l0,[Lex-13],[[\\:]],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]' => {
                                                                                                      'length' => 9,
                                                                                                      'lhs' => '[Lex-13]',
                                                                                                      'mask' => [
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1
                                                                                                                ],
                                                                                                      'rhs' => [
                                                                                                                 '[[\\:]]',
                                                                                                                 '[[l]]',
                                                                                                                 '[[e]]',
                                                                                                                 '[[x]]',
                                                                                                                 '[[e]]',
                                                                                                                 '[[m]]',
                                                                                                                 '[[e]]'
                                                                                                               ],
                                                                                                      'start' => 1699,
                                                                                                      'subgrammar' => 'l0',
                                                                                                      'subkey' => 0
                                                                                                    },
                                       'l0,[Lex-14],[[e]],[[v]],[[e]],[[n]],[[t]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-14]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[e]]',
                                                                                                   '[[v]]',
                                                                                                   '[[e]]',
                                                                                                   '[[n]]',
                                                                                                   '[[t]]'
                                                                                                 ],
                                                                                        'start' => 1786,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-15],[[c]],[[o]],[[m]],[[p]],[[l]],[[e]],[[t]],[[e]],[[d]]' => {
                                                                                                                'length' => 11,
                                                                                                                'lhs' => '[Lex-15]',
                                                                                                                'mask' => [
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'rhs' => [
                                                                                                                           '[[c]]',
                                                                                                                           '[[o]]',
                                                                                                                           '[[m]]',
                                                                                                                           '[[p]]',
                                                                                                                           '[[l]]',
                                                                                                                           '[[e]]',
                                                                                                                           '[[t]]',
                                                                                                                           '[[e]]',
                                                                                                                           '[[d]]'
                                                                                                                         ],
                                                                                                                'start' => 1823,
                                                                                                                'subgrammar' => 'l0',
                                                                                                                'subkey' => 0
                                                                                                              },
                                       'l0,[Lex-16],[[n]],[[u]],[[l]],[[l]],[[e]],[[d]]' => {
                                                                                              'length' => 8,
                                                                                              'lhs' => '[Lex-16]',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'rhs' => [
                                                                                                         '[[n]]',
                                                                                                         '[[u]]',
                                                                                                         '[[l]]',
                                                                                                         '[[l]]',
                                                                                                         '[[e]]',
                                                                                                         '[[d]]'
                                                                                                       ],
                                                                                              'start' => 1919,
                                                                                              'subgrammar' => 'l0',
                                                                                              'subkey' => 0
                                                                                            },
                                       'l0,[Lex-17],[[p]],[[r]],[[e]],[[d]],[[i]],[[c]],[[t]],[[e]],[[d]]' => {
                                                                                                                'length' => 11,
                                                                                                                'lhs' => '[Lex-17]',
                                                                                                                'mask' => [
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'rhs' => [
                                                                                                                           '[[p]]',
                                                                                                                           '[[r]]',
                                                                                                                           '[[e]]',
                                                                                                                           '[[d]]',
                                                                                                                           '[[i]]',
                                                                                                                           '[[c]]',
                                                                                                                           '[[t]]',
                                                                                                                           '[[e]]',
                                                                                                                           '[[d]]'
                                                                                                                         ],
                                                                                                                'start' => 2016,
                                                                                                                'subgrammar' => 'l0',
                                                                                                                'subkey' => 0
                                                                                                              },
                                       'l0,[Lex-18],[[i]],[[n]],[[a]],[[c]],[[c]],[[e]],[[s]],[[s]],[[i]],[[b]],[[l]],[[e]]' => {
                                                                                                                                  'length' => 14,
                                                                                                                                  'lhs' => '[Lex-18]',
                                                                                                                                  'mask' => [
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1
                                                                                                                                            ],
                                                                                                                                  'rhs' => [
                                                                                                                                             '[[i]]',
                                                                                                                                             '[[n]]',
                                                                                                                                             '[[a]]',
                                                                                                                                             '[[c]]',
                                                                                                                                             '[[c]]',
                                                                                                                                             '[[e]]',
                                                                                                                                             '[[s]]',
                                                                                                                                             '[[s]]',
                                                                                                                                             '[[i]]',
                                                                                                                                             '[[b]]',
                                                                                                                                             '[[l]]',
                                                                                                                                             '[[e]]'
                                                                                                                                           ],
                                                                                                                                  'start' => 2074,
                                                                                                                                  'subgrammar' => 'l0',
                                                                                                                                  'subkey' => 0
                                                                                                                                },
                                       'l0,[Lex-19],[[b]],[[y]]' => {
                                                                      'length' => 4,
                                                                      'lhs' => '[Lex-19]',
                                                                      'mask' => [
                                                                                  1,
                                                                                  1
                                                                                ],
                                                                      'rhs' => [
                                                                                 '[[b]]',
                                                                                 '[[y]]'
                                                                               ],
                                                                      'start' => 2121,
                                                                      'subgrammar' => 'l0',
                                                                      'subkey' => 0
                                                                    },
                                       'l0,[Lex-1],[[\\{]]' => {
                                                                 'length' => 3,
                                                                 'lhs' => '[Lex-1]',
                                                                 'mask' => [
                                                                             1
                                                                           ],
                                                                 'rhs' => [
                                                                            '[[\\{]]'
                                                                          ],
                                                                 'start' => 1100,
                                                                 'subgrammar' => 'l0',
                                                                 'subkey' => 0
                                                               },
                                       'l0,[Lex-20],[[w]],[[a]],[[r]],[[n]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-20]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[w]]',
                                                                                             '[[a]]',
                                                                                             '[[r]]',
                                                                                             '[[n]]'
                                                                                           ],
                                                                                  'start' => 2166,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-21],[[o]],[[k]]' => {
                                                                      'length' => 4,
                                                                      'lhs' => '[Lex-21]',
                                                                      'mask' => [
                                                                                  1,
                                                                                  1
                                                                                ],
                                                                      'rhs' => [
                                                                                 '[[o]]',
                                                                                 '[[k]]'
                                                                               ],
                                                                      'start' => 2175,
                                                                      'subgrammar' => 'l0',
                                                                      'subkey' => 0
                                                                    },
                                       'l0,[Lex-22],[[f]],[[a]],[[t]],[[a]],[[l]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-22]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[f]]',
                                                                                                   '[[a]]',
                                                                                                   '[[t]]',
                                                                                                   '[[a]]',
                                                                                                   '[[l]]'
                                                                                                 ],
                                                                                        'start' => 2182,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-23],[[\\,]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-23]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\,]]'
                                                                           ],
                                                                  'start' => 2896,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-24],[[a]],[[c]],[[t]],[[i]],[[o]],[[n]]' => {
                                                                                              'length' => 8,
                                                                                              'lhs' => '[Lex-24]',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'rhs' => [
                                                                                                         '[[a]]',
                                                                                                         '[[c]]',
                                                                                                         '[[t]]',
                                                                                                         '[[i]]',
                                                                                                         '[[o]]',
                                                                                                         '[[n]]'
                                                                                                       ],
                                                                                              'start' => 2912,
                                                                                              'subgrammar' => 'l0',
                                                                                              'subkey' => 0
                                                                                            },
                                       'l0,[Lex-25],[[\\=]],[[\\>]]' => {
                                                                          'length' => 4,
                                                                          'lhs' => '[Lex-25]',
                                                                          'mask' => [
                                                                                      1,
                                                                                      1
                                                                                    ],
                                                                          'rhs' => [
                                                                                     '[[\\=]]',
                                                                                     '[[\\>]]'
                                                                                   ],
                                                                          'start' => 2921,
                                                                          'subgrammar' => 'l0',
                                                                          'subkey' => 0
                                                                        },
                                       'l0,[Lex-26],[[a]],[[s]],[[s]],[[o]],[[c]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-26]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[a]]',
                                                                                                   '[[s]]',
                                                                                                   '[[s]]',
                                                                                                   '[[o]]',
                                                                                                   '[[c]]'
                                                                                                 ],
                                                                                        'start' => 2965,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-27],[[l]],[[e]],[[f]],[[t]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-27]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[l]]',
                                                                                             '[[e]]',
                                                                                             '[[f]]',
                                                                                             '[[t]]'
                                                                                           ],
                                                                                  'start' => 2978,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-28],[[r]],[[i]],[[g]],[[h]],[[t]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-28]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[r]]',
                                                                                                   '[[i]]',
                                                                                                   '[[g]]',
                                                                                                   '[[h]]',
                                                                                                   '[[t]]'
                                                                                                 ],
                                                                                        'start' => 3024,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-29],[[g]],[[r]],[[o]],[[u]],[[p]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-29]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[g]]',
                                                                                                   '[[r]]',
                                                                                                   '[[o]]',
                                                                                                   '[[u]]',
                                                                                                   '[[p]]'
                                                                                                 ],
                                                                                        'start' => 3071,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-2],[[\\}]]' => {
                                                                 'length' => 3,
                                                                 'lhs' => '[Lex-2]',
                                                                 'mask' => [
                                                                             1
                                                                           ],
                                                                 'rhs' => [
                                                                            '[[\\}]]'
                                                                          ],
                                                                 'start' => 1116,
                                                                 'subgrammar' => 'l0',
                                                                 'subkey' => 0
                                                               },
                                       'l0,[Lex-30],[[s]],[[e]],[[p]],[[a]],[[r]],[[a]],[[t]],[[o]],[[r]]' => {
                                                                                                                'length' => 11,
                                                                                                                'lhs' => '[Lex-30]',
                                                                                                                'mask' => [
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'rhs' => [
                                                                                                                           '[[s]]',
                                                                                                                           '[[e]]',
                                                                                                                           '[[p]]',
                                                                                                                           '[[a]]',
                                                                                                                           '[[r]]',
                                                                                                                           '[[a]]',
                                                                                                                           '[[t]]',
                                                                                                                           '[[o]]',
                                                                                                                           '[[r]]'
                                                                                                                         ],
                                                                                                                'start' => 3111,
                                                                                                                'subgrammar' => 'l0',
                                                                                                                'subkey' => 0
                                                                                                              },
                                       'l0,[Lex-31],[[p]],[[r]],[[o]],[[p]],[[e]],[[r]]' => {
                                                                                              'length' => 8,
                                                                                              'lhs' => '[Lex-31]',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'rhs' => [
                                                                                                         '[[p]]',
                                                                                                         '[[r]]',
                                                                                                         '[[o]]',
                                                                                                         '[[p]]',
                                                                                                         '[[e]]',
                                                                                                         '[[r]]'
                                                                                                       ],
                                                                                              'start' => 3173,
                                                                                              'subgrammar' => 'l0',
                                                                                              'subkey' => 0
                                                                                            },
                                       'l0,[Lex-32],[[e]],[[a]],[[g]],[[e]],[[r]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-32]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[e]]',
                                                                                                   '[[a]]',
                                                                                                   '[[g]]',
                                                                                                   '[[e]]',
                                                                                                   '[[r]]'
                                                                                                 ],
                                                                                        'start' => 3223,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-33],[[r]],[[a]],[[n]],[[k]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-33]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[r]]',
                                                                                             '[[a]]',
                                                                                             '[[n]]',
                                                                                             '[[k]]'
                                                                                           ],
                                                                                  'start' => 3271,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-34],[[n]],[[u]],[[l]],[[l]],[[\\-]],[[r]],[[a]],[[n]],[[k]],[[i]],[[n]],[[g]]' => {
                                                                                                                                    'length' => 14,
                                                                                                                                    'lhs' => '[Lex-34]',
                                                                                                                                    'mask' => [
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1,
                                                                                                                                                1
                                                                                                                                              ],
                                                                                                                                    'rhs' => [
                                                                                                                                               '[[n]]',
                                                                                                                                               '[[u]]',
                                                                                                                                               '[[l]]',
                                                                                                                                               '[[l]]',
                                                                                                                                               '[[\\-]]',
                                                                                                                                               '[[r]]',
                                                                                                                                               '[[a]]',
                                                                                                                                               '[[n]]',
                                                                                                                                               '[[k]]',
                                                                                                                                               '[[i]]',
                                                                                                                                               '[[n]]',
                                                                                                                                               '[[g]]'
                                                                                                                                             ],
                                                                                                                                    'start' => 3335,
                                                                                                                                    'subgrammar' => 'l0',
                                                                                                                                    'subkey' => 0
                                                                                                                                  },
                                       'l0,[Lex-35],[[n]],[[u]],[[l]],[[l]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-35]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[n]]',
                                                                                             '[[u]]',
                                                                                             '[[l]]',
                                                                                             '[[l]]'
                                                                                           ],
                                                                                  'start' => 3414,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-36],[[l]],[[o]],[[w]]' => {
                                                                            'length' => 5,
                                                                            'lhs' => '[Lex-36]',
                                                                            'mask' => [
                                                                                        1,
                                                                                        1,
                                                                                        1
                                                                                      ],
                                                                            'rhs' => [
                                                                                       '[[l]]',
                                                                                       '[[o]]',
                                                                                       '[[w]]'
                                                                                     ],
                                                                            'start' => 3486,
                                                                            'subgrammar' => 'l0',
                                                                            'subkey' => 0
                                                                          },
                                       'l0,[Lex-37],[[h]],[[i]],[[g]],[[h]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-37]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[h]]',
                                                                                             '[[i]]',
                                                                                             '[[g]]',
                                                                                             '[[h]]'
                                                                                           ],
                                                                                  'start' => 3494,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-38],[[p]],[[r]],[[i]],[[o]],[[r]],[[i]],[[t]],[[y]]' => {
                                                                                                          'length' => 10,
                                                                                                          'lhs' => '[Lex-38]',
                                                                                                          'mask' => [
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'rhs' => [
                                                                                                                     '[[p]]',
                                                                                                                     '[[r]]',
                                                                                                                     '[[i]]',
                                                                                                                     '[[o]]',
                                                                                                                     '[[r]]',
                                                                                                                     '[[i]]',
                                                                                                                     '[[t]]',
                                                                                                                     '[[y]]'
                                                                                                                   ],
                                                                                                          'start' => 3531,
                                                                                                          'subgrammar' => 'l0',
                                                                                                          'subkey' => 0
                                                                                                        },
                                       'l0,[Lex-39],[[p]],[[a]],[[u]],[[s]],[[e]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-39]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[p]]',
                                                                                                   '[[a]]',
                                                                                                   '[[u]]',
                                                                                                   '[[s]]',
                                                                                                   '[[e]]'
                                                                                                 ],
                                                                                        'start' => 3592,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-3],[[\\:]],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                               'length' => 8,
                                                                                               'lhs' => '[Lex-3]',
                                                                                               'mask' => [
                                                                                                           1,
                                                                                                           1,
                                                                                                           1,
                                                                                                           1,
                                                                                                           1,
                                                                                                           1
                                                                                                         ],
                                                                                               'rhs' => [
                                                                                                          '[[\\:]]',
                                                                                                          '[[s]]',
                                                                                                          '[[t]]',
                                                                                                          '[[a]]',
                                                                                                          '[[r]]',
                                                                                                          '[[t]]'
                                                                                                        ],
                                                                                               'start' => 1138,
                                                                                               'subgrammar' => 'l0',
                                                                                               'subkey' => 0
                                                                                             },
                                       'l0,[Lex-40],[[o]],[[n]]' => {
                                                                      'length' => 4,
                                                                      'lhs' => '[Lex-40]',
                                                                      'mask' => [
                                                                                  1,
                                                                                  1
                                                                                ],
                                                                      'rhs' => [
                                                                                 '[[o]]',
                                                                                 '[[n]]'
                                                                               ],
                                                                      'start' => 3807,
                                                                      'subgrammar' => 'l0',
                                                                      'subkey' => 0
                                                                    },
                                       'l0,[Lex-41],[[o]],[[f]],[[f]]' => {
                                                                            'length' => 5,
                                                                            'lhs' => '[Lex-41]',
                                                                            'mask' => [
                                                                                        1,
                                                                                        1,
                                                                                        1
                                                                                      ],
                                                                            'rhs' => [
                                                                                       '[[o]]',
                                                                                       '[[f]]',
                                                                                       '[[f]]'
                                                                                     ],
                                                                            'start' => 3814,
                                                                            'subgrammar' => 'l0',
                                                                            'subkey' => 0
                                                                          },
                                       'l0,[Lex-42],[[b]],[[l]],[[e]],[[s]],[[s]]' => {
                                                                                        'length' => 7,
                                                                                        'lhs' => '[Lex-42]',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'rhs' => [
                                                                                                   '[[b]]',
                                                                                                   '[[l]]',
                                                                                                   '[[e]]',
                                                                                                   '[[s]]',
                                                                                                   '[[s]]'
                                                                                                 ],
                                                                                        'start' => 3869,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 0
                                                                                      },
                                       'l0,[Lex-43],[[n]],[[a]],[[m]],[[e]]' => {
                                                                                  'length' => 6,
                                                                                  'lhs' => '[Lex-43]',
                                                                                  'mask' => [
                                                                                              1,
                                                                                              1,
                                                                                              1,
                                                                                              1
                                                                                            ],
                                                                                  'rhs' => [
                                                                                             '[[n]]',
                                                                                             '[[a]]',
                                                                                             '[[m]]',
                                                                                             '[[e]]'
                                                                                           ],
                                                                                  'start' => 3913,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0
                                                                                },
                                       'l0,[Lex-44],[[\\(]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-44]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\(]]'
                                                                           ],
                                                                  'start' => 4423,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-45],[[\\)]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-45]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\)]]'
                                                                           ],
                                                                  'start' => 4448,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-46],[[\\*]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-46]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\*]]'
                                                                           ],
                                                                  'start' => 5323,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-47],[[\\+]]' => {
                                                                  'length' => 3,
                                                                  'lhs' => '[Lex-47]',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'rhs' => [
                                                                             '[[\\+]]'
                                                                           ],
                                                                  'start' => 5329,
                                                                  'subgrammar' => 'l0',
                                                                  'subkey' => 0
                                                                },
                                       'l0,[Lex-4],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                       'length' => 7,
                                                                                       'lhs' => '[Lex-4]',
                                                                                       'mask' => [
                                                                                                   1,
                                                                                                   1,
                                                                                                   1,
                                                                                                   1,
                                                                                                   1
                                                                                                 ],
                                                                                       'rhs' => [
                                                                                                  '[[s]]',
                                                                                                  '[[t]]',
                                                                                                  '[[a]]',
                                                                                                  '[[r]]',
                                                                                                  '[[t]]'
                                                                                                ],
                                                                                       'start' => 1190,
                                                                                       'subgrammar' => 'l0',
                                                                                       'subkey' => 0
                                                                                     },
                                       'l0,[Lex-5],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                             'length' => 8,
                                                                                             'lhs' => '[Lex-5]',
                                                                                             'mask' => [
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1
                                                                                                       ],
                                                                                             'rhs' => [
                                                                                                        '[[s]]',
                                                                                                        '[[y]]',
                                                                                                        '[[m]]',
                                                                                                        '[[b]]',
                                                                                                        '[[o]]',
                                                                                                        '[[l]]'
                                                                                                      ],
                                                                                             'start' => 1198,
                                                                                             'subgrammar' => 'l0',
                                                                                             'subkey' => 0
                                                                                           },
                                       'l0,[Lex-6],[[i]],[[s]]' => {
                                                                     'length' => 4,
                                                                     'lhs' => '[Lex-6]',
                                                                     'mask' => [
                                                                                 1,
                                                                                 1
                                                                               ],
                                                                     'rhs' => [
                                                                                '[[i]]',
                                                                                '[[s]]'
                                                                              ],
                                                                     'start' => 1207,
                                                                     'subgrammar' => 'l0',
                                                                     'subkey' => 0
                                                                   },
                                       'l0,[Lex-7],[[\\:]],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                           'length' => 10,
                                                                                                           'lhs' => '[Lex-7]',
                                                                                                           'mask' => [
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1,
                                                                                                                       1
                                                                                                                     ],
                                                                                                           'rhs' => [
                                                                                                                      '[[\\:]]',
                                                                                                                      '[[d]]',
                                                                                                                      '[[e]]',
                                                                                                                      '[[f]]',
                                                                                                                      '[[a]]',
                                                                                                                      '[[u]]',
                                                                                                                      '[[l]]',
                                                                                                                      '[[t]]'
                                                                                                                    ],
                                                                                                           'start' => 1239,
                                                                                                           'subgrammar' => 'l0',
                                                                                                           'subkey' => 0
                                                                                                         },
                                       'l0,[Lex-8],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]' => {
                                                                                             'length' => 8,
                                                                                             'lhs' => '[Lex-8]',
                                                                                             'mask' => [
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1
                                                                                                       ],
                                                                                             'rhs' => [
                                                                                                        '[[l]]',
                                                                                                        '[[e]]',
                                                                                                        '[[x]]',
                                                                                                        '[[e]]',
                                                                                                        '[[m]]',
                                                                                                        '[[e]]'
                                                                                                      ],
                                                                                             'start' => 1313,
                                                                                             'subgrammar' => 'l0',
                                                                                             'subkey' => 0
                                                                                           },
                                       'l0,[Lex-9],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                   'length' => 9,
                                                                                                   'lhs' => '[Lex-9]',
                                                                                                   'mask' => [
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1
                                                                                                             ],
                                                                                                   'rhs' => [
                                                                                                              '[[d]]',
                                                                                                              '[[e]]',
                                                                                                              '[[f]]',
                                                                                                              '[[a]]',
                                                                                                              '[[u]]',
                                                                                                              '[[l]]',
                                                                                                              '[[t]]'
                                                                                                            ],
                                                                                                   'start' => 1322,
                                                                                                   'subgrammar' => 'l0',
                                                                                                   'subkey' => 0
                                                                                                 },
                                       'l0,array descriptor left bracket,[[\\[]]' => {
                                                                                       'length' => 37,
                                                                                       'lhs' => 'array descriptor left bracket',
                                                                                       'mask' => [
                                                                                                   1
                                                                                                 ],
                                                                                       'name' => 'array descriptor left bracket',
                                                                                       'rhs' => [
                                                                                                  '[[\\[]]'
                                                                                                ],
                                                                                       'start' => 6219,
                                                                                       'subgrammar' => 'l0',
                                                                                       'subkey' => 1,
                                                                                       'xrlid' => 'array descriptor left bracket@6219+37'
                                                                                     },
                                       'l0,array descriptor left bracket,[[\\[]],whitespace' => {
                                                                                                  'length' => 48,
                                                                                                  'lhs' => 'array descriptor left bracket',
                                                                                                  'mask' => [
                                                                                                              1,
                                                                                                              1
                                                                                                            ],
                                                                                                  'name' => 'array descriptor left bracket',
                                                                                                  'rhs' => [
                                                                                                             '[[\\[]]',
                                                                                                             'whitespace'
                                                                                                           ],
                                                                                                  'start' => 6258,
                                                                                                  'subgrammar' => 'l0',
                                                                                                  'subkey' => 1,
                                                                                                  'xrlid' => 'array descriptor left bracket@6258+48'
                                                                                                },
                                       'l0,array descriptor right bracket,[[\\]]]' => {
                                                                                        'length' => 38,
                                                                                        'lhs' => 'array descriptor right bracket',
                                                                                        'mask' => [
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'array descriptor right bracket',
                                                                                        'rhs' => [
                                                                                                   '[[\\]]]'
                                                                                                 ],
                                                                                        'start' => 6307,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'array descriptor right bracket@6307+38'
                                                                                      },
                                       'l0,array descriptor right bracket,whitespace,[[\\]]]' => {
                                                                                                   'length' => 49,
                                                                                                   'lhs' => 'array descriptor right bracket',
                                                                                                   'mask' => [
                                                                                                               1,
                                                                                                               1
                                                                                                             ],
                                                                                                   'name' => 'array descriptor right bracket',
                                                                                                   'rhs' => [
                                                                                                              'whitespace',
                                                                                                              '[[\\]]]'
                                                                                                            ],
                                                                                                   'start' => 6347,
                                                                                                   'subgrammar' => 'l0',
                                                                                                   'subkey' => 1,
                                                                                                   'xrlid' => 'array descriptor right bracket@6347+49'
                                                                                                 },
                                       'l0,array descriptor,array descriptor left bracket,result item descriptor list,array descriptor right bracket' => {
                                                                                                                                                           'length' => 115,
                                                                                                                                                           'lhs' => 'array descriptor',
                                                                                                                                                           'mask' => [
                                                                                                                                                                       1,
                                                                                                                                                                       1,
                                                                                                                                                                       1
                                                                                                                                                                     ],
                                                                                                                                                           'name' => 'array descriptor',
                                                                                                                                                           'rhs' => [
                                                                                                                                                                      'array descriptor left bracket',
                                                                                                                                                                      'result item descriptor list',
                                                                                                                                                                      'array descriptor right bracket'
                                                                                                                                                                    ],
                                                                                                                                                           'start' => 6103,
                                                                                                                                                           'subgrammar' => 'l0',
                                                                                                                                                           'subkey' => 1,
                                                                                                                                                           'xrlid' => 'array descriptor@6103+115'
                                                                                                                                                         },
                                       'l0,bare name,[[\\w]]' => {
                                                                   'length' => 19,
                                                                   'lhs' => 'bare name',
                                                                   'min' => 1,
                                                                   'name' => 'bare name',
                                                                   'rhs' => [
                                                                              '[[\\w]]'
                                                                            ],
                                                                   'start' => 5939,
                                                                   'subgrammar' => 'l0',
                                                                   'subkey' => 0,
                                                                   'xrlid' => 'bare name@5939+19'
                                                                 },
                                       'l0,before or after,[[a]],[[f]],[[t]],[[e]],[[r]]' => {
                                                                                               'length' => 7,
                                                                                               'lhs' => 'before or after',
                                                                                               'mask' => [
                                                                                                           1,
                                                                                                           1,
                                                                                                           1,
                                                                                                           1,
                                                                                                           1
                                                                                                         ],
                                                                                               'name' => 'before or after',
                                                                                               'rhs' => [
                                                                                                          '[[a]]',
                                                                                                          '[[f]]',
                                                                                                          '[[t]]',
                                                                                                          '[[e]]',
                                                                                                          '[[r]]'
                                                                                                        ],
                                                                                               'start' => 5364,
                                                                                               'subgrammar' => 'l0',
                                                                                               'subkey' => 2,
                                                                                               'xrlid' => 'before or after@5333+38'
                                                                                             },
                                       'l0,before or after,[[b]],[[e]],[[f]],[[o]],[[r]],[[e]]' => {
                                                                                                     'length' => 38,
                                                                                                     'lhs' => 'before or after',
                                                                                                     'mask' => [
                                                                                                                 1,
                                                                                                                 1,
                                                                                                                 1,
                                                                                                                 1,
                                                                                                                 1,
                                                                                                                 1
                                                                                                               ],
                                                                                                     'name' => 'before or after',
                                                                                                     'rhs' => [
                                                                                                                '[[b]]',
                                                                                                                '[[e]]',
                                                                                                                '[[f]]',
                                                                                                                '[[o]]',
                                                                                                                '[[r]]',
                                                                                                                '[[e]]'
                                                                                                              ],
                                                                                                     'start' => 5333,
                                                                                                     'subgrammar' => 'l0',
                                                                                                     'subkey' => 1,
                                                                                                     'xrlid' => 'before or after@5333+38'
                                                                                                   },
                                       'l0,boolean,[[01]]' => {
                                                                'length' => 14,
                                                                'lhs' => 'boolean',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'name' => 'boolean',
                                                                'rhs' => [
                                                                           '[[01]]'
                                                                         ],
                                                                'start' => 5454,
                                                                'subgrammar' => 'l0',
                                                                'subkey' => 1,
                                                                'xrlid' => 'boolean@5454+14'
                                                              },
                                       'l0,bracketed name string,[[\\s\\w]]' => {
                                                                                  'length' => 33,
                                                                                  'lhs' => 'bracketed name string',
                                                                                  'min' => 1,
                                                                                  'name' => 'bracketed name string',
                                                                                  'rhs' => [
                                                                                             '[[\\s\\w]]'
                                                                                           ],
                                                                                  'start' => 6068,
                                                                                  'subgrammar' => 'l0',
                                                                                  'subkey' => 0,
                                                                                  'xrlid' => 'bracketed name string@6068+33'
                                                                                },
                                       'l0,bracketed name,[[\\<]],bracketed name string,[[\\>]]' => {
                                                                                                      'length' => 50,
                                                                                                      'lhs' => 'bracketed name',
                                                                                                      'mask' => [
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1
                                                                                                                ],
                                                                                                      'name' => 'bracketed name',
                                                                                                      'rhs' => [
                                                                                                                 '[[\\<]]',
                                                                                                                 'bracketed name string',
                                                                                                                 '[[\\>]]'
                                                                                                               ],
                                                                                                      'start' => 6017,
                                                                                                      'subgrammar' => 'l0',
                                                                                                      'subkey' => 1,
                                                                                                      'xrlid' => 'bracketed name@6017+50'
                                                                                                    },
                                       'l0,cc element,escaped cc character' => {
                                                                                 'length' => 37,
                                                                                 'lhs' => 'cc element',
                                                                                 'mask' => [
                                                                                             1
                                                                                           ],
                                                                                 'name' => 'cc element',
                                                                                 'rhs' => [
                                                                                            'escaped cc character'
                                                                                          ],
                                                                                 'start' => 7387,
                                                                                 'subgrammar' => 'l0',
                                                                                 'subkey' => 1,
                                                                                 'xrlid' => 'cc element@7387+37'
                                                                               },
                                       'l0,cc element,negated posix char class' => {
                                                                                     'length' => 41,
                                                                                     'lhs' => 'cc element',
                                                                                     'mask' => [
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'cc element',
                                                                                     'rhs' => [
                                                                                                'negated posix char class'
                                                                                              ],
                                                                                     'start' => 7511,
                                                                                     'subgrammar' => 'l0',
                                                                                     'subkey' => 1,
                                                                                     'xrlid' => 'cc element@7511+41'
                                                                                   },
                                       'l0,cc element,posix char class' => {
                                                                             'length' => 33,
                                                                             'lhs' => 'cc element',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'cc element',
                                                                             'rhs' => [
                                                                                        'posix char class'
                                                                                      ],
                                                                             'start' => 7477,
                                                                             'subgrammar' => 'l0',
                                                                             'subkey' => 1,
                                                                             'xrlid' => 'cc element@7477+33'
                                                                           },
                                       'l0,cc element,safe cc character' => {
                                                                              'length' => 34,
                                                                              'lhs' => 'cc element',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'cc element',
                                                                              'rhs' => [
                                                                                         'safe cc character'
                                                                                       ],
                                                                              'start' => 7239,
                                                                              'subgrammar' => 'l0',
                                                                              'subkey' => 1,
                                                                              'xrlid' => 'cc element@7239+34'
                                                                            },
                                       'l0,cc elements,cc element' => {
                                                                        'length' => 29,
                                                                        'lhs' => 'cc elements',
                                                                        'min' => 1,
                                                                        'name' => 'cc elements',
                                                                        'rhs' => [
                                                                                   'cc element'
                                                                                 ],
                                                                        'start' => 7209,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 0,
                                                                        'xrlid' => 'cc elements@7209+29'
                                                                      },
                                       'l0,character class modifier,[[\\:]],[[i]]' => {
                                                                                        'length' => 33,
                                                                                        'lhs' => 'character class modifier',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'character class modifier',
                                                                                        'rhs' => [
                                                                                                   '[[\\:]]',
                                                                                                   '[[i]]'
                                                                                                 ],
                                                                                        'start' => 7646,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'character class modifier@7646+33'
                                                                                      },
                                       'l0,character class modifier,[[\\:]],[[i]],[[c]]' => {
                                                                                              'length' => 34,
                                                                                              'lhs' => 'character class modifier',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'name' => 'character class modifier',
                                                                                              'rhs' => [
                                                                                                         '[[\\:]]',
                                                                                                         '[[i]]',
                                                                                                         '[[c]]'
                                                                                                       ],
                                                                                              'start' => 7611,
                                                                                              'subgrammar' => 'l0',
                                                                                              'subkey' => 1,
                                                                                              'xrlid' => 'character class modifier@7611+34'
                                                                                            },
                                       'l0,character class modifiers,character class modifier' => {
                                                                                                    'length' => 57,
                                                                                                    'lhs' => 'character class modifiers',
                                                                                                    'min' => 0,
                                                                                                    'name' => 'character class modifiers',
                                                                                                    'rhs' => [
                                                                                                               'character class modifier'
                                                                                                             ],
                                                                                                    'start' => 7553,
                                                                                                    'subgrammar' => 'l0',
                                                                                                    'subkey' => 0,
                                                                                                    'xrlid' => 'character class modifiers@7553+57'
                                                                                                  },
                                       'l0,character class,[[\\[]],cc elements,[[\\]]],character class modifiers' => {
                                                                                                                       'length' => 69,
                                                                                                                       'lhs' => 'character class',
                                                                                                                       'mask' => [
                                                                                                                                   1,
                                                                                                                                   1,
                                                                                                                                   1,
                                                                                                                                   1
                                                                                                                                 ],
                                                                                                                       'name' => 'character class',
                                                                                                                       'rhs' => [
                                                                                                                                  '[[\\[]]',
                                                                                                                                  'cc elements',
                                                                                                                                  '[[\\]]]',
                                                                                                                                  'character class modifiers'
                                                                                                                                ],
                                                                                                                       'start' => 7139,
                                                                                                                       'subgrammar' => 'l0',
                                                                                                                       'subkey' => 1,
                                                                                                                       'xrlid' => 'character class@7139+69'
                                                                                                                     },
                                       'l0,double colon,[[\\:]],[[\\:]]' => {
                                                                              'length' => 21,
                                                                              'lhs' => 'double colon',
                                                                              'mask' => [
                                                                                          1,
                                                                                          1
                                                                                        ],
                                                                              'name' => 'double colon',
                                                                              'rhs' => [
                                                                                         '[[\\:]]',
                                                                                         '[[\\:]]'
                                                                                       ],
                                                                              'start' => 5843,
                                                                              'subgrammar' => 'l0',
                                                                              'subkey' => 1,
                                                                              'xrlid' => 'double colon@5843+21'
                                                                            },
                                       'l0,escaped cc character,[[\\\\]],horizontal character' => {
                                                                                                    'length' => 51,
                                                                                                    'lhs' => 'escaped cc character',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'name' => 'escaped cc character',
                                                                                                    'rhs' => [
                                                                                                               '[[\\\\]]',
                                                                                                               'horizontal character'
                                                                                                             ],
                                                                                                    'start' => 7425,
                                                                                                    'subgrammar' => 'l0',
                                                                                                    'subkey' => 1,
                                                                                                    'xrlid' => 'escaped cc character@7425+51'
                                                                                                  },
                                       'l0,hash comment body,hash comment char' => {
                                                                                     'length' => 42,
                                                                                     'lhs' => 'hash comment body',
                                                                                     'min' => 0,
                                                                                     'name' => 'hash comment body',
                                                                                     'rhs' => [
                                                                                                'hash comment char'
                                                                                              ],
                                                                                     'start' => 5044,
                                                                                     'subgrammar' => 'l0',
                                                                                     'subkey' => 0,
                                                                                     'xrlid' => 'hash comment body@5044+42'
                                                                                   },
                                       'l0,hash comment char,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                   'length' => 61,
                                                                                                                   'lhs' => 'hash comment char',
                                                                                                                   'mask' => [
                                                                                                                               1
                                                                                                                             ],
                                                                                                                   'name' => 'hash comment char',
                                                                                                                   'rhs' => [
                                                                                                                              '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                            ],
                                                                                                                   'start' => 5150,
                                                                                                                   'subgrammar' => 'l0',
                                                                                                                   'subkey' => 1,
                                                                                                                   'xrlid' => 'hash comment char@5150+61'
                                                                                                                 },
                                       'l0,hash comment,terminated hash comment' => {
                                                                                      'length' => 81,
                                                                                      'lhs' => 'hash comment',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'hash comment',
                                                                                      'rhs' => [
                                                                                                 'terminated hash comment'
                                                                                               ],
                                                                                      'start' => 4828,
                                                                                      'subgrammar' => 'l0',
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'hash comment@4828+81'
                                                                                    },
                                       'l0,hash comment,unterminated final hash comment' => {
                                                                                              'length' => 36,
                                                                                              'lhs' => 'hash comment',
                                                                                              'mask' => [
                                                                                                          1
                                                                                                        ],
                                                                                              'name' => 'hash comment',
                                                                                              'rhs' => [
                                                                                                         'unterminated final hash comment'
                                                                                                       ],
                                                                                              'start' => 4873,
                                                                                              'subgrammar' => 'l0',
                                                                                              'subkey' => 2,
                                                                                              'xrlid' => 'hash comment@4828+81'
                                                                                            },
                                       'l0,horizontal character,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                      'length' => 64,
                                                                                                                      'lhs' => 'horizontal character',
                                                                                                                      'mask' => [
                                                                                                                                  1
                                                                                                                                ],
                                                                                                                      'name' => 'horizontal character',
                                                                                                                      'rhs' => [
                                                                                                                                 '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                               ],
                                                                                                                      'start' => 8087,
                                                                                                                      'subgrammar' => 'l0',
                                                                                                                      'subkey' => 1,
                                                                                                                      'xrlid' => 'horizontal character@8087+64'
                                                                                                                    },
                                       'l0,integer,[[\\d]]' => {
                                                                 'length' => 17,
                                                                 'lhs' => 'integer',
                                                                 'min' => 1,
                                                                 'name' => 'integer',
                                                                 'rhs' => [
                                                                            '[[\\d]]'
                                                                          ],
                                                                 'start' => 5435,
                                                                 'subgrammar' => 'l0',
                                                                 'subkey' => 0,
                                                                 'xrlid' => 'integer@5435+17'
                                                               },
                                       'l0,negated posix char class,[[\\[]],[[\\:]],[[\\^]],posix char class name,[[\\:]],[[\\]]]' => {
                                                                                                                                        'length' => 63,
                                                                                                                                        'lhs' => 'negated posix char class',
                                                                                                                                        'mask' => [
                                                                                                                                                    1,
                                                                                                                                                    1,
                                                                                                                                                    1,
                                                                                                                                                    1,
                                                                                                                                                    1,
                                                                                                                                                    1
                                                                                                                                                  ],
                                                                                                                                        'name' => 'negated posix char class',
                                                                                                                                        'rhs' => [
                                                                                                                                                   '[[\\[]]',
                                                                                                                                                   '[[\\:]]',
                                                                                                                                                   '[[\\^]]',
                                                                                                                                                   'posix char class name',
                                                                                                                                                   '[[\\:]]',
                                                                                                                                                   '[[\\]]]'
                                                                                                                                                 ],
                                                                                                                                        'start' => 7914,
                                                                                                                                        'subgrammar' => 'l0',
                                                                                                                                        'subkey' => 1,
                                                                                                                                        'xrlid' => 'negated posix char class@7914+63'
                                                                                                                                      },
                                       'l0,one or more word characters,[[\\w]]' => {
                                                                                     'length' => 37,
                                                                                     'lhs' => 'one or more word characters',
                                                                                     'min' => 1,
                                                                                     'name' => 'one or more word characters',
                                                                                     'rhs' => [
                                                                                                '[[\\w]]'
                                                                                              ],
                                                                                     'start' => 5592,
                                                                                     'subgrammar' => 'l0',
                                                                                     'subkey' => 0,
                                                                                     'xrlid' => 'one or more word characters@5592+37'
                                                                                   },
                                       'l0,op declare bnf,[[\\:]],[[\\:]],[[\\=]]' => {
                                                                                        'length' => 24,
                                                                                        'lhs' => 'op declare bnf',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'op declare bnf',
                                                                                        'rhs' => [
                                                                                                   '[[\\:]]',
                                                                                                   '[[\\:]]',
                                                                                                   '[[\\=]]'
                                                                                                 ],
                                                                                        'start' => 5213,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'op declare bnf@5213+24'
                                                                                      },
                                       'l0,op declare match,[[\\~]]' => {
                                                                          'length' => 24,
                                                                          'lhs' => 'op declare match',
                                                                          'mask' => [
                                                                                      1
                                                                                    ],
                                                                          'name' => 'op declare match',
                                                                          'rhs' => [
                                                                                     '[[\\~]]'
                                                                                   ],
                                                                          'start' => 5238,
                                                                          'subgrammar' => 'l0',
                                                                          'subkey' => 1,
                                                                          'xrlid' => 'op declare match@5238+24'
                                                                        },
                                       'l0,op equal priority,[[\\|]]' => {
                                                                           'length' => 25,
                                                                           'lhs' => 'op equal priority',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'op equal priority',
                                                                           'rhs' => [
                                                                                      '[[\\|]]'
                                                                                    ],
                                                                           'start' => 5282,
                                                                           'subgrammar' => 'l0',
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'op equal priority@5282+25'
                                                                         },
                                       'l0,op loosen,[[\\|]],[[\\|]]' => {
                                                                           'length' => 18,
                                                                           'lhs' => 'op loosen',
                                                                           'mask' => [
                                                                                       1,
                                                                                       1
                                                                                     ],
                                                                           'name' => 'op loosen',
                                                                           'rhs' => [
                                                                                      '[[\\|]]',
                                                                                      '[[\\|]]'
                                                                                    ],
                                                                           'start' => 5263,
                                                                           'subgrammar' => 'l0',
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'op loosen@5263+18'
                                                                         },
                                       'l0,posix char class name,[[[:alnum:]]]' => {
                                                                                     'length' => 38,
                                                                                     'lhs' => 'posix char class name',
                                                                                     'min' => 1,
                                                                                     'name' => 'posix char class name',
                                                                                     'rhs' => [
                                                                                                '[[[:alnum:]]]'
                                                                                              ],
                                                                                     'start' => 7978,
                                                                                     'subgrammar' => 'l0',
                                                                                     'subkey' => 0,
                                                                                     'xrlid' => 'posix char class name@7978+38'
                                                                                   },
                                       'l0,posix char class,[[\\[]],[[\\:]],posix char class name,[[\\:]],[[\\]]]' => {
                                                                                                                        'length' => 54,
                                                                                                                        'lhs' => 'posix char class',
                                                                                                                        'mask' => [
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1
                                                                                                                                  ],
                                                                                                                        'name' => 'posix char class',
                                                                                                                        'rhs' => [
                                                                                                                                   '[[\\[]]',
                                                                                                                                   '[[\\:]]',
                                                                                                                                   'posix char class name',
                                                                                                                                   '[[\\:]]',
                                                                                                                                   '[[\\]]]'
                                                                                                                                 ],
                                                                                                                        'start' => 7859,
                                                                                                                        'subgrammar' => 'l0',
                                                                                                                        'subkey' => 1,
                                                                                                                        'xrlid' => 'posix char class@7859+54'
                                                                                                                      },
                                       'l0,reserved action name,[[\\:]],[[\\:]],one or more word characters' => {
                                                                                                                  'length' => 59,
                                                                                                                  'lhs' => 'reserved action name',
                                                                                                                  'mask' => [
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'reserved action name',
                                                                                                                  'rhs' => [
                                                                                                                             '[[\\:]]',
                                                                                                                             '[[\\:]]',
                                                                                                                             'one or more word characters'
                                                                                                                           ],
                                                                                                                  'start' => 5470,
                                                                                                                  'subgrammar' => 'l0',
                                                                                                                  'subkey' => 1,
                                                                                                                  'xrlid' => 'reserved action name@5470+59'
                                                                                                                },
                                       'l0,reserved blessing name,[[\\:]],[[\\:]],one or more word characters' => {
                                                                                                                    'length' => 61,
                                                                                                                    'lhs' => 'reserved blessing name',
                                                                                                                    'mask' => [
                                                                                                                                1,
                                                                                                                                1,
                                                                                                                                1
                                                                                                                              ],
                                                                                                                    'name' => 'reserved blessing name',
                                                                                                                    'rhs' => [
                                                                                                                               '[[\\:]]',
                                                                                                                               '[[\\:]]',
                                                                                                                               'one or more word characters'
                                                                                                                             ],
                                                                                                                    'start' => 5530,
                                                                                                                    'subgrammar' => 'l0',
                                                                                                                    'subkey' => 1,
                                                                                                                    'xrlid' => 'reserved blessing name@5530+61'
                                                                                                                  },
                                       'l0,reserved event name,[[\\:]],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                                                 'length' => 33,
                                                                                                                 'lhs' => 'reserved event name',
                                                                                                                 'mask' => [
                                                                                                                             1,
                                                                                                                             1,
                                                                                                                             1,
                                                                                                                             1,
                                                                                                                             1,
                                                                                                                             1,
                                                                                                                             1
                                                                                                                           ],
                                                                                                                 'name' => 'reserved event name',
                                                                                                                 'rhs' => [
                                                                                                                            '[[\\:]]',
                                                                                                                            '[[s]]',
                                                                                                                            '[[y]]',
                                                                                                                            '[[m]]',
                                                                                                                            '[[b]]',
                                                                                                                            '[[o]]',
                                                                                                                            '[[l]]'
                                                                                                                          ],
                                                                                                                 'start' => 4097,
                                                                                                                 'subgrammar' => 'l0',
                                                                                                                 'subkey' => 1,
                                                                                                                 'xrlid' => 'reserved event name@4097+33'
                                                                                                               },
                                       'l0,result item descriptor list,result item descriptor' => {
                                                                                                    'length' => 105,
                                                                                                    'lhs' => 'result item descriptor list',
                                                                                                    'min' => 0,
                                                                                                    'name' => 'result item descriptor list',
                                                                                                    'rhs' => [
                                                                                                               'result item descriptor'
                                                                                                             ],
                                                                                                    'separator' => 'result item descriptor separator',
                                                                                                    'start' => 6398,
                                                                                                    'subgrammar' => 'l0',
                                                                                                    'subkey' => 0,
                                                                                                    'xrlid' => 'result item descriptor list@6398+105'
                                                                                                  },
                                       'l0,result item descriptor separator,[[,]]' => {
                                                                                        'length' => 40,
                                                                                        'lhs' => 'result item descriptor separator',
                                                                                        'mask' => [
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'result item descriptor separator',
                                                                                        'rhs' => [
                                                                                                   '[[,]]'
                                                                                                 ],
                                                                                        'start' => 6504,
                                                                                        'subgrammar' => 'l0',
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'result item descriptor separator@6504+40'
                                                                                      },
                                       'l0,result item descriptor separator,[[,]],whitespace' => {
                                                                                                   'length' => 51,
                                                                                                   'lhs' => 'result item descriptor separator',
                                                                                                   'mask' => [
                                                                                                               1,
                                                                                                               1
                                                                                                             ],
                                                                                                   'name' => 'result item descriptor separator',
                                                                                                   'rhs' => [
                                                                                                              '[[,]]',
                                                                                                              'whitespace'
                                                                                                            ],
                                                                                                   'start' => 6545,
                                                                                                   'subgrammar' => 'l0',
                                                                                                   'subkey' => 1,
                                                                                                   'xrlid' => 'result item descriptor separator@6545+51'
                                                                                                 },
                                       'l0,result item descriptor,[[g]],[[1]],[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]' => {
                                                                                                                        'length' => 10,
                                                                                                                        'lhs' => 'result item descriptor',
                                                                                                                        'mask' => [
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1,
                                                                                                                                    1
                                                                                                                                  ],
                                                                                                                        'name' => 'result item descriptor',
                                                                                                                        'rhs' => [
                                                                                                                                   '[[g]]',
                                                                                                                                   '[[1]]',
                                                                                                                                   '[[l]]',
                                                                                                                                   '[[e]]',
                                                                                                                                   '[[n]]',
                                                                                                                                   '[[g]]',
                                                                                                                                   '[[t]]',
                                                                                                                                   '[[h]]'
                                                                                                                                 ],
                                                                                                                        'start' => 6659,
                                                                                                                        'subgrammar' => 'l0',
                                                                                                                        'subkey' => 4,
                                                                                                                        'xrlid' => 'result item descriptor@6597+135'
                                                                                                                      },
                                       'l0,result item descriptor,[[g]],[[1]],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                                                  'length' => 9,
                                                                                                                  'lhs' => 'result item descriptor',
                                                                                                                  'mask' => [
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'result item descriptor',
                                                                                                                  'rhs' => [
                                                                                                                             '[[g]]',
                                                                                                                             '[[1]]',
                                                                                                                             '[[s]]',
                                                                                                                             '[[t]]',
                                                                                                                             '[[a]]',
                                                                                                                             '[[r]]',
                                                                                                                             '[[t]]'
                                                                                                                           ],
                                                                                                                  'start' => 6647,
                                                                                                                  'subgrammar' => 'l0',
                                                                                                                  'subkey' => 3,
                                                                                                                  'xrlid' => 'result item descriptor@6597+135'
                                                                                                                },
                                       'l0,result item descriptor,[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]' => {
                                                                                                            'length' => 8,
                                                                                                            'lhs' => 'result item descriptor',
                                                                                                            'mask' => [
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1
                                                                                                                      ],
                                                                                                            'name' => 'result item descriptor',
                                                                                                            'rhs' => [
                                                                                                                       '[[l]]',
                                                                                                                       '[[e]]',
                                                                                                                       '[[n]]',
                                                                                                                       '[[g]]',
                                                                                                                       '[[t]]',
                                                                                                                       '[[h]]'
                                                                                                                     ],
                                                                                                            'start' => 6634,
                                                                                                            'subgrammar' => 'l0',
                                                                                                            'subkey' => 2,
                                                                                                            'xrlid' => 'result item descriptor@6597+135'
                                                                                                          },
                                       'l0,result item descriptor,[[l]],[[h]],[[s]]' => {
                                                                                          'length' => 5,
                                                                                          'lhs' => 'result item descriptor',
                                                                                          'mask' => [
                                                                                                      1,
                                                                                                      1,
                                                                                                      1
                                                                                                    ],
                                                                                          'name' => 'result item descriptor',
                                                                                          'rhs' => [
                                                                                                     '[[l]]',
                                                                                                     '[[h]]',
                                                                                                     '[[s]]'
                                                                                                   ],
                                                                                          'start' => 6683,
                                                                                          'subgrammar' => 'l0',
                                                                                          'subkey' => 6,
                                                                                          'xrlid' => 'result item descriptor@6597+135'
                                                                                        },
                                       'l0,result item descriptor,[[n]],[[a]],[[m]],[[e]]' => {
                                                                                                'length' => 6,
                                                                                                'lhs' => 'result item descriptor',
                                                                                                'mask' => [
                                                                                                            1,
                                                                                                            1,
                                                                                                            1,
                                                                                                            1
                                                                                                          ],
                                                                                                'name' => 'result item descriptor',
                                                                                                'rhs' => [
                                                                                                           '[[n]]',
                                                                                                           '[[a]]',
                                                                                                           '[[m]]',
                                                                                                           '[[e]]'
                                                                                                         ],
                                                                                                'start' => 6674,
                                                                                                'subgrammar' => 'l0',
                                                                                                'subkey' => 5,
                                                                                                'xrlid' => 'result item descriptor@6597+135'
                                                                                              },
                                       'l0,result item descriptor,[[r]],[[u]],[[l]],[[e]]' => {
                                                                                                'length' => 6,
                                                                                                'lhs' => 'result item descriptor',
                                                                                                'mask' => [
                                                                                                            1,
                                                                                                            1,
                                                                                                            1,
                                                                                                            1
                                                                                                          ],
                                                                                                'name' => 'result item descriptor',
                                                                                                'rhs' => [
                                                                                                           '[[r]]',
                                                                                                           '[[u]]',
                                                                                                           '[[l]]',
                                                                                                           '[[e]]'
                                                                                                         ],
                                                                                                'start' => 6702,
                                                                                                'subgrammar' => 'l0',
                                                                                                'subkey' => 8,
                                                                                                'xrlid' => 'result item descriptor@6597+135'
                                                                                              },
                                       'l0,result item descriptor,[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                                      'length' => 135,
                                                                                                      'lhs' => 'result item descriptor',
                                                                                                      'mask' => [
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1
                                                                                                                ],
                                                                                                      'name' => 'result item descriptor',
                                                                                                      'rhs' => [
                                                                                                                 '[[s]]',
                                                                                                                 '[[t]]',
                                                                                                                 '[[a]]',
                                                                                                                 '[[r]]',
                                                                                                                 '[[t]]'
                                                                                                               ],
                                                                                                      'start' => 6597,
                                                                                                      'subgrammar' => 'l0',
                                                                                                      'subkey' => 1,
                                                                                                      'xrlid' => 'result item descriptor@6597+135'
                                                                                                    },
                                       'l0,result item descriptor,[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                                            'length' => 8,
                                                                                                            'lhs' => 'result item descriptor',
                                                                                                            'mask' => [
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1
                                                                                                                      ],
                                                                                                            'name' => 'result item descriptor',
                                                                                                            'rhs' => [
                                                                                                                       '[[s]]',
                                                                                                                       '[[y]]',
                                                                                                                       '[[m]]',
                                                                                                                       '[[b]]',
                                                                                                                       '[[o]]',
                                                                                                                       '[[l]]'
                                                                                                                     ],
                                                                                                            'start' => 6691,
                                                                                                            'subgrammar' => 'l0',
                                                                                                            'subkey' => 7,
                                                                                                            'xrlid' => 'result item descriptor@6597+135'
                                                                                                          },
                                       'l0,result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]]' => {
                                                                                                      'length' => 7,
                                                                                                      'lhs' => 'result item descriptor',
                                                                                                      'mask' => [
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1,
                                                                                                                  1
                                                                                                                ],
                                                                                                      'name' => 'result item descriptor',
                                                                                                      'rhs' => [
                                                                                                                 '[[v]]',
                                                                                                                 '[[a]]',
                                                                                                                 '[[l]]',
                                                                                                                 '[[u]]',
                                                                                                                 '[[e]]'
                                                                                                               ],
                                                                                                      'start' => 6714,
                                                                                                      'subgrammar' => 'l0',
                                                                                                      'subkey' => 9,
                                                                                                      'xrlid' => 'result item descriptor@6597+135'
                                                                                                    },
                                       'l0,result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]],[[s]]' => {
                                                                                                            'length' => 8,
                                                                                                            'lhs' => 'result item descriptor',
                                                                                                            'mask' => [
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1,
                                                                                                                        1
                                                                                                                      ],
                                                                                                            'name' => 'result item descriptor',
                                                                                                            'rhs' => [
                                                                                                                       '[[v]]',
                                                                                                                       '[[a]]',
                                                                                                                       '[[l]]',
                                                                                                                       '[[u]]',
                                                                                                                       '[[e]]',
                                                                                                                       '[[s]]'
                                                                                                                     ],
                                                                                                            'start' => 6724,
                                                                                                            'subgrammar' => 'l0',
                                                                                                            'subkey' => 10,
                                                                                                            'xrlid' => 'result item descriptor@6597+135'
                                                                                                          },
                                       'l0,safe cc character,[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                                       'length' => 79,
                                                                                                                                       'lhs' => 'safe cc character',
                                                                                                                                       'mask' => [
                                                                                                                                                   1
                                                                                                                                                 ],
                                                                                                                                       'name' => 'safe cc character',
                                                                                                                                       'rhs' => [
                                                                                                                                                  '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                                                ],
                                                                                                                                       'start' => 7307,
                                                                                                                                       'subgrammar' => 'l0',
                                                                                                                                       'subkey' => 1,
                                                                                                                                       'xrlid' => 'safe cc character@7307+79'
                                                                                                                                     },
                                       'l0,sign,[[+-]]' => {
                                                             'length' => 13,
                                                             'lhs' => 'sign',
                                                             'mask' => [
                                                                         1
                                                                       ],
                                                             'name' => 'sign',
                                                             'rhs' => [
                                                                        '[[+-]]'
                                                                      ],
                                                             'start' => 5421,
                                                             'subgrammar' => 'l0',
                                                             'subkey' => 1,
                                                             'xrlid' => 'sign@5421+13'
                                                           },
                                       'l0,signed integer,integer' => {
                                                                        'length' => 47,
                                                                        'lhs' => 'signed integer',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'signed integer',
                                                                        'rhs' => [
                                                                                   'integer'
                                                                                 ],
                                                                        'start' => 5373,
                                                                        'subgrammar' => 'l0',
                                                                        'subkey' => 1,
                                                                        'xrlid' => 'signed integer@5373+47'
                                                                      },
                                       'l0,signed integer,sign,integer' => {
                                                                             'length' => 16,
                                                                             'lhs' => 'signed integer',
                                                                             'mask' => [
                                                                                         1,
                                                                                         1
                                                                                       ],
                                                                             'name' => 'signed integer',
                                                                             'rhs' => [
                                                                                        'sign',
                                                                                        'integer'
                                                                                      ],
                                                                             'start' => 5404,
                                                                             'subgrammar' => 'l0',
                                                                             'subkey' => 2,
                                                                             'xrlid' => 'signed integer@5373+47'
                                                                           },
                                       'l0,single quoted name,[[\']],string without single quote or vertical space,[[\']]' => {
                                                                                                                                'length' => 78,
                                                                                                                                'lhs' => 'single quoted name',
                                                                                                                                'mask' => [
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1
                                                                                                                                          ],
                                                                                                                                'name' => 'single quoted name',
                                                                                                                                'rhs' => [
                                                                                                                                           '[[\']]',
                                                                                                                                           'string without single quote or vertical space',
                                                                                                                                           '[[\']]'
                                                                                                                                         ],
                                                                                                                                'start' => 6955,
                                                                                                                                'subgrammar' => 'l0',
                                                                                                                                'subkey' => 1,
                                                                                                                                'xrlid' => 'single quoted name@6955+78'
                                                                                                                              },
                                       'l0,single quoted string,[[\']],string without single quote or vertical space,[[\']],character class modifiers' => {
                                                                                                                                                            'length' => 108,
                                                                                                                                                            'lhs' => 'single quoted string',
                                                                                                                                                            'mask' => [
                                                                                                                                                                        1,
                                                                                                                                                                        1,
                                                                                                                                                                        1,
                                                                                                                                                                        1
                                                                                                                                                                      ],
                                                                                                                                                            'name' => 'single quoted string',
                                                                                                                                                            'rhs' => [
                                                                                                                                                                       '[[\']]',
                                                                                                                                                                       'string without single quote or vertical space',
                                                                                                                                                                       '[[\']]',
                                                                                                                                                                       'character class modifiers'
                                                                                                                                                                     ],
                                                                                                                                                            'start' => 6846,
                                                                                                                                                            'subgrammar' => 'l0',
                                                                                                                                                            'subkey' => 1,
                                                                                                                                                            'xrlid' => 'single quoted string@6846+108'
                                                                                                                                                          },
                                       'l0,standard name,[[a-zA-Z]],zero or more word characters' => {
                                                                                                       'length' => 57,
                                                                                                       'lhs' => 'standard name',
                                                                                                       'mask' => [
                                                                                                                   1,
                                                                                                                   1
                                                                                                                 ],
                                                                                                       'name' => 'standard name',
                                                                                                       'rhs' => [
                                                                                                                  '[[a-zA-Z]]',
                                                                                                                  'zero or more word characters'
                                                                                                                ],
                                                                                                       'start' => 5959,
                                                                                                       'subgrammar' => 'l0',
                                                                                                       'subkey' => 1,
                                                                                                       'xrlid' => 'standard name@5959+57'
                                                                                                     },
                                       'l0,string without single quote or vertical space,[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                                                              'length' => 103,
                                                                                                                                                              'lhs' => 'string without single quote or vertical space',
                                                                                                                                                              'min' => 1,
                                                                                                                                                              'name' => 'string without single quote or vertical space',
                                                                                                                                                              'rhs' => [
                                                                                                                                                                         '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                                                                       ],
                                                                                                                                                              'start' => 7034,
                                                                                                                                                              'subgrammar' => 'l0',
                                                                                                                                                              'subkey' => 0,
                                                                                                                                                              'xrlid' => 'string without single quote or vertical space@7034+103'
                                                                                                                                                            },
                                       'l0,terminated hash comment,[[\\#]],hash comment body,vertical space char' => {
                                                                                                                       'length' => 73,
                                                                                                                       'lhs' => 'terminated hash comment',
                                                                                                                       'mask' => [
                                                                                                                                   1,
                                                                                                                                   1,
                                                                                                                                   1
                                                                                                                                 ],
                                                                                                                       'name' => 'terminated hash comment',
                                                                                                                       'rhs' => [
                                                                                                                                  '[[\\#]]',
                                                                                                                                  'hash comment body',
                                                                                                                                  'vertical space char'
                                                                                                                                ],
                                                                                                                       'start' => 4910,
                                                                                                                       'subgrammar' => 'l0',
                                                                                                                       'subkey' => 1,
                                                                                                                       'xrlid' => 'terminated hash comment@4910+73'
                                                                                                                     },
                                       'l0,unterminated final hash comment,[[\\#]],hash comment body' => {
                                                                                                           'length' => 59,
                                                                                                           'lhs' => 'unterminated final hash comment',
                                                                                                           'mask' => [
                                                                                                                       1,
                                                                                                                       1
                                                                                                                     ],
                                                                                                           'name' => 'unterminated final hash comment',
                                                                                                           'rhs' => [
                                                                                                                      '[[\\#]]',
                                                                                                                      'hash comment body'
                                                                                                                    ],
                                                                                                           'start' => 4984,
                                                                                                           'subgrammar' => 'l0',
                                                                                                           'subkey' => 1,
                                                                                                           'xrlid' => 'unterminated final hash comment@4984+59'
                                                                                                         },
                                       'l0,vertical space char,[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                    'length' => 62,
                                                                                                                    'lhs' => 'vertical space char',
                                                                                                                    'mask' => [
                                                                                                                                1
                                                                                                                              ],
                                                                                                                    'name' => 'vertical space char',
                                                                                                                    'rhs' => [
                                                                                                                               '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                             ],
                                                                                                                    'start' => 5087,
                                                                                                                    'subgrammar' => 'l0',
                                                                                                                    'subkey' => 1,
                                                                                                                    'xrlid' => 'vertical space char@5087+62'
                                                                                                                  },
                                       'l0,whitespace,[[\\s]]' => {
                                                                    'length' => 18,
                                                                    'lhs' => 'whitespace',
                                                                    'min' => 1,
                                                                    'name' => 'whitespace',
                                                                    'rhs' => [
                                                                               '[[\\s]]'
                                                                             ],
                                                                    'start' => 4765,
                                                                    'subgrammar' => 'l0',
                                                                    'subkey' => 0,
                                                                    'xrlid' => 'whitespace@4765+18'
                                                                  },
                                       'l0,zero or more word characters,[[\\w]]' => {
                                                                                      'length' => 38,
                                                                                      'lhs' => 'zero or more word characters',
                                                                                      'min' => 0,
                                                                                      'name' => 'zero or more word characters',
                                                                                      'rhs' => [
                                                                                                 '[[\\w]]'
                                                                                               ],
                                                                                      'start' => 5630,
                                                                                      'subgrammar' => 'l0',
                                                                                      'subkey' => 0,
                                                                                      'xrlid' => 'zero or more word characters@5630+38'
                                                                                    }
                                     }
                           },
                  'xrl' => {
                             'Perl identifier@5817+25' => {
                                                            'length' => 25,
                                                            'lhs' => 'Perl identifier',
                                                            'precedence_count' => 1,
                                                            'start' => 5817
                                                          },
                             'Perl name@5865+72' => {
                                                      'length' => 72,
                                                      'lhs' => 'Perl name',
                                                      'precedence_count' => 1,
                                                      'start' => 5865
                                                    },
                             'action name@4634+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4634
                                                      },
                             'action name@4664+40' => {
                                                        'length' => 40,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4664
                                                      },
                             'action name@4705+36' => {
                                                        'length' => 36,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4705
                                                      },
                             'action@2900+40' => {
                                                   'length' => 40,
                                                   'lhs' => 'action',
                                                   'precedence_count' => 1,
                                                   'start' => 2900
                                                 },
                             'adverb item@2507+369' => {
                                                         'length' => 369,
                                                         'lhs' => 'adverb item',
                                                         'precedence_count' => 1,
                                                         'start' => 2507
                                                       },
                             'adverb list items@2468+38' => {
                                                              'length' => 38,
                                                              'lhs' => 'adverb list items',
                                                              'precedence_count' => 1,
                                                              'start' => 2468
                                                            },
                             'adverb list@2430+37' => {
                                                        'length' => 37,
                                                        'lhs' => 'adverb list',
                                                        'precedence_count' => 1,
                                                        'start' => 2430
                                                      },
                             'alternative name@3946+61' => {
                                                             'length' => 61,
                                                             'lhs' => 'alternative name',
                                                             'precedence_count' => 1,
                                                             'start' => 3946
                                                           },
                             'alternative@2395+33' => {
                                                        'length' => 33,
                                                        'lhs' => 'alternative',
                                                        'precedence_count' => 1,
                                                        'start' => 2395
                                                      },
                             'alternatives@2316+78' => {
                                                         'length' => 78,
                                                         'lhs' => 'alternatives',
                                                         'precedence_count' => 1,
                                                         'start' => 2316
                                                       },
                             'array descriptor left bracket@6219+37' => {
                                                                          'length' => 37,
                                                                          'lhs' => 'array descriptor left bracket',
                                                                          'precedence_count' => 1,
                                                                          'start' => 6219
                                                                        },
                             'array descriptor left bracket@6258+48' => {
                                                                          'length' => 48,
                                                                          'lhs' => 'array descriptor left bracket',
                                                                          'precedence_count' => 1,
                                                                          'start' => 6258
                                                                        },
                             'array descriptor right bracket@6307+38' => {
                                                                           'length' => 38,
                                                                           'lhs' => 'array descriptor right bracket',
                                                                           'precedence_count' => 1,
                                                                           'start' => 6307
                                                                         },
                             'array descriptor right bracket@6347+49' => {
                                                                           'length' => 49,
                                                                           'lhs' => 'array descriptor right bracket',
                                                                           'precedence_count' => 1,
                                                                           'start' => 6347
                                                                         },
                             'array descriptor@6103+115' => {
                                                              'length' => 115,
                                                              'lhs' => 'array descriptor',
                                                              'precedence_count' => 1,
                                                              'start' => 6103
                                                            },
                             'bare name@5939+19' => {
                                                      'length' => 19,
                                                      'lhs' => 'bare name',
                                                      'precedence_count' => 1,
                                                      'start' => 5939
                                                    },
                             'before or after@5333+38' => {
                                                            'length' => 38,
                                                            'lhs' => 'before or after',
                                                            'precedence_count' => 1,
                                                            'start' => 5333
                                                          },
                             'blessing name@4132+35' => {
                                                          'length' => 35,
                                                          'lhs' => 'blessing name',
                                                          'precedence_count' => 1,
                                                          'start' => 4132
                                                        },
                             'blessing name@4168+44' => {
                                                          'length' => 44,
                                                          'lhs' => 'blessing name',
                                                          'precedence_count' => 1,
                                                          'start' => 4168
                                                        },
                             'blessing@3853+45' => {
                                                     'length' => 45,
                                                     'lhs' => 'blessing',
                                                     'precedence_count' => 1,
                                                     'start' => 3853
                                                   },
                             'boolean@5454+14' => {
                                                    'length' => 14,
                                                    'lhs' => 'boolean',
                                                    'precedence_count' => 1,
                                                    'start' => 5454
                                                  },
                             'bracketed name string@6068+33' => {
                                                                  'length' => 33,
                                                                  'lhs' => 'bracketed name string',
                                                                  'precedence_count' => 1,
                                                                  'start' => 6068
                                                                },
                             'bracketed name@6017+50' => {
                                                           'length' => 50,
                                                           'lhs' => 'bracketed name',
                                                           'precedence_count' => 1,
                                                           'start' => 6017
                                                         },
                             'cc element@7239+34' => {
                                                       'length' => 34,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7239
                                                     },
                             'cc element@7387+37' => {
                                                       'length' => 37,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7387
                                                     },
                             'cc element@7477+33' => {
                                                       'length' => 33,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7477
                                                     },
                             'cc element@7511+41' => {
                                                       'length' => 41,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7511
                                                     },
                             'cc elements@7209+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'cc elements',
                                                        'precedence_count' => 1,
                                                        'start' => 7209
                                                      },
                             'character class modifier@7611+34' => {
                                                                     'length' => 34,
                                                                     'lhs' => 'character class modifier',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7611
                                                                   },
                             'character class modifier@7646+33' => {
                                                                     'length' => 33,
                                                                     'lhs' => 'character class modifier',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7646
                                                                   },
                             'character class modifiers@7553+57' => {
                                                                      'length' => 57,
                                                                      'lhs' => 'character class modifiers',
                                                                      'precedence_count' => 1,
                                                                      'start' => 7553
                                                                    },
                             'character class@7139+69' => {
                                                            'length' => 69,
                                                            'lhs' => 'character class',
                                                            'precedence_count' => 1,
                                                            'start' => 7139
                                                          },
                             'completion event declaration@1750+99' => {
                                                                         'length' => 99,
                                                                         'lhs' => 'completion event declaration',
                                                                         'precedence_count' => 1,
                                                                         'start' => 1750
                                                                       },
                             'default rule@1220+60' => {
                                                         'length' => 60,
                                                         'lhs' => 'default rule',
                                                         'precedence_count' => 1,
                                                         'start' => 1220
                                                       },
                             'discard default statement@1351+71' => {
                                                                      'length' => 71,
                                                                      'lhs' => 'discard default statement',
                                                                      'precedence_count' => 1,
                                                                      'start' => 1351
                                                                    },
                             'discard rule@1599+80' => {
                                                         'length' => 80,
                                                         'lhs' => 'discard rule',
                                                         'precedence_count' => 1,
                                                         'start' => 1599
                                                       },
                             'double colon@5843+21' => {
                                                         'length' => 21,
                                                         'lhs' => 'double colon',
                                                         'precedence_count' => 1,
                                                         'start' => 5843
                                                       },
                             'eager specification@3196+48' => {
                                                                'length' => 48,
                                                                'lhs' => 'eager specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3196
                                                              },
                             'empty rule@1471+47' => {
                                                       'length' => 47,
                                                       'lhs' => 'empty rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1471
                                                     },
                             'escaped cc character@7425+51' => {
                                                                 'length' => 51,
                                                                 'lhs' => 'escaped cc character',
                                                                 'precedence_count' => 1,
                                                                 'start' => 7425
                                                               },
                             'event initialization@3689+59' => {
                                                                 'length' => 59,
                                                                 'lhs' => 'event initialization',
                                                                 'precedence_count' => 1,
                                                                 'start' => 3689
                                                               },
                             'event initializer@3749+41' => {
                                                              'length' => 41,
                                                              'lhs' => 'event initializer',
                                                              'precedence_count' => 1,
                                                              'start' => 3749
                                                            },
                             'event initializer@3820+23' => {
                                                              'length' => 23,
                                                              'lhs' => 'event initializer',
                                                              'precedence_count' => 1,
                                                              'start' => 3820
                                                            },
                             'event name@4009+87' => {
                                                       'length' => 87,
                                                       'lhs' => 'event name',
                                                       'precedence_count' => 1,
                                                       'start' => 4009
                                                     },
                             'event specification@3625+63' => {
                                                                'length' => 63,
                                                                'lhs' => 'event specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3625
                                                              },
                             'group association@3033+46' => {
                                                              'length' => 46,
                                                              'lhs' => 'group association',
                                                              'precedence_count' => 1,
                                                              'start' => 3033
                                                            },
                             'hash comment body@5044+42' => {
                                                              'length' => 42,
                                                              'lhs' => 'hash comment body',
                                                              'precedence_count' => 1,
                                                              'start' => 5044
                                                            },
                             'hash comment char@5150+61' => {
                                                              'length' => 61,
                                                              'lhs' => 'hash comment char',
                                                              'precedence_count' => 1,
                                                              'start' => 5150
                                                            },
                             'hash comment@4828+81' => {
                                                         'length' => 81,
                                                         'lhs' => 'hash comment',
                                                         'precedence_count' => 1,
                                                         'start' => 4828
                                                       },
                             'horizontal character@8087+64' => {
                                                                 'length' => 64,
                                                                 'lhs' => 'horizontal character',
                                                                 'precedence_count' => 1,
                                                                 'start' => 8087
                                                               },
                             'inaccessible statement@2044+92' => {
                                                                   'length' => 92,
                                                                   'lhs' => 'inaccessible statement',
                                                                   'precedence_count' => 1,
                                                                   'start' => 2044
                                                                 },
                             'inaccessible treatment@2137+52' => {
                                                                   'length' => 52,
                                                                   'lhs' => 'inaccessible treatment',
                                                                   'precedence_count' => 1,
                                                                   'start' => 2137
                                                                 },
                             'integer@5435+17' => {
                                                    'length' => 17,
                                                    'lhs' => 'integer',
                                                    'precedence_count' => 1,
                                                    'start' => 5435
                                                  },
                             'left association@2941+44' => {
                                                             'length' => 44,
                                                             'lhs' => 'left association',
                                                             'precedence_count' => 1,
                                                             'start' => 2941
                                                           },
                             'lexeme default statement@1281+69' => {
                                                                     'length' => 69,
                                                                     'lhs' => 'lexeme default statement',
                                                                     'precedence_count' => 1,
                                                                     'start' => 1281
                                                                   },
                             'lexeme rule@1680+69' => {
                                                        'length' => 69,
                                                        'lhs' => 'lexeme rule',
                                                        'precedence_count' => 1,
                                                        'start' => 1680
                                                      },
                             'lhs@4214+21' => {
                                                'length' => 21,
                                                'lhs' => 'lhs',
                                                'precedence_count' => 1,
                                                'start' => 4214
                                              },
                             'naming@3899+45' => {
                                                   'length' => 45,
                                                   'lhs' => 'naming',
                                                   'precedence_count' => 1,
                                                   'start' => 3899
                                                 },
                             'negated posix char class@7914+63' => {
                                                                     'length' => 63,
                                                                     'lhs' => 'negated posix char class',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7914
                                                                   },
                             'null adverb@2878+21' => {
                                                        'length' => 21,
                                                        'lhs' => 'null adverb',
                                                        'precedence_count' => 1,
                                                        'start' => 2878
                                                      },
                             'null ranking constant@3458+42' => {
                                                                  'length' => 42,
                                                                  'lhs' => 'null ranking constant',
                                                                  'precedence_count' => 1,
                                                                  'start' => 3458
                                                                },
                             'null ranking specification@3301+78' => {
                                                                       'length' => 78,
                                                                       'lhs' => 'null ranking specification',
                                                                       'precedence_count' => 1,
                                                                       'start' => 3301
                                                                     },
                             'null ranking specification@3380+77' => {
                                                                       'length' => 77,
                                                                       'lhs' => 'null ranking specification',
                                                                       'precedence_count' => 1,
                                                                       'start' => 3380
                                                                     },
                             'null statement@1052+24' => {
                                                           'length' => 24,
                                                           'lhs' => 'null statement',
                                                           'precedence_count' => 1,
                                                           'start' => 1052
                                                         },
                             'nulled event declaration@1850+92' => {
                                                                     'length' => 92,
                                                                     'lhs' => 'nulled event declaration',
                                                                     'precedence_count' => 1,
                                                                     'start' => 1850
                                                                   },
                             'on or off@3791+28' => {
                                                      'length' => 28,
                                                      'lhs' => 'on or off',
                                                      'precedence_count' => 1,
                                                      'start' => 3791
                                                    },
                             'one or more word characters@5592+37' => {
                                                                        'length' => 37,
                                                                        'lhs' => 'one or more word characters',
                                                                        'precedence_count' => 1,
                                                                        'start' => 5592
                                                                      },
                             'op declare bnf@5213+24' => {
                                                           'length' => 24,
                                                           'lhs' => 'op declare bnf',
                                                           'precedence_count' => 1,
                                                           'start' => 5213
                                                         },
                             'op declare match@5238+24' => {
                                                             'length' => 24,
                                                             'lhs' => 'op declare match',
                                                             'precedence_count' => 1,
                                                             'start' => 5238
                                                           },
                             'op declare@2191+54' => {
                                                       'length' => 54,
                                                       'lhs' => 'op declare',
                                                       'precedence_count' => 1,
                                                       'start' => 2191
                                                     },
                             'op equal priority@5282+25' => {
                                                              'length' => 25,
                                                              'lhs' => 'op equal priority',
                                                              'precedence_count' => 1,
                                                              'start' => 5282
                                                            },
                             'op loosen@5263+18' => {
                                                      'length' => 18,
                                                      'lhs' => 'op loosen',
                                                      'precedence_count' => 1,
                                                      'start' => 5263
                                                    },
                             'parenthesized rhs primary list@4385+67' => {
                                                                           'length' => 67,
                                                                           'lhs' => 'parenthesized rhs primary list',
                                                                           'precedence_count' => 1,
                                                                           'start' => 4385
                                                                         },
                             'pause specification@3565+58' => {
                                                                'length' => 58,
                                                                'lhs' => 'pause specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3565
                                                              },
                             'posix char class name@7978+38' => {
                                                                  'length' => 38,
                                                                  'lhs' => 'posix char class name',
                                                                  'precedence_count' => 1,
                                                                  'start' => 7978
                                                                },
                             'posix char class@7859+54' => {
                                                             'length' => 54,
                                                             'lhs' => 'posix char class',
                                                             'precedence_count' => 1,
                                                             'start' => 7859
                                                           },
                             'prediction event declaration@1943+99' => {
                                                                         'length' => 99,
                                                                         'lhs' => 'prediction event declaration',
                                                                         'precedence_count' => 1,
                                                                         'start' => 1943
                                                                       },
                             'priorities@2246+69' => {
                                                       'length' => 69,
                                                       'lhs' => 'priorities',
                                                       'precedence_count' => 1,
                                                       'start' => 2246
                                                     },
                             'priority rule@1423+47' => {
                                                          'length' => 47,
                                                          'lhs' => 'priority rule',
                                                          'precedence_count' => 1,
                                                          'start' => 1423
                                                        },
                             'priority specification@3501+63' => {
                                                                   'length' => 63,
                                                                   'lhs' => 'priority specification',
                                                                   'precedence_count' => 1,
                                                                   'start' => 3501
                                                                 },
                             'proper specification@3145+50' => {
                                                                 'length' => 50,
                                                                 'lhs' => 'proper specification',
                                                                 'precedence_count' => 1,
                                                                 'start' => 3145
                                                               },
                             'quantified rule@1519+79' => {
                                                            'length' => 79,
                                                            'lhs' => 'quantified rule',
                                                            'precedence_count' => 1,
                                                            'start' => 1519
                                                          },
                             'quantifier@5308+24' => {
                                                       'length' => 24,
                                                       'lhs' => 'quantifier',
                                                       'precedence_count' => 1,
                                                       'start' => 5308
                                                     },
                             'rank specification@3245+55' => {
                                                               'length' => 55,
                                                               'lhs' => 'rank specification',
                                                               'precedence_count' => 1,
                                                               'start' => 3245
                                                             },
                             'reserved action name@5470+59' => {
                                                                 'length' => 59,
                                                                 'lhs' => 'reserved action name',
                                                                 'precedence_count' => 1,
                                                                 'start' => 5470
                                                               },
                             'reserved blessing name@5530+61' => {
                                                                   'length' => 61,
                                                                   'lhs' => 'reserved blessing name',
                                                                   'precedence_count' => 1,
                                                                   'start' => 5530
                                                                 },
                             'reserved event name@4097+33' => {
                                                                'length' => 33,
                                                                'lhs' => 'reserved event name',
                                                                'precedence_count' => 1,
                                                                'start' => 4097
                                                              },
                             'result item descriptor list@6398+105' => {
                                                                         'length' => 105,
                                                                         'lhs' => 'result item descriptor list',
                                                                         'precedence_count' => 1,
                                                                         'start' => 6398
                                                                       },
                             'result item descriptor separator@6504+40' => {
                                                                             'length' => 40,
                                                                             'lhs' => 'result item descriptor separator',
                                                                             'precedence_count' => 1,
                                                                             'start' => 6504
                                                                           },
                             'result item descriptor separator@6545+51' => {
                                                                             'length' => 51,
                                                                             'lhs' => 'result item descriptor separator',
                                                                             'precedence_count' => 1,
                                                                             'start' => 6545
                                                                           },
                             'result item descriptor@6597+135' => {
                                                                    'length' => 135,
                                                                    'lhs' => 'result item descriptor',
                                                                    'precedence_count' => 1,
                                                                    'start' => 6597
                                                                  },
                             'rhs primary list@4453+37' => {
                                                             'length' => 37,
                                                             'lhs' => 'rhs primary list',
                                                             'precedence_count' => 1,
                                                             'start' => 4453
                                                           },
                             'rhs primary@4259+33' => {
                                                        'length' => 33,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4259
                                                      },
                             'rhs primary@4293+40' => {
                                                        'length' => 40,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4293
                                                      },
                             'rhs primary@4334+50' => {
                                                        'length' => 50,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4334
                                                      },
                             'rhs@4236+22' => {
                                                'length' => 22,
                                                'lhs' => 'rhs',
                                                'precedence_count' => 1,
                                                'start' => 4236
                                              },
                             'right association@2986+46' => {
                                                              'length' => 46,
                                                              'lhs' => 'right association',
                                                              'precedence_count' => 1,
                                                              'start' => 2986
                                                            },
                             'safe cc character@7307+79' => {
                                                              'length' => 79,
                                                              'lhs' => 'safe cc character',
                                                              'precedence_count' => 1,
                                                              'start' => 7307
                                                            },
                             'separator specification@3080+64' => {
                                                                    'length' => 64,
                                                                    'lhs' => 'separator specification',
                                                                    'precedence_count' => 1,
                                                                    'start' => 3080
                                                                  },
                             'sign@5421+13' => {
                                                 'length' => 13,
                                                 'lhs' => 'sign',
                                                 'precedence_count' => 1,
                                                 'start' => 5421
                                               },
                             'signed integer@5373+47' => {
                                                           'length' => 47,
                                                           'lhs' => 'signed integer',
                                                           'precedence_count' => 1,
                                                           'start' => 5373
                                                         },
                             'single quoted name@6955+78' => {
                                                               'length' => 78,
                                                               'lhs' => 'single quoted name',
                                                               'precedence_count' => 1,
                                                               'start' => 6955
                                                             },
                             'single quoted string@6846+108' => {
                                                                  'length' => 108,
                                                                  'lhs' => 'single quoted string',
                                                                  'precedence_count' => 1,
                                                                  'start' => 6846
                                                                },
                             'single symbol@4491+52' => {
                                                          'length' => 52,
                                                          'lhs' => 'single symbol',
                                                          'precedence_count' => 1,
                                                          'start' => 4491
                                                        },
                             'standard name@5959+57' => {
                                                          'length' => 57,
                                                          'lhs' => 'standard name',
                                                          'precedence_count' => 1,
                                                          'start' => 5959
                                                        },
                             'start rule@1120+51' => {
                                                       'length' => 51,
                                                       'lhs' => 'start rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1120
                                                     },
                             'start rule@1172+47' => {
                                                       'length' => 47,
                                                       'lhs' => 'start rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1172
                                                     },
                             'statement group@1077+42' => {
                                                            'length' => 42,
                                                            'lhs' => 'statement group',
                                                            'precedence_count' => 1,
                                                            'start' => 1077
                                                          },
                             'statement@681+369' => {
                                                      'length' => 369,
                                                      'lhs' => 'statement',
                                                      'precedence_count' => 1,
                                                      'start' => 681
                                                    },
                             'statements@655+25' => {
                                                      'length' => 25,
                                                      'lhs' => 'statements',
                                                      'precedence_count' => 1,
                                                      'start' => 655
                                                    },
                             'string without single quote or vertical space@7034+103' => {
                                                                                           'length' => 103,
                                                                                           'lhs' => 'string without single quote or vertical space',
                                                                                           'precedence_count' => 1,
                                                                                           'start' => 7034
                                                                                         },
                             'symbol name@4569+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'symbol name',
                                                        'precedence_count' => 1,
                                                        'start' => 4569
                                                      },
                             'symbol name@4599+34' => {
                                                        'length' => 34,
                                                        'lhs' => 'symbol name',
                                                        'precedence_count' => 1,
                                                        'start' => 4599
                                                      },
                             'symbol@4544+24' => {
                                                   'length' => 24,
                                                   'lhs' => 'symbol',
                                                   'precedence_count' => 1,
                                                   'start' => 4544
                                                 },
                             'terminated hash comment@4910+73' => {
                                                                    'length' => 73,
                                                                    'lhs' => 'terminated hash comment',
                                                                    'precedence_count' => 1,
                                                                    'start' => 4910
                                                                  },
                             'unterminated final hash comment@4984+59' => {
                                                                            'length' => 59,
                                                                            'lhs' => 'unterminated final hash comment',
                                                                            'precedence_count' => 1,
                                                                            'start' => 4984
                                                                          },
                             'vertical space char@5087+62' => {
                                                                'length' => 62,
                                                                'lhs' => 'vertical space char',
                                                                'precedence_count' => 1,
                                                                'start' => 5087
                                                              },
                             'whitespace@4765+18' => {
                                                       'length' => 18,
                                                       'lhs' => 'whitespace',
                                                       'precedence_count' => 1,
                                                       'start' => 4765
                                                     },
                             'zero or more word characters@5630+38' => {
                                                                         'length' => 38,
                                                                         'lhs' => 'zero or more word characters',
                                                                         'precedence_count' => 1,
                                                                         'start' => 5630
                                                                       }
                           },
                  'xsy' => {
                             'Perl identifier' => {
                                                    'dsl_form' => 'Perl identifier',
                                                    'name_source' => 'lexical'
                                                  },
                             'Perl name' => {
                                              'dsl_form' => 'Perl name',
                                              'name_source' => 'lexical'
                                            },
                             '[:discard:]' => {
                                                'dsl_form' => '[:discard:]',
                                                'name_source' => 'internal'
                                              },
                             '[:lex_start:]' => {
                                                  'dsl_form' => '[:lex_start:]',
                                                  'name_source' => 'internal'
                                                },
                             '[:start:]' => {
                                              'dsl_form' => '[:start:]',
                                              'name_source' => 'internal'
                                            },
                             '[Lex-0]' => {
                                            'dsl_form' => '\';\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-10]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-11]' => {
                                             'dsl_form' => '\'discard\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-12]' => {
                                             'dsl_form' => '\':discard\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-13]' => {
                                             'dsl_form' => '\':lexeme\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-14]' => {
                                             'dsl_form' => '\'event\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-15]' => {
                                             'dsl_form' => '\'completed\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-16]' => {
                                             'dsl_form' => '\'nulled\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-17]' => {
                                             'dsl_form' => '\'predicted\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-18]' => {
                                             'dsl_form' => '\'inaccessible\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-19]' => {
                                             'dsl_form' => '\'by\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-1]' => {
                                            'dsl_form' => '\'{\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-20]' => {
                                             'dsl_form' => '\'warn\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-21]' => {
                                             'dsl_form' => '\'ok\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-22]' => {
                                             'dsl_form' => '\'fatal\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-23]' => {
                                             'dsl_form' => '\',\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-24]' => {
                                             'dsl_form' => '\'action\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-25]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-26]' => {
                                             'dsl_form' => '\'assoc\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-27]' => {
                                             'dsl_form' => '\'left\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-28]' => {
                                             'dsl_form' => '\'right\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-29]' => {
                                             'dsl_form' => '\'group\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-2]' => {
                                            'dsl_form' => '\'}\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-30]' => {
                                             'dsl_form' => '\'separator\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-31]' => {
                                             'dsl_form' => '\'proper\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-32]' => {
                                             'dsl_form' => '\'eager\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-33]' => {
                                             'dsl_form' => '\'rank\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-34]' => {
                                             'dsl_form' => '\'null-ranking\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-35]' => {
                                             'dsl_form' => '\'null\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-36]' => {
                                             'dsl_form' => '\'low\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-37]' => {
                                             'dsl_form' => '\'high\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-38]' => {
                                             'dsl_form' => '\'priority\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-39]' => {
                                             'dsl_form' => '\'pause\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-3]' => {
                                            'dsl_form' => '\':start\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-40]' => {
                                             'dsl_form' => '\'on\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-41]' => {
                                             'dsl_form' => '\'off\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-42]' => {
                                             'dsl_form' => '\'bless\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-43]' => {
                                             'dsl_form' => '\'name\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-44]' => {
                                             'dsl_form' => '\'(\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-45]' => {
                                             'dsl_form' => '\')\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-46]' => {
                                             'dsl_form' => '\'*\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-47]' => {
                                             'dsl_form' => '\'+\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-4]' => {
                                            'dsl_form' => '\'start\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-5]' => {
                                            'dsl_form' => '\'symbol\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-6]' => {
                                            'dsl_form' => '\'is\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-7]' => {
                                            'dsl_form' => '\':default\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-8]' => {
                                            'dsl_form' => '\'lexeme\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-9]' => {
                                            'dsl_form' => '\'default\'',
                                            'name_source' => 'internal'
                                          },
                             '[[\']]' => {
                                           'dsl_form' => '[\']',
                                           'name_source' => 'internal'
                                         },
                             '[[+-]]' => {
                                           'dsl_form' => '[+-]',
                                           'name_source' => 'internal'
                                         },
                             '[[,]]' => {
                                          'dsl_form' => '[,]',
                                          'name_source' => 'internal'
                                        },
                             '[[01]]' => {
                                           'dsl_form' => '[01]',
                                           'name_source' => 'internal'
                                         },
                             '[[1]]' => {
                                          'dsl_form' => '[1]',
                                          'name_source' => 'internal'
                                        },
                             '[[[:alnum:]]]' => {
                                                  'dsl_form' => '[[:alnum:]]',
                                                  'name_source' => 'internal'
                                                },
                             '[[\\#]]' => {
                                            'dsl_form' => '[\\#]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\(]]' => {
                                            'dsl_form' => '[\\(]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\)]]' => {
                                            'dsl_form' => '[\\)]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\*]]' => {
                                            'dsl_form' => '[\\*]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\+]]' => {
                                            'dsl_form' => '[\\+]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\,]]' => {
                                            'dsl_form' => '[\\,]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\-]]' => {
                                            'dsl_form' => '[\\-]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\:]]' => {
                                            'dsl_form' => '[\\:]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\;]]' => {
                                            'dsl_form' => '[\\;]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\<]]' => {
                                            'dsl_form' => '[\\<]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\=]]' => {
                                            'dsl_form' => '[\\=]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\>]]' => {
                                            'dsl_form' => '[\\>]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\[]]' => {
                                            'dsl_form' => '[\\[]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\\\]]' => {
                                             'dsl_form' => '[\\\\]',
                                             'name_source' => 'internal'
                                           },
                             '[[\\]]]' => {
                                            'dsl_form' => '[\\]]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\^]]' => {
                                            'dsl_form' => '[\\^]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\d]]' => {
                                            'dsl_form' => '[\\d]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\s\\w]]' => {
                                               'dsl_form' => '[\\s\\w]',
                                               'name_source' => 'internal'
                                             },
                             '[[\\s]]' => {
                                            'dsl_form' => '[\\s]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\w]]' => {
                                            'dsl_form' => '[\\w]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                   'dsl_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                   'name_source' => 'internal'
                                                                                 },
                             '[[\\{]]' => {
                                            'dsl_form' => '[\\{]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\|]]' => {
                                            'dsl_form' => '[\\|]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\}]]' => {
                                            'dsl_form' => '[\\}]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\~]]' => {
                                            'dsl_form' => '[\\~]',
                                            'name_source' => 'internal'
                                          },
                             '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                   'dsl_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                   'name_source' => 'internal'
                                                                                                 },
                             '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                        'dsl_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                        'name_source' => 'internal'
                                                                                                      },
                             '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                    'dsl_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                    'name_source' => 'internal'
                                                                                  },
                             '[[a-zA-Z]]' => {
                                               'dsl_form' => '[a-zA-Z]',
                                               'name_source' => 'internal'
                                             },
                             '[[a]]' => {
                                          'dsl_form' => '[a]',
                                          'name_source' => 'internal'
                                        },
                             '[[b]]' => {
                                          'dsl_form' => '[b]',
                                          'name_source' => 'internal'
                                        },
                             '[[c]]' => {
                                          'dsl_form' => '[c]',
                                          'name_source' => 'internal'
                                        },
                             '[[d]]' => {
                                          'dsl_form' => '[d]',
                                          'name_source' => 'internal'
                                        },
                             '[[e]]' => {
                                          'dsl_form' => '[e]',
                                          'name_source' => 'internal'
                                        },
                             '[[f]]' => {
                                          'dsl_form' => '[f]',
                                          'name_source' => 'internal'
                                        },
                             '[[g]]' => {
                                          'dsl_form' => '[g]',
                                          'name_source' => 'internal'
                                        },
                             '[[h]]' => {
                                          'dsl_form' => '[h]',
                                          'name_source' => 'internal'
                                        },
                             '[[i]]' => {
                                          'dsl_form' => '[i]',
                                          'name_source' => 'internal'
                                        },
                             '[[k]]' => {
                                          'dsl_form' => '[k]',
                                          'name_source' => 'internal'
                                        },
                             '[[l]]' => {
                                          'dsl_form' => '[l]',
                                          'name_source' => 'internal'
                                        },
                             '[[m]]' => {
                                          'dsl_form' => '[m]',
                                          'name_source' => 'internal'
                                        },
                             '[[n]]' => {
                                          'dsl_form' => '[n]',
                                          'name_source' => 'internal'
                                        },
                             '[[o]]' => {
                                          'dsl_form' => '[o]',
                                          'name_source' => 'internal'
                                        },
                             '[[p]]' => {
                                          'dsl_form' => '[p]',
                                          'name_source' => 'internal'
                                        },
                             '[[r]]' => {
                                          'dsl_form' => '[r]',
                                          'name_source' => 'internal'
                                        },
                             '[[s]]' => {
                                          'dsl_form' => '[s]',
                                          'name_source' => 'internal'
                                        },
                             '[[t]]' => {
                                          'dsl_form' => '[t]',
                                          'name_source' => 'internal'
                                        },
                             '[[u]]' => {
                                          'dsl_form' => '[u]',
                                          'name_source' => 'internal'
                                        },
                             '[[v]]' => {
                                          'dsl_form' => '[v]',
                                          'name_source' => 'internal'
                                        },
                             '[[w]]' => {
                                          'dsl_form' => '[w]',
                                          'name_source' => 'internal'
                                        },
                             '[[x]]' => {
                                          'dsl_form' => '[x]',
                                          'name_source' => 'internal'
                                        },
                             '[[y]]' => {
                                          'dsl_form' => '[y]',
                                          'name_source' => 'internal'
                                        },
                             'action' => {
                                           'dsl_form' => 'action',
                                           'name_source' => 'lexical'
                                         },
                             'action name' => {
                                                'dsl_form' => 'action name',
                                                'name_source' => 'lexical'
                                              },
                             'adverb item' => {
                                                'dsl_form' => 'adverb item',
                                                'name_source' => 'lexical'
                                              },
                             'adverb list' => {
                                                'dsl_form' => 'adverb list',
                                                'name_source' => 'lexical'
                                              },
                             'adverb list items' => {
                                                      'dsl_form' => 'adverb list items',
                                                      'name_source' => 'lexical'
                                                    },
                             'alternative' => {
                                                'dsl_form' => 'alternative',
                                                'name_source' => 'lexical'
                                              },
                             'alternative name' => {
                                                     'dsl_form' => 'alternative name',
                                                     'name_source' => 'lexical'
                                                   },
                             'alternatives' => {
                                                 'dsl_form' => 'alternatives',
                                                 'name_source' => 'lexical'
                                               },
                             'array descriptor' => {
                                                     'dsl_form' => 'array descriptor',
                                                     'name_source' => 'lexical'
                                                   },
                             'array descriptor left bracket' => {
                                                                  'dsl_form' => 'array descriptor left bracket',
                                                                  'name_source' => 'lexical'
                                                                },
                             'array descriptor right bracket' => {
                                                                   'dsl_form' => 'array descriptor right bracket',
                                                                   'name_source' => 'lexical'
                                                                 },
                             'bare name' => {
                                              'dsl_form' => 'bare name',
                                              'name_source' => 'lexical'
                                            },
                             'before or after' => {
                                                    'dsl_form' => 'before or after',
                                                    'name_source' => 'lexical'
                                                  },
                             'blessing' => {
                                             'dsl_form' => 'blessing',
                                             'name_source' => 'lexical'
                                           },
                             'blessing name' => {
                                                  'dsl_form' => 'blessing name',
                                                  'name_source' => 'lexical'
                                                },
                             'boolean' => {
                                            'dsl_form' => 'boolean',
                                            'name_source' => 'lexical'
                                          },
                             'bracketed name' => {
                                                   'dsl_form' => 'bracketed name',
                                                   'name_source' => 'lexical'
                                                 },
                             'bracketed name string' => {
                                                          'dsl_form' => 'bracketed name string',
                                                          'name_source' => 'lexical'
                                                        },
                             'cc element' => {
                                               'dsl_form' => 'cc element',
                                               'name_source' => 'lexical'
                                             },
                             'cc elements' => {
                                                'dsl_form' => 'cc elements',
                                                'name_source' => 'lexical'
                                              },
                             'character class' => {
                                                    'dsl_form' => 'character class',
                                                    'name_source' => 'lexical'
                                                  },
                             'character class modifier' => {
                                                             'dsl_form' => 'character class modifier',
                                                             'name_source' => 'lexical'
                                                           },
                             'character class modifiers' => {
                                                              'dsl_form' => 'character class modifiers',
                                                              'name_source' => 'lexical'
                                                            },
                             'completion event declaration' => {
                                                                 'dsl_form' => 'completion event declaration',
                                                                 'name_source' => 'lexical'
                                                               },
                             'default rule' => {
                                                 'dsl_form' => 'default rule',
                                                 'name_source' => 'lexical'
                                               },
                             'discard default statement' => {
                                                              'dsl_form' => 'discard default statement',
                                                              'name_source' => 'lexical'
                                                            },
                             'discard rule' => {
                                                 'dsl_form' => 'discard rule',
                                                 'name_source' => 'lexical'
                                               },
                             'double colon' => {
                                                 'dsl_form' => 'double colon',
                                                 'name_source' => 'lexical'
                                               },
                             'eager specification' => {
                                                        'dsl_form' => 'eager specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'empty rule' => {
                                               'dsl_form' => 'empty rule',
                                               'name_source' => 'lexical'
                                             },
                             'escaped cc character' => {
                                                         'dsl_form' => 'escaped cc character',
                                                         'name_source' => 'lexical'
                                                       },
                             'event initialization' => {
                                                         'dsl_form' => 'event initialization',
                                                         'name_source' => 'lexical'
                                                       },
                             'event initializer' => {
                                                      'dsl_form' => 'event initializer',
                                                      'name_source' => 'lexical'
                                                    },
                             'event name' => {
                                               'dsl_form' => 'event name',
                                               'name_source' => 'lexical'
                                             },
                             'event specification' => {
                                                        'dsl_form' => 'event specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'group association' => {
                                                      'dsl_form' => 'group association',
                                                      'name_source' => 'lexical'
                                                    },
                             'hash comment' => {
                                                 'dsl_form' => 'hash comment',
                                                 'name_source' => 'lexical'
                                               },
                             'hash comment body' => {
                                                      'dsl_form' => 'hash comment body',
                                                      'name_source' => 'lexical'
                                                    },
                             'hash comment char' => {
                                                      'dsl_form' => 'hash comment char',
                                                      'name_source' => 'lexical'
                                                    },
                             'horizontal character' => {
                                                         'dsl_form' => 'horizontal character',
                                                         'name_source' => 'lexical'
                                                       },
                             'inaccessible statement' => {
                                                           'dsl_form' => 'inaccessible statement',
                                                           'name_source' => 'lexical'
                                                         },
                             'inaccessible treatment' => {
                                                           'dsl_form' => 'inaccessible treatment',
                                                           'name_source' => 'lexical'
                                                         },
                             'integer' => {
                                            'dsl_form' => 'integer',
                                            'name_source' => 'lexical'
                                          },
                             'left association' => {
                                                     'dsl_form' => 'left association',
                                                     'name_source' => 'lexical'
                                                   },
                             'lexeme default statement' => {
                                                             'dsl_form' => 'lexeme default statement',
                                                             'name_source' => 'lexical'
                                                           },
                             'lexeme rule' => {
                                                'dsl_form' => 'lexeme rule',
                                                'name_source' => 'lexical'
                                              },
                             'lhs' => {
                                        'dsl_form' => 'lhs',
                                        'name_source' => 'lexical'
                                      },
                             'naming' => {
                                           'dsl_form' => 'naming',
                                           'name_source' => 'lexical'
                                         },
                             'negated posix char class' => {
                                                             'dsl_form' => 'negated posix char class',
                                                             'name_source' => 'lexical'
                                                           },
                             'null adverb' => {
                                                'dsl_form' => 'null adverb',
                                                'name_source' => 'lexical'
                                              },
                             'null ranking constant' => {
                                                          'dsl_form' => 'null ranking constant',
                                                          'name_source' => 'lexical'
                                                        },
                             'null ranking specification' => {
                                                               'dsl_form' => 'null ranking specification',
                                                               'name_source' => 'lexical'
                                                             },
                             'null statement' => {
                                                   'dsl_form' => 'null statement',
                                                   'name_source' => 'lexical'
                                                 },
                             'nulled event declaration' => {
                                                             'dsl_form' => 'nulled event declaration',
                                                             'name_source' => 'lexical'
                                                           },
                             'on or off' => {
                                              'dsl_form' => 'on or off',
                                              'name_source' => 'lexical'
                                            },
                             'one or more word characters' => {
                                                                'dsl_form' => 'one or more word characters',
                                                                'name_source' => 'lexical'
                                                              },
                             'op declare' => {
                                               'dsl_form' => 'op declare',
                                               'name_source' => 'lexical'
                                             },
                             'op declare bnf' => {
                                                   'dsl_form' => 'op declare bnf',
                                                   'name_source' => 'lexical'
                                                 },
                             'op declare match' => {
                                                     'dsl_form' => 'op declare match',
                                                     'name_source' => 'lexical'
                                                   },
                             'op equal priority' => {
                                                      'dsl_form' => 'op equal priority',
                                                      'name_source' => 'lexical'
                                                    },
                             'op loosen' => {
                                              'dsl_form' => 'op loosen',
                                              'name_source' => 'lexical'
                                            },
                             'parenthesized rhs primary list' => {
                                                                   'dsl_form' => 'parenthesized rhs primary list',
                                                                   'name_source' => 'lexical'
                                                                 },
                             'pause specification' => {
                                                        'dsl_form' => 'pause specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'posix char class' => {
                                                     'dsl_form' => 'posix char class',
                                                     'name_source' => 'lexical'
                                                   },
                             'posix char class name' => {
                                                          'dsl_form' => 'posix char class name',
                                                          'name_source' => 'lexical'
                                                        },
                             'prediction event declaration' => {
                                                                 'dsl_form' => 'prediction event declaration',
                                                                 'name_source' => 'lexical'
                                                               },
                             'priorities' => {
                                               'dsl_form' => 'priorities',
                                               'name_source' => 'lexical'
                                             },
                             'priority rule' => {
                                                  'dsl_form' => 'priority rule',
                                                  'name_source' => 'lexical'
                                                },
                             'priority specification' => {
                                                           'dsl_form' => 'priority specification',
                                                           'name_source' => 'lexical'
                                                         },
                             'proper specification' => {
                                                         'dsl_form' => 'proper specification',
                                                         'name_source' => 'lexical'
                                                       },
                             'quantified rule' => {
                                                    'dsl_form' => 'quantified rule',
                                                    'name_source' => 'lexical'
                                                  },
                             'quantifier' => {
                                               'dsl_form' => 'quantifier',
                                               'name_source' => 'lexical'
                                             },
                             'rank specification' => {
                                                       'dsl_form' => 'rank specification',
                                                       'name_source' => 'lexical'
                                                     },
                             'reserved action name' => {
                                                         'dsl_form' => 'reserved action name',
                                                         'name_source' => 'lexical'
                                                       },
                             'reserved blessing name' => {
                                                           'dsl_form' => 'reserved blessing name',
                                                           'name_source' => 'lexical'
                                                         },
                             'reserved event name' => {
                                                        'dsl_form' => 'reserved event name',
                                                        'name_source' => 'lexical'
                                                      },
                             'result item descriptor' => {
                                                           'dsl_form' => 'result item descriptor',
                                                           'name_source' => 'lexical'
                                                         },
                             'result item descriptor list' => {
                                                                'dsl_form' => 'result item descriptor list',
                                                                'name_source' => 'lexical'
                                                              },
                             'result item descriptor separator' => {
                                                                     'dsl_form' => 'result item descriptor separator',
                                                                     'name_source' => 'lexical'
                                                                   },
                             'rhs' => {
                                        'dsl_form' => 'rhs',
                                        'name_source' => 'lexical'
                                      },
                             'rhs primary' => {
                                                'dsl_form' => 'rhs pr