# Marpa::R3 is Copyright (C) 2017, Jeffrey Kegler.
#
# This module is free software; you can redistribute it and/or modify it
# under the same terms as Perl 5.10.1. For more details, see the full text
# of the licenses in the directory LICENSES.
#
# This program is distributed in the hope that it will be
# useful, but it is provided "as is" and without any express
# or implied warranties. For details, see the full text of
# of the licenses in the directory LICENSES.

use 5.010001;
use warnings;
use strict;
use English qw( -no_match_vars );
use File::Spec;

my $outfile_name = shift;
open my $out_fh, '>', $outfile_name;

print {$out_fh}  <<END_OF_CHUNK;

# This file was autogenerated by $PROGRAM_NAME
# IF YOU EDIT THIS FILE, YOUR CHANGES WILL BE LOST
# This is not a source file.  For license information,
# consult the source files.

END_OF_CHUNK

print {$out_fh} <<'END_OF_CHUNK';

package Marpa::R3::Lua::Test::Builder;

use 5.010001;
use warnings;
use strict;

use vars qw($VERSION $STRING_VERSION);
$VERSION        = '4.001_024';
$STRING_VERSION = $VERSION;
$VERSION        = eval $VERSION;

$Marpa::R3::Lua::Test::Builder::loader = <<'END_OF_LUA';
END_OF_CHUNK

my $lua_file_name  = File::Spec->catfile(qw(inc Marpa R3 Lua Test Builder.lua));
open my $in_fh, '<', $lua_file_name;
my $lua_file = do { local $RS = undef; <$in_fh>; };
print {$out_fh} $lua_file;
close $in_fh;

print {$out_fh} <<'END_OF_CHUNK';
END_OF_LUA

1;
END_OF_CHUNK

close $out_fh;

# vim: set expandtab shiftwidth=4:
