# Marpa::R3 is Copyright (C) 2017, Jeffrey Kegler.
#
# This module is free software; you can redistribute it and/or modify it
# under the same terms as Perl 5.10.1. For more details, see the full text
# of the licenses in the directory LICENSES.
#
# This program is distributed in the hope that it will be
# useful, but it is provided "as is" and without any express
# or implied warranties. For details, see the full text of
# of the licenses in the directory LICENSES.

package Marpa::R3::MetaG;

use 5.010001;
use strict;
use warnings;

use vars qw($VERSION $STRING_VERSION);
$VERSION        = '4.001_047';
$STRING_VERSION = $VERSION;
## no critic(BuiltinFunctions::ProhibitStringyEval)
$VERSION = eval $VERSION;
## use critic

package Marpa::R3::Internal::MetaG;

use English qw( -no_match_vars );

sub hashed_grammar {
    my $hashed_metag;

## no critic(RegularExpressions::RequireDotMatchAnything)
## no critic(RegularExpressions::RequireExtendedFormatting)
## no critic(RegularExpressions::RequireLineBoundaryMatching)
## no critic(RegularExpressions::ProhibitEscapedMetacharacters)
## no critic(RegularExpressions::ProhibitComplexRegexes)

## The code after this line was automatically generated by sl_to_hash.pl
$hashed_metag = {
                  'character_classes' => {
                                           '[[\']]' => [
                                                         '[\']',
                                                         ''
                                                       ],
                                           '[[+-]]' => [
                                                         '[+-]',
                                                         ''
                                                       ],
                                           '[[,]]' => [
                                                        '[,]',
                                                        ''
                                                      ],
                                           '[[01]]' => [
                                                         '[01]',
                                                         ''
                                                       ],
                                           '[[1]]' => [
                                                        '[1]',
                                                        ''
                                                      ],
                                           '[[[:alnum:]]]' => [
                                                                '[[:alnum:]]',
                                                                ''
                                                              ],
                                           '[[\\#]]' => [
                                                          '[\\#]',
                                                          ''
                                                        ],
                                           '[[\\(]]' => [
                                                          '[\\(]',
                                                          ''
                                                        ],
                                           '[[\\)]]' => [
                                                          '[\\)]',
                                                          ''
                                                        ],
                                           '[[\\*]]' => [
                                                          '[\\*]',
                                                          ''
                                                        ],
                                           '[[\\+]]' => [
                                                          '[\\+]',
                                                          ''
                                                        ],
                                           '[[\\,]]' => [
                                                          '[\\,]',
                                                          ''
                                                        ],
                                           '[[\\-]]' => [
                                                          '[\\-]',
                                                          ''
                                                        ],
                                           '[[\\:]]' => [
                                                          '[\\:]',
                                                          ''
                                                        ],
                                           '[[\\;]]' => [
                                                          '[\\;]',
                                                          ''
                                                        ],
                                           '[[\\<]]' => [
                                                          '[\\<]',
                                                          ''
                                                        ],
                                           '[[\\=]]' => [
                                                          '[\\=]',
                                                          ''
                                                        ],
                                           '[[\\>]]' => [
                                                          '[\\>]',
                                                          ''
                                                        ],
                                           '[[\\[]]' => [
                                                          '[\\[]',
                                                          ''
                                                        ],
                                           '[[\\\\]]' => [
                                                           '[\\\\]',
                                                           ''
                                                         ],
                                           '[[\\]]]' => [
                                                          '[\\]]',
                                                          ''
                                                        ],
                                           '[[\\^]]' => [
                                                          '[\\^]',
                                                          ''
                                                        ],
                                           '[[\\d]]' => [
                                                          '[\\d]',
                                                          ''
                                                        ],
                                           '[[\\s\\w]]' => [
                                                             '[\\s\\w]',
                                                             ''
                                                           ],
                                           '[[\\s]]' => [
                                                          '[\\s]',
                                                          ''
                                                        ],
                                           '[[\\w]]' => [
                                                          '[\\w]',
                                                          ''
                                                        ],
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                 '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                 ''
                                                                                               ],
                                           '[[\\{]]' => [
                                                          '[\\{]',
                                                          ''
                                                        ],
                                           '[[\\|]]' => [
                                                          '[\\|]',
                                                          ''
                                                        ],
                                           '[[\\}]]' => [
                                                          '[\\}]',
                                                          ''
                                                        ],
                                           '[[\\~]]' => [
                                                          '[\\~]',
                                                          ''
                                                        ],
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                 '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                 ''
                                                                                                               ],
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => [
                                                                                                                      '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                                      ''
                                                                                                                    ],
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => [
                                                                                                  '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                                  ''
                                                                                                ],
                                           '[[a-zA-Z]]' => [
                                                             '[a-zA-Z]',
                                                             ''
                                                           ],
                                           '[[a]]' => [
                                                        '[a]',
                                                        ''
                                                      ],
                                           '[[b]]' => [
                                                        '[b]',
                                                        ''
                                                      ],
                                           '[[c]]' => [
                                                        '[c]',
                                                        ''
                                                      ],
                                           '[[d]]' => [
                                                        '[d]',
                                                        ''
                                                      ],
                                           '[[e]]' => [
                                                        '[e]',
                                                        ''
                                                      ],
                                           '[[f]]' => [
                                                        '[f]',
                                                        ''
                                                      ],
                                           '[[g]]' => [
                                                        '[g]',
                                                        ''
                                                      ],
                                           '[[h]]' => [
                                                        '[h]',
                                                        ''
                                                      ],
                                           '[[i]]' => [
                                                        '[i]',
                                                        ''
                                                      ],
                                           '[[k]]' => [
                                                        '[k]',
                                                        ''
                                                      ],
                                           '[[l]]' => [
                                                        '[l]',
                                                        ''
                                                      ],
                                           '[[m]]' => [
                                                        '[m]',
                                                        ''
                                                      ],
                                           '[[n]]' => [
                                                        '[n]',
                                                        ''
                                                      ],
                                           '[[o]]' => [
                                                        '[o]',
                                                        ''
                                                      ],
                                           '[[p]]' => [
                                                        '[p]',
                                                        ''
                                                      ],
                                           '[[r]]' => [
                                                        '[r]',
                                                        ''
                                                      ],
                                           '[[s]]' => [
                                                        '[s]',
                                                        ''
                                                      ],
                                           '[[t]]' => [
                                                        '[t]',
                                                        ''
                                                      ],
                                           '[[u]]' => [
                                                        '[u]',
                                                        ''
                                                      ],
                                           '[[v]]' => [
                                                        '[v]',
                                                        ''
                                                      ],
                                           '[[w]]' => [
                                                        '[w]',
                                                        ''
                                                      ],
                                           '[[x]]' => [
                                                        '[x]',
                                                        ''
                                                      ],
                                           '[[y]]' => [
                                                        '[y]',
                                                        ''
                                                      ]
                                         },
                  'discard_default_adverbs' => undef,
                  'first_lhs' => 'statements',
                  'lexeme_default_adverbs' => {
                                                'action' => '[start,length,value]',
                                                'bless' => '::name'
                                              },
                  'rules' => {
                               'G1' => [
                                         {
                                           'action' => '::first',
                                           'lhs' => '[:start]',
                                           'rhs' => [
                                                      'statements'
                                                    ],
                                           'xbnfid' => '[:start],statements'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action',
                                           'rhs' => [
                                                      '[Lex-33]',
                                                      '[Lex-34]',
                                                      'action name'
                                                    ],
                                           'xbnfid' => 'action,[Lex-33],[Lex-34],action name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'Perl name'
                                                    ],
                                           'xbnfid' => 'action name,Perl name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'array descriptor'
                                                    ],
                                           'xbnfid' => 'action name,array descriptor'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'action name',
                                           'rhs' => [
                                                      'reserved action name'
                                                    ],
                                           'xbnfid' => 'action name,reserved action name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'action'
                                                    ],
                                           'xbnfid' => 'adverb item,action'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'blessing'
                                                    ],
                                           'xbnfid' => 'adverb item,blessing'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'eager specification'
                                                    ],
                                           'xbnfid' => 'adverb item,eager specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'event specification'
                                                    ],
                                           'xbnfid' => 'adverb item,event specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'group association'
                                                    ],
                                           'xbnfid' => 'adverb item,group association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'left association'
                                                    ],
                                           'xbnfid' => 'adverb item,left association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'naming'
                                                    ],
                                           'xbnfid' => 'adverb item,naming'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'null adverb'
                                                    ],
                                           'xbnfid' => 'adverb item,null adverb'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'null ranking specification'
                                                    ],
                                           'xbnfid' => 'adverb item,null ranking specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'pause specification'
                                                    ],
                                           'xbnfid' => 'adverb item,pause specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'priority specification'
                                                    ],
                                           'xbnfid' => 'adverb item,priority specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'proper specification'
                                                    ],
                                           'xbnfid' => 'adverb item,proper specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'rank specification'
                                                    ],
                                           'xbnfid' => 'adverb item,rank specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'right association'
                                                    ],
                                           'xbnfid' => 'adverb item,right association'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb item',
                                           'rhs' => [
                                                      'separator specification'
                                                    ],
                                           'xbnfid' => 'adverb item,separator specification'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb list',
                                           'rhs' => [
                                                      'adverb list items'
                                                    ],
                                           'xbnfid' => 'adverb list,adverb list items'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'adverb list items',
                                           'min' => 0,
                                           'rhs' => [
                                                      'adverb item'
                                                    ],
                                           'xbnfid' => 'adverb list items,adverb item'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative',
                                           'rhs' => [
                                                      'rhs',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'alternative,rhs,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ],
                                           'xbnfid' => 'alternative name,single quoted name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternative name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'xbnfid' => 'alternative name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'alternatives',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternative'
                                                    ],
                                           'separator' => 'op equal priority',
                                           'xbnfid' => 'alternatives,alternative'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing',
                                           'rhs' => [
                                                      '[Lex-68]',
                                                      '[Lex-69]',
                                                      'blessing name'
                                                    ],
                                           'xbnfid' => 'blessing,[Lex-68],[Lex-69],blessing name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing name',
                                           'rhs' => [
                                                      'reserved blessing name'
                                                    ],
                                           'xbnfid' => 'blessing name,reserved blessing name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'blessing name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'xbnfid' => 'blessing name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'completion event declaration',
                                           'rhs' => [
                                                      '[Lex-16]',
                                                      'event initialization',
                                                      '[Lex-17]',
                                                      '[Lex-18]',
                                                      'symbol name'
                                                    ],
                                           'xbnfid' => 'completion event declaration,[Lex-16],event initialization,[Lex-17],[Lex-18],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'default rule',
                                           'rhs' => [
                                                      '[Lex-7]',
                                                      'op declare bnf',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'default rule,[Lex-7],op declare bnf,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'discard default statement',
                                           'rhs' => [
                                                      '[Lex-11]',
                                                      '[Lex-12]',
                                                      '[Lex-13]',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'discard default statement,[Lex-11],[Lex-12],[Lex-13],adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'discard rule',
                                           'rhs' => [
                                                      '[Lex-14]',
                                                      'op declare match',
                                                      'single symbol',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'discard rule,[Lex-14],op declare match,single symbol,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'eager specification',
                                           'rhs' => [
                                                      '[Lex-48]',
                                                      '[Lex-49]',
                                                      'boolean'
                                                    ],
                                           'xbnfid' => 'eager specification,[Lex-48],[Lex-49],boolean'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'empty rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'empty rule,lhs,op declare,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initialization',
                                           'rhs' => [
                                                      'event name',
                                                      'event initializer'
                                                    ],
                                           'xbnfid' => 'event initialization,event name,event initializer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initializer',
                                           'rhs' => [],
                                           'xbnfid' => 'event initializer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event initializer',
                                           'rhs' => [
                                                      '[Lex-65]',
                                                      'on or off'
                                                    ],
                                           'xbnfid' => 'event initializer,[Lex-65],on or off'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'reserved event name'
                                                    ],
                                           'xbnfid' => 'event name,reserved event name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'single quoted name'
                                                    ],
                                           'xbnfid' => 'event name,single quoted name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event name',
                                           'rhs' => [
                                                      'standard name'
                                                    ],
                                           'xbnfid' => 'event name,standard name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'event specification',
                                           'rhs' => [
                                                      '[Lex-63]',
                                                      '[Lex-64]',
                                                      'event initialization'
                                                    ],
                                           'xbnfid' => 'event specification,[Lex-63],[Lex-64],event initialization'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'group association',
                                           'rhs' => [
                                                      '[Lex-41]',
                                                      '[Lex-42]',
                                                      '[Lex-43]'
                                                    ],
                                           'xbnfid' => 'group association,[Lex-41],[Lex-42],[Lex-43]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible statement',
                                           'rhs' => [
                                                      '[Lex-25]',
                                                      '[Lex-26]',
                                                      'inaccessible treatment',
                                                      '[Lex-27]',
                                                      '[Lex-28]'
                                                    ],
                                           'xbnfid' => 'inaccessible statement,[Lex-25],[Lex-26],inaccessible treatment,[Lex-27],[Lex-28]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-29]'
                                                    ],
                                           'xbnfid' => 'inaccessible treatment,[Lex-29]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-30]'
                                                    ],
                                           'xbnfid' => 'inaccessible treatment,[Lex-30]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'inaccessible treatment',
                                           'rhs' => [
                                                      '[Lex-31]'
                                                    ],
                                           'xbnfid' => 'inaccessible treatment,[Lex-31]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'left association',
                                           'rhs' => [
                                                      '[Lex-35]',
                                                      '[Lex-36]',
                                                      '[Lex-37]'
                                                    ],
                                           'xbnfid' => 'left association,[Lex-35],[Lex-36],[Lex-37]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lexeme default statement',
                                           'rhs' => [
                                                      '[Lex-8]',
                                                      '[Lex-9]',
                                                      '[Lex-10]',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'lexeme default statement,[Lex-8],[Lex-9],[Lex-10],adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lexeme rule',
                                           'rhs' => [
                                                      '[Lex-15]',
                                                      'op declare match',
                                                      'symbol',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'lexeme rule,[Lex-15],op declare match,symbol,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'lhs',
                                           'rhs' => [
                                                      'symbol name'
                                                    ],
                                           'xbnfid' => 'lhs,symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'naming',
                                           'rhs' => [
                                                      '[Lex-70]',
                                                      '[Lex-71]',
                                                      'alternative name'
                                                    ],
                                           'xbnfid' => 'naming,[Lex-70],[Lex-71],alternative name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null adverb',
                                           'rhs' => [
                                                      '[Lex-32]'
                                                    ],
                                           'xbnfid' => 'null adverb,[Lex-32]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-57]'
                                                    ],
                                           'xbnfid' => 'null ranking constant,[Lex-57]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking constant',
                                           'rhs' => [
                                                      '[Lex-58]'
                                                    ],
                                           'xbnfid' => 'null ranking constant,[Lex-58]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-52]',
                                                      '[Lex-53]',
                                                      'null ranking constant'
                                                    ],
                                           'xbnfid' => 'null ranking specification,[Lex-52],[Lex-53],null ranking constant'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null ranking specification',
                                           'rhs' => [
                                                      '[Lex-54]',
                                                      '[Lex-55]',
                                                      '[Lex-56]',
                                                      'null ranking constant'
                                                    ],
                                           'xbnfid' => 'null ranking specification,[Lex-54],[Lex-55],[Lex-56],null ranking constant'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'null statement',
                                           'rhs' => [
                                                      '[Lex-0]'
                                                    ],
                                           'xbnfid' => 'null statement,[Lex-0]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'nulled event declaration',
                                           'rhs' => [
                                                      '[Lex-19]',
                                                      'event initialization',
                                                      '[Lex-20]',
                                                      '[Lex-21]',
                                                      'symbol name'
                                                    ],
                                           'xbnfid' => 'nulled event declaration,[Lex-19],event initialization,[Lex-20],[Lex-21],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-66]'
                                                    ],
                                           'xbnfid' => 'on or off,[Lex-66]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'on or off',
                                           'rhs' => [
                                                      '[Lex-67]'
                                                    ],
                                           'xbnfid' => 'on or off,[Lex-67]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'op declare',
                                           'rhs' => [
                                                      'op declare bnf'
                                                    ],
                                           'xbnfid' => 'op declare,op declare bnf'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'op declare',
                                           'rhs' => [
                                                      'op declare match'
                                                    ],
                                           'xbnfid' => 'op declare,op declare match'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'parenthesized rhs primary list',
                                           'rhs' => [
                                                      '[Lex-72]',
                                                      'rhs primary list',
                                                      '[Lex-73]'
                                                    ],
                                           'xbnfid' => 'parenthesized rhs primary list,[Lex-72],rhs primary list,[Lex-73]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'pause specification',
                                           'rhs' => [
                                                      '[Lex-61]',
                                                      '[Lex-62]',
                                                      'before or after'
                                                    ],
                                           'xbnfid' => 'pause specification,[Lex-61],[Lex-62],before or after'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'prediction event declaration',
                                           'rhs' => [
                                                      '[Lex-22]',
                                                      'event initialization',
                                                      '[Lex-23]',
                                                      '[Lex-24]',
                                                      'symbol name'
                                                    ],
                                           'xbnfid' => 'prediction event declaration,[Lex-22],event initialization,[Lex-23],[Lex-24],symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priorities',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'alternatives'
                                                    ],
                                           'separator' => 'op loosen',
                                           'xbnfid' => 'priorities,alternatives'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priority rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'priorities'
                                                    ],
                                           'xbnfid' => 'priority rule,lhs,op declare,priorities'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'priority specification',
                                           'rhs' => [
                                                      '[Lex-59]',
                                                      '[Lex-60]',
                                                      'signed integer'
                                                    ],
                                           'xbnfid' => 'priority specification,[Lex-59],[Lex-60],signed integer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'proper specification',
                                           'rhs' => [
                                                      '[Lex-46]',
                                                      '[Lex-47]',
                                                      'boolean'
                                                    ],
                                           'xbnfid' => 'proper specification,[Lex-46],[Lex-47],boolean'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantified rule',
                                           'rhs' => [
                                                      'lhs',
                                                      'op declare',
                                                      'single symbol',
                                                      'quantifier',
                                                      'adverb list'
                                                    ],
                                           'xbnfid' => 'quantified rule,lhs,op declare,single symbol,quantifier,adverb list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-74]'
                                                    ],
                                           'xbnfid' => 'quantifier,[Lex-74]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'quantifier',
                                           'rhs' => [
                                                      '[Lex-75]'
                                                    ],
                                           'xbnfid' => 'quantifier,[Lex-75]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rank specification',
                                           'rhs' => [
                                                      '[Lex-50]',
                                                      '[Lex-51]',
                                                      'signed integer'
                                                    ],
                                           'xbnfid' => 'rank specification,[Lex-50],[Lex-51],signed integer'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ],
                                           'xbnfid' => 'rhs,rhs primary'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'parenthesized rhs primary list'
                                                    ],
                                           'xbnfid' => 'rhs primary,parenthesized rhs primary list'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'single quoted string'
                                                    ],
                                           'xbnfid' => 'rhs primary,single quoted string'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary',
                                           'rhs' => [
                                                      'single symbol'
                                                    ],
                                           'xbnfid' => 'rhs primary,single symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'rhs primary list',
                                           'min' => 1,
                                           'rhs' => [
                                                      'rhs primary'
                                                    ],
                                           'xbnfid' => 'rhs primary list,rhs primary'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'right association',
                                           'rhs' => [
                                                      '[Lex-38]',
                                                      '[Lex-39]',
                                                      '[Lex-40]'
                                                    ],
                                           'xbnfid' => 'right association,[Lex-38],[Lex-39],[Lex-40]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'separator specification',
                                           'rhs' => [
                                                      '[Lex-44]',
                                                      '[Lex-45]',
                                                      'single symbol'
                                                    ],
                                           'xbnfid' => 'separator specification,[Lex-44],[Lex-45],single symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'single symbol',
                                           'rhs' => [
                                                      'character class'
                                                    ],
                                           'xbnfid' => 'single symbol,character class'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'single symbol',
                                           'rhs' => [
                                                      'symbol'
                                                    ],
                                           'xbnfid' => 'single symbol,symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-3]',
                                                      'op declare bnf',
                                                      'symbol'
                                                    ],
                                           'xbnfid' => 'start rule,[Lex-3],op declare bnf,symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'start rule',
                                           'rhs' => [
                                                      '[Lex-4]',
                                                      '[Lex-5]',
                                                      '[Lex-6]',
                                                      'symbol'
                                                    ],
                                           'xbnfid' => 'start rule,[Lex-4],[Lex-5],[Lex-6],symbol'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'completion event declaration'
                                                    ],
                                           'xbnfid' => 'statement,completion event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'default rule'
                                                    ],
                                           'xbnfid' => 'statement,default rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'discard default statement'
                                                    ],
                                           'xbnfid' => 'statement,discard default statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'discard rule'
                                                    ],
                                           'xbnfid' => 'statement,discard rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'empty rule'
                                                    ],
                                           'xbnfid' => 'statement,empty rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'inaccessible statement'
                                                    ],
                                           'xbnfid' => 'statement,inaccessible statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'lexeme default statement'
                                                    ],
                                           'xbnfid' => 'statement,lexeme default statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'lexeme rule'
                                                    ],
                                           'xbnfid' => 'statement,lexeme rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'null statement'
                                                    ],
                                           'xbnfid' => 'statement,null statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'nulled event declaration'
                                                    ],
                                           'xbnfid' => 'statement,nulled event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'prediction event declaration'
                                                    ],
                                           'xbnfid' => 'statement,prediction event declaration'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'priority rule'
                                                    ],
                                           'xbnfid' => 'statement,priority rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'quantified rule'
                                                    ],
                                           'xbnfid' => 'statement,quantified rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'start rule'
                                                    ],
                                           'xbnfid' => 'statement,start rule'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement',
                                           'rhs' => [
                                                      'statement group'
                                                    ],
                                           'xbnfid' => 'statement,statement group'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statement group',
                                           'rhs' => [
                                                      '[Lex-1]',
                                                      'statements',
                                                      '[Lex-2]'
                                                    ],
                                           'xbnfid' => 'statement group,[Lex-1],statements,[Lex-2]'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'statements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'statement'
                                                    ],
                                           'xbnfid' => 'statements,statement'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol',
                                           'rhs' => [
                                                      'symbol name'
                                                    ],
                                           'xbnfid' => 'symbol,symbol name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol name',
                                           'rhs' => [
                                                      'bare name'
                                                    ],
                                           'xbnfid' => 'symbol name,bare name'
                                         },
                                         {
                                           'action' => '[start,length,values]',
                                           'lhs' => 'symbol name',
                                           'rhs' => [
                                                      'bracketed name'
                                                    ],
                                           'xbnfid' => 'symbol name,bracketed name'
                                         }
                                       ],
                               'L0' => [
                                         {
                                           'lhs' => 'Perl identifier',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'xbnfid' => 'Perl identifier,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'Perl name',
                                           'min' => 1,
                                           'proper' => '1',
                                           'rhs' => [
                                                      'Perl identifier'
                                                    ],
                                           'separator' => 'double colon',
                                           'xbnfid' => 'Perl name,Perl identifier'
                                         },
                                         {
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'hash comment'
                                                    ],
                                           'xbnfid' => '[:discard],hash comment'
                                         },
                                         {
                                           'lhs' => '[:discard]',
                                           'rhs' => [
                                                      'whitespace'
                                                    ],
                                           'xbnfid' => '[:discard],whitespace'
                                         },
                                         {
                                           'lhs' => '[Lex-0]',
                                           'rhs' => [
                                                      '[[\\;]]'
                                                    ],
                                           'xbnfid' => '[Lex-0],[[\\;]]'
                                         },
                                         {
                                           'lhs' => '[Lex-10]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-10],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-11]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ],
                                           'xbnfid' => '[Lex-11],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-12]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-12],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-13]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-13],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-14]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[s]]',
                                                      '[[c]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[d]]'
                                                    ],
                                           'xbnfid' => '[Lex-14],[[\\:]],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-15]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => '[Lex-15],[[\\:]],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-16]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-16],[[e]],[[v]],[[e]],[[n]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-17]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-17],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-18]',
                                           'rhs' => [
                                                      '[[c]]',
                                                      '[[o]]',
                                                      '[[m]]',
                                                      '[[p]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'xbnfid' => '[Lex-18],[[c]],[[o]],[[m]],[[p]],[[l]],[[e]],[[t]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-19]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-19],[[e]],[[v]],[[e]],[[n]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-1]',
                                           'rhs' => [
                                                      '[[\\{]]'
                                                    ],
                                           'xbnfid' => '[Lex-1],[[\\{]]'
                                         },
                                         {
                                           'lhs' => '[Lex-20]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-20],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-21]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'xbnfid' => '[Lex-21],[[n]],[[u]],[[l]],[[l]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-22]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-22],[[e]],[[v]],[[e]],[[n]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-23]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-23],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-24]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[e]]',
                                                      '[[d]]',
                                                      '[[i]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[d]]'
                                                    ],
                                           'xbnfid' => '[Lex-24],[[p]],[[r]],[[e]],[[d]],[[i]],[[c]],[[t]],[[e]],[[d]]'
                                         },
                                         {
                                           'lhs' => '[Lex-25]',
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[c]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[i]]',
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => '[Lex-25],[[i]],[[n]],[[a]],[[c]],[[c]],[[e]],[[s]],[[s]],[[i]],[[b]],[[l]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-26]',
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ],
                                           'xbnfid' => '[Lex-26],[[i]],[[s]]'
                                         },
                                         {
                                           'lhs' => '[Lex-27]',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[y]]'
                                                    ],
                                           'xbnfid' => '[Lex-27],[[b]],[[y]]'
                                         },
                                         {
                                           'lhs' => '[Lex-28]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-28],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-29]',
                                           'rhs' => [
                                                      '[[w]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[n]]'
                                                    ],
                                           'xbnfid' => '[Lex-29],[[w]],[[a]],[[r]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-2]',
                                           'rhs' => [
                                                      '[[\\}]]'
                                                    ],
                                           'xbnfid' => '[Lex-2],[[\\}]]'
                                         },
                                         {
                                           'lhs' => '[Lex-30]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[k]]'
                                                    ],
                                           'xbnfid' => '[Lex-30],[[o]],[[k]]'
                                         },
                                         {
                                           'lhs' => '[Lex-31]',
                                           'rhs' => [
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[l]]'
                                                    ],
                                           'xbnfid' => '[Lex-31],[[f]],[[a]],[[t]],[[a]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-32]',
                                           'rhs' => [
                                                      '[[\\,]]'
                                                    ],
                                           'xbnfid' => '[Lex-32],[[\\,]]'
                                         },
                                         {
                                           'lhs' => '[Lex-33]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[c]]',
                                                      '[[t]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ],
                                           'xbnfid' => '[Lex-33],[[a]],[[c]],[[t]],[[i]],[[o]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-34]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-34],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-35]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ],
                                           'xbnfid' => '[Lex-35],[[a]],[[s]],[[s]],[[o]],[[c]]'
                                         },
                                         {
                                           'lhs' => '[Lex-36]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-36],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-37]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-37],[[l]],[[e]],[[f]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-38]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ],
                                           'xbnfid' => '[Lex-38],[[a]],[[s]],[[s]],[[o]],[[c]]'
                                         },
                                         {
                                           'lhs' => '[Lex-39]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-39],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-3]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-3],[[\\:]],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-40]',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-40],[[r]],[[i]],[[g]],[[h]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-41]',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[s]]',
                                                      '[[s]]',
                                                      '[[o]]',
                                                      '[[c]]'
                                                    ],
                                           'xbnfid' => '[Lex-41],[[a]],[[s]],[[s]],[[o]],[[c]]'
                                         },
                                         {
                                           'lhs' => '[Lex-42]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-42],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-43]',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[u]]',
                                                      '[[p]]'
                                                    ],
                                           'xbnfid' => '[Lex-43],[[g]],[[r]],[[o]],[[u]],[[p]]'
                                         },
                                         {
                                           'lhs' => '[Lex-44]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[e]]',
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[t]]',
                                                      '[[o]]',
                                                      '[[r]]'
                                                    ],
                                           'xbnfid' => '[Lex-44],[[s]],[[e]],[[p]],[[a]],[[r]],[[a]],[[t]],[[o]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-45]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-45],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-46]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[o]]',
                                                      '[[p]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'xbnfid' => '[Lex-46],[[p]],[[r]],[[o]],[[p]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-47]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-47],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-48]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[a]]',
                                                      '[[g]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'xbnfid' => '[Lex-48],[[e]],[[a]],[[g]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => '[Lex-49]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-49],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-4]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-4],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-50]',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ],
                                           'xbnfid' => '[Lex-50],[[r]],[[a]],[[n]],[[k]]'
                                         },
                                         {
                                           'lhs' => '[Lex-51]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-51],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-52]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]',
                                                      '[[\\-]]',
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]',
                                                      '[[i]]',
                                                      '[[n]]',
                                                      '[[g]]'
                                                    ],
                                           'xbnfid' => '[Lex-52],[[n]],[[u]],[[l]],[[l]],[[\\-]],[[r]],[[a]],[[n]],[[k]],[[i]],[[n]],[[g]]'
                                         },
                                         {
                                           'lhs' => '[Lex-53]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-53],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-54]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[l]]'
                                                    ],
                                           'xbnfid' => '[Lex-54],[[n]],[[u]],[[l]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-55]',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[a]]',
                                                      '[[n]]',
                                                      '[[k]]'
                                                    ],
                                           'xbnfid' => '[Lex-55],[[r]],[[a]],[[n]],[[k]]'
                                         },
                                         {
                                           'lhs' => '[Lex-56]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-56],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-57]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[o]]',
                                                      '[[w]]'
                                                    ],
                                           'xbnfid' => '[Lex-57],[[l]],[[o]],[[w]]'
                                         },
                                         {
                                           'lhs' => '[Lex-58]',
                                           'rhs' => [
                                                      '[[h]]',
                                                      '[[i]]',
                                                      '[[g]]',
                                                      '[[h]]'
                                                    ],
                                           'xbnfid' => '[Lex-58],[[h]],[[i]],[[g]],[[h]]'
                                         },
                                         {
                                           'lhs' => '[Lex-59]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[i]]',
                                                      '[[t]]',
                                                      '[[y]]'
                                                    ],
                                           'xbnfid' => '[Lex-59],[[p]],[[r]],[[i]],[[o]],[[r]],[[i]],[[t]],[[y]]'
                                         },
                                         {
                                           'lhs' => '[Lex-5]',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'xbnfid' => '[Lex-5],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => '[Lex-60]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-60],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-61]',
                                           'rhs' => [
                                                      '[[p]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[s]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => '[Lex-61],[[p]],[[a]],[[u]],[[s]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-62]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-62],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-63]',
                                           'rhs' => [
                                                      '[[e]]',
                                                      '[[v]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-63],[[e]],[[v]],[[e]],[[n]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-64]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-64],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-65]',
                                           'rhs' => [
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => '[Lex-65],[[\\=]]'
                                         },
                                         {
                                           'lhs' => '[Lex-66]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[n]]'
                                                    ],
                                           'xbnfid' => '[Lex-66],[[o]],[[n]]'
                                         },
                                         {
                                           'lhs' => '[Lex-67]',
                                           'rhs' => [
                                                      '[[o]]',
                                                      '[[f]]',
                                                      '[[f]]'
                                                    ],
                                           'xbnfid' => '[Lex-67],[[o]],[[f]],[[f]]'
                                         },
                                         {
                                           'lhs' => '[Lex-68]',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[s]]',
                                                      '[[s]]'
                                                    ],
                                           'xbnfid' => '[Lex-68],[[b]],[[l]],[[e]],[[s]],[[s]]'
                                         },
                                         {
                                           'lhs' => '[Lex-69]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-69],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-6]',
                                           'rhs' => [
                                                      '[[i]]',
                                                      '[[s]]'
                                                    ],
                                           'xbnfid' => '[Lex-6],[[i]],[[s]]'
                                         },
                                         {
                                           'lhs' => '[Lex-70]',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => '[Lex-70],[[n]],[[a]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-71]',
                                           'rhs' => [
                                                      '[[\\=]]',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => '[Lex-71],[[\\=]],[[\\>]]'
                                         },
                                         {
                                           'lhs' => '[Lex-72]',
                                           'rhs' => [
                                                      '[[\\(]]'
                                                    ],
                                           'xbnfid' => '[Lex-72],[[\\(]]'
                                         },
                                         {
                                           'lhs' => '[Lex-73]',
                                           'rhs' => [
                                                      '[[\\)]]'
                                                    ],
                                           'xbnfid' => '[Lex-73],[[\\)]]'
                                         },
                                         {
                                           'lhs' => '[Lex-74]',
                                           'rhs' => [
                                                      '[[\\*]]'
                                                    ],
                                           'xbnfid' => '[Lex-74],[[\\*]]'
                                         },
                                         {
                                           'lhs' => '[Lex-75]',
                                           'rhs' => [
                                                      '[[\\+]]'
                                                    ],
                                           'xbnfid' => '[Lex-75],[[\\+]]'
                                         },
                                         {
                                           'lhs' => '[Lex-7]',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-7],[[\\:]],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => '[Lex-8]',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[x]]',
                                                      '[[e]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => '[Lex-8],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => '[Lex-9]',
                                           'rhs' => [
                                                      '[[d]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[a]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => '[Lex-9],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor',
                                           'rhs' => [
                                                      'array descriptor left bracket',
                                                      'result item descriptor list',
                                                      'array descriptor right bracket'
                                                    ],
                                           'xbnfid' => 'array descriptor,array descriptor left bracket,result item descriptor list,array descriptor right bracket'
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'rhs' => [
                                                      '[[\\[]]'
                                                    ],
                                           'xbnfid' => 'array descriptor left bracket,[[\\[]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor left bracket',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'whitespace'
                                                    ],
                                           'xbnfid' => 'array descriptor left bracket,[[\\[]],whitespace'
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'rhs' => [
                                                      '[[\\]]]'
                                                    ],
                                           'xbnfid' => 'array descriptor right bracket,[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'array descriptor right bracket',
                                           'rhs' => [
                                                      'whitespace',
                                                      '[[\\]]]'
                                                    ],
                                           'xbnfid' => 'array descriptor right bracket,whitespace,[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'bare name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'xbnfid' => 'bare name,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'rhs' => [
                                                      '[[a]]',
                                                      '[[f]]',
                                                      '[[t]]',
                                                      '[[e]]',
                                                      '[[r]]'
                                                    ],
                                           'xbnfid' => 'before or after,[[a]],[[f]],[[t]],[[e]],[[r]]'
                                         },
                                         {
                                           'lhs' => 'before or after',
                                           'rhs' => [
                                                      '[[b]]',
                                                      '[[e]]',
                                                      '[[f]]',
                                                      '[[o]]',
                                                      '[[r]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => 'before or after,[[b]],[[e]],[[f]],[[o]],[[r]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'boolean',
                                           'rhs' => [
                                                      '[[01]]'
                                                    ],
                                           'xbnfid' => 'boolean,[[01]]'
                                         },
                                         {
                                           'lhs' => 'bracketed name',
                                           'rhs' => [
                                                      '[[\\<]]',
                                                      'bracketed name string',
                                                      '[[\\>]]'
                                                    ],
                                           'xbnfid' => 'bracketed name,[[\\<]],bracketed name string,[[\\>]]'
                                         },
                                         {
                                           'lhs' => 'bracketed name string',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s\\w]]'
                                                    ],
                                           'xbnfid' => 'bracketed name string,[[\\s\\w]]'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'escaped cc character'
                                                    ],
                                           'xbnfid' => 'cc element,escaped cc character'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'negated posix char class'
                                                    ],
                                           'xbnfid' => 'cc element,negated posix char class'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'posix char class'
                                                    ],
                                           'xbnfid' => 'cc element,posix char class'
                                         },
                                         {
                                           'lhs' => 'cc element',
                                           'rhs' => [
                                                      'safe cc character'
                                                    ],
                                           'xbnfid' => 'cc element,safe cc character'
                                         },
                                         {
                                           'lhs' => 'cc elements',
                                           'min' => 1,
                                           'rhs' => [
                                                      'cc element'
                                                    ],
                                           'xbnfid' => 'cc elements,cc element'
                                         },
                                         {
                                           'lhs' => 'character class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      'cc elements',
                                                      '[[\\]]]',
                                                      'character class modifiers'
                                                    ],
                                           'xbnfid' => 'character class,[[\\[]],cc elements,[[\\]]],character class modifiers'
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]'
                                                    ],
                                           'xbnfid' => 'character class modifier,[[\\:]],[[i]]'
                                         },
                                         {
                                           'lhs' => 'character class modifier',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[i]]',
                                                      '[[c]]'
                                                    ],
                                           'xbnfid' => 'character class modifier,[[\\:]],[[i]],[[c]]'
                                         },
                                         {
                                           'lhs' => 'character class modifiers',
                                           'min' => 0,
                                           'rhs' => [
                                                      'character class modifier'
                                                    ],
                                           'xbnfid' => 'character class modifiers,character class modifier'
                                         },
                                         {
                                           'lhs' => 'double colon',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]'
                                                    ],
                                           'xbnfid' => 'double colon,[[\\:]],[[\\:]]'
                                         },
                                         {
                                           'lhs' => 'escaped cc character',
                                           'rhs' => [
                                                      '[[\\\\]]',
                                                      'horizontal character'
                                                    ],
                                           'xbnfid' => 'escaped cc character,[[\\\\]],horizontal character'
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'rhs' => [
                                                      'terminated hash comment'
                                                    ],
                                           'xbnfid' => 'hash comment,terminated hash comment'
                                         },
                                         {
                                           'lhs' => 'hash comment',
                                           'rhs' => [
                                                      'unterminated final hash comment'
                                                    ],
                                           'xbnfid' => 'hash comment,unterminated final hash comment'
                                         },
                                         {
                                           'lhs' => 'hash comment body',
                                           'min' => 0,
                                           'rhs' => [
                                                      'hash comment char'
                                                    ],
                                           'xbnfid' => 'hash comment body,hash comment char'
                                         },
                                         {
                                           'lhs' => 'hash comment char',
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'xbnfid' => 'hash comment char,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'horizontal character',
                                           'rhs' => [
                                                      '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'xbnfid' => 'horizontal character,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'integer',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\d]]'
                                                    ],
                                           'xbnfid' => 'integer,[[\\d]]'
                                         },
                                         {
                                           'lhs' => 'negated posix char class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      '[[\\^]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ],
                                           'xbnfid' => 'negated posix char class,[[\\[]],[[\\:]],[[\\^]],posix char class name,[[\\:]],[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'one or more word characters',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'xbnfid' => 'one or more word characters,[[\\w]]'
                                         },
                                         {
                                           'lhs' => 'op declare bnf',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      '[[\\=]]'
                                                    ],
                                           'xbnfid' => 'op declare bnf,[[\\:]],[[\\:]],[[\\=]]'
                                         },
                                         {
                                           'lhs' => 'op declare match',
                                           'rhs' => [
                                                      '[[\\~]]'
                                                    ],
                                           'xbnfid' => 'op declare match,[[\\~]]'
                                         },
                                         {
                                           'lhs' => 'op equal priority',
                                           'rhs' => [
                                                      '[[\\|]]'
                                                    ],
                                           'xbnfid' => 'op equal priority,[[\\|]]'
                                         },
                                         {
                                           'lhs' => 'op loosen',
                                           'rhs' => [
                                                      '[[\\|]]',
                                                      '[[\\|]]'
                                                    ],
                                           'xbnfid' => 'op loosen,[[\\|]],[[\\|]]'
                                         },
                                         {
                                           'lhs' => 'posix char class',
                                           'rhs' => [
                                                      '[[\\[]]',
                                                      '[[\\:]]',
                                                      'posix char class name',
                                                      '[[\\:]]',
                                                      '[[\\]]]'
                                                    ],
                                           'xbnfid' => 'posix char class,[[\\[]],[[\\:]],posix char class name,[[\\:]],[[\\]]]'
                                         },
                                         {
                                           'lhs' => 'posix char class name',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[[:alnum:]]]'
                                                    ],
                                           'xbnfid' => 'posix char class name,[[[:alnum:]]]'
                                         },
                                         {
                                           'lhs' => 'reserved action name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ],
                                           'xbnfid' => 'reserved action name,[[\\:]],[[\\:]],one or more word characters'
                                         },
                                         {
                                           'lhs' => 'reserved blessing name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[\\:]]',
                                                      'one or more word characters'
                                                    ],
                                           'xbnfid' => 'reserved blessing name,[[\\:]],[[\\:]],one or more word characters'
                                         },
                                         {
                                           'lhs' => 'reserved event name',
                                           'rhs' => [
                                                      '[[\\:]]',
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'xbnfid' => 'reserved event name,[[\\:]],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[h]]',
                                                      '[[s]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[l]],[[h]],[[s]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[n]]',
                                                      '[[a]]',
                                                      '[[m]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[n]],[[a]],[[m]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[r]]',
                                                      '[[u]]',
                                                      '[[l]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[r]],[[u]],[[l]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[s]]',
                                                      '[[y]]',
                                                      '[[m]]',
                                                      '[[b]]',
                                                      '[[o]]',
                                                      '[[l]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[v]]',
                                                      '[[a]]',
                                                      '[[l]]',
                                                      '[[u]]',
                                                      '[[e]]',
                                                      '[[s]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]],[[s]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[s]]',
                                                      '[[t]]',
                                                      '[[a]]',
                                                      '[[r]]',
                                                      '[[t]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[g]],[[1]],[[s]],[[t]],[[a]],[[r]],[[t]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor',
                                           'rhs' => [
                                                      '[[g]]',
                                                      '[[1]]',
                                                      '[[l]]',
                                                      '[[e]]',
                                                      '[[n]]',
                                                      '[[g]]',
                                                      '[[t]]',
                                                      '[[h]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor,[[g]],[[1]],[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor list',
                                           'min' => 0,
                                           'rhs' => [
                                                      'result item descriptor'
                                                    ],
                                           'separator' => 'result item descriptor separator',
                                           'xbnfid' => 'result item descriptor list,result item descriptor'
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'rhs' => [
                                                      '[[,]]'
                                                    ],
                                           'xbnfid' => 'result item descriptor separator,[[,]]'
                                         },
                                         {
                                           'lhs' => 'result item descriptor separator',
                                           'rhs' => [
                                                      '[[,]]',
                                                      'whitespace'
                                                    ],
                                           'xbnfid' => 'result item descriptor separator,[[,]],whitespace'
                                         },
                                         {
                                           'lhs' => 'safe cc character',
                                           'rhs' => [
                                                      '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'xbnfid' => 'safe cc character,[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'sign',
                                           'rhs' => [
                                                      '[[+-]]'
                                                    ],
                                           'xbnfid' => 'sign,[[+-]]'
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'rhs' => [
                                                      'integer'
                                                    ],
                                           'xbnfid' => 'signed integer,integer'
                                         },
                                         {
                                           'lhs' => 'signed integer',
                                           'rhs' => [
                                                      'sign',
                                                      'integer'
                                                    ],
                                           'xbnfid' => 'signed integer,sign,integer'
                                         },
                                         {
                                           'lhs' => 'single quoted name',
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]'
                                                    ],
                                           'xbnfid' => 'single quoted name,[[\']],string without single quote or vertical space,[[\']]'
                                         },
                                         {
                                           'lhs' => 'single quoted string',
                                           'rhs' => [
                                                      '[[\']]',
                                                      'string without single quote or vertical space',
                                                      '[[\']]',
                                                      'character class modifiers'
                                                    ],
                                           'xbnfid' => 'single quoted string,[[\']],string without single quote or vertical space,[[\']],character class modifiers'
                                         },
                                         {
                                           'lhs' => 'standard name',
                                           'rhs' => [
                                                      '[[a-zA-Z]]',
                                                      'zero or more word characters'
                                                    ],
                                           'xbnfid' => 'standard name,[[a-zA-Z]],zero or more word characters'
                                         },
                                         {
                                           'lhs' => 'string without single quote or vertical space',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'xbnfid' => 'string without single quote or vertical space,[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'terminated hash comment',
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body',
                                                      'vertical space char'
                                                    ],
                                           'xbnfid' => 'terminated hash comment,[[\\#]],hash comment body,vertical space char'
                                         },
                                         {
                                           'lhs' => 'unterminated final hash comment',
                                           'rhs' => [
                                                      '[[\\#]]',
                                                      'hash comment body'
                                                    ],
                                           'xbnfid' => 'unterminated final hash comment,[[\\#]],hash comment body'
                                         },
                                         {
                                           'lhs' => 'vertical space char',
                                           'rhs' => [
                                                      '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                    ],
                                           'xbnfid' => 'vertical space char,[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                         },
                                         {
                                           'lhs' => 'whitespace',
                                           'min' => 1,
                                           'rhs' => [
                                                      '[[\\s]]'
                                                    ],
                                           'xbnfid' => 'whitespace,[[\\s]]'
                                         },
                                         {
                                           'lhs' => 'zero or more word characters',
                                           'min' => 0,
                                           'rhs' => [
                                                      '[[\\w]]'
                                                    ],
                                           'xbnfid' => 'zero or more word characters,[[\\w]]'
                                         }
                                       ]
                             },
                  'start_lhs' => 'statements',
                  'symbols' => {
                                 'G1' => {
                                           'Perl name' => {
                                                            'wsyid' => 662,
                                                            'xsy' => 'Perl name'
                                                          },
                                           '[:start]' => {},
                                           '[Lex-0]' => {
                                                          'wsyid' => 1,
                                                          'xsy' => '[Lex-0]'
                                                        },
                                           '[Lex-10]' => {
                                                           'wsyid' => 64,
                                                           'xsy' => '[Lex-10]'
                                                         },
                                           '[Lex-11]' => {
                                                           'wsyid' => 73,
                                                           'xsy' => '[Lex-11]'
                                                         },
                                           '[Lex-12]' => {
                                                           'wsyid' => 82,
                                                           'xsy' => '[Lex-12]'
                                                         },
                                           '[Lex-13]' => {
                                                           'wsyid' => 85,
                                                           'xsy' => '[Lex-13]'
                                                         },
                                           '[Lex-14]' => {
                                                           'wsyid' => 95,
                                                           'xsy' => '[Lex-14]'
                                                         },
                                           '[Lex-15]' => {
                                                           'wsyid' => 104,
                                                           'xsy' => '[Lex-15]'
                                                         },
                                           '[Lex-16]' => {
                                                           'wsyid' => 111,
                                                           'xsy' => '[Lex-16]'
                                                         },
                                           '[Lex-17]' => {
                                                           'wsyid' => 114,
                                                           'xsy' => '[Lex-17]'
                                                         },
                                           '[Lex-18]' => {
                                                           'wsyid' => 125,
                                                           'xsy' => '[Lex-18]'
                                                         },
                                           '[Lex-19]' => {
                                                           'wsyid' => 132,
                                                           'xsy' => '[Lex-19]'
                                                         },
                                           '[Lex-1]' => {
                                                          'wsyid' => 4,
                                                          'xsy' => '[Lex-1]'
                                                        },
                                           '[Lex-20]' => {
                                                           'wsyid' => 135,
                                                           'xsy' => '[Lex-20]'
                                                         },
                                           '[Lex-21]' => {
                                                           'wsyid' => 143,
                                                           'xsy' => '[Lex-21]'
                                                         },
                                           '[Lex-22]' => {
                                                           'wsyid' => 150,
                                                           'xsy' => '[Lex-22]'
                                                         },
                                           '[Lex-23]' => {
                                                           'wsyid' => 153,
                                                           'xsy' => '[Lex-23]'
                                                         },
                                           '[Lex-24]' => {
                                                           'wsyid' => 164,
                                                           'xsy' => '[Lex-24]'
                                                         },
                                           '[Lex-25]' => {
                                                           'wsyid' => 178,
                                                           'xsy' => '[Lex-25]'
                                                         },
                                           '[Lex-26]' => {
                                                           'wsyid' => 182,
                                                           'xsy' => '[Lex-26]'
                                                         },
                                           '[Lex-27]' => {
                                                           'wsyid' => 186,
                                                           'xsy' => '[Lex-27]'
                                                         },
                                           '[Lex-28]' => {
                                                           'wsyid' => 195,
                                                           'xsy' => '[Lex-28]'
                                                         },
                                           '[Lex-29]' => {
                                                           'wsyid' => 201,
                                                           'xsy' => '[Lex-29]'
                                                         },
                                           '[Lex-2]' => {
                                                          'wsyid' => 7,
                                                          'xsy' => '[Lex-2]'
                                                        },
                                           '[Lex-30]' => {
                                                           'wsyid' => 205,
                                                           'xsy' => '[Lex-30]'
                                                         },
                                           '[Lex-31]' => {
                                                           'wsyid' => 212,
                                                           'xsy' => '[Lex-31]'
                                                         },
                                           '[Lex-32]' => {
                                                           'wsyid' => 215,
                                                           'xsy' => '[Lex-32]'
                                                         },
                                           '[Lex-33]' => {
                                                           'wsyid' => 223,
                                                           'xsy' => '[Lex-33]'
                                                         },
                                           '[Lex-34]' => {
                                                           'wsyid' => 227,
                                                           'xsy' => '[Lex-34]'
                                                         },
                                           '[Lex-35]' => {
                                                           'wsyid' => 234,
                                                           'xsy' => '[Lex-35]'
                                                         },
                                           '[Lex-36]' => {
                                                           'wsyid' => 238,
                                                           'xsy' => '[Lex-36]'
                                                         },
                                           '[Lex-37]' => {
                                                           'wsyid' => 244,
                                                           'xsy' => '[Lex-37]'
                                                         },
                                           '[Lex-38]' => {
                                                           'wsyid' => 251,
                                                           'xsy' => '[Lex-38]'
                                                         },
                                           '[Lex-39]' => {
                                                           'wsyid' => 255,
                                                           'xsy' => '[Lex-39]'
                                                         },
                                           '[Lex-3]' => {
                                                          'wsyid' => 15,
                                                          'xsy' => '[Lex-3]'
                                                        },
                                           '[Lex-40]' => {
                                                           'wsyid' => 262,
                                                           'xsy' => '[Lex-40]'
                                                         },
                                           '[Lex-41]' => {
                                                           'wsyid' => 269,
                                                           'xsy' => '[Lex-41]'
                                                         },
                                           '[Lex-42]' => {
                                                           'wsyid' => 273,
                                                           'xsy' => '[Lex-42]'
                                                         },
                                           '[Lex-43]' => {
                                                           'wsyid' => 280,
                                                           'xsy' => '[Lex-43]'
                                                         },
                                           '[Lex-44]' => {
                                                           'wsyid' => 291,
                                                           'xsy' => '[Lex-44]'
                                                         },
                                           '[Lex-45]' => {
                                                           'wsyid' => 295,
                                                           'xsy' => '[Lex-45]'
                                                         },
                                           '[Lex-46]' => {
                                                           'wsyid' => 303,
                                                           'xsy' => '[Lex-46]'
                                                         },
                                           '[Lex-47]' => {
                                                           'wsyid' => 307,
                                                           'xsy' => '[Lex-47]'
                                                         },
                                           '[Lex-48]' => {
                                                           'wsyid' => 314,
                                                           'xsy' => '[Lex-48]'
                                                         },
                                           '[Lex-49]' => {
                                                           'wsyid' => 318,
                                                           'xsy' => '[Lex-49]'
                                                         },
                                           '[Lex-4]' => {
                                                          'wsyid' => 22,
                                                          'xsy' => '[Lex-4]'
                                                        },
                                           '[Lex-50]' => {
                                                           'wsyid' => 324,
                                                           'xsy' => '[Lex-50]'
                                                         },
                                           '[Lex-51]' => {
                                                           'wsyid' => 328,
                                                           'xsy' => '[Lex-51]'
                                                         },
                                           '[Lex-52]' => {
                                                           'wsyid' => 342,
                                                           'xsy' => '[Lex-52]'
                                                         },
                                           '[Lex-53]' => {
                                                           'wsyid' => 346,
                                                           'xsy' => '[Lex-53]'
                                                         },
                                           '[Lex-54]' => {
                                                           'wsyid' => 352,
                                                           'xsy' => '[Lex-54]'
                                                         },
                                           '[Lex-55]' => {
                                                           'wsyid' => 358,
                                                           'xsy' => '[Lex-55]'
                                                         },
                                           '[Lex-56]' => {
                                                           'wsyid' => 362,
                                                           'xsy' => '[Lex-56]'
                                                         },
                                           '[Lex-57]' => {
                                                           'wsyid' => 367,
                                                           'xsy' => '[Lex-57]'
                                                         },
                                           '[Lex-58]' => {
                                                           'wsyid' => 373,
                                                           'xsy' => '[Lex-58]'
                                                         },
                                           '[Lex-59]' => {
                                                           'wsyid' => 383,
                                                           'xsy' => '[Lex-59]'
                                                         },
                                           '[Lex-5]' => {
                                                          'wsyid' => 30,
                                                          'xsy' => '[Lex-5]'
                                                        },
                                           '[Lex-60]' => {
                                                           'wsyid' => 387,
                                                           'xsy' => '[Lex-60]'
                                                         },
                                           '[Lex-61]' => {
                                                           'wsyid' => 394,
                                                           'xsy' => '[Lex-61]'
                                                         },
                                           '[Lex-62]' => {
                                                           'wsyid' => 398,
                                                           'xsy' => '[Lex-62]'
                                                         },
                                           '[Lex-63]' => {
                                                           'wsyid' => 405,
                                                           'xsy' => '[Lex-63]'
                                                         },
                                           '[Lex-64]' => {
                                                           'wsyid' => 409,
                                                           'xsy' => '[Lex-64]'
                                                         },
                                           '[Lex-65]' => {
                                                           'wsyid' => 412,
                                                           'xsy' => '[Lex-65]'
                                                         },
                                           '[Lex-66]' => {
                                                           'wsyid' => 416,
                                                           'xsy' => '[Lex-66]'
                                                         },
                                           '[Lex-67]' => {
                                                           'wsyid' => 421,
                                                           'xsy' => '[Lex-67]'
                                                         },
                                           '[Lex-68]' => {
                                                           'wsyid' => 428,
                                                           'xsy' => '[Lex-68]'
                                                         },
                                           '[Lex-69]' => {
                                                           'wsyid' => 432,
                                                           'xsy' => '[Lex-69]'
                                                         },
                                           '[Lex-6]' => {
                                                          'wsyid' => 34,
                                                          'xsy' => '[Lex-6]'
                                                        },
                                           '[Lex-70]' => {
                                                           'wsyid' => 438,
                                                           'xsy' => '[Lex-70]'
                                                         },
                                           '[Lex-71]' => {
                                                           'wsyid' => 442,
                                                           'xsy' => '[Lex-71]'
                                                         },
                                           '[Lex-72]' => {
                                                           'wsyid' => 452,
                                                           'xsy' => '[Lex-72]'
                                                         },
                                           '[Lex-73]' => {
                                                           'wsyid' => 455,
                                                           'xsy' => '[Lex-73]'
                                                         },
                                           '[Lex-74]' => {
                                                           'wsyid' => 474,
                                                           'xsy' => '[Lex-74]'
                                                         },
                                           '[Lex-75]' => {
                                                           'wsyid' => 477,
                                                           'xsy' => '[Lex-75]'
                                                         },
                                           '[Lex-7]' => {
                                                          'wsyid' => 44,
                                                          'xsy' => '[Lex-7]'
                                                        },
                                           '[Lex-8]' => {
                                                          'wsyid' => 52,
                                                          'xsy' => '[Lex-8]'
                                                        },
                                           '[Lex-9]' => {
                                                          'wsyid' => 61,
                                                          'xsy' => '[Lex-9]'
                                                        },
                                           'action' => {
                                                         'wsyid' => 618,
                                                         'xsy' => 'action'
                                                       },
                                           'action name' => {
                                                              'wsyid' => 647,
                                                              'xsy' => 'action name'
                                                            },
                                           'adverb item' => {
                                                              'wsyid' => 616,
                                                              'xsy' => 'adverb item'
                                                            },
                                           'adverb list' => {
                                                              'wsyid' => 614,
                                                              'xsy' => 'adverb list'
                                                            },
                                           'adverb list items' => {
                                                                    'wsyid' => 615,
                                                                    'xsy' => 'adverb list items'
                                                                  },
                                           'alternative' => {
                                                              'wsyid' => 613,
                                                              'xsy' => 'alternative'
                                                            },
                                           'alternative name' => {
                                                                   'wsyid' => 636,
                                                                   'xsy' => 'alternative name'
                                                                 },
                                           'alternatives' => {
                                                               'wsyid' => 612,
                                                               'xsy' => 'alternatives'
                                                             },
                                           'array descriptor' => {
                                                                   'wsyid' => 664,
                                                                   'xsy' => 'array descriptor'
                                                                 },
                                           'bare name' => {
                                                            'wsyid' => 660,
                                                            'xsy' => 'bare name'
                                                          },
                                           'before or after' => {
                                                                  'wsyid' => 653,
                                                                  'xsy' => 'before or after'
                                                                },
                                           'blessing' => {
                                                           'wsyid' => 634,
                                                           'xsy' => 'blessing'
                                                         },
                                           'blessing name' => {
                                                                'wsyid' => 638,
                                                                'xsy' => 'blessing name'
                                                              },
                                           'boolean' => {
                                                          'wsyid' => 651,
                                                          'xsy' => 'boolean'
                                                        },
                                           'bracketed name' => {
                                                                 'wsyid' => 661,
                                                                 'xsy' => 'bracketed name'
                                                               },
                                           'character class' => {
                                                                  'wsyid' => 659,
                                                                  'xsy' => 'character class'
                                                                },
                                           'completion event declaration' => {
                                                                               'wsyid' => 605,
                                                                               'xsy' => 'completion event declaration'
                                                                             },
                                           'default rule' => {
                                                               'wsyid' => 597,
                                                               'xsy' => 'default rule'
                                                             },
                                           'discard default statement' => {
                                                                            'wsyid' => 599,
                                                                            'xsy' => 'discard default statement'
                                                                          },
                                           'discard rule' => {
                                                               'wsyid' => 603,
                                                               'xsy' => 'discard rule'
                                                             },
                                           'eager specification' => {
                                                                      'wsyid' => 624,
                                                                      'xsy' => 'eager specification'
                                                                    },
                                           'empty rule' => {
                                                             'wsyid' => 601,
                                                             'xsy' => 'empty rule'
                                                           },
                                           'event initialization' => {
                                                                       'wsyid' => 631,
                                                                       'xsy' => 'event initialization'
                                                                     },
                                           'event initializer' => {
                                                                    'wsyid' => 632,
                                                                    'xsy' => 'event initializer'
                                                                  },
                                           'event name' => {
                                                             'wsyid' => 637,
                                                             'xsy' => 'event name'
                                                           },
                                           'event specification' => {
                                                                      'wsyid' => 630,
                                                                      'xsy' => 'event specification'
                                                                    },
                                           'group association' => {
                                                                    'wsyid' => 621,
                                                                    'xsy' => 'group association'
                                                                  },
                                           'inaccessible statement' => {
                                                                         'wsyid' => 608,
                                                                         'xsy' => 'inaccessible statement'
                                                                       },
                                           'inaccessible treatment' => {
                                                                         'wsyid' => 609,
                                                                         'xsy' => 'inaccessible treatment'
                                                                       },
                                           'left association' => {
                                                                   'wsyid' => 619,
                                                                   'xsy' => 'left association'
                                                                 },
                                           'lexeme default statement' => {
                                                                           'wsyid' => 598,
                                                                           'xsy' => 'lexeme default statement'
                                                                         },
                                           'lexeme rule' => {
                                                              'wsyid' => 604,
                                                              'xsy' => 'lexeme rule'
                                                            },
                                           'lhs' => {
                                                      'wsyid' => 639,
                                                      'xsy' => 'lhs'
                                                    },
                                           'naming' => {
                                                         'wsyid' => 635,
                                                         'xsy' => 'naming'
                                                       },
                                           'null adverb' => {
                                                              'wsyid' => 617,
                                                              'xsy' => 'null adverb'
                                                            },
                                           'null ranking constant' => {
                                                                        'wsyid' => 627,
                                                                        'xsy' => 'null ranking constant'
                                                                      },
                                           'null ranking specification' => {
                                                                             'wsyid' => 626,
                                                                             'xsy' => 'null ranking specification'
                                                                           },
                                           'null statement' => {
                                                                 'wsyid' => 594,
                                                                 'xsy' => 'null statement'
                                                               },
                                           'nulled event declaration' => {
                                                                           'wsyid' => 606,
                                                                           'xsy' => 'nulled event declaration'
                                                                         },
                                           'on or off' => {
                                                            'wsyid' => 633,
                                                            'xsy' => 'on or off'
                                                          },
                                           'op declare' => {
                                                             'wsyid' => 610,
                                                             'xsy' => 'op declare'
                                                           },
                                           'op declare bnf' => {
                                                                 'wsyid' => 649,
                                                                 'xsy' => 'op declare bnf'
                                                               },
                                           'op declare match' => {
                                                                   'wsyid' => 650,
                                                                   'xsy' => 'op declare match'
                                                                 },
                                           'parenthesized rhs primary list' => {
                                                                                 'wsyid' => 642,
                                                                                 'xsy' => 'parenthesized rhs primary list'
                                                                               },
                                           'pause specification' => {
                                                                      'wsyid' => 629,
                                                                      'xsy' => 'pause specification'
                                                                    },
                                           'prediction event declaration' => {
                                                                               'wsyid' => 607,
                                                                               'xsy' => 'prediction event declaration'
                                                                             },
                                           'priorities' => {
                                                             'wsyid' => 611,
                                                             'xsy' => 'priorities'
                                                           },
                                           'priority rule' => {
                                                                'wsyid' => 600,
                                                                'xsy' => 'priority rule'
                                                              },
                                           'priority specification' => {
                                                                         'wsyid' => 628,
                                                                         'xsy' => 'priority specification'
                                                                       },
                                           'proper specification' => {
                                                                       'wsyid' => 623,
                                                                       'xsy' => 'proper specification'
                                                                     },
                                           'quantified rule' => {
                                                                  'wsyid' => 602,
                                                                  'xsy' => 'quantified rule'
                                                                },
                                           'quantifier' => {
                                                             'wsyid' => 648,
                                                             'xsy' => 'quantifier'
                                                           },
                                           'rank specification' => {
                                                                     'wsyid' => 625,
                                                                     'xsy' => 'rank specification'
                                                                   },
                                           'reserved action name' => {
                                                                       'wsyid' => 663,
                                                                       'xsy' => 'reserved action name'
                                                                     },
                                           'reserved blessing name' => {
                                                                         'wsyid' => 657,
                                                                         'xsy' => 'reserved blessing name'
                                                                       },
                                           'reserved event name' => {
                                                                      'wsyid' => 656,
                                                                      'xsy' => 'reserved event name'
                                                                    },
                                           'rhs' => {
                                                      'wsyid' => 640,
                                                      'xsy' => 'rhs'
                                                    },
                                           'rhs primary' => {
                                                              'wsyid' => 641,
                                                              'xsy' => 'rhs primary'
                                                            },
                                           'rhs primary list' => {
                                                                   'wsyid' => 643,
                                                                   'xsy' => 'rhs primary list'
                                                                 },
                                           'right association' => {
                                                                    'wsyid' => 620,
                                                                    'xsy' => 'right association'
                                                                  },
                                           'separator specification' => {
                                                                          'wsyid' => 622,
                                                                          'xsy' => 'separator specification'
                                                                        },
                                           'signed integer' => {
                                                                 'wsyid' => 652,
                                                                 'xsy' => 'signed integer'
                                                               },
                                           'single quoted name' => {
                                                                     'wsyid' => 655,
                                                                     'xsy' => 'single quoted name'
                                                                   },
                                           'single quoted string' => {
                                                                       'wsyid' => 658,
                                                                       'xsy' => 'single quoted string'
                                                                     },
                                           'single symbol' => {
                                                                'wsyid' => 644,
                                                                'xsy' => 'single symbol'
                                                              },
                                           'standard name' => {
                                                                'wsyid' => 654,
                                                                'xsy' => 'standard name'
                                                              },
                                           'start rule' => {
                                                             'wsyid' => 596,
                                                             'xsy' => 'start rule'
                                                           },
                                           'statement' => {
                                                            'wsyid' => 593,
                                                            'xsy' => 'statement'
                                                          },
                                           'statement group' => {
                                                                  'wsyid' => 595,
                                                                  'xsy' => 'statement group'
                                                                },
                                           'statements' => {
                                                             'wsyid' => 592,
                                                             'xsy' => 'statements'
                                                           },
                                           'symbol' => {
                                                         'wsyid' => 645,
                                                         'xsy' => 'symbol'
                                                       },
                                           'symbol name' => {
                                                              'wsyid' => 646,
                                                              'xsy' => 'symbol name'
                                                            }
                                         },
                                 'L0' => {
                                           'Perl identifier' => {
                                                                  'wsyid' => 684,
                                                                  'xsy' => 'Perl identifier'
                                                                },
                                           'Perl name' => {
                                                            'wsyid' => 686,
                                                            'xsy' => 'Perl name'
                                                          },
                                           '[:discard]' => {
                                                             'wsyid' => 460
                                                           },
                                           '[Lex-0]' => {
                                                          'wsyid' => 2,
                                                          'xsy' => '[Lex-0]'
                                                        },
                                           '[Lex-10]' => {
                                                           'wsyid' => 65,
                                                           'xsy' => '[Lex-10]'
                                                         },
                                           '[Lex-11]' => {
                                                           'wsyid' => 74,
                                                           'xsy' => '[Lex-11]'
                                                         },
                                           '[Lex-12]' => {
                                                           'wsyid' => 83,
                                                           'xsy' => '[Lex-12]'
                                                         },
                                           '[Lex-13]' => {
                                                           'wsyid' => 86,
                                                           'xsy' => '[Lex-13]'
                                                         },
                                           '[Lex-14]' => {
                                                           'wsyid' => 96,
                                                           'xsy' => '[Lex-14]'
                                                         },
                                           '[Lex-15]' => {
                                                           'wsyid' => 105,
                                                           'xsy' => '[Lex-15]'
                                                         },
                                           '[Lex-16]' => {
                                                           'wsyid' => 112,
                                                           'xsy' => '[Lex-16]'
                                                         },
                                           '[Lex-17]' => {
                                                           'wsyid' => 115,
                                                           'xsy' => '[Lex-17]'
                                                         },
                                           '[Lex-18]' => {
                                                           'wsyid' => 126,
                                                           'xsy' => '[Lex-18]'
                                                         },
                                           '[Lex-19]' => {
                                                           'wsyid' => 133,
                                                           'xsy' => '[Lex-19]'
                                                         },
                                           '[Lex-1]' => {
                                                          'wsyid' => 5,
                                                          'xsy' => '[Lex-1]'
                                                        },
                                           '[Lex-20]' => {
                                                           'wsyid' => 136,
                                                           'xsy' => '[Lex-20]'
                                                         },
                                           '[Lex-21]' => {
                                                           'wsyid' => 144,
                                                           'xsy' => '[Lex-21]'
                                                         },
                                           '[Lex-22]' => {
                                                           'wsyid' => 151,
                                                           'xsy' => '[Lex-22]'
                                                         },
                                           '[Lex-23]' => {
                                                           'wsyid' => 154,
                                                           'xsy' => '[Lex-23]'
                                                         },
                                           '[Lex-24]' => {
                                                           'wsyid' => 165,
                                                           'xsy' => '[Lex-24]'
                                                         },
                                           '[Lex-25]' => {
                                                           'wsyid' => 179,
                                                           'xsy' => '[Lex-25]'
                                                         },
                                           '[Lex-26]' => {
                                                           'wsyid' => 183,
                                                           'xsy' => '[Lex-26]'
                                                         },
                                           '[Lex-27]' => {
                                                           'wsyid' => 187,
                                                           'xsy' => '[Lex-27]'
                                                         },
                                           '[Lex-28]' => {
                                                           'wsyid' => 196,
                                                           'xsy' => '[Lex-28]'
                                                         },
                                           '[Lex-29]' => {
                                                           'wsyid' => 202,
                                                           'xsy' => '[Lex-29]'
                                                         },
                                           '[Lex-2]' => {
                                                          'wsyid' => 8,
                                                          'xsy' => '[Lex-2]'
                                                        },
                                           '[Lex-30]' => {
                                                           'wsyid' => 206,
                                                           'xsy' => '[Lex-30]'
                                                         },
                                           '[Lex-31]' => {
                                                           'wsyid' => 213,
                                                           'xsy' => '[Lex-31]'
                                                         },
                                           '[Lex-32]' => {
                                                           'wsyid' => 216,
                                                           'xsy' => '[Lex-32]'
                                                         },
                                           '[Lex-33]' => {
                                                           'wsyid' => 224,
                                                           'xsy' => '[Lex-33]'
                                                         },
                                           '[Lex-34]' => {
                                                           'wsyid' => 228,
                                                           'xsy' => '[Lex-34]'
                                                         },
                                           '[Lex-35]' => {
                                                           'wsyid' => 235,
                                                           'xsy' => '[Lex-35]'
                                                         },
                                           '[Lex-36]' => {
                                                           'wsyid' => 239,
                                                           'xsy' => '[Lex-36]'
                                                         },
                                           '[Lex-37]' => {
                                                           'wsyid' => 245,
                                                           'xsy' => '[Lex-37]'
                                                         },
                                           '[Lex-38]' => {
                                                           'wsyid' => 252,
                                                           'xsy' => '[Lex-38]'
                                                         },
                                           '[Lex-39]' => {
                                                           'wsyid' => 256,
                                                           'xsy' => '[Lex-39]'
                                                         },
                                           '[Lex-3]' => {
                                                          'wsyid' => 16,
                                                          'xsy' => '[Lex-3]'
                                                        },
                                           '[Lex-40]' => {
                                                           'wsyid' => 263,
                                                           'xsy' => '[Lex-40]'
                                                         },
                                           '[Lex-41]' => {
                                                           'wsyid' => 270,
                                                           'xsy' => '[Lex-41]'
                                                         },
                                           '[Lex-42]' => {
                                                           'wsyid' => 274,
                                                           'xsy' => '[Lex-42]'
                                                         },
                                           '[Lex-43]' => {
                                                           'wsyid' => 281,
                                                           'xsy' => '[Lex-43]'
                                                         },
                                           '[Lex-44]' => {
                                                           'wsyid' => 292,
                                                           'xsy' => '[Lex-44]'
                                                         },
                                           '[Lex-45]' => {
                                                           'wsyid' => 296,
                                                           'xsy' => '[Lex-45]'
                                                         },
                                           '[Lex-46]' => {
                                                           'wsyid' => 304,
                                                           'xsy' => '[Lex-46]'
                                                         },
                                           '[Lex-47]' => {
                                                           'wsyid' => 308,
                                                           'xsy' => '[Lex-47]'
                                                         },
                                           '[Lex-48]' => {
                                                           'wsyid' => 315,
                                                           'xsy' => '[Lex-48]'
                                                         },
                                           '[Lex-49]' => {
                                                           'wsyid' => 319,
                                                           'xsy' => '[Lex-49]'
                                                         },
                                           '[Lex-4]' => {
                                                          'wsyid' => 23,
                                                          'xsy' => '[Lex-4]'
                                                        },
                                           '[Lex-50]' => {
                                                           'wsyid' => 325,
                                                           'xsy' => '[Lex-50]'
                                                         },
                                           '[Lex-51]' => {
                                                           'wsyid' => 329,
                                                           'xsy' => '[Lex-51]'
                                                         },
                                           '[Lex-52]' => {
                                                           'wsyid' => 343,
                                                           'xsy' => '[Lex-52]'
                                                         },
                                           '[Lex-53]' => {
                                                           'wsyid' => 347,
                                                           'xsy' => '[Lex-53]'
                                                         },
                                           '[Lex-54]' => {
                                                           'wsyid' => 353,
                                                           'xsy' => '[Lex-54]'
                                                         },
                                           '[Lex-55]' => {
                                                           'wsyid' => 359,
                                                           'xsy' => '[Lex-55]'
                                                         },
                                           '[Lex-56]' => {
                                                           'wsyid' => 363,
                                                           'xsy' => '[Lex-56]'
                                                         },
                                           '[Lex-57]' => {
                                                           'wsyid' => 368,
                                                           'xsy' => '[Lex-57]'
                                                         },
                                           '[Lex-58]' => {
                                                           'wsyid' => 374,
                                                           'xsy' => '[Lex-58]'
                                                         },
                                           '[Lex-59]' => {
                                                           'wsyid' => 384,
                                                           'xsy' => '[Lex-59]'
                                                         },
                                           '[Lex-5]' => {
                                                          'wsyid' => 31,
                                                          'xsy' => '[Lex-5]'
                                                        },
                                           '[Lex-60]' => {
                                                           'wsyid' => 388,
                                                           'xsy' => '[Lex-60]'
                                                         },
                                           '[Lex-61]' => {
                                                           'wsyid' => 395,
                                                           'xsy' => '[Lex-61]'
                                                         },
                                           '[Lex-62]' => {
                                                           'wsyid' => 399,
                                                           'xsy' => '[Lex-62]'
                                                         },
                                           '[Lex-63]' => {
                                                           'wsyid' => 406,
                                                           'xsy' => '[Lex-63]'
                                                         },
                                           '[Lex-64]' => {
                                                           'wsyid' => 410,
                                                           'xsy' => '[Lex-64]'
                                                         },
                                           '[Lex-65]' => {
                                                           'wsyid' => 413,
                                                           'xsy' => '[Lex-65]'
                                                         },
                                           '[Lex-66]' => {
                                                           'wsyid' => 417,
                                                           'xsy' => '[Lex-66]'
                                                         },
                                           '[Lex-67]' => {
                                                           'wsyid' => 422,
                                                           'xsy' => '[Lex-67]'
                                                         },
                                           '[Lex-68]' => {
                                                           'wsyid' => 429,
                                                           'xsy' => '[Lex-68]'
                                                         },
                                           '[Lex-69]' => {
                                                           'wsyid' => 433,
                                                           'xsy' => '[Lex-69]'
                                                         },
                                           '[Lex-6]' => {
                                                          'wsyid' => 35,
                                                          'xsy' => '[Lex-6]'
                                                        },
                                           '[Lex-70]' => {
                                                           'wsyid' => 439,
                                                           'xsy' => '[Lex-70]'
                                                         },
                                           '[Lex-71]' => {
                                                           'wsyid' => 443,
                                                           'xsy' => '[Lex-71]'
                                                         },
                                           '[Lex-72]' => {
                                                           'wsyid' => 453,
                                                           'xsy' => '[Lex-72]'
                                                         },
                                           '[Lex-73]' => {
                                                           'wsyid' => 456,
                                                           'xsy' => '[Lex-73]'
                                                         },
                                           '[Lex-74]' => {
                                                           'wsyid' => 475,
                                                           'xsy' => '[Lex-74]'
                                                         },
                                           '[Lex-75]' => {
                                                           'wsyid' => 478,
                                                           'xsy' => '[Lex-75]'
                                                         },
                                           '[Lex-7]' => {
                                                          'wsyid' => 45,
                                                          'xsy' => '[Lex-7]'
                                                        },
                                           '[Lex-8]' => {
                                                          'wsyid' => 53,
                                                          'xsy' => '[Lex-8]'
                                                        },
                                           '[Lex-9]' => {
                                                          'wsyid' => 62,
                                                          'xsy' => '[Lex-9]'
                                                        },
                                           '[[\']]' => {
                                                         'wsyid' => 570,
                                                         'xsy' => '[[\']]'
                                                       },
                                           '[[+-]]' => {
                                                         'wsyid' => 490,
                                                         'xsy' => '[[+-]]'
                                                       },
                                           '[[,]]' => {
                                                        'wsyid' => 512,
                                                        'xsy' => '[[,]]'
                                                      },
                                           '[[01]]' => {
                                                         'wsyid' => 492,
                                                         'xsy' => '[[01]]'
                                                       },
                                           '[[1]]' => {
                                                        'wsyid' => 532,
                                                        'xsy' => '[[1]]'
                                                      },
                                           '[[[:alnum:]]]' => {
                                                                'wsyid' => 590,
                                                                'xsy' => '[[[:alnum:]]]'
                                                              },
                                           '[[\\#]]' => {
                                                          'wsyid' => 463,
                                                          'xsy' => '[[\\#]]'
                                                        },
                                           '[[\\(]]' => {
                                                          'wsyid' => 451,
                                                          'xsy' => '[[\\(]]'
                                                        },
                                           '[[\\)]]' => {
                                                          'wsyid' => 454,
                                                          'xsy' => '[[\\)]]'
                                                        },
                                           '[[\\*]]' => {
                                                          'wsyid' => 473,
                                                          'xsy' => '[[\\*]]'
                                                        },
                                           '[[\\+]]' => {
                                                          'wsyid' => 476,
                                                          'xsy' => '[[\\+]]'
                                                        },
                                           '[[\\,]]' => {
                                                          'wsyid' => 214,
                                                          'xsy' => '[[\\,]]'
                                                        },
                                           '[[\\-]]' => {
                                                          'wsyid' => 334,
                                                          'xsy' => '[[\\-]]'
                                                        },
                                           '[[\\:]]' => {
                                                          'wsyid' => 588,
                                                          'xsy' => '[[\\:]]'
                                                        },
                                           '[[\\;]]' => {
                                                          'wsyid' => 0,
                                                          'xsy' => '[[\\;]]'
                                                        },
                                           '[[\\<]]' => {
                                                          'wsyid' => 504,
                                                          'xsy' => '[[\\<]]'
                                                        },
                                           '[[\\=]]' => {
                                                          'wsyid' => 468,
                                                          'xsy' => '[[\\=]]'
                                                        },
                                           '[[\\>]]' => {
                                                          'wsyid' => 505,
                                                          'xsy' => '[[\\>]]'
                                                        },
                                           '[[\\[]]' => {
                                                          'wsyid' => 585,
                                                          'xsy' => '[[\\[]]'
                                                        },
                                           '[[\\\\]]' => {
                                                           'wsyid' => 575,
                                                           'xsy' => '[[\\\\]]'
                                                         },
                                           '[[\\]]]' => {
                                                          'wsyid' => 589,
                                                          'xsy' => '[[\\]]]'
                                                        },
                                           '[[\\^]]' => {
                                                          'wsyid' => 587,
                                                          'xsy' => '[[\\^]]'
                                                        },
                                           '[[\\d]]' => {
                                                          'wsyid' => 491,
                                                          'xsy' => '[[\\d]]'
                                                        },
                                           '[[\\s\\w]]' => {
                                                             'wsyid' => 506,
                                                             'xsy' => '[[\\s\\w]]'
                                                           },
                                           '[[\\s]]' => {
                                                          'wsyid' => 459,
                                                          'xsy' => '[[\\s]]'
                                                        },
                                           '[[\\w]]' => {
                                                          'wsyid' => 502,
                                                          'xsy' => '[[\\w]]'
                                                        },
                                           '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                 'wsyid' => 464,
                                                                                                 'xsy' => '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                               },
                                           '[[\\{]]' => {
                                                          'wsyid' => 3,
                                                          'xsy' => '[[\\{]]'
                                                        },
                                           '[[\\|]]' => {
                                                          'wsyid' => 472,
                                                          'xsy' => '[[\\|]]'
                                                        },
                                           '[[\\}]]' => {
                                                          'wsyid' => 6,
                                                          'xsy' => '[[\\}]]'
                                                        },
                                           '[[\\~]]' => {
                                                          'wsyid' => 469,
                                                          'xsy' => '[[\\~]]'
                                                        },
                                           '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                 'wsyid' => 571,
                                                                                                                 'xsy' => '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                               },
                                           '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                      'wsyid' => 574,
                                                                                                                      'xsy' => '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                    },
                                           '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                  'wsyid' => 591,
                                                                                                  'xsy' => '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                },
                                           '[[a-zA-Z]]' => {
                                                             'wsyid' => 503,
                                                             'xsy' => '[[a-zA-Z]]'
                                                           },
                                           '[[a]]' => {
                                                        'wsyid' => 562,
                                                        'xsy' => '[[a]]'
                                                      },
                                           '[[b]]' => {
                                                        'wsyid' => 549,
                                                        'xsy' => '[[b]]'
                                                      },
                                           '[[c]]' => {
                                                        'wsyid' => 578,
                                                        'xsy' => '[[c]]'
                                                      },
                                           '[[d]]' => {
                                                        'wsyid' => 188,
                                                        'xsy' => '[[d]]'
                                                      },
                                           '[[e]]' => {
                                                        'wsyid' => 565,
                                                        'xsy' => '[[e]]'
                                                      },
                                           '[[f]]' => {
                                                        'wsyid' => 486,
                                                        'xsy' => '[[f]]'
                                                      },
                                           '[[g]]' => {
                                                        'wsyid' => 536,
                                                        'xsy' => '[[g]]'
                                                      },
                                           '[[h]]' => {
                                                        'wsyid' => 544,
                                                        'xsy' => '[[h]]'
                                                      },
                                           '[[i]]' => {
                                                        'wsyid' => 580,
                                                        'xsy' => '[[i]]'
                                                      },
                                           '[[k]]' => {
                                                        'wsyid' => 357,
                                                        'xsy' => '[[k]]'
                                                      },
                                           '[[l]]' => {
                                                        'wsyid' => 563,
                                                        'xsy' => '[[l]]'
                                                      },
                                           '[[m]]' => {
                                                        'wsyid' => 548,
                                                        'xsy' => '[[m]]'
                                                      },
                                           '[[n]]' => {
                                                        'wsyid' => 539,
                                                        'xsy' => '[[n]]'
                                                      },
                                           '[[o]]' => {
                                                        'wsyid' => 550,
                                                        'xsy' => '[[o]]'
                                                      },
                                           '[[p]]' => {
                                                        'wsyid' => 389,
                                                        'xsy' => '[[p]]'
                                                      },
                                           '[[r]]' => {
                                                        'wsyid' => 552,
                                                        'xsy' => '[[r]]'
                                                      },
                                           '[[s]]' => {
                                                        'wsyid' => 566,
                                                        'xsy' => '[[s]]'
                                                      },
                                           '[[t]]' => {
                                                        'wsyid' => 537,
                                                        'xsy' => '[[t]]'
                                                      },
                                           '[[u]]' => {
                                                        'wsyid' => 564,
                                                        'xsy' => '[[u]]'
                                                      },
                                           '[[v]]' => {
                                                        'wsyid' => 561,
                                                        'xsy' => '[[v]]'
                                                      },
                                           '[[w]]' => {
                                                        'wsyid' => 366,
                                                        'xsy' => '[[w]]'
                                                      },
                                           '[[x]]' => {
                                                        'wsyid' => 100,
                                                        'xsy' => '[[x]]'
                                                      },
                                           '[[y]]' => {
                                                        'wsyid' => 547,
                                                        'xsy' => '[[y]]'
                                                      },
                                           'array descriptor' => {
                                                                   'wsyid' => 691,
                                                                   'xsy' => 'array descriptor'
                                                                 },
                                           'array descriptor left bracket' => {
                                                                                'wsyid' => 692,
                                                                                'xsy' => 'array descriptor left bracket'
                                                                              },
                                           'array descriptor right bracket' => {
                                                                                 'wsyid' => 693,
                                                                                 'xsy' => 'array descriptor right bracket'
                                                                               },
                                           'bare name' => {
                                                            'wsyid' => 687,
                                                            'xsy' => 'bare name'
                                                          },
                                           'before or after' => {
                                                                  'wsyid' => 675,
                                                                  'xsy' => 'before or after'
                                                                },
                                           'boolean' => {
                                                          'wsyid' => 679,
                                                          'xsy' => 'boolean'
                                                        },
                                           'bracketed name' => {
                                                                 'wsyid' => 689,
                                                                 'xsy' => 'bracketed name'
                                                               },
                                           'bracketed name string' => {
                                                                        'wsyid' => 690,
                                                                        'xsy' => 'bracketed name string'
                                                                      },
                                           'cc element' => {
                                                             'wsyid' => 702,
                                                             'xsy' => 'cc element'
                                                           },
                                           'cc elements' => {
                                                              'wsyid' => 701,
                                                              'xsy' => 'cc elements'
                                                            },
                                           'character class' => {
                                                                  'wsyid' => 700,
                                                                  'xsy' => 'character class'
                                                                },
                                           'character class modifier' => {
                                                                           'wsyid' => 706,
                                                                           'xsy' => 'character class modifier'
                                                                         },
                                           'character class modifiers' => {
                                                                            'wsyid' => 705,
                                                                            'xsy' => 'character class modifiers'
                                                                          },
                                           'double colon' => {
                                                               'wsyid' => 685,
                                                               'xsy' => 'double colon'
                                                             },
                                           'escaped cc character' => {
                                                                       'wsyid' => 704,
                                                                       'xsy' => 'escaped cc character'
                                                                     },
                                           'hash comment' => {
                                                               'wsyid' => 461,
                                                               'xsy' => 'hash comment'
                                                             },
                                           'hash comment body' => {
                                                                    'wsyid' => 668,
                                                                    'xsy' => 'hash comment body'
                                                                  },
                                           'hash comment char' => {
                                                                    'wsyid' => 670,
                                                                    'xsy' => 'hash comment char'
                                                                  },
                                           'horizontal character' => {
                                                                       'wsyid' => 710,
                                                                       'xsy' => 'horizontal character'
                                                                     },
                                           'integer' => {
                                                          'wsyid' => 678,
                                                          'xsy' => 'integer'
                                                        },
                                           'negated posix char class' => {
                                                                           'wsyid' => 708,
                                                                           'xsy' => 'negated posix char class'
                                                                         },
                                           'one or more word characters' => {
                                                                              'wsyid' => 682,
                                                                              'xsy' => 'one or more word characters'
                                                                            },
                                           'op declare bnf' => {
                                                                 'wsyid' => 671,
                                                                 'xsy' => 'op declare bnf'
                                                               },
                                           'op declare match' => {
                                                                   'wsyid' => 672,
                                                                   'xsy' => 'op declare match'
                                                                 },
                                           'op equal priority' => {
                                                                    'wsyid' => 674,
                                                                    'xsy' => 'op equal priority'
                                                                  },
                                           'op loosen' => {
                                                            'wsyid' => 673,
                                                            'xsy' => 'op loosen'
                                                          },
                                           'posix char class' => {
                                                                   'wsyid' => 707,
                                                                   'xsy' => 'posix char class'
                                                                 },
                                           'posix char class name' => {
                                                                        'wsyid' => 709,
                                                                        'xsy' => 'posix char class name'
                                                                      },
                                           'reserved action name' => {
                                                                       'wsyid' => 680,
                                                                       'xsy' => 'reserved action name'
                                                                     },
                                           'reserved blessing name' => {
                                                                         'wsyid' => 681,
                                                                         'xsy' => 'reserved blessing name'
                                                                       },
                                           'reserved event name' => {
                                                                      'wsyid' => 665,
                                                                      'xsy' => 'reserved event name'
                                                                    },
                                           'result item descriptor' => {
                                                                         'wsyid' => 696,
                                                                         'xsy' => 'result item descriptor'
                                                                       },
                                           'result item descriptor list' => {
                                                                              'wsyid' => 694,
                                                                              'xsy' => 'result item descriptor list'
                                                                            },
                                           'result item descriptor separator' => {
                                                                                   'wsyid' => 695,
                                                                                   'xsy' => 'result item descriptor separator'
                                                                                 },
                                           'safe cc character' => {
                                                                    'wsyid' => 703,
                                                                    'xsy' => 'safe cc character'
                                                                  },
                                           'sign' => {
                                                       'wsyid' => 677,
                                                       'xsy' => 'sign'
                                                     },
                                           'signed integer' => {
                                                                 'wsyid' => 676,
                                                                 'xsy' => 'signed integer'
                                                               },
                                           'single quoted name' => {
                                                                     'wsyid' => 698,
                                                                     'xsy' => 'single quoted name'
                                                                   },
                                           'single quoted string' => {
                                                                       'wsyid' => 697,
                                                                       'xsy' => 'single quoted string'
                                                                     },
                                           'standard name' => {
                                                                'wsyid' => 688,
                                                                'xsy' => 'standard name'
                                                              },
                                           'string without single quote or vertical space' => {
                                                                                                'wsyid' => 699,
                                                                                                'xsy' => 'string without single quote or vertical space'
                                                                                              },
                                           'terminated hash comment' => {
                                                                          'wsyid' => 666,
                                                                          'xsy' => 'terminated hash comment'
                                                                        },
                                           'unterminated final hash comment' => {
                                                                                  'wsyid' => 667,
                                                                                  'xsy' => 'unterminated final hash comment'
                                                                                },
                                           'vertical space char' => {
                                                                      'wsyid' => 669,
                                                                      'xsy' => 'vertical space char'
                                                                    },
                                           'whitespace' => {
                                                             'wsyid' => 458,
                                                             'xsy' => 'whitespace'
                                                           },
                                           'zero or more word characters' => {
                                                                               'wsyid' => 683,
                                                                               'xsy' => 'zero or more word characters'
                                                                             }
                                         }
                               },
                  'xbnf' => {
                              'G1' => {
                                        '[:start],statements' => {
                                                                   'action' => '::first',
                                                                   'length' => 0,
                                                                   'lhs' => '[:start]',
                                                                   'rhs' => [
                                                                              'statements'
                                                                            ],
                                                                   'start' => 0,
                                                                   'subkey' => 0
                                                                 },
                                        'action name,Perl name' => {
                                                                     'action' => '[start,length,values]',
                                                                     'bless' => 'action_name',
                                                                     'length' => 29,
                                                                     'lhs' => 'action name',
                                                                     'mask' => [
                                                                                 1
                                                                               ],
                                                                     'name' => 'action name',
                                                                     'rhs' => [
                                                                                'Perl name'
                                                                              ],
                                                                     'start' => 4634,
                                                                     'subkey' => 1,
                                                                     'xrlid' => 'action name@4634+29'
                                                                   },
                                        'action name,array descriptor' => {
                                                                            'action' => '[start,length,values]',
                                                                            'bless' => 'action_name',
                                                                            'length' => 36,
                                                                            'lhs' => 'action name',
                                                                            'mask' => [
                                                                                        1
                                                                                      ],
                                                                            'name' => 'action name',
                                                                            'rhs' => [
                                                                                       'array descriptor'
                                                                                     ],
                                                                            'start' => 4705,
                                                                            'subkey' => 1,
                                                                            'xrlid' => 'action name@4705+36'
                                                                          },
                                        'action name,reserved action name' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'action_name',
                                                                                'length' => 40,
                                                                                'lhs' => 'action name',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'action name',
                                                                                'rhs' => [
                                                                                           'reserved action name'
                                                                                         ],
                                                                                'start' => 4664,
                                                                                'subkey' => 1,
                                                                                'xrlid' => 'action name@4664+40'
                                                                              },
                                        'action,[Lex-33],[Lex-34],action name' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'action',
                                                                                    'length' => 40,
                                                                                    'lhs' => 'action',
                                                                                    'mask' => [
                                                                                                0,
                                                                                                0,
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'action',
                                                                                    'rhs' => [
                                                                                               '[Lex-33]',
                                                                                               '[Lex-34]',
                                                                                               'action name'
                                                                                             ],
                                                                                    'start' => 2900,
                                                                                    'subkey' => 1,
                                                                                    'xrlid' => 'action@2900+40'
                                                                                  },
                                        'adverb item,action' => {
                                                                  'action' => '[start,length,values]',
                                                                  'bless' => 'adverb_item',
                                                                  'length' => 369,
                                                                  'lhs' => 'adverb item',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'name' => 'adverb item',
                                                                  'rhs' => [
                                                                             'action'
                                                                           ],
                                                                  'start' => 2507,
                                                                  'subkey' => 1,
                                                                  'xrlid' => 'adverb item@2507+369'
                                                                },
                                        'adverb item,blessing' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'adverb_item',
                                                                    'length' => 8,
                                                                    'lhs' => 'adverb item',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'adverb item',
                                                                    'rhs' => [
                                                                               'blessing'
                                                                             ],
                                                                    'start' => 2843,
                                                                    'subkey' => 13,
                                                                    'xrlid' => 'adverb item@2507+369'
                                                                  },
                                        'adverb item,eager specification' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_item',
                                                                               'length' => 21,
                                                                               'lhs' => 'adverb item',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb item',
                                                                               'rhs' => [
                                                                                          'eager specification'
                                                                                        ],
                                                                               'start' => 2728,
                                                                               'subkey' => 9,
                                                                               'xrlid' => 'adverb item@2507+369'
                                                                             },
                                        'adverb item,event specification' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_item',
                                                                               'length' => 21,
                                                                               'lhs' => 'adverb item',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb item',
                                                                               'rhs' => [
                                                                                          'event specification'
                                                                                        ],
                                                                               'start' => 2756,
                                                                               'subkey' => 10,
                                                                               'xrlid' => 'adverb item@2507+369'
                                                                             },
                                        'adverb item,group association' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'adverb_item',
                                                                             'length' => 19,
                                                                             'lhs' => 'adverb item',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'adverb item',
                                                                             'rhs' => [
                                                                                        'group association'
                                                                                      ],
                                                                             'start' => 2587,
                                                                             'subkey' => 4,
                                                                             'xrlid' => 'adverb item@2507+369'
                                                                           },
                                        'adverb item,left association' => {
                                                                            'action' => '[start,length,values]',
                                                                            'bless' => 'adverb_item',
                                                                            'length' => 18,
                                                                            'lhs' => 'adverb item',
                                                                            'mask' => [
                                                                                        1
                                                                                      ],
                                                                            'name' => 'adverb item',
                                                                            'rhs' => [
                                                                                       'left association'
                                                                                     ],
                                                                            'start' => 2544,
                                                                            'subkey' => 2,
                                                                            'xrlid' => 'adverb item@2507+369'
                                                                          },
                                        'adverb item,naming' => {
                                                                  'action' => '[start,length,values]',
                                                                  'bless' => 'adverb_item',
                                                                  'length' => 6,
                                                                  'lhs' => 'adverb item',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'name' => 'adverb item',
                                                                  'rhs' => [
                                                                             'naming'
                                                                           ],
                                                                  'start' => 2854,
                                                                  'subkey' => 14,
                                                                  'xrlid' => 'adverb item@2507+369'
                                                                },
                                        'adverb item,null adverb' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'adverb_item',
                                                                       'length' => 13,
                                                                       'lhs' => 'adverb item',
                                                                       'mask' => [
                                                                                   1
                                                                                 ],
                                                                       'name' => 'adverb item',
                                                                       'rhs' => [
                                                                                  'null adverb'
                                                                                ],
                                                                       'start' => 2863,
                                                                       'subkey' => 15,
                                                                       'xrlid' => 'adverb item@2507+369'
                                                                     },
                                        'adverb item,null ranking specification' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'adverb_item',
                                                                                      'length' => 28,
                                                                                      'lhs' => 'adverb item',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'adverb item',
                                                                                      'rhs' => [
                                                                                                 'null ranking specification'
                                                                                               ],
                                                                                      'start' => 2693,
                                                                                      'subkey' => 8,
                                                                                      'xrlid' => 'adverb item@2507+369'
                                                                                    },
                                        'adverb item,pause specification' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'adverb_item',
                                                                               'length' => 21,
                                                                               'lhs' => 'adverb item',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'adverb item',
                                                                               'rhs' => [
                                                                                          'pause specification'
                                                                                        ],
                                                                               'start' => 2815,
                                                                               'subkey' => 12,
                                                                               'xrlid' => 'adverb item@2507+369'
                                                                             },
                                        'adverb item,priority specification' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'adverb_item',
                                                                                  'length' => 24,
                                                                                  'lhs' => 'adverb item',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'adverb item',
                                                                                  'rhs' => [
                                                                                             'priority specification'
                                                                                           ],
                                                                                  'start' => 2784,
                                                                                  'subkey' => 11,
                                                                                  'xrlid' => 'adverb item@2507+369'
                                                                                },
                                        'adverb item,proper specification' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'adverb_item',
                                                                                'length' => 22,
                                                                                'lhs' => 'adverb item',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'adverb item',
                                                                                'rhs' => [
                                                                                           'proper specification'
                                                                                         ],
                                                                                'start' => 2641,
                                                                                'subkey' => 6,
                                                                                'xrlid' => 'adverb item@2507+369'
                                                                              },
                                        'adverb item,rank specification' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'adverb_item',
                                                                              'length' => 20,
                                                                              'lhs' => 'adverb item',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'adverb item',
                                                                              'rhs' => [
                                                                                         'rank specification'
                                                                                       ],
                                                                              'start' => 2670,
                                                                              'subkey' => 7,
                                                                              'xrlid' => 'adverb item@2507+369'
                                                                            },
                                        'adverb item,right association' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'adverb_item',
                                                                             'length' => 19,
                                                                             'lhs' => 'adverb item',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'adverb item',
                                                                             'rhs' => [
                                                                                        'right association'
                                                                                      ],
                                                                             'start' => 2565,
                                                                             'subkey' => 3,
                                                                             'xrlid' => 'adverb item@2507+369'
                                                                           },
                                        'adverb item,separator specification' => {
                                                                                   'action' => '[start,length,values]',
                                                                                   'bless' => 'adverb_item',
                                                                                   'length' => 25,
                                                                                   'lhs' => 'adverb item',
                                                                                   'mask' => [
                                                                                               1
                                                                                             ],
                                                                                   'name' => 'adverb item',
                                                                                   'rhs' => [
                                                                                              'separator specification'
                                                                                            ],
                                                                                   'start' => 2613,
                                                                                   'subkey' => 5,
                                                                                   'xrlid' => 'adverb item@2507+369'
                                                                                 },
                                        'adverb list items,adverb item' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'adverb_list_items',
                                                                             'length' => 38,
                                                                             'lhs' => 'adverb list items',
                                                                             'min' => 0,
                                                                             'name' => 'adverb list items',
                                                                             'rhs' => [
                                                                                        'adverb item'
                                                                                      ],
                                                                             'start' => 2468,
                                                                             'subkey' => 0,
                                                                             'xrlid' => 'adverb list items@2468+38'
                                                                           },
                                        'adverb list,adverb list items' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'adverb_list',
                                                                             'length' => 37,
                                                                             'lhs' => 'adverb list',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'adverb list',
                                                                             'rhs' => [
                                                                                        'adverb list items'
                                                                                      ],
                                                                             'start' => 2430,
                                                                             'subkey' => 1,
                                                                             'xrlid' => 'adverb list@2430+37'
                                                                           },
                                        'alternative name,single quoted name' => {
                                                                                   'action' => '[start,length,values]',
                                                                                   'bless' => 'alternative_name',
                                                                                   'length' => 20,
                                                                                   'lhs' => 'alternative name',
                                                                                   'mask' => [
                                                                                               1
                                                                                             ],
                                                                                   'name' => 'alternative name',
                                                                                   'rhs' => [
                                                                                              'single quoted name'
                                                                                            ],
                                                                                   'start' => 3987,
                                                                                   'subkey' => 2,
                                                                                   'xrlid' => 'alternative name@3946+61'
                                                                                 },
                                        'alternative name,standard name' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'alternative_name',
                                                                              'length' => 61,
                                                                              'lhs' => 'alternative name',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'alternative name',
                                                                              'rhs' => [
                                                                                         'standard name'
                                                                                       ],
                                                                              'start' => 3946,
                                                                              'subkey' => 1,
                                                                              'xrlid' => 'alternative name@3946+61'
                                                                            },
                                        'alternative,rhs,adverb list' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'alternative',
                                                                           'length' => 33,
                                                                           'lhs' => 'alternative',
                                                                           'mask' => [
                                                                                       1,
                                                                                       1
                                                                                     ],
                                                                           'name' => 'alternative',
                                                                           'rhs' => [
                                                                                      'rhs',
                                                                                      'adverb list'
                                                                                    ],
                                                                           'start' => 2395,
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'alternative@2395+33'
                                                                         },
                                        'alternatives,alternative' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'alternatives',
                                                                        'length' => 78,
                                                                        'lhs' => 'alternatives',
                                                                        'min' => 1,
                                                                        'name' => 'alternatives',
                                                                        'proper' => '1',
                                                                        'rhs' => [
                                                                                   'alternative'
                                                                                 ],
                                                                        'separator' => 'op equal priority',
                                                                        'start' => 2316,
                                                                        'subkey' => 0,
                                                                        'xrlid' => 'alternatives@2316+78'
                                                                      },
                                        'blessing name,reserved blessing name' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'blessing_name',
                                                                                    'length' => 44,
                                                                                    'lhs' => 'blessing name',
                                                                                    'mask' => [
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'blessing name',
                                                                                    'rhs' => [
                                                                                               'reserved blessing name'
                                                                                             ],
                                                                                    'start' => 4168,
                                                                                    'subkey' => 1,
                                                                                    'xrlid' => 'blessing name@4168+44'
                                                                                  },
                                        'blessing name,standard name' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'blessing_name',
                                                                           'length' => 35,
                                                                           'lhs' => 'blessing name',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'blessing name',
                                                                           'rhs' => [
                                                                                      'standard name'
                                                                                    ],
                                                                           'start' => 4132,
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'blessing name@4132+35'
                                                                         },
                                        'blessing,[Lex-68],[Lex-69],blessing name' => {
                                                                                        'action' => '[start,length,values]',
                                                                                        'bless' => 'blessing',
                                                                                        'length' => 45,
                                                                                        'lhs' => 'blessing',
                                                                                        'mask' => [
                                                                                                    0,
                                                                                                    0,
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'blessing',
                                                                                        'rhs' => [
                                                                                                   '[Lex-68]',
                                                                                                   '[Lex-69]',
                                                                                                   'blessing name'
                                                                                                 ],
                                                                                        'start' => 3853,
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'blessing@3853+45'
                                                                                      },
                                        'completion event declaration,[Lex-16],event initialization,[Lex-17],[Lex-18],symbol name' => {
                                                                                                                                        'action' => '[start,length,values]',
                                                                                                                                        'bless' => 'completion_event_declaration',
                                                                                                                                        'length' => 99,
                                                                                                                                        'lhs' => 'completion event declaration',
                                                                                                                                        'mask' => [
                                                                                                                                                    0,
                                                                                                                                                    1,
                                                                                                                                                    0,
                                                                                                                                                    0,
                                                                                                                                                    1
                                                                                                                                                  ],
                                                                                                                                        'name' => 'completion event declaration',
                                                                                                                                        'rhs' => [
                                                                                                                                                   '[Lex-16]',
                                                                                                                                                   'event initialization',
                                                                                                                                                   '[Lex-17]',
                                                                                                                                                   '[Lex-18]',
                                                                                                                                                   'symbol name'
                                                                                                                                                 ],
                                                                                                                                        'start' => 1750,
                                                                                                                                        'subkey' => 1,
                                                                                                                                        'xrlid' => 'completion event declaration@1750+99'
                                                                                                                                      },
                                        'default rule,[Lex-7],op declare bnf,adverb list' => {
                                                                                               'action' => '[start,length,values]',
                                                                                               'bless' => 'default_rule',
                                                                                               'length' => 60,
                                                                                               'lhs' => 'default rule',
                                                                                               'mask' => [
                                                                                                           1,
                                                                                                           1,
                                                                                                           1
                                                                                                         ],
                                                                                               'name' => 'default rule',
                                                                                               'rhs' => [
                                                                                                          '[Lex-7]',
                                                                                                          'op declare bnf',
                                                                                                          'adverb list'
                                                                                                        ],
                                                                                               'start' => 1220,
                                                                                               'subkey' => 1,
                                                                                               'xrlid' => 'default rule@1220+60'
                                                                                             },
                                        'discard default statement,[Lex-11],[Lex-12],[Lex-13],adverb list' => {
                                                                                                                'action' => '[start,length,values]',
                                                                                                                'bless' => 'discard_default_statement',
                                                                                                                'length' => 71,
                                                                                                                'lhs' => 'discard default statement',
                                                                                                                'mask' => [
                                                                                                                            0,
                                                                                                                            0,
                                                                                                                            0,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'name' => 'discard default statement',
                                                                                                                'rhs' => [
                                                                                                                           '[Lex-11]',
                                                                                                                           '[Lex-12]',
                                                                                                                           '[Lex-13]',
                                                                                                                           'adverb list'
                                                                                                                         ],
                                                                                                                'start' => 1351,
                                                                                                                'subkey' => 1,
                                                                                                                'xrlid' => 'discard default statement@1351+71'
                                                                                                              },
                                        'discard rule,[Lex-14],op declare match,single symbol,adverb list' => {
                                                                                                                'action' => '[start,length,values]',
                                                                                                                'bless' => 'discard_rule',
                                                                                                                'length' => 80,
                                                                                                                'lhs' => 'discard rule',
                                                                                                                'mask' => [
                                                                                                                            0,
                                                                                                                            0,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'name' => 'discard rule',
                                                                                                                'rhs' => [
                                                                                                                           '[Lex-14]',
                                                                                                                           'op declare match',
                                                                                                                           'single symbol',
                                                                                                                           'adverb list'
                                                                                                                         ],
                                                                                                                'start' => 1599,
                                                                                                                'subkey' => 1,
                                                                                                                'xrlid' => 'discard rule@1599+80'
                                                                                                              },
                                        'eager specification,[Lex-48],[Lex-49],boolean' => {
                                                                                             'action' => '[start,length,values]',
                                                                                             'bless' => 'eager_specification',
                                                                                             'length' => 48,
                                                                                             'lhs' => 'eager specification',
                                                                                             'mask' => [
                                                                                                         0,
                                                                                                         0,
                                                                                                         1
                                                                                                       ],
                                                                                             'name' => 'eager specification',
                                                                                             'rhs' => [
                                                                                                        '[Lex-48]',
                                                                                                        '[Lex-49]',
                                                                                                        'boolean'
                                                                                                      ],
                                                                                             'start' => 3196,
                                                                                             'subkey' => 1,
                                                                                             'xrlid' => 'eager specification@3196+48'
                                                                                           },
                                        'empty rule,lhs,op declare,adverb list' => {
                                                                                     'action' => '[start,length,values]',
                                                                                     'bless' => 'empty_rule',
                                                                                     'length' => 47,
                                                                                     'lhs' => 'empty rule',
                                                                                     'mask' => [
                                                                                                 1,
                                                                                                 1,
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'empty rule',
                                                                                     'rhs' => [
                                                                                                'lhs',
                                                                                                'op declare',
                                                                                                'adverb list'
                                                                                              ],
                                                                                     'start' => 1471,
                                                                                     'subkey' => 1,
                                                                                     'xrlid' => 'empty rule@1471+47'
                                                                                   },
                                        'event initialization,event name,event initializer' => {
                                                                                                 'action' => '[start,length,values]',
                                                                                                 'bless' => 'event_initialization',
                                                                                                 'length' => 59,
                                                                                                 'lhs' => 'event initialization',
                                                                                                 'mask' => [
                                                                                                             1,
                                                                                                             1
                                                                                                           ],
                                                                                                 'name' => 'event initialization',
                                                                                                 'rhs' => [
                                                                                                            'event name',
                                                                                                            'event initializer'
                                                                                                          ],
                                                                                                 'start' => 3689,
                                                                                                 'subkey' => 1,
                                                                                                 'xrlid' => 'event initialization@3689+59'
                                                                                               },
                                        'event initializer' => {
                                                                 'action' => '[start,length,values]',
                                                                 'bless' => 'event_initializer',
                                                                 'length' => 23,
                                                                 'lhs' => 'event initializer',
                                                                 'name' => 'event initializer',
                                                                 'rhs' => [],
                                                                 'start' => 3820,
                                                                 'subkey' => 0,
                                                                 'xrlid' => 'event initializer@3820+23'
                                                               },
                                        'event initializer,[Lex-65],on or off' => {
                                                                                    'action' => '[start,length,values]',
                                                                                    'bless' => 'event_initializer',
                                                                                    'length' => 41,
                                                                                    'lhs' => 'event initializer',
                                                                                    'mask' => [
                                                                                                0,
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'event initializer',
                                                                                    'rhs' => [
                                                                                               '[Lex-65]',
                                                                                               'on or off'
                                                                                             ],
                                                                                    'start' => 3749,
                                                                                    'subkey' => 1,
                                                                                    'xrlid' => 'event initializer@3749+41'
                                                                                  },
                                        'event name,reserved event name' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'event_name',
                                                                              'length' => 21,
                                                                              'lhs' => 'event name',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'event name',
                                                                              'rhs' => [
                                                                                         'reserved event name'
                                                                                       ],
                                                                              'start' => 4075,
                                                                              'subkey' => 3,
                                                                              'xrlid' => 'event name@4009+87'
                                                                            },
                                        'event name,single quoted name' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'event_name',
                                                                             'length' => 20,
                                                                             'lhs' => 'event name',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'event name',
                                                                             'rhs' => [
                                                                                        'single quoted name'
                                                                                      ],
                                                                             'start' => 4048,
                                                                             'subkey' => 2,
                                                                             'xrlid' => 'event name@4009+87'
                                                                           },
                                        'event name,standard name' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'event_name',
                                                                        'length' => 87,
                                                                        'lhs' => 'event name',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'event name',
                                                                        'rhs' => [
                                                                                   'standard name'
                                                                                 ],
                                                                        'start' => 4009,
                                                                        'subkey' => 1,
                                                                        'xrlid' => 'event name@4009+87'
                                                                      },
                                        'event specification,[Lex-63],[Lex-64],event initialization' => {
                                                                                                          'action' => '[start,length,values]',
                                                                                                          'bless' => 'event_specification',
                                                                                                          'length' => 63,
                                                                                                          'lhs' => 'event specification',
                                                                                                          'mask' => [
                                                                                                                      0,
                                                                                                                      0,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'name' => 'event specification',
                                                                                                          'rhs' => [
                                                                                                                     '[Lex-63]',
                                                                                                                     '[Lex-64]',
                                                                                                                     'event initialization'
                                                                                                                   ],
                                                                                                          'start' => 3625,
                                                                                                          'subkey' => 1,
                                                                                                          'xrlid' => 'event specification@3625+63'
                                                                                                        },
                                        'group association,[Lex-41],[Lex-42],[Lex-43]' => {
                                                                                            'action' => '[start,length,values]',
                                                                                            'bless' => 'group_association',
                                                                                            'length' => 46,
                                                                                            'lhs' => 'group association',
                                                                                            'mask' => [
                                                                                                        0,
                                                                                                        0,
                                                                                                        0
                                                                                                      ],
                                                                                            'name' => 'group association',
                                                                                            'rhs' => [
                                                                                                       '[Lex-41]',
                                                                                                       '[Lex-42]',
                                                                                                       '[Lex-43]'
                                                                                                     ],
                                                                                            'start' => 3033,
                                                                                            'subkey' => 1,
                                                                                            'xrlid' => 'group association@3033+46'
                                                                                          },
                                        'inaccessible statement,[Lex-25],[Lex-26],inaccessible treatment,[Lex-27],[Lex-28]' => {
                                                                                                                                 'action' => '[start,length,values]',
                                                                                                                                 'bless' => 'inaccessible_statement',
                                                                                                                                 'length' => 92,
                                                                                                                                 'lhs' => 'inaccessible statement',
                                                                                                                                 'mask' => [
                                                                                                                                             0,
                                                                                                                                             0,
                                                                                                                                             1,
                                                                                                                                             0,
                                                                                                                                             0
                                                                                                                                           ],
                                                                                                                                 'name' => 'inaccessible statement',
                                                                                                                                 'rhs' => [
                                                                                                                                            '[Lex-25]',
                                                                                                                                            '[Lex-26]',
                                                                                                                                            'inaccessible treatment',
                                                                                                                                            '[Lex-27]',
                                                                                                                                            '[Lex-28]'
                                                                                                                                          ],
                                                                                                                                 'start' => 2044,
                                                                                                                                 'subkey' => 1,
                                                                                                                                 'xrlid' => 'inaccessible statement@2044+92'
                                                                                                                               },
                                        'inaccessible treatment,[Lex-29]' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'inaccessible_treatment',
                                                                               'length' => 52,
                                                                               'lhs' => 'inaccessible treatment',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'inaccessible treatment',
                                                                               'rhs' => [
                                                                                          '[Lex-29]'
                                                                                        ],
                                                                               'start' => 2137,
                                                                               'subkey' => 1,
                                                                               'xrlid' => 'inaccessible treatment@2137+52'
                                                                             },
                                        'inaccessible treatment,[Lex-30]' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'inaccessible_treatment',
                                                                               'length' => 4,
                                                                               'lhs' => 'inaccessible treatment',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'inaccessible treatment',
                                                                               'rhs' => [
                                                                                          '[Lex-30]'
                                                                                        ],
                                                                               'start' => 2175,
                                                                               'subkey' => 2,
                                                                               'xrlid' => 'inaccessible treatment@2137+52'
                                                                             },
                                        'inaccessible treatment,[Lex-31]' => {
                                                                               'action' => '[start,length,values]',
                                                                               'bless' => 'inaccessible_treatment',
                                                                               'length' => 7,
                                                                               'lhs' => 'inaccessible treatment',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'inaccessible treatment',
                                                                               'rhs' => [
                                                                                          '[Lex-31]'
                                                                                        ],
                                                                               'start' => 2182,
                                                                               'subkey' => 3,
                                                                               'xrlid' => 'inaccessible treatment@2137+52'
                                                                             },
                                        'left association,[Lex-35],[Lex-36],[Lex-37]' => {
                                                                                           'action' => '[start,length,values]',
                                                                                           'bless' => 'left_association',
                                                                                           'length' => 44,
                                                                                           'lhs' => 'left association',
                                                                                           'mask' => [
                                                                                                       0,
                                                                                                       0,
                                                                                                       0
                                                                                                     ],
                                                                                           'name' => 'left association',
                                                                                           'rhs' => [
                                                                                                      '[Lex-35]',
                                                                                                      '[Lex-36]',
                                                                                                      '[Lex-37]'
                                                                                                    ],
                                                                                           'start' => 2941,
                                                                                           'subkey' => 1,
                                                                                           'xrlid' => 'left association@2941+44'
                                                                                         },
                                        'lexeme default statement,[Lex-8],[Lex-9],[Lex-10],adverb list' => {
                                                                                                             'action' => '[start,length,values]',
                                                                                                             'bless' => 'lexeme_default_statement',
                                                                                                             'length' => 69,
                                                                                                             'lhs' => 'lexeme default statement',
                                                                                                             'mask' => [
                                                                                                                         0,
                                                                                                                         0,
                                                                                                                         0,
                                                                                                                         1
                                                                                                                       ],
                                                                                                             'name' => 'lexeme default statement',
                                                                                                             'rhs' => [
                                                                                                                        '[Lex-8]',
                                                                                                                        '[Lex-9]',
                                                                                                                        '[Lex-10]',
                                                                                                                        'adverb list'
                                                                                                                      ],
                                                                                                             'start' => 1281,
                                                                                                             'subkey' => 1,
                                                                                                             'xrlid' => 'lexeme default statement@1281+69'
                                                                                                           },
                                        'lexeme rule,[Lex-15],op declare match,symbol,adverb list' => {
                                                                                                        'action' => '[start,length,values]',
                                                                                                        'bless' => 'lexeme_rule',
                                                                                                        'length' => 69,
                                                                                                        'lhs' => 'lexeme rule',
                                                                                                        'mask' => [
                                                                                                                    0,
                                                                                                                    0,
                                                                                                                    1,
                                                                                                                    1
                                                                                                                  ],
                                                                                                        'name' => 'lexeme rule',
                                                                                                        'rhs' => [
                                                                                                                   '[Lex-15]',
                                                                                                                   'op declare match',
                                                                                                                   'symbol',
                                                                                                                   'adverb list'
                                                                                                                 ],
                                                                                                        'start' => 1680,
                                                                                                        'subkey' => 1,
                                                                                                        'xrlid' => 'lexeme rule@1680+69'
                                                                                                      },
                                        'lhs,symbol name' => {
                                                               'action' => '[start,length,values]',
                                                               'bless' => 'lhs',
                                                               'length' => 21,
                                                               'lhs' => 'lhs',
                                                               'mask' => [
                                                                           1
                                                                         ],
                                                               'name' => 'lhs',
                                                               'rhs' => [
                                                                          'symbol name'
                                                                        ],
                                                               'start' => 4214,
                                                               'subkey' => 1,
                                                               'xrlid' => 'lhs@4214+21'
                                                             },
                                        'naming,[Lex-70],[Lex-71],alternative name' => {
                                                                                         'action' => '[start,length,values]',
                                                                                         'bless' => 'naming',
                                                                                         'length' => 45,
                                                                                         'lhs' => 'naming',
                                                                                         'mask' => [
                                                                                                     0,
                                                                                                     0,
                                                                                                     1
                                                                                                   ],
                                                                                         'name' => 'naming',
                                                                                         'rhs' => [
                                                                                                    '[Lex-70]',
                                                                                                    '[Lex-71]',
                                                                                                    'alternative name'
                                                                                                  ],
                                                                                         'start' => 3899,
                                                                                         'subkey' => 1,
                                                                                         'xrlid' => 'naming@3899+45'
                                                                                       },
                                        'null adverb,[Lex-32]' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'null_adverb',
                                                                    'length' => 21,
                                                                    'lhs' => 'null adverb',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'null adverb',
                                                                    'rhs' => [
                                                                               '[Lex-32]'
                                                                             ],
                                                                    'start' => 2878,
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'null adverb@2878+21'
                                                                  },
                                        'null ranking constant,[Lex-57]' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'null_ranking_constant',
                                                                              'length' => 42,
                                                                              'lhs' => 'null ranking constant',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'null ranking constant',
                                                                              'rhs' => [
                                                                                         '[Lex-57]'
                                                                                       ],
                                                                              'start' => 3458,
                                                                              'subkey' => 1,
                                                                              'xrlid' => 'null ranking constant@3458+42'
                                                                            },
                                        'null ranking constant,[Lex-58]' => {
                                                                              'action' => '[start,length,values]',
                                                                              'bless' => 'null_ranking_constant',
                                                                              'length' => 6,
                                                                              'lhs' => 'null ranking constant',
                                                                              'mask' => [
                                                                                          1
                                                                                        ],
                                                                              'name' => 'null ranking constant',
                                                                              'rhs' => [
                                                                                         '[Lex-58]'
                                                                                       ],
                                                                              'start' => 3494,
                                                                              'subkey' => 2,
                                                                              'xrlid' => 'null ranking constant@3458+42'
                                                                            },
                                        'null ranking specification,[Lex-52],[Lex-53],null ranking constant' => {
                                                                                                                  'action' => '[start,length,values]',
                                                                                                                  'bless' => 'null_ranking_specification',
                                                                                                                  'length' => 78,
                                                                                                                  'lhs' => 'null ranking specification',
                                                                                                                  'mask' => [
                                                                                                                              0,
                                                                                                                              0,
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'null ranking specification',
                                                                                                                  'rhs' => [
                                                                                                                             '[Lex-52]',
                                                                                                                             '[Lex-53]',
                                                                                                                             'null ranking constant'
                                                                                                                           ],
                                                                                                                  'start' => 3301,
                                                                                                                  'subkey' => 1,
                                                                                                                  'xrlid' => 'null ranking specification@3301+78'
                                                                                                                },
                                        'null ranking specification,[Lex-54],[Lex-55],[Lex-56],null ranking constant' => {
                                                                                                                           'action' => '[start,length,values]',
                                                                                                                           'bless' => 'null_ranking_specification',
                                                                                                                           'length' => 77,
                                                                                                                           'lhs' => 'null ranking specification',
                                                                                                                           'mask' => [
                                                                                                                                       0,
                                                                                                                                       0,
                                                                                                                                       0,
                                                                                                                                       1
                                                                                                                                     ],
                                                                                                                           'name' => 'null ranking specification',
                                                                                                                           'rhs' => [
                                                                                                                                      '[Lex-54]',
                                                                                                                                      '[Lex-55]',
                                                                                                                                      '[Lex-56]',
                                                                                                                                      'null ranking constant'
                                                                                                                                    ],
                                                                                                                           'start' => 3380,
                                                                                                                           'subkey' => 1,
                                                                                                                           'xrlid' => 'null ranking specification@3380+77'
                                                                                                                         },
                                        'null statement,[Lex-0]' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'null_statement',
                                                                      'length' => 24,
                                                                      'lhs' => 'null statement',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'null statement',
                                                                      'rhs' => [
                                                                                 '[Lex-0]'
                                                                               ],
                                                                      'start' => 1052,
                                                                      'subkey' => 1,
                                                                      'xrlid' => 'null statement@1052+24'
                                                                    },
                                        'nulled event declaration,[Lex-19],event initialization,[Lex-20],[Lex-21],symbol name' => {
                                                                                                                                    'action' => '[start,length,values]',
                                                                                                                                    'bless' => 'nulled_event_declaration',
                                                                                                                                    'length' => 92,
                                                                                                                                    'lhs' => 'nulled event declaration',
                                                                                                                                    'mask' => [
                                                                                                                                                0,
                                                                                                                                                1,
                                                                                                                                                0,
                                                                                                                                                0,
                                                                                                                                                1
                                                                                                                                              ],
                                                                                                                                    'name' => 'nulled event declaration',
                                                                                                                                    'rhs' => [
                                                                                                                                               '[Lex-19]',
                                                                                                                                               'event initialization',
                                                                                                                                               '[Lex-20]',
                                                                                                                                               '[Lex-21]',
                                                                                                                                               'symbol name'
                                                                                                                                             ],
                                                                                                                                    'start' => 1850,
                                                                                                                                    'subkey' => 1,
                                                                                                                                    'xrlid' => 'nulled event declaration@1850+92'
                                                                                                                                  },
                                        'on or off,[Lex-66]' => {
                                                                  'action' => '[start,length,values]',
                                                                  'bless' => 'on_or_off',
                                                                  'length' => 28,
                                                                  'lhs' => 'on or off',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'name' => 'on or off',
                                                                  'rhs' => [
                                                                             '[Lex-66]'
                                                                           ],
                                                                  'start' => 3791,
                                                                  'subkey' => 1,
                                                                  'xrlid' => 'on or off@3791+28'
                                                                },
                                        'on or off,[Lex-67]' => {
                                                                  'action' => '[start,length,values]',
                                                                  'bless' => 'on_or_off',
                                                                  'length' => 5,
                                                                  'lhs' => 'on or off',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'name' => 'on or off',
                                                                  'rhs' => [
                                                                             '[Lex-67]'
                                                                           ],
                                                                  'start' => 3814,
                                                                  'subkey' => 2,
                                                                  'xrlid' => 'on or off@3791+28'
                                                                },
                                        'op declare,op declare bnf' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'op_declare',
                                                                         'length' => 54,
                                                                         'lhs' => 'op declare',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'op declare',
                                                                         'rhs' => [
                                                                                    'op declare bnf'
                                                                                  ],
                                                                         'start' => 2191,
                                                                         'subkey' => 1,
                                                                         'xrlid' => 'op declare@2191+54'
                                                                       },
                                        'op declare,op declare match' => {
                                                                           'action' => '[start,length,values]',
                                                                           'bless' => 'op_declare',
                                                                           'length' => 18,
                                                                           'lhs' => 'op declare',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'op declare',
                                                                           'rhs' => [
                                                                                      'op declare match'
                                                                                    ],
                                                                           'start' => 2227,
                                                                           'subkey' => 2,
                                                                           'xrlid' => 'op declare@2191+54'
                                                                         },
                                        'parenthesized rhs primary list,[Lex-72],rhs primary list,[Lex-73]' => {
                                                                                                                 'action' => '[start,length,values]',
                                                                                                                 'bless' => 'parenthesized_rhs_primary_list',
                                                                                                                 'length' => 67,
                                                                                                                 'lhs' => 'parenthesized rhs primary list',
                                                                                                                 'mask' => [
                                                                                                                             0,
                                                                                                                             1,
                                                                                                                             0
                                                                                                                           ],
                                                                                                                 'name' => 'parenthesized rhs primary list',
                                                                                                                 'rhs' => [
                                                                                                                            '[Lex-72]',
                                                                                                                            'rhs primary list',
                                                                                                                            '[Lex-73]'
                                                                                                                          ],
                                                                                                                 'start' => 4385,
                                                                                                                 'subkey' => 1,
                                                                                                                 'xrlid' => 'parenthesized rhs primary list@4385+67'
                                                                                                               },
                                        'pause specification,[Lex-61],[Lex-62],before or after' => {
                                                                                                     'action' => '[start,length,values]',
                                                                                                     'bless' => 'pause_specification',
                                                                                                     'length' => 58,
                                                                                                     'lhs' => 'pause specification',
                                                                                                     'mask' => [
                                                                                                                 0,
                                                                                                                 0,
                                                                                                                 1
                                                                                                               ],
                                                                                                     'name' => 'pause specification',
                                                                                                     'rhs' => [
                                                                                                                '[Lex-61]',
                                                                                                                '[Lex-62]',
                                                                                                                'before or after'
                                                                                                              ],
                                                                                                     'start' => 3565,
                                                                                                     'subkey' => 1,
                                                                                                     'xrlid' => 'pause specification@3565+58'
                                                                                                   },
                                        'prediction event declaration,[Lex-22],event initialization,[Lex-23],[Lex-24],symbol name' => {
                                                                                                                                        'action' => '[start,length,values]',
                                                                                                                                        'bless' => 'prediction_event_declaration',
                                                                                                                                        'length' => 99,
                                                                                                                                        'lhs' => 'prediction event declaration',
                                                                                                                                        'mask' => [
                                                                                                                                                    0,
                                                                                                                                                    1,
                                                                                                                                                    0,
                                                                                                                                                    0,
                                                                                                                                                    1
                                                                                                                                                  ],
                                                                                                                                        'name' => 'prediction event declaration',
                                                                                                                                        'rhs' => [
                                                                                                                                                   '[Lex-22]',
                                                                                                                                                   'event initialization',
                                                                                                                                                   '[Lex-23]',
                                                                                                                                                   '[Lex-24]',
                                                                                                                                                   'symbol name'
                                                                                                                                                 ],
                                                                                                                                        'start' => 1943,
                                                                                                                                        'subkey' => 1,
                                                                                                                                        'xrlid' => 'prediction event declaration@1943+99'
                                                                                                                                      },
                                        'priorities,alternatives' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'priorities',
                                                                       'length' => 69,
                                                                       'lhs' => 'priorities',
                                                                       'min' => 1,
                                                                       'name' => 'priorities',
                                                                       'proper' => '1',
                                                                       'rhs' => [
                                                                                  'alternatives'
                                                                                ],
                                                                       'separator' => 'op loosen',
                                                                       'start' => 2246,
                                                                       'subkey' => 0,
                                                                       'xrlid' => 'priorities@2246+69'
                                                                     },
                                        'priority rule,lhs,op declare,priorities' => {
                                                                                       'action' => '[start,length,values]',
                                                                                       'bless' => 'priority_rule',
                                                                                       'length' => 47,
                                                                                       'lhs' => 'priority rule',
                                                                                       'mask' => [
                                                                                                   1,
                                                                                                   1,
                                                                                                   1
                                                                                                 ],
                                                                                       'name' => 'priority rule',
                                                                                       'rhs' => [
                                                                                                  'lhs',
                                                                                                  'op declare',
                                                                                                  'priorities'
                                                                                                ],
                                                                                       'start' => 1423,
                                                                                       'subkey' => 1,
                                                                                       'xrlid' => 'priority rule@1423+47'
                                                                                     },
                                        'priority specification,[Lex-59],[Lex-60],signed integer' => {
                                                                                                       'action' => '[start,length,values]',
                                                                                                       'bless' => 'priority_specification',
                                                                                                       'length' => 63,
                                                                                                       'lhs' => 'priority specification',
                                                                                                       'mask' => [
                                                                                                                   0,
                                                                                                                   0,
                                                                                                                   1
                                                                                                                 ],
                                                                                                       'name' => 'priority specification',
                                                                                                       'rhs' => [
                                                                                                                  '[Lex-59]',
                                                                                                                  '[Lex-60]',
                                                                                                                  'signed integer'
                                                                                                                ],
                                                                                                       'start' => 3501,
                                                                                                       'subkey' => 1,
                                                                                                       'xrlid' => 'priority specification@3501+63'
                                                                                                     },
                                        'proper specification,[Lex-46],[Lex-47],boolean' => {
                                                                                              'action' => '[start,length,values]',
                                                                                              'bless' => 'proper_specification',
                                                                                              'length' => 50,
                                                                                              'lhs' => 'proper specification',
                                                                                              'mask' => [
                                                                                                          0,
                                                                                                          0,
                                                                                                          1
                                                                                                        ],
                                                                                              'name' => 'proper specification',
                                                                                              'rhs' => [
                                                                                                         '[Lex-46]',
                                                                                                         '[Lex-47]',
                                                                                                         'boolean'
                                                                                                       ],
                                                                                              'start' => 3145,
                                                                                              'subkey' => 1,
                                                                                              'xrlid' => 'proper specification@3145+50'
                                                                                            },
                                        'quantified rule,lhs,op declare,single symbol,quantifier,adverb list' => {
                                                                                                                   'action' => '[start,length,values]',
                                                                                                                   'bless' => 'quantified_rule',
                                                                                                                   'length' => 79,
                                                                                                                   'lhs' => 'quantified rule',
                                                                                                                   'mask' => [
                                                                                                                               1,
                                                                                                                               1,
                                                                                                                               1,
                                                                                                                               1,
                                                                                                                               1
                                                                                                                             ],
                                                                                                                   'name' => 'quantified rule',
                                                                                                                   'rhs' => [
                                                                                                                              'lhs',
                                                                                                                              'op declare',
                                                                                                                              'single symbol',
                                                                                                                              'quantifier',
                                                                                                                              'adverb list'
                                                                                                                            ],
                                                                                                                   'start' => 1519,
                                                                                                                   'subkey' => 1,
                                                                                                                   'xrlid' => 'quantified rule@1519+79'
                                                                                                                 },
                                        'quantifier,[Lex-74]' => {
                                                                   'action' => '[start,length,values]',
                                                                   'bless' => 'quantifier',
                                                                   'length' => 24,
                                                                   'lhs' => 'quantifier',
                                                                   'mask' => [
                                                                               1
                                                                             ],
                                                                   'name' => 'quantifier',
                                                                   'rhs' => [
                                                                              '[Lex-74]'
                                                                            ],
                                                                   'start' => 5308,
                                                                   'subkey' => 1,
                                                                   'xrlid' => 'quantifier@5308+24'
                                                                 },
                                        'quantifier,[Lex-75]' => {
                                                                   'action' => '[start,length,values]',
                                                                   'bless' => 'quantifier',
                                                                   'length' => 3,
                                                                   'lhs' => 'quantifier',
                                                                   'mask' => [
                                                                               1
                                                                             ],
                                                                   'name' => 'quantifier',
                                                                   'rhs' => [
                                                                              '[Lex-75]'
                                                                            ],
                                                                   'start' => 5329,
                                                                   'subkey' => 2,
                                                                   'xrlid' => 'quantifier@5308+24'
                                                                 },
                                        'rank specification,[Lex-50],[Lex-51],signed integer' => {
                                                                                                   'action' => '[start,length,values]',
                                                                                                   'bless' => 'rank_specification',
                                                                                                   'length' => 55,
                                                                                                   'lhs' => 'rank specification',
                                                                                                   'mask' => [
                                                                                                               0,
                                                                                                               0,
                                                                                                               1
                                                                                                             ],
                                                                                                   'name' => 'rank specification',
                                                                                                   'rhs' => [
                                                                                                              '[Lex-50]',
                                                                                                              '[Lex-51]',
                                                                                                              'signed integer'
                                                                                                            ],
                                                                                                   'start' => 3245,
                                                                                                   'subkey' => 1,
                                                                                                   'xrlid' => 'rank specification@3245+55'
                                                                                                 },
                                        'rhs primary list,rhs primary' => {
                                                                            'action' => '[start,length,values]',
                                                                            'bless' => 'rhs_primary_list',
                                                                            'length' => 37,
                                                                            'lhs' => 'rhs primary list',
                                                                            'min' => 1,
                                                                            'name' => 'rhs primary list',
                                                                            'rhs' => [
                                                                                       'rhs primary'
                                                                                     ],
                                                                            'start' => 4453,
                                                                            'subkey' => 0,
                                                                            'xrlid' => 'rhs primary list@4453+37'
                                                                          },
                                        'rhs primary,parenthesized rhs primary list' => {
                                                                                          'action' => '[start,length,values]',
                                                                                          'bless' => 'rhs_primary',
                                                                                          'length' => 50,
                                                                                          'lhs' => 'rhs primary',
                                                                                          'mask' => [
                                                                                                      1
                                                                                                    ],
                                                                                          'name' => 'rhs primary',
                                                                                          'rhs' => [
                                                                                                     'parenthesized rhs primary list'
                                                                                                   ],
                                                                                          'start' => 4334,
                                                                                          'subkey' => 1,
                                                                                          'xrlid' => 'rhs primary@4334+50'
                                                                                        },
                                        'rhs primary,single quoted string' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'rhs_primary',
                                                                                'length' => 40,
                                                                                'lhs' => 'rhs primary',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'rhs primary',
                                                                                'rhs' => [
                                                                                           'single quoted string'
                                                                                         ],
                                                                                'start' => 4293,
                                                                                'subkey' => 1,
                                                                                'xrlid' => 'rhs primary@4293+40'
                                                                              },
                                        'rhs primary,single symbol' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'rhs_primary',
                                                                         'length' => 33,
                                                                         'lhs' => 'rhs primary',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'rhs primary',
                                                                         'rhs' => [
                                                                                    'single symbol'
                                                                                  ],
                                                                         'start' => 4259,
                                                                         'subkey' => 1,
                                                                         'xrlid' => 'rhs primary@4259+33'
                                                                       },
                                        'rhs,rhs primary' => {
                                                               'action' => '[start,length,values]',
                                                               'bless' => 'rhs',
                                                               'length' => 22,
                                                               'lhs' => 'rhs',
                                                               'min' => 1,
                                                               'name' => 'rhs',
                                                               'rhs' => [
                                                                          'rhs primary'
                                                                        ],
                                                               'start' => 4236,
                                                               'subkey' => 0,
                                                               'xrlid' => 'rhs@4236+22'
                                                             },
                                        'right association,[Lex-38],[Lex-39],[Lex-40]' => {
                                                                                            'action' => '[start,length,values]',
                                                                                            'bless' => 'right_association',
                                                                                            'length' => 46,
                                                                                            'lhs' => 'right association',
                                                                                            'mask' => [
                                                                                                        0,
                                                                                                        0,
                                                                                                        0
                                                                                                      ],
                                                                                            'name' => 'right association',
                                                                                            'rhs' => [
                                                                                                       '[Lex-38]',
                                                                                                       '[Lex-39]',
                                                                                                       '[Lex-40]'
                                                                                                     ],
                                                                                            'start' => 2986,
                                                                                            'subkey' => 1,
                                                                                            'xrlid' => 'right association@2986+46'
                                                                                          },
                                        'separator specification,[Lex-44],[Lex-45],single symbol' => {
                                                                                                       'action' => '[start,length,values]',
                                                                                                       'bless' => 'separator_specification',
                                                                                                       'length' => 64,
                                                                                                       'lhs' => 'separator specification',
                                                                                                       'mask' => [
                                                                                                                   0,
                                                                                                                   0,
                                                                                                                   1
                                                                                                                 ],
                                                                                                       'name' => 'separator specification',
                                                                                                       'rhs' => [
                                                                                                                  '[Lex-44]',
                                                                                                                  '[Lex-45]',
                                                                                                                  'single symbol'
                                                                                                                ],
                                                                                                       'start' => 3080,
                                                                                                       'subkey' => 1,
                                                                                                       'xrlid' => 'separator specification@3080+64'
                                                                                                     },
                                        'single symbol,character class' => {
                                                                             'action' => '[start,length,values]',
                                                                             'bless' => 'single_symbol',
                                                                             'length' => 17,
                                                                             'lhs' => 'single symbol',
                                                                             'mask' => [
                                                                                         1
                                                                                       ],
                                                                             'name' => 'single symbol',
                                                                             'rhs' => [
                                                                                        'character class'
                                                                                      ],
                                                                             'start' => 4526,
                                                                             'subkey' => 2,
                                                                             'xrlid' => 'single symbol@4491+52'
                                                                           },
                                        'single symbol,symbol' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'single_symbol',
                                                                    'length' => 52,
                                                                    'lhs' => 'single symbol',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'single symbol',
                                                                    'rhs' => [
                                                                               'symbol'
                                                                             ],
                                                                    'start' => 4491,
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'single symbol@4491+52'
                                                                  },
                                        'start rule,[Lex-3],op declare bnf,symbol' => {
                                                                                        'action' => '[start,length,values]',
                                                                                        'bless' => 'start_rule',
                                                                                        'length' => 51,
                                                                                        'lhs' => 'start rule',
                                                                                        'mask' => [
                                                                                                    0,
                                                                                                    0,
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'start rule',
                                                                                        'rhs' => [
                                                                                                   '[Lex-3]',
                                                                                                   'op declare bnf',
                                                                                                   'symbol'
                                                                                                 ],
                                                                                        'start' => 1120,
                                                                                        'subkey' => 1,
                                                                                        'xrlid' => 'start rule@1120+51'
                                                                                      },
                                        'start rule,[Lex-4],[Lex-5],[Lex-6],symbol' => {
                                                                                         'action' => '[start,length,values]',
                                                                                         'bless' => 'start_rule',
                                                                                         'length' => 47,
                                                                                         'lhs' => 'start rule',
                                                                                         'mask' => [
                                                                                                     0,
                                                                                                     0,
                                                                                                     0,
                                                                                                     1
                                                                                                   ],
                                                                                         'name' => 'start rule',
                                                                                         'rhs' => [
                                                                                                    '[Lex-4]',
                                                                                                    '[Lex-5]',
                                                                                                    '[Lex-6]',
                                                                                                    'symbol'
                                                                                                  ],
                                                                                         'start' => 1172,
                                                                                         'subkey' => 1,
                                                                                         'xrlid' => 'start rule@1172+47'
                                                                                       },
                                        'statement group,[Lex-1],statements,[Lex-2]' => {
                                                                                          'action' => '[start,length,values]',
                                                                                          'bless' => 'statement_group',
                                                                                          'length' => 42,
                                                                                          'lhs' => 'statement group',
                                                                                          'mask' => [
                                                                                                      0,
                                                                                                      1,
                                                                                                      1
                                                                                                    ],
                                                                                          'name' => 'statement group',
                                                                                          'rhs' => [
                                                                                                     '[Lex-1]',
                                                                                                     'statements',
                                                                                                     '[Lex-2]'
                                                                                                   ],
                                                                                          'start' => 1077,
                                                                                          'subkey' => 1,
                                                                                          'xrlid' => 'statement group@1077+42'
                                                                                        },
                                        'statement,completion event declaration' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'statement',
                                                                                      'length' => 30,
                                                                                      'lhs' => 'statement',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'statement',
                                                                                      'rhs' => [
                                                                                                 'completion event declaration'
                                                                                               ],
                                                                                      'start' => 925,
                                                                                      'subkey' => 12,
                                                                                      'xrlid' => 'statement@681+369'
                                                                                    },
                                        'statement,default rule' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'statement',
                                                                      'length' => 14,
                                                                      'lhs' => 'statement',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'statement',
                                                                      'rhs' => [
                                                                                 'default rule'
                                                                               ],
                                                                      'start' => 825,
                                                                      'subkey' => 8,
                                                                      'xrlid' => 'statement@681+369'
                                                                    },
                                        'statement,discard default statement' => {
                                                                                   'action' => '[start,length,values]',
                                                                                   'bless' => 'statement',
                                                                                   'length' => 27,
                                                                                   'lhs' => 'statement',
                                                                                   'mask' => [
                                                                                               1
                                                                                             ],
                                                                                   'name' => 'statement',
                                                                                   'rhs' => [
                                                                                              'discard default statement'
                                                                                            ],
                                                                                   'start' => 875,
                                                                                   'subkey' => 10,
                                                                                   'xrlid' => 'statement@681+369'
                                                                                 },
                                        'statement,discard rule' => {
                                                                      'action' => '[start,length,values]',
                                                                      'bless' => 'statement',
                                                                      'length' => 14,
                                                                      'lhs' => 'statement',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'statement',
                                                                      'rhs' => [
                                                                                 'discard rule'
                                                                               ],
                                                                      'start' => 808,
                                                                      'subkey' => 7,
                                                                      'xrlid' => 'statement@681+369'
                                                                    },
                                        'statement,empty rule' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'statement',
                                                                    'length' => 12,
                                                                    'lhs' => 'statement',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'statement',
                                                                    'rhs' => [
                                                                               'empty rule'
                                                                             ],
                                                                    'start' => 710,
                                                                    'subkey' => 2,
                                                                    'xrlid' => 'statement@681+369'
                                                                  },
                                        'statement,inaccessible statement' => {
                                                                                'action' => '[start,length,values]',
                                                                                'bless' => 'statement',
                                                                                'length' => 24,
                                                                                'lhs' => 'statement',
                                                                                'mask' => [
                                                                                            1
                                                                                          ],
                                                                                'name' => 'statement',
                                                                                'rhs' => [
                                                                                           'inaccessible statement'
                                                                                         ],
                                                                                'start' => 1026,
                                                                                'subkey' => 15,
                                                                                'xrlid' => 'statement@681+369'
                                                                              },
                                        'statement,lexeme default statement' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'statement',
                                                                                  'length' => 26,
                                                                                  'lhs' => 'statement',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'statement',
                                                                                  'rhs' => [
                                                                                             'lexeme default statement'
                                                                                           ],
                                                                                  'start' => 844,
                                                                                  'subkey' => 9,
                                                                                  'xrlid' => 'statement@681+369'
                                                                                },
                                        'statement,lexeme rule' => {
                                                                     'action' => '[start,length,values]',
                                                                     'bless' => 'statement',
                                                                     'length' => 13,
                                                                     'lhs' => 'statement',
                                                                     'mask' => [
                                                                                 1
                                                                               ],
                                                                     'name' => 'statement',
                                                                     'rhs' => [
                                                                                'lexeme rule'
                                                                              ],
                                                                     'start' => 907,
                                                                     'subkey' => 11,
                                                                     'xrlid' => 'statement@681+369'
                                                                   },
                                        'statement,null statement' => {
                                                                        'action' => '[start,length,values]',
                                                                        'bless' => 'statement',
                                                                        'length' => 16,
                                                                        'lhs' => 'statement',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'statement',
                                                                        'rhs' => [
                                                                                   'null statement'
                                                                                 ],
                                                                        'start' => 727,
                                                                        'subkey' => 3,
                                                                        'xrlid' => 'statement@681+369'
                                                                      },
                                        'statement,nulled event declaration' => {
                                                                                  'action' => '[start,length,values]',
                                                                                  'bless' => 'statement',
                                                                                  'length' => 26,
                                                                                  'lhs' => 'statement',
                                                                                  'mask' => [
                                                                                              1
                                                                                            ],
                                                                                  'name' => 'statement',
                                                                                  'rhs' => [
                                                                                             'nulled event declaration'
                                                                                           ],
                                                                                  'start' => 960,
                                                                                  'subkey' => 13,
                                                                                  'xrlid' => 'statement@681+369'
                                                                                },
                                        'statement,prediction event declaration' => {
                                                                                      'action' => '[start,length,values]',
                                                                                      'bless' => 'statement',
                                                                                      'length' => 30,
                                                                                      'lhs' => 'statement',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'statement',
                                                                                      'rhs' => [
                                                                                                 'prediction event declaration'
                                                                                               ],
                                                                                      'start' => 991,
                                                                                      'subkey' => 14,
                                                                                      'xrlid' => 'statement@681+369'
                                                                                    },
                                        'statement,priority rule' => {
                                                                       'action' => '[start,length,values]',
                                                                       'bless' => 'statement',
                                                                       'length' => 15,
                                                                       'lhs' => 'statement',
                                                                       'mask' => [
                                                                                   1
                                                                                 ],
                                                                       'name' => 'statement',
                                                                       'rhs' => [
                                                                                  'priority rule'
                                                                                ],
                                                                       'start' => 768,
                                                                       'subkey' => 5,
                                                                       'xrlid' => 'statement@681+369'
                                                                     },
                                        'statement,quantified rule' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'statement',
                                                                         'length' => 17,
                                                                         'lhs' => 'statement',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'statement',
                                                                         'rhs' => [
                                                                                    'quantified rule'
                                                                                  ],
                                                                         'start' => 786,
                                                                         'subkey' => 6,
                                                                         'xrlid' => 'statement@681+369'
                                                                       },
                                        'statement,start rule' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'statement',
                                                                    'length' => 369,
                                                                    'lhs' => 'statement',
                                                                    'mask' => [
                                                                                1
                                                                              ],
                                                                    'name' => 'statement',
                                                                    'rhs' => [
                                                                               'start rule'
                                                                             ],
                                                                    'start' => 681,
                                                                    'subkey' => 1,
                                                                    'xrlid' => 'statement@681+369'
                                                                  },
                                        'statement,statement group' => {
                                                                         'action' => '[start,length,values]',
                                                                         'bless' => 'statement',
                                                                         'length' => 17,
                                                                         'lhs' => 'statement',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'statement',
                                                                         'rhs' => [
                                                                                    'statement group'
                                                                                  ],
                                                                         'start' => 746,
                                                                         'subkey' => 4,
                                                                         'xrlid' => 'statement@681+369'
                                                                       },
                                        'statements,statement' => {
                                                                    'action' => '[start,length,values]',
                                                                    'bless' => 'statements',
                                                                    'length' => 25,
                                                                    'lhs' => 'statements',
                                                                    'min' => 1,
                                                                    'name' => 'statements',
                                                                    'rhs' => [
                                                                               'statement'
                                                                             ],
                                                                    'start' => 655,
                                                                    'subkey' => 0,
                                                                    'xrlid' => 'statements@655+25'
                                                                  },
                                        'symbol name,bare name' => {
                                                                     'action' => '[start,length,values]',
                                                                     'bless' => 'symbol_name',
                                                                     'length' => 29,
                                                                     'lhs' => 'symbol name',
                                                                     'mask' => [
                                                                                 1
                                                                               ],
                                                                     'name' => 'symbol name',
                                                                     'rhs' => [
                                                                                'bare name'
                                                                              ],
                                                                     'start' => 4569,
                                                                     'subkey' => 1,
                                                                     'xrlid' => 'symbol name@4569+29'
                                                                   },
                                        'symbol name,bracketed name' => {
                                                                          'action' => '[start,length,values]',
                                                                          'bless' => 'symbol_name',
                                                                          'length' => 34,
                                                                          'lhs' => 'symbol name',
                                                                          'mask' => [
                                                                                      1
                                                                                    ],
                                                                          'name' => 'symbol name',
                                                                          'rhs' => [
                                                                                     'bracketed name'
                                                                                   ],
                                                                          'start' => 4599,
                                                                          'subkey' => 1,
                                                                          'xrlid' => 'symbol name@4599+34'
                                                                        },
                                        'symbol,symbol name' => {
                                                                  'action' => '[start,length,values]',
                                                                  'bless' => 'symbol',
                                                                  'length' => 24,
                                                                  'lhs' => 'symbol',
                                                                  'mask' => [
                                                                              1
                                                                            ],
                                                                  'name' => 'symbol',
                                                                  'rhs' => [
                                                                             'symbol name'
                                                                           ],
                                                                  'start' => 4544,
                                                                  'subkey' => 1,
                                                                  'xrlid' => 'symbol@4544+24'
                                                                }
                                      },
                              'L0' => {
                                        'Perl identifier,[[\\w]]' => {
                                                                       'length' => 25,
                                                                       'lhs' => 'Perl identifier',
                                                                       'min' => 1,
                                                                       'name' => 'Perl identifier',
                                                                       'rhs' => [
                                                                                  '[[\\w]]'
                                                                                ],
                                                                       'start' => 5817,
                                                                       'subkey' => 0,
                                                                       'xrlid' => 'Perl identifier@5817+25'
                                                                     },
                                        'Perl name,Perl identifier' => {
                                                                         'length' => 72,
                                                                         'lhs' => 'Perl name',
                                                                         'min' => 1,
                                                                         'name' => 'Perl name',
                                                                         'proper' => '1',
                                                                         'rhs' => [
                                                                                    'Perl identifier'
                                                                                  ],
                                                                         'separator' => 'double colon',
                                                                         'start' => 5865,
                                                                         'subkey' => 0,
                                                                         'xrlid' => 'Perl name@5865+72'
                                                                       },
                                        '[:discard],hash comment' => {
                                                                       'length' => 25,
                                                                       'lhs' => '[:discard]',
                                                                       'rhs' => [
                                                                                  'hash comment'
                                                                                ],
                                                                       'start' => 4802,
                                                                       'subkey' => 0,
                                                                       'symbol_as_event' => 'hash comment'
                                                                     },
                                        '[:discard],whitespace' => {
                                                                     'length' => 21,
                                                                     'lhs' => '[:discard]',
                                                                     'rhs' => [
                                                                                'whitespace'
                                                                              ],
                                                                     'start' => 4743,
                                                                     'subkey' => 0,
                                                                     'symbol_as_event' => 'whitespace'
                                                                   },
                                        '[Lex-0],[[\\;]]' => {
                                                               'length' => 3,
                                                               'lhs' => '[Lex-0]',
                                                               'mask' => [
                                                                           1
                                                                         ],
                                                               'rhs' => [
                                                                          '[[\\;]]'
                                                                        ],
                                                               'start' => 1073,
                                                               'subkey' => 0
                                                             },
                                        '[Lex-10],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-10]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 1332,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-11],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]' => {
                                                                                                  'length' => 9,
                                                                                                  'lhs' => '[Lex-11]',
                                                                                                  'mask' => [
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1
                                                                                                            ],
                                                                                                  'rhs' => [
                                                                                                             '[[d]]',
                                                                                                             '[[i]]',
                                                                                                             '[[s]]',
                                                                                                             '[[c]]',
                                                                                                             '[[a]]',
                                                                                                             '[[r]]',
                                                                                                             '[[d]]'
                                                                                                           ],
                                                                                                  'start' => 1384,
                                                                                                  'subkey' => 0
                                                                                                },
                                        '[Lex-12],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                  'length' => 9,
                                                                                                  'lhs' => '[Lex-12]',
                                                                                                  'mask' => [
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1
                                                                                                            ],
                                                                                                  'rhs' => [
                                                                                                             '[[d]]',
                                                                                                             '[[e]]',
                                                                                                             '[[f]]',
                                                                                                             '[[a]]',
                                                                                                             '[[u]]',
                                                                                                             '[[l]]',
                                                                                                             '[[t]]'
                                                                                                           ],
                                                                                                  'start' => 1394,
                                                                                                  'subkey' => 0
                                                                                                },
                                        '[Lex-13],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-13]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 1404,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-14],[[\\:]],[[d]],[[i]],[[s]],[[c]],[[a]],[[r]],[[d]]' => {
                                                                                                          'length' => 10,
                                                                                                          'lhs' => '[Lex-14]',
                                                                                                          'mask' => [
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'rhs' => [
                                                                                                                     '[[\\:]]',
                                                                                                                     '[[d]]',
                                                                                                                     '[[i]]',
                                                                                                                     '[[s]]',
                                                                                                                     '[[c]]',
                                                                                                                     '[[a]]',
                                                                                                                     '[[r]]',
                                                                                                                     '[[d]]'
                                                                                                                   ],
                                                                                                          'start' => 1619,
                                                                                                          'subkey' => 0
                                                                                                        },
                                        '[Lex-15],[[\\:]],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]' => {
                                                                                                    'length' => 9,
                                                                                                    'lhs' => '[Lex-15]',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'rhs' => [
                                                                                                               '[[\\:]]',
                                                                                                               '[[l]]',
                                                                                                               '[[e]]',
                                                                                                               '[[x]]',
                                                                                                               '[[e]]',
                                                                                                               '[[m]]',
                                                                                                               '[[e]]'
                                                                                                             ],
                                                                                                    'start' => 1699,
                                                                                                    'subkey' => 0
                                                                                                  },
                                        '[Lex-16],[[e]],[[v]],[[e]],[[n]],[[t]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-16]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[e]]',
                                                                                                 '[[v]]',
                                                                                                 '[[e]]',
                                                                                                 '[[n]]',
                                                                                                 '[[t]]'
                                                                                               ],
                                                                                      'start' => 1786,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-17],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-17]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 1819,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-18],[[c]],[[o]],[[m]],[[p]],[[l]],[[e]],[[t]],[[e]],[[d]]' => {
                                                                                                              'length' => 11,
                                                                                                              'lhs' => '[Lex-18]',
                                                                                                              'mask' => [
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1
                                                                                                                        ],
                                                                                                              'rhs' => [
                                                                                                                         '[[c]]',
                                                                                                                         '[[o]]',
                                                                                                                         '[[m]]',
                                                                                                                         '[[p]]',
                                                                                                                         '[[l]]',
                                                                                                                         '[[e]]',
                                                                                                                         '[[t]]',
                                                                                                                         '[[e]]',
                                                                                                                         '[[d]]'
                                                                                                                       ],
                                                                                                              'start' => 1823,
                                                                                                              'subkey' => 0
                                                                                                            },
                                        '[Lex-19],[[e]],[[v]],[[e]],[[n]],[[t]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-19]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[e]]',
                                                                                                 '[[v]]',
                                                                                                 '[[e]]',
                                                                                                 '[[n]]',
                                                                                                 '[[t]]'
                                                                                               ],
                                                                                      'start' => 1882,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-1],[[\\{]]' => {
                                                               'length' => 3,
                                                               'lhs' => '[Lex-1]',
                                                               'mask' => [
                                                                           1
                                                                         ],
                                                               'rhs' => [
                                                                          '[[\\{]]'
                                                                        ],
                                                               'start' => 1100,
                                                               'subkey' => 0
                                                             },
                                        '[Lex-20],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-20]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 1915,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-21],[[n]],[[u]],[[l]],[[l]],[[e]],[[d]]' => {
                                                                                            'length' => 8,
                                                                                            'lhs' => '[Lex-21]',
                                                                                            'mask' => [
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1
                                                                                                      ],
                                                                                            'rhs' => [
                                                                                                       '[[n]]',
                                                                                                       '[[u]]',
                                                                                                       '[[l]]',
                                                                                                       '[[l]]',
                                                                                                       '[[e]]',
                                                                                                       '[[d]]'
                                                                                                     ],
                                                                                            'start' => 1919,
                                                                                            'subkey' => 0
                                                                                          },
                                        '[Lex-22],[[e]],[[v]],[[e]],[[n]],[[t]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-22]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[e]]',
                                                                                                 '[[v]]',
                                                                                                 '[[e]]',
                                                                                                 '[[n]]',
                                                                                                 '[[t]]'
                                                                                               ],
                                                                                      'start' => 1979,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-23],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-23]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 2012,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-24],[[p]],[[r]],[[e]],[[d]],[[i]],[[c]],[[t]],[[e]],[[d]]' => {
                                                                                                              'length' => 11,
                                                                                                              'lhs' => '[Lex-24]',
                                                                                                              'mask' => [
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1
                                                                                                                        ],
                                                                                                              'rhs' => [
                                                                                                                         '[[p]]',
                                                                                                                         '[[r]]',
                                                                                                                         '[[e]]',
                                                                                                                         '[[d]]',
                                                                                                                         '[[i]]',
                                                                                                                         '[[c]]',
                                                                                                                         '[[t]]',
                                                                                                                         '[[e]]',
                                                                                                                         '[[d]]'
                                                                                                                       ],
                                                                                                              'start' => 2016,
                                                                                                              'subkey' => 0
                                                                                                            },
                                        '[Lex-25],[[i]],[[n]],[[a]],[[c]],[[c]],[[e]],[[s]],[[s]],[[i]],[[b]],[[l]],[[e]]' => {
                                                                                                                                'length' => 14,
                                                                                                                                'lhs' => '[Lex-25]',
                                                                                                                                'mask' => [
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1,
                                                                                                                                            1
                                                                                                                                          ],
                                                                                                                                'rhs' => [
                                                                                                                                           '[[i]]',
                                                                                                                                           '[[n]]',
                                                                                                                                           '[[a]]',
                                                                                                                                           '[[c]]',
                                                                                                                                           '[[c]]',
                                                                                                                                           '[[e]]',
                                                                                                                                           '[[s]]',
                                                                                                                                           '[[s]]',
                                                                                                                                           '[[i]]',
                                                                                                                                           '[[b]]',
                                                                                                                                           '[[l]]',
                                                                                                                                           '[[e]]'
                                                                                                                                         ],
                                                                                                                                'start' => 2074,
                                                                                                                                'subkey' => 0
                                                                                                                              },
                                        '[Lex-26],[[i]],[[s]]' => {
                                                                    'length' => 4,
                                                                    'lhs' => '[Lex-26]',
                                                                    'mask' => [
                                                                                1,
                                                                                1
                                                                              ],
                                                                    'rhs' => [
                                                                               '[[i]]',
                                                                               '[[s]]'
                                                                             ],
                                                                    'start' => 2089,
                                                                    'subkey' => 0
                                                                  },
                                        '[Lex-27],[[b]],[[y]]' => {
                                                                    'length' => 4,
                                                                    'lhs' => '[Lex-27]',
                                                                    'mask' => [
                                                                                1,
                                                                                1
                                                                              ],
                                                                    'rhs' => [
                                                                               '[[b]]',
                                                                               '[[y]]'
                                                                             ],
                                                                    'start' => 2121,
                                                                    'subkey' => 0
                                                                  },
                                        '[Lex-28],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                  'length' => 9,
                                                                                                  'lhs' => '[Lex-28]',
                                                                                                  'mask' => [
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1,
                                                                                                              1
                                                                                                            ],
                                                                                                  'rhs' => [
                                                                                                             '[[d]]',
                                                                                                             '[[e]]',
                                                                                                             '[[f]]',
                                                                                                             '[[a]]',
                                                                                                             '[[u]]',
                                                                                                             '[[l]]',
                                                                                                             '[[t]]'
                                                                                                           ],
                                                                                                  'start' => 2126,
                                                                                                  'subkey' => 0
                                                                                                },
                                        '[Lex-29],[[w]],[[a]],[[r]],[[n]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-29]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[w]]',
                                                                                           '[[a]]',
                                                                                           '[[r]]',
                                                                                           '[[n]]'
                                                                                         ],
                                                                                'start' => 2166,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-2],[[\\}]]' => {
                                                               'length' => 3,
                                                               'lhs' => '[Lex-2]',
                                                               'mask' => [
                                                                           1
                                                                         ],
                                                               'rhs' => [
                                                                          '[[\\}]]'
                                                                        ],
                                                               'start' => 1116,
                                                               'subkey' => 0
                                                             },
                                        '[Lex-30],[[o]],[[k]]' => {
                                                                    'length' => 4,
                                                                    'lhs' => '[Lex-30]',
                                                                    'mask' => [
                                                                                1,
                                                                                1
                                                                              ],
                                                                    'rhs' => [
                                                                               '[[o]]',
                                                                               '[[k]]'
                                                                             ],
                                                                    'start' => 2175,
                                                                    'subkey' => 0
                                                                  },
                                        '[Lex-31],[[f]],[[a]],[[t]],[[a]],[[l]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-31]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[f]]',
                                                                                                 '[[a]]',
                                                                                                 '[[t]]',
                                                                                                 '[[a]]',
                                                                                                 '[[l]]'
                                                                                               ],
                                                                                      'start' => 2182,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-32],[[\\,]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-32]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\,]]'
                                                                         ],
                                                                'start' => 2896,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-33],[[a]],[[c]],[[t]],[[i]],[[o]],[[n]]' => {
                                                                                            'length' => 8,
                                                                                            'lhs' => '[Lex-33]',
                                                                                            'mask' => [
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1
                                                                                                      ],
                                                                                            'rhs' => [
                                                                                                       '[[a]]',
                                                                                                       '[[c]]',
                                                                                                       '[[t]]',
                                                                                                       '[[i]]',
                                                                                                       '[[o]]',
                                                                                                       '[[n]]'
                                                                                                     ],
                                                                                            'start' => 2912,
                                                                                            'subkey' => 0
                                                                                          },
                                        '[Lex-34],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-34]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 2921,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-35],[[a]],[[s]],[[s]],[[o]],[[c]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-35]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[a]]',
                                                                                                 '[[s]]',
                                                                                                 '[[s]]',
                                                                                                 '[[o]]',
                                                                                                 '[[c]]'
                                                                                               ],
                                                                                      'start' => 2965,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-36],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-36]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 2973,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-37],[[l]],[[e]],[[f]],[[t]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-37]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[l]]',
                                                                                           '[[e]]',
                                                                                           '[[f]]',
                                                                                           '[[t]]'
                                                                                         ],
                                                                                'start' => 2978,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-38],[[a]],[[s]],[[s]],[[o]],[[c]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-38]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[a]]',
                                                                                                 '[[s]]',
                                                                                                 '[[s]]',
                                                                                                 '[[o]]',
                                                                                                 '[[c]]'
                                                                                               ],
                                                                                      'start' => 3011,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-39],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-39]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3019,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-3],[[\\:]],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                             'length' => 8,
                                                                                             'lhs' => '[Lex-3]',
                                                                                             'mask' => [
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1
                                                                                                       ],
                                                                                             'rhs' => [
                                                                                                        '[[\\:]]',
                                                                                                        '[[s]]',
                                                                                                        '[[t]]',
                                                                                                        '[[a]]',
                                                                                                        '[[r]]',
                                                                                                        '[[t]]'
                                                                                                      ],
                                                                                             'start' => 1138,
                                                                                             'subkey' => 0
                                                                                           },
                                        '[Lex-40],[[r]],[[i]],[[g]],[[h]],[[t]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-40]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[r]]',
                                                                                                 '[[i]]',
                                                                                                 '[[g]]',
                                                                                                 '[[h]]',
                                                                                                 '[[t]]'
                                                                                               ],
                                                                                      'start' => 3024,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-41],[[a]],[[s]],[[s]],[[o]],[[c]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-41]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[a]]',
                                                                                                 '[[s]]',
                                                                                                 '[[s]]',
                                                                                                 '[[o]]',
                                                                                                 '[[c]]'
                                                                                               ],
                                                                                      'start' => 3058,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-42],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-42]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3066,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-43],[[g]],[[r]],[[o]],[[u]],[[p]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-43]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[g]]',
                                                                                                 '[[r]]',
                                                                                                 '[[o]]',
                                                                                                 '[[u]]',
                                                                                                 '[[p]]'
                                                                                               ],
                                                                                      'start' => 3071,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-44],[[s]],[[e]],[[p]],[[a]],[[r]],[[a]],[[t]],[[o]],[[r]]' => {
                                                                                                              'length' => 11,
                                                                                                              'lhs' => '[Lex-44]',
                                                                                                              'mask' => [
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1,
                                                                                                                          1
                                                                                                                        ],
                                                                                                              'rhs' => [
                                                                                                                         '[[s]]',
                                                                                                                         '[[e]]',
                                                                                                                         '[[p]]',
                                                                                                                         '[[a]]',
                                                                                                                         '[[r]]',
                                                                                                                         '[[a]]',
                                                                                                                         '[[t]]',
                                                                                                                         '[[o]]',
                                                                                                                         '[[r]]'
                                                                                                                       ],
                                                                                                              'start' => 3111,
                                                                                                              'subkey' => 0
                                                                                                            },
                                        '[Lex-45],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-45]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3123,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-46],[[p]],[[r]],[[o]],[[p]],[[e]],[[r]]' => {
                                                                                            'length' => 8,
                                                                                            'lhs' => '[Lex-46]',
                                                                                            'mask' => [
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1,
                                                                                                        1
                                                                                                      ],
                                                                                            'rhs' => [
                                                                                                       '[[p]]',
                                                                                                       '[[r]]',
                                                                                                       '[[o]]',
                                                                                                       '[[p]]',
                                                                                                       '[[e]]',
                                                                                                       '[[r]]'
                                                                                                     ],
                                                                                            'start' => 3173,
                                                                                            'subkey' => 0
                                                                                          },
                                        '[Lex-47],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-47]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3182,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-48],[[e]],[[a]],[[g]],[[e]],[[r]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-48]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[e]]',
                                                                                                 '[[a]]',
                                                                                                 '[[g]]',
                                                                                                 '[[e]]',
                                                                                                 '[[r]]'
                                                                                               ],
                                                                                      'start' => 3223,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-49],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-49]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3231,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-4],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                     'length' => 7,
                                                                                     'lhs' => '[Lex-4]',
                                                                                     'mask' => [
                                                                                                 1,
                                                                                                 1,
                                                                                                 1,
                                                                                                 1,
                                                                                                 1
                                                                                               ],
                                                                                     'rhs' => [
                                                                                                '[[s]]',
                                                                                                '[[t]]',
                                                                                                '[[a]]',
                                                                                                '[[r]]',
                                                                                                '[[t]]'
                                                                                              ],
                                                                                     'start' => 1190,
                                                                                     'subkey' => 0
                                                                                   },
                                        '[Lex-50],[[r]],[[a]],[[n]],[[k]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-50]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[r]]',
                                                                                           '[[a]]',
                                                                                           '[[n]]',
                                                                                           '[[k]]'
                                                                                         ],
                                                                                'start' => 3271,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-51],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-51]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3278,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-52],[[n]],[[u]],[[l]],[[l]],[[\\-]],[[r]],[[a]],[[n]],[[k]],[[i]],[[n]],[[g]]' => {
                                                                                                                                  'length' => 14,
                                                                                                                                  'lhs' => '[Lex-52]',
                                                                                                                                  'mask' => [
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1,
                                                                                                                                              1
                                                                                                                                            ],
                                                                                                                                  'rhs' => [
                                                                                                                                             '[[n]]',
                                                                                                                                             '[[u]]',
                                                                                                                                             '[[l]]',
                                                                                                                                             '[[l]]',
                                                                                                                                             '[[\\-]]',
                                                                                                                                             '[[r]]',
                                                                                                                                             '[[a]]',
                                                                                                                                             '[[n]]',
                                                                                                                                             '[[k]]',
                                                                                                                                             '[[i]]',
                                                                                                                                             '[[n]]',
                                                                                                                                             '[[g]]'
                                                                                                                                           ],
                                                                                                                                  'start' => 3335,
                                                                                                                                  'subkey' => 0
                                                                                                                                },
                                        '[Lex-53],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-53]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3350,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-54],[[n]],[[u]],[[l]],[[l]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-54]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[n]]',
                                                                                           '[[u]]',
                                                                                           '[[l]]',
                                                                                           '[[l]]'
                                                                                         ],
                                                                                'start' => 3414,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-55],[[r]],[[a]],[[n]],[[k]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-55]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[r]]',
                                                                                           '[[a]]',
                                                                                           '[[n]]',
                                                                                           '[[k]]'
                                                                                         ],
                                                                                'start' => 3421,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-56],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-56]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3428,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-57],[[l]],[[o]],[[w]]' => {
                                                                          'length' => 5,
                                                                          'lhs' => '[Lex-57]',
                                                                          'mask' => [
                                                                                      1,
                                                                                      1,
                                                                                      1
                                                                                    ],
                                                                          'rhs' => [
                                                                                     '[[l]]',
                                                                                     '[[o]]',
                                                                                     '[[w]]'
                                                                                   ],
                                                                          'start' => 3486,
                                                                          'subkey' => 0
                                                                        },
                                        '[Lex-58],[[h]],[[i]],[[g]],[[h]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-58]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[h]]',
                                                                                           '[[i]]',
                                                                                           '[[g]]',
                                                                                           '[[h]]'
                                                                                         ],
                                                                                'start' => 3494,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-59],[[p]],[[r]],[[i]],[[o]],[[r]],[[i]],[[t]],[[y]]' => {
                                                                                                        'length' => 10,
                                                                                                        'lhs' => '[Lex-59]',
                                                                                                        'mask' => [
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1,
                                                                                                                    1
                                                                                                                  ],
                                                                                                        'rhs' => [
                                                                                                                   '[[p]]',
                                                                                                                   '[[r]]',
                                                                                                                   '[[i]]',
                                                                                                                   '[[o]]',
                                                                                                                   '[[r]]',
                                                                                                                   '[[i]]',
                                                                                                                   '[[t]]',
                                                                                                                   '[[y]]'
                                                                                                                 ],
                                                                                                        'start' => 3531,
                                                                                                        'subkey' => 0
                                                                                                      },
                                        '[Lex-5],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                           'length' => 8,
                                                                                           'lhs' => '[Lex-5]',
                                                                                           'mask' => [
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1
                                                                                                     ],
                                                                                           'rhs' => [
                                                                                                      '[[s]]',
                                                                                                      '[[y]]',
                                                                                                      '[[m]]',
                                                                                                      '[[b]]',
                                                                                                      '[[o]]',
                                                                                                      '[[l]]'
                                                                                                    ],
                                                                                           'start' => 1198,
                                                                                           'subkey' => 0
                                                                                         },
                                        '[Lex-60],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-60]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3542,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-61],[[p]],[[a]],[[u]],[[s]],[[e]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-61]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[p]]',
                                                                                                 '[[a]]',
                                                                                                 '[[u]]',
                                                                                                 '[[s]]',
                                                                                                 '[[e]]'
                                                                                               ],
                                                                                      'start' => 3592,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-62],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-62]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3600,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-63],[[e]],[[v]],[[e]],[[n]],[[t]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-63]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[e]]',
                                                                                                 '[[v]]',
                                                                                                 '[[e]]',
                                                                                                 '[[n]]',
                                                                                                 '[[t]]'
                                                                                               ],
                                                                                      'start' => 3652,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-64],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-64]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3660,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-65],[[\\=]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-65]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\=]]'
                                                                         ],
                                                                'start' => 3774,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-66],[[o]],[[n]]' => {
                                                                    'length' => 4,
                                                                    'lhs' => '[Lex-66]',
                                                                    'mask' => [
                                                                                1,
                                                                                1
                                                                              ],
                                                                    'rhs' => [
                                                                               '[[o]]',
                                                                               '[[n]]'
                                                                             ],
                                                                    'start' => 3807,
                                                                    'subkey' => 0
                                                                  },
                                        '[Lex-67],[[o]],[[f]],[[f]]' => {
                                                                          'length' => 5,
                                                                          'lhs' => '[Lex-67]',
                                                                          'mask' => [
                                                                                      1,
                                                                                      1,
                                                                                      1
                                                                                    ],
                                                                          'rhs' => [
                                                                                     '[[o]]',
                                                                                     '[[f]]',
                                                                                     '[[f]]'
                                                                                   ],
                                                                          'start' => 3814,
                                                                          'subkey' => 0
                                                                        },
                                        '[Lex-68],[[b]],[[l]],[[e]],[[s]],[[s]]' => {
                                                                                      'length' => 7,
                                                                                      'lhs' => '[Lex-68]',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'rhs' => [
                                                                                                 '[[b]]',
                                                                                                 '[[l]]',
                                                                                                 '[[e]]',
                                                                                                 '[[s]]',
                                                                                                 '[[s]]'
                                                                                               ],
                                                                                      'start' => 3869,
                                                                                      'subkey' => 0
                                                                                    },
                                        '[Lex-69],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-69]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3877,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-6],[[i]],[[s]]' => {
                                                                   'length' => 4,
                                                                   'lhs' => '[Lex-6]',
                                                                   'mask' => [
                                                                               1,
                                                                               1
                                                                             ],
                                                                   'rhs' => [
                                                                              '[[i]]',
                                                                              '[[s]]'
                                                                            ],
                                                                   'start' => 1207,
                                                                   'subkey' => 0
                                                                 },
                                        '[Lex-70],[[n]],[[a]],[[m]],[[e]]' => {
                                                                                'length' => 6,
                                                                                'lhs' => '[Lex-70]',
                                                                                'mask' => [
                                                                                            1,
                                                                                            1,
                                                                                            1,
                                                                                            1
                                                                                          ],
                                                                                'rhs' => [
                                                                                           '[[n]]',
                                                                                           '[[a]]',
                                                                                           '[[m]]',
                                                                                           '[[e]]'
                                                                                         ],
                                                                                'start' => 3913,
                                                                                'subkey' => 0
                                                                              },
                                        '[Lex-71],[[\\=]],[[\\>]]' => {
                                                                        'length' => 4,
                                                                        'lhs' => '[Lex-71]',
                                                                        'mask' => [
                                                                                    1,
                                                                                    1
                                                                                  ],
                                                                        'rhs' => [
                                                                                   '[[\\=]]',
                                                                                   '[[\\>]]'
                                                                                 ],
                                                                        'start' => 3920,
                                                                        'subkey' => 0
                                                                      },
                                        '[Lex-72],[[\\(]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-72]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\(]]'
                                                                         ],
                                                                'start' => 4423,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-73],[[\\)]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-73]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\)]]'
                                                                         ],
                                                                'start' => 4448,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-74],[[\\*]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-74]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\*]]'
                                                                         ],
                                                                'start' => 5323,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-75],[[\\+]]' => {
                                                                'length' => 3,
                                                                'lhs' => '[Lex-75]',
                                                                'mask' => [
                                                                            1
                                                                          ],
                                                                'rhs' => [
                                                                           '[[\\+]]'
                                                                         ],
                                                                'start' => 5329,
                                                                'subkey' => 0
                                                              },
                                        '[Lex-7],[[\\:]],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                         'length' => 10,
                                                                                                         'lhs' => '[Lex-7]',
                                                                                                         'mask' => [
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1,
                                                                                                                     1
                                                                                                                   ],
                                                                                                         'rhs' => [
                                                                                                                    '[[\\:]]',
                                                                                                                    '[[d]]',
                                                                                                                    '[[e]]',
                                                                                                                    '[[f]]',
                                                                                                                    '[[a]]',
                                                                                                                    '[[u]]',
                                                                                                                    '[[l]]',
                                                                                                                    '[[t]]'
                                                                                                                  ],
                                                                                                         'start' => 1239,
                                                                                                         'subkey' => 0
                                                                                                       },
                                        '[Lex-8],[[l]],[[e]],[[x]],[[e]],[[m]],[[e]]' => {
                                                                                           'length' => 8,
                                                                                           'lhs' => '[Lex-8]',
                                                                                           'mask' => [
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1,
                                                                                                       1
                                                                                                     ],
                                                                                           'rhs' => [
                                                                                                      '[[l]]',
                                                                                                      '[[e]]',
                                                                                                      '[[x]]',
                                                                                                      '[[e]]',
                                                                                                      '[[m]]',
                                                                                                      '[[e]]'
                                                                                                    ],
                                                                                           'start' => 1313,
                                                                                           'subkey' => 0
                                                                                         },
                                        '[Lex-9],[[d]],[[e]],[[f]],[[a]],[[u]],[[l]],[[t]]' => {
                                                                                                 'length' => 9,
                                                                                                 'lhs' => '[Lex-9]',
                                                                                                 'mask' => [
                                                                                                             1,
                                                                                                             1,
                                                                                                             1,
                                                                                                             1,
                                                                                                             1,
                                                                                                             1,
                                                                                                             1
                                                                                                           ],
                                                                                                 'rhs' => [
                                                                                                            '[[d]]',
                                                                                                            '[[e]]',
                                                                                                            '[[f]]',
                                                                                                            '[[a]]',
                                                                                                            '[[u]]',
                                                                                                            '[[l]]',
                                                                                                            '[[t]]'
                                                                                                          ],
                                                                                                 'start' => 1322,
                                                                                                 'subkey' => 0
                                                                                               },
                                        'array descriptor left bracket,[[\\[]]' => {
                                                                                     'length' => 37,
                                                                                     'lhs' => 'array descriptor left bracket',
                                                                                     'mask' => [
                                                                                                 1
                                                                                               ],
                                                                                     'name' => 'array descriptor left bracket',
                                                                                     'rhs' => [
                                                                                                '[[\\[]]'
                                                                                              ],
                                                                                     'start' => 6219,
                                                                                     'subkey' => 1,
                                                                                     'xrlid' => 'array descriptor left bracket@6219+37'
                                                                                   },
                                        'array descriptor left bracket,[[\\[]],whitespace' => {
                                                                                                'length' => 48,
                                                                                                'lhs' => 'array descriptor left bracket',
                                                                                                'mask' => [
                                                                                                            1,
                                                                                                            1
                                                                                                          ],
                                                                                                'name' => 'array descriptor left bracket',
                                                                                                'rhs' => [
                                                                                                           '[[\\[]]',
                                                                                                           'whitespace'
                                                                                                         ],
                                                                                                'start' => 6258,
                                                                                                'subkey' => 1,
                                                                                                'xrlid' => 'array descriptor left bracket@6258+48'
                                                                                              },
                                        'array descriptor right bracket,[[\\]]]' => {
                                                                                      'length' => 38,
                                                                                      'lhs' => 'array descriptor right bracket',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'array descriptor right bracket',
                                                                                      'rhs' => [
                                                                                                 '[[\\]]]'
                                                                                               ],
                                                                                      'start' => 6307,
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'array descriptor right bracket@6307+38'
                                                                                    },
                                        'array descriptor right bracket,whitespace,[[\\]]]' => {
                                                                                                 'length' => 49,
                                                                                                 'lhs' => 'array descriptor right bracket',
                                                                                                 'mask' => [
                                                                                                             1,
                                                                                                             1
                                                                                                           ],
                                                                                                 'name' => 'array descriptor right bracket',
                                                                                                 'rhs' => [
                                                                                                            'whitespace',
                                                                                                            '[[\\]]]'
                                                                                                          ],
                                                                                                 'start' => 6347,
                                                                                                 'subkey' => 1,
                                                                                                 'xrlid' => 'array descriptor right bracket@6347+49'
                                                                                               },
                                        'array descriptor,array descriptor left bracket,result item descriptor list,array descriptor right bracket' => {
                                                                                                                                                         'length' => 115,
                                                                                                                                                         'lhs' => 'array descriptor',
                                                                                                                                                         'mask' => [
                                                                                                                                                                     1,
                                                                                                                                                                     1,
                                                                                                                                                                     1
                                                                                                                                                                   ],
                                                                                                                                                         'name' => 'array descriptor',
                                                                                                                                                         'rhs' => [
                                                                                                                                                                    'array descriptor left bracket',
                                                                                                                                                                    'result item descriptor list',
                                                                                                                                                                    'array descriptor right bracket'
                                                                                                                                                                  ],
                                                                                                                                                         'start' => 6103,
                                                                                                                                                         'subkey' => 1,
                                                                                                                                                         'xrlid' => 'array descriptor@6103+115'
                                                                                                                                                       },
                                        'bare name,[[\\w]]' => {
                                                                 'length' => 19,
                                                                 'lhs' => 'bare name',
                                                                 'min' => 1,
                                                                 'name' => 'bare name',
                                                                 'rhs' => [
                                                                            '[[\\w]]'
                                                                          ],
                                                                 'start' => 5939,
                                                                 'subkey' => 0,
                                                                 'xrlid' => 'bare name@5939+19'
                                                               },
                                        'before or after,[[a]],[[f]],[[t]],[[e]],[[r]]' => {
                                                                                             'length' => 7,
                                                                                             'lhs' => 'before or after',
                                                                                             'mask' => [
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1,
                                                                                                         1
                                                                                                       ],
                                                                                             'name' => 'before or after',
                                                                                             'rhs' => [
                                                                                                        '[[a]]',
                                                                                                        '[[f]]',
                                                                                                        '[[t]]',
                                                                                                        '[[e]]',
                                                                                                        '[[r]]'
                                                                                                      ],
                                                                                             'start' => 5364,
                                                                                             'subkey' => 2,
                                                                                             'xrlid' => 'before or after@5333+38'
                                                                                           },
                                        'before or after,[[b]],[[e]],[[f]],[[o]],[[r]],[[e]]' => {
                                                                                                   'length' => 38,
                                                                                                   'lhs' => 'before or after',
                                                                                                   'mask' => [
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1,
                                                                                                               1
                                                                                                             ],
                                                                                                   'name' => 'before or after',
                                                                                                   'rhs' => [
                                                                                                              '[[b]]',
                                                                                                              '[[e]]',
                                                                                                              '[[f]]',
                                                                                                              '[[o]]',
                                                                                                              '[[r]]',
                                                                                                              '[[e]]'
                                                                                                            ],
                                                                                                   'start' => 5333,
                                                                                                   'subkey' => 1,
                                                                                                   'xrlid' => 'before or after@5333+38'
                                                                                                 },
                                        'boolean,[[01]]' => {
                                                              'length' => 14,
                                                              'lhs' => 'boolean',
                                                              'mask' => [
                                                                          1
                                                                        ],
                                                              'name' => 'boolean',
                                                              'rhs' => [
                                                                         '[[01]]'
                                                                       ],
                                                              'start' => 5454,
                                                              'subkey' => 1,
                                                              'xrlid' => 'boolean@5454+14'
                                                            },
                                        'bracketed name string,[[\\s\\w]]' => {
                                                                                'length' => 33,
                                                                                'lhs' => 'bracketed name string',
                                                                                'min' => 1,
                                                                                'name' => 'bracketed name string',
                                                                                'rhs' => [
                                                                                           '[[\\s\\w]]'
                                                                                         ],
                                                                                'start' => 6068,
                                                                                'subkey' => 0,
                                                                                'xrlid' => 'bracketed name string@6068+33'
                                                                              },
                                        'bracketed name,[[\\<]],bracketed name string,[[\\>]]' => {
                                                                                                    'length' => 50,
                                                                                                    'lhs' => 'bracketed name',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'name' => 'bracketed name',
                                                                                                    'rhs' => [
                                                                                                               '[[\\<]]',
                                                                                                               'bracketed name string',
                                                                                                               '[[\\>]]'
                                                                                                             ],
                                                                                                    'start' => 6017,
                                                                                                    'subkey' => 1,
                                                                                                    'xrlid' => 'bracketed name@6017+50'
                                                                                                  },
                                        'cc element,escaped cc character' => {
                                                                               'length' => 37,
                                                                               'lhs' => 'cc element',
                                                                               'mask' => [
                                                                                           1
                                                                                         ],
                                                                               'name' => 'cc element',
                                                                               'rhs' => [
                                                                                          'escaped cc character'
                                                                                        ],
                                                                               'start' => 7387,
                                                                               'subkey' => 1,
                                                                               'xrlid' => 'cc element@7387+37'
                                                                             },
                                        'cc element,negated posix char class' => {
                                                                                   'length' => 41,
                                                                                   'lhs' => 'cc element',
                                                                                   'mask' => [
                                                                                               1
                                                                                             ],
                                                                                   'name' => 'cc element',
                                                                                   'rhs' => [
                                                                                              'negated posix char class'
                                                                                            ],
                                                                                   'start' => 7511,
                                                                                   'subkey' => 1,
                                                                                   'xrlid' => 'cc element@7511+41'
                                                                                 },
                                        'cc element,posix char class' => {
                                                                           'length' => 33,
                                                                           'lhs' => 'cc element',
                                                                           'mask' => [
                                                                                       1
                                                                                     ],
                                                                           'name' => 'cc element',
                                                                           'rhs' => [
                                                                                      'posix char class'
                                                                                    ],
                                                                           'start' => 7477,
                                                                           'subkey' => 1,
                                                                           'xrlid' => 'cc element@7477+33'
                                                                         },
                                        'cc element,safe cc character' => {
                                                                            'length' => 34,
                                                                            'lhs' => 'cc element',
                                                                            'mask' => [
                                                                                        1
                                                                                      ],
                                                                            'name' => 'cc element',
                                                                            'rhs' => [
                                                                                       'safe cc character'
                                                                                     ],
                                                                            'start' => 7239,
                                                                            'subkey' => 1,
                                                                            'xrlid' => 'cc element@7239+34'
                                                                          },
                                        'cc elements,cc element' => {
                                                                      'length' => 29,
                                                                      'lhs' => 'cc elements',
                                                                      'min' => 1,
                                                                      'name' => 'cc elements',
                                                                      'rhs' => [
                                                                                 'cc element'
                                                                               ],
                                                                      'start' => 7209,
                                                                      'subkey' => 0,
                                                                      'xrlid' => 'cc elements@7209+29'
                                                                    },
                                        'character class modifier,[[\\:]],[[i]]' => {
                                                                                      'length' => 33,
                                                                                      'lhs' => 'character class modifier',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'character class modifier',
                                                                                      'rhs' => [
                                                                                                 '[[\\:]]',
                                                                                                 '[[i]]'
                                                                                               ],
                                                                                      'start' => 7646,
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'character class modifier@7646+33'
                                                                                    },
                                        'character class modifier,[[\\:]],[[i]],[[c]]' => {
                                                                                            'length' => 34,
                                                                                            'lhs' => 'character class modifier',
                                                                                            'mask' => [
                                                                                                        1,
                                                                                                        1,
                                                                                                        1
                                                                                                      ],
                                                                                            'name' => 'character class modifier',
                                                                                            'rhs' => [
                                                                                                       '[[\\:]]',
                                                                                                       '[[i]]',
                                                                                                       '[[c]]'
                                                                                                     ],
                                                                                            'start' => 7611,
                                                                                            'subkey' => 1,
                                                                                            'xrlid' => 'character class modifier@7611+34'
                                                                                          },
                                        'character class modifiers,character class modifier' => {
                                                                                                  'length' => 57,
                                                                                                  'lhs' => 'character class modifiers',
                                                                                                  'min' => 0,
                                                                                                  'name' => 'character class modifiers',
                                                                                                  'rhs' => [
                                                                                                             'character class modifier'
                                                                                                           ],
                                                                                                  'start' => 7553,
                                                                                                  'subkey' => 0,
                                                                                                  'xrlid' => 'character class modifiers@7553+57'
                                                                                                },
                                        'character class,[[\\[]],cc elements,[[\\]]],character class modifiers' => {
                                                                                                                     'length' => 69,
                                                                                                                     'lhs' => 'character class',
                                                                                                                     'mask' => [
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1
                                                                                                                               ],
                                                                                                                     'name' => 'character class',
                                                                                                                     'rhs' => [
                                                                                                                                '[[\\[]]',
                                                                                                                                'cc elements',
                                                                                                                                '[[\\]]]',
                                                                                                                                'character class modifiers'
                                                                                                                              ],
                                                                                                                     'start' => 7139,
                                                                                                                     'subkey' => 1,
                                                                                                                     'xrlid' => 'character class@7139+69'
                                                                                                                   },
                                        'double colon,[[\\:]],[[\\:]]' => {
                                                                            'length' => 21,
                                                                            'lhs' => 'double colon',
                                                                            'mask' => [
                                                                                        1,
                                                                                        1
                                                                                      ],
                                                                            'name' => 'double colon',
                                                                            'rhs' => [
                                                                                       '[[\\:]]',
                                                                                       '[[\\:]]'
                                                                                     ],
                                                                            'start' => 5843,
                                                                            'subkey' => 1,
                                                                            'xrlid' => 'double colon@5843+21'
                                                                          },
                                        'escaped cc character,[[\\\\]],horizontal character' => {
                                                                                                  'length' => 51,
                                                                                                  'lhs' => 'escaped cc character',
                                                                                                  'mask' => [
                                                                                                              1,
                                                                                                              1
                                                                                                            ],
                                                                                                  'name' => 'escaped cc character',
                                                                                                  'rhs' => [
                                                                                                             '[[\\\\]]',
                                                                                                             'horizontal character'
                                                                                                           ],
                                                                                                  'start' => 7425,
                                                                                                  'subkey' => 1,
                                                                                                  'xrlid' => 'escaped cc character@7425+51'
                                                                                                },
                                        'hash comment body,hash comment char' => {
                                                                                   'length' => 42,
                                                                                   'lhs' => 'hash comment body',
                                                                                   'min' => 0,
                                                                                   'name' => 'hash comment body',
                                                                                   'rhs' => [
                                                                                              'hash comment char'
                                                                                            ],
                                                                                   'start' => 5044,
                                                                                   'subkey' => 0,
                                                                                   'xrlid' => 'hash comment body@5044+42'
                                                                                 },
                                        'hash comment char,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                 'length' => 61,
                                                                                                                 'lhs' => 'hash comment char',
                                                                                                                 'mask' => [
                                                                                                                             1
                                                                                                                           ],
                                                                                                                 'name' => 'hash comment char',
                                                                                                                 'rhs' => [
                                                                                                                            '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                          ],
                                                                                                                 'start' => 5150,
                                                                                                                 'subkey' => 1,
                                                                                                                 'xrlid' => 'hash comment char@5150+61'
                                                                                                               },
                                        'hash comment,terminated hash comment' => {
                                                                                    'length' => 81,
                                                                                    'lhs' => 'hash comment',
                                                                                    'mask' => [
                                                                                                1
                                                                                              ],
                                                                                    'name' => 'hash comment',
                                                                                    'rhs' => [
                                                                                               'terminated hash comment'
                                                                                             ],
                                                                                    'start' => 4828,
                                                                                    'subkey' => 1,
                                                                                    'xrlid' => 'hash comment@4828+81'
                                                                                  },
                                        'hash comment,unterminated final hash comment' => {
                                                                                            'length' => 36,
                                                                                            'lhs' => 'hash comment',
                                                                                            'mask' => [
                                                                                                        1
                                                                                                      ],
                                                                                            'name' => 'hash comment',
                                                                                            'rhs' => [
                                                                                                       'unterminated final hash comment'
                                                                                                     ],
                                                                                            'start' => 4873,
                                                                                            'subkey' => 2,
                                                                                            'xrlid' => 'hash comment@4828+81'
                                                                                          },
                                        'horizontal character,[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                    'length' => 64,
                                                                                                                    'lhs' => 'horizontal character',
                                                                                                                    'mask' => [
                                                                                                                                1
                                                                                                                              ],
                                                                                                                    'name' => 'horizontal character',
                                                                                                                    'rhs' => [
                                                                                                                               '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                             ],
                                                                                                                    'start' => 8087,
                                                                                                                    'subkey' => 1,
                                                                                                                    'xrlid' => 'horizontal character@8087+64'
                                                                                                                  },
                                        'integer,[[\\d]]' => {
                                                               'length' => 17,
                                                               'lhs' => 'integer',
                                                               'min' => 1,
                                                               'name' => 'integer',
                                                               'rhs' => [
                                                                          '[[\\d]]'
                                                                        ],
                                                               'start' => 5435,
                                                               'subkey' => 0,
                                                               'xrlid' => 'integer@5435+17'
                                                             },
                                        'negated posix char class,[[\\[]],[[\\:]],[[\\^]],posix char class name,[[\\:]],[[\\]]]' => {
                                                                                                                                      'length' => 63,
                                                                                                                                      'lhs' => 'negated posix char class',
                                                                                                                                      'mask' => [
                                                                                                                                                  1,
                                                                                                                                                  1,
                                                                                                                                                  1,
                                                                                                                                                  1,
                                                                                                                                                  1,
                                                                                                                                                  1
                                                                                                                                                ],
                                                                                                                                      'name' => 'negated posix char class',
                                                                                                                                      'rhs' => [
                                                                                                                                                 '[[\\[]]',
                                                                                                                                                 '[[\\:]]',
                                                                                                                                                 '[[\\^]]',
                                                                                                                                                 'posix char class name',
                                                                                                                                                 '[[\\:]]',
                                                                                                                                                 '[[\\]]]'
                                                                                                                                               ],
                                                                                                                                      'start' => 7914,
                                                                                                                                      'subkey' => 1,
                                                                                                                                      'xrlid' => 'negated posix char class@7914+63'
                                                                                                                                    },
                                        'one or more word characters,[[\\w]]' => {
                                                                                   'length' => 37,
                                                                                   'lhs' => 'one or more word characters',
                                                                                   'min' => 1,
                                                                                   'name' => 'one or more word characters',
                                                                                   'rhs' => [
                                                                                              '[[\\w]]'
                                                                                            ],
                                                                                   'start' => 5592,
                                                                                   'subkey' => 0,
                                                                                   'xrlid' => 'one or more word characters@5592+37'
                                                                                 },
                                        'op declare bnf,[[\\:]],[[\\:]],[[\\=]]' => {
                                                                                      'length' => 24,
                                                                                      'lhs' => 'op declare bnf',
                                                                                      'mask' => [
                                                                                                  1,
                                                                                                  1,
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'op declare bnf',
                                                                                      'rhs' => [
                                                                                                 '[[\\:]]',
                                                                                                 '[[\\:]]',
                                                                                                 '[[\\=]]'
                                                                                               ],
                                                                                      'start' => 5213,
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'op declare bnf@5213+24'
                                                                                    },
                                        'op declare match,[[\\~]]' => {
                                                                        'length' => 24,
                                                                        'lhs' => 'op declare match',
                                                                        'mask' => [
                                                                                    1
                                                                                  ],
                                                                        'name' => 'op declare match',
                                                                        'rhs' => [
                                                                                   '[[\\~]]'
                                                                                 ],
                                                                        'start' => 5238,
                                                                        'subkey' => 1,
                                                                        'xrlid' => 'op declare match@5238+24'
                                                                      },
                                        'op equal priority,[[\\|]]' => {
                                                                         'length' => 25,
                                                                         'lhs' => 'op equal priority',
                                                                         'mask' => [
                                                                                     1
                                                                                   ],
                                                                         'name' => 'op equal priority',
                                                                         'rhs' => [
                                                                                    '[[\\|]]'
                                                                                  ],
                                                                         'start' => 5282,
                                                                         'subkey' => 1,
                                                                         'xrlid' => 'op equal priority@5282+25'
                                                                       },
                                        'op loosen,[[\\|]],[[\\|]]' => {
                                                                         'length' => 18,
                                                                         'lhs' => 'op loosen',
                                                                         'mask' => [
                                                                                     1,
                                                                                     1
                                                                                   ],
                                                                         'name' => 'op loosen',
                                                                         'rhs' => [
                                                                                    '[[\\|]]',
                                                                                    '[[\\|]]'
                                                                                  ],
                                                                         'start' => 5263,
                                                                         'subkey' => 1,
                                                                         'xrlid' => 'op loosen@5263+18'
                                                                       },
                                        'posix char class name,[[[:alnum:]]]' => {
                                                                                   'length' => 38,
                                                                                   'lhs' => 'posix char class name',
                                                                                   'min' => 1,
                                                                                   'name' => 'posix char class name',
                                                                                   'rhs' => [
                                                                                              '[[[:alnum:]]]'
                                                                                            ],
                                                                                   'start' => 7978,
                                                                                   'subkey' => 0,
                                                                                   'xrlid' => 'posix char class name@7978+38'
                                                                                 },
                                        'posix char class,[[\\[]],[[\\:]],posix char class name,[[\\:]],[[\\]]]' => {
                                                                                                                      'length' => 54,
                                                                                                                      'lhs' => 'posix char class',
                                                                                                                      'mask' => [
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1
                                                                                                                                ],
                                                                                                                      'name' => 'posix char class',
                                                                                                                      'rhs' => [
                                                                                                                                 '[[\\[]]',
                                                                                                                                 '[[\\:]]',
                                                                                                                                 'posix char class name',
                                                                                                                                 '[[\\:]]',
                                                                                                                                 '[[\\]]]'
                                                                                                                               ],
                                                                                                                      'start' => 7859,
                                                                                                                      'subkey' => 1,
                                                                                                                      'xrlid' => 'posix char class@7859+54'
                                                                                                                    },
                                        'reserved action name,[[\\:]],[[\\:]],one or more word characters' => {
                                                                                                                'length' => 59,
                                                                                                                'lhs' => 'reserved action name',
                                                                                                                'mask' => [
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'name' => 'reserved action name',
                                                                                                                'rhs' => [
                                                                                                                           '[[\\:]]',
                                                                                                                           '[[\\:]]',
                                                                                                                           'one or more word characters'
                                                                                                                         ],
                                                                                                                'start' => 5470,
                                                                                                                'subkey' => 1,
                                                                                                                'xrlid' => 'reserved action name@5470+59'
                                                                                                              },
                                        'reserved blessing name,[[\\:]],[[\\:]],one or more word characters' => {
                                                                                                                  'length' => 61,
                                                                                                                  'lhs' => 'reserved blessing name',
                                                                                                                  'mask' => [
                                                                                                                              1,
                                                                                                                              1,
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'reserved blessing name',
                                                                                                                  'rhs' => [
                                                                                                                             '[[\\:]]',
                                                                                                                             '[[\\:]]',
                                                                                                                             'one or more word characters'
                                                                                                                           ],
                                                                                                                  'start' => 5530,
                                                                                                                  'subkey' => 1,
                                                                                                                  'xrlid' => 'reserved blessing name@5530+61'
                                                                                                                },
                                        'reserved event name,[[\\:]],[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                                               'length' => 33,
                                                                                                               'lhs' => 'reserved event name',
                                                                                                               'mask' => [
                                                                                                                           1,
                                                                                                                           1,
                                                                                                                           1,
                                                                                                                           1,
                                                                                                                           1,
                                                                                                                           1,
                                                                                                                           1
                                                                                                                         ],
                                                                                                               'name' => 'reserved event name',
                                                                                                               'rhs' => [
                                                                                                                          '[[\\:]]',
                                                                                                                          '[[s]]',
                                                                                                                          '[[y]]',
                                                                                                                          '[[m]]',
                                                                                                                          '[[b]]',
                                                                                                                          '[[o]]',
                                                                                                                          '[[l]]'
                                                                                                                        ],
                                                                                                               'start' => 4097,
                                                                                                               'subkey' => 1,
                                                                                                               'xrlid' => 'reserved event name@4097+33'
                                                                                                             },
                                        'result item descriptor list,result item descriptor' => {
                                                                                                  'length' => 105,
                                                                                                  'lhs' => 'result item descriptor list',
                                                                                                  'min' => 0,
                                                                                                  'name' => 'result item descriptor list',
                                                                                                  'rhs' => [
                                                                                                             'result item descriptor'
                                                                                                           ],
                                                                                                  'separator' => 'result item descriptor separator',
                                                                                                  'start' => 6398,
                                                                                                  'subkey' => 0,
                                                                                                  'xrlid' => 'result item descriptor list@6398+105'
                                                                                                },
                                        'result item descriptor separator,[[,]]' => {
                                                                                      'length' => 40,
                                                                                      'lhs' => 'result item descriptor separator',
                                                                                      'mask' => [
                                                                                                  1
                                                                                                ],
                                                                                      'name' => 'result item descriptor separator',
                                                                                      'rhs' => [
                                                                                                 '[[,]]'
                                                                                               ],
                                                                                      'start' => 6504,
                                                                                      'subkey' => 1,
                                                                                      'xrlid' => 'result item descriptor separator@6504+40'
                                                                                    },
                                        'result item descriptor separator,[[,]],whitespace' => {
                                                                                                 'length' => 51,
                                                                                                 'lhs' => 'result item descriptor separator',
                                                                                                 'mask' => [
                                                                                                             1,
                                                                                                             1
                                                                                                           ],
                                                                                                 'name' => 'result item descriptor separator',
                                                                                                 'rhs' => [
                                                                                                            '[[,]]',
                                                                                                            'whitespace'
                                                                                                          ],
                                                                                                 'start' => 6545,
                                                                                                 'subkey' => 1,
                                                                                                 'xrlid' => 'result item descriptor separator@6545+51'
                                                                                               },
                                        'result item descriptor,[[g]],[[1]],[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]' => {
                                                                                                                      'length' => 10,
                                                                                                                      'lhs' => 'result item descriptor',
                                                                                                                      'mask' => [
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1,
                                                                                                                                  1
                                                                                                                                ],
                                                                                                                      'name' => 'result item descriptor',
                                                                                                                      'rhs' => [
                                                                                                                                 '[[g]]',
                                                                                                                                 '[[1]]',
                                                                                                                                 '[[l]]',
                                                                                                                                 '[[e]]',
                                                                                                                                 '[[n]]',
                                                                                                                                 '[[g]]',
                                                                                                                                 '[[t]]',
                                                                                                                                 '[[h]]'
                                                                                                                               ],
                                                                                                                      'start' => 6659,
                                                                                                                      'subkey' => 4,
                                                                                                                      'xrlid' => 'result item descriptor@6597+135'
                                                                                                                    },
                                        'result item descriptor,[[g]],[[1]],[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                                                'length' => 9,
                                                                                                                'lhs' => 'result item descriptor',
                                                                                                                'mask' => [
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1,
                                                                                                                            1
                                                                                                                          ],
                                                                                                                'name' => 'result item descriptor',
                                                                                                                'rhs' => [
                                                                                                                           '[[g]]',
                                                                                                                           '[[1]]',
                                                                                                                           '[[s]]',
                                                                                                                           '[[t]]',
                                                                                                                           '[[a]]',
                                                                                                                           '[[r]]',
                                                                                                                           '[[t]]'
                                                                                                                         ],
                                                                                                                'start' => 6647,
                                                                                                                'subkey' => 3,
                                                                                                                'xrlid' => 'result item descriptor@6597+135'
                                                                                                              },
                                        'result item descriptor,[[l]],[[e]],[[n]],[[g]],[[t]],[[h]]' => {
                                                                                                          'length' => 8,
                                                                                                          'lhs' => 'result item descriptor',
                                                                                                          'mask' => [
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'name' => 'result item descriptor',
                                                                                                          'rhs' => [
                                                                                                                     '[[l]]',
                                                                                                                     '[[e]]',
                                                                                                                     '[[n]]',
                                                                                                                     '[[g]]',
                                                                                                                     '[[t]]',
                                                                                                                     '[[h]]'
                                                                                                                   ],
                                                                                                          'start' => 6634,
                                                                                                          'subkey' => 2,
                                                                                                          'xrlid' => 'result item descriptor@6597+135'
                                                                                                        },
                                        'result item descriptor,[[l]],[[h]],[[s]]' => {
                                                                                        'length' => 5,
                                                                                        'lhs' => 'result item descriptor',
                                                                                        'mask' => [
                                                                                                    1,
                                                                                                    1,
                                                                                                    1
                                                                                                  ],
                                                                                        'name' => 'result item descriptor',
                                                                                        'rhs' => [
                                                                                                   '[[l]]',
                                                                                                   '[[h]]',
                                                                                                   '[[s]]'
                                                                                                 ],
                                                                                        'start' => 6683,
                                                                                        'subkey' => 6,
                                                                                        'xrlid' => 'result item descriptor@6597+135'
                                                                                      },
                                        'result item descriptor,[[n]],[[a]],[[m]],[[e]]' => {
                                                                                              'length' => 6,
                                                                                              'lhs' => 'result item descriptor',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'name' => 'result item descriptor',
                                                                                              'rhs' => [
                                                                                                         '[[n]]',
                                                                                                         '[[a]]',
                                                                                                         '[[m]]',
                                                                                                         '[[e]]'
                                                                                                       ],
                                                                                              'start' => 6674,
                                                                                              'subkey' => 5,
                                                                                              'xrlid' => 'result item descriptor@6597+135'
                                                                                            },
                                        'result item descriptor,[[r]],[[u]],[[l]],[[e]]' => {
                                                                                              'length' => 6,
                                                                                              'lhs' => 'result item descriptor',
                                                                                              'mask' => [
                                                                                                          1,
                                                                                                          1,
                                                                                                          1,
                                                                                                          1
                                                                                                        ],
                                                                                              'name' => 'result item descriptor',
                                                                                              'rhs' => [
                                                                                                         '[[r]]',
                                                                                                         '[[u]]',
                                                                                                         '[[l]]',
                                                                                                         '[[e]]'
                                                                                                       ],
                                                                                              'start' => 6702,
                                                                                              'subkey' => 8,
                                                                                              'xrlid' => 'result item descriptor@6597+135'
                                                                                            },
                                        'result item descriptor,[[s]],[[t]],[[a]],[[r]],[[t]]' => {
                                                                                                    'length' => 135,
                                                                                                    'lhs' => 'result item descriptor',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'name' => 'result item descriptor',
                                                                                                    'rhs' => [
                                                                                                               '[[s]]',
                                                                                                               '[[t]]',
                                                                                                               '[[a]]',
                                                                                                               '[[r]]',
                                                                                                               '[[t]]'
                                                                                                             ],
                                                                                                    'start' => 6597,
                                                                                                    'subkey' => 1,
                                                                                                    'xrlid' => 'result item descriptor@6597+135'
                                                                                                  },
                                        'result item descriptor,[[s]],[[y]],[[m]],[[b]],[[o]],[[l]]' => {
                                                                                                          'length' => 8,
                                                                                                          'lhs' => 'result item descriptor',
                                                                                                          'mask' => [
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'name' => 'result item descriptor',
                                                                                                          'rhs' => [
                                                                                                                     '[[s]]',
                                                                                                                     '[[y]]',
                                                                                                                     '[[m]]',
                                                                                                                     '[[b]]',
                                                                                                                     '[[o]]',
                                                                                                                     '[[l]]'
                                                                                                                   ],
                                                                                                          'start' => 6691,
                                                                                                          'subkey' => 7,
                                                                                                          'xrlid' => 'result item descriptor@6597+135'
                                                                                                        },
                                        'result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]]' => {
                                                                                                    'length' => 7,
                                                                                                    'lhs' => 'result item descriptor',
                                                                                                    'mask' => [
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1,
                                                                                                                1
                                                                                                              ],
                                                                                                    'name' => 'result item descriptor',
                                                                                                    'rhs' => [
                                                                                                               '[[v]]',
                                                                                                               '[[a]]',
                                                                                                               '[[l]]',
                                                                                                               '[[u]]',
                                                                                                               '[[e]]'
                                                                                                             ],
                                                                                                    'start' => 6714,
                                                                                                    'subkey' => 9,
                                                                                                    'xrlid' => 'result item descriptor@6597+135'
                                                                                                  },
                                        'result item descriptor,[[v]],[[a]],[[l]],[[u]],[[e]],[[s]]' => {
                                                                                                          'length' => 8,
                                                                                                          'lhs' => 'result item descriptor',
                                                                                                          'mask' => [
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1,
                                                                                                                      1
                                                                                                                    ],
                                                                                                          'name' => 'result item descriptor',
                                                                                                          'rhs' => [
                                                                                                                     '[[v]]',
                                                                                                                     '[[a]]',
                                                                                                                     '[[l]]',
                                                                                                                     '[[u]]',
                                                                                                                     '[[e]]',
                                                                                                                     '[[s]]'
                                                                                                                   ],
                                                                                                          'start' => 6724,
                                                                                                          'subkey' => 10,
                                                                                                          'xrlid' => 'result item descriptor@6597+135'
                                                                                                        },
                                        'safe cc character,[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                                     'length' => 79,
                                                                                                                                     'lhs' => 'safe cc character',
                                                                                                                                     'mask' => [
                                                                                                                                                 1
                                                                                                                                               ],
                                                                                                                                     'name' => 'safe cc character',
                                                                                                                                     'rhs' => [
                                                                                                                                                '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                                              ],
                                                                                                                                     'start' => 7307,
                                                                                                                                     'subkey' => 1,
                                                                                                                                     'xrlid' => 'safe cc character@7307+79'
                                                                                                                                   },
                                        'sign,[[+-]]' => {
                                                           'length' => 13,
                                                           'lhs' => 'sign',
                                                           'mask' => [
                                                                       1
                                                                     ],
                                                           'name' => 'sign',
                                                           'rhs' => [
                                                                      '[[+-]]'
                                                                    ],
                                                           'start' => 5421,
                                                           'subkey' => 1,
                                                           'xrlid' => 'sign@5421+13'
                                                         },
                                        'signed integer,integer' => {
                                                                      'length' => 47,
                                                                      'lhs' => 'signed integer',
                                                                      'mask' => [
                                                                                  1
                                                                                ],
                                                                      'name' => 'signed integer',
                                                                      'rhs' => [
                                                                                 'integer'
                                                                               ],
                                                                      'start' => 5373,
                                                                      'subkey' => 1,
                                                                      'xrlid' => 'signed integer@5373+47'
                                                                    },
                                        'signed integer,sign,integer' => {
                                                                           'length' => 16,
                                                                           'lhs' => 'signed integer',
                                                                           'mask' => [
                                                                                       1,
                                                                                       1
                                                                                     ],
                                                                           'name' => 'signed integer',
                                                                           'rhs' => [
                                                                                      'sign',
                                                                                      'integer'
                                                                                    ],
                                                                           'start' => 5404,
                                                                           'subkey' => 2,
                                                                           'xrlid' => 'signed integer@5373+47'
                                                                         },
                                        'single quoted name,[[\']],string without single quote or vertical space,[[\']]' => {
                                                                                                                              'length' => 78,
                                                                                                                              'lhs' => 'single quoted name',
                                                                                                                              'mask' => [
                                                                                                                                          1,
                                                                                                                                          1,
                                                                                                                                          1
                                                                                                                                        ],
                                                                                                                              'name' => 'single quoted name',
                                                                                                                              'rhs' => [
                                                                                                                                         '[[\']]',
                                                                                                                                         'string without single quote or vertical space',
                                                                                                                                         '[[\']]'
                                                                                                                                       ],
                                                                                                                              'start' => 6955,
                                                                                                                              'subkey' => 1,
                                                                                                                              'xrlid' => 'single quoted name@6955+78'
                                                                                                                            },
                                        'single quoted string,[[\']],string without single quote or vertical space,[[\']],character class modifiers' => {
                                                                                                                                                          'length' => 108,
                                                                                                                                                          'lhs' => 'single quoted string',
                                                                                                                                                          'mask' => [
                                                                                                                                                                      1,
                                                                                                                                                                      1,
                                                                                                                                                                      1,
                                                                                                                                                                      1
                                                                                                                                                                    ],
                                                                                                                                                          'name' => 'single quoted string',
                                                                                                                                                          'rhs' => [
                                                                                                                                                                     '[[\']]',
                                                                                                                                                                     'string without single quote or vertical space',
                                                                                                                                                                     '[[\']]',
                                                                                                                                                                     'character class modifiers'
                                                                                                                                                                   ],
                                                                                                                                                          'start' => 6846,
                                                                                                                                                          'subkey' => 1,
                                                                                                                                                          'xrlid' => 'single quoted string@6846+108'
                                                                                                                                                        },
                                        'standard name,[[a-zA-Z]],zero or more word characters' => {
                                                                                                     'length' => 57,
                                                                                                     'lhs' => 'standard name',
                                                                                                     'mask' => [
                                                                                                                 1,
                                                                                                                 1
                                                                                                               ],
                                                                                                     'name' => 'standard name',
                                                                                                     'rhs' => [
                                                                                                                '[[a-zA-Z]]',
                                                                                                                'zero or more word characters'
                                                                                                              ],
                                                                                                     'start' => 5959,
                                                                                                     'subkey' => 1,
                                                                                                     'xrlid' => 'standard name@5959+57'
                                                                                                   },
                                        'string without single quote or vertical space,[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                                                                            'length' => 103,
                                                                                                                                                            'lhs' => 'string without single quote or vertical space',
                                                                                                                                                            'min' => 1,
                                                                                                                                                            'name' => 'string without single quote or vertical space',
                                                                                                                                                            'rhs' => [
                                                                                                                                                                       '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]'
                                                                                                                                                                     ],
                                                                                                                                                            'start' => 7034,
                                                                                                                                                            'subkey' => 0,
                                                                                                                                                            'xrlid' => 'string without single quote or vertical space@7034+103'
                                                                                                                                                          },
                                        'terminated hash comment,[[\\#]],hash comment body,vertical space char' => {
                                                                                                                     'length' => 73,
                                                                                                                     'lhs' => 'terminated hash comment',
                                                                                                                     'mask' => [
                                                                                                                                 1,
                                                                                                                                 1,
                                                                                                                                 1
                                                                                                                               ],
                                                                                                                     'name' => 'terminated hash comment',
                                                                                                                     'rhs' => [
                                                                                                                                '[[\\#]]',
                                                                                                                                'hash comment body',
                                                                                                                                'vertical space char'
                                                                                                                              ],
                                                                                                                     'start' => 4910,
                                                                                                                     'subkey' => 1,
                                                                                                                     'xrlid' => 'terminated hash comment@4910+73'
                                                                                                                   },
                                        'unterminated final hash comment,[[\\#]],hash comment body' => {
                                                                                                         'length' => 59,
                                                                                                         'lhs' => 'unterminated final hash comment',
                                                                                                         'mask' => [
                                                                                                                     1,
                                                                                                                     1
                                                                                                                   ],
                                                                                                         'name' => 'unterminated final hash comment',
                                                                                                         'rhs' => [
                                                                                                                    '[[\\#]]',
                                                                                                                    'hash comment body'
                                                                                                                  ],
                                                                                                         'start' => 4984,
                                                                                                         'subkey' => 1,
                                                                                                         'xrlid' => 'unterminated final hash comment@4984+59'
                                                                                                       },
                                        'vertical space char,[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                                                  'length' => 62,
                                                                                                                  'lhs' => 'vertical space char',
                                                                                                                  'mask' => [
                                                                                                                              1
                                                                                                                            ],
                                                                                                                  'name' => 'vertical space char',
                                                                                                                  'rhs' => [
                                                                                                                             '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]'
                                                                                                                           ],
                                                                                                                  'start' => 5087,
                                                                                                                  'subkey' => 1,
                                                                                                                  'xrlid' => 'vertical space char@5087+62'
                                                                                                                },
                                        'whitespace,[[\\s]]' => {
                                                                  'length' => 18,
                                                                  'lhs' => 'whitespace',
                                                                  'min' => 1,
                                                                  'name' => 'whitespace',
                                                                  'rhs' => [
                                                                             '[[\\s]]'
                                                                           ],
                                                                  'start' => 4765,
                                                                  'subkey' => 0,
                                                                  'xrlid' => 'whitespace@4765+18'
                                                                },
                                        'zero or more word characters,[[\\w]]' => {
                                                                                    'length' => 38,
                                                                                    'lhs' => 'zero or more word characters',
                                                                                    'min' => 0,
                                                                                    'name' => 'zero or more word characters',
                                                                                    'rhs' => [
                                                                                               '[[\\w]]'
                                                                                             ],
                                                                                    'start' => 5630,
                                                                                    'subkey' => 0,
                                                                                    'xrlid' => 'zero or more word characters@5630+38'
                                                                                  }
                                      }
                            },
                  'xrl' => {
                             'Perl identifier@5817+25' => {
                                                            'length' => 25,
                                                            'lhs' => 'Perl identifier',
                                                            'precedence_count' => 1,
                                                            'start' => 5817
                                                          },
                             'Perl name@5865+72' => {
                                                      'length' => 72,
                                                      'lhs' => 'Perl name',
                                                      'precedence_count' => 1,
                                                      'start' => 5865
                                                    },
                             'action name@4634+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4634
                                                      },
                             'action name@4664+40' => {
                                                        'length' => 40,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4664
                                                      },
                             'action name@4705+36' => {
                                                        'length' => 36,
                                                        'lhs' => 'action name',
                                                        'precedence_count' => 1,
                                                        'start' => 4705
                                                      },
                             'action@2900+40' => {
                                                   'length' => 40,
                                                   'lhs' => 'action',
                                                   'precedence_count' => 1,
                                                   'start' => 2900
                                                 },
                             'adverb item@2507+369' => {
                                                         'length' => 369,
                                                         'lhs' => 'adverb item',
                                                         'precedence_count' => 1,
                                                         'start' => 2507
                                                       },
                             'adverb list items@2468+38' => {
                                                              'length' => 38,
                                                              'lhs' => 'adverb list items',
                                                              'precedence_count' => 1,
                                                              'start' => 2468
                                                            },
                             'adverb list@2430+37' => {
                                                        'length' => 37,
                                                        'lhs' => 'adverb list',
                                                        'precedence_count' => 1,
                                                        'start' => 2430
                                                      },
                             'alternative name@3946+61' => {
                                                             'length' => 61,
                                                             'lhs' => 'alternative name',
                                                             'precedence_count' => 1,
                                                             'start' => 3946
                                                           },
                             'alternative@2395+33' => {
                                                        'length' => 33,
                                                        'lhs' => 'alternative',
                                                        'precedence_count' => 1,
                                                        'start' => 2395
                                                      },
                             'alternatives@2316+78' => {
                                                         'length' => 78,
                                                         'lhs' => 'alternatives',
                                                         'precedence_count' => 1,
                                                         'start' => 2316
                                                       },
                             'array descriptor left bracket@6219+37' => {
                                                                          'length' => 37,
                                                                          'lhs' => 'array descriptor left bracket',
                                                                          'precedence_count' => 1,
                                                                          'start' => 6219
                                                                        },
                             'array descriptor left bracket@6258+48' => {
                                                                          'length' => 48,
                                                                          'lhs' => 'array descriptor left bracket',
                                                                          'precedence_count' => 1,
                                                                          'start' => 6258
                                                                        },
                             'array descriptor right bracket@6307+38' => {
                                                                           'length' => 38,
                                                                           'lhs' => 'array descriptor right bracket',
                                                                           'precedence_count' => 1,
                                                                           'start' => 6307
                                                                         },
                             'array descriptor right bracket@6347+49' => {
                                                                           'length' => 49,
                                                                           'lhs' => 'array descriptor right bracket',
                                                                           'precedence_count' => 1,
                                                                           'start' => 6347
                                                                         },
                             'array descriptor@6103+115' => {
                                                              'length' => 115,
                                                              'lhs' => 'array descriptor',
                                                              'precedence_count' => 1,
                                                              'start' => 6103
                                                            },
                             'bare name@5939+19' => {
                                                      'length' => 19,
                                                      'lhs' => 'bare name',
                                                      'precedence_count' => 1,
                                                      'start' => 5939
                                                    },
                             'before or after@5333+38' => {
                                                            'length' => 38,
                                                            'lhs' => 'before or after',
                                                            'precedence_count' => 1,
                                                            'start' => 5333
                                                          },
                             'blessing name@4132+35' => {
                                                          'length' => 35,
                                                          'lhs' => 'blessing name',
                                                          'precedence_count' => 1,
                                                          'start' => 4132
                                                        },
                             'blessing name@4168+44' => {
                                                          'length' => 44,
                                                          'lhs' => 'blessing name',
                                                          'precedence_count' => 1,
                                                          'start' => 4168
                                                        },
                             'blessing@3853+45' => {
                                                     'length' => 45,
                                                     'lhs' => 'blessing',
                                                     'precedence_count' => 1,
                                                     'start' => 3853
                                                   },
                             'boolean@5454+14' => {
                                                    'length' => 14,
                                                    'lhs' => 'boolean',
                                                    'precedence_count' => 1,
                                                    'start' => 5454
                                                  },
                             'bracketed name string@6068+33' => {
                                                                  'length' => 33,
                                                                  'lhs' => 'bracketed name string',
                                                                  'precedence_count' => 1,
                                                                  'start' => 6068
                                                                },
                             'bracketed name@6017+50' => {
                                                           'length' => 50,
                                                           'lhs' => 'bracketed name',
                                                           'precedence_count' => 1,
                                                           'start' => 6017
                                                         },
                             'cc element@7239+34' => {
                                                       'length' => 34,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7239
                                                     },
                             'cc element@7387+37' => {
                                                       'length' => 37,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7387
                                                     },
                             'cc element@7477+33' => {
                                                       'length' => 33,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7477
                                                     },
                             'cc element@7511+41' => {
                                                       'length' => 41,
                                                       'lhs' => 'cc element',
                                                       'precedence_count' => 1,
                                                       'start' => 7511
                                                     },
                             'cc elements@7209+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'cc elements',
                                                        'precedence_count' => 1,
                                                        'start' => 7209
                                                      },
                             'character class modifier@7611+34' => {
                                                                     'length' => 34,
                                                                     'lhs' => 'character class modifier',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7611
                                                                   },
                             'character class modifier@7646+33' => {
                                                                     'length' => 33,
                                                                     'lhs' => 'character class modifier',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7646
                                                                   },
                             'character class modifiers@7553+57' => {
                                                                      'length' => 57,
                                                                      'lhs' => 'character class modifiers',
                                                                      'precedence_count' => 1,
                                                                      'start' => 7553
                                                                    },
                             'character class@7139+69' => {
                                                            'length' => 69,
                                                            'lhs' => 'character class',
                                                            'precedence_count' => 1,
                                                            'start' => 7139
                                                          },
                             'completion event declaration@1750+99' => {
                                                                         'length' => 99,
                                                                         'lhs' => 'completion event declaration',
                                                                         'precedence_count' => 1,
                                                                         'start' => 1750
                                                                       },
                             'default rule@1220+60' => {
                                                         'length' => 60,
                                                         'lhs' => 'default rule',
                                                         'precedence_count' => 1,
                                                         'start' => 1220
                                                       },
                             'discard default statement@1351+71' => {
                                                                      'length' => 71,
                                                                      'lhs' => 'discard default statement',
                                                                      'precedence_count' => 1,
                                                                      'start' => 1351
                                                                    },
                             'discard rule@1599+80' => {
                                                         'length' => 80,
                                                         'lhs' => 'discard rule',
                                                         'precedence_count' => 1,
                                                         'start' => 1599
                                                       },
                             'double colon@5843+21' => {
                                                         'length' => 21,
                                                         'lhs' => 'double colon',
                                                         'precedence_count' => 1,
                                                         'start' => 5843
                                                       },
                             'eager specification@3196+48' => {
                                                                'length' => 48,
                                                                'lhs' => 'eager specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3196
                                                              },
                             'empty rule@1471+47' => {
                                                       'length' => 47,
                                                       'lhs' => 'empty rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1471
                                                     },
                             'escaped cc character@7425+51' => {
                                                                 'length' => 51,
                                                                 'lhs' => 'escaped cc character',
                                                                 'precedence_count' => 1,
                                                                 'start' => 7425
                                                               },
                             'event initialization@3689+59' => {
                                                                 'length' => 59,
                                                                 'lhs' => 'event initialization',
                                                                 'precedence_count' => 1,
                                                                 'start' => 3689
                                                               },
                             'event initializer@3749+41' => {
                                                              'length' => 41,
                                                              'lhs' => 'event initializer',
                                                              'precedence_count' => 1,
                                                              'start' => 3749
                                                            },
                             'event initializer@3820+23' => {
                                                              'length' => 23,
                                                              'lhs' => 'event initializer',
                                                              'precedence_count' => 1,
                                                              'start' => 3820
                                                            },
                             'event name@4009+87' => {
                                                       'length' => 87,
                                                       'lhs' => 'event name',
                                                       'precedence_count' => 1,
                                                       'start' => 4009
                                                     },
                             'event specification@3625+63' => {
                                                                'length' => 63,
                                                                'lhs' => 'event specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3625
                                                              },
                             'group association@3033+46' => {
                                                              'length' => 46,
                                                              'lhs' => 'group association',
                                                              'precedence_count' => 1,
                                                              'start' => 3033
                                                            },
                             'hash comment body@5044+42' => {
                                                              'length' => 42,
                                                              'lhs' => 'hash comment body',
                                                              'precedence_count' => 1,
                                                              'start' => 5044
                                                            },
                             'hash comment char@5150+61' => {
                                                              'length' => 61,
                                                              'lhs' => 'hash comment char',
                                                              'precedence_count' => 1,
                                                              'start' => 5150
                                                            },
                             'hash comment@4828+81' => {
                                                         'length' => 81,
                                                         'lhs' => 'hash comment',
                                                         'precedence_count' => 1,
                                                         'start' => 4828
                                                       },
                             'horizontal character@8087+64' => {
                                                                 'length' => 64,
                                                                 'lhs' => 'horizontal character',
                                                                 'precedence_count' => 1,
                                                                 'start' => 8087
                                                               },
                             'inaccessible statement@2044+92' => {
                                                                   'length' => 92,
                                                                   'lhs' => 'inaccessible statement',
                                                                   'precedence_count' => 1,
                                                                   'start' => 2044
                                                                 },
                             'inaccessible treatment@2137+52' => {
                                                                   'length' => 52,
                                                                   'lhs' => 'inaccessible treatment',
                                                                   'precedence_count' => 1,
                                                                   'start' => 2137
                                                                 },
                             'integer@5435+17' => {
                                                    'length' => 17,
                                                    'lhs' => 'integer',
                                                    'precedence_count' => 1,
                                                    'start' => 5435
                                                  },
                             'left association@2941+44' => {
                                                             'length' => 44,
                                                             'lhs' => 'left association',
                                                             'precedence_count' => 1,
                                                             'start' => 2941
                                                           },
                             'lexeme default statement@1281+69' => {
                                                                     'length' => 69,
                                                                     'lhs' => 'lexeme default statement',
                                                                     'precedence_count' => 1,
                                                                     'start' => 1281
                                                                   },
                             'lexeme rule@1680+69' => {
                                                        'length' => 69,
                                                        'lhs' => 'lexeme rule',
                                                        'precedence_count' => 1,
                                                        'start' => 1680
                                                      },
                             'lhs@4214+21' => {
                                                'length' => 21,
                                                'lhs' => 'lhs',
                                                'precedence_count' => 1,
                                                'start' => 4214
                                              },
                             'naming@3899+45' => {
                                                   'length' => 45,
                                                   'lhs' => 'naming',
                                                   'precedence_count' => 1,
                                                   'start' => 3899
                                                 },
                             'negated posix char class@7914+63' => {
                                                                     'length' => 63,
                                                                     'lhs' => 'negated posix char class',
                                                                     'precedence_count' => 1,
                                                                     'start' => 7914
                                                                   },
                             'null adverb@2878+21' => {
                                                        'length' => 21,
                                                        'lhs' => 'null adverb',
                                                        'precedence_count' => 1,
                                                        'start' => 2878
                                                      },
                             'null ranking constant@3458+42' => {
                                                                  'length' => 42,
                                                                  'lhs' => 'null ranking constant',
                                                                  'precedence_count' => 1,
                                                                  'start' => 3458
                                                                },
                             'null ranking specification@3301+78' => {
                                                                       'length' => 78,
                                                                       'lhs' => 'null ranking specification',
                                                                       'precedence_count' => 1,
                                                                       'start' => 3301
                                                                     },
                             'null ranking specification@3380+77' => {
                                                                       'length' => 77,
                                                                       'lhs' => 'null ranking specification',
                                                                       'precedence_count' => 1,
                                                                       'start' => 3380
                                                                     },
                             'null statement@1052+24' => {
                                                           'length' => 24,
                                                           'lhs' => 'null statement',
                                                           'precedence_count' => 1,
                                                           'start' => 1052
                                                         },
                             'nulled event declaration@1850+92' => {
                                                                     'length' => 92,
                                                                     'lhs' => 'nulled event declaration',
                                                                     'precedence_count' => 1,
                                                                     'start' => 1850
                                                                   },
                             'on or off@3791+28' => {
                                                      'length' => 28,
                                                      'lhs' => 'on or off',
                                                      'precedence_count' => 1,
                                                      'start' => 3791
                                                    },
                             'one or more word characters@5592+37' => {
                                                                        'length' => 37,
                                                                        'lhs' => 'one or more word characters',
                                                                        'precedence_count' => 1,
                                                                        'start' => 5592
                                                                      },
                             'op declare bnf@5213+24' => {
                                                           'length' => 24,
                                                           'lhs' => 'op declare bnf',
                                                           'precedence_count' => 1,
                                                           'start' => 5213
                                                         },
                             'op declare match@5238+24' => {
                                                             'length' => 24,
                                                             'lhs' => 'op declare match',
                                                             'precedence_count' => 1,
                                                             'start' => 5238
                                                           },
                             'op declare@2191+54' => {
                                                       'length' => 54,
                                                       'lhs' => 'op declare',
                                                       'precedence_count' => 1,
                                                       'start' => 2191
                                                     },
                             'op equal priority@5282+25' => {
                                                              'length' => 25,
                                                              'lhs' => 'op equal priority',
                                                              'precedence_count' => 1,
                                                              'start' => 5282
                                                            },
                             'op loosen@5263+18' => {
                                                      'length' => 18,
                                                      'lhs' => 'op loosen',
                                                      'precedence_count' => 1,
                                                      'start' => 5263
                                                    },
                             'parenthesized rhs primary list@4385+67' => {
                                                                           'length' => 67,
                                                                           'lhs' => 'parenthesized rhs primary list',
                                                                           'precedence_count' => 1,
                                                                           'start' => 4385
                                                                         },
                             'pause specification@3565+58' => {
                                                                'length' => 58,
                                                                'lhs' => 'pause specification',
                                                                'precedence_count' => 1,
                                                                'start' => 3565
                                                              },
                             'posix char class name@7978+38' => {
                                                                  'length' => 38,
                                                                  'lhs' => 'posix char class name',
                                                                  'precedence_count' => 1,
                                                                  'start' => 7978
                                                                },
                             'posix char class@7859+54' => {
                                                             'length' => 54,
                                                             'lhs' => 'posix char class',
                                                             'precedence_count' => 1,
                                                             'start' => 7859
                                                           },
                             'prediction event declaration@1943+99' => {
                                                                         'length' => 99,
                                                                         'lhs' => 'prediction event declaration',
                                                                         'precedence_count' => 1,
                                                                         'start' => 1943
                                                                       },
                             'priorities@2246+69' => {
                                                       'length' => 69,
                                                       'lhs' => 'priorities',
                                                       'precedence_count' => 1,
                                                       'start' => 2246
                                                     },
                             'priority rule@1423+47' => {
                                                          'length' => 47,
                                                          'lhs' => 'priority rule',
                                                          'precedence_count' => 1,
                                                          'start' => 1423
                                                        },
                             'priority specification@3501+63' => {
                                                                   'length' => 63,
                                                                   'lhs' => 'priority specification',
                                                                   'precedence_count' => 1,
                                                                   'start' => 3501
                                                                 },
                             'proper specification@3145+50' => {
                                                                 'length' => 50,
                                                                 'lhs' => 'proper specification',
                                                                 'precedence_count' => 1,
                                                                 'start' => 3145
                                                               },
                             'quantified rule@1519+79' => {
                                                            'length' => 79,
                                                            'lhs' => 'quantified rule',
                                                            'precedence_count' => 1,
                                                            'start' => 1519
                                                          },
                             'quantifier@5308+24' => {
                                                       'length' => 24,
                                                       'lhs' => 'quantifier',
                                                       'precedence_count' => 1,
                                                       'start' => 5308
                                                     },
                             'rank specification@3245+55' => {
                                                               'length' => 55,
                                                               'lhs' => 'rank specification',
                                                               'precedence_count' => 1,
                                                               'start' => 3245
                                                             },
                             'reserved action name@5470+59' => {
                                                                 'length' => 59,
                                                                 'lhs' => 'reserved action name',
                                                                 'precedence_count' => 1,
                                                                 'start' => 5470
                                                               },
                             'reserved blessing name@5530+61' => {
                                                                   'length' => 61,
                                                                   'lhs' => 'reserved blessing name',
                                                                   'precedence_count' => 1,
                                                                   'start' => 5530
                                                                 },
                             'reserved event name@4097+33' => {
                                                                'length' => 33,
                                                                'lhs' => 'reserved event name',
                                                                'precedence_count' => 1,
                                                                'start' => 4097
                                                              },
                             'result item descriptor list@6398+105' => {
                                                                         'length' => 105,
                                                                         'lhs' => 'result item descriptor list',
                                                                         'precedence_count' => 1,
                                                                         'start' => 6398
                                                                       },
                             'result item descriptor separator@6504+40' => {
                                                                             'length' => 40,
                                                                             'lhs' => 'result item descriptor separator',
                                                                             'precedence_count' => 1,
                                                                             'start' => 6504
                                                                           },
                             'result item descriptor separator@6545+51' => {
                                                                             'length' => 51,
                                                                             'lhs' => 'result item descriptor separator',
                                                                             'precedence_count' => 1,
                                                                             'start' => 6545
                                                                           },
                             'result item descriptor@6597+135' => {
                                                                    'length' => 135,
                                                                    'lhs' => 'result item descriptor',
                                                                    'precedence_count' => 1,
                                                                    'start' => 6597
                                                                  },
                             'rhs primary list@4453+37' => {
                                                             'length' => 37,
                                                             'lhs' => 'rhs primary list',
                                                             'precedence_count' => 1,
                                                             'start' => 4453
                                                           },
                             'rhs primary@4259+33' => {
                                                        'length' => 33,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4259
                                                      },
                             'rhs primary@4293+40' => {
                                                        'length' => 40,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4293
                                                      },
                             'rhs primary@4334+50' => {
                                                        'length' => 50,
                                                        'lhs' => 'rhs primary',
                                                        'precedence_count' => 1,
                                                        'start' => 4334
                                                      },
                             'rhs@4236+22' => {
                                                'length' => 22,
                                                'lhs' => 'rhs',
                                                'precedence_count' => 1,
                                                'start' => 4236
                                              },
                             'right association@2986+46' => {
                                                              'length' => 46,
                                                              'lhs' => 'right association',
                                                              'precedence_count' => 1,
                                                              'start' => 2986
                                                            },
                             'safe cc character@7307+79' => {
                                                              'length' => 79,
                                                              'lhs' => 'safe cc character',
                                                              'precedence_count' => 1,
                                                              'start' => 7307
                                                            },
                             'separator specification@3080+64' => {
                                                                    'length' => 64,
                                                                    'lhs' => 'separator specification',
                                                                    'precedence_count' => 1,
                                                                    'start' => 3080
                                                                  },
                             'sign@5421+13' => {
                                                 'length' => 13,
                                                 'lhs' => 'sign',
                                                 'precedence_count' => 1,
                                                 'start' => 5421
                                               },
                             'signed integer@5373+47' => {
                                                           'length' => 47,
                                                           'lhs' => 'signed integer',
                                                           'precedence_count' => 1,
                                                           'start' => 5373
                                                         },
                             'single quoted name@6955+78' => {
                                                               'length' => 78,
                                                               'lhs' => 'single quoted name',
                                                               'precedence_count' => 1,
                                                               'start' => 6955
                                                             },
                             'single quoted string@6846+108' => {
                                                                  'length' => 108,
                                                                  'lhs' => 'single quoted string',
                                                                  'precedence_count' => 1,
                                                                  'start' => 6846
                                                                },
                             'single symbol@4491+52' => {
                                                          'length' => 52,
                                                          'lhs' => 'single symbol',
                                                          'precedence_count' => 1,
                                                          'start' => 4491
                                                        },
                             'standard name@5959+57' => {
                                                          'length' => 57,
                                                          'lhs' => 'standard name',
                                                          'precedence_count' => 1,
                                                          'start' => 5959
                                                        },
                             'start rule@1120+51' => {
                                                       'length' => 51,
                                                       'lhs' => 'start rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1120
                                                     },
                             'start rule@1172+47' => {
                                                       'length' => 47,
                                                       'lhs' => 'start rule',
                                                       'precedence_count' => 1,
                                                       'start' => 1172
                                                     },
                             'statement group@1077+42' => {
                                                            'length' => 42,
                                                            'lhs' => 'statement group',
                                                            'precedence_count' => 1,
                                                            'start' => 1077
                                                          },
                             'statement@681+369' => {
                                                      'length' => 369,
                                                      'lhs' => 'statement',
                                                      'precedence_count' => 1,
                                                      'start' => 681
                                                    },
                             'statements@655+25' => {
                                                      'length' => 25,
                                                      'lhs' => 'statements',
                                                      'precedence_count' => 1,
                                                      'start' => 655
                                                    },
                             'string without single quote or vertical space@7034+103' => {
                                                                                           'length' => 103,
                                                                                           'lhs' => 'string without single quote or vertical space',
                                                                                           'precedence_count' => 1,
                                                                                           'start' => 7034
                                                                                         },
                             'symbol name@4569+29' => {
                                                        'length' => 29,
                                                        'lhs' => 'symbol name',
                                                        'precedence_count' => 1,
                                                        'start' => 4569
                                                      },
                             'symbol name@4599+34' => {
                                                        'length' => 34,
                                                        'lhs' => 'symbol name',
                                                        'precedence_count' => 1,
                                                        'start' => 4599
                                                      },
                             'symbol@4544+24' => {
                                                   'length' => 24,
                                                   'lhs' => 'symbol',
                                                   'precedence_count' => 1,
                                                   'start' => 4544
                                                 },
                             'terminated hash comment@4910+73' => {
                                                                    'length' => 73,
                                                                    'lhs' => 'terminated hash comment',
                                                                    'precedence_count' => 1,
                                                                    'start' => 4910
                                                                  },
                             'unterminated final hash comment@4984+59' => {
                                                                            'length' => 59,
                                                                            'lhs' => 'unterminated final hash comment',
                                                                            'precedence_count' => 1,
                                                                            'start' => 4984
                                                                          },
                             'vertical space char@5087+62' => {
                                                                'length' => 62,
                                                                'lhs' => 'vertical space char',
                                                                'precedence_count' => 1,
                                                                'start' => 5087
                                                              },
                             'whitespace@4765+18' => {
                                                       'length' => 18,
                                                       'lhs' => 'whitespace',
                                                       'precedence_count' => 1,
                                                       'start' => 4765
                                                     },
                             'zero or more word characters@5630+38' => {
                                                                         'length' => 38,
                                                                         'lhs' => 'zero or more word characters',
                                                                         'precedence_count' => 1,
                                                                         'start' => 5630
                                                                       }
                           },
                  'xsy' => {
                             'Perl identifier' => {
                                                    'dsl_form' => 'Perl identifier',
                                                    'name_source' => 'lexical'
                                                  },
                             'Perl name' => {
                                              'dsl_form' => 'Perl name',
                                              'name_source' => 'lexical'
                                            },
                             '[Lex-0]' => {
                                            'dsl_form' => '\';\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-10]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-11]' => {
                                             'dsl_form' => '\'discard\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-12]' => {
                                             'dsl_form' => '\'default\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-13]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-14]' => {
                                             'dsl_form' => '\':discard\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-15]' => {
                                             'dsl_form' => '\':lexeme\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-16]' => {
                                             'dsl_form' => '\'event\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-17]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-18]' => {
                                             'dsl_form' => '\'completed\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-19]' => {
                                             'dsl_form' => '\'event\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-1]' => {
                                            'dsl_form' => '\'{\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-20]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-21]' => {
                                             'dsl_form' => '\'nulled\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-22]' => {
                                             'dsl_form' => '\'event\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-23]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-24]' => {
                                             'dsl_form' => '\'predicted\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-25]' => {
                                             'dsl_form' => '\'inaccessible\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-26]' => {
                                             'dsl_form' => '\'is\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-27]' => {
                                             'dsl_form' => '\'by\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-28]' => {
                                             'dsl_form' => '\'default\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-29]' => {
                                             'dsl_form' => '\'warn\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-2]' => {
                                            'dsl_form' => '\'}\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-30]' => {
                                             'dsl_form' => '\'ok\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-31]' => {
                                             'dsl_form' => '\'fatal\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-32]' => {
                                             'dsl_form' => '\',\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-33]' => {
                                             'dsl_form' => '\'action\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-34]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-35]' => {
                                             'dsl_form' => '\'assoc\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-36]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-37]' => {
                                             'dsl_form' => '\'left\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-38]' => {
                                             'dsl_form' => '\'assoc\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-39]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-3]' => {
                                            'dsl_form' => '\':start\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-40]' => {
                                             'dsl_form' => '\'right\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-41]' => {
                                             'dsl_form' => '\'assoc\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-42]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-43]' => {
                                             'dsl_form' => '\'group\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-44]' => {
                                             'dsl_form' => '\'separator\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-45]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-46]' => {
                                             'dsl_form' => '\'proper\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-47]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-48]' => {
                                             'dsl_form' => '\'eager\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-49]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-4]' => {
                                            'dsl_form' => '\'start\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-50]' => {
                                             'dsl_form' => '\'rank\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-51]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-52]' => {
                                             'dsl_form' => '\'null-ranking\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-53]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-54]' => {
                                             'dsl_form' => '\'null\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-55]' => {
                                             'dsl_form' => '\'rank\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-56]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-57]' => {
                                             'dsl_form' => '\'low\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-58]' => {
                                             'dsl_form' => '\'high\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-59]' => {
                                             'dsl_form' => '\'priority\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-5]' => {
                                            'dsl_form' => '\'symbol\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-60]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-61]' => {
                                             'dsl_form' => '\'pause\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-62]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-63]' => {
                                             'dsl_form' => '\'event\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-64]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-65]' => {
                                             'dsl_form' => '\'=\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-66]' => {
                                             'dsl_form' => '\'on\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-67]' => {
                                             'dsl_form' => '\'off\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-68]' => {
                                             'dsl_form' => '\'bless\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-69]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-6]' => {
                                            'dsl_form' => '\'is\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-70]' => {
                                             'dsl_form' => '\'name\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-71]' => {
                                             'dsl_form' => '\'=>\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-72]' => {
                                             'dsl_form' => '\'(\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-73]' => {
                                             'dsl_form' => '\')\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-74]' => {
                                             'dsl_form' => '\'*\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-75]' => {
                                             'dsl_form' => '\'+\'',
                                             'name_source' => 'internal'
                                           },
                             '[Lex-7]' => {
                                            'dsl_form' => '\':default\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-8]' => {
                                            'dsl_form' => '\'lexeme\'',
                                            'name_source' => 'internal'
                                          },
                             '[Lex-9]' => {
                                            'dsl_form' => '\'default\'',
                                            'name_source' => 'internal'
                                          },
                             '[[\']]' => {
                                           'dsl_form' => '[\']',
                                           'name_source' => 'internal'
                                         },
                             '[[+-]]' => {
                                           'dsl_form' => '[+-]',
                                           'name_source' => 'internal'
                                         },
                             '[[,]]' => {
                                          'dsl_form' => '[,]',
                                          'name_source' => 'internal'
                                        },
                             '[[01]]' => {
                                           'dsl_form' => '[01]',
                                           'name_source' => 'internal'
                                         },
                             '[[1]]' => {
                                          'dsl_form' => '[1]',
                                          'name_source' => 'internal'
                                        },
                             '[[[:alnum:]]]' => {
                                                  'dsl_form' => '[[:alnum:]]',
                                                  'name_source' => 'internal'
                                                },
                             '[[\\#]]' => {
                                            'dsl_form' => '[\\#]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\(]]' => {
                                            'dsl_form' => '[\\(]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\)]]' => {
                                            'dsl_form' => '[\\)]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\*]]' => {
                                            'dsl_form' => '[\\*]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\+]]' => {
                                            'dsl_form' => '[\\+]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\,]]' => {
                                            'dsl_form' => '[\\,]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\-]]' => {
                                            'dsl_form' => '[\\-]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\:]]' => {
                                            'dsl_form' => '[\\:]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\;]]' => {
                                            'dsl_form' => '[\\;]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\<]]' => {
                                            'dsl_form' => '[\\<]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\=]]' => {
                                            'dsl_form' => '[\\=]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\>]]' => {
                                            'dsl_form' => '[\\>]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\[]]' => {
                                            'dsl_form' => '[\\[]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\\\]]' => {
                                             'dsl_form' => '[\\\\]',
                                             'name_source' => 'internal'
                                           },
                             '[[\\]]]' => {
                                            'dsl_form' => '[\\]]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\^]]' => {
                                            'dsl_form' => '[\\^]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\d]]' => {
                                            'dsl_form' => '[\\d]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\s\\w]]' => {
                                               'dsl_form' => '[\\s\\w]',
                                               'name_source' => 'internal'
                                             },
                             '[[\\s]]' => {
                                            'dsl_form' => '[\\s]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\w]]' => {
                                            'dsl_form' => '[\\w]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                   'dsl_form' => '[\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                   'name_source' => 'internal'
                                                                                 },
                             '[[\\{]]' => {
                                            'dsl_form' => '[\\{]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\|]]' => {
                                            'dsl_form' => '[\\|]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\}]]' => {
                                            'dsl_form' => '[\\}]',
                                            'name_source' => 'internal'
                                          },
                             '[[\\~]]' => {
                                            'dsl_form' => '[\\~]',
                                            'name_source' => 'internal'
                                          },
                             '[[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                   'dsl_form' => '[^\'\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                   'name_source' => 'internal'
                                                                                                 },
                             '[[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]]' => {
                                                                                                        'dsl_form' => '[^\\x{5d}\\x{0A}\\x{0B}\\x{0C}\\x{0D}\\x{0085}\\x{2028}\\x{2029}]',
                                                                                                        'name_source' => 'internal'
                                                                                                      },
                             '[[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]]' => {
                                                                                    'dsl_form' => '[^\\x{A}\\x{B}\\x{C}\\x{D}\\x{2028}\\x{2029}]',
                                                                                    'name_source' => 'internal'
                                                                                  },
                             '[[a-zA-Z]]' => {
                                               'dsl_form' => '[a-zA-Z]',
                                               'name_source' => 'internal'
                                             },
                             '[[a]]' => {
                                          'dsl_form' => '[a]',
                                          'name_source' => 'internal'
                                        },
                             '[[b]]' => {
                                          'dsl_form' => '[b]',
                                          'name_source' => 'internal'
                                        },
                             '[[c]]' => {
                                          'dsl_form' => '[c]',
                                          'name_source' => 'internal'
                                        },
                             '[[d]]' => {
                                          'dsl_form' => '[d]',
                                          'name_source' => 'internal'
                                        },
                             '[[e]]' => {
                                          'dsl_form' => '[e]',
                                          'name_source' => 'internal'
                                        },
                             '[[f]]' => {
                                          'dsl_form' => '[f]',
                                          'name_source' => 'internal'
                                        },
                             '[[g]]' => {
                                          'dsl_form' => '[g]',
                                          'name_source' => 'internal'
                                        },
                             '[[h]]' => {
                                          'dsl_form' => '[h]',
                                          'name_source' => 'internal'
                                        },
                             '[[i]]' => {
                                          'dsl_form' => '[i]',
                                          'name_source' => 'internal'
                                        },
                             '[[k]]' => {
                                          'dsl_form' => '[k]',
                                          'name_source' => 'internal'
                                        },
                             '[[l]]' => {
                                          'dsl_form' => '[l]',
                                          'name_source' => 'internal'
                                        },
                             '[[m]]' => {
                                          'dsl_form' => '[m]',
                                          'name_source' => 'internal'
                                        },
                             '[[n]]' => {
                                          'dsl_form' => '[n]',
                                          'name_source' => 'internal'
                                        },
                             '[[o]]' => {
                                          'dsl_form' => '[o]',
                                          'name_source' => 'internal'
                                        },
                             '[[p]]' => {
                                          'dsl_form' => '[p]',
                                          'name_source' => 'internal'
                                        },
                             '[[r]]' => {
                                          'dsl_form' => '[r]',
                                          'name_source' => 'internal'
                                        },
                             '[[s]]' => {
                                          'dsl_form' => '[s]',
                                          'name_source' => 'internal'
                                        },
                             '[[t]]' => {
                                          'dsl_form' => '[t]',
                                          'name_source' => 'internal'
                                        },
                             '[[u]]' => {
                                          'dsl_form' => '[u]',
                                          'name_source' => 'internal'
                                        },
                             '[[v]]' => {
                                          'dsl_form' => '[v]',
                                          'name_source' => 'internal'
                                        },
                             '[[w]]' => {
                                          'dsl_form' => '[w]',
                                          'name_source' => 'internal'
                                        },
                             '[[x]]' => {
                                          'dsl_form' => '[x]',
                                          'name_source' => 'internal'
                                        },
                             '[[y]]' => {
                                          'dsl_form' => '[y]',
                                          'name_source' => 'internal'
                                        },
                             'action' => {
                                           'dsl_form' => 'action',
                                           'name_source' => 'lexical'
                                         },
                             'action name' => {
                                                'dsl_form' => 'action name',
                                                'name_source' => 'lexical'
                                              },
                             'adverb item' => {
                                                'dsl_form' => 'adverb item',
                                                'name_source' => 'lexical'
                                              },
                             'adverb list' => {
                                                'dsl_form' => 'adverb list',
                                                'name_source' => 'lexical'
                                              },
                             'adverb list items' => {
                                                      'dsl_form' => 'adverb list items',
                                                      'name_source' => 'lexical'
                                                    },
                             'alternative' => {
                                                'dsl_form' => 'alternative',
                                                'name_source' => 'lexical'
                                              },
                             'alternative name' => {
                                                     'dsl_form' => 'alternative name',
                                                     'name_source' => 'lexical'
                                                   },
                             'alternatives' => {
                                                 'dsl_form' => 'alternatives',
                                                 'name_source' => 'lexical'
                                               },
                             'array descriptor' => {
                                                     'dsl_form' => 'array descriptor',
                                                     'name_source' => 'lexical'
                                                   },
                             'array descriptor left bracket' => {
                                                                  'dsl_form' => 'array descriptor left bracket',
                                                                  'name_source' => 'lexical'
                                                                },
                             'array descriptor right bracket' => {
                                                                   'dsl_form' => 'array descriptor right bracket',
                                                                   'name_source' => 'lexical'
                                                                 },
                             'bare name' => {
                                              'dsl_form' => 'bare name',
                                              'name_source' => 'lexical'
                                            },
                             'before or after' => {
                                                    'dsl_form' => 'before or after',
                                                    'name_source' => 'lexical'
                                                  },
                             'blessing' => {
                                             'dsl_form' => 'blessing',
                                             'name_source' => 'lexical'
                                           },
                             'blessing name' => {
                                                  'dsl_form' => 'blessing name',
                                                  'name_source' => 'lexical'
                                                },
                             'boolean' => {
                                            'dsl_form' => 'boolean',
                                            'name_source' => 'lexical'
                                          },
                             'bracketed name' => {
                                                   'dsl_form' => 'bracketed name',
                                                   'name_source' => 'lexical'
                                                 },
                             'bracketed name string' => {
                                                          'dsl_form' => 'bracketed name string',
                                                          'name_source' => 'lexical'
                                                        },
                             'cc element' => {
                                               'dsl_form' => 'cc element',
                                               'name_source' => 'lexical'
                                             },
                             'cc elements' => {
                                                'dsl_form' => 'cc elements',
                                                'name_source' => 'lexical'
                                              },
                             'character class' => {
                                                    'dsl_form' => 'character class',
                                                    'name_source' => 'lexical'
                                                  },
                             'character class modifier' => {
                                                             'dsl_form' => 'character class modifier',
                                                             'name_source' => 'lexical'
                                                           },
                             'character class modifiers' => {
                                                              'dsl_form' => 'character class modifiers',
                                                              'name_source' => 'lexical'
                                                            },
                             'completion event declaration' => {
                                                                 'dsl_form' => 'completion event declaration',
                                                                 'name_source' => 'lexical'
                                                               },
                             'default rule' => {
                                                 'dsl_form' => 'default rule',
                                                 'name_source' => 'lexical'
                                               },
                             'discard default statement' => {
                                                              'dsl_form' => 'discard default statement',
                                                              'name_source' => 'lexical'
                                                            },
                             'discard rule' => {
                                                 'dsl_form' => 'discard rule',
                                                 'name_source' => 'lexical'
                                               },
                             'double colon' => {
                                                 'dsl_form' => 'double colon',
                                                 'name_source' => 'lexical'
                                               },
                             'eager specification' => {
                                                        'dsl_form' => 'eager specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'empty rule' => {
                                               'dsl_form' => 'empty rule',
                                               'name_source' => 'lexical'
                                             },
                             'escaped cc character' => {
                                                         'dsl_form' => 'escaped cc character',
                                                         'name_source' => 'lexical'
                                                       },
                             'event initialization' => {
                                                         'dsl_form' => 'event initialization',
                                                         'name_source' => 'lexical'
                                                       },
                             'event initializer' => {
                                                      'dsl_form' => 'event initializer',
                                                      'name_source' => 'lexical'
                                                    },
                             'event name' => {
                                               'dsl_form' => 'event name',
                                               'name_source' => 'lexical'
                                             },
                             'event specification' => {
                                                        'dsl_form' => 'event specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'group association' => {
                                                      'dsl_form' => 'group association',
                                                      'name_source' => 'lexical'
                                                    },
                             'hash comment' => {
                                                 'dsl_form' => 'hash comment',
                                                 'name_source' => 'lexical'
                                               },
                             'hash comment body' => {
                                                      'dsl_form' => 'hash comment body',
                                                      'name_source' => 'lexical'
                                                    },
                             'hash comment char' => {
                                                      'dsl_form' => 'hash comment char',
                                                      'name_source' => 'lexical'
                                                    },
                             'horizontal character' => {
                                                         'dsl_form' => 'horizontal character',
                                                         'name_source' => 'lexical'
                                                       },
                             'inaccessible statement' => {
                                                           'dsl_form' => 'inaccessible statement',
                                                           'name_source' => 'lexical'
                                                         },
                             'inaccessible treatment' => {
                                                           'dsl_form' => 'inaccessible treatment',
                                                           'name_source' => 'lexical'
                                                         },
                             'integer' => {
                                            'dsl_form' => 'integer',
                                            'name_source' => 'lexical'
                                          },
                             'left association' => {
                                                     'dsl_form' => 'left association',
                                                     'name_source' => 'lexical'
                                                   },
                             'lexeme default statement' => {
                                                             'dsl_form' => 'lexeme default statement',
                                                             'name_source' => 'lexical'
                                                           },
                             'lexeme rule' => {
                                                'dsl_form' => 'lexeme rule',
                                                'name_source' => 'lexical'
                                              },
                             'lhs' => {
                                        'dsl_form' => 'lhs',
                                        'name_source' => 'lexical'
                                      },
                             'naming' => {
                                           'dsl_form' => 'naming',
                                           'name_source' => 'lexical'
                                         },
                             'negated posix char class' => {
                                                             'dsl_form' => 'negated posix char class',
                                                             'name_source' => 'lexical'
                                                           },
                             'null adverb' => {
                                                'dsl_form' => 'null adverb',
                                                'name_source' => 'lexical'
                                              },
                             'null ranking constant' => {
                                                          'dsl_form' => 'null ranking constant',
                                                          'name_source' => 'lexical'
                                                        },
                             'null ranking specification' => {
                                                               'dsl_form' => 'null ranking specification',
                                                               'name_source' => 'lexical'
                                                             },
                             'null statement' => {
                                                   'dsl_form' => 'null statement',
                                                   'name_source' => 'lexical'
                                                 },
                             'nulled event declaration' => {
                                                             'dsl_form' => 'nulled event declaration',
                                                             'name_source' => 'lexical'
                                                           },
                             'on or off' => {
                                              'dsl_form' => 'on or off',
                                              'name_source' => 'lexical'
                                            },
                             'one or more word characters' => {
                                                                'dsl_form' => 'one or more word characters',
                                                                'name_source' => 'lexical'
                                                              },
                             'op declare' => {
                                               'dsl_form' => 'op declare',
                                               'name_source' => 'lexical'
                                             },
                             'op declare bnf' => {
                                                   'dsl_form' => 'op declare bnf',
                                                   'name_source' => 'lexical'
                                                 },
                             'op declare match' => {
                                                     'dsl_form' => 'op declare match',
                                                     'name_source' => 'lexical'
                                                   },
                             'op equal priority' => {
                                                      'dsl_form' => 'op equal priority',
                                                      'name_source' => 'lexical'
                                                    },
                             'op loosen' => {
                                              'dsl_form' => 'op loosen',
                                              'name_source' => 'lexical'
                                            },
                             'parenthesized rhs primary list' => {
                                                                   'dsl_form' => 'parenthesized rhs primary list',
                                                                   'name_source' => 'lexical'
                                                                 },
                             'pause specification' => {
                                                        'dsl_form' => 'pause specification',
                                                        'name_source' => 'lexical'
                                                      },
                             'posix char class' => {
                                                     'dsl_form' => 'posix char class',
                                                     'name_source' => 'lexical'
                                                   },
                             'posix char class name' => {
                                                          'dsl_form' => 'posix char class name',
                                                          'name_source' => 'lexical'
                                                        },
                             'prediction event declaration' => {
                                                                 'dsl_form' => 'prediction event declaration',
                                                                 'name_source' => 'lexical'
                                                               },
                             'priorities' => {
                                               'dsl_form' => 'priorities',
                                               'name_source' => 'lexical'
                                             },
                             'priority rule' => {
                                                  'dsl_form' => 'priority rule',
                                                  'name_source' => 'lexical'
                                                },
                             'priority specification' => {
                                                           'dsl_form' => 'priority specification',
                                                           'name_source' => 'lexical'
                                                         },
                             'proper specification' => {
                                                         'dsl_form' => 'proper specification',
                                                         'name_source' => 'lexical'
                                                       },
                             'quantified rule' => {
                                                    'dsl_form' => 'quantified rule',
                                                    'name_source' => 'lexical'
                                                  },
                             'quantifier' => {
                                               'dsl_form' => 'quantifier',
                                               'name_source' => 'lexical'
                                             },
                             'rank specification' => {
                                                       'dsl_form' => 'rank specification',
                                                       'name_source' => 'lexical'
                                                     },
                             'reserved action name' => {
                                                         'dsl_form' => 'reserved action name',
                                                         'name_source' => 'lexical'
                                                       },
                             'reserved blessing name' => {
                                                           'dsl_form' => 'reserved blessing name',
                                                           'name_source' => 'lexical'
                                                         },
                             'reserved event name' => {
                                                        'dsl_form' => 'reserved event name',
                                                        'name_source' => 'lexical'
                                                      },
                             'result item descriptor' => {
                                                           'dsl_form' => 'result item descriptor',
                                                           'name_source' => 'lexical'
                                                         },
                             'result item descriptor list' => {
                                                                'dsl_form' => 'result item descriptor list',
                                                                'name_source' => 'lexical'
                                                              },
                             'result item descriptor separator' => {
                                                                     'dsl_form' => 'result item descriptor separator',
                                                                     'name_source' => 'lexical'
                                                                   },
                             'rhs' => {
                                        'dsl_form' => 'rhs',
                                        'name_source' => 'lexical'
                                      },
                             'rhs primary' => {
                                                'dsl_form' => 'rhs primary',
                                                'name_source' => 'lexical'
                                              },
                             'rhs primary list' => {
                                                     'dsl_form' => 'rhs primary list',
                                                     'name_source' => 'lexical'
                                                   },
                             'right association' => {
                                                      'dsl_form' => 'right association',
                                                      'name_source' => 'lexical'
                                                    },
                             'safe cc character' => {
                                                      'dsl_form' => 'safe cc character',
                                                      'name_source' => 'lexical'
                                                    },
                             'separator specification' => {
                                                            'dsl_form' => 'separator specification',
                                                            'name_source' => 'lexical'
                                                          },
                             'sign' => {
                                         'dsl_form' => 'sign',
                                         'name_source' => 'lexical'
                                       },
                             'signed integer' => {
                                                   'dsl_form' => 'signed integer',
                                                   'name_source' => 'lexical'
                                                 },
                             'single quoted name' => {
                                                       'dsl_form' => 'single quoted name',
                                                       'name_source' => 'lexical'
                                                     },
                             'single quoted string' => {
                                                         'dsl_form' => 'single quoted string',
                                                         'name_source' => 'lexical'
                                                       },
                             'single symbol' => {
                                                  'dsl_form' => 'single symbol',
                                                  'name_source' => 'lexical'
                                                },
                             'standard name' => {
                                                  'dsl_form' => 'standard name',
                                                  'name_source' => 'lexical'
                                                },
                             'start rule' => {
                                               'dsl_form' => 'start rule',
                                               'name_source' => 'lexical'
                                             },
                             'statement' => {
                                              'dsl_form' => 'statement',
                                              'name_source' => 'lexical'
                                            },
                             'statement group' => {
                                                    'dsl_form' => 'statement group',
                                                    'name_source' => 'lexical'
                                                  },
                             'statements' => {
                                               'dsl_form' => 'statements',
                                               'name_source' => 'lexical'
                                             },
                             'string without single quote or vertical space' => {
                                                                                  'dsl_form' => 'string without single quote or vertical space',
                                                                                  'name_source' => 'lexical'
                                                                                },
                             'symbol' => {
                                           'dsl_form' => 'symbol',
                                           'name_source' => 'lexical'
                                         },
                             'symbol name' => {
                                                'dsl_form' => 'symbol name',
                                                'name_source' => 'lexical'
                                              },
                             'terminated hash comment' => {
                                                            'dsl_form' => 'terminated hash comment',
                                                            'name_source' => 'lexical'
                                                          },
                             'unterminated final hash comment' => {
                                                                    'dsl_form' => 'unterminated final hash comment',
                                                                    'name_source' => 'lexical'
                                                                  },
                             'vertical space char' => {
                                                        'dsl_form' => 'vertical space char',
                                                        'name_source' => 'lexical'
                                                      },
                             'whitespace' => {
                                               'dsl_form' => 'whitespace',
                                               'name_source' => 'lexical'
                                             },
                             'zero or more word characters' => {
                                                                 'dsl_form' => 'zero or more word characters',
                                                                 'name_source' => 'lexical'
                                                               }
                           }
                };
## The code before this line was automatically generated by sl_to_hash.pl

##use critic

    return $hashed_metag;

} ## end sub meta_grammar

1;

# vim: expandtab shiftwidth=4:
