use Test::More;
use PDLA::LiteF;

use strict;
use warnings;

BEGIN {
	eval {
		require PDLA::Fit::Polynomial;
		PDLA::Fit::Polynomial->import();
		1;
	} or plan skip_all => "PDLA::Fit::Polynomial: $@";
}

kill 'INT',$$ if $ENV{UNDER_DEBUGGER}; # Useful for debugging.
plan tests => 1;

my $x = sequence(20)-10;
my $y = 30-2*$x+3*$x**2-2*$x**3;

# Random numbers, generated by  grandom($y)*100
# Hard-wired to avoid OS seed variations barfing test

my $rand = pdl qw/65.735917 -40.510143 -122.07767 -19.591344 -139.76362
106.44639 -0.30094068 -5.3129683  49.815455  97.247868 -9.3130775  
19.585472  8.5260268 -194.49596  73.822799  25.628967  133.36015 -2.6611465  
9.0335632 -0.82946383/;

$y += $rand;

#points $x,$y;

my $yfit = fitpoly1d($x,$y,4);

#hold; line $x, $yfit;

ok(max(abs($y-$yfit)) < 220); # need to add 10 for windows
