package WordList::ID::Common::Wikipedia2500;

our $DATE = '2018-01-01'; # DATE
our $VERSION = '0.004'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"num_words_contains_whitespace",0,"avg_word_len",7.074,"longest_word_len",18,"num_words",2500,"shortest_word_len",2); # STATS

1;
# ABSTRACT: Top 2500 words from Wikipedia Indonesia pages

=pod

=encoding UTF-8

=head1 NAME

WordList::ID::Common::Wikipedia2500 - Top 2500 words from Wikipedia Indonesia pages

=head1 VERSION

This document describes version 0.004 of WordList::ID::Common::Wikipedia2500 (from Perl distribution WordLists-ID-Common), released on 2018-01-01.

=head1 SYNOPSIS

 use WordList::ID::Common::Wikipedia2500;

 my $wl = WordList::ID::Common::Wikipedia2500->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This module contains 2500 most frequently used Indonesian words in Wikipedia
Indonesian pages.

Here's how the list is produced: First the Wikipedia Indonesia's XML.bz2 [1] was
downloaded (last downloaded: Dec 30, 2017). Then a couple of ad-hoc, rather
simplistic Perl scripts were used to process this large file: one script to
split the file to a per-page basis, and the other to strip Wikimedia markup.
All-lowercase words were then extracted from these files and merged to become a
single file. Then the list is curated to get the final {1000,2500,5000} top
words (false positives, misspellings removed).

Note that Wikipedia article pages do not represent general Indonesian text, some
words are overrepresented e.g. "lagu" (in articles about particular songs) or
"filum".

Some words are derivative forms (not-root words), e.g. "makanannya" or
"berdasarkan".

The order of the words in this wordlist is asciibetical, as required by the
L<WordList> convention. If you want to know the ranks of words by frequency, as
well as the scripts used to generate the result, see the C<devscripts/> and
C<work/> directories in the Git repository.

[1] https://id.wikipedia.org/wiki/Wikipedia:Wikipedia_bahasa_Indonesia_versi_luring

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 7.074 |
 | longest_word_len                 | 18    |
 | num_words                        | 2500  |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-ID-Common>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-ID-Common>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-ID-Common>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018, 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
abad
abu
acara
ada
adalah
adanya
adaptasi
adat
adegan
adik
adiknya
administrasi
administratif
agak
agama
agar
agen
agresif
agung
ah
ahli
air
ajang
ajaran
akademik
akan
akar
akhir
akhirnya
akibat
aksara
akses
aksi
aktif
aktivis
aktivitas
aktor
aktris
aku
akun
alam
alamat
alami
alasan
alat
album
alias
alih
aliran
alternatif
aman
amat
anak
anaknya
analisis
ancaman
anda
aneh
anggaran
anggota
anggotanya
anggur
angin
angka
angkasa
angkatan
angkutan
animasi
anjing
antar
antara
antaranya
anti
apa
apabila
apakah
apapun
api
aplikasi
arah
area
armada
arsip
arsitektur
arti
artikel
artinya
artis
arus
asal
asam
asing
asisten
asli
aslinya
aspek
asteroid
atap
atas
atau
ataupun
atlet
atmosfer
atom
aturan
audio
audisi
awak
awal
awalnya
ayah
ayahnya
ayam
ayat
babak
baca
badan
bagaimana
bagi
bagian
bagus
bahan
bahasa
bahkan
bahwa
baik
baja
baju
bakal
bakar
bakat
bakteri
baku
balap
balapan
balik
ban
band
bandar
bandara
bangsa
bangsawan
bangunan
banjir
bank
bantuan
banyak
banyaknya
bar
barang
barat
baris
baru
basis
batang
batas
batu
batuan
bawah
bayi
bebas
beberapa
beda
begitu
bekas
bekerja
belajar
belakang
belakangan
belas
beliau
belum
benar
bencana
benda
bendera
benteng
bentuk
benua
berada
beragam
beragama
berakhir
beralih
berangkat
berani
berarti
berasal
berat
berbagai
berbagi
berbahasa
berbahaya
berbasis
berbatasan
berbeda
berbentuk
berbicara
berdarah
berdasarkan
berdiri
berdirinya
berdua
berencana
berfokus
berfungsi
bergabung
berganti
bergantung
bergelar
bergerak
berguna
berhak
berharap
berharga
berhasil
berhenti
berhubungan
berikut
berikutnya
berisi
berita
berjalan
berjarak
berjuang
berjudul
berjumlah
berkaitan
berkarier
berkas
berkat
berkata
berkebangsaan
berkedudukan
berkembang
berkewarganegaraan
berkisar
berkompetisi
berkontribusi
berkuasa
berkumpul
berkurang
berlaku
berlangsung
berlanjut
berlokasi
bermain
bernama
beroperasi
berpartisipasi
berpendapat
berpengaruh
berperan
berperang
berpikir
berpindah
berpori
berpusat
bersaing
bersama
bersamaan
bersangkutan
bersatu
bersaudara
bersejarah
bersenjata
bersifat
bersih
bertahan
bertambah
bertanggung
bertanya
bertarung
bertelur
bertemu
bertentangan
bertindak
bertugas
bertujuan
berturut
berubah
berukuran
berulang
berumur
berupa
berupaya
berusaha
berusia
bervariasi
berwarna
besar
besaran
besarnya
beserta
besi
betina
biara
biasa
biasanya
biaya
bicara
bidang
biji
bila
bilangan
binatang
bintang
biografi
bioskop
biru
bisa
bisnis
bit
bita
blok
blokir
bola
boleh
bom
buah
buat
buatan
budak
budaya
bukan
bukanlah
bukit
bukti
buku
bukunya
bulan
bulat
bulu
bumi
bunga
bunuh
bunyi
bupati
buruh
buruk
burung
bus
cabang
cadangan
cahaya
cairan
calon
campuran
candi
cantik
cara
cat
catatan
cedera
cenderung
cepat
cerita
cetak
cincin
cinta
ciri
cita
coba
cocok
coklat
contoh
contohnya
cuaca
cucu
cukup
daerah
daftar
dagang
daging
dahulu
dalam
dalamnya
damai
dampak
dan
dana
danau
dapat
darah
darat
daratan
dari
daripada
dasar
dasarnya
data
datang
dataran
daun
daya
debut
debutnya
definisi
dekade
dekat
delapan
demi
demikian
demokrasi
dengan
dengannya
depan
departemen
derajat
desa
desain
detail
detik
dewa
dewan
dewasa
dewi
di
dia
diadakan
diajukan
diakses
diakui
dialek
diam
diambil
dianggap
diangkat
dianugerahi
diatur
dibaca
dibagi
dibanding
dibandingkan
dibangun
dibantu
dibatasi
dibawa
dibawakan
dibebaskan
dibedakan
dibeli
dibentuk
diberi
diberikan
dibesarkan
dibintangi
dibuat
dibuka
dibunuh
dibutuhkan
dicapai
dicatat
dicetak
diciptakan
didasarkan
didefinisikan
didirikan
diduga
didukung
digambarkan
diganti
digantikan
digelar
digital
digunakan
dihancurkan
dihapus
diharapkan
dihasilkan
dihentikan
dihitung
dihukum
dihuni
diikuti
diisi
dijadikan
dijalankan
dijelaskan
dijual
dijuluki
dijumpai
dikaitkan
dikalahkan
dikarenakan
dikatakan
dikelilingi
dikelola
dikeluarkan
dikembangkan
dikenakan
dikenal
diketahui
dikirim
dikuasai
dilahirkan
dilaksanakan
dilakukan
dilanjutkan
dilantik
dilaporkan
dilarang
dilengkapi
diletakkan
dilihat
diluncurkan
dimainkan
dimakamkan
dimakan
dimaksud
dimaksudkan
dimana
dimanfaatkan
dimasukkan
dimensi
dimiliki
diminta
dimulai
dinamai
dinamakan
dinasti
dinding
dingin
dinilai
dinominasikan
dinyanyikan
dinyatakan
dioperasikan
dipakai
dipaksa
dipandang
dipanggil
dipasang
dipegang
dipengaruhi
diperankan
diperbolehkan
dipercaya
dipergunakan
diperkenalkan
diperkirakan
diperlukan
diperoleh
dipilih
dipimpin
dipindahkan
dipisahkan
diproduksi
dipublikasikan
dirancang
direkam
direktur
direncanakan
diresmikan
diri
dirilis
dirinya
disajikan
disampaikan
disebabkan
disebut
disebutkan
disediakan
diselenggarakan
diselesaikan
diserahkan
diserang
disertai
disetujui
disiarkan
disimpan
disingkat
diskusi
distribusi
distrik
disunting
disusun
disutradarai
ditambah
ditambahkan
ditampilkan
ditandai
ditandatangani
ditangkap
ditayangkan
ditebang
ditempatkan
ditempuh
ditemui
ditemukan
ditentukan
diterapkan
diterbitkan
diterima
diterjemahkan
ditetapkan
ditinggalkan
ditinjau
ditolak
ditugaskan
ditujukan
ditulis
ditunjuk
diturunkan
ditutup
diubah
diumumkan
divisi
diyakini
doa
dokter
dokumen
dokumenter
domestik
dominan
dosa
dosen
drama
drum
dua
duduk
dukungan
dulu
dulunya
dunia
dusun
edisi
edit
editor
efek
efektif
ekonomi
ekor
eksekutif
ekspedisi
elektron
elektronik
elemen
emas
empat
enam
energi
engkau
episode
era
erat
etnis
fakta
faktor
fakultas
famili
fase
fasilitas
fenomena
festival
fiksi
film
filsafat
filum
final
fisik
fisika
fitur
fokus
form
formal
formasi
format
forum
foto
frekuensi
fungsi
gabungan
gadis
gagal
gagasan
gambar
ganda
gangguan
ganti
garam
garis
gas
gaya
gedung
gejala
gelap
gelar
gelombang
gempa
gen
generasi
genre
genus
geografis
gerak
gerakan
gerbang
gereja
gigi
gitar
global
gol
golongan
gratis
grup
gua
gubernur
gugur
gula
guna
gunakan
gunung
guru
habis
habitatnya
hadapan
hadiah
hadir
hak
hakim
hal
halaman
halnya
halus
hampir
hancur
hanya
hanyalah
harapan
harga
hari
harian
harinya
harta
harus
hasil
hasilnya
hati
hebat
hendak
hewan
hiburan
hidup
hidupnya
hijau
hilang
hingga
historis
hitam
hotel
hubungan
hubungannya
hujan
hukum
hukuman
huruf
hutan
ia
ialah
ibadah
ibu
ibukota
ibunya
ide
identitas
ikan
ikatan
iklan
iklim
ikut
ilmiah
ilmu
ilmuwan
imam
iman
indah
independen
individu
indonesia
induk
industri
infeksi
informasi
ingin
ini
inilah
insiden
insting
institusi
instrumen
interaksi
internal
internasional
internet
interview
inti
investasi
ion
isi
isinya
istana
istilah
istimewa
istri
istrinya
isu
item
itu
itulah
izin
jabatan
jabatannya
jadi
jadwal
jahat
jalan
jalur
jam
jangan
jangka
jantan
jantung
jarak
jarang
jari
jaringan
jasa
jatuh
jauh
jawa
jawab
jawaban
jelas
jemaat
jembatan
jenderal
jenis
jenjang
jika
jiwa
juara
judul
juga
julukan
jumlah
juniornya
juri
jurusan
justru
juta
kabar
kabel
kabupaten
kabur
kaca
kadang
kadar
kain
kaisar
kakak
kakaknya
kaki
kala
kalah
kalangan
kalau
kali
kalian
kalimat
kalinya
kamar
kamera
kami
kamp
kampanye
kampung
kampus
kamu
kan
kanan
kandang
kandidat
kandungan
kantor
kapal
kapasitas
karakter
karakteristik
karbon
karena
karier
kariernya
kartu
karya
karyanya
karyawan
kasar
kasih
kasus
kata
kategori
kaum
kawan
kawasan
kaya
kayu
ke
keadaan
keagamaan
keahlian
keamanan
kebakaran
kebanyakan
kebebasan
kebenaran
keberadaan
keberhasilan
kebiasaan
kebijakan
kebudayaan
kebun
kebutuhan
kecamatan
kecelakaan
kecepatan
kecil
kecuali
kedatangan
kedua
keduanya
kedudukan
keempat
keenam
kegagalan
kegiatan
kehadiran
kehidupan
kehilangan
kehormatan
keinginan
kejadian
kejahatan
keju
kejuaraan
kekaisaran
kekalahan
kekayaan
kekerasan
kekuasaan
kekuatan
kekurangan
kelahiran
kelak
kelapa
kelas
kelima
kelompok
keluar
keluarga
keluarganya
kelurahan
kemajuan
kemampuan
kematian
kematiannya
kembali
kembar
kemenangan
kemerdekaan
kemudian
kemungkinan
kendali
kendaraan
kepada
kepadanya
kepadatan
kepala
kepemilikan
kepemimpinan
kepentingan
kepercayaan
keperluan
kepulauan
keputusan
kerajaan
kerap
keras
kereta
kering
kerja
kerjasama
kertas
kerusakan
kesadaran
kesalahan
kesatuan
kesehatan
keselamatan
keseluruhan
kesempatan
kesenian
kesepakatan
kesuksesan
kesulitan
ketat
ketentuan
keterangan
ketertarikan
ketiga
ketika
ketinggian
ketua
ketujuh
keturunan
keuangan
keuntungan
keyakinan
khas
khusus
khususnya
kilometer
kimia
kinerja
kini
kira
kiri
kisah
kita
kitab
klaim
klan
klasik
klub
kode
kolam
koleksi
kolom
koloni
kolonial
komandan
komando
kombinasi
komedi
komentar
komersial
komik
kompas
kompetisi
kompilasi
kompleks
komponen
komposisi
komputer
komune
komunikasi
komunis
komunitas
kondisi
konferensi
konflik
konsentrasi
konsep
konser
konstruksi
konsumen
kontak
konteks
konten
kontes
kontestan
kontrak
kontribusi
kontrol
kopi
koran
korban
kosong
kota
kotak
krisis
kriteria
kritik
kritikus
kritis
kualifikasi
kualitas
kuat
kucing
kuda
kue
kuil
kuliah
kulit
kumbang
kumpulan
kunci
kuning
kunjungan
kuno
kurang
kurangnya
kursi
laba
label
laboratorium
lagi
lagu
lah
lahan
lahir
lain
lainnya
laki
lakukan
lalat
lalu
lama
lamanya
lambang
lambat
lampu
landasan
langit
langkah
langsung
lanjut
lanjutan
lantai
lapangan
lapisan
laporan
larva
latar
latihan
laut
lawan
layak
layanan
layar
lebar
lebih
legenda
lelaki
leluhur
lemah
lembab
lembaga
lembah
lembap
lengkap
lepas
les
letaknya
level
lewat
liar
liga
lihat
lima
lingkaran
lingkungan
links
lintas
lirik
lisensi
listrik
logam
logo
lokal
lokasi
lokomotif
lolos
lomba
luar
luas
lubang
luka
lukisan
lulus
lulusan
lunak
lurus
maaf
macam
mahal
mahasiswa
mahkota
main
majalah
maju
maka
makam
makan
makanan
makanannya
makhluk
makin
makna
maksimum
maksud
malah
malam
mampu
mana
manajemen
manajer
mandiri
manga
manis
mantan
manusia
map
marah
marga
markas
masa
masakan
masalah
masih
masing
masjid
maskapai
massa
masuk
masyarakat
mata
matahari
matematika
materi
material
mati
mau
maupun
mayoritas
medali
medan
media
medis
mekanisme
melahirkan
melainkan
melaju
melaksanakan
melakukan
melakukannya
melalui
melambangkan
melanggar
melanjutkan
melaporkan
melarang
melarikan
melawan
melayani
melebihi
melepaskan
melewati
melibatkan
melihat
melindungi
melintasi
meliputi
meluncurkan
memahami
memainkan
memakai
memakan
memaksa
memandang
memanfaatkan
memang
memanggil
memastikan
memasuki
memasukkan
membaca
membagi
membahas
membangun
membantu
membawa
membawakan
membayar
membebaskan
membedakan
membela
membeli
membentang
membentuk
memberi
memberikan
membintangi
membuat
membuatnya
membuka
membuktikan
membunuh
membutuhkan
memegang
memenangi
memenangkan
memengaruhi
memenuhi
memerankan
memerintah
memerintahkan
memerlukan
memicu
memilih
memiliki
memimpin
memindahkan
meminta
memisahkan
mempelajari
mempengaruhi
memperbaiki
memperkenalkan
memperkuat
memperlihatkan
memperluas
memperoleh
mempersiapkan
mempertahankan
memproduksi
mempromosikan
mempunyai
memuat
memulai
memungkinkan
memutuskan
menahan
menaklukkan
menambah
menambahkan
menampilkan
menampung
menandai
menandakan
menandatangani
menang
menangani
menangkap
menara
menarik
menawarkan
mencakup
mencapai
mencari
mencatat
mencegah
menceritakan
mencetak
menciptakan
mencoba
mendapat
mendapatkan
mendarat
mendekati
mendengar
menderita
mendirikan
mendorong
menduduki
mendukung
menegaskan
menekan
menekankan
menempati
menempatkan
menempuh
menemui
menemukan
menengah
menentang
menentukan
menerapkan
menerbitkan
menerima
menerus
meneruskan
menetap
menetapkan
mengacu
mengadakan
mengajak
mengajar
mengajarkan
mengajukan
mengakhiri
mengakibatkan
mengaku
mengakui
mengalahkan
mengalami
mengalir
mengambil
mengandung
menganggap
mengangkat
mengapa
mengarah
mengatakan
mengatasi
mengatur
mengebor
mengejar
mengelola
mengeluarkan
mengembalikan
mengembangkan
mengenai
mengenakan
mengenal
mengendalikan
mengetahui
menggabungkan
menggambarkan
mengganggu
mengganti
menggantikan
menggunakan
menghabiskan
menghadap
menghadapi
menghadiri
menghancurkan
menghapus
menghasilkan
menghentikan
menghilangkan
menghindari
menghormati
menghubungkan
mengikuti
mengingat
menginginkan
mengirim
mengirimkan
mengisahkan
mengisi
mengizinkan
mengklaim
mengoperasikan
menguasai
mengubah
mengumpulkan
mengumumkan
mengundang
mengundurkan
mengungkapkan
mengunjungi
mengurangi
mengusulkan
menikah
menikahi
menikmati
menimbulkan
meninggal
meninggalkan
meningkat
meningkatkan
menit
menjabat
menjadi
menjadikan
menjadikannya
menjaga
menjalani
menjalankan
menjalin
menjawab
menjelang
menjelaskan
menjual
menolak
menonjol
menteri
menuju
menulis
menuliskan
menunggu
menunjuk
menunjukkan
menuntut
menurun
menurunkan
menurut
menutup
menyadari
menyaksikan
menyampaikan
menyanyi
menyanyikan
menyatakan
menyebabkan
menyebar
menyebarkan
menyebut
menyebutkan
menyebutnya
menyediakan
menyelamatkan
menyelenggarakan
menyelesaikan
menyerah
menyerahkan
menyerang
menyerap
menyerupai
menyetujui
menyimpan
menyukai
menyunting
menyusun
merah
meraih
merasa
merayakan
merdeka
merebut
merek
mereka
merekam
merilis
merujuk
merupakan
merusak
mesin
meski
meskipun
meter
metode
mewakili
mil
miliar
milik
militer
minat
mineral
minggu
mini
minimal
minum
minuman
minyak
mirip
misalnya
misi
miskin
mobil
modal
mode
model
modern
mohon
molekul
monarki
moral
motor
muatan
muda
mudah
muka
mula
mulai
mulanya
mulut
muncul
munculnya
mundur
mungkin
munisipalitas
murah
murid
murni
museum
musik
musim
musisi
muslim
musuh
nabi
nada
naik
nama
namanya
namun
nanti
nantinya
nasa
nasional
naskah
nebula
negara
negatif
negeri
nenek
nilai
nominasi
nomor
normal
novel
nuklir
nusa
nyata
obat
objek
oksigen
olahraga
oleh
operasi
operator
orang
orbit
order
ordo
organ
organik
organisasi
organisme
original
otak
otomatis
otoritas
pabrik
pada
padang
padat
padi
pagi
paham
pahlawan
pajak
pakaian
pakar
paket
paling
pameran
panas
pandang
pandangan
pangan
pangeran
panggilan
panggung
pangkat
panjang
pantai
papan
para
parah
parameter
pariwisata
parlemen
partai
partikel
paruh
pasal
pasang
pasangan
pasar
pasca
pasien
pasir
pasti
pasukan
pasukannya
patung
pecah
pecahan
pedagang
pedang
pegawai
pegunungan
pejabat
pejuang
pekan
pekerja
pekerjaan
pelabuhan
pelajar
pelajaran
pelaksanaan
pelaku
pelanggan
pelanggaran
pelatih
pelatihan
pelayanan
pelindung
pelukis
peluncuran
peluru
pemahaman
pemain
pemakaman
pemandangan
pembaca
pembagian
pembalap
pembangunan
pembawa
pembelajaran
pembentukan
pemberian
pemberontak
pemberontakan
pembicaraan
pembuat
pembuatan
pembuka
pembukaan
pembunuhan
pemegang
pemekaran
pemenang
pemeran
pemerintah
pemerintahan
pemerintahannya
pemikiran
pemilihan
pemilik
pemilu
pemimpin
pemuda
pemukiman
pemungutan
penambahan
penampilan
penari
pencarian
pencipta
pendapat
pendapatan
pendek
pendekatan
pendeta
pendidikan
pendiri
pendirian
penduduk
pendudukan
penduduknya
pendukung
peneliti
penelitian
penemuan
penerbangan
penerbit
penerima
pengadilan
pengakuan
pengalaman
pengambilan
penganut
pengarang
pengaruh
pengawasan
pengelolaan
pengembangan
pengertian
pengetahuan
pengganti
penggemar
pengguna
penggunaan
penghapusan
penghargaan
pengikut
pengobatan
penguasa
pengunjung
pengurus
pengusaha
peninggalan
peningkatan
penjaga
penjara
penjelasan
penjualan
penonton
pensiun
penting
penuh
penulis
penulisan
penumpang
penurunan
penutup
penyair
penyakit
penyanyi
penyebab
penyebaran
penyelenggaraan
penyimpanan
peperangan
peradaban
perahu
perairan
perak
peralatan
peran
perang
perangkat
perannya
perasaan
peraturan
perawatan
perayaan
perbaikan
perbatasan
perbedaan
perbuatan
percaya
percobaan
perdagangan
perdamaian
perdana
perekonomian
perempuan
perencanaan
perfilman
pergerakan
pergi
perguruan
perhatian
perhitungan
perilaku
peringatan
peringkat
perintah
periode
peristiwa
perjalanan
perjanjian
perjuangan
perkawinan
perkebunan
perkembangan
perlawanan
perlindungan
perlu
permainan
permanen
permasalahan
permintaan
permohonan
permukaan
permukiman
pernah
pernikahan
pernyataan
perpustakaan
pers
persamaan
persegi
persen
persetujuan
persiapan
personel
pertahanan
pertama
pertamanya
pertandingan
pertanian
pertanyaan
pertarungan
pertempuran
pertemuan
pertengahan
pertumbuhan
pertunjukan
perubahan
perusahaan
perwakilan
perwira
pesan
pesantren
pesat
pesawat
peserta
pesisir
pesta
peta
petani
petugas
petunjuk
piano
pihak
pikiran
pilihan
pilot
pimpinan
pindah
pinggiran
pinjaman
pintu
planet
plat
platform
pohon
poin
pokok
pola
polisi
politik
politikus
pop
populasi
populer
portal
pos
posisi
positif
potensi
potongan
prajurit
praktik
pranala
prasasti
predator
presiden
prestasi
pria
pribadi
primordial
prinsip
pro
produk
produksi
produsen
produser
profesional
profesor
profil
program
promosi
properti
proses
protein
protes
provinsi
proyek
publik
puisi
pukul
pula
pulang
pulau
puluh
pun
puncak
punya
pusat
pustaka
putaran
putera
putih
putra
putranya
putri
radar
radio
radius
rahasia
raja
raksasa
rakyat
rambut
rancangan
rangka
rangkaian
rapat
ras
rasa
rata
ratu
ratusan
raya
reaksi
referensi
reformasi
region
regional
rekaman
rekan
rekor
rel
relatif
remaja
rencana
rendah
resmi
restoran
review
revisi
revolusi
ribu
ribuan
rilis
ringan
rintisan
riset
risiko
ritual
riwayat
roda
roh
roket
ruang
ruangan
rudal
rujukan
rumah
rumahnya
rumput
rupa
rusak
rute
saat
sadar
sah
sahabat
saham
saja
sakit
saksi
salah
saling
saluran
sama
sambil
sampai
samping
sana
sang
sangat
sapi
sarana
sarjana
sasaran
sastra
satelit
satu
satuan
satunya
saudara
saudaranya
sawah
saya
sayap
sebab
sebagai
sebagaimana
sebagainya
sebagian
sebaliknya
sebanyak
sebelah
sebelum
sebelumnya
sebenarnya
sebesar
sebuah
sebut
sebutan
secara
sedang
sedangkan
sederhana
sedikit
seekor
segala
segera
segi
sehari
seharusnya
sehat
sehingga
seiring
sejak
sejarah
sejarawan
sejauh
sejenis
sejumlah
sekali
sekaligus
sekarang
sekelompok
sekitar
sekitarnya
sekolah
seksual
sektor
sekutu
sel
selain
selalu
selama
selamat
selanjutnya
selatan
selesai
seluas
seluler
seluruh
seluruhnya
semacam
semakin
semangat
sembilan
semenjak
sementara
semesta
semi
seminggu
semiperairan
sempat
sempurna
semua
semuanya
semula
senang
senapan
sendiri
sengaja
seni
seniman
senior
seniornya
senjata
sensus
senyawa
seorang
sepak
sepanjang
sepeda
sepenuhnya
seperti
sepuluh
serangan
serangga
serangkaian
seri
serial
sering
seringkali
serius
serta
serupa
server
sesama
seseorang
sesi
sesuai
sesuatu
sesudah
sesungguhnya
set
setahun
setara
setelah
setempat
setengah
setia
setiap
setidaknya
setuju
sewaktu
si
siang
siap
siapa
siaran
sifat
signifikan
sikap
simbol
sinar
sinetron
singel
singkat
singkatan
sini
sinyal
sipil
sisa
sisi
sistem
siswa
situ
situasi
situs
skala
skenario
skor
soal
solo
sosial
sosok
spesies
spesifik
spons
stabil
stadion
staf
standar
start
stasiun
status
strategi
strategis
string
struktur
studi
studio
suami
suaminya
suara
suasana
suatu
suci
sudah
sudut
suhu
suka
sukses
suku
sulit
sumber
sungai
sungguh
suntingan
supaya
surat
susu
susunan
sutradara
swasta
syarat
tabel
tahan
tahanan
tahap
tahta
tahu
tahun
tahunan
tahunnya
tajam
tak
takhta
takut
taman
tambahan
tampak
tampaknya
tampil
tamu
tanah
tanaman
tanda
tangan
tangga
tanggal
tanggung
tank
tanpa
tantangan
tapi
target
tari
tarian
tata
tayang
teater
tebal
teh
tekanan
teknik
teknis
teknologi
teks
telah
telepon
televisi
telur
tema
teman
temannya
tembok
tempat
templat
tempo
tempur
tenaga
tengah
tenggara
tentang
tentara
tentu
teori
tepat
tepatnya
tepi
terakhir
terang
terbagi
terbaik
terbakar
terbang
terbanyak
terbaru
terbatas
terbentuk
terbesar
terbit
terbuat
terbuka
terbukti
terbunuh
tercatat
terdaftar
terdapat
terdekat
terdiri
tergabung
tergantung
tergolong
terhadap
terhubung
terima
terjadi
terjadinya
terjemahan
terjual
terjun
terkadang
terkait
terkemuka
terkena
terkenal
terlalu
terlebih
terletak
terlibat
terlihat
terluka
termasuk
terminal
ternyata
terpaksa
terpilih
terpisah
tersebar
tersebut
tersedia
tersendiri
tersisa
tertarik
tertentu
tertinggi
tertua
tertulis
tertutup
terus
terutama
tes
tetangga
tetap
tetapi
tewas
tiang
tiap
tiba
tidak
tidur
tiga
tiket
tim
timbul
timur
tindakan
tinggal
tinggi
tingkat
tipe
tipis
titik
toko
tokoh
tombol
ton
topik
total
tradisi
tradisional
trans
transfer
transportasi
tua
tuan
tuanya
tubuh
tubuhnya
tuduhan
tugas
tujuan
tujuh
tukang
tulang
tulis
tulisan
tumbuh
tumbuhan
tunggal
tuntutan
tur
turnamen
turun
turut
uang
ubah
udara
uji
ujian
ujung
ukuran
ulama
ulang
ular
umat
umum
umumnya
umur
undang
undangan
unggulan
unik
unit
universitas
unsur
untuk
upacara
upaya
urusan
urutan
usaha
usia
uskup
usul
usulan
utama
utamanya
utara
utusan
varian
variasi
versi
vertikal
via
video
virus
visual
vokal
vokalis
volume
wadah
wafat
wajah
wajib
wakil
waktu
walaupun
wali
wanita
warga
warisan
warna
wartawan
wawancara
web
wilayah
wilayahnya
wisata
wisatawan
wujud
ya
yaitu
yakin
yakni
yang
zaman
zat
zona
