package Lingua::IN::R::TGC;
#use Indic::Base;
use Moose::Role;
use utf8;
use v5.22;
use experimentals;
use Function::Parameters;


# ar hash is written according to http://unicode.org/charts
# each key in the hash is a combination of a consonant and the virama
# please send me a message if you find something to change

# suported scripts are telugu, kannada , tamil, malayalam, devanagari, oriya, gujarati, gurmukhi, bengali
# to support other scripts, combine each consonant with virama, add them to the hash

has 'ar' => (
  is      => 'ro',
  isa     => 'HashRef',
  default => sub { return {క్ => 1, ఖ్ => 1, గ్ => 1, ఘ్ => 1, ఙ్ => 1,  చ్ => 1,  ఛ్ => 1,  జ్ => 1,  ఝ్ => 1, ఞ్ => 1, ట్ => 1, ఠ్ => 1, డ్ => 1,
                           ఢ్ => 1, ణ్ => 1, త్ => 1, థ్ => 1, ద్ => 1, ధ్ => 1, న్ => 1, ప్ => 1, ఫ్ => 1, బ్ => 1, భ్ => 1, మ్ => 1, య్ => 1, ర్ => 1,
                           ఱ్ => 1, ల్ => 1, ళ్ => 1, వ్ => 1, శ్ => 1, ష్ => 1, స్ => 1, హ్ => 1, ಕ್ => 1, ಖ್ => 1, ಗ್ => 1, ಘ್ => 1, ಙ್ => 1,
                           ಚ್ => 1, ಛ್ => 1, ಜ್ => 1, ಝ್ => 1, ಞ್ => 1, ಟ್ => 1, ಠ್ => 1, ಡ್ => 1, ಢ್ => 1, ಣ್ => 1, ತ್ => 1, ಥ್ => 1,
                           ದ್ => 1, ಧ್ => 1, ನ್ =>1, ಪ್ =>1 ,ಫ್ => 1, ಬ್ =>1, ಭ್ =>1, ಮ್ =>1, ಯ್ => 1, ರ್ =>1, ಱ್ => 1, ಲ್ => 1, ಳ್ => 1,
                           ವ್ => 1, ಶ್ => 1, ಷ್ =>1, ಸ್ =>1, ಹ್ => 1 , क् => 1, ख् => 1, ग् => 1, घ् => 1, ङ् => 1, च् => 1, छ् => 1, ज् => 1,
                           झ् => 1, ञ् => 1, ट् => 1, ठ् => 1, ड् => 1, ढ् => 1, ण् => 1, त् => 1,  थ्=> 1, द् => 1, ध् => 1, न् => 1, प् => 1,
                           फ् => 1, ब् => 1, भ् => 1, म् => 1, य् => 1, र् => 1, ऱ् => 1, ल् => 1,  व् => 1, श् => 1, ष् => 1, स् => 1, ह्=> 1, ळ् => 1,
                           ক্ => 1, খ্=> 1,  গ্=> 1, ঘ্ => 1, ঙ্=> 1, চ্ => 1, ছ্=> 1,  জ্ => 1, ঝ্ => 1, ঞ্ => 1, ট্ => 1, ঠ্ => 1, ড্ => 1,
                           ঢ্ => 1, ণ্ => 1,  ত্=> 1, থ্ => 1, দ্ => 1, ধ্ => 1, ন্ => 1, প্ => 1, ফ্ => 1, ব্ => 1, ভ্ => 1, ম্=> 1, য্ => 1, র্ => 1,
                           ল্ => 1, শ্ => 1, ষ্=> 1, স্=> 1,  হ্ => 1, ક્=> 1,  ખ્ => 1, ગ્ => 1, ઘ્ => 1, ઙ્ => 1, ચ્ => 1, છ્ => 1, જ્ => 1, ઝ્ => 1,
                           ઞ્ => 1, ટ્ => 1, ઠ્ => 1, ડ્ => 1, ઢ્ => 1, ણ્ => 1, ત્ => 1, થ્ => 1, દ્ => 1, ધ્ => 1, ન્ => 1, પ્ => 1, ફ્=> 1,  બ્ => 1,
                           ભ્ => 1,  મ્=> 1,  ય્=> 1, ર્=> 1,  લ્ => 1, વ્ => 1, શ્ => 1, ષ્ => 1, સ્ => 1, હ્ => 1, ળ્ => 1,
                           ਕ੍ => 1, ਖ੍ => 1, ਗ੍ => 1, ਘ੍ => 1, ਙ੍ => 1,  ਚ੍ => 1, ਛ੍ => 1,  ਜ੍ => 1, ਝ੍ => 1, ਞ੍=> 1,  ਟ੍=> 1,  ਠ੍ => 1, ਡ੍ => 1,
                           ਢ੍ => 1, ਣ੍ => 1, ਤ੍ => 1, ਥ੍ => 1, ਦ੍ => 1, ਧ੍ => 1, ਨ੍ => 1, ਪ੍ => 1, ਫ੍ => 1, ਬ੍ => 1, ਭ੍ => 1, ਮ੍ => 1, ਯ੍ => 1,
                           ਰ੍ => 1, ਲ੍=> 1,  ਵ੍ => 1, ਸ਼੍ => 1, ਸ਼੍ => 1, ਸ੍ => 1, ਹ੍ => 1, ਲ਼੍ => 1, କ୍ => 1, ଖ୍=> 1, ଗ୍ => 1, ଘ୍=> 1,  ଙ୍=> 1, ଚ୍=> 1,
                           ଛ୍ => 1, ଜ୍ => 1, ଝ୍ => 1, ଞ୍ => 1, ଟ୍ => 1, ଠ୍ => 1, ଡ୍ => 1, ଢ୍ => 1, ଣ୍ => 1, ତ୍=> 1,  ଥ୍ => 1, ଦ୍ => 1, ଧ୍ => 1,
                           ନ୍ => 1, ପ୍=> 1, ଫ୍ => 1, ବ୍=> 1,  ଭ୍ => 1, ମ୍ => 1, ଯ୍ => 1, ର୍ => 1, ଲ୍ => 1, ଵ୍ => 1, ଶ୍=> 1,  ଷ୍ => 1, ସ୍ => 1,
                           ହ୍ => 1, ଳ୍  => 1, ക്=> 1,  ഖ്=> 1, ഗ്=> 1 ,ഘ്=> 1, ങ്=> 1, ച് => 1, ഛ് => 1, ജ്=> 1,  ഝ് => 1, ഞ് => 1, ട്=> 1,
                           ഠ് => 1, ഡ് => 1,  ഢ്=> 1, ണ്=> 1, ത് => 1, ഥ് => 1, ദ് => 1, ധ് => 1, ന് => 1, പ് => 1, ഫ് => 1, ബ് => 1, ഭ് => 1,
                           മ് => 1, യ് => 1, ര്=> 1, റ് => 1, ല് => 1, വ് => 1, ശ് => 1, ഷ്=> 1, സ്=> 1, ഹ് => 1, ള് => 1,
                           க் => 1, ங் => 1,  ச் => 1,  ஜ் => 1,   ஞ் => 1,  ட் => 1, ண் => 1,  த் => 1,  ந் => 1, ன் => 1, ப் => 1,
                           ம் => 1,  ய் => 1,  ர் => 1, ற் => 1, ல் => 1, ழ் => 1, வ் => 1,  ஶ் => 1,  ஷ் => 1,  ஸ் => 1,  ஹ் => 1,  ள் => 1,
                         };
                 }
);





# Returns an array,
# Splits on Tailored Grapheme Clusters.
# To learn more about tgc's goto http://unicode.org/reports/tr29/

method TGC(:$string) {
  my @res;                                          # Stores result
  my @ires;                                         # Stores intermediate resuts
  my @split_chars = split(/\b{gcb}/, $string);      # Split input on grapheme cluster boundaries
  my $sc = $#split_chars;                           # Size of split_chars array
  my $c = 0;                                        # Counter
  LABE:
      while (($c <= $sc) && !($self->ar->{$split_chars[$c]})) {
        push @res, $split_chars[$c];
        if($c >= $sc) {
          return @res;
        }
        $c++;
      }
      while (($c <= $sc) && $self->ar->{$split_chars[$c]}) {
        push @ires, $split_chars[$c];
        if($c >= $sc) {
          return @res;
        }
        $c++;
      }
      if ($c <= $sc ) {
        push @res, join("",@ires) . $split_chars[$c] ;
      }
      else {
        push @res, join("",@ires);
      }
      if($c >= $sc) {
        return @res;
      }
      if($split_chars[$c] ne " ") {
        $c++;
      }
      @ires = ();
      goto LABE;
}

1;
