package Paws::AlexaForBusiness::SkillGroupData;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has SkillGroupArn => (is => 'ro', isa => 'Str');
  has SkillGroupName => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::AlexaForBusiness::SkillGroupData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AlexaForBusiness::SkillGroupData object:

  $service_obj->Method(Att1 => { Description => $value, ..., SkillGroupName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AlexaForBusiness::SkillGroupData object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

The attributes of a skill group.

=head1 ATTRIBUTES


=head2 Description => Str

  The description of a skill group.


=head2 SkillGroupArn => Str

  The skill group ARN of a skill group.


=head2 SkillGroupName => Str

  The skill group name of a skill group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AlexaForBusiness>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

