package Google::Ads::AdWords::v201603::TemporaryUrl;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201603' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %url_of :ATTR(:get<url>);
my %expiration_of :ATTR(:get<expiration>);

__PACKAGE__->_factory(
    [ qw(        url
        expiration

    ) ],
    {
        'url' => \%url_of,
        'expiration' => \%expiration_of,
    },
    {
        'url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'expiration' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'url' => 'url',
        'expiration' => 'expiration',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201603::TemporaryUrl

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TemporaryUrl from the namespace https://adwords.google.com/api/adwords/cm/v201603.

A URL that expires at a particular time. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * url


=item * expiration




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

