package Google::Ads::AdWords::v201109::BudgetOptimizerAdGroupBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109::AdGroupBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AdGroupBids__Type_of :ATTR(:get<AdGroupBids__Type>);
my %proxyKeywordMaxCpc_of :ATTR(:get<proxyKeywordMaxCpc>);
my %proxySiteMaxCpc_of :ATTR(:get<proxySiteMaxCpc>);
my %enhancedCpcEnabled_of :ATTR(:get<enhancedCpcEnabled>);

__PACKAGE__->_factory(
    [ qw(        AdGroupBids__Type
        proxyKeywordMaxCpc
        proxySiteMaxCpc
        enhancedCpcEnabled

    ) ],
    {
        'AdGroupBids__Type' => \%AdGroupBids__Type_of,
        'proxyKeywordMaxCpc' => \%proxyKeywordMaxCpc_of,
        'proxySiteMaxCpc' => \%proxySiteMaxCpc_of,
        'enhancedCpcEnabled' => \%enhancedCpcEnabled_of,
    },
    {
        'AdGroupBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'proxyKeywordMaxCpc' => 'Google::Ads::AdWords::v201109::Bid',
        'proxySiteMaxCpc' => 'Google::Ads::AdWords::v201109::Bid',
        'enhancedCpcEnabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'AdGroupBids__Type' => 'AdGroupBids.Type',
        'proxyKeywordMaxCpc' => 'proxyKeywordMaxCpc',
        'proxySiteMaxCpc' => 'proxySiteMaxCpc',
        'enhancedCpcEnabled' => 'enhancedCpcEnabled',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::BudgetOptimizerAdGroupBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BudgetOptimizerAdGroupBids from the namespace https://adwords.google.com/api/adwords/cm/v201109.

Adgroup level bids used in budget optimizer bidding strategy. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * proxyKeywordMaxCpc


=item * proxySiteMaxCpc


=item * enhancedCpcEnabled




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::BudgetOptimizerAdGroupBids
   proxyKeywordMaxCpc =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Bid
   proxySiteMaxCpc =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Bid
   enhancedCpcEnabled =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

